/**
 * @file Bts2App_Phonebook.cpp
 *
 * @par SW-Component
 * Messages
 *
 * @brief BtStackIf to Application messages for function block BTS_FB_PHONEBOOK.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of messages for function block BTS_FB_PHONEBOOK.
 */

#include "Bts2App_Phonebook.h"
#include "BtStackIfCallback.h"
#include "IBtStackIfPhonebookCallback.h"
#include "FwAssert.h"

namespace btstackif {

Bts2App_FbPhonebookInitialized::Bts2App_FbPhonebookInitialized()
: Bts2App_BaseMessage(BTS_FB_PHONEBOOK, Bts2AppOC_FbPhonebookInitialized)
{
   _result = BTS_REQ_LAST;
}

Bts2App_FbPhonebookInitialized::Bts2App_FbPhonebookInitialized(IN const Bts2App_FbPhonebookInitialized& ref)
: Bts2App_BaseMessage(ref)
{
   _result = ref._result;
}

Bts2App_FbPhonebookInitialized& Bts2App_FbPhonebookInitialized::operator=(IN const Bts2App_FbPhonebookInitialized& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _result = ref._result;

   return *this;
}

Bts2App_FbPhonebookInitialized::~Bts2App_FbPhonebookInitialized()
{
}

void Bts2App_FbPhonebookInitialized::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getPhonebookCallback())
   {
      callback.getPhonebookCallback()->fbPhonebookInitializedCB(_result);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_FbPhonebookInitialized::clone(void) const
{
   return new Bts2App_FbPhonebookInitialized(*this);
}

Bts2App_SetPhonebookDummyResult::Bts2App_SetPhonebookDummyResult()
: Bts2App_BaseMessage(BTS_FB_PHONEBOOK, Bts2AppOC_SetPhonebookDummyResult)
{
   _result = BTS_REQ_LAST;
}

Bts2App_SetPhonebookDummyResult::Bts2App_SetPhonebookDummyResult(IN const Bts2App_SetPhonebookDummyResult& ref)
: Bts2App_BaseMessage(ref)
{
   _result = ref._result;
}

Bts2App_SetPhonebookDummyResult& Bts2App_SetPhonebookDummyResult::operator=(IN const Bts2App_SetPhonebookDummyResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _result = ref._result;

   return *this;
}

Bts2App_SetPhonebookDummyResult::~Bts2App_SetPhonebookDummyResult()
{
}

void Bts2App_SetPhonebookDummyResult::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getPhonebookCallback())
   {
      callback.getPhonebookCallback()->setPhonebookDummyResultCB(_result);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_SetPhonebookDummyResult::clone(void) const
{
   return new Bts2App_SetPhonebookDummyResult(*this);
}

} //btstackif
