/**
 * @file Bts2App_MediaPlayer.cpp
 *
 * @par SW-Component
 * Messages
 *
 * @brief BtStackIf to Application messages for function block BTS_FB_MEDIAPLAYER.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of messages for function block BTS_FB_MEDIAPLAYER.
 */

#include "Bts2App_MediaPlayer.h"
#include "BtStackIfCallback.h"
#include "IBtStackIfMediaPlayerCallback.h"
#include "FwAssert.h"

namespace btstackif {

Bts2App_FbMediaPlayerInitialized::Bts2App_FbMediaPlayerInitialized()
: Bts2App_BaseMessage(BTS_FB_MEDIAPLAYER, Bts2AppOC_FbMediaPlayerInitialized)
{
   _result = BTS_REQ_LAST;
}

Bts2App_FbMediaPlayerInitialized::Bts2App_FbMediaPlayerInitialized(IN const Bts2App_FbMediaPlayerInitialized& ref)
: Bts2App_BaseMessage(ref)
{
   _result = ref._result;
}

Bts2App_FbMediaPlayerInitialized& Bts2App_FbMediaPlayerInitialized::operator=(IN const Bts2App_FbMediaPlayerInitialized& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _result = ref._result;

   return *this;
}

Bts2App_FbMediaPlayerInitialized::~Bts2App_FbMediaPlayerInitialized()
{
}

void Bts2App_FbMediaPlayerInitialized::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getMediaPlayerCallback())
   {
      callback.getMediaPlayerCallback()->fbMediaPlayerInitializedCB(_result);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_FbMediaPlayerInitialized::clone(void) const
{
   return new Bts2App_FbMediaPlayerInitialized(*this);
}

Bts2App_SetMediaPlayerDummyResult::Bts2App_SetMediaPlayerDummyResult()
: Bts2App_BaseMessage(BTS_FB_MEDIAPLAYER, Bts2AppOC_SetMediaPlayerDummyResult)
{
   _result = BTS_REQ_LAST;
}

Bts2App_SetMediaPlayerDummyResult::Bts2App_SetMediaPlayerDummyResult(IN const Bts2App_SetMediaPlayerDummyResult& ref)
: Bts2App_BaseMessage(ref)
{
   _result = ref._result;
}

Bts2App_SetMediaPlayerDummyResult& Bts2App_SetMediaPlayerDummyResult::operator=(IN const Bts2App_SetMediaPlayerDummyResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _result = ref._result;

   return *this;
}

Bts2App_SetMediaPlayerDummyResult::~Bts2App_SetMediaPlayerDummyResult()
{
}

void Bts2App_SetMediaPlayerDummyResult::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getMediaPlayerCallback())
   {
      callback.getMediaPlayerCallback()->setMediaPlayerDummyResultCB(_result);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_SetMediaPlayerDummyResult::clone(void) const
{
   return new Bts2App_SetMediaPlayerDummyResult(*this);
}

} //btstackif
