/**
 * @file Bts2App_Connection.cpp
 *
 * @par SW-Component
 * Messages
 *
 * @brief BtStackIf to Application messages for function block BTS_FB_CONNECTION.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of messages for function block BTS_FB_CONNECTION.
 */

#include "Bts2App_Connection.h"
#include "BtStackIfCallback.h"
#include "IBtStackIfConnectionCallback.h"
#include "FwAssert.h"

namespace btstackif {

Bts2App_FbConnectionInitialized::Bts2App_FbConnectionInitialized()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_FbConnectionInitialized)
{
   _result = BTS_REQ_LAST;
}

Bts2App_FbConnectionInitialized::Bts2App_FbConnectionInitialized(IN const Bts2App_FbConnectionInitialized& ref)
: Bts2App_BaseMessage(ref)
{
   _result = ref._result;
}

Bts2App_FbConnectionInitialized& Bts2App_FbConnectionInitialized::operator=(IN const Bts2App_FbConnectionInitialized& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _result = ref._result;

   return *this;
}

Bts2App_FbConnectionInitialized::~Bts2App_FbConnectionInitialized()
{
}

void Bts2App_FbConnectionInitialized::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->fbConnectionInitializedCB(_result);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_FbConnectionInitialized::clone(void) const
{
   return new Bts2App_FbConnectionInitialized(*this);
}

Bts2App_LocalVersionInfo::Bts2App_LocalVersionInfo()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_LocalVersionInfo)
{
   // _versionInfo: init is done by member constructor
}

Bts2App_LocalVersionInfo::Bts2App_LocalVersionInfo(IN const Bts2App_LocalVersionInfo& ref)
: Bts2App_BaseMessage(ref)
{
   _versionInfo = ref._versionInfo;
}

Bts2App_LocalVersionInfo& Bts2App_LocalVersionInfo::operator=(IN const Bts2App_LocalVersionInfo& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _versionInfo = ref._versionInfo;

   return *this;
}

Bts2App_LocalVersionInfo::~Bts2App_LocalVersionInfo()
{
}

void Bts2App_LocalVersionInfo::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->localVersionInfoCB(_versionInfo);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_LocalVersionInfo::clone(void) const
{
   return new Bts2App_LocalVersionInfo(*this);
}

Bts2App_SwitchBluetoothOnOffResult::Bts2App_SwitchBluetoothOnOffResult()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_SwitchBluetoothOnOffResult)
{
   _result = BTS_REQ_LAST;
}

Bts2App_SwitchBluetoothOnOffResult::Bts2App_SwitchBluetoothOnOffResult(IN const Bts2App_SwitchBluetoothOnOffResult& ref)
: Bts2App_BaseMessage(ref)
{
   _result = ref._result;
}

Bts2App_SwitchBluetoothOnOffResult& Bts2App_SwitchBluetoothOnOffResult::operator=(IN const Bts2App_SwitchBluetoothOnOffResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _result = ref._result;

   return *this;
}

Bts2App_SwitchBluetoothOnOffResult::~Bts2App_SwitchBluetoothOnOffResult()
{
}

void Bts2App_SwitchBluetoothOnOffResult::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->switchBluetoothOnOffResultCB(_result);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_SwitchBluetoothOnOffResult::clone(void) const
{
   return new Bts2App_SwitchBluetoothOnOffResult(*this);
}

Bts2App_CurrentBluetoothOnOffStatus::Bts2App_CurrentBluetoothOnOffStatus()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_CurrentBluetoothOnOffStatus)
{
   _bluetoothMode = BTS_BT_MODE_LAST;
   _offReason = BTS_BT_OFF_REASON_LAST;
   _adapterMode = BTS_ADAPTER_MODE_LAST;
}

Bts2App_CurrentBluetoothOnOffStatus::Bts2App_CurrentBluetoothOnOffStatus(IN const Bts2App_CurrentBluetoothOnOffStatus& ref)
: Bts2App_BaseMessage(ref)
{
   _bluetoothMode = ref._bluetoothMode;
   _offReason = ref._offReason;
   _adapterMode = ref._adapterMode;
}

Bts2App_CurrentBluetoothOnOffStatus& Bts2App_CurrentBluetoothOnOffStatus::operator=(IN const Bts2App_CurrentBluetoothOnOffStatus& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _bluetoothMode = ref._bluetoothMode;
   _offReason = ref._offReason;
   _adapterMode = ref._adapterMode;

   return *this;
}

Bts2App_CurrentBluetoothOnOffStatus::~Bts2App_CurrentBluetoothOnOffStatus()
{
}

void Bts2App_CurrentBluetoothOnOffStatus::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->currentBluetoothOnOffStatusCB(_bluetoothMode, _offReason, _adapterMode, _deviceAddress);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_CurrentBluetoothOnOffStatus::clone(void) const
{
   return new Bts2App_CurrentBluetoothOnOffStatus(*this);
}

Bts2App_SwitchBluetoothHardwareOnOffResult::Bts2App_SwitchBluetoothHardwareOnOffResult()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_SwitchBluetoothHardwareOnOffResult)
{
   _result = BTS_REQ_LAST;
}

Bts2App_SwitchBluetoothHardwareOnOffResult::Bts2App_SwitchBluetoothHardwareOnOffResult(IN const Bts2App_SwitchBluetoothHardwareOnOffResult& ref)
: Bts2App_BaseMessage(ref)
{
   _result = ref._result;
}

Bts2App_SwitchBluetoothHardwareOnOffResult& Bts2App_SwitchBluetoothHardwareOnOffResult::operator=(IN const Bts2App_SwitchBluetoothHardwareOnOffResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _result = ref._result;

   return *this;
}

Bts2App_SwitchBluetoothHardwareOnOffResult::~Bts2App_SwitchBluetoothHardwareOnOffResult()
{
}

void Bts2App_SwitchBluetoothHardwareOnOffResult::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->switchBluetoothHardwareOnOffResultCB(_result);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_SwitchBluetoothHardwareOnOffResult::clone(void) const
{
   return new Bts2App_SwitchBluetoothHardwareOnOffResult(*this);
}

Bts2App_SetLocalBtNameResult::Bts2App_SetLocalBtNameResult()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_SetLocalBtNameResult)
{
   _result = BTS_REQ_LAST;
}

Bts2App_SetLocalBtNameResult::Bts2App_SetLocalBtNameResult(IN const Bts2App_SetLocalBtNameResult& ref)
: Bts2App_BaseMessage(ref)
{
   _result = ref._result;
}

Bts2App_SetLocalBtNameResult& Bts2App_SetLocalBtNameResult::operator=(IN const Bts2App_SetLocalBtNameResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _result = ref._result;

   return *this;
}

Bts2App_SetLocalBtNameResult::~Bts2App_SetLocalBtNameResult()
{
}

void Bts2App_SetLocalBtNameResult::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->setLocalBtNameResultCB(_result);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_SetLocalBtNameResult::clone(void) const
{
   return new Bts2App_SetLocalBtNameResult(*this);
}

Bts2App_CurrentLocalBtName::Bts2App_CurrentLocalBtName()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_CurrentLocalBtName)
{
   // _adapterName: init is done by member constructor
}

Bts2App_CurrentLocalBtName::Bts2App_CurrentLocalBtName(IN const Bts2App_CurrentLocalBtName& ref)
: Bts2App_BaseMessage(ref)
{
   _adapterName = ref._adapterName;
}

Bts2App_CurrentLocalBtName& Bts2App_CurrentLocalBtName::operator=(IN const Bts2App_CurrentLocalBtName& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _adapterName = ref._adapterName;

   return *this;
}

Bts2App_CurrentLocalBtName::~Bts2App_CurrentLocalBtName()
{
}

void Bts2App_CurrentLocalBtName::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->currentLocalBtNameCB(_adapterName);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_CurrentLocalBtName::clone(void) const
{
   return new Bts2App_CurrentLocalBtName(*this);
}

Bts2App_CurrentDeviceForRestrictedPairingConnecting::Bts2App_CurrentDeviceForRestrictedPairingConnecting()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_CurrentDeviceForRestrictedPairingConnecting)
{
}

Bts2App_CurrentDeviceForRestrictedPairingConnecting::Bts2App_CurrentDeviceForRestrictedPairingConnecting(IN const Bts2App_CurrentDeviceForRestrictedPairingConnecting& ref)
: Bts2App_BaseMessage(ref)
{
}

Bts2App_CurrentDeviceForRestrictedPairingConnecting& Bts2App_CurrentDeviceForRestrictedPairingConnecting::operator=(IN const Bts2App_CurrentDeviceForRestrictedPairingConnecting& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   return *this;
}

Bts2App_CurrentDeviceForRestrictedPairingConnecting::~Bts2App_CurrentDeviceForRestrictedPairingConnecting()
{
}

void Bts2App_CurrentDeviceForRestrictedPairingConnecting::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->currentDeviceForRestrictedPairingConnectingCB(_deviceAddress, _sessionHandle);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_CurrentDeviceForRestrictedPairingConnecting::clone(void) const
{
   return new Bts2App_CurrentDeviceForRestrictedPairingConnecting(*this);
}

Bts2App_SetLocalAdapterModesResult::Bts2App_SetLocalAdapterModesResult()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_SetLocalAdapterModesResult)
{
   _result = BTS_REQ_LAST;
}

Bts2App_SetLocalAdapterModesResult::Bts2App_SetLocalAdapterModesResult(IN const Bts2App_SetLocalAdapterModesResult& ref)
: Bts2App_BaseMessage(ref)
{
   _result = ref._result;
}

Bts2App_SetLocalAdapterModesResult& Bts2App_SetLocalAdapterModesResult::operator=(IN const Bts2App_SetLocalAdapterModesResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _result = ref._result;

   return *this;
}

Bts2App_SetLocalAdapterModesResult::~Bts2App_SetLocalAdapterModesResult()
{
}

void Bts2App_SetLocalAdapterModesResult::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->setLocalAdapterModesResultCB(_result, _sessionHandle);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_SetLocalAdapterModesResult::clone(void) const
{
   return new Bts2App_SetLocalAdapterModesResult(*this);
}

Bts2App_CurrentDiscoverableMode::Bts2App_CurrentDiscoverableMode()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_CurrentDiscoverableMode)
{
   _discoverableMode = BTS_MODE_LAST;
   _offReason = BTS_MODE_OFF_REASON_LAST;
}

Bts2App_CurrentDiscoverableMode::Bts2App_CurrentDiscoverableMode(IN const Bts2App_CurrentDiscoverableMode& ref)
: Bts2App_BaseMessage(ref)
{
   _discoverableMode = ref._discoverableMode;
   _offReason = ref._offReason;
}

Bts2App_CurrentDiscoverableMode& Bts2App_CurrentDiscoverableMode::operator=(IN const Bts2App_CurrentDiscoverableMode& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _discoverableMode = ref._discoverableMode;
   _offReason = ref._offReason;

   return *this;
}

Bts2App_CurrentDiscoverableMode::~Bts2App_CurrentDiscoverableMode()
{
}

void Bts2App_CurrentDiscoverableMode::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->currentDiscoverableModeCB(_discoverableMode, _offReason, _sessionHandle);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_CurrentDiscoverableMode::clone(void) const
{
   return new Bts2App_CurrentDiscoverableMode(*this);
}

Bts2App_CurrentConnectableMode::Bts2App_CurrentConnectableMode()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_CurrentConnectableMode)
{
   _connectableMode = BTS_MODE_LAST;
   _offReason = BTS_MODE_OFF_REASON_LAST;
}

Bts2App_CurrentConnectableMode::Bts2App_CurrentConnectableMode(IN const Bts2App_CurrentConnectableMode& ref)
: Bts2App_BaseMessage(ref)
{
   _connectableMode = ref._connectableMode;
   _offReason = ref._offReason;
}

Bts2App_CurrentConnectableMode& Bts2App_CurrentConnectableMode::operator=(IN const Bts2App_CurrentConnectableMode& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _connectableMode = ref._connectableMode;
   _offReason = ref._offReason;

   return *this;
}

Bts2App_CurrentConnectableMode::~Bts2App_CurrentConnectableMode()
{
}

void Bts2App_CurrentConnectableMode::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->currentConnectableModeCB(_connectableMode, _offReason, _sessionHandle);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_CurrentConnectableMode::clone(void) const
{
   return new Bts2App_CurrentConnectableMode(*this);
}

Bts2App_StartDiscoveryResult::Bts2App_StartDiscoveryResult()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_StartDiscoveryResult)
{
   _result = BTS_REQ_LAST;
}

Bts2App_StartDiscoveryResult::Bts2App_StartDiscoveryResult(IN const Bts2App_StartDiscoveryResult& ref)
: Bts2App_BaseMessage(ref)
{
   _result = ref._result;
}

Bts2App_StartDiscoveryResult& Bts2App_StartDiscoveryResult::operator=(IN const Bts2App_StartDiscoveryResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _result = ref._result;

   return *this;
}

Bts2App_StartDiscoveryResult::~Bts2App_StartDiscoveryResult()
{
}

void Bts2App_StartDiscoveryResult::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->startDiscoveryResultCB(_result, _sessionHandle);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_StartDiscoveryResult::clone(void) const
{
   return new Bts2App_StartDiscoveryResult(*this);
}

Bts2App_StopDiscoveryResult::Bts2App_StopDiscoveryResult()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_StopDiscoveryResult)
{
   _result = BTS_REQ_LAST;
}

Bts2App_StopDiscoveryResult::Bts2App_StopDiscoveryResult(IN const Bts2App_StopDiscoveryResult& ref)
: Bts2App_BaseMessage(ref)
{
   _result = ref._result;
}

Bts2App_StopDiscoveryResult& Bts2App_StopDiscoveryResult::operator=(IN const Bts2App_StopDiscoveryResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _result = ref._result;

   return *this;
}

Bts2App_StopDiscoveryResult::~Bts2App_StopDiscoveryResult()
{
}

void Bts2App_StopDiscoveryResult::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->stopDiscoveryResultCB(_result, _sessionHandle);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_StopDiscoveryResult::clone(void) const
{
   return new Bts2App_StopDiscoveryResult(*this);
}

Bts2App_DiscoveringStatus::Bts2App_DiscoveringStatus()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_DiscoveringStatus)
{
   _discoveringStatus = BTS_DISCOVERING_LAST;
}

Bts2App_DiscoveringStatus::Bts2App_DiscoveringStatus(IN const Bts2App_DiscoveringStatus& ref)
: Bts2App_BaseMessage(ref)
{
   _discoveringStatus = ref._discoveringStatus;
}

Bts2App_DiscoveringStatus& Bts2App_DiscoveringStatus::operator=(IN const Bts2App_DiscoveringStatus& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _discoveringStatus = ref._discoveringStatus;

   return *this;
}

Bts2App_DiscoveringStatus::~Bts2App_DiscoveringStatus()
{
}

void Bts2App_DiscoveringStatus::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->discoveringStatusCB(_discoveringStatus, _sessionHandle);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_DiscoveringStatus::clone(void) const
{
   return new Bts2App_DiscoveringStatus(*this);
}

Bts2App_DiscoveredDeviceFound::Bts2App_DiscoveredDeviceFound()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_DiscoveredDeviceFound)
{
   // _discoveredDevice: init is done by member constructor
}

Bts2App_DiscoveredDeviceFound::Bts2App_DiscoveredDeviceFound(IN const Bts2App_DiscoveredDeviceFound& ref)
: Bts2App_BaseMessage(ref)
{
   _discoveredDevice = ref._discoveredDevice;
}

Bts2App_DiscoveredDeviceFound& Bts2App_DiscoveredDeviceFound::operator=(IN const Bts2App_DiscoveredDeviceFound& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _discoveredDevice = ref._discoveredDevice;

   return *this;
}

Bts2App_DiscoveredDeviceFound::~Bts2App_DiscoveredDeviceFound()
{
}

void Bts2App_DiscoveredDeviceFound::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->discoveredDeviceFoundCB(_discoveredDevice, _sessionHandle);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_DiscoveredDeviceFound::clone(void) const
{
   return new Bts2App_DiscoveredDeviceFound(*this);
}

Bts2App_StartPairingResult::Bts2App_StartPairingResult()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_StartPairingResult)
{
   _result = BTS_REQ_LAST;
}

Bts2App_StartPairingResult::Bts2App_StartPairingResult(IN const Bts2App_StartPairingResult& ref)
: Bts2App_BaseMessage(ref)
{
   _result = ref._result;
}

Bts2App_StartPairingResult& Bts2App_StartPairingResult::operator=(IN const Bts2App_StartPairingResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _result = ref._result;

   return *this;
}

Bts2App_StartPairingResult::~Bts2App_StartPairingResult()
{
}

void Bts2App_StartPairingResult::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->startPairingResultCB(_deviceAddress, _result, _sessionHandle);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_StartPairingResult::clone(void) const
{
   return new Bts2App_StartPairingResult(*this);
}

Bts2App_PinCodeRequested::Bts2App_PinCodeRequested()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_PinCodeRequested)
{
   // _deviceName: init is done by member constructor
   _pairingOriginator = BTS_PAIR_CONNECT_INITIATED_LAST;
}

Bts2App_PinCodeRequested::Bts2App_PinCodeRequested(IN const Bts2App_PinCodeRequested& ref)
: Bts2App_BaseMessage(ref)
{
   _deviceName = ref._deviceName;
   _pairingOriginator = ref._pairingOriginator;
}

Bts2App_PinCodeRequested& Bts2App_PinCodeRequested::operator=(IN const Bts2App_PinCodeRequested& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _deviceName = ref._deviceName;
   _pairingOriginator = ref._pairingOriginator;

   return *this;
}

Bts2App_PinCodeRequested::~Bts2App_PinCodeRequested()
{
}

void Bts2App_PinCodeRequested::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->pinCodeRequestedCB(_deviceAddress, _deviceName, _pairingOriginator, _sessionHandle);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_PinCodeRequested::clone(void) const
{
   return new Bts2App_PinCodeRequested(*this);
}

Bts2App_SecureSimplePairingRequested::Bts2App_SecureSimplePairingRequested()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_SecureSimplePairingRequested)
{
   // _deviceName: init is done by member constructor
   _sspMode = BTS_SSP_LAST;
   // _numericValue: init is done by member constructor
   _pairingOriginator = BTS_PAIR_CONNECT_INITIATED_LAST;
}

Bts2App_SecureSimplePairingRequested::Bts2App_SecureSimplePairingRequested(IN const Bts2App_SecureSimplePairingRequested& ref)
: Bts2App_BaseMessage(ref)
{
   _deviceName = ref._deviceName;
   _sspMode = ref._sspMode;
   _numericValue = ref._numericValue;
   _pairingOriginator = ref._pairingOriginator;
}

Bts2App_SecureSimplePairingRequested& Bts2App_SecureSimplePairingRequested::operator=(IN const Bts2App_SecureSimplePairingRequested& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _deviceName = ref._deviceName;
   _sspMode = ref._sspMode;
   _numericValue = ref._numericValue;
   _pairingOriginator = ref._pairingOriginator;

   return *this;
}

Bts2App_SecureSimplePairingRequested::~Bts2App_SecureSimplePairingRequested()
{
}

void Bts2App_SecureSimplePairingRequested::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->secureSimplePairingRequestedCB(_deviceAddress, _deviceName, _sspMode, _numericValue, _pairingOriginator, _sessionHandle);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_SecureSimplePairingRequested::clone(void) const
{
   return new Bts2App_SecureSimplePairingRequested(*this);
}

Bts2App_PairingFinished::Bts2App_PairingFinished()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_PairingFinished)
{
   _result = BTS_REQ_LAST;
   _linkKeyType = BTS_LINK_KEY_TYPE_LAST;
   // _linkKey: init is done by member constructor
   // _dLinkKey: init is done by member constructor
   // _majorServiceClass: init is done by member constructor
   _majorDeviceClass = BTS_COD_MAJORDC_LAST;
   _minorDeviceClass = BTS_COD_MINORDC_LAST;
   // _deviceName: init is done by member constructor
}

Bts2App_PairingFinished::Bts2App_PairingFinished(IN const Bts2App_PairingFinished& ref)
: Bts2App_BaseMessage(ref)
{
   _result = ref._result;
   _linkKeyType = ref._linkKeyType;
   _linkKey = ref._linkKey;
   _dLinkKey = ref._dLinkKey;
   _majorServiceClass = ref._majorServiceClass;
   _majorDeviceClass = ref._majorDeviceClass;
   _minorDeviceClass = ref._minorDeviceClass;
   _deviceName = ref._deviceName;
}

Bts2App_PairingFinished& Bts2App_PairingFinished::operator=(IN const Bts2App_PairingFinished& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _result = ref._result;
   _linkKeyType = ref._linkKeyType;
   _linkKey = ref._linkKey;
   _dLinkKey = ref._dLinkKey;
   _majorServiceClass = ref._majorServiceClass;
   _majorDeviceClass = ref._majorDeviceClass;
   _minorDeviceClass = ref._minorDeviceClass;
   _deviceName = ref._deviceName;

   return *this;
}

Bts2App_PairingFinished::~Bts2App_PairingFinished()
{
}

void Bts2App_PairingFinished::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->pairingFinishedCB(_deviceAddress, _result, _linkKeyType, _linkKey, _dLinkKey, _majorServiceClass, _majorDeviceClass, _minorDeviceClass, _deviceName, _sessionHandle);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_PairingFinished::clone(void) const
{
   return new Bts2App_PairingFinished(*this);
}

Bts2App_LinkKeyRequested::Bts2App_LinkKeyRequested()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_LinkKeyRequested)
{
}

Bts2App_LinkKeyRequested::Bts2App_LinkKeyRequested(IN const Bts2App_LinkKeyRequested& ref)
: Bts2App_BaseMessage(ref)
{
}

Bts2App_LinkKeyRequested& Bts2App_LinkKeyRequested::operator=(IN const Bts2App_LinkKeyRequested& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   return *this;
}

Bts2App_LinkKeyRequested::~Bts2App_LinkKeyRequested()
{
}

void Bts2App_LinkKeyRequested::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->linkKeyRequestedCB(_deviceAddress, _sessionHandle);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_LinkKeyRequested::clone(void) const
{
   return new Bts2App_LinkKeyRequested(*this);
}

Bts2App_ConnectProtocolResult::Bts2App_ConnectProtocolResult()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_ConnectProtocolResult)
{
   _result = BTS_REQ_LAST;
   _protocolId = BTS_PROTO_LAST;
   // _sppUuid: init is done by member constructor
   // _masInstance: init is done by member constructor
}

Bts2App_ConnectProtocolResult::Bts2App_ConnectProtocolResult(IN const Bts2App_ConnectProtocolResult& ref)
: Bts2App_BaseMessage(ref)
{
   _result = ref._result;
   _protocolId = ref._protocolId;
   _sppUuid = ref._sppUuid;
   _masInstance = ref._masInstance;
}

Bts2App_ConnectProtocolResult& Bts2App_ConnectProtocolResult::operator=(IN const Bts2App_ConnectProtocolResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _result = ref._result;
   _protocolId = ref._protocolId;
   _sppUuid = ref._sppUuid;
   _masInstance = ref._masInstance;

   return *this;
}

Bts2App_ConnectProtocolResult::~Bts2App_ConnectProtocolResult()
{
}

void Bts2App_ConnectProtocolResult::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->connectProtocolResultCB(_deviceAddress, _result, _protocolId, _sppUuid, _masInstance, _sessionHandle);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_ConnectProtocolResult::clone(void) const
{
   return new Bts2App_ConnectProtocolResult(*this);
}

Bts2App_RemoteProtocolConnectRequest::Bts2App_RemoteProtocolConnectRequest()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_RemoteProtocolConnectRequest)
{
   _protocolId = BTS_PROTO_LAST;
   // _sppUuid: init is done by member constructor
}

Bts2App_RemoteProtocolConnectRequest::Bts2App_RemoteProtocolConnectRequest(IN const Bts2App_RemoteProtocolConnectRequest& ref)
: Bts2App_BaseMessage(ref)
{
   _protocolId = ref._protocolId;
   _sppUuid = ref._sppUuid;
}

Bts2App_RemoteProtocolConnectRequest& Bts2App_RemoteProtocolConnectRequest::operator=(IN const Bts2App_RemoteProtocolConnectRequest& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _protocolId = ref._protocolId;
   _sppUuid = ref._sppUuid;

   return *this;
}

Bts2App_RemoteProtocolConnectRequest::~Bts2App_RemoteProtocolConnectRequest()
{
}

void Bts2App_RemoteProtocolConnectRequest::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->remoteProtocolConnectRequestCB(_deviceAddress, _protocolId, _sppUuid, _sessionHandle);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_RemoteProtocolConnectRequest::clone(void) const
{
   return new Bts2App_RemoteProtocolConnectRequest(*this);
}

Bts2App_DisconnectProtocolResult::Bts2App_DisconnectProtocolResult()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_DisconnectProtocolResult)
{
   _result = BTS_REQ_LAST;
   _protocolId = BTS_PROTO_LAST;
   // _sppUuid: init is done by member constructor
   // _masInstance: init is done by member constructor
}

Bts2App_DisconnectProtocolResult::Bts2App_DisconnectProtocolResult(IN const Bts2App_DisconnectProtocolResult& ref)
: Bts2App_BaseMessage(ref)
{
   _result = ref._result;
   _protocolId = ref._protocolId;
   _sppUuid = ref._sppUuid;
   _masInstance = ref._masInstance;
}

Bts2App_DisconnectProtocolResult& Bts2App_DisconnectProtocolResult::operator=(IN const Bts2App_DisconnectProtocolResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _result = ref._result;
   _protocolId = ref._protocolId;
   _sppUuid = ref._sppUuid;
   _masInstance = ref._masInstance;

   return *this;
}

Bts2App_DisconnectProtocolResult::~Bts2App_DisconnectProtocolResult()
{
}

void Bts2App_DisconnectProtocolResult::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->disconnectProtocolResultCB(_deviceAddress, _result, _protocolId, _sppUuid, _masInstance, _sessionHandle);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_DisconnectProtocolResult::clone(void) const
{
   return new Bts2App_DisconnectProtocolResult(*this);
}

Bts2App_DisconnectDeviceResult::Bts2App_DisconnectDeviceResult()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_DisconnectDeviceResult)
{
   _result = BTS_REQ_LAST;
}

Bts2App_DisconnectDeviceResult::Bts2App_DisconnectDeviceResult(IN const Bts2App_DisconnectDeviceResult& ref)
: Bts2App_BaseMessage(ref)
{
   _result = ref._result;
}

Bts2App_DisconnectDeviceResult& Bts2App_DisconnectDeviceResult::operator=(IN const Bts2App_DisconnectDeviceResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _result = ref._result;

   return *this;
}

Bts2App_DisconnectDeviceResult::~Bts2App_DisconnectDeviceResult()
{
}

void Bts2App_DisconnectDeviceResult::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->disconnectDeviceResultCB(_deviceAddress, _result, _sessionHandle);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_DisconnectDeviceResult::clone(void) const
{
   return new Bts2App_DisconnectDeviceResult(*this);
}

Bts2App_ProtocolConnectionStatus::Bts2App_ProtocolConnectionStatus()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_ProtocolConnectionStatus)
{
   _connectionStatus = BTS_CONN_LAST;
   _disconnectReason = BTS_DISCONNECT_REASON_LAST;
   _protocolId = BTS_PROTO_LAST;
   // _sppUuid: init is done by member constructor
   // _masInstance: init is done by member constructor
   // _rfCommDevice: init is done by member constructor
}

Bts2App_ProtocolConnectionStatus::Bts2App_ProtocolConnectionStatus(IN const Bts2App_ProtocolConnectionStatus& ref)
: Bts2App_BaseMessage(ref)
{
   _connectionStatus = ref._connectionStatus;
   _disconnectReason = ref._disconnectReason;
   _protocolId = ref._protocolId;
   _sppUuid = ref._sppUuid;
   _masInstance = ref._masInstance;
   _rfCommDevice = ref._rfCommDevice;
}

Bts2App_ProtocolConnectionStatus& Bts2App_ProtocolConnectionStatus::operator=(IN const Bts2App_ProtocolConnectionStatus& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _connectionStatus = ref._connectionStatus;
   _disconnectReason = ref._disconnectReason;
   _protocolId = ref._protocolId;
   _sppUuid = ref._sppUuid;
   _masInstance = ref._masInstance;
   _rfCommDevice = ref._rfCommDevice;

   return *this;
}

Bts2App_ProtocolConnectionStatus::~Bts2App_ProtocolConnectionStatus()
{
}

void Bts2App_ProtocolConnectionStatus::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->protocolConnectionStatusCB(_deviceAddress, _connectionStatus, _disconnectReason, _protocolId, _sppUuid, _masInstance, _rfCommDevice, _sessionHandle);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_ProtocolConnectionStatus::clone(void) const
{
   return new Bts2App_ProtocolConnectionStatus(*this);
}

Bts2App_DeviceConnectionStatus::Bts2App_DeviceConnectionStatus()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_DeviceConnectionStatus)
{
   _connectionStatus = BTS_CONN_LAST;
   _disconnectReason = BTS_DISCONNECT_REASON_LAST;
}

Bts2App_DeviceConnectionStatus::Bts2App_DeviceConnectionStatus(IN const Bts2App_DeviceConnectionStatus& ref)
: Bts2App_BaseMessage(ref)
{
   _connectionStatus = ref._connectionStatus;
   _disconnectReason = ref._disconnectReason;
}

Bts2App_DeviceConnectionStatus& Bts2App_DeviceConnectionStatus::operator=(IN const Bts2App_DeviceConnectionStatus& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _connectionStatus = ref._connectionStatus;
   _disconnectReason = ref._disconnectReason;

   return *this;
}

Bts2App_DeviceConnectionStatus::~Bts2App_DeviceConnectionStatus()
{
}

void Bts2App_DeviceConnectionStatus::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->deviceConnectionStatusCB(_deviceAddress, _connectionStatus, _disconnectReason, _sessionHandle);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_DeviceConnectionStatus::clone(void) const
{
   return new Bts2App_DeviceConnectionStatus(*this);
}

Bts2App_DeviceCapabilities::Bts2App_DeviceCapabilities()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_DeviceCapabilities)
{
   // _deviceCapabilities: init is done by member constructor
}

Bts2App_DeviceCapabilities::Bts2App_DeviceCapabilities(IN const Bts2App_DeviceCapabilities& ref)
: Bts2App_BaseMessage(ref)
{
   _deviceCapabilities = ref._deviceCapabilities;
}

Bts2App_DeviceCapabilities& Bts2App_DeviceCapabilities::operator=(IN const Bts2App_DeviceCapabilities& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _deviceCapabilities = ref._deviceCapabilities;

   return *this;
}

Bts2App_DeviceCapabilities::~Bts2App_DeviceCapabilities()
{
}

void Bts2App_DeviceCapabilities::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->deviceCapabilitiesCB(_deviceAddress, _deviceCapabilities, _sessionHandle);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_DeviceCapabilities::clone(void) const
{
   return new Bts2App_DeviceCapabilities(*this);
}

Bts2App_RemoteSupportedServices::Bts2App_RemoteSupportedServices()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_RemoteSupportedServices)
{
   _result = BTS_REQ_LAST;
   // _supportedServices: init is done by member constructor
   // _serviceInfoList is empty per default
}

Bts2App_RemoteSupportedServices::Bts2App_RemoteSupportedServices(IN const Bts2App_RemoteSupportedServices& ref)
: Bts2App_BaseMessage(ref)
{
   _result = ref._result;
   _supportedServices = ref._supportedServices;
   _serviceInfoList = ref._serviceInfoList;
}

Bts2App_RemoteSupportedServices& Bts2App_RemoteSupportedServices::operator=(IN const Bts2App_RemoteSupportedServices& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _result = ref._result;
   _supportedServices = ref._supportedServices;
   _serviceInfoList = ref._serviceInfoList;

   return *this;
}

Bts2App_RemoteSupportedServices::~Bts2App_RemoteSupportedServices()
{
}

void Bts2App_RemoteSupportedServices::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->remoteSupportedServicesCB(_deviceAddress, _result, _supportedServices, _serviceInfoList, _sessionHandle);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_RemoteSupportedServices::clone(void) const
{
   return new Bts2App_RemoteSupportedServices(*this);
}

Bts2App_RemoteSppCapabilities::Bts2App_RemoteSppCapabilities()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_RemoteSppCapabilities)
{
   _result = BTS_REQ_LAST;
   // _sspCapabilities is empty per default
}

Bts2App_RemoteSppCapabilities::Bts2App_RemoteSppCapabilities(IN const Bts2App_RemoteSppCapabilities& ref)
: Bts2App_BaseMessage(ref)
{
   _result = ref._result;
   _sspCapabilities = ref._sspCapabilities;
}

Bts2App_RemoteSppCapabilities& Bts2App_RemoteSppCapabilities::operator=(IN const Bts2App_RemoteSppCapabilities& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _result = ref._result;
   _sspCapabilities = ref._sspCapabilities;

   return *this;
}

Bts2App_RemoteSppCapabilities::~Bts2App_RemoteSppCapabilities()
{
}

void Bts2App_RemoteSppCapabilities::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->remoteSppCapabilitiesCB(_deviceAddress, _result, _sspCapabilities, _sessionHandle);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_RemoteSppCapabilities::clone(void) const
{
   return new Bts2App_RemoteSppCapabilities(*this);
}

Bts2App_RemoteDeviceIdServiceRecords::Bts2App_RemoteDeviceIdServiceRecords()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_RemoteDeviceIdServiceRecords)
{
   _result = BTS_REQ_LAST;
   // _deviceIdServiceRecords is empty per default
}

Bts2App_RemoteDeviceIdServiceRecords::Bts2App_RemoteDeviceIdServiceRecords(IN const Bts2App_RemoteDeviceIdServiceRecords& ref)
: Bts2App_BaseMessage(ref)
{
   _result = ref._result;
   _deviceIdServiceRecords = ref._deviceIdServiceRecords;
}

Bts2App_RemoteDeviceIdServiceRecords& Bts2App_RemoteDeviceIdServiceRecords::operator=(IN const Bts2App_RemoteDeviceIdServiceRecords& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _result = ref._result;
   _deviceIdServiceRecords = ref._deviceIdServiceRecords;

   return *this;
}

Bts2App_RemoteDeviceIdServiceRecords::~Bts2App_RemoteDeviceIdServiceRecords()
{
}

void Bts2App_RemoteDeviceIdServiceRecords::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->remoteDeviceIdServiceRecordsCB(_deviceAddress, _result, _deviceIdServiceRecords, _sessionHandle);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_RemoteDeviceIdServiceRecords::clone(void) const
{
   return new Bts2App_RemoteDeviceIdServiceRecords(*this);
}

Bts2App_RemoteServiceSearchResult::Bts2App_RemoteServiceSearchResult()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_RemoteServiceSearchResult)
{
   _supportedServicesResult = BTS_REQ_LAST;
   _sppCapabilitiesResult = BTS_REQ_LAST;
   _deviceIdServiceRecordsResult = BTS_REQ_LAST;
}

Bts2App_RemoteServiceSearchResult::Bts2App_RemoteServiceSearchResult(IN const Bts2App_RemoteServiceSearchResult& ref)
: Bts2App_BaseMessage(ref)
{
   _supportedServicesResult = ref._supportedServicesResult;
   _sppCapabilitiesResult = ref._sppCapabilitiesResult;
   _deviceIdServiceRecordsResult = ref._deviceIdServiceRecordsResult;
}

Bts2App_RemoteServiceSearchResult& Bts2App_RemoteServiceSearchResult::operator=(IN const Bts2App_RemoteServiceSearchResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _supportedServicesResult = ref._supportedServicesResult;
   _sppCapabilitiesResult = ref._sppCapabilitiesResult;
   _deviceIdServiceRecordsResult = ref._deviceIdServiceRecordsResult;

   return *this;
}

Bts2App_RemoteServiceSearchResult::~Bts2App_RemoteServiceSearchResult()
{
}

void Bts2App_RemoteServiceSearchResult::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->remoteServiceSearchResultCB(_deviceAddress, _supportedServicesResult, _sppCapabilitiesResult, _deviceIdServiceRecordsResult, _sessionHandle);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_RemoteServiceSearchResult::clone(void) const
{
   return new Bts2App_RemoteServiceSearchResult(*this);
}

Bts2App_RemoteNameResult::Bts2App_RemoteNameResult()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_RemoteNameResult)
{
   _result = BTS_REQ_LAST;
   // _deviceName: init is done by member constructor
}

Bts2App_RemoteNameResult::Bts2App_RemoteNameResult(IN const Bts2App_RemoteNameResult& ref)
: Bts2App_BaseMessage(ref)
{
   _result = ref._result;
   _deviceName = ref._deviceName;
}

Bts2App_RemoteNameResult& Bts2App_RemoteNameResult::operator=(IN const Bts2App_RemoteNameResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _result = ref._result;
   _deviceName = ref._deviceName;

   return *this;
}

Bts2App_RemoteNameResult::~Bts2App_RemoteNameResult()
{
}

void Bts2App_RemoteNameResult::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->remoteNameResultCB(_deviceAddress, _result, _deviceName, _sessionHandle);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_RemoteNameResult::clone(void) const
{
   return new Bts2App_RemoteNameResult(*this);
}

Bts2App_RemoteNameStatus::Bts2App_RemoteNameStatus()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_RemoteNameStatus)
{
   // _deviceName: init is done by member constructor
}

Bts2App_RemoteNameStatus::Bts2App_RemoteNameStatus(IN const Bts2App_RemoteNameStatus& ref)
: Bts2App_BaseMessage(ref)
{
   _deviceName = ref._deviceName;
}

Bts2App_RemoteNameStatus& Bts2App_RemoteNameStatus::operator=(IN const Bts2App_RemoteNameStatus& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _deviceName = ref._deviceName;

   return *this;
}

Bts2App_RemoteNameStatus::~Bts2App_RemoteNameStatus()
{
}

void Bts2App_RemoteNameStatus::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->remoteNameStatusCB(_deviceAddress, _deviceName, _sessionHandle);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_RemoteNameStatus::clone(void) const
{
   return new Bts2App_RemoteNameStatus(*this);
}

Bts2App_LinkQualityResult::Bts2App_LinkQualityResult()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_LinkQualityResult)
{
   _result = BTS_REQ_LAST;
   _rssi = 0;
   _linkQuality = 0;
}

Bts2App_LinkQualityResult::Bts2App_LinkQualityResult(IN const Bts2App_LinkQualityResult& ref)
: Bts2App_BaseMessage(ref)
{
   _result = ref._result;
   _rssi = ref._rssi;
   _linkQuality = ref._linkQuality;
}

Bts2App_LinkQualityResult& Bts2App_LinkQualityResult::operator=(IN const Bts2App_LinkQualityResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _result = ref._result;
   _rssi = ref._rssi;
   _linkQuality = ref._linkQuality;

   return *this;
}

Bts2App_LinkQualityResult::~Bts2App_LinkQualityResult()
{
}

void Bts2App_LinkQualityResult::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->linkQualityResultCB(_deviceAddress, _result, _rssi, _linkQuality, _sessionHandle);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_LinkQualityResult::clone(void) const
{
   return new Bts2App_LinkQualityResult(*this);
}

Bts2App_StartTestModeResult::Bts2App_StartTestModeResult()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_StartTestModeResult)
{
   _result = BTS_REQ_LAST;
}

Bts2App_StartTestModeResult::Bts2App_StartTestModeResult(IN const Bts2App_StartTestModeResult& ref)
: Bts2App_BaseMessage(ref)
{
   _result = ref._result;
}

Bts2App_StartTestModeResult& Bts2App_StartTestModeResult::operator=(IN const Bts2App_StartTestModeResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _result = ref._result;

   return *this;
}

Bts2App_StartTestModeResult::~Bts2App_StartTestModeResult()
{
}

void Bts2App_StartTestModeResult::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->startTestModeResultCB(_result, _sessionHandle);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_StartTestModeResult::clone(void) const
{
   return new Bts2App_StartTestModeResult(*this);
}

Bts2App_StopTestModeResult::Bts2App_StopTestModeResult()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_StopTestModeResult)
{
   _result = BTS_REQ_LAST;
}

Bts2App_StopTestModeResult::Bts2App_StopTestModeResult(IN const Bts2App_StopTestModeResult& ref)
: Bts2App_BaseMessage(ref)
{
   _result = ref._result;
}

Bts2App_StopTestModeResult& Bts2App_StopTestModeResult::operator=(IN const Bts2App_StopTestModeResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _result = ref._result;

   return *this;
}

Bts2App_StopTestModeResult::~Bts2App_StopTestModeResult()
{
}

void Bts2App_StopTestModeResult::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->stopTestModeResultCB(_result, _sessionHandle);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_StopTestModeResult::clone(void) const
{
   return new Bts2App_StopTestModeResult(*this);
}

Bts2App_TestModeStatus::Bts2App_TestModeStatus()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_TestModeStatus)
{
   _connectionStatus = BTS_CONN_LAST;
}

Bts2App_TestModeStatus::Bts2App_TestModeStatus(IN const Bts2App_TestModeStatus& ref)
: Bts2App_BaseMessage(ref)
{
   _connectionStatus = ref._connectionStatus;
}

Bts2App_TestModeStatus& Bts2App_TestModeStatus::operator=(IN const Bts2App_TestModeStatus& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _connectionStatus = ref._connectionStatus;

   return *this;
}

Bts2App_TestModeStatus::~Bts2App_TestModeStatus()
{
}

void Bts2App_TestModeStatus::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->testModeStatusCB(_deviceAddress, _connectionStatus, _sessionHandle);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_TestModeStatus::clone(void) const
{
   return new Bts2App_TestModeStatus(*this);
}

Bts2App_TestModeLinkQualityResult::Bts2App_TestModeLinkQualityResult()
: Bts2App_BaseMessage(BTS_FB_CONNECTION, Bts2AppOC_TestModeLinkQualityResult)
{
   _result = BTS_REQ_LAST;
   _rssi = 0;
   _linkQuality = 0;
}

Bts2App_TestModeLinkQualityResult::Bts2App_TestModeLinkQualityResult(IN const Bts2App_TestModeLinkQualityResult& ref)
: Bts2App_BaseMessage(ref)
{
   _result = ref._result;
   _rssi = ref._rssi;
   _linkQuality = ref._linkQuality;
}

Bts2App_TestModeLinkQualityResult& Bts2App_TestModeLinkQualityResult::operator=(IN const Bts2App_TestModeLinkQualityResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _result = ref._result;
   _rssi = ref._rssi;
   _linkQuality = ref._linkQuality;

   return *this;
}

Bts2App_TestModeLinkQualityResult::~Bts2App_TestModeLinkQualityResult()
{
}

void Bts2App_TestModeLinkQualityResult::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getConnectionCallback())
   {
      callback.getConnectionCallback()->testModeLinkQualityResultCB(_result, _rssi, _linkQuality, _sessionHandle);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_TestModeLinkQualityResult::clone(void) const
{
   return new Bts2App_TestModeLinkQualityResult(*this);
}

} //btstackif
