/**
 * @file App2Bts_Wbl.cpp
 *
 * @par SW-Component
 * Messages
 *
 * @brief Application to BtStackIf messages for function block BTS_FB_WBL.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of messages for function block BTS_FB_WBL.
 */

#include "App2Bts_Wbl.h"

namespace btstackif {

App2Bts_SetWblDummy::App2Bts_SetWblDummy()
: App2Bts_BaseMessage(BTS_FB_WBL, App2BtsOC_SetWblDummy)
{
}

App2Bts_SetWblDummy::App2Bts_SetWblDummy(IN const App2Bts_SetWblDummy& ref)
: App2Bts_BaseMessage(ref)
{
}

App2Bts_SetWblDummy& App2Bts_SetWblDummy::operator=(IN const App2Bts_SetWblDummy& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   return *this;
}

App2Bts_SetWblDummy::~App2Bts_SetWblDummy()
{
}

App2Bts_BaseMessage* App2Bts_SetWblDummy::clone(void) const
{
   return new App2Bts_SetWblDummy(*this);
}

App2Bts_TriggerFbWblInitialized::App2Bts_TriggerFbWblInitialized()
: App2Bts_BaseMessage(BTS_FB_WBL, App2BtsOC_TriggerFbWblInitialized)
{
}

App2Bts_TriggerFbWblInitialized::App2Bts_TriggerFbWblInitialized(IN const App2Bts_TriggerFbWblInitialized& ref)
: App2Bts_BaseMessage(ref)
{
}

App2Bts_TriggerFbWblInitialized& App2Bts_TriggerFbWblInitialized::operator=(IN const App2Bts_TriggerFbWblInitialized& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   return *this;
}

App2Bts_TriggerFbWblInitialized::~App2Bts_TriggerFbWblInitialized()
{
}

App2Bts_BaseMessage* App2Bts_TriggerFbWblInitialized::clone(void) const
{
   return new App2Bts_TriggerFbWblInitialized(*this);
}

App2Bts_AllowWblCommunication::App2Bts_AllowWblCommunication()
: App2Bts_BaseMessage(BTS_FB_WBL, App2BtsOC_AllowWblCommunication)
{
}

App2Bts_AllowWblCommunication::App2Bts_AllowWblCommunication(IN const App2Bts_AllowWblCommunication& ref)
: App2Bts_BaseMessage(ref)
{
}

App2Bts_AllowWblCommunication& App2Bts_AllowWblCommunication::operator=(IN const App2Bts_AllowWblCommunication& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   return *this;
}

App2Bts_AllowWblCommunication::~App2Bts_AllowWblCommunication()
{
}

App2Bts_BaseMessage* App2Bts_AllowWblCommunication::clone(void) const
{
   return new App2Bts_AllowWblCommunication(*this);
}

App2Bts_BlockWblCommunication::App2Bts_BlockWblCommunication()
: App2Bts_BaseMessage(BTS_FB_WBL, App2BtsOC_BlockWblCommunication)
{
}

App2Bts_BlockWblCommunication::App2Bts_BlockWblCommunication(IN const App2Bts_BlockWblCommunication& ref)
: App2Bts_BaseMessage(ref)
{
}

App2Bts_BlockWblCommunication& App2Bts_BlockWblCommunication::operator=(IN const App2Bts_BlockWblCommunication& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   return *this;
}

App2Bts_BlockWblCommunication::~App2Bts_BlockWblCommunication()
{
}

App2Bts_BaseMessage* App2Bts_BlockWblCommunication::clone(void) const
{
   return new App2Bts_BlockWblCommunication(*this);
}

App2Bts_GetWblCommunicationStatus::App2Bts_GetWblCommunicationStatus()
: App2Bts_BaseMessage(BTS_FB_WBL, App2BtsOC_GetWblCommunicationStatus)
{
}

App2Bts_GetWblCommunicationStatus::App2Bts_GetWblCommunicationStatus(IN const App2Bts_GetWblCommunicationStatus& ref)
: App2Bts_BaseMessage(ref)
{
}

App2Bts_GetWblCommunicationStatus& App2Bts_GetWblCommunicationStatus::operator=(IN const App2Bts_GetWblCommunicationStatus& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   return *this;
}

App2Bts_GetWblCommunicationStatus::~App2Bts_GetWblCommunicationStatus()
{
}

App2Bts_BaseMessage* App2Bts_GetWblCommunicationStatus::clone(void) const
{
   return new App2Bts_GetWblCommunicationStatus(*this);
}

App2Bts_GetWblServiceAvailability::App2Bts_GetWblServiceAvailability()
: App2Bts_BaseMessage(BTS_FB_WBL, App2BtsOC_GetWblServiceAvailability)
{
}

App2Bts_GetWblServiceAvailability::App2Bts_GetWblServiceAvailability(IN const App2Bts_GetWblServiceAvailability& ref)
: App2Bts_BaseMessage(ref)
{
}

App2Bts_GetWblServiceAvailability& App2Bts_GetWblServiceAvailability::operator=(IN const App2Bts_GetWblServiceAvailability& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   return *this;
}

App2Bts_GetWblServiceAvailability::~App2Bts_GetWblServiceAvailability()
{
}

App2Bts_BaseMessage* App2Bts_GetWblServiceAvailability::clone(void) const
{
   return new App2Bts_GetWblServiceAvailability(*this);
}

App2Bts_GetWblLastIntendedMode::App2Bts_GetWblLastIntendedMode()
: App2Bts_BaseMessage(BTS_FB_WBL, App2BtsOC_GetWblLastIntendedMode)
{
}

App2Bts_GetWblLastIntendedMode::App2Bts_GetWblLastIntendedMode(IN const App2Bts_GetWblLastIntendedMode& ref)
: App2Bts_BaseMessage(ref)
{
}

App2Bts_GetWblLastIntendedMode& App2Bts_GetWblLastIntendedMode::operator=(IN const App2Bts_GetWblLastIntendedMode& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   return *this;
}

App2Bts_GetWblLastIntendedMode::~App2Bts_GetWblLastIntendedMode()
{
}

App2Bts_BaseMessage* App2Bts_GetWblLastIntendedMode::clone(void) const
{
   return new App2Bts_GetWblLastIntendedMode(*this);
}

App2Bts_GetWblSupportedRestrictions::App2Bts_GetWblSupportedRestrictions()
: App2Bts_BaseMessage(BTS_FB_WBL, App2BtsOC_GetWblSupportedRestrictions)
{
}

App2Bts_GetWblSupportedRestrictions::App2Bts_GetWblSupportedRestrictions(IN const App2Bts_GetWblSupportedRestrictions& ref)
: App2Bts_BaseMessage(ref)
{
}

App2Bts_GetWblSupportedRestrictions& App2Bts_GetWblSupportedRestrictions::operator=(IN const App2Bts_GetWblSupportedRestrictions& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   return *this;
}

App2Bts_GetWblSupportedRestrictions::~App2Bts_GetWblSupportedRestrictions()
{
}

App2Bts_BaseMessage* App2Bts_GetWblSupportedRestrictions::clone(void) const
{
   return new App2Bts_GetWblSupportedRestrictions(*this);
}

App2Bts_GetWblWiFiSetupStatus::App2Bts_GetWblWiFiSetupStatus()
: App2Bts_BaseMessage(BTS_FB_WBL, App2BtsOC_GetWblWiFiSetupStatus)
{
}

App2Bts_GetWblWiFiSetupStatus::App2Bts_GetWblWiFiSetupStatus(IN const App2Bts_GetWblWiFiSetupStatus& ref)
: App2Bts_BaseMessage(ref)
{
}

App2Bts_GetWblWiFiSetupStatus& App2Bts_GetWblWiFiSetupStatus::operator=(IN const App2Bts_GetWblWiFiSetupStatus& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   return *this;
}

App2Bts_GetWblWiFiSetupStatus::~App2Bts_GetWblWiFiSetupStatus()
{
}

App2Bts_BaseMessage* App2Bts_GetWblWiFiSetupStatus::clone(void) const
{
   return new App2Bts_GetWblWiFiSetupStatus(*this);
}

App2Bts_GetWblHealthinessIndicator::App2Bts_GetWblHealthinessIndicator()
: App2Bts_BaseMessage(BTS_FB_WBL, App2BtsOC_GetWblHealthinessIndicator)
{
}

App2Bts_GetWblHealthinessIndicator::App2Bts_GetWblHealthinessIndicator(IN const App2Bts_GetWblHealthinessIndicator& ref)
: App2Bts_BaseMessage(ref)
{
}

App2Bts_GetWblHealthinessIndicator& App2Bts_GetWblHealthinessIndicator::operator=(IN const App2Bts_GetWblHealthinessIndicator& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   return *this;
}

App2Bts_GetWblHealthinessIndicator::~App2Bts_GetWblHealthinessIndicator()
{
}

App2Bts_BaseMessage* App2Bts_GetWblHealthinessIndicator::clone(void) const
{
   return new App2Bts_GetWblHealthinessIndicator(*this);
}

} //btstackif
