/**
 * @file App2Bts_Messaging.cpp
 *
 * @par SW-Component
 * Messages
 *
 * @brief Application to BtStackIf messages for function block BTS_FB_MESSAGING.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of messages for function block BTS_FB_MESSAGING.
 */

#include "App2Bts_Messaging.h"

namespace btstackif {

App2Bts_SetMessagingDummy::App2Bts_SetMessagingDummy()
: App2Bts_BaseMessage(BTS_FB_MESSAGING, App2BtsOC_SetMessagingDummy)
{
}

App2Bts_SetMessagingDummy::App2Bts_SetMessagingDummy(IN const App2Bts_SetMessagingDummy& ref)
: App2Bts_BaseMessage(ref)
{
}

App2Bts_SetMessagingDummy& App2Bts_SetMessagingDummy::operator=(IN const App2Bts_SetMessagingDummy& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   return *this;
}

App2Bts_SetMessagingDummy::~App2Bts_SetMessagingDummy()
{
}

App2Bts_BaseMessage* App2Bts_SetMessagingDummy::clone(void) const
{
   return new App2Bts_SetMessagingDummy(*this);
}

} //btstackif
