/**
 * @file App2Bts_Ecnr.cpp
 *
 * @par SW-Component
 * Messages
 *
 * @brief Application to BtStackIf messages for function block BTS_FB_ECNR.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of messages for function block BTS_FB_ECNR.
 */

#include "App2Bts_Ecnr.h"

namespace btstackif {

App2Bts_SetEcnrDummy::App2Bts_SetEcnrDummy()
: App2Bts_BaseMessage(BTS_FB_ECNR, App2BtsOC_SetEcnrDummy)
{
}

App2Bts_SetEcnrDummy::App2Bts_SetEcnrDummy(IN const App2Bts_SetEcnrDummy& ref)
: App2Bts_BaseMessage(ref)
{
}

App2Bts_SetEcnrDummy& App2Bts_SetEcnrDummy::operator=(IN const App2Bts_SetEcnrDummy& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   return *this;
}

App2Bts_SetEcnrDummy::~App2Bts_SetEcnrDummy()
{
}

App2Bts_BaseMessage* App2Bts_SetEcnrDummy::clone(void) const
{
   return new App2Bts_SetEcnrDummy(*this);
}

} //btstackif
