/**
 * @file App2Bts_Config.cpp
 *
 * @par SW-Component
 * Messages
 *
 * @brief Application to BtStackIf messages for function block BTS_FB_CONFIG.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of messages for function block BTS_FB_CONFIG.
 */

#include "App2Bts_Config.h"

namespace btstackif {

App2Bts_SetDummy::App2Bts_SetDummy()
: App2Bts_BaseMessage(BTS_FB_CONFIG, App2BtsOC_SetDummy)
{
   // _remoteDeviceAddress: init is done by member constructor
}

App2Bts_SetDummy::App2Bts_SetDummy(IN const App2Bts_SetDummy& ref)
: App2Bts_BaseMessage(ref)
{
   _remoteDeviceAddress = ref._remoteDeviceAddress;
}

App2Bts_SetDummy& App2Bts_SetDummy::operator=(IN const App2Bts_SetDummy& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   _remoteDeviceAddress = ref._remoteDeviceAddress;

   return *this;
}

App2Bts_SetDummy::~App2Bts_SetDummy()
{
}

App2Bts_BaseMessage* App2Bts_SetDummy::clone(void) const
{
   return new App2Bts_SetDummy(*this);
}

void App2Bts_SetDummy::getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const
{
   // set available data
   compareItem.opCode = _opCode;
   compareItem.deviceAddress = _deviceAddress;
}

} //btstackif
