/**
 * @file App2Bts_BaseMessage.cpp
 *
 * @par SW-Component
 * Messages
 *
 * @brief Application to BtStackIf messages.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of base message for Application to BtStackIf messages.
 */

#include "App2Bts_BaseMessage.h"
#include "BtsUtils.h"

#ifdef VARIANT_S_FTR_ENABLE_FW_MEMORY_CHECKER
#include "FwMemoryChecker.h"
#endif

namespace btstackif {

unsigned int App2Bts_BaseMessage::_countApp2BtsMessages = 0;

App2Bts_BaseMessage::App2Bts_BaseMessage()
{
   _functionBlock = BTS_FB_NONE;
   _opCode = App2BtsOC_None;
   _callback = 0;
   _sessionHandle = 0;
   _component = BTS_FB_NONE;
   _stackInterface = BTS_IF_UNDEFINED;
   // _deviceAddress
   _internalMsg = false;
   _userData = 0;
   _countApp2BtsMessages++;

#ifdef VARIANT_S_FTR_ENABLE_FW_MEMORY_CHECKER
   FW_MEMORY_CHECK_NEW_OBJ(this);
#endif
}

App2Bts_BaseMessage::App2Bts_BaseMessage(IN const BTSFunctionBlock functionBlock, IN const BTSApp2BtsOpcode opCode)
{
   _functionBlock = functionBlock;
   _opCode = opCode;
   _callback = 0;
   _sessionHandle = 0;
   _component = BTS_FB_NONE;
   _stackInterface = BTS_IF_UNDEFINED;
   // _deviceAddress
   _internalMsg = false;
   _userData = 0;
   _countApp2BtsMessages++;

#ifdef VARIANT_S_FTR_ENABLE_FW_MEMORY_CHECKER
   FW_MEMORY_CHECK_NEW_OBJ(this);
#endif
}

App2Bts_BaseMessage::App2Bts_BaseMessage(IN const App2Bts_BaseMessage& ref)
{
   _functionBlock = ref._functionBlock;
   _opCode = ref._opCode;
   _callback = 0;
   setCallback(ref._callback);
   _sessionHandle = ref._sessionHandle;
   _component = ref._component;
   _stackInterface = ref._stackInterface;
   _deviceAddress = ref._deviceAddress;
   _internalMsg = ref._internalMsg;
   _userData = ref._userData;
   _countApp2BtsMessages++;

#ifdef VARIANT_S_FTR_ENABLE_FW_MEMORY_CHECKER
   FW_MEMORY_CHECK_NEW_OBJ(this);
#endif
}

App2Bts_BaseMessage& App2Bts_BaseMessage::operator=(IN const App2Bts_BaseMessage& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   _functionBlock = ref._functionBlock;
   _opCode = ref._opCode;
   _callback = 0;
   setCallback(ref._callback);
   _sessionHandle = ref._sessionHandle;
   _component = ref._component;
   _stackInterface = ref._stackInterface;
   _deviceAddress = ref._deviceAddress;
   _internalMsg = ref._internalMsg;
   _userData = ref._userData;
   // do not increment --- _countApp2BtsMessages++;

   return *this;
}

App2Bts_BaseMessage::~App2Bts_BaseMessage()
{
   _callback = 0;
   if(_countApp2BtsMessages) _countApp2BtsMessages--;

#ifdef VARIANT_S_FTR_ENABLE_FW_MEMORY_CHECKER
   FW_MEMORY_CHECK_DEL_OBJ(this);
#endif
}

void App2Bts_BaseMessage::doInputTrace(void)
{
   // is done by derived class
}

void App2Bts_BaseMessage::getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const
{
   // set available data
   compareItem.opCode = _opCode;
   compareItem.deviceAddress = _deviceAddress;
}

uint32_t App2Bts_BaseMessage::getMessageTraceId(void) const
{
   return calcMessageTraceId((uint32_t)_component, (uint32_t)_stackInterface, (uint32_t)_opCode);
}

App2Bts_BaseMessage* App2Bts_BaseMessage::getMessagePtr(void)
{
   return this;
}

} //btstackif
