/**
 * @file App2Bts_Wbl.h
 *
 * @par SW-Component
 * Messages
 *
 * @brief Application to BtStackIf messages for function block BTS_FB_WBL.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Declaration of messages for function block BTS_FB_WBL.
 */

#ifndef _APP_2_BTS_WBL_MSG_H_
#define _APP_2_BTS_WBL_MSG_H_

#include "App2Bts_BaseMessage.h"

namespace btstackif {

/**
 *
 */
class App2Bts_SetWblDummy : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_SetWblDummy();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_SetWblDummy(IN const App2Bts_SetWblDummy& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_SetWblDummy& operator=(IN const App2Bts_SetWblDummy& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_SetWblDummy();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;
};

/**
 *
 */
class App2Bts_TriggerFbWblInitialized : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_TriggerFbWblInitialized();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_TriggerFbWblInitialized(IN const App2Bts_TriggerFbWblInitialized& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_TriggerFbWblInitialized& operator=(IN const App2Bts_TriggerFbWblInitialized& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_TriggerFbWblInitialized();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;
};

/**
 *
 */
class App2Bts_AllowWblCommunication : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_AllowWblCommunication();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_AllowWblCommunication(IN const App2Bts_AllowWblCommunication& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_AllowWblCommunication& operator=(IN const App2Bts_AllowWblCommunication& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_AllowWblCommunication();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;
};

/**
 *
 */
class App2Bts_BlockWblCommunication : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_BlockWblCommunication();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_BlockWblCommunication(IN const App2Bts_BlockWblCommunication& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_BlockWblCommunication& operator=(IN const App2Bts_BlockWblCommunication& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_BlockWblCommunication();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;
};

/**
 *
 */
class App2Bts_GetWblCommunicationStatus : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_GetWblCommunicationStatus();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_GetWblCommunicationStatus(IN const App2Bts_GetWblCommunicationStatus& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_GetWblCommunicationStatus& operator=(IN const App2Bts_GetWblCommunicationStatus& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_GetWblCommunicationStatus();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;
};

/**
 *
 */
class App2Bts_GetWblServiceAvailability : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_GetWblServiceAvailability();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_GetWblServiceAvailability(IN const App2Bts_GetWblServiceAvailability& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_GetWblServiceAvailability& operator=(IN const App2Bts_GetWblServiceAvailability& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_GetWblServiceAvailability();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;
};

/**
 *
 */
class App2Bts_GetWblLastIntendedMode : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_GetWblLastIntendedMode();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_GetWblLastIntendedMode(IN const App2Bts_GetWblLastIntendedMode& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_GetWblLastIntendedMode& operator=(IN const App2Bts_GetWblLastIntendedMode& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_GetWblLastIntendedMode();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;
};

/**
 *
 */
class App2Bts_GetWblSupportedRestrictions : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_GetWblSupportedRestrictions();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_GetWblSupportedRestrictions(IN const App2Bts_GetWblSupportedRestrictions& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_GetWblSupportedRestrictions& operator=(IN const App2Bts_GetWblSupportedRestrictions& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_GetWblSupportedRestrictions();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;
};

/**
 *
 */
class App2Bts_GetWblWiFiSetupStatus : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_GetWblWiFiSetupStatus();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_GetWblWiFiSetupStatus(IN const App2Bts_GetWblWiFiSetupStatus& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_GetWblWiFiSetupStatus& operator=(IN const App2Bts_GetWblWiFiSetupStatus& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_GetWblWiFiSetupStatus();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;
};

/**
 *
 */
class App2Bts_GetWblHealthinessIndicator : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_GetWblHealthinessIndicator();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_GetWblHealthinessIndicator(IN const App2Bts_GetWblHealthinessIndicator& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_GetWblHealthinessIndicator& operator=(IN const App2Bts_GetWblHealthinessIndicator& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_GetWblHealthinessIndicator();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;
};

} //btstackif

#endif //_APP_2_BTS_WBL_MSG_H_
