/**
 * @file App2Bts_MessageWrapper.h
 *
 * @par SW-Component
 * Messages
 *
 * @brief Wrapper for Application to BtStackIf messages.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Wrapper for Application to BtStackIf messages.
 * The only reason for this file is to solve following lint warnings:
 * Warning 429: prio2: Custodial pointer 'ptrMessage' ...
 */

#ifndef _APP_2_BTS_MESSAGE_WRAPPER_H_
#define _APP_2_BTS_MESSAGE_WRAPPER_H_

#include "App2Bts_Config.h"
#include "App2Bts_Connection.h"
#include "App2Bts_Telephony.h"
#include "App2Bts_Phonebook.h"
#include "App2Bts_Messaging.h"
#include "App2Bts_MediaPlayer.h"
#include "App2Bts_Wbl.h"
#include "App2Bts_Ecnr.h"

namespace btstackif {

inline App2Bts_SetDummy* ptrNew_App2Bts_SetDummy(void) { return new App2Bts_SetDummy(); }
inline App2Bts_StartInternalCommunication* ptrNew_App2Bts_StartInternalCommunication(void) { return new App2Bts_StartInternalCommunication(); }
inline App2Bts_TriggerFbConnectionInitialized* ptrNew_App2Bts_TriggerFbConnectionInitialized(void) { return new App2Bts_TriggerFbConnectionInitialized(); }
inline App2Bts_SwitchBluetoothOnOff* ptrNew_App2Bts_SwitchBluetoothOnOff(void) { return new App2Bts_SwitchBluetoothOnOff(); }
inline App2Bts_GetBluetoothOnOffStatus* ptrNew_App2Bts_GetBluetoothOnOffStatus(void) { return new App2Bts_GetBluetoothOnOffStatus(); }
inline App2Bts_SwitchBluetoothHardwareOnOff* ptrNew_App2Bts_SwitchBluetoothHardwareOnOff(void) { return new App2Bts_SwitchBluetoothHardwareOnOff(); }
inline App2Bts_SetLocalBtName* ptrNew_App2Bts_SetLocalBtName(void) { return new App2Bts_SetLocalBtName(); }
inline App2Bts_GetLocalBtName* ptrNew_App2Bts_GetLocalBtName(void) { return new App2Bts_GetLocalBtName(); }
inline App2Bts_SetDeviceIdServiceRecord* ptrNew_App2Bts_SetDeviceIdServiceRecord(void) { return new App2Bts_SetDeviceIdServiceRecord(); }
inline App2Bts_SetDeviceForRestrictedPairingConnecting* ptrNew_App2Bts_SetDeviceForRestrictedPairingConnecting(void) { return new App2Bts_SetDeviceForRestrictedPairingConnecting(); }
inline App2Bts_SetLocalAdapterModes* ptrNew_App2Bts_SetLocalAdapterModes(void) { return new App2Bts_SetLocalAdapterModes(); }
inline App2Bts_GetLocalAdapterModes* ptrNew_App2Bts_GetLocalAdapterModes(void) { return new App2Bts_GetLocalAdapterModes(); }
inline App2Bts_StartDiscovery* ptrNew_App2Bts_StartDiscovery(void) { return new App2Bts_StartDiscovery(); }
inline App2Bts_StopDiscovery* ptrNew_App2Bts_StopDiscovery(void) { return new App2Bts_StopDiscovery(); }
inline App2Bts_GetDiscoveringStatus* ptrNew_App2Bts_GetDiscoveringStatus(void) { return new App2Bts_GetDiscoveringStatus(); }
inline App2Bts_StartPairing* ptrNew_App2Bts_StartPairing(void) { return new App2Bts_StartPairing(); }
inline App2Bts_CancelPairing* ptrNew_App2Bts_CancelPairing(void) { return new App2Bts_CancelPairing(); }
inline App2Bts_SetPinCode* ptrNew_App2Bts_SetPinCode(void) { return new App2Bts_SetPinCode(); }
inline App2Bts_ConfirmSecureSimplePairing* ptrNew_App2Bts_ConfirmSecureSimplePairing(void) { return new App2Bts_ConfirmSecureSimplePairing(); }
inline App2Bts_SetLinkKey* ptrNew_App2Bts_SetLinkKey(void) { return new App2Bts_SetLinkKey(); }
inline App2Bts_ConnectProtocol* ptrNew_App2Bts_ConnectProtocol(void) { return new App2Bts_ConnectProtocol(); }
inline App2Bts_AcceptRemoteProtocolConnect* ptrNew_App2Bts_AcceptRemoteProtocolConnect(void) { return new App2Bts_AcceptRemoteProtocolConnect(); }
inline App2Bts_RejectRemoteProtocolConnect* ptrNew_App2Bts_RejectRemoteProtocolConnect(void) { return new App2Bts_RejectRemoteProtocolConnect(); }
inline App2Bts_DisconnectProtocol* ptrNew_App2Bts_DisconnectProtocol(void) { return new App2Bts_DisconnectProtocol(); }
inline App2Bts_DisconnectDevice* ptrNew_App2Bts_DisconnectDevice(void) { return new App2Bts_DisconnectDevice(); }
inline App2Bts_GetProtocolConnectionStatus* ptrNew_App2Bts_GetProtocolConnectionStatus(void) { return new App2Bts_GetProtocolConnectionStatus(); }
inline App2Bts_GetDeviceConnectionStatus* ptrNew_App2Bts_GetDeviceConnectionStatus(void) { return new App2Bts_GetDeviceConnectionStatus(); }
inline App2Bts_StartRemoteServiceSearch* ptrNew_App2Bts_StartRemoteServiceSearch(void) { return new App2Bts_StartRemoteServiceSearch(); }
inline App2Bts_CancelRemoteServiceSearch* ptrNew_App2Bts_CancelRemoteServiceSearch(void) { return new App2Bts_CancelRemoteServiceSearch(); }
inline App2Bts_QueryRemoteName* ptrNew_App2Bts_QueryRemoteName(void) { return new App2Bts_QueryRemoteName(); }
inline App2Bts_RequestLinkQuality* ptrNew_App2Bts_RequestLinkQuality(void) { return new App2Bts_RequestLinkQuality(); }
inline App2Bts_StartTestMode* ptrNew_App2Bts_StartTestMode(void) { return new App2Bts_StartTestMode(); }
inline App2Bts_StopTestMode* ptrNew_App2Bts_StopTestMode(void) { return new App2Bts_StopTestMode(); }
inline App2Bts_RequestTestModeLinkQuality* ptrNew_App2Bts_RequestTestModeLinkQuality(void) { return new App2Bts_RequestTestModeLinkQuality(); }
inline App2Bts_SetTelephonyDummy* ptrNew_App2Bts_SetTelephonyDummy(void) { return new App2Bts_SetTelephonyDummy(); }
inline App2Bts_SetPhonebookDummy* ptrNew_App2Bts_SetPhonebookDummy(void) { return new App2Bts_SetPhonebookDummy(); }
inline App2Bts_SetMessagingDummy* ptrNew_App2Bts_SetMessagingDummy(void) { return new App2Bts_SetMessagingDummy(); }
inline App2Bts_SetMediaPlayerDummy* ptrNew_App2Bts_SetMediaPlayerDummy(void) { return new App2Bts_SetMediaPlayerDummy(); }
inline App2Bts_SetWblDummy* ptrNew_App2Bts_SetWblDummy(void) { return new App2Bts_SetWblDummy(); }
inline App2Bts_TriggerFbWblInitialized* ptrNew_App2Bts_TriggerFbWblInitialized(void) { return new App2Bts_TriggerFbWblInitialized(); }
inline App2Bts_AllowWblCommunication* ptrNew_App2Bts_AllowWblCommunication(void) { return new App2Bts_AllowWblCommunication(); }
inline App2Bts_BlockWblCommunication* ptrNew_App2Bts_BlockWblCommunication(void) { return new App2Bts_BlockWblCommunication(); }
inline App2Bts_GetWblCommunicationStatus* ptrNew_App2Bts_GetWblCommunicationStatus(void) { return new App2Bts_GetWblCommunicationStatus(); }
inline App2Bts_GetWblServiceAvailability* ptrNew_App2Bts_GetWblServiceAvailability(void) { return new App2Bts_GetWblServiceAvailability(); }
inline App2Bts_GetWblLastIntendedMode* ptrNew_App2Bts_GetWblLastIntendedMode(void) { return new App2Bts_GetWblLastIntendedMode(); }
inline App2Bts_GetWblSupportedRestrictions* ptrNew_App2Bts_GetWblSupportedRestrictions(void) { return new App2Bts_GetWblSupportedRestrictions(); }
inline App2Bts_GetWblWiFiSetupStatus* ptrNew_App2Bts_GetWblWiFiSetupStatus(void) { return new App2Bts_GetWblWiFiSetupStatus(); }
inline App2Bts_GetWblHealthinessIndicator* ptrNew_App2Bts_GetWblHealthinessIndicator(void) { return new App2Bts_GetWblHealthinessIndicator(); }
inline App2Bts_SetEcnrDummy* ptrNew_App2Bts_SetEcnrDummy(void) { return new App2Bts_SetEcnrDummy(); }

} //btstackif

#endif //_APP_2_BTS_MESSAGE_WRAPPER_H_
