/**
 * @file App2Bts_MediaPlayer.h
 *
 * @par SW-Component
 * Messages
 *
 * @brief Application to BtStackIf messages for function block BTS_FB_MEDIAPLAYER.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Declaration of messages for function block BTS_FB_MEDIAPLAYER.
 */

#ifndef _APP_2_BTS_MEDIAPLAYER_MSG_H_
#define _APP_2_BTS_MEDIAPLAYER_MSG_H_

#include "App2Bts_BaseMessage.h"

namespace btstackif {

/**
 *
 */
class App2Bts_SetMediaPlayerDummy : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_SetMediaPlayerDummy();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_SetMediaPlayerDummy(IN const App2Bts_SetMediaPlayerDummy& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_SetMediaPlayerDummy& operator=(IN const App2Bts_SetMediaPlayerDummy& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_SetMediaPlayerDummy();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;
};

} //btstackif

#endif //_APP_2_BTS_MEDIAPLAYER_MSG_H_
