/**
 * @file App2Bts_Ecnr.h
 *
 * @par SW-Component
 * Messages
 *
 * @brief Application to BtStackIf messages for function block BTS_FB_ECNR.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Declaration of messages for function block BTS_FB_ECNR.
 */

#ifndef _APP_2_BTS_ECNR_MSG_H_
#define _APP_2_BTS_ECNR_MSG_H_

#include "App2Bts_BaseMessage.h"

namespace btstackif {

/**
 *
 */
class App2Bts_SetEcnrDummy : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_SetEcnrDummy();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_SetEcnrDummy(IN const App2Bts_SetEcnrDummy& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_SetEcnrDummy& operator=(IN const App2Bts_SetEcnrDummy& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_SetEcnrDummy();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;
};

} //btstackif

#endif //_APP_2_BTS_ECNR_MSG_H_
