/**
 * @file FC_Bluetooth_clienthandler_Phone.cpp
 * @author
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 *
 * @addtogroup FC_Bluetooth
 *
 * @brief Public Implementation for Phone client handler
 *
 * @{
 */
/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
//Include FI interface of used service
#define MOST_FI_S_IMPORT_INTERFACE_MOST_TELFI_TYPES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_TELFI_FUNCTIONIDS
#define MOST_FI_S_IMPORT_INTERFACE_MOST_TELFI_ERRORCODES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_TELFI_SERVICEINFO
#include "conn_most_fi_if.h"

#include "FC_Bluetooth_main.h"
#include "FC_Bluetooth_clienthandler_Diaglib.h"
#include "FC_Bluetooth_clienthandler_Phone.h"
#include "FC_Bluetooth_CCAService.h"
#include "FunctionTracer.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_BLUETOOTH_BM_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/FC_Bluetooth_clienthandler_Phone.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_BLUETOOTH_BM_APPLICATION
#endif // VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
fc_bluetooth_tclClientHandler_Phone* fc_bluetooth_tclClientHandler_Phone::m_poClientHandlerPhone =
      OSAL_NULL;

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/
BEGIN_MSG_MAP(fc_bluetooth_tclClientHandler_Phone, ahl_tclBaseWork)

ON_MESSAGE_SVCDATA( MOST_TELFI_C_U16_CALLSTATUSNOTICE, AMT_C_U8_CCAMSG_OPCODE_STATUS ,
         OnCallStatusNoticeStatus )

ON_MESSAGE_SVCDATA( MOST_TELFI_C_U16_CALLSTATUSNOTICE, AMT_C_U8_CCAMSG_OPCODE_ERROR ,
                  OnCallStatusNoticeError )

END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
 *
 * FUNCTION     :  fc_bluetooth_tclClientHandler_Phone::
 *                 fc_bluetooth_tclClientHandler_Phone(fc_bluetooth_tclApp* poMainAppl)
 *
 * DESCRIPTION  : Constructor.
 *
 *                 Create an object of the base class
 *                 ahl_tclBaseOneThreadClientHandler with a pointer to this
 *                 application, the to be used service identifier and the service
 *                 version as parameters.
 *
 * PARAMETER    : [IN] poMainAppl = Pointer to the object of this application.
 *
 * RETURNVALUE  : None.
 *
 *******************************************************************************/
fc_bluetooth_tclClientHandler_Phone::fc_bluetooth_tclClientHandler_Phone(fc_bluetooth_tclApp* poMainAppl) :
      ahl_tclBaseOneThreadClientHandler(
      /* Application Pointer          */poMainAppl,
      /* ID of used Service           */CCA_C_U16_SRV_FB_TELEPHONE,
      /* MajorVersion of used Service */FC_BLUETOOTH_SERVICE_TELEPHONE_FI_MAJOR_VERSION,
      /* MinorVersion of used Service */FC_BLUETOOTH_SERVICE_TELEPHONE_FI_MINOR_VERSION)
{
   ENTRY
   m_poClientHandlerPhone = this;
   m_bIsCallStatusCalled = false;
}

/*******************************************************************************
 *
 * FUNCTION     :  fc_bluetooth_tclClientHandler_Phone::
 *                 ~fc_bluetooth_tclClientHandler_Phone(tVoid)
 *
 * DESCRIPTION  : Destructor.
 *
 * PARAMETER    : None.
 *
 * RETURNVALUE  : None.
 *
 *******************************************************************************/
fc_bluetooth_tclClientHandler_Phone::~fc_bluetooth_tclClientHandler_Phone(tVoid)
{
   ENTRY
   m_poClientHandlerPhone = OSAL_NULL;
   m_bIsCallStatusCalled = false;
}

/*******************************************************************************
 *
 * FUNCTION     :  tVoid fc_bluetooth_tclClientHandler_Phone::
 *						vOnServiceAvailable()
 *
 * DESCRIPTION  :  This function is called by the CCA framework when the service
 *                 this client-handler has registered for has become available.
 *
 * PARAMETER    :  None.
 *
 * RETURNVALUE  :  None.
 *
 ********************************************************************************
 * Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
 *******************************************************************************/
tVoid fc_bluetooth_tclClientHandler_Phone::vOnServiceAvailable()
{
   ENTRY
   ETG_TRACE_USR2(("vOnServiceAvailable() entered. AppID = %u.", u16GetServerAppID()));
}

/*******************************************************************************
 *
 * FUNCTION     :  tVoid fc_bluetooth_tclClientHandler_Phone::
 vOnServiceUnavailable()
 *
 * DESCRIPTION  :  This function is called by the CCA framework when the service
 *                 this client-handler has registered for has become unavailable.
 *
 * PARAMETER    :  None.
 *
 * RETURNVALUE  :  None.
 *
 ********************************************************************************
 * Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
 *******************************************************************************/
tVoid fc_bluetooth_tclClientHandler_Phone::vOnServiceUnavailable()
{
   ENTRY
   ETG_TRACE_USR2(("vOnServiceUnavailable() entered. AppID = %u.",u16GetServerAppID()));
}

/*******************************************************************************
 *
 * FUNCTION     :  vGetCallStatus(..)
 *
 * DESCRIPTION  :  This is a handler function for CallStatus property status
 *
 * PARAMETER    :  IN:poMessage: This is the received message from a client
 *
 * RETURNVALUE  :  None.
 *
 ********************************************************************************/
tBool fc_bluetooth_tclClientHandler_Phone::vGetCallStatus()
{
   ENTRY

   tBool bResult = TRUE;

   most_telfi_tclMsgCallStatusNoticeStatus oCallStatusNoticeStatusGet;

   fi_tclVisitorMessage oVisitorMsgOutput(oCallStatusNoticeStatusGet, FC_BLUETOOTH_SERVICE_TELEPHONE_FI_MAJOR_VERSION);

   // Here the message related header information is added and by this the
   // creation of the message is completed.

   vInitServiceData(oVisitorMsgOutput, 0, MOST_TELFI_C_U16_CALLSTATUSNOTICE, AMT_C_U8_CCAMSG_OPCODE_GET);

   // Post message
   ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

   if (enResult != AIL_EN_N_NO_ERROR)
   {
      ETG_TRACE_ERR(("vGetCallStatus:enPostMessage() failed"));
      bResult = FALSE;
   }
   else
   {
      m_bIsCallStatusCalled = true;
   }

   oCallStatusNoticeStatusGet.vDestroy();

   return bResult;
}

/*******************************************************************************
 *
 * FUNCTION     :  OnIncomingCallEventStatus(..)
 *
 * DESCRIPTION  :  This is a handler function for DeviceList property status
 *
 * PARAMETER    :  IN:poMessage: This is the received message from a client
 *
 * RETURNVALUE  :  None.
 *
 ********************************************************************************/
tVoid fc_bluetooth_tclClientHandler_Phone::OnCallStatusNoticeStatus(amt_tclServiceData* poMessage)
{
   ENTRY

   fi_tclVisitorMessage oVisitorMsg(poMessage);
   fc_bluetooth_tclClientHandler_Diaglib *poBluetoothDiaglib = OSAL_NULL;

   most_telfi_tclMsgCallStatusNoticeStatus oCallStatusNoticeStatus;

   if (oVisitorMsg.s32GetData(oCallStatusNoticeStatus, MOST_TELFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
   {
      std::vector<most_fi_tcl_TelCallStatusNoticeStreamItem,
            std::allocator<most_fi_tcl_TelCallStatusNoticeStreamItem> >::iterator Itr = oCallStatusNoticeStatus.oCallStatusNoticeStream.oItems.begin();

      if (Itr != oCallStatusNoticeStatus.oCallStatusNoticeStream.oItems.end())
      {
         ETG_TRACE_USR1(("oCallStatusNoticeStatus.oCallStatusNoticeStream.oItems.Size()== %u", oCallStatusNoticeStatus.oCallStatusNoticeStream.oItems.size()));
         if (oCallStatusNoticeStatus.oCallStatusNoticeStream.oItems.size() > 0)
         {
            while (Itr != oCallStatusNoticeStatus.oCallStatusNoticeStream.oItems.end())
            {
               ETG_TRACE_USR1(("oCallStatusNoticeStatus: call status - %d", Itr->e8CallStatus.enType));

               if (Itr->e8CallStatus.enType != most_fi_tcl_e8_TelCallStatus::FI_EN_E8IDLE)
               {
                  poBluetoothDiaglib = fc_bluetooth_tclClientHandler_Diaglib::poGetInstance();
                  if (OSAL_NULL != poBluetoothDiaglib)
                  {
                     poBluetoothDiaglib->vDiagCallStatus((tU8)Itr->e8CallStatus.enType);
                  }
                  else
                  {
                     ETG_TRACE_ERR(("poBluetoothDiaglib is OSAL_NULL"));
                  }

                  break;
               }
               Itr++;
            }
         }
      }
   }
   else
   {
      ETG_TRACE_ERR(("oCallStatusNoticeStatus: Version mismatch"));

      poBluetoothDiaglib = fc_bluetooth_tclClientHandler_Diaglib::poGetInstance();
      if (OSAL_NULL != poBluetoothDiaglib)
      {
         poBluetoothDiaglib->vDiagCallStatus((tU8)-1); // semaphore m_hEvFusion will be posted in this routine!
      }
   }

   m_bIsCallStatusCalled = false;
   oCallStatusNoticeStatus.vDestroy();
}

/*******************************************************************************
 *
 * FUNCTION     :  OnIncomingCallEventStatus(..)
 *
 * DESCRIPTION  :  This is a handler function for DeviceList property status
 *
 * PARAMETER    :  IN:poMessage: This is the received message from a client
 *
 * RETURNVALUE  :  None.
 *
 ********************************************************************************/
tVoid fc_bluetooth_tclClientHandler_Phone::OnCallStatusNoticeError(amt_tclServiceData* poMessage)
{
   ENTRY
   (tVoid)poMessage;
   fc_bluetooth_tclClientHandler_Diaglib *poBluetoothDiaglib = OSAL_NULL;

   if(m_bIsCallStatusCalled == true)
   {
      m_bIsCallStatusCalled = false;
      poBluetoothDiaglib = fc_bluetooth_tclClientHandler_Diaglib::poGetInstance();
      if (OSAL_NULL != poBluetoothDiaglib)
      {
         ETG_TRACE_ERR(("OnCallStatusNoticeError: vDiagCallStatus send"));
         poBluetoothDiaglib->vDiagCallStatus((tU8)-1); // semaphore m_hEvFusion will be posted in this routine!
      }
   }
   else
   {
      ETG_TRACE_USR4(("OnCallStatusNoticeError: m_bIsCallStatusCalled is false"));
   }
}
