/**
 * @file FC_Bluetooth_CCAService.cpp
 * @author 
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 *
 * @addtogroup FC_Bluetooth
 *
 * @brief Public interface for BluetoothCCAService
 * @{
 */

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

//Include FI interface of used service
#define MOST_FI_S_IMPORT_INTERFACE_MOST_TELFI_TYPES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_TELFI_FUNCTIONIDS
#define MOST_FI_S_IMPORT_INTERFACE_MOST_TELFI_ERRORCODES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_TELFI_SERVICEINFO

#include "FC_Bluetooth_main.h"
#include "FC_Bluetooth_CCAService.h"
#include "FC_Bluetooth_Loopback_Controller.h"
#include "FC_Bluetooth_clienthandler_MediaPlayer.h"
#include "FC_Bluetooth_AudioRouting.h"
#include "FC_Bluetooth_AudioPlayer.h"
#include "FC_Bluetooth_clienthandler_Phone.h"
#include "FC_Bluetooth_clienthandler_SpmCore.h"
#include <FC_Bluetooth_rootdaemon_client.h>
#include "FC_Bluetooth_clienthandler_Diaglog.h"
#include "FC_Bluetooth_clienthandler_Diaglib.h"
#include "IBmCoreRequestIf.h"
#include "FunctionTracer.h"
#include "FwUtils.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_BLUETOOTH_BM_APP_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/FC_Bluetooth_CCAService.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_BLUETOOTH_BM_APP_SERVICE
#endif
#endif

#ifdef VARIANT_S_FTR_ENABLE_FW_MEMORY_CHECKER
#include "FwMemoryChecker.h"
#endif

//#define DISABLE_PAIRED_CONNECTION_DEV_LIST_UPD
#undef DISABLE_PAIRED_CONNECTION_DEV_LIST_UPD

/******************************************************************************/
/* CCA MESSAGE MAP                                                            */
/******************************************************************************/
BEGIN_MSG_MAP(FC_Bluetooth_tclCCAService, ahl_tclBaseWork)

/**
 * Message map for method Start
 */


ON_MESSAGE_SVCDATA( MOST_BTSETFI_C_U16_SWITCHBLUETOOTHONOFFEXTENDED,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
      onSwitchBluetoothOnOffExtendedMethodStart )

ON_MESSAGE_SVCDATA( MOST_BTSETFI_C_U16_SCANBLUETOOTHDEVICES,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
      onScanBluetoothDevicesMethodStart )


ON_MESSAGE_SVCDATA( MOST_BTSETFI_C_U16_GETDEVICEINFOEXTENDED,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
      onGetDeviceInfoExtendedMethodStart )

ON_MESSAGE_SVCDATA( MOST_BTSETFI_C_U16_ADDNEWDEVICE,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
      onAddNewDeviceMethodStart )

ON_MESSAGE_SVCDATA( MOST_BTSETFI_C_U16_CHANGEPIN,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
      onChangePinMethodStart )

ON_MESSAGE_SVCDATA( MOST_BTSETFI_C_U16_PAIRINGRESPONSE,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
      onPairingResponseMethodStart )

ON_MESSAGE_SVCDATA( MOST_BTSETFI_C_U16_CHANGEDEVICESTATE,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
      onChangeDeviceStateMethodStart)

ON_MESSAGE_SVCDATA( MOST_BTSETFI_C_U16_REPLACEDEVICE,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
      onReplaceDeviceMethodStart)

ON_MESSAGE_SVCDATA( MOST_BTSETFI_C_U16_CLEARDEVICEINFO,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
      onClearDeviceInfoMethodStart )

ON_MESSAGE_SVCDATA( MOST_BTSETFI_C_U16_CONNECTBLUETOOTHPROFILE,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
      onConnectBluetoothProfileMethodStart )

ON_MESSAGE_SVCDATA( MOST_BTSETFI_C_U16_DISCONNECTBLUETOOTHPROFILE,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
      onDisconnectBluetoothProfileMethodStart )

ON_MESSAGE_SVCDATA( MOST_BTSETFI_C_U16_SENDPAIRINGREQUEST,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
      onSendPairingRequestMethodStart )

ON_MESSAGE_SVCDATA( MOST_BTSETFI_C_U16_PLAYRINGTONE,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
      OnPlayRingtoneMethodStart )

ON_MESSAGE_SVCDATA( MOST_BTSETFI_C_U16_STOPRINGTONE,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
      OnStopRingtoneMethodStart )

ON_MESSAGE_SVCDATA( MOST_BTSETFI_C_U16_REQUESTDEVICERINGTONELIST,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
      OnRequestDeviceRingtonesListMethodStart )

ON_MESSAGE_SVCDATA( MOST_BTSETFI_C_U16_REQUESTAVAILABLERINGTONESLIST,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
      OnRequestAvailableRingtonesListMethodStart )

ON_MESSAGE_SVCDATA( MOST_BTSETFI_C_U16_CONNECTSPPSERVICE,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
      OnConnectSPPServiceMethodStart )

ON_MESSAGE_SVCDATA( MOST_BTSETFI_C_U16_SWITCHBTLOCALMODE,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
      OnSwitchBTLocalModeMethodStart )

ON_MESSAGE_SVCDATA( MOST_BTSETFI_C_U16_STARTAUTOCONNECTSEQUENCE,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
      OnStartAutoConnectSequenceMethodStart )

ON_MESSAGE_SVCDATA( MOST_BTSETFI_C_U16_SETBLUETOOTHLIMITATIONMODE,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
      OnSetBTLimitationModeMethodStart )

ON_MESSAGE_SVCDATA( MOST_BTSETFI_C_U16_CHANGEWIFITRANSMITPOWER,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
      OnChangeWifiTransmitPowerMethodStart )

ON_MESSAGE_SVCDATA( MOST_BTSETFI_C_U16_DISCONNECTSPPSERVICE,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
      OnDisconnectSPPServiceMethodStart )

ON_MESSAGE_SVCDATA( MOST_BTSETFI_C_U16_STARTSEARCHSPPSERVICES,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
      OnStartSearchSPPServicesMethodStart )

ON_MESSAGE_SVCDATA( MOST_BTSETFI_C_U16_STOPSEARCHSPPSERVICES,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
      OnStopSearchSPPServicesMethodStart )

ON_MESSAGE_SVCDATA( MOST_BTSETFI_C_U16_ADDOOBPAIREDDEVICE,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
      OnAddOobPairedDeviceMethodStart )

ON_MESSAGE_SVCDATA( MOST_BTSETFI_C_U16_SETFAVORITE,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
      OnSetFavoriteMethodStart )

ON_MESSAGE_SVCDATA( MOST_BTSETFI_C_U16_CLEARFAVORITE,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
      OnClearFavoriteMethodStart )

ON_MESSAGE_SVCDATA( MOST_BTSETFI_C_U16_SWITCHMULTIHFPSUPPORT,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
      OnSwitchMultiHFPSupportMethodStart )

ON_MESSAGE_SVCDATA( MOST_BTSETFI_C_U16_SETPRIMARY,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
      OnSetPrimaryMethodStart )

ON_MESSAGE_SVCDATA( MOST_BTSETFI_C_U16_SETBTPROFILESUSAGE,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
      OnSetBtPrfoilesUsageMethodStart )

ON_MESSAGE_SVCDATA( MOST_BTSETFI_C_U16_RESOLVECONFLICTS,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
      OnResolveConflictsMethodStart )

ON_MESSAGE_SVCDATA( MOST_BTSETFI_C_U16_SETDEVICEUSAGEPREFERENCE,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
      OnSetDeviceUsagePreferenceMethodStart )

ON_MESSAGE_SVCDATA( MOST_BTSETFI_C_U16_SETPROFILEUSERAVAILABILITY,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
      OnSetProfileUserAvailabilityMethodStart )

ON_MESSAGE_SVCDATA( MOST_BTSETFI_C_U16_REPLACEBLUETOOTHLIMITATIONMODE,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
      OnReplaceBluetoothLimitationModeMethodStart )

END_MSG_MAP()

FC_Bluetooth_tclCCAService* FC_Bluetooth_tclCCAService::m_poCCAService = OSAL_NULL;

/******************************************************************************/
/* FC_Bluetooth_tclCCAService()                                               */
/******************************************************************************/
FC_Bluetooth_tclCCAService::FC_Bluetooth_tclCCAService(fc_bluetooth_tclApp* poMainAppl)
:ahl_tclBaseOneThreadService(
      /* Application Pointer              */poMainAppl,
      /* ID of offered Service            */CCA_C_U16_SRV_FB_BLUETOOTHSETTINGS,
      /* MajorVersion of offered Service  */FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION,
      /* MinoreVersion of offered Service */FC_BLUETOOTH_CCASERVICE_FI_MINOR_VERSION,
      /* PatchVersion of offered Service  */FC_BLUETOOTH_CCASERVICE_FI_PATCH_VERSION)
{
   ENTRY

   _bluetoothApp = poMainAppl;
   FC_Bluetooth_tclCCAService::m_poCCAService = this;
   FC_Bluetooth_CCAMethodQueue::poGetInstance();
   _bIsStopRingtoneinProgress = FALSE;
   _bIsRingtonePlaying = FALSE;
   _pairingState = BM_PAIRING_STATE_UNKNOWN;
   _maxNumPairedDevices = 0;
   _bluetoothswitchState = SWITCH_STATE_SWITCHED_OFF;
   _bProtocolStatusUpdate = false;


   //Clear sorted index list
   _pairedDeviceList._deviceBaseInfoList.clear();
   _u8DeviceHandle = INVALID_DEVICE_HANDLE;
   _e8connectionStatus = BM_CONNECTION_STATUS_UNKNOWN;
   _u8prevDeviceHandle = INVALID_DEVICE_HANDLE;
   _e8prevconnectionStatus = BM_CONNECTION_STATUS_UNKNOWN;

   _u16SystemWideRingtone = RINGTONE_INBAND_RINGTONEID;
   _u8SystemWideDeviceHandle = SYSTEM_WIDE_DEVICEHANDLE;
   _u8PrevRingtoneIDDeviceHandle = INVALID_DEVICE_HANDLE;
   _ringtoneIDInBandSupport = BM_INBAND_RINGTONE_SUPPORT_UNKNOWN;
   _outgoingSourceDeviceHandle = INVALID_DEVICE_HANDLE;
   _bVersionUpdate = FALSE;
   _bPairedDevicelistUpdate = FALSE;
   _bHFPStatusUpdate = FALSE;
   _bDeviceListChangeUpdate = FALSE;
   _bAVPStatusUpdate = FALSE;
   _bPBAPStatusUpdate = FALSE;
   _bMAPStatusUpdate = FALSE;
   _bPANStatusUpdate = FALSE;
   _u8BluetoothAudioDeviceHandle = INVALID_DEVICE_HANDLE;
   _u16PBAPDeviceHandle = INVALID_DEVICE_HANDLE;
   _u16MAPDeviceHandle = INVALID_DEVICE_HANDLE;
   _u16PANDeviceHandle = INVALID_DEVICE_HANDLE;
   _bluetoothAudioVersion = FC_BLUETOOTH_CCASERVICE_ZERO;
   _bUpdateRingtoneStatus = FALSE;
   _inbandRingtoneSupport = BM_INBAND_RINGTONE_SUPPORT_UNKNOWN;
   _initPairedDeviceListReceived = FALSE;
   _bUpdateBtDTCState = FALSE;
   _bStackInitialized = false;
   _vehicleBtAddress = "";

   BdAddress bdAddress("");
   _oFIDataVehicleBTAddress.sVehicleBTAddress.bSet(bdAddress.c_str(),
                     most_fi_tcl_String::FI_EN_UTF8);

   _oFIDataObjectDeviceListExtended.oDeviceListChange.e8DeviceStatus.enType = most_fi_tcl_e8_BTSetDeviceStatus::FI_EN_E8DEVICE_NO_CHANGE;

   PairingPinType pin("");
   _oFIDataPairingRequest.sPinNumber.bSet(pin.c_str(), most_fi_tcl_String::FI_EN_UTF8);

   _oFIDataPairingStatus.u8DeviceHandle = INVALID_DEVICE_HANDLE;
   _oFIDataPairingStatus.e8PairingStatusType.enType = most_fi_tcl_e8_BTSetPairingStatusType::FI_EN_E8PAIRING_STATUS_IDLE;
   _oFIDataBTProfilesUsageInfo.oBTProfilesUsageInfoList.oItems.clear();
   _oFIDataSignalStrength.oSignalStrengthList.oSignalStrengthItems.clear();
   _oFIDataServiceAvailableStatus.e8ServiceAvailable.enType = most_fi_tcl_e8_BTServiceAvailable::FI_EN_E8SERVICE_UNAVAILABLE;

   m_u8Pairable = BT_LOCALMODE_AUTO;
   m_u8Connectable = BT_LOCALMODE_AUTO;
   _bdAAPAddress = "";

   if(access(BT_SERVICE_FILEPATH, F_OK) != -1)
   {
      _bBluetoothServiceIsAvail = true;
   }
   else
   {
      _bBluetoothServiceIsAvail = false;
   }
}

/******************************************************************************/
/* ~FC_Bluetooth_tclCCAService()                                              */
/******************************************************************************/
FC_Bluetooth_tclCCAService::~FC_Bluetooth_tclCCAService()
{
   ENTRY

   _bIsRingtonePlaying = FALSE;
   _bIsStopRingtoneinProgress = FALSE;
   _oFIDataChangeRingtone.vDestroy();
   _oFIDataPairingStatus.vDestroy();
   _oFIDataPairingRequest.vDestroy();
   _oFIDataPairableMode.vDestroy();
   _oFIDataBluetoothOnOff.vDestroy();
   _oFIDataVehicleBTFriendlyNameset.vDestroy();
   _oFIDataVehicleBTAddress.vDestroy();
   _oFIDataVehicleSupportedBTProfiles.vDestroy();
   _oFIDataVehicleBTFriendlyName.vDestroy();
   _oFIDataPairingPin.vDestroy();
   _oFIDataAutoConnectOnOff.vDestroy();
   _oFIDataObjectDeviceListExtended.vDestroy();
   _oFIDataMaxDevicesPaired.vDestroy();
   _oFIDataSignalStrength.vDestroy();
   _oFIDataSPPServiceConnection.vDestroy();
   _oFIDataBluetoothAudioSource.vDestroy();
   _oFIDataAutoConnectionStatus.vDestroy();
   _oFIDataVehicleConfiguration.vDestroy();

   FC_Bluetooth_tclCCAService::m_poCCAService = OSAL_NULL;
   _bluetoothApp = OSAL_NULL;
}

/******************************************************************************/
/* vOnServiceAvailable()                                                      */
/******************************************************************************/
tVoid FC_Bluetooth_tclCCAService::vOnServiceAvailable()
{
   ETG_TRACE_USR1(("vOnServiceAvailable(): entered"));
   return;
}

/******************************************************************************/
/* vOnServiceUnavailable()                                                    */
/******************************************************************************/
tVoid FC_Bluetooth_tclCCAService::vOnServiceUnavailable()
{
   ETG_TRACE_USR1(("vOnServiceUnavailable(): entered"));
   return;
}

/******************************************************************************/
/* bStatusMessageFactory                                                      */
/******************************************************************************/
tBool FC_Bluetooth_tclCCAService::bStatusMessageFactory(tU16 u16FunctionId, amt_tclServiceData& roOutMsg,
      amt_tclServiceData* poInMsg)
{
   (tVoid) poInMsg;
   ENTRY

   tBool bSuccess = false;

   ETG_TRACE_USR2(("bStatusMessageFactory() entered. FID = 0x%4x.", u16FunctionId));

   switch (u16FunctionId)
   {

      case MOST_BTSETFI_C_U16_PAIRINGSTATUS:
      {
         bSuccess = handlePairingStatusGet(roOutMsg);
      }
      break;

      case MOST_BTSETFI_C_U16_VEHICLEBTFRIENDLYNAME:
      {
         bSuccess = handleVehicleFriendlyNameGet(roOutMsg);
      }
      break;

      case MOST_BTSETFI_C_U16_VEHICLEBTFRIENDLYNAMESET:
      {
         bSuccess = handleVehicleFriendlyNameSetStatus(roOutMsg);
      }
      break;

      case MOST_BTSETFI_C_U16_PAIRINGPIN:
      {
         bSuccess = handlePairingPinGet(roOutMsg);
      }
      break;

      case MOST_BTSETFI_C_U16_MAXDEVICESPAIRED:
      {
         bSuccess = handleMaxDevicesPairedGet(roOutMsg);
      }
      break;

      case MOST_BTSETFI_C_U16_BLUETOOTHONOFF:
      {
         bSuccess = handleBluetoothOnOffGet(roOutMsg);
      }
      break;

      case MOST_BTSETFI_C_U16_VEHICLEBTADDRESS:
      {
         bSuccess = handleVehicleBtAddressGet(roOutMsg);
      }
      break;

      case MOST_BTSETFI_C_U16_VEHICLESUPPORTEDBTPROFILES:
      {
         bSuccess = handleVehicleSupportedProfilesGet(roOutMsg);
      }
      break;

      case MOST_BTSETFI_C_U16_AUTOCONNECTONOFF:
      {
         bSuccess = handleAutoconnectOnOffGet(roOutMsg);
      }
      break;

      case MOST_BTSETFI_C_U16_PAIRINGREQUEST:
      {
         bSuccess = handlePairingRequestGet(roOutMsg);
      }
      break;

      case MOST_BTSETFI_C_U16_DEVICELISTEXTENDED:
      {
         bSuccess = handleDeviceListExtendedGet(roOutMsg);
      }
      break;

      case MOST_BTSETFI_C_U16_VISIBLEDEVICES:
      {
         bSuccess = handleVisibleDevicesGet(roOutMsg);
      }
      break;
      case MOST_BTSETFI_C_U16_BLUETOOTHAUDIOSOURCE:
      {
         bSuccess = handleBluetoothAudioSourceGet(roOutMsg);
      }
      break;
      case MOST_BTSETFI_C_U16_CHANGERINGTONE:
      {
         bSuccess = handleChangeRingtoneGet(roOutMsg);
      }
      break;
      case MOST_BTSETFI_C_U16_SIGNALSTRENGTH:
      {
         bSuccess = handleSignalStrengthGet(roOutMsg);
      }
      break;
      case MOST_BTSETFI_C_U16_PAIRABLEMODE:
      {
         bSuccess = handlePairableModeGet(roOutMsg);
      }
      break;
      case MOST_BTSETFI_C_U16_SPPSERVICECONNECTION:
      {
         bSuccess = handleSppServiceConnectionGet(roOutMsg);
      }
      break;
      case MOST_BTSETFI_C_U16_BLUETOOTHLIMITATIONMODE:
      {
         bSuccess = handleBTLimitationModeGet(roOutMsg);
      }
      break;
      case MOST_BTSETFI_C_U16_MULTIHFPSUPPORT:
      {
         bSuccess = handleMultiHFPSupportGet(roOutMsg);
      }
      break;
      case MOST_BTSETFI_C_U16_BTPROFILESUSAGEINFO:
      {
         bSuccess = handleBtProfilesUsageInfoGet(roOutMsg);
      }
      break;
      case MOST_BTSETFI_C_U16_CONFLICTSDETECTED:
      {
         bSuccess = handleConflictDetectedGet(roOutMsg);
      }
      break;
      case MOST_BTSETFI_C_U16_AUTOCONNECTIONSTATUS:
      {
         bSuccess = handleAutoConnectionStatusGet(roOutMsg);
      }
      break;
      case MOST_BTSETFI_C_U16_SERVICEAVAILABLE:
      {
         bSuccess = handleServiceAvailableGet(roOutMsg);
      }
      break;
      case MOST_BTSETFI_C_U16_VEHICLECONFIGURATION:
      {
         bSuccess = handleVehicleConfigurationGet(roOutMsg);
      }
      break;
      default:
         ETG_TRACE_USR4(("Property not found: 'FID = %u'", u16FunctionId));
      break;
   }

   return bSuccess;
}

/*******************************************************************************
 *
 * FUNCTION: vPostLoopBackMessageToCCA()
 *
 * DESCRIPTION:Post Loopback Messages to CCA service thread from Internal component
 *
 * PARAMETER: [IN] tU16 u16CallbackFuncID
 *            [IN] tU32 u32CommandCounter
 *
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
void FC_Bluetooth_tclCCAService::vPostLoopBackMessageToCCA(tU16 u16CallbackFuncID, tU32 u32CommandCounter)
{
   // Create a 'generic message' (with tU32 content), intended to be sent
   // to our own server (loopback message)
   ENTRY

   gm_tclU32Message oServiceReadyMsg(_poMainAppl->u16GetAppId(), // Source AppID
            _poMainAppl->u16GetAppId(), // Target AppID
            0, // RegisterID
            (tU16)u32CommandCounter, // CmdCounter
            CCA_C_U16_SRV_FB_BLUETOOTHSETTINGS, // ServiceID
            BLUETOOTHSETTINGS_C_U16_IFID_INTERNAL, // Function ID
            AMT_C_U8_CCAMSG_OPCODE_STATUS // Opcode
   );

   oServiceReadyMsg.vSetDWord(u16CallbackFuncID);

   // Post message
   ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oServiceReadyMsg, TRUE);

   if (enResult != AIL_EN_N_NO_ERROR)
   {
      ETG_TRACE_FATAL(( "vProcessService: 'ServiceReady' Opcode STATUS: enPostMessage() failed, 'ail_tenCommunicationError' = %u", (tU32)enResult ));
   }
}

/*******************************************************************************
 *
 * FUNCTION    : tVoid FC_Bluetooth_tclCCAService::vOnLoopbackService(amt_tclServiceData* poMessage)
 *
 * DESCRIPTION : This function is called from the vOnLoopback() function of this
 *               CCA application if a message from one of this applications
 *               services is received (so called self or loopback messages).
 *
 * PARAMETER   : [IN] u16ServiceID = Identifier of the service from where the
 *                                message was sent.
 *               [IN] poMessage = Message object.
 *
 * RETURNVALUE: -
 *
 *******************************************************************************/
tVoid FC_Bluetooth_tclCCAService::vOnLoopbackService(amt_tclServiceData* poMessage)
{
   ENTRY

   gm_tclU32Message oVisitorMsg(poMessage);
   LoopBackMessageData oLoopBackMessageData;

   tU16 u16FunctionId = poMessage->u16GetFunctionID();
   tU16 u16CmdCounter = poMessage->u16GetCmdCounter();
   tU32 u32MsgContent = oVisitorMsg.u32GetDWord();

   ETG_TRACE_USR1(("vOnLoopbackService():iFID = 0x%4x, u32MsgContent = %u", ETG_CENUM(enFunctionID,u16FunctionId), ETG_CENUM(enMessageContentID,u32MsgContent)));

   FC_Bluetooth_Loopback_Controller * poLoopbackController = FC_Bluetooth_Loopback_Controller::poGetInstance();

   if (poLoopbackController)
   {
      switch (u16FunctionId)
      {
         case BLUETOOTHSETTINGS_C_U16_IFID_INTERNAL:
         {
            switch (u32MsgContent)
            {
               case BTSET_BMCORE_MSG_SWITCHBTSTATUS_RESPONSE:
               {
                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_SWITCHBTSTATUS_RESPONSE:result - %d",oLoopBackMessageData.result));

                  if (BM_RESULT_OK != oLoopBackMessageData.result)
                  {
                     funcResponseError(SWITCHBTONOFF_METHOD_FKTID, most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC, REMOVE_PARTICULAR_METHOD);
                     funcResponseError(SWITCHBTONOFFEXT_METHOD_FKTID, most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC, REMOVE_PARTICULAR_METHOD);
                  }
                  else
                  {
                     // TODO: This logic need to be revisited
                     SwitchState switchState;
                     vGetBluetoothOnOff(switchState);

                     // Checking for same request is received from clients if already BT is ON or OFF.
                     if((switchState == SWITCH_STATE_SWITCHED_ON) || (switchState == SWITCH_STATE_SWITCHED_OFF))
                     {
                        updateBTOnOffExtenedMR(switchState, true);
                     }
                  }
               }
               break;
               case BTSET_BMCORE_MSG_SWITCHBTSTATUS_CHANGED:
               {
                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_SWITCHBTSTATUS_CHANGED:entered"));

                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  if (oLoopBackMessageData.vpData)
                  {
                     SwitchStatus* status = NULL;

                     status = (SwitchStatus*) oLoopBackMessageData.vpData;

                     vUpdateBluetoothOnOff(status->_switchState);

                     OSAL_DELETE status;
                  }
               }
               break;
               case BTSET_BMCORE_MSG_SWITCHDISCOVERYSTATUS_RESPONSE:
               {
                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_SWITCHDISCOVERYSTATUS_RESPONSE:result - %d",oLoopBackMessageData.result));

                  if (BM_RESULT_OK != oLoopBackMessageData.result)
                  {
                     funcResponseError(SCANBTDEVICES_METHOD_FKTID, most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC, REMOVE_PARTICULAR_METHOD);
                  }
                  else
                  {
                     // TODO: This logic need to be revisited
                     SwitchStatus switchStatus;
                     vGetDiscoveryStatus(switchStatus);

                     // Checking for same request is received from clients if already BT is ON or OFF.
                     if((switchStatus._switchState == SWITCH_STATE_SWITCHED_ON) || (switchStatus._switchState == SWITCH_STATE_SWITCHED_OFF))
                     {
                        vUpdateDiscoveryStatus(switchStatus);
                     }
                  }
               }
               break;
               case BTSET_BMCORE_MSG_CONNECTPROFILERESPONSE:
               {
                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_CONNECTPROFILERESPONSE:result - %d",oLoopBackMessageData.result));

                  DeviceConnectionStatusList deviceConnectionStatusList;
                  vGetDeviceConnectionStatusList(deviceConnectionStatusList);

                  ConnectProfileResponse(deviceConnectionStatusList, TRUE, oLoopBackMessageData.result);
               }
               break;
               case BTSET_BMCORE_MSG_DISCONNECTPROFILERESPONSE:
               {
                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_DISCONNECTPROFILERESPONSE:result - %d",oLoopBackMessageData.result));

                  DeviceConnectionStatusList deviceConnectionStatusList;
                  vGetDeviceConnectionStatusList(deviceConnectionStatusList);

                  DisconnectProfileResponse(deviceConnectionStatusList, TRUE, oLoopBackMessageData.result);
               }
               break;
               case BTSET_BMCORE_MSG_BLOCKDEVICERESPONSE:
               {
                  // Read the loopback data from queue
                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_BLOCKDEVICERESPONSE:result - %d",oLoopBackMessageData.result));

                  BlockStatus blockStatus;
                  vGetBlockStatus(blockStatus);

                  vBlockAndUnblockProfileResponse(blockStatus, TRUE, oLoopBackMessageData.result);
               }
               break;
               case BTSET_BMCORE_MSG_UNBLOCKDEVICERSPONSE:
               {
                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_UNBLOCKDEVICERSPONSE:result - %d",oLoopBackMessageData.result));

                  BlockStatus blockStatus;
                  vGetBlockStatus(blockStatus);

                  vBlockAndUnblockProfileResponse(blockStatus, TRUE, oLoopBackMessageData.result);
               }
               break;
               case BTSET_BMCORE_MSG_BLOCKPROFILERESPONSE:
               {
                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_BLOCKPROFILERESPONSE:result - %d",oLoopBackMessageData.result));
               }
               break;
               case BTSET_BMCORE_MSG_UNBLOCKPROFILERESPONSE:
               {
                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_UNBLOCKPROFILERESPONSE:result - %d",oLoopBackMessageData.result));

                  if(oLoopBackMessageData.vpData)
                  {
                     DeviceId* deviceId = NULL;
                     ProtocolList protocolList;
                     Protocol protocol;

                     protocolList.clear();
                     protocol._protocolId = BM_PROTOCOL_ID_AVP;
                     protocol._uuid = "";
                     protocolList.push_back(protocol);

                     deviceId = (DeviceId*) oLoopBackMessageData.vpData;

                     ETG_TRACE_USR1(("BTSET_BMCORE_MSG_UNBLOCKPROFILERESPONSE:deviceId - %d", *deviceId));

                     enBlockInfo blockAVPStatus;
                     getBlockInfoStauts(*deviceId, blockAVPStatus);

                     if(blockAVPStatus == AVP_DISCONNECT_BLOCKED)
                     {
                        Job connectProfile;
                        connectProfile.u16FunctionID = DUMMY_METHOD_FKID;
                        connectProfile.bResponse = false;
                        connectProfile.poMethodArg = OSAL_NULL;

                        FC_Bluetooth_CCAMethodQueue::poGetInstance()->PushMethodContext(CONNECTPROFILE_METHOD_FKTID, connectProfile);

                        if (_bluetoothApp)
                        {
                           _bluetoothApp->getBmCoreRequestIf().connectProfiles(*deviceId, protocolList);
                        }
                     }

                     setBlockInfoStauts(*deviceId, AVP_UNBLOCKED);

                     OSAL_DELETE deviceId;
                  }
               }
               break;
               case BTSET_BMCORE_MSG_UPDATE_CONFIGURATION:
               {
                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_UPDATE_CONFIGURATION:entered"));

                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  if(oLoopBackMessageData.vpData)
                  {
                     BmCoreConfiguration* configData = OSAL_NULL;

                     configData = (BmCoreConfiguration*)oLoopBackMessageData.vpData;

                     vUpdateConfiguration(*configData);

                     OSAL_DELETE configData;
                  }
               }
               break;
               case BTSET_BMCORE_MSG_SWITCHDISCOVERYSTATUS_CHANGED:
               {
                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_SWITCHDISCOVERYSTATUS_CHANGED:entered"));

                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  if(oLoopBackMessageData.vpData)
                  {
                     SwitchStatus* status = NULL;

                     status = (SwitchStatus*)oLoopBackMessageData.vpData;

                     vUpdateDiscoveryStatus(*status);

                     OSAL_DELETE status;
                  }
               }
               break;
               case BTSET_BMCORE_MSG_STARTAUTOCONNECT:
               {
                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_STARTAUTOCONNECT:result - %d",oLoopBackMessageData.result));

                  StartAutoconnectSeqResponse(oLoopBackMessageData.result);
               }
               break;
               case BTSET_BMCORE_MSG_PAIRINGRESPONSE:
               {
                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_PAIRINGRESPONSE:result - %d",oLoopBackMessageData.result));

                  PairingStatus btPairingStatus;
                  vGetPairingStatus(btPairingStatus);

                  updatePairingResponse(btPairingStatus, TRUE, oLoopBackMessageData.result);
               }
               break;
               case BTSET_BMCORE_MSG_SENDPAIRINGREQUESTRESPONSE:
               {
                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_SENDPAIRINGREQUESTRESPONSE:result - %d",oLoopBackMessageData.result));

                  if (BM_RESULT_OK != oLoopBackMessageData.result)
                  {
                     funcResponseError(SENDPAIRINGREQUEST_METHOD_FKTID, most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC, REMOVE_PARTICULAR_METHOD);
                  }
               }
               break;
               case BTSET_BMCORE_MSG_CHANGEDEVICESTATERESPONSE:
               {
                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_CHANGEDEVICESTATERESPONSE:result - %d",oLoopBackMessageData.result));

                  PairedDeviceList pairedDeviceList;
                  vGetPairedDeviceList(pairedDeviceList);

                  ChangeDeviceStateResponse(pairedDeviceList, TRUE, oLoopBackMessageData.result);
               }
               break;
               case BTSET_BMCORE_MSG_BTLIMITATIONMODERESPONSE:
               {
                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_BTLIMITATIONMODERESPONSE:result - %d",oLoopBackMessageData.result));

                  if (BM_RESULT_OK != oLoopBackMessageData.result)
                  {
                     funcResponseError(SETBTLIMITATIONMODE_METHOD_FKTID, most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC, REMOVE_PARTICULAR_METHOD);
                  }
                  else
                  {
                     sendMethodResult(SETBTLIMITATIONMODE_METHOD_FKTID);
                  }
               }
               break;
               case BTSET_BMCORE_MSG_SWITCHLOCALPAIRABLEMODERESPONSE:
               {
                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_SWITCHLOCALPAIRABLEMODERESPONSE:result - %d",oLoopBackMessageData.result));

                  SwitchLocalPairableModeResponse(oLoopBackMessageData.result);
               }
               break;
               case BTSET_BMCORE_MSG_SWITCHLOCALCONNECTABLEMODERESPONSE:
               {
                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_SWITCHLOCALCONNECTABLEMODERESPONSE:result - %d",oLoopBackMessageData.result));

                  SwitchLocalConnectableModeResponse(oLoopBackMessageData.result);
               }
               break;
               case BTSET_BMCORE_MSG_CLEARDEVICEINFORESPONSE:
               {
                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_CLEARDEVICEINFORESPONSE:result - %d",oLoopBackMessageData.result));

                  if (BM_RESULT_OK != oLoopBackMessageData.result)
                  {
                     funcResponseError(CLEARDEVICEINFO_METHOD_FKTID, most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC, REMOVE_PARTICULAR_METHOD);
                  }
                  else
                  {
                     sendMethodResult(CLEARDEVICEINFO_METHOD_FKTID);
                     updateRingtoneValues(TRUE);
                  }
               }
               break;
               case BTSET_BMCORE_MSG_ADDOOBPAIREDDEVICERESPONSE:
               {
                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_ADDOOBPAIREDDEVICERESPONSE:result - %d",oLoopBackMessageData.result));

                  AddOobPairedDeviceResponse(oLoopBackMessageData.result);
               }
               break;
               case BTSET_BMCORE_MSG_SETFAVORITERESPONSE:
               {
                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_SETFAVORITERESPONSE:result - %d",oLoopBackMessageData.result));

                  SetFavoriteResponse(oLoopBackMessageData.result);
               }
               break;
               case BTSET_BMCORE_MSG_CLEARFAVORITERESPONSE:
               {
                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_CLEARFAVORITERESPONSE:result - %d",oLoopBackMessageData.result));

                  ClearFavoriteResponse(oLoopBackMessageData.result);
               }
               break;
               case BTSET_BMCORE_MSG_STARTSERVICESEARCHRESPONSE:
               {
                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_STARTSERVICESEARCHRESPONSE:result - %d",oLoopBackMessageData.result));

                  StartServiceSearchResponse(oLoopBackMessageData.result);
               }
               break;
               case BTSET_BMCORE_MSG_STOPSERVICESEARCHRESPONSE:
               {
                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_STOPSERVICESEARCHRESPONSE:result - %d",oLoopBackMessageData.result));

                  StopServiceSearchResponse(oLoopBackMessageData.result);
               }
               break;
               case BTSET_BMCORE_MSG_SWITCHMULTIHFPSUPPORTRESPONSE:
               {
                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_SWITCHMULTIHFPSUPPORTRESPONSE:result - %d",oLoopBackMessageData.result));

                  MultiHFPSupportResponse(oLoopBackMessageData.result);
               }
               break;
               case BTSET_BMCORE_MSG_SETDEVICEUSAGEPREFERENCERESPONSE:
               {
                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_SETDEVICEUSAGEPREFERENCERESPONSE:result - %d",oLoopBackMessageData.result));

                  SetDeviceUsagePreferenceResponse(oLoopBackMessageData.result);
               }
               break;
               case BTSET_BMCORE_MSG_SETPRIMARYRESPONSE:
               {
                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_SETPRIMARYRESPONSE:result - %d",oLoopBackMessageData.result));

                  SetPrimaryResponse(oLoopBackMessageData.result);
               }
               break;
               case BTSET_BMCORE_MSG_SETBTPROFILEUSAGEINFORESPONSE:
               {
                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_SETBTPROFILEUSAGEINFORESPONSE:result - %d",oLoopBackMessageData.result));

                  SetBtPrfoilesUsageInfoResponse(oLoopBackMessageData.result);
               }
               break;
               case BTSET_BMCORE_MSG_NOTIFYUSERDECISIONRESPONSE:
               {
                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_NOTIFYUSERDECISIONRESPONSE:result - %d",oLoopBackMessageData.result));

                  ResolveConflictsResponse(oLoopBackMessageData.result);
               }
               break;
               case BTSET_BMCORE_MSG_SETPROFILEUSERAVAILABILITYRESPONSE:
               {
                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_SETPROFILEUSERAVAILABILITYRESPONSE:result - %d",oLoopBackMessageData.result));

                  SetProfileUserAvailabilityResponse(oLoopBackMessageData.result);
               }
               break;
               case BTSET_BMCORE_MSG_REPLACEBTLIMITATIONMODERESPONSE:
               {
                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_REPLACEBLUETOOTHLIMITATIONMODERESPONSE:result - %d",oLoopBackMessageData.result));

                  ReplaceBluetoothLimitationModeResponse(oLoopBackMessageData.result);
               }
               break;
               case BTSET_BMCORE_MSG_PAIRINGPIN:
               {
                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_PAIRINGPIN:result - %d",oLoopBackMessageData.result));

                  if (BM_RESULT_OK != oLoopBackMessageData.result)
                  {
                     funcResponseError(CHANGEPIN_METHOD_FKTID, most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC, REMOVE_PARTICULAR_METHOD);
                  }
                  else
                  {
                     if(oLoopBackMessageData.vpData)
                     {
                        PairingPin* pin = NULL;

                        pin = (PairingPin*)oLoopBackMessageData.vpData;

                        vUpdatePairingPin(pin->_pin);

                        OSAL_DELETE pin;
                     }
                  }
               }
               break;
               case BTSET_BMCORE_MSG_PAIRINGSTATUS_CHANGED:
               {
                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_PAIRINGSTATUS_CHANGED entered"));

                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  if(oLoopBackMessageData.vpData)
                  {
                     PairingStatus* status = NULL;

                     status = (PairingStatus*)oLoopBackMessageData.vpData;

                     vPairingStatusChanged(*status);

                     OSAL_DELETE status;
                  }

               }
               break;
               case BTSET_BMCORE_MSG_LOCALPAIRABLEMODE_CHANGED:
               {
                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_LOCALPAIRABLEMODE_CHANGED: enterd"));

                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  if(oLoopBackMessageData.vpData)
                  {
                     SwitchStatus* status = NULL;

                     status = (SwitchStatus*)oLoopBackMessageData.vpData;

                     vUpdatePairableMode(LOCALPAIRABLEMODECHANGED, status->_switchState);

                     OSAL_DELETE status;
                  }
               }
               break;
               case BTSET_BMCORE_MSG_LOCALCONNECTABLEMODE_CHANGED:
               {
                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_LOCALCONNECTABLEMODE_CHANGED: enterd"));

                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  if(oLoopBackMessageData.vpData)
                  {
                     SwitchStatus* status = NULL;

                     status = (SwitchStatus*)oLoopBackMessageData.vpData;

                     vUpdatePairableMode(LOCALCONNECTABLEMODECHANGED, status->_switchState);

                     OSAL_DELETE status;
                  }
               }
               break;
               case BTSET_BMCORE_MSG_BMCONFIGDATA_CHANGED:
               {
                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_BMCONFIGDATA_CHANGED: enterd"));

                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  if(oLoopBackMessageData.vpData)
                  {
                     BmConfigData* configData = NULL;

                     configData = (BmConfigData*)oLoopBackMessageData.vpData;

                     vUpdateBmConfigData(*configData);

                     OSAL_DELETE configData;
                  }
               }
               break;
               case BTSET_BMCORE_MSG_BMSERVICEAVAILABILITY_CHANGED:
               {
                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_BMSERVICEAVAILABILITY_CHANGED: enterd"));

                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  if(oLoopBackMessageData.vpData)
                  {
                     BmServiceAvailability* serviceAvailability = NULL;

                     serviceAvailability = (BmServiceAvailability*)oLoopBackMessageData.vpData;

                     vUpdateBmServiceAvailability(*serviceAvailability);

                     OSAL_DELETE serviceAvailability;
                  }
               }
               break;
               case BTSET_BMCORE_MSG_AUTOCONNECTIONTYPE_CHANGED:
               {
                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_AUTOCONNECTIONTYPE_CHANGED: enterd"));

                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  if(oLoopBackMessageData.vpData)
                  {
                     AutoConnectionType* connectionType = NULL;

                     connectionType = (AutoConnectionType*)oLoopBackMessageData.vpData;

                     vUpdateAutoConnectOnOff(connectionType->_type);

                     OSAL_DELETE connectionType;
                  }
               }
               break;
               case BTSET_BMCORE_MSG_LOCALFRIENDLYNAME_CHANGED:
               {
                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_LOCALFRIENDLYNAME_CHANGED: enterd"));

                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  if(oLoopBackMessageData.vpData)
                  {
                     LocalFriendlyName* friendlyName = NULL;

                     friendlyName = (LocalFriendlyName*)oLoopBackMessageData.vpData;

                     vUpdateBtLocalFriendlyNameSet(friendlyName->_localFriendlyName);

                     OSAL_DELETE friendlyName;
                  }
               }
               break;
               case BTSET_BMCORE_MSG_BTLOCALINFO_CHANGED:
               {
                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_BTLOCALINFO_CHANGED: enterd"));

                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  if(oLoopBackMessageData.vpData)
                  {
                     LocalInfo* localInfo = NULL;

                     localInfo = (LocalInfo*)oLoopBackMessageData.vpData;

                     vUpdateVehicleBtAddress(localInfo->_bdAddress);
                     vUpdateVehicleSupportedProfiles(localInfo->_protocolInfos);
                     vUpdateVehicleFriendlyName(localInfo->_bdName);
                     vUpdateStackInitialized(localInfo->_stackInitialized);
                     vUpdateVehicleConfiguration(*localInfo);
                     OSAL_DELETE localInfo;
                  }
               }
               break;
               case BTSET_BMCORE_MSG_PAIREDDEVICELIST_CHANGED:
               {
                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_PAIREDDEVICELIST_CHANGED: enterd"));

                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  if(oLoopBackMessageData.vpData)
                  {
                     PairedDeviceList* pairedDeviceList = NULL;

                     pairedDeviceList = (PairedDeviceList*)oLoopBackMessageData.vpData;

#ifndef DISABLE_PAIRED_CONNECTION_DEV_LIST_UPD
                     vUpdatePairedList(*pairedDeviceList);

                     vMaxDevicesPairedReached(*pairedDeviceList);
#endif

#ifdef VARIANT_S_FTR_ENABLE_FW_MEMORY_CHECKER
                     FW_MEMORY_CHECK_DEL_OBJ(pairedDeviceList);
#endif

                     OSAL_DELETE pairedDeviceList;
                  }
               }
               break;
               case BTSET_BMCORE_MSG_CONNECTIONDEVICELIST_CHANGED:
               {
                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_CONNECTIONDEVICELIST_CHANGED: enterd"));

                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  if(oLoopBackMessageData.vpData)
                  {
                     DeviceConnectionStatusList* deviceConnectionStatusList = NULL;

                     deviceConnectionStatusList = (DeviceConnectionStatusList*)oLoopBackMessageData.vpData;

#ifndef DISABLE_PAIRED_CONNECTION_DEV_LIST_UPD
                     vUpdateConnectionStatusList(*deviceConnectionStatusList);
#endif

#ifdef VARIANT_S_FTR_ENABLE_FW_MEMORY_CHECKER
                     FW_MEMORY_CHECK_DEL_OBJ(deviceConnectionStatusList);
#endif

                     OSAL_DELETE deviceConnectionStatusList;
                  }
               }
               break;
               case BTSET_BMCORE_MSG_BLOCKSTATUS_CHANGED:
               {
                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_BLOCKSTATUS_CHANGED: enterd"));

                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  if(oLoopBackMessageData.vpData)
                  {
                     BlockStatus* blockStatus = NULL;

                     blockStatus = (BlockStatus*)oLoopBackMessageData.vpData;

                     vUpdateBlockStatus(*blockStatus);

                     OSAL_DELETE blockStatus;
                  }
               }
               break;
               case BTSET_BMCORE_MSG_BTLIMITATIONMODE_CHANGED:
               {
                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_BTLIMITATIONMODE_CHANGED: entered"));

                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  if(oLoopBackMessageData.vpData)
                  {
                     BtLimitationMode* btLimitationMode = NULL;

                     btLimitationMode = (BtLimitationMode*)oLoopBackMessageData.vpData;

                     vUpdateBtLimitationMode(*btLimitationMode);

                     OSAL_DELETE btLimitationMode;
                  }
               }
               break;
               case BTSET_BMCORE_MSG_DISCOVERDEVICELIST_CHANGED:
               {
                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_DISCOVERDEVICELIST_CHANGED: entered"));

                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  if(oLoopBackMessageData.vpData)
                  {
                     DiscoveredDeviceList* discoveredDeviceList = NULL;

                     discoveredDeviceList = (DiscoveredDeviceList*)oLoopBackMessageData.vpData;

                     vUpdateDiscoveredDeviceList(*discoveredDeviceList);

                     OSAL_DELETE discoveredDeviceList;
                  }
               }
               break;
               case BTSET_BMCORE_MSG_DISCOVERDEVICE_CHANGED:
               {
                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_DISCOVERDEVICE_CHANGED: entered"));

                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  if(oLoopBackMessageData.vpData)
                  {
                     DiscoveredDevice* discoveredDevice = NULL;

                     discoveredDevice = (DiscoveredDevice*)oLoopBackMessageData.vpData;

                     //Need to be update

                     OSAL_DELETE discoveredDevice;
                  }
               }
               break;
               case BTSET_BMCORE_MSG_LINKQUALITY_CHANGED:
               {
                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_LINKQUALITY_CHANGED: entered"));

                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  if(oLoopBackMessageData.vpData)
                  {
                     LinkQuality* linkQuality = NULL;

                     linkQuality = (LinkQuality*)oLoopBackMessageData.vpData;

                     vUpdateRssiValue(*linkQuality);

                     OSAL_DELETE linkQuality;
                  }
               }
               break;
               case BTSET_BMCORE_MSG_TESTMODE_LINKQUALITY_CHANGED:
               {
                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_TESTMODE_LINKQUALITY_CHANGED: entered"));

                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  if(oLoopBackMessageData.vpData)
                  {
                     TestModeLinkQuality* testModeLinkQuality = NULL;

                     testModeLinkQuality = (TestModeLinkQuality*)oLoopBackMessageData.vpData;

                     vUpdateLinkQualityTestMode(testModeLinkQuality->_linkQualityInfo);

                     OSAL_DELETE testModeLinkQuality;
                  }
               }
               break;
               case BTSET_BMCORE_MSG_MULTIHFPSUPPORT_CHANGED:
               {
                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_MULTIHFPSUPPORT_CHANGED:entered"));

                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  if (oLoopBackMessageData.vpData)
                  {
                     SwitchStatus* status = NULL;

                     status = (SwitchStatus*) oLoopBackMessageData.vpData;

                     vUpdateMultiHFPSupportStatus(status->_switchState);

                     OSAL_DELETE status;
                  }
               }
               break;
               case BTSET_BMCORE_MSG_BTPROFILEUSAGEINFO_CHANGED:
               {
                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_BTPROFILEUSAGEINFO_CHANGED:entered"));

                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  if (oLoopBackMessageData.vpData)
                  {
                     ProfileUsageList* profileUsageList = NULL;

                     profileUsageList = (ProfileUsageList*) oLoopBackMessageData.vpData;

                     vUpdateProfileUsageList(*profileUsageList);

                     OSAL_DELETE profileUsageList;
                  }
               }
               break;
               case BTSET_BMCORE_MSG_USERDECISIONREQUIRED_CHANGED:
               {
                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_BTPROFILEUSAGEINFO_CHANGED:entered"));

                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  if (oLoopBackMessageData.vpData)
                  {
                     IssueInfoList* issueInfoList = NULL;

                     issueInfoList = (IssueInfoList*) oLoopBackMessageData.vpData;

                     vUpdateIssueInfoList(*issueInfoList);

                     OSAL_DELETE issueInfoList;
                  }
               }
               break;
               case BTSET_BMCORE_MSG_AUTOCONNECTIONSTATUS_CHANGED:
               {
                  ETG_TRACE_USR1(("BTSET_BMCORE_MSG_AUTOCONNECTIONSTATUS_CHANGED:entered"));

                  oLoopBackMessageData = poLoopbackController->poGetData(u32MsgContent, u16CmdCounter);

                  if (oLoopBackMessageData.vpData)
                  {
                     AutoConnectionStatus* status = NULL;

                     status = (AutoConnectionStatus*) oLoopBackMessageData.vpData;

                     vUpdateAutoConnectionStatus(*status);

                     OSAL_DELETE status;
                  }
               }
               break;
               default:
               {
                  ETG_TRACE_ERR(("vOnLoopbackService(). Unknown u32MsgContent"));
               }
               break;
            }

            //remove data from the queue
            poLoopbackController->vDeleteData(u32MsgContent, u16CmdCounter);

         } //Internal FunctionID

         break;
         default:
         {
            ETG_TRACE_ERR(("vOnLoopbackService(). Unknown iFID"));
         }
         break;
      }
   }

   ETG_TRACE_USR1(("vOnLoopbackService() end"));
}

tVoid FC_Bluetooth_tclCCAService::vUpdateConfiguration(const BmCoreConfiguration& bmCoreConfiguration)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("vUpdateConfiguration() entered"));

   _bmCoreConfiguration._btModuleName = bmCoreConfiguration._btModuleName;
   _bmCoreConfiguration._btLocalFriendlyName = bmCoreConfiguration._btLocalFriendlyName;
   _bmCoreConfiguration._btLocalBdAddress = bmCoreConfiguration._btLocalBdAddress;
   _bmCoreConfiguration._didSpecificationId = bmCoreConfiguration._didSpecificationId;
   _bmCoreConfiguration._didVendorId = bmCoreConfiguration._didVendorId;
   _bmCoreConfiguration._didProductId = bmCoreConfiguration._didProductId;
   _bmCoreConfiguration._didVersion = bmCoreConfiguration._didVersion;
   _bmCoreConfiguration._didVendorIdSource = bmCoreConfiguration._didVendorIdSource;
   _bmCoreConfiguration._didClientExecutableUrl = bmCoreConfiguration._didClientExecutableUrl;
   _bmCoreConfiguration._didServiceDescription = bmCoreConfiguration._didServiceDescription;
   _bmCoreConfiguration._didClientDocumentationUrl = bmCoreConfiguration._didClientDocumentationUrl;
   _bmCoreConfiguration._carPlayWirelessSupported = bmCoreConfiguration._carPlayWirelessSupported;
   _bmCoreConfiguration._wideBandSpeechEnabled = bmCoreConfiguration._wideBandSpeechEnabled;
   _bmCoreConfiguration._pbdlViaPbapEnabled = bmCoreConfiguration._pbdlViaPbapEnabled;
   _bmCoreConfiguration._pbdlViaHfpEnabled = bmCoreConfiguration._pbdlViaHfpEnabled;
   _bmCoreConfiguration._pbdlViaSppEnabled = bmCoreConfiguration._pbdlViaSppEnabled;
   _bmCoreConfiguration._pbdlViaSyncMlEnabled = bmCoreConfiguration._pbdlViaSyncMlEnabled;
   _bmCoreConfiguration._voiceRecognitionEnabled = bmCoreConfiguration._voiceRecognitionEnabled;
   _bmCoreConfiguration._enhancedCallControlEnabled = bmCoreConfiguration._enhancedCallControlEnabled;
   _bmCoreConfiguration._avrcpBrowsingEnabled = bmCoreConfiguration._avrcpBrowsingEnabled;
   _bmCoreConfiguration._audioCodecMp3Enabled = bmCoreConfiguration._audioCodecMp3Enabled;
   _bmCoreConfiguration._audioCodecAacEnabled = bmCoreConfiguration._audioCodecAacEnabled;
   _bmCoreConfiguration._maxNumPairedDevices = bmCoreConfiguration._maxNumPairedDevices;
   _bmCoreConfiguration._maxNumConnectedDevices = bmCoreConfiguration._maxNumConnectedDevices;
   _bmCoreConfiguration._defaultBtStatus = bmCoreConfiguration._defaultBtStatus;
   _bmCoreConfiguration._defaultLocalPairableMode = bmCoreConfiguration._defaultLocalPairableMode;
   _bmCoreConfiguration._defaultLocalConnectableMode = bmCoreConfiguration._defaultLocalConnectableMode;
   _bmCoreConfiguration._localPairableTimeoutSeconds = bmCoreConfiguration._localPairableTimeoutSeconds;
   _bmCoreConfiguration._localConnectableTimeoutSeconds = bmCoreConfiguration._localConnectableTimeoutSeconds;
   _bmCoreConfiguration._useFixedPinLegacyPairing = bmCoreConfiguration._useFixedPinLegacyPairing;
   _bmCoreConfiguration._pinLengthLegacyPairing = bmCoreConfiguration._pinLengthLegacyPairing;
   _bmCoreConfiguration._defaultFixedPinLegacyPairing = bmCoreConfiguration._defaultFixedPinLegacyPairing;
   _bmCoreConfiguration._autoConfirmRemoteLegacyPairingRequest = bmCoreConfiguration._autoConfirmRemoteLegacyPairingRequest;
   _bmCoreConfiguration._autoConfirmLocalLegacyPairingRequest = bmCoreConfiguration._autoConfirmLocalLegacyPairingRequest;
   _bmCoreConfiguration._autoConfirmRemoteSecureSimplePairingRequest = bmCoreConfiguration._autoConfirmRemoteSecureSimplePairingRequest;
   _bmCoreConfiguration._autoConfirmLocalSecureSimplePairingRequest = bmCoreConfiguration._autoConfirmLocalSecureSimplePairingRequest;
   _bmCoreConfiguration._allowLegacyPairingRetry = bmCoreConfiguration._allowLegacyPairingRetry;
   _bmCoreConfiguration._lostDeviceConnectionRetryDelayMilliSeconds = bmCoreConfiguration._lostDeviceConnectionRetryDelayMilliSeconds;
   _bmCoreConfiguration._localProtocolConnectingDelaySeconds = bmCoreConfiguration._localProtocolConnectingDelaySeconds;
   _bmCoreConfiguration._protocolDisconnectingTimeoutSeconds = bmCoreConfiguration._protocolDisconnectingTimeoutSeconds;
   _bmCoreConfiguration._defaultStandardAutoConnectionType = bmCoreConfiguration._defaultStandardAutoConnectionType;
   _bmCoreConfiguration._startAutoConnectionOnStartUp = bmCoreConfiguration._startAutoConnectionOnStartUp;
   _bmCoreConfiguration._linkQualityRequestTimeOut = bmCoreConfiguration._linkQualityRequestTimeOut;
   _bmCoreConfiguration._blockAllProtocolsForNonProjectionDevices = bmCoreConfiguration._blockAllProtocolsForNonProjectionDevices;
   _bmCoreConfiguration._connectAfterPairing = bmCoreConfiguration._connectAfterPairing;
   _bmCoreConfiguration._iapEnabled = bmCoreConfiguration._iapEnabled;
   _bmCoreConfiguration._defaultmultiHFPSupport = bmCoreConfiguration._defaultmultiHFPSupport;
   _bmCoreConfiguration._systemWideRingtoneEnabled = bmCoreConfiguration._systemWideRingtoneEnabled;
   _bmCoreConfiguration._blockDeviceRemoteConnectionsTimeoutSeconds = bmCoreConfiguration._blockDeviceRemoteConnectionsTimeoutSeconds;
   _bmCoreConfiguration._updateConflictDuringCPWOOBPairing = bmCoreConfiguration._updateConflictDuringCPWOOBPairing;
   _bmCoreConfiguration._CPWReconnectTimeoutInSecs = bmCoreConfiguration._CPWReconnectTimeoutInSecs;
   _bmCoreConfiguration._enableDefaultActionAtEndOfBtLimitation = bmCoreConfiguration._enableDefaultActionAtEndOfBtLimitation;
   _bmCoreConfiguration._deleteDeviceDuringOOBTPairing = bmCoreConfiguration._deleteDeviceDuringOOBTPairing;
   _bmCoreConfiguration._serviceSearchTimeoutSeconds = bmCoreConfiguration._serviceSearchTimeoutSeconds;
   _bmCoreConfiguration._defaultConnectionPageTimeoutMilliSeconds = bmCoreConfiguration._defaultConnectionPageTimeoutMilliSeconds;
   _bmCoreConfiguration._delayAutoConnectionAtEndOfBtLimitationInSec = bmCoreConfiguration._delayAutoConnectionAtEndOfBtLimitationInSec;

   for (WifiHealthinessIndicatorInformation::const_iterator it = bmCoreConfiguration._wifiHealthinessIndicatorInformation.begin();
         it != bmCoreConfiguration._wifiHealthinessIndicatorInformation.end(); ++it)
   {
      WifiHealthinessIndicatorInfo wifiHealthinessIndicatorInfo;

      wifiHealthinessIndicatorInfo._wifiHealthinessIndicatorThresholdValue = it->_wifiHealthinessIndicatorThresholdValue;
      wifiHealthinessIndicatorInfo._connectionPageTimeoutMilliSeconds = it->_connectionPageTimeoutMilliSeconds;

      _bmCoreConfiguration._wifiHealthinessIndicatorInformation.push_back(wifiHealthinessIndicatorInfo);
   }

   ETG_TRACE_USR4(("vUpdateConfiguration(): _wifiHealthinessIndicatorInformation.size() - %u", _bmCoreConfiguration._wifiHealthinessIndicatorInformation.size()));

   for (SppServiceInformation::const_iterator it = bmCoreConfiguration._sppServiceInformation.begin();
         it != bmCoreConfiguration._sppServiceInformation.end(); ++it)
   {
      SppServiceInfo sppServiceInfo;

      sppServiceInfo._maxNumInstances = it->_maxNumInstances;
      sppServiceInfo._serviceName = it->_serviceName;
      sppServiceInfo._localUuid = it->_localUuid;
      sppServiceInfo._remoteUuid = it->_remoteUuid;

      _bmCoreConfiguration._sppServiceInformation.push_back(sppServiceInfo);
   }

   ETG_TRACE_USR4(("vUpdateConfiguration(): _sppServiceInformation.size() - %u", _bmCoreConfiguration._sppServiceInformation.size()));

   for (ProtocolSupportInformation::const_iterator itPIM = bmCoreConfiguration._protocolSupportInformation.begin();
         itPIM != bmCoreConfiguration._protocolSupportInformation.end(); itPIM++)
   {
      ProtocolId protocolId  = itPIM->first;

      ProtocolSupportInfo protocolSupportInfo;
      protocolSupportInfo._name = itPIM->second._name;
      protocolSupportInfo._version = itPIM->second._version;
      protocolSupportInfo._maxNumInstances = itPIM->second._maxNumInstances;
      protocolSupportInfo._dependencyLevel = itPIM->second._dependencyLevel;
      protocolSupportInfo._masterProtocolsSelector = itPIM->second._masterProtocolsSelector;
      protocolSupportInfo._usedForDeviceConnection = itPIM->second._usedForDeviceConnection;

      _bmCoreConfiguration._protocolSupportInformation[protocolId] = protocolSupportInfo;
   }

   _bmCoreConfiguration._btOnOffSupport = bmCoreConfiguration._btOnOffSupport;

   ETG_TRACE_USR4(("vUpdateConfiguration(): _defaultLocalConnectableMode - %d", _bmCoreConfiguration._defaultLocalConnectableMode));

   ETG_TRACE_USR4(("vUpdateConfiguration(): _systemWideRingtoneEnabled - %d", _bmCoreConfiguration._systemWideRingtoneEnabled));

   ETG_TRACE_USR4(("vUpdateConfiguration(): Pan supported Max instance - %d", _bmCoreConfiguration._protocolSupportInformation[BM_PROTOCOL_ID_PAN]._maxNumInstances));

   ETG_TRACE_USR4(("vUpdateConfiguration(): _btOnOffSupport - %d", _bmCoreConfiguration._btOnOffSupport));

   ETG_TRACE_USR4(("vUpdateConfiguration() end"));

   return;
}

tVoid FC_Bluetooth_tclCCAService::vPairingStatusChanged(const PairingStatus& btPairingStatus)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR4(("vPairingStatusChanged entered"));

   JobList *joblist = OSAL_NULL;
   SwitchState switchState = SWITCH_STATE_SWITCHED_OFF;

   vUpdatePairableMode(PAIRINGSTATUSCHANGED, switchState,
               btPairingStatus._state, btPairingStatus._remoteBdAddress);

   //resets the pairing status property once the Pairing state became IDLE.
   vUpdatePairingStatus(btPairingStatus._result, btPairingStatus._remoteBdName, btPairingStatus._remoteBdAddress);

   // resets the pairing reqeust property if the Pairing state became IDLE.
   vUpdatePairingRequest(btPairingStatus);

   if((btPairingStatus._state == BM_PAIRING_STATE_PAIRING_IN_PROGRESS) ||
         (btPairingStatus._result != BM_PAIRING_RESULT_UNKNOWN))
   {
      //MR for Sendpairingrequest
      //check if any Sendpairingrequest is there in Queue. If available then only send the MethodResult.
      //Same MethodResult should be sent to all the request in the Queue.
      joblist = FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopMethodContext(SENDPAIRINGREQUEST_METHOD_FKTID);
      if (joblist)
      {
         for (JobList::iterator it = joblist->begin(); it != joblist->end();it++)
         {
            SendPairingRequestMethodResult(((Job) *it), btPairingStatus);
         }
      }

      //MR for Addnewdevice
      //check if any Addnewrequest is there in Queue.If available then only send the MethodResult.
      //Same MethodResult should be sent to all the request in the Queue.
      updateAddNewDeviceMR(btPairingStatus);
   }

   if(btPairingStatus._result != BM_PAIRING_RESULT_UNKNOWN)
   {
      //check if any PairingResponse is there in Queue.If available then only send the MethodResult.
      updatePairingResponse(btPairingStatus);
   }

   _btPairingStatus = btPairingStatus;

   return;
}

tVoid FC_Bluetooth_tclCCAService::vGetPairingStatus(PairingStatus& btPairingStatus)
{
   btPairingStatus = _btPairingStatus;

   ETG_TRACE_USR4(("vGetPairingStatus: pairingstate - %d result - %d", btPairingStatus._state, btPairingStatus._result));
}

tVoid FC_Bluetooth_tclCCAService::updateAddNewDeviceMR(const PairingStatus& btPairingStatus)
{
   ENTRY_INTERNAL

   JobList *joblist = OSAL_NULL;
   Job methodcontext;
   tBool bJobFind = FALSE;
   tU16 u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;

   do
   {
      bJobFind = FALSE;
      u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;

      joblist = FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContext(ADDNEWDEVICE_METHOD_FKTID);

      if (joblist)
      {
         for (JobList::iterator it = joblist->begin(); it != joblist->end(); it++)
         {
            methodcontext = (Job) *it;
            u16Count++;

            ETG_TRACE_USR1(("updateAddNewDeviceMR: methodcontext u16FunctionID: %d bResponse: %d u16Count - %d",
                  methodcontext.u16FunctionID, methodcontext.bResponse, u16Count));

            if((methodcontext.u16FunctionID == ADDNEWDEVICE_METHOD_FKTID) && (methodcontext.bResponse == true))
            {
               AddNewDeviceMethodResult(((Job) *it), btPairingStatus);

               FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(ADDNEWDEVICE_METHOD_FKTID, methodcontext, u16Count);

               bJobFind = TRUE;
               break;
            }
            else
            {
               ETG_TRACE_USR1(("updateAddNewDeviceMR: methodcontext.bResponse is not received yet"));
            }

            ETG_TRACE_USR1(("updateAddNewDeviceMR: bJobFind: %d", bJobFind));
         }
      }
   }while(bJobFind == TRUE);

   return;
}

/*******************************************************************************
 *
 * Handle functions for Get Properties
 *
 *******************************************************************************/




tVoid FC_Bluetooth_tclCCAService::vUpdatePairedList(const PairedDeviceList& pairedDeviceList)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR4(("vUpdatePairedList:entered"));

   vUpdateBlockInfo(pairedDeviceList);

   if (pairedDeviceList._deviceBaseInfoList.size() > FC_BLUETOOTH_CCASERVICE_ZERO)
   {
      vFillDeviceListChange(pairedDeviceList);
   }
   else
   {
      _u8DeviceHandle = INVALID_DEVICE_HANDLE;
      _e8connectionStatus = BM_CONNECTION_STATUS_UNKNOWN;
      _bDeviceListChangeUpdate = true;
   }

   ETG_TRACE_USR1((" vUpdatePairedList ::DeviceHandle : %d %d", _u8DeviceHandle, _u8prevDeviceHandle));
   ETG_TRACE_USR1((" vUpdatePairedList ::e8DeviceStatus : %d %d", _e8connectionStatus, _e8prevconnectionStatus));
   ETG_TRACE_USR1((" vUpdatePairedList ::_bVersionUpdate : %d", _bVersionUpdate));
   ETG_TRACE_USR1((" vUpdatePairedList ::_bPairedDevicelistUpdate : %d", _bPairedDevicelistUpdate));

   if ((_u8prevDeviceHandle != _u8DeviceHandle) || (_e8prevconnectionStatus != _e8connectionStatus) ||
         (_bVersionUpdate == TRUE) || (_bPairedDevicelistUpdate == TRUE))
   {
      vUpdateList();

      _u8prevDeviceHandle = _u8DeviceHandle;
      _e8prevconnectionStatus = _e8connectionStatus;
      _bPairedDevicelistUpdate = FALSE;


      vUpdateDeviceListExtended(pairedDeviceList, _deviceConnectionStatusList);

      if(_bVersionUpdate == TRUE)
      {
         _bVersionUpdate = FALSE;
         vUpdateBluetoothAudioSource(_u8BluetoothAudioDeviceHandle, pairedDeviceList);
      }

      if(_bUpdateRingtoneStatus == TRUE)
      {
         _bUpdateRingtoneStatus = FALSE;
         _inbandRingtoneSupport = BM_INBAND_RINGTONE_SUPPORT_UNKNOWN;

         if(_initPairedDeviceListReceived == TRUE)
         {
            vUpdateRingtoneSupport((DeviceId)_u8DeviceHandle, _inbandRingtoneSupport);
         }
      }
   }

   //MR for onChangeDeviceState
   //check if any onChangeDeviceState is there in Queue.If available then only send the MethodResult.
   //Same MethodResult should be sent to all the request in the Queue.
   ChangeDeviceStateResponse(pairedDeviceList);

   vCopyPairedDeviceList(pairedDeviceList);

   if(_initPairedDeviceListReceived == FALSE)
   {
      vCheckAndUpdateRingtoneSupport();
      _initPairedDeviceListReceived = TRUE;
   }
}

tVoid FC_Bluetooth_tclCCAService::vUpdateConnectionStatusList(const DeviceConnectionStatusList& deviceConnectionStatusList)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR4(("vUpdateConnectionStatusList:entered"));

   vCheckHFPStatus(_bHFPStatusUpdate, deviceConnectionStatusList);

   vCheckAVPStatus(_bAVPStatusUpdate, deviceConnectionStatusList);

   vCheckPBAPStatus(_bPBAPStatusUpdate, deviceConnectionStatusList);

   vCheckMAPStatus(_bMAPStatusUpdate, deviceConnectionStatusList);

   vCheckPANStatus(_bPANStatusUpdate, deviceConnectionStatusList);

   ETG_TRACE_USR4(("vUpdateConnectionStatusList:bHFPUpdate: %d Outgoing Device Source : %d", _bHFPStatusUpdate, _outgoingSourceDeviceHandle));
   ETG_TRACE_USR4(("vUpdateConnectionStatusList:_bAVPStatusUpdate: %d _bPBAPStatusUpdate: %d _bMAPStatusUpdate - %d,  _bPANStatusUpdate - %d, _bProtocolStatusUpdate - %d",
         _bAVPStatusUpdate, _bPBAPStatusUpdate, _bMAPStatusUpdate, _bPANStatusUpdate, _bProtocolStatusUpdate));
   ETG_TRACE_USR1(("vUpdateConnectionStatusList ::DeviceHandle : %d %d", _u8DeviceHandle, _u8prevDeviceHandle));
   ETG_TRACE_USR1(("vUpdateConnectionStatusList ::e8DeviceStatus : %d %d", _e8connectionStatus, _e8prevconnectionStatus));

   if((_bHFPStatusUpdate == TRUE) || (_bAVPStatusUpdate == TRUE) || (_bPBAPStatusUpdate == TRUE) || (_bMAPStatusUpdate == TRUE) || ((_bPANStatusUpdate == TRUE)) ||
         (_u8prevDeviceHandle != _u8DeviceHandle) || (_e8prevconnectionStatus != _e8connectionStatus) || (_bProtocolStatusUpdate == TRUE))
   {
      vUpdateList();

      _u8prevDeviceHandle = _u8DeviceHandle;
      _e8prevconnectionStatus = _e8connectionStatus;
      _bHFPStatusUpdate = FALSE;
      _bPBAPStatusUpdate = FALSE;
      _bMAPStatusUpdate = FALSE;
      _bPANStatusUpdate = FALSE;
      _bProtocolStatusUpdate = FALSE;


      vUpdateDeviceListExtended(_pairedDeviceList, deviceConnectionStatusList);

      if(_bAVPStatusUpdate == TRUE)
      {
         _bAVPStatusUpdate = FALSE;
         vUpdateBluetoothAudioSource(_u8BluetoothAudioDeviceHandle, _pairedDeviceList);
      }
   }

   //MR for onConnectbluetoothprofile
   //check if any onConnectbluetoothprofile is there in Queue.If available then only send the MethodResult.
   //Same MethodResult should be sent to all the request in the Queue.
   ConnectProfileResponse(deviceConnectionStatusList);

   //MR for onDisconnectbluetoothprofile
   //check if any onDisconnectbluetoothprofile is there in Queue.If available then only send the MethodResult.
   //Same MethodResult should be sent to all the request in the Queue.
   DisconnectProfileResponse(deviceConnectionStatusList);

   vUpdateSppServiceConnection(deviceConnectionStatusList);

   vCopyDeviceConnectionStatusList(deviceConnectionStatusList);
}

tVoid FC_Bluetooth_tclCCAService::vUpdateList()
{
   ENTRY_INTERNAL

   ETG_TRACE_USR4(("vUpdateList:entered"));
   most_fi_tcl_e8_BTSetDeviceStatus e8BTSetDeviceStatus;

   _oDeviceListChange.u8DeviceHandle = _u8DeviceHandle;

   if (_oDeviceListChange.u8DeviceHandle == INVALID_DEVICE_HANDLE)
   {
      _oDeviceListChange.u8DeviceHandle = FC_BLUETOOTH_CCASERVICE_ZERO;
   }

   if ((_outgoingSourceDeviceHandle != INVALID_DEVICE_HANDLE) && (_outgoingSourceDeviceHandle == _u8DeviceHandle))
   {
      MapDeviceStatusTypeToMOST(e8BTSetDeviceStatus, _e8connectionStatus, true);
   }
   else
   {
      MapDeviceStatusTypeToMOST(e8BTSetDeviceStatus, _e8connectionStatus, false);
   }

   ETG_TRACE_USR4(("vUpdateList:_bDeviceListChangeUpdate - %d", _bDeviceListChangeUpdate));

   if(_bDeviceListChangeUpdate == true)
   {
      _bDeviceListChangeUpdate = false;
      _oDeviceListChange.e8DeviceStatus.enType = e8BTSetDeviceStatus.enType;
   }
   else
   {
      _oDeviceListChange.e8DeviceStatus.enType = most_fi_tcl_e8_BTSetDeviceStatus::FI_EN_E8DEVICE_NO_CHANGE;
   }
}

tVoid FC_Bluetooth_tclCCAService::vCopyPairedDeviceList(const PairedDeviceList& pairedDeviceList)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR4(("vCopyPairedDeviceList:entered"));

   _pairedDeviceList._deviceBaseInfoList.clear();

   if(pairedDeviceList._deviceBaseInfoList.size() > 0)
   {
      for (std::list<DeviceBaseInfo>::const_iterator it = pairedDeviceList._deviceBaseInfoList.begin();
            it != pairedDeviceList._deviceBaseInfoList.end(); it++)
      {
         DeviceBaseInfo temp;

         temp._deviceHandle = it->_deviceHandle;
         temp._bdAddress  = it->_bdAddress;
         temp._bdName = it->_bdName;
         temp._majorDeviceClass = it->_majorDeviceClass;
         temp._inbandRingtoneSupport = it->_inbandRingtoneSupport;
         temp._connectionStatus = it->_connectionStatus;
         temp._disconnectedReason = it->_disconnectedReason;
         temp._deviceIdentification = it->_deviceIdentification;
         temp._connectionOrderInfo = it->_connectionOrderInfo;
         temp._favoriteIndex = it->_favoriteIndex;
         temp._absoluteVolumeSupport = it->_absoluteVolumeSupport;
         temp._remoteConnectable = it->_remoteConnectable;
         temp._usagePreference = it->_usagePreference;
         temp._pairingOrderInfo = it->_pairingOrderInfo;
         temp._iAPoverBTSupported = it->_iAPoverBTSupported;

         for (ProtocolInfoMap::const_iterator itPIM = it->_protocolInfo.begin(); itPIM != it->_protocolInfo.end(); itPIM++)
         {
            ProtocolId protocolId  = itPIM->first;

            ProtocolInfo protocolInfo;
            protocolInfo._name = itPIM->second._name;
            protocolInfo._version = itPIM->second._version;
            protocolInfo._isSupported = itPIM->second._isSupported;
            protocolInfo._favoriteIndex = itPIM->second._favoriteIndex;

            temp._protocolInfo[protocolId] = protocolInfo;
         }

         _pairedDeviceList._deviceBaseInfoList.push_back(temp);
      }
   }

   vPrintPairedDevicelist(_pairedDeviceList);

   return;
}

tVoid FC_Bluetooth_tclCCAService::vPrintPairedDevicelist(const PairedDeviceList& pairedDeviceList)
{
   ETG_TRACE_USR4(("vPrintPairedDevicelist:size - %d", pairedDeviceList._deviceBaseInfoList.size()));

   for (std::list<DeviceBaseInfo>::const_iterator it = pairedDeviceList._deviceBaseInfoList.begin();
         it != pairedDeviceList._deviceBaseInfoList.end(); it++)
   {
      ETG_TRACE_USR4(("vPrintPairedDevicelist:_deviceHandle - %d", it->_deviceHandle));
      ETG_TRACE_USR4(("vPrintPairedDevicelist:_bdAddress - %s", it->_bdAddress.c_str()));
      ETG_TRACE_USR4(("vPrintPairedDevicelist:_bdName - %s", it->_bdName.c_str()));
      ETG_TRACE_USR4(("vPrintPairedDevicelist:_majorDeviceClass - %d", it->_majorDeviceClass));
      ETG_TRACE_USR4(("vPrintPairedDevicelist:_favoriteIndex - %d", it->_favoriteIndex));
      ETG_TRACE_USR4(("vPrintPairedDevicelist:_remoteConnectable - %d", it->_remoteConnectable));
      ETG_TRACE_USR4(("vPrintPairedDevicelist:_usagePreference - %d", it->_usagePreference));
      ETG_TRACE_USR4(("vPrintPairedDevicelist:_inbandRingtoneSupport - %d", it->_inbandRingtoneSupport));
      ETG_TRACE_USR4(("vPrintPairedDevicelist:_absoluteVolumeSupport - %d", it->_absoluteVolumeSupport));
      ETG_TRACE_USR4(("vPrintPairedDevicelist:_connectionStatus - %d", it->_connectionStatus));
      ETG_TRACE_USR4(("vPrintPairedDevicelist:_disconnectedReason - %d", it->_disconnectedReason));
      ETG_TRACE_USR4(("vPrintPairedDevicelist:_deviceIdentification: _specificationId - %d _vendorId - %d _vendorIdSource - %d _productId - %d _version - %d ",
            it->_deviceIdentification._specificationId, it->_deviceIdentification._vendorId, it->_deviceIdentification._vendorIdSource,
            it->_deviceIdentification._productId, it->_deviceIdentification._version));
      ETG_TRACE_USR4(("vPrintPairedDevicelist:_connectionOrderInfo - %d", it->_connectionOrderInfo._seconds));
      ETG_TRACE_USR4(("vPrintPairedDevicelist:_pairingOrderInfo - %d", it->_pairingOrderInfo._seconds));
      ETG_TRACE_USR4(("vPrintPairedDevicelist:_iAPoverBTSupported - %d", it->_iAPoverBTSupported));

      for (ProtocolInfoMap::const_iterator itPIM = it->_protocolInfo.begin(); itPIM != it->_protocolInfo.end(); itPIM++)
      {
         ProtocolId protocolId  = itPIM->first;
         ProtocolInfo protocolInfo = itPIM->second;

         ETG_TRACE_USR4(("vPrintPairedDevicelist: protocolId - %X version - %X _name - %50s _isSupported - %d ", protocolId, protocolInfo._version,
               protocolInfo._name.c_str(), protocolInfo._isSupported));
         ETG_TRACE_USR4(("vPrintPairedDevicelist: protocolInfo._favoriteIndex - %d", protocolInfo._favoriteIndex));
      }
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::vCopyDeviceConnectionStatusList(const DeviceConnectionStatusList& deviceConnectionStatusList)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR4(("vCopyDeviceConnectionStatusList:entered"));

   _deviceConnectionStatusList._deviceConnectionInfoList.clear();

   if(deviceConnectionStatusList._deviceConnectionInfoList.size() > 0)
   {
      for (tU16 iCount = FC_BLUETOOTH_CCASERVICE_ZERO; iCount < deviceConnectionStatusList._deviceConnectionInfoList.size(); iCount++)
      {
         DeviceConnectionInfo temp;

         temp._deviceHandle = deviceConnectionStatusList._deviceConnectionInfoList[iCount]._deviceHandle;
         temp._connectionStatus = deviceConnectionStatusList._deviceConnectionInfoList[iCount]._connectionStatus;
         temp._disconnectedReason = deviceConnectionStatusList._deviceConnectionInfoList[iCount]._disconnectedReason;
         temp._connectionOrderInfo = deviceConnectionStatusList._deviceConnectionInfoList[iCount]._connectionOrderInfo;

         for (ProtocolConnectionInfoMap::const_iterator itPIM = deviceConnectionStatusList._deviceConnectionInfoList[iCount]._protocolConnectionInfo.begin();
               itPIM != deviceConnectionStatusList._deviceConnectionInfoList[iCount]._protocolConnectionInfo.end(); itPIM++)
         {
            ProtocolId protocolId = itPIM->first;

            ProtocolConnectionInfo protocolInfo;
            protocolInfo._connectionStatus = itPIM->second._connectionStatus;
            protocolInfo._disconnectedReason = itPIM->second._disconnectedReason;
            protocolInfo._rfcommDevicePath = itPIM->second._rfcommDevicePath;
            protocolInfo._primary = itPIM->second._primary;

            temp._protocolConnectionInfo[protocolId] = protocolInfo;
         }

         for (SppConnectionInfoMap::const_iterator itSCIM = deviceConnectionStatusList._deviceConnectionInfoList[iCount]._sppConnectionInfo.begin();
               itSCIM != deviceConnectionStatusList._deviceConnectionInfoList[iCount]._sppConnectionInfo.end(); itSCIM++)
         {
            Uuid uuid= itSCIM->first;

            ProtocolConnectionInfo protocolInfo;
            protocolInfo._connectionStatus = itSCIM->second._connectionStatus;
            protocolInfo._disconnectedReason = itSCIM->second._disconnectedReason;
            protocolInfo._rfcommDevicePath = itSCIM->second._rfcommDevicePath;
            protocolInfo._primary = itSCIM->second._primary;

            temp._sppConnectionInfo[uuid] = protocolInfo;
         }

         _deviceConnectionStatusList._deviceConnectionInfoList.push_back(temp);
      }
   }

   vPrintDeviceConnectionStatusList(_deviceConnectionStatusList);

   return;
}

tVoid FC_Bluetooth_tclCCAService::vPrintDeviceConnectionStatusList(const DeviceConnectionStatusList& deviceConnectionStatusList)
{
   ETG_TRACE_USR4(("vPrintDeviceConnectionStatusList:size - %d", deviceConnectionStatusList._deviceConnectionInfoList.size()));

   for (tU16 iCount = FC_BLUETOOTH_CCASERVICE_ZERO; iCount < deviceConnectionStatusList._deviceConnectionInfoList.size(); iCount++)
   {
      ETG_TRACE_USR4(("vPrintDeviceConnectionStatusList:_deviceHandle - %d", deviceConnectionStatusList._deviceConnectionInfoList[iCount]._deviceHandle));
      ETG_TRACE_USR4(("vPrintDeviceConnectionStatusList:_connectionStatus - %d", deviceConnectionStatusList._deviceConnectionInfoList[iCount]._connectionStatus));
      ETG_TRACE_USR4(("vPrintDeviceConnectionStatusList:_disconnectedReason - %d", deviceConnectionStatusList._deviceConnectionInfoList[iCount]._disconnectedReason));
      ETG_TRACE_USR4(("vPrintDeviceConnectionStatusList:_connectionOrderInfo - %d", deviceConnectionStatusList._deviceConnectionInfoList[iCount]._connectionOrderInfo._seconds));

      for (ProtocolConnectionInfoMap::const_iterator itPIM = deviceConnectionStatusList._deviceConnectionInfoList[iCount]._protocolConnectionInfo.begin();
            itPIM != deviceConnectionStatusList._deviceConnectionInfoList[iCount]._protocolConnectionInfo.end(); itPIM++)
      {
         ProtocolId protocolId = itPIM->first;

         ProtocolConnectionInfo protocolInfo;
         protocolInfo._connectionStatus = itPIM->second._connectionStatus;
         protocolInfo._disconnectedReason = itPIM->second._disconnectedReason;
         protocolInfo._rfcommDevicePath = itPIM->second._rfcommDevicePath;
         protocolInfo._primary = itPIM->second._primary;

         ETG_TRACE_USR4(("vPrintDeviceConnectionStatusList: protocolId - %X _connectionStatus - %d _disconnectedReason - %d _rfcommDevicePath - %50s, _primary - %d",
               protocolId, protocolInfo._connectionStatus, protocolInfo._disconnectedReason, protocolInfo._rfcommDevicePath.c_str(), protocolInfo._primary));
      }

      for (SppConnectionInfoMap::const_iterator itSCIM = deviceConnectionStatusList._deviceConnectionInfoList[iCount]._sppConnectionInfo.begin();
            itSCIM != deviceConnectionStatusList._deviceConnectionInfoList[iCount]._sppConnectionInfo.end(); itSCIM++)
      {
         Uuid uuid= itSCIM->first;

         ProtocolConnectionInfo protocolInfo;
         protocolInfo._connectionStatus = itSCIM->second._connectionStatus;
         protocolInfo._disconnectedReason = itSCIM->second._disconnectedReason;
         protocolInfo._rfcommDevicePath = itSCIM->second._rfcommDevicePath;
         protocolInfo._primary = itSCIM->second._primary;

         ETG_TRACE_USR4(("vPrintDeviceConnectionStatusList: uuid - %50s _connectionStatus - %d _disconnectedReason - %d _rfcommDevicePath - %50s, _primary - %d",
               uuid.c_str(), protocolInfo._connectionStatus, protocolInfo._disconnectedReason, protocolInfo._rfcommDevicePath.c_str(), protocolInfo._primary));
      }
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::vGetPairedDeviceList(PairedDeviceList& pairedDeviceList)
{
   ENTRY_INTERNAL

   pairedDeviceList = _pairedDeviceList;

   return;
}

tVoid FC_Bluetooth_tclCCAService::vGetDeviceConnectionStatusList(DeviceConnectionStatusList& deviceConnectionStatusList)
{
   ENTRY_INTERNAL

   deviceConnectionStatusList = _deviceConnectionStatusList;

   return;
}

tVoid FC_Bluetooth_tclCCAService::vGetCurrentOutGoingSource(tU16& u16OutgoingSourceDeviceHandle)
{
   ENTRY_INTERNAL

   u16OutgoingSourceDeviceHandle = _outgoingSourceDeviceHandle;

   ETG_TRACE_USR4(("vGetCurrentOutGoingSource: %d", u16OutgoingSourceDeviceHandle));

   return;
}


tVoid FC_Bluetooth_tclCCAService::vCheckHFPStatus(tBool& bHFPUpdate, const DeviceConnectionStatusList& deviceConnectionStatusList)
{
   ENTRY_INTERNAL

   tU16 u16DeviceHandle = _outgoingSourceDeviceHandle;
   tBool bUpdate = false;
   tBool bProtocolStatusUpdate = false;
   DeviceBaseInfoList::const_iterator connListIt;

   vFindChangeProfileStatus(BM_PROTOCOL_ID_HFP, _outgoingSourceDeviceHandle, deviceConnectionStatusList, bUpdate, bProtocolStatusUpdate, u16DeviceHandle);

   if((bUpdate == TRUE) || (bProtocolStatusUpdate == TRUE))
   {
      if ((u16DeviceHandle != _u8DeviceHandle) && (u16DeviceHandle != INVALID_DEVICE_HANDLE))
      {
         connListIt = std::find_if(_pairedDeviceList._deviceBaseInfoList.begin(),
               _pairedDeviceList._deviceBaseInfoList.end(),
               MeetsDeviceHandle<DeviceBaseInfo>(u16DeviceHandle));
         {
            if (connListIt != _pairedDeviceList._deviceBaseInfoList.end())
            {
               _u8DeviceHandle = (tU8)connListIt->_deviceHandle;
               _e8connectionStatus = connListIt->_connectionStatus;
            }
         }
      }

      if(bUpdate == TRUE)
      {
         ETG_TRACE_USR4(("vCheckHFPStatus: Outgoing Device Source - Curr: %d Prev: %d", u16DeviceHandle, _outgoingSourceDeviceHandle));

         if (_outgoingSourceDeviceHandle != u16DeviceHandle)
         {
            if(u16DeviceHandle != INVALID_DEVICE_HANDLE)
            {
               connListIt = std::find_if(_pairedDeviceList._deviceBaseInfoList.begin(),
                     _pairedDeviceList._deviceBaseInfoList.end(),
                     MeetsDeviceHandle<DeviceBaseInfo>(u16DeviceHandle));
            }
            else
            {
               connListIt = std::find_if(_pairedDeviceList._deviceBaseInfoList.begin(),
                     _pairedDeviceList._deviceBaseInfoList.end(),
                     MeetsDeviceHandle<DeviceBaseInfo>(_outgoingSourceDeviceHandle));
            }

            if (connListIt != _pairedDeviceList._deviceBaseInfoList.end())
            {
               if (connListIt->_connectionStatus == BM_CONNECTION_STATUS_CONNECTED)
               {
                  _u8DeviceHandle = (tU8)connListIt->_deviceHandle;
                  _e8connectionStatus = connListIt->_connectionStatus;
                  _bDeviceListChangeUpdate = TRUE;
               }
            }

            _outgoingSourceDeviceHandle = u16DeviceHandle;
         }

         bHFPUpdate = TRUE;
      }
      else
      {
         ETG_TRACE_USR4(("vCheckHFPStatus: Protocolstatuschange - %d", u16DeviceHandle));
         _bProtocolStatusUpdate = bProtocolStatusUpdate;
      }
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::vFindChangeProfileStatus(ProtocolId protocolId, tU16 u16InDeviceHandle,
      const DeviceConnectionStatusList& deviceConnectionStatusList, tBool& bUpdate, tBool& bProtocolStatusUpdate, tU16& u16OutDeviceHandle)
{
   ProtocolConnectionInfo curProtocolconnectioninfo, prevProtocolconnectioninfo;
   ProtocolId curProtocolId, prevProtocolId;
   ProtocolConnectionInfoMap::const_iterator ItCurProConInfoMap, ItPrevProConInfoMap;
   tBool bChange = FALSE;

   if(_deviceConnectionStatusList._deviceConnectionInfoList.size() == deviceConnectionStatusList._deviceConnectionInfoList.size())
   {
      for (tU16 iCount = FC_BLUETOOTH_CCASERVICE_ZERO; iCount < deviceConnectionStatusList._deviceConnectionInfoList.size(); iCount++)
      {
         for (ItCurProConInfoMap = deviceConnectionStatusList._deviceConnectionInfoList[iCount]._protocolConnectionInfo.begin();
               ItCurProConInfoMap != deviceConnectionStatusList._deviceConnectionInfoList[iCount]._protocolConnectionInfo.end();
               ItCurProConInfoMap++)
         {
            curProtocolId = ItCurProConInfoMap->first;
            curProtocolconnectioninfo = ItCurProConInfoMap->second;

            if (curProtocolId == protocolId)
            {
               ETG_TRACE_USR1(("vFindChangeProfileStatus::curProtocolId = %d, _curConnectionStatus - %d",
                     curProtocolId, curProtocolconnectioninfo._connectionStatus));

               DeviceConnectionInfoList::const_iterator connListIt = std::find_if(_deviceConnectionStatusList._deviceConnectionInfoList.begin(),
                     _deviceConnectionStatusList._deviceConnectionInfoList.end(),
                     MeetsDeviceHandle<DeviceConnectionInfo>(deviceConnectionStatusList._deviceConnectionInfoList[iCount]._deviceHandle));

               if(connListIt != _deviceConnectionStatusList._deviceConnectionInfoList.end())
               {
                  for (ItPrevProConInfoMap = connListIt->_protocolConnectionInfo.begin();
                        ItPrevProConInfoMap != connListIt->_protocolConnectionInfo.end(); ItPrevProConInfoMap++)
                  {
                     prevProtocolId = ItPrevProConInfoMap->first;
                     prevProtocolconnectioninfo = ItPrevProConInfoMap->second;

                     if(prevProtocolId == protocolId)
                     {
                        ETG_TRACE_USR1(("vFindChangeProfileStatus::prevProtocolId = %d, _prevConnectionStatus - %d",
                              prevProtocolId, prevProtocolconnectioninfo._connectionStatus));

                        if((curProtocolconnectioninfo._connectionStatus != BM_CONNECTION_STATUS_CONNECTING) &&
                              (curProtocolconnectioninfo._connectionStatus != BM_CONNECTION_STATUS_DISCONNECTING))
                        {
                           if(prevProtocolconnectioninfo._connectionStatus != curProtocolconnectioninfo._connectionStatus)
                           {
                              if(deviceConnectionStatusList._deviceConnectionInfoList[iCount]._connectionStatus == BM_CONNECTION_STATUS_CONNECTED)
                              {
                                 if (curProtocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_CONNECTED)
                                 {
                                    bChange = TRUE;

                                    if(deviceConnectionStatusList._deviceConnectionInfoList[iCount]._deviceHandle == u16InDeviceHandle)
                                    {
                                       bUpdate = TRUE;
                                    }
                                 }
                                 else if(curProtocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_DISCONNECTED)
                                 {
                                    if(deviceConnectionStatusList._deviceConnectionInfoList[iCount]._deviceHandle == u16InDeviceHandle)
                                    {
                                       bChange = TRUE;
                                    }
                                 }
                              }
                              else if(deviceConnectionStatusList._deviceConnectionInfoList[iCount]._connectionStatus == BM_CONNECTION_STATUS_DISCONNECTING)
                              {
                                 if((deviceConnectionStatusList._deviceConnectionInfoList[iCount]._deviceHandle == u16InDeviceHandle) &&
                                       (curProtocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_DISCONNECTED))
                                 {
                                    bChange = TRUE;
                                 }
                              }
                              else
                              {
                                 ETG_TRACE_USR1(("vFindChangeProfileStatus:: device is not connected"));
                              }
                           }
                           else
                           {
                              ETG_TRACE_USR1(("vFindChangeProfileStatus:: device ConnectionStatus prev - %d curr - %d",
                                    connListIt->_connectionStatus, deviceConnectionStatusList._deviceConnectionInfoList[iCount]._connectionStatus));

                              if((deviceConnectionStatusList._deviceConnectionInfoList[iCount]._connectionStatus != BM_CONNECTION_STATUS_CONNECTING) &&
                                    (deviceConnectionStatusList._deviceConnectionInfoList[iCount]._connectionStatus != BM_CONNECTION_STATUS_DISCONNECTING))
                              {
                                 if(connListIt->_connectionStatus != deviceConnectionStatusList._deviceConnectionInfoList[iCount]._connectionStatus)
                                 {
                                    if (curProtocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_CONNECTED)
                                    {
                                       bChange = TRUE;

                                       if(deviceConnectionStatusList._deviceConnectionInfoList[iCount]._deviceHandle == u16InDeviceHandle)
                                       {
                                          bUpdate = TRUE;
                                       }
                                    }
                                    else if(curProtocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_DISCONNECTED)
                                    {
                                       if(deviceConnectionStatusList._deviceConnectionInfoList[iCount]._deviceHandle == u16InDeviceHandle)
                                       {
                                          bChange = TRUE;
                                       }
                                    }
                                 }
                              }
                           }

                           if(bChange == FALSE)
                           {
                              if((prevProtocolconnectioninfo._connectionStatus != curProtocolconnectioninfo._connectionStatus) &&
                                    (curProtocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_DISCONNECTED))
                              {
                                 bProtocolStatusUpdate = TRUE;
                              }
                           }
                        }
                        else
                        {
                           if(prevProtocolconnectioninfo._connectionStatus != curProtocolconnectioninfo._connectionStatus)
                           {
                              bProtocolStatusUpdate = TRUE;
                           }
                        }
                        break;
                     }
                  }
               }

              if(bChange == TRUE)
              {
                 if (curProtocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_CONNECTED)
                 {
                    u16OutDeviceHandle = (tU16)deviceConnectionStatusList._deviceConnectionInfoList[iCount]._deviceHandle;
                 }
                 else
                 {
                    u16OutDeviceHandle = INVALID_DEVICE_HANDLE;
                 }

                 if (u16OutDeviceHandle != u16InDeviceHandle)
                 {
                    bUpdate = TRUE;
                 }

                 ETG_TRACE_USR4(("vFindChangeProfileStatus: u16DeviceHandle - %d u16InDeviceHandle - %d bUpdate - %d",
                       u16OutDeviceHandle, u16InDeviceHandle, bUpdate));
              }
              else if(bProtocolStatusUpdate == TRUE)
              {
                 u16OutDeviceHandle = (tU16)deviceConnectionStatusList._deviceConnectionInfoList[iCount]._deviceHandle;
              }
              break;
            }
         }

         if((bChange == TRUE) || (bProtocolStatusUpdate == TRUE))
         {
            break;
         }
      }
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::vCheckAVPStatus(tBool& bAVPUpdate, const DeviceConnectionStatusList& deviceConnectionStatusList)
{
   ENTRY_INTERNAL
   tU16 u16DeviceHandle = _u8BluetoothAudioDeviceHandle;
   tBool bUpdate = false;
   tBool bProtocolStatusUpdate = false;

   vFindChangeProfileStatus(BM_PROTOCOL_ID_AVP, _u8BluetoothAudioDeviceHandle, deviceConnectionStatusList, bUpdate, bProtocolStatusUpdate, u16DeviceHandle);

   if((bUpdate == TRUE) || (bProtocolStatusUpdate == TRUE))
   {
      if ((u16DeviceHandle != _u8DeviceHandle) && (u16DeviceHandle != INVALID_DEVICE_HANDLE))
      {
         DeviceBaseInfoList::const_iterator connListIt = std::find_if(_pairedDeviceList._deviceBaseInfoList.begin(),
               _pairedDeviceList._deviceBaseInfoList.end(),
               MeetsDeviceHandle<DeviceBaseInfo>(u16DeviceHandle));
         {
            if (connListIt != _pairedDeviceList._deviceBaseInfoList.end())
            {
               _u8DeviceHandle = (tU8)connListIt->_deviceHandle;
               _e8connectionStatus = connListIt->_connectionStatus;
            }
         }
      }

      if(bUpdate == TRUE)
      {
         ETG_TRACE_USR4(("vCheckAVPStatus: AudioHandle - Curr: %d Prev: %d", u16DeviceHandle, _u8BluetoothAudioDeviceHandle));
         _u8BluetoothAudioDeviceHandle = (tU8)u16DeviceHandle;
         bAVPUpdate = true;
      }
      else
      {
         ETG_TRACE_USR4(("vCheckAVPStatus: Protocolstatuschange - %d", u16DeviceHandle));
         _bProtocolStatusUpdate = bProtocolStatusUpdate;
      }
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::vCheckPBAPStatus(tBool& bPBAPUpdate, const DeviceConnectionStatusList& deviceConnectionStatusList)
{
   ENTRY_INTERNAL
   tU16 u16DeviceHandle = _u16PBAPDeviceHandle;
   tBool bUpdate = false;
   tBool bProtocolStatusUpdate = false;

   vFindChangeProfileStatus(BM_PROTOCOL_ID_PBDL, _u16PBAPDeviceHandle, deviceConnectionStatusList, bUpdate, bProtocolStatusUpdate, u16DeviceHandle);

   if((bUpdate == TRUE) || (bProtocolStatusUpdate == TRUE))
   {
      if ((u16DeviceHandle != _u8DeviceHandle) && (u16DeviceHandle != INVALID_DEVICE_HANDLE))
      {
         DeviceBaseInfoList::const_iterator connListIt = std::find_if(_pairedDeviceList._deviceBaseInfoList.begin(),
               _pairedDeviceList._deviceBaseInfoList.end(),
               MeetsDeviceHandle<DeviceBaseInfo>(u16DeviceHandle));
         {
            if (connListIt != _pairedDeviceList._deviceBaseInfoList.end())
            {
               _u8DeviceHandle = (tU8)connListIt->_deviceHandle;
               _e8connectionStatus = connListIt->_connectionStatus;
            }
         }
      }

      if(bUpdate == TRUE)
      {
         ETG_TRACE_USR4(("vCheckPBAPStatus: u16DeviceHandle - Curr: %d Prev: %d", u16DeviceHandle, _u16PBAPDeviceHandle));
         _u16PBAPDeviceHandle = u16DeviceHandle;
         bPBAPUpdate = TRUE;
      }
      else
      {
         ETG_TRACE_USR4(("vCheckPBAPStatus: Protocolstatuschange - %d", u16DeviceHandle));
         _bProtocolStatusUpdate = bProtocolStatusUpdate;
      }
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::vCheckMAPStatus(tBool& bMAPUpdate, const DeviceConnectionStatusList& deviceConnectionStatusList)
{
   ENTRY_INTERNAL
   tU16 u16DeviceHandle = _u16MAPDeviceHandle;
   tBool bUpdate = false;
   tBool bProtocolStatusUpdate = false;

   vFindChangeProfileStatus(BM_PROTOCOL_ID_MSG, _u16MAPDeviceHandle, deviceConnectionStatusList, bUpdate, bProtocolStatusUpdate, u16DeviceHandle);

   if((bUpdate == TRUE) || (bProtocolStatusUpdate == TRUE))
   {
      if ((u16DeviceHandle != _u8DeviceHandle) && (u16DeviceHandle != INVALID_DEVICE_HANDLE))
      {
         DeviceBaseInfoList::const_iterator connListIt = std::find_if(_pairedDeviceList._deviceBaseInfoList.begin(),
               _pairedDeviceList._deviceBaseInfoList.end(),
               MeetsDeviceHandle<DeviceBaseInfo>(u16DeviceHandle));
         {
            if (connListIt != _pairedDeviceList._deviceBaseInfoList.end())
            {
               _u8DeviceHandle = (tU8)connListIt->_deviceHandle;
               _e8connectionStatus = connListIt->_connectionStatus;
            }
         }
      }

      if (bUpdate == TRUE)
      {
         ETG_TRACE_USR4(("vCheckMAPStatus: u16DeviceHandle - Curr: %d Prev: %d", u16DeviceHandle, _u16MAPDeviceHandle));
         _u16MAPDeviceHandle = u16DeviceHandle;
         bMAPUpdate = TRUE;
      }
      else
      {
         ETG_TRACE_USR4(("vCheckMAPStatus: Protocolstatuschange - %d", u16DeviceHandle));
         _bProtocolStatusUpdate = bProtocolStatusUpdate;
      }
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::vCheckPANStatus(tBool& bPANUpdate, const DeviceConnectionStatusList& deviceConnectionStatusList)
{
   ENTRY_INTERNAL
   tU16 u16DeviceHandle = _u16PANDeviceHandle;
   tBool bUpdate = false;
   tBool bProtocolStatusUpdate = false;

   vFindChangeProfileStatus(BM_PROTOCOL_ID_PAN, _u16PANDeviceHandle, deviceConnectionStatusList, bUpdate, bProtocolStatusUpdate, u16DeviceHandle);

   if((bUpdate == TRUE) || (bProtocolStatusUpdate == TRUE))
   {
      if ((u16DeviceHandle != _u8DeviceHandle) && (u16DeviceHandle != INVALID_DEVICE_HANDLE))
      {
         DeviceBaseInfoList::const_iterator connListIt = std::find_if(_pairedDeviceList._deviceBaseInfoList.begin(),
               _pairedDeviceList._deviceBaseInfoList.end(),
               MeetsDeviceHandle<DeviceBaseInfo>(u16DeviceHandle));
         {
            if (connListIt != _pairedDeviceList._deviceBaseInfoList.end())
            {
               _u8DeviceHandle = (tU8)connListIt->_deviceHandle;
               _e8connectionStatus = connListIt->_connectionStatus;
            }
         }
      }

      if (bUpdate == TRUE)
      {
         ETG_TRACE_USR4(("vCheckPANStatus: u16DeviceHandle - Curr: %d Prev: %d", u16DeviceHandle, _u16PANDeviceHandle));
         _u16PANDeviceHandle = u16DeviceHandle;
         bPANUpdate = TRUE;
      }
      else
      {
         ETG_TRACE_USR4(("vCheckPANStatus: Protocolstatuschange - %d", u16DeviceHandle));
         _bProtocolStatusUpdate = bProtocolStatusUpdate;
      }
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::ChangeDeviceStateResponse(const PairedDeviceList& pairedDeviceList,
      tBool bResponse, BmResult result)
{
   JobList *joblist = OSAL_NULL;
   Job methodcontext;
   tBool bQuit = FALSE;
   tBool bJobFind = FALSE;
   tU16 u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;

   ETG_TRACE_USR1(("ChangeDeviceStateResponse: bResponse: %d result:%d", bResponse, result));

   do
   {
      bJobFind = FALSE;
      bQuit = FALSE;

      joblist = FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContext(CHANGEDEVICESTATE_METHOD_FKTID);

      if (joblist)
      {
         ETG_TRACE_USR1(("ChangeDeviceStateResponse: size: %d", joblist->size()));

         for (JobList::iterator it = joblist->begin(); it != joblist->end(); it++)
         {
            methodcontext = (Job) *it;
            u16Count++;

            ETG_TRACE_USR1(("ChangeDeviceStateResponse: methodcontext u16FunctionID: %d bResponse: %d u16Count - %d",
                  methodcontext.u16FunctionID, methodcontext.bResponse, u16Count));

            if(bResponse == TRUE)
            {
               if(methodcontext.bResponse == false)
               {
                  (*it).bResponse = true;

                  if(BM_RESULT_OK != result)
                  {
                     ChangeDeviceStateMethodError(methodcontext, u16Count);
                  }
                  else
                  {
                     updateChangeDeviceStateMR(pairedDeviceList, methodcontext, bJobFind, u16Count, bResponse);
                  }
                  bQuit = TRUE;
               }
               else
               {
                  ETG_TRACE_USR1(("ChangeDeviceStateResponse: Response is already received"));
               }
            }
            else
            {
               if(methodcontext.bResponse == true)
               {
                  //MR for onConnectbluetoothprofile
                  //check if any onConnectbluetoothprofile is there in Queue.If available then only send the MethodResult.
                  //Same MethodResult should be sent to all the request in the Queue.
                  updateChangeDeviceStateMR(pairedDeviceList, methodcontext, bJobFind, u16Count, bResponse);
               }
               else
               {
                  ETG_TRACE_USR1(("ChangeDeviceStateResponse: Response is not yet received"));
                  bQuit = TRUE;
               }
            }

            ETG_TRACE_USR1(("ChangeDeviceStateResponse: bJobFind: %d bQuit:%d", bJobFind, bQuit));

            if((bJobFind == TRUE) || (bQuit == TRUE))
            {
               u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;
               break;
            }
         }
      }
      else
      {
         bQuit = TRUE;
      }
   }while((bJobFind == TRUE) && (bQuit == FALSE));

   return;
}

void FC_Bluetooth_tclCCAService::updateChangeDeviceStateMR(const PairedDeviceList& pairedDeviceList,
      Job& methodcontext, tBool& bJobFind, tU16& u16Count, tBool& bResponse)
{
   ENTRY_INTERNAL

   DeviceBaseInfo devicebaseinfo, olddevicebaseinfo;
   DeviceBaseInfoList::const_iterator It, oldIt;
   most_fi_tcl_e8_BTSetConnectionResult e8_BTSetConnectionResult;
   most_btsetfi_tclMsgChangeDeviceStateMethodStart *poCDSFiDataObjectMethodStart = NULL;

   poCDSFiDataObjectMethodStart = (most_btsetfi_tclMsgChangeDeviceStateMethodStart *) (methodcontext.poMethodArg);

   if (poCDSFiDataObjectMethodStart)
   {
      if ((poCDSFiDataObjectMethodStart->e8ChangeDeviceStateAction.enType == most_fi_tcl_e8_BTSetChangeDeviceStateAction::FI_EN_E8SELECT) ||
            (poCDSFiDataObjectMethodStart->e8ChangeDeviceStateAction.enType == most_fi_tcl_e8_BTSetChangeDeviceStateAction::FI_EN_E8DISCONNECT) ||
            (poCDSFiDataObjectMethodStart->e8ChangeDeviceStateAction.enType == most_fi_tcl_e8_BTSetChangeDeviceStateAction::FI_EN_E8DELETE) ||
            (poCDSFiDataObjectMethodStart->e8ChangeDeviceStateAction.enType == most_fi_tcl_e8_BTSetChangeDeviceStateAction::FI_EN_E8DELETE_ALL))
      {
         if(poCDSFiDataObjectMethodStart->u8DeviceHandle == FC_BLUETOOTH_CCASERVICE_ZERO)
         {
            if(poCDSFiDataObjectMethodStart->e8ChangeDeviceStateAction.enType == most_fi_tcl_e8_BTSetChangeDeviceStateAction::FI_EN_E8DISCONNECT)
            {
               for (std::list<DeviceBaseInfo>::const_iterator devInfoIt = pairedDeviceList._deviceBaseInfoList.begin();
                     devInfoIt != pairedDeviceList._deviceBaseInfoList.end(); devInfoIt++)
               {
                  devicebaseinfo = *devInfoIt;

                  if (devicebaseinfo._connectionStatus == BM_CONNECTION_STATUS_DISCONNECTED)
                  {
                     e8_BTSetConnectionResult.enType = most_fi_tcl_e8_BTSetConnectionResult::FI_EN_E8DEVICE_DISCONNECTED;
                     bJobFind = TRUE;
                  }
                  else
                  {
                     bJobFind = FALSE;
                     break;
                  }
               }
            }
            else if((poCDSFiDataObjectMethodStart->e8ChangeDeviceStateAction.enType == most_fi_tcl_e8_BTSetChangeDeviceStateAction::FI_EN_E8DELETE)
                  || (poCDSFiDataObjectMethodStart->e8ChangeDeviceStateAction.enType == most_fi_tcl_e8_BTSetChangeDeviceStateAction::FI_EN_E8DELETE_ALL))
            {
               if(pairedDeviceList._deviceBaseInfoList.size() == FC_BLUETOOTH_CCASERVICE_ZERO)
               {
                  e8_BTSetConnectionResult.enType = most_fi_tcl_e8_BTSetConnectionResult::FI_EN_E8NOT_APPLICABLE;
                  bJobFind = TRUE;
               }
            }
         }
         else
         {
            It = std::find_if(pairedDeviceList._deviceBaseInfoList.begin(),
                  pairedDeviceList._deviceBaseInfoList.end(),
                  MeetsDeviceHandle<DeviceBaseInfo>(poCDSFiDataObjectMethodStart->u8DeviceHandle));

            if (It != pairedDeviceList._deviceBaseInfoList.end())
            {
               devicebaseinfo = *It;

               ETG_TRACE_USR1(("updateChangeDeviceStateMR: MS Handle:%d Received Handle:%d Status:%d",\
                     poCDSFiDataObjectMethodStart->u8DeviceHandle, devicebaseinfo._deviceHandle, devicebaseinfo._connectionStatus));

               if(poCDSFiDataObjectMethodStart->e8ChangeDeviceStateAction.enType == most_fi_tcl_e8_BTSetChangeDeviceStateAction::FI_EN_E8SELECT)
               {
                  if(devicebaseinfo._connectionStatus == BM_CONNECTION_STATUS_CONNECTED)
                  {
                     e8_BTSetConnectionResult.enType = most_fi_tcl_e8_BTSetConnectionResult::FI_EN_E8DEVICE_CONNECTED;
                     bJobFind = TRUE;
                  }
                  else if((devicebaseinfo._connectionStatus == BM_CONNECTION_STATUS_DISCONNECTED) && (bResponse == FALSE))
                  {
                     // find related entry in old list
                     oldIt = std::find_if(_pairedDeviceList._deviceBaseInfoList.begin(),
                           _pairedDeviceList._deviceBaseInfoList.end(),
                           MeetsDeviceHandle<DeviceBaseInfo>(poCDSFiDataObjectMethodStart->u8DeviceHandle));

                     if (oldIt != _pairedDeviceList._deviceBaseInfoList.end())
                     {
                        olddevicebaseinfo = *oldIt;

                        if(olddevicebaseinfo._connectionStatus != devicebaseinfo._connectionStatus)
                        {
                           e8_BTSetConnectionResult.enType = most_fi_tcl_e8_BTSetConnectionResult::FI_EN_E8DEVICE_DISCONNECTED;
                           bJobFind = TRUE;
                        }
                     }
                  }
               }
               else if(poCDSFiDataObjectMethodStart->e8ChangeDeviceStateAction.enType == most_fi_tcl_e8_BTSetChangeDeviceStateAction::FI_EN_E8DISCONNECT)
               {
                  if(devicebaseinfo._connectionStatus == BM_CONNECTION_STATUS_DISCONNECTED)
                  {
                     e8_BTSetConnectionResult.enType = most_fi_tcl_e8_BTSetConnectionResult::FI_EN_E8DEVICE_DISCONNECTED;
                     bJobFind = TRUE;
                  }
                  else if((devicebaseinfo._connectionStatus == BM_CONNECTION_STATUS_CONNECTED) && (bResponse == FALSE))
                  {
                     // find related entry in old list

                     oldIt = std::find_if(_pairedDeviceList._deviceBaseInfoList.begin(),
                           _pairedDeviceList._deviceBaseInfoList.end(),
                           MeetsDeviceHandle<DeviceBaseInfo>(poCDSFiDataObjectMethodStart->u8DeviceHandle));

                     if (oldIt != _pairedDeviceList._deviceBaseInfoList.end())
                     {
                        olddevicebaseinfo = *oldIt;

                        if(olddevicebaseinfo._connectionStatus != devicebaseinfo._connectionStatus)
                        {
                           e8_BTSetConnectionResult.enType = most_fi_tcl_e8_BTSetConnectionResult::FI_EN_E8DEVICE_CONNECTED;
                           bJobFind = TRUE;
                        }
                     }
                  }
               }
            }
            else
            {
               if((poCDSFiDataObjectMethodStart->e8ChangeDeviceStateAction.enType == most_fi_tcl_e8_BTSetChangeDeviceStateAction::FI_EN_E8DELETE) ||
                     (poCDSFiDataObjectMethodStart->e8ChangeDeviceStateAction.enType == most_fi_tcl_e8_BTSetChangeDeviceStateAction::FI_EN_E8DELETE_ALL))
               {
                  e8_BTSetConnectionResult.enType = most_fi_tcl_e8_BTSetConnectionResult::FI_EN_E8NOT_APPLICABLE;
                  bJobFind = TRUE;
               }
            }
         }

         if(bJobFind == TRUE)
         {
            ChangeDeviceStateMethodResult(methodcontext, e8_BTSetConnectionResult);

            poCDSFiDataObjectMethodStart->vDestroy();
            OSAL_DELETE poCDSFiDataObjectMethodStart;

            FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(CHANGEDEVICESTATE_METHOD_FKTID, methodcontext, u16Count);
         }
      }
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::ConnectProfileResponse(const DeviceConnectionStatusList& deviceConnectionStatusList,
      tBool bResponse, BmResult result)
{
   JobList *joblist = OSAL_NULL;
   Job methodcontext;
   tBool bQuit = FALSE;
   tBool bJobFind = FALSE;
   tU16 u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;

   ETG_TRACE_USR1(("ConnectProfileResponse: bResponse: %d result:%d", bResponse, result));

   do
   {
      bJobFind = FALSE;
      bQuit = FALSE;

      joblist = FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContext(CONNECTPROFILE_METHOD_FKTID);

      if (joblist)
      {
         ETG_TRACE_USR1(("ConnectProfileResponse: size: %d", joblist->size()));

         for (JobList::iterator it = joblist->begin(); it != joblist->end(); it++)
         {
            methodcontext = (Job) *it;
            u16Count++;

            ETG_TRACE_USR1(("ConnectProfileResponse: methodcontext u16FunctionID: %d bResponse: %d u16Count - %d",
                  methodcontext.u16FunctionID, methodcontext.bResponse, u16Count));

            if(bResponse == TRUE)
            {
               if(methodcontext.bResponse == false)
               {
                  if(methodcontext.u16FunctionID == CONNECTPROFILE_METHOD_FKTID)
                  {
                     (*it).bResponse = true;

                     if(BM_RESULT_OK != result)
                     {
                        ConnectBluetoothProfileMethodError(methodcontext, u16Count);
                     }
                     else
                     {
                        updateConnectProfileMR(deviceConnectionStatusList, methodcontext, bJobFind, u16Count, bResponse);
                     }
                  }
                  else if(methodcontext.u16FunctionID == CONNECTSPPSERVICE_METHOD_FKTID)
                  {
                     if(BM_RESULT_OK != result)
                     {
                        sendMethodError(CONNECTSPPSERVICE_METHOD_FKTID, methodcontext, most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
                     }
                     else
                     {
                        ConnectSPPServiceMethodResult(methodcontext, TRUE);
                     }

                     FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(CONNECTPROFILE_METHOD_FKTID, methodcontext, u16Count);
                  }
                  else
                  {
                     FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(CONNECTPROFILE_METHOD_FKTID, methodcontext, u16Count);
                  }

                  bQuit = TRUE;
               }
               else
               {
                  ETG_TRACE_USR1(("ConnectProfileResponse: Response is already received"));
               }
            }
            else
            {
               if(methodcontext.bResponse == true)
               {
                  //MR for onConnectbluetoothprofile
                  //check if any onConnectbluetoothprofile is there in Queue.If available then only send the MethodResult.
                  //Same MethodResult should be sent to all the request in the Queue.
                  updateConnectProfileMR(deviceConnectionStatusList, methodcontext, bJobFind, u16Count, bResponse);
               }
               else
               {
                  ETG_TRACE_USR1(("ConnectProfileResponse: Response is not yet received"));
                  bQuit = TRUE;
               }
            }

            ETG_TRACE_USR1(("ConnectProfileResponse: bJobFind: %d bQuit:%d", bJobFind, bQuit));

            if((bJobFind == TRUE) || (bQuit == TRUE))
            {
               u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;
               break;
            }
         }
      }
      else
      {
         bQuit = TRUE;
      }
   }while((bJobFind == TRUE) && (bQuit == FALSE));

   return;
}

void FC_Bluetooth_tclCCAService::updateConnectProfileMR(const DeviceConnectionStatusList& deviceConnectionStatusList,
      Job& methodcontext, tBool& bJobFind, tU16& u16Count, tBool& bResponse)
{
   ENTRY_INTERNAL

   DeviceConnectionInfo deviceconnectioninfo;
   ProtocolConnectionInfo protocolconnectioninfo;
   ConnectionStatus prevConnectionStatus = BM_CONNECTION_STATUS_UNKNOWN;
   ProtocolId protocolId;
   DeviceConnectionInfoList::const_iterator It;
   most_btsetfi_tclMsgConnectBluetoothProfileMethodStart CBPFMethodResult;
   connectBluetoothProfileStruct *poConnectBluetoothProfile = NULL;
   tBool bRet = false;
   BlockState blockState = BM_BLOCK_STATE_UNBLOCKED;

   poConnectBluetoothProfile = (connectBluetoothProfileStruct *) methodcontext.poMethodArg;

   if (poConnectBluetoothProfile)
   {
      ETG_TRACE_USR1(("updateConnectProfileMR: MS Handle: %d", poConnectBluetoothProfile->CBPFiDataObjectMethodStart.u8DeviceHandle));

      It = std::find_if(deviceConnectionStatusList._deviceConnectionInfoList.begin(),
            deviceConnectionStatusList._deviceConnectionInfoList.end(),
            MeetsDeviceHandle<DeviceConnectionInfo>(poConnectBluetoothProfile->CBPFiDataObjectMethodStart.u8DeviceHandle));

      if (It != deviceConnectionStatusList._deviceConnectionInfoList.end())
      {
         deviceconnectioninfo = *It;

         CBPFMethodResult.u8DeviceHandle = poConnectBluetoothProfile->CBPFiDataObjectMethodStart.u8DeviceHandle;
         CBPFMethodResult.oServiceType.bHFP = FALSE;
         CBPFMethodResult.oServiceType.bAVP = FALSE;
         CBPFMethodResult.oServiceType.bPAN = FALSE;
         CBPFMethodResult.oServiceType.bPBAP = FALSE;
         CBPFMethodResult.oServiceType.bMAP = FALSE;

         ETG_TRACE_USR1(("updateConnectProfileMR: MS HFP: %d, AVP:%d, PAN:%d PBAP - %d MAP - %d",\
               poConnectBluetoothProfile->CBPFiDataObjectMethodStart.oServiceType.bHFP,
               poConnectBluetoothProfile->CBPFiDataObjectMethodStart.oServiceType.bAVP,
               poConnectBluetoothProfile->CBPFiDataObjectMethodStart.oServiceType.bPAN,
               poConnectBluetoothProfile->CBPFiDataObjectMethodStart.oServiceType.bPBAP,
               poConnectBluetoothProfile->CBPFiDataObjectMethodStart.oServiceType.bMAP));

         if((TRUE == poConnectBluetoothProfile->CBPFiDataObjectMethodStart.oServiceType.bPAN) &&
               (0u == _bmCoreConfiguration._protocolSupportInformation[BM_PROTOCOL_ID_PAN]._maxNumInstances))
         {
            poConnectBluetoothProfile->BTServiceType.bPAN = TRUE;
         }

         for (ProtocolConnectionInfoMap::const_iterator ItProConInfoMap = deviceconnectioninfo._protocolConnectionInfo.begin();
               ItProConInfoMap != deviceconnectioninfo._protocolConnectionInfo.end();
               ItProConInfoMap++)
         {
            protocolId = ItProConInfoMap->first;
            protocolconnectioninfo = ItProConInfoMap->second;

            ETG_TRACE_USR1(("updateConnectProfileMR : protocolId:%d status:%d",\
                  protocolId, protocolconnectioninfo._connectionStatus));

            if ((protocolId == BM_PROTOCOL_ID_HFP) && (poConnectBluetoothProfile->CBPFiDataObjectMethodStart.oServiceType.bHFP == TRUE))
            {
               if (protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_CONNECTED)
               {
                  poConnectBluetoothProfile->BTServiceType.bHFP = TRUE;
                  CBPFMethodResult.oServiceType.bHFP = TRUE;
               }
               else if((protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_DISCONNECTED) && (bResponse == FALSE))
               {
                  // find related entry in old list
                  bRet = vCheckProfileStatus(poConnectBluetoothProfile->CBPFiDataObjectMethodStart.u8DeviceHandle, protocolId, prevConnectionStatus, blockState);

                  if(bRet == true)
                  {
                     if((prevConnectionStatus != protocolconnectioninfo._connectionStatus) || (BM_BLOCK_STATE_BLOCKED == blockState))
                     {
                        poConnectBluetoothProfile->BTServiceType.bHFP = TRUE;
                     }
                  }
               }
               else
               {
                  vGetProfileBlockStatus(poConnectBluetoothProfile->CBPFiDataObjectMethodStart.u8DeviceHandle, protocolId, blockState);

                  if(BM_BLOCK_STATE_BLOCKED == blockState)
                  {
                     poConnectBluetoothProfile->BTServiceType.bHFP = TRUE;
                  }
               }
            }

            if ((protocolId == BM_PROTOCOL_ID_AVP) && (poConnectBluetoothProfile->CBPFiDataObjectMethodStart.oServiceType.bAVP == TRUE))
            {
               if (protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_CONNECTED)
               {
                  poConnectBluetoothProfile->BTServiceType.bAVP = TRUE;
                  CBPFMethodResult.oServiceType.bAVP = TRUE;
               }
               else if((protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_DISCONNECTED) && (bResponse == FALSE))
               {
                  // find related entry in old list
                  bRet = vCheckProfileStatus(poConnectBluetoothProfile->CBPFiDataObjectMethodStart.u8DeviceHandle, protocolId, prevConnectionStatus, blockState);

                  if(bRet == true)
                  {
                     if((prevConnectionStatus != protocolconnectioninfo._connectionStatus) || (BM_BLOCK_STATE_BLOCKED == blockState))
                     {
                        poConnectBluetoothProfile->BTServiceType.bAVP = TRUE;
                     }
                  }
               }
               else
               {
                  vGetProfileBlockStatus(poConnectBluetoothProfile->CBPFiDataObjectMethodStart.u8DeviceHandle, protocolId, blockState);

                  if(BM_BLOCK_STATE_BLOCKED == blockState)
                  {
                     poConnectBluetoothProfile->BTServiceType.bAVP = TRUE;
                  }
               }
            }

            if ((protocolId == BM_PROTOCOL_ID_PAN) && (poConnectBluetoothProfile->CBPFiDataObjectMethodStart.oServiceType.bPAN == TRUE))
            {
               if (protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_CONNECTED)
               {
                  poConnectBluetoothProfile->BTServiceType.bPAN = TRUE;
                  CBPFMethodResult.oServiceType.bPAN = TRUE;
               }
               else if((protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_DISCONNECTED) && (bResponse == FALSE))
               {
                  // find related entry in old list
                  bRet = vCheckProfileStatus(poConnectBluetoothProfile->CBPFiDataObjectMethodStart.u8DeviceHandle, protocolId, prevConnectionStatus, blockState);

                  if(bRet == true)
                  {
                     if((prevConnectionStatus != protocolconnectioninfo._connectionStatus) || (BM_BLOCK_STATE_BLOCKED == blockState))
                     {
                        poConnectBluetoothProfile->BTServiceType.bPAN = TRUE;
                     }
                  }
               }
               else
               {
                  vGetProfileBlockStatus(poConnectBluetoothProfile->CBPFiDataObjectMethodStart.u8DeviceHandle, protocolId, blockState);

                  if(BM_BLOCK_STATE_BLOCKED == blockState)
                  {
                     poConnectBluetoothProfile->BTServiceType.bPAN = TRUE;
                  }
               }
            }

            if ((protocolId == BM_PROTOCOL_ID_PBDL) && (poConnectBluetoothProfile->CBPFiDataObjectMethodStart.oServiceType.bPBAP == TRUE))
            {
               if (protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_CONNECTED)
               {
                  poConnectBluetoothProfile->BTServiceType.bPBAP = TRUE;
                  CBPFMethodResult.oServiceType.bPBAP = TRUE;
               }
               else if((protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_DISCONNECTED) && (bResponse == FALSE))
               {
                  // find related entry in old list
                  bRet = vCheckProfileStatus(poConnectBluetoothProfile->CBPFiDataObjectMethodStart.u8DeviceHandle, protocolId, prevConnectionStatus, blockState);

                  if(bRet == true)
                  {
                     if((prevConnectionStatus != protocolconnectioninfo._connectionStatus) || (BM_BLOCK_STATE_BLOCKED == blockState))
                     {
                        poConnectBluetoothProfile->BTServiceType.bPBAP = TRUE;
                     }
                  }
               }
               else
               {
                  vGetProfileBlockStatus(poConnectBluetoothProfile->CBPFiDataObjectMethodStart.u8DeviceHandle, protocolId, blockState);

                  if(BM_BLOCK_STATE_BLOCKED == blockState)
                  {
                     poConnectBluetoothProfile->BTServiceType.bPBAP = TRUE;
                  }
               }
            }

            if ((protocolId == BM_PROTOCOL_ID_MSG) && (poConnectBluetoothProfile->CBPFiDataObjectMethodStart.oServiceType.bMAP == TRUE))
            {
               if (protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_CONNECTED)
               {
                  poConnectBluetoothProfile->BTServiceType.bMAP = TRUE;
                  CBPFMethodResult.oServiceType.bMAP = TRUE;
               }
               else if((protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_DISCONNECTED) && (bResponse == FALSE))
               {
                  // find related entry in old list
                  bRet = vCheckProfileStatus(poConnectBluetoothProfile->CBPFiDataObjectMethodStart.u8DeviceHandle, protocolId, prevConnectionStatus, blockState);

                  if(bRet == true)
                  {
                     if((prevConnectionStatus != protocolconnectioninfo._connectionStatus) || (BM_BLOCK_STATE_BLOCKED == blockState))
                     {
                        poConnectBluetoothProfile->BTServiceType.bMAP = TRUE;
                     }
                  }
               }
               else
               {
                  vGetProfileBlockStatus(poConnectBluetoothProfile->CBPFiDataObjectMethodStart.u8DeviceHandle, protocolId, blockState);

                  if(BM_BLOCK_STATE_BLOCKED == blockState)
                  {
                     poConnectBluetoothProfile->BTServiceType.bMAP = TRUE;
                  }
               }
            }
         }

         ETG_TRACE_USR1(("updateConnectProfileMR: Service HFP: %d, AVP:%d, PAN:%d, bPBAP:%d, bMAP:%d", poConnectBluetoothProfile->BTServiceType.bHFP,
               poConnectBluetoothProfile->BTServiceType.bAVP,poConnectBluetoothProfile->BTServiceType.bPAN, poConnectBluetoothProfile->BTServiceType.bPBAP,
               poConnectBluetoothProfile->BTServiceType.bMAP));

         if ((poConnectBluetoothProfile->BTServiceType.bHFP == poConnectBluetoothProfile->CBPFiDataObjectMethodStart.oServiceType.bHFP) &&
               (poConnectBluetoothProfile->BTServiceType.bAVP == poConnectBluetoothProfile->CBPFiDataObjectMethodStart.oServiceType.bAVP) &&
               (poConnectBluetoothProfile->BTServiceType.bPAN == poConnectBluetoothProfile->CBPFiDataObjectMethodStart.oServiceType.bPAN) &&
               (poConnectBluetoothProfile->BTServiceType.bPBAP == poConnectBluetoothProfile->CBPFiDataObjectMethodStart.oServiceType.bPBAP) &&
               (poConnectBluetoothProfile->BTServiceType.bMAP == poConnectBluetoothProfile->CBPFiDataObjectMethodStart.oServiceType.bMAP))
         {
            ConnectBluetoothProfileMethodResult(methodcontext, CBPFMethodResult);

            poConnectBluetoothProfile->CBPFiDataObjectMethodStart.vDestroy();
            OSAL_DELETE poConnectBluetoothProfile;

            FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(CONNECTPROFILE_METHOD_FKTID, methodcontext, u16Count);
            bJobFind = TRUE;
         }
      }
      else
      {
         // In Reno - Cancel is received after Pairing
         if(TRUE == bResponse)
         {
            if ((poConnectBluetoothProfile->BTServiceType.bHFP == poConnectBluetoothProfile->CBPFiDataObjectMethodStart.oServiceType.bHFP) &&
                  (poConnectBluetoothProfile->BTServiceType.bAVP == poConnectBluetoothProfile->CBPFiDataObjectMethodStart.oServiceType.bAVP) &&
                  (poConnectBluetoothProfile->BTServiceType.bPAN == poConnectBluetoothProfile->CBPFiDataObjectMethodStart.oServiceType.bPAN) &&
                  (poConnectBluetoothProfile->BTServiceType.bPBAP == poConnectBluetoothProfile->CBPFiDataObjectMethodStart.oServiceType.bPBAP) &&
                  (poConnectBluetoothProfile->BTServiceType.bMAP == poConnectBluetoothProfile->CBPFiDataObjectMethodStart.oServiceType.bMAP))
            {
               ConnectBluetoothProfileMethodResult(methodcontext, poConnectBluetoothProfile->CBPFiDataObjectMethodStart);

               poConnectBluetoothProfile->CBPFiDataObjectMethodStart.vDestroy();
               OSAL_DELETE poConnectBluetoothProfile;

               FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(CONNECTPROFILE_METHOD_FKTID, methodcontext, u16Count);
               bJobFind = TRUE;
            }
         }
      }
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::DisconnectProfileResponse(const DeviceConnectionStatusList& deviceConnectionStatusList,
      tBool bResponse, BmResult result)
{
   JobList *joblist = OSAL_NULL;
   Job methodcontext;
   tBool bQuit = FALSE;
   tBool bJobFind = FALSE;
   tU16 u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;

   ETG_TRACE_USR1(("DisconnectProfileResponse: bResponse: %d result:%d", bResponse, result));

   do
   {
      bJobFind = FALSE;
      bQuit = FALSE;

      joblist = FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContext(DISCONNECTPROFILE_METHOD_FKTID);

      if (joblist)
      {
         ETG_TRACE_USR1(("DisconnectProfileResponse: size: %d", joblist->size()));

         for (JobList::iterator it = joblist->begin(); it != joblist->end(); it++)
         {
            methodcontext = (Job) *it;
            u16Count++;

            ETG_TRACE_USR1(("DisconnectProfileResponse: methodcontext u16FunctionID: %d bResponse: %d u16Count - %d",
                  methodcontext.u16FunctionID, methodcontext.bResponse, u16Count));

            if(bResponse == TRUE)
            {
               if(methodcontext.bResponse == false)
               {
                  if(methodcontext.u16FunctionID == DISCONNECTPROFILE_METHOD_FKTID)
                  {
                     (*it).bResponse = true;

                     if(BM_RESULT_OK != result)
                     {
                        DisconnectBluetoothProfileMethodError(methodcontext, u16Count);
                     }
                     else
                     {
                        updateDisconnectProfileMR(deviceConnectionStatusList, methodcontext, bJobFind, u16Count, bResponse);
                     }
                  }
                  else if(methodcontext.u16FunctionID == DISCONNECTSPPSERVICE_METHOD_FKTID)
                  {
                     if(BM_RESULT_OK != result)
                     {
                        sendMethodError(DISCONNECTSPPSERVICE_METHOD_FKTID, methodcontext, most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
                     }
                     else
                     {
                        DisconnectSPPServiceMethodResult(methodcontext, TRUE);
                     }

                     FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(DISCONNECTPROFILE_METHOD_FKTID, methodcontext, u16Count);
                  }

                  bQuit = TRUE;
               }
               else
               {
                  ETG_TRACE_USR1(("DisconnectProfileResponse: Response is already received"));
               }
            }
            else
            {
               if(methodcontext.bResponse == true)
               {
                  //MR for onDisconnectbluetoothprofile
                  //check if any onDisconnectbluetoothprofile is there in Queue.If available then only send the MethodResult.
                  //Same MethodResult should be sent to all the request in the Queue.
                  updateDisconnectProfileMR(deviceConnectionStatusList, methodcontext, bJobFind, u16Count, bResponse);
               }
               else
               {
                  ETG_TRACE_USR1(("DisconnectProfileResponse: Response is not yet received"));
                  bQuit = TRUE;
               }
            }

            ETG_TRACE_USR1(("DisconnectProfileResponse: bJobFind: %d bQuit:%d", bJobFind, bQuit));

            if((bJobFind == TRUE) || (bQuit == TRUE))
            {
               u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;
               break;
            }
         }
      }
      else
      {
         bQuit = TRUE;
      }
   }while((bJobFind == TRUE) && (bQuit == FALSE));

   return;
}

void FC_Bluetooth_tclCCAService::updateDisconnectProfileMR(const DeviceConnectionStatusList& deviceConnectionStatusList,
      Job& methodcontext, tBool& bJobFind, tU16& u16Count, tBool& bResponse)
{
   ENTRY_INTERNAL

   DeviceConnectionInfo deviceconnectioninfo;
   ProtocolConnectionInfo protocolconnectioninfo;
   ProtocolId protocolId;
   ConnectionStatus prevConnectionStatus = BM_CONNECTION_STATUS_UNKNOWN;
   DeviceConnectionInfoList::const_iterator It;
   most_btsetfi_tclMsgDisconnectBluetoothProfileMethodStart DBPFMethodResult;
   disconnectBluetoothProfileStruct *poDisconnectBluetoothProfile = NULL;
   tBool bRet = false;
   BlockState blockState = BM_BLOCK_STATE_UNBLOCKED;

   poDisconnectBluetoothProfile = (disconnectBluetoothProfileStruct *) methodcontext.poMethodArg;

   if (poDisconnectBluetoothProfile)
   {
      ETG_TRACE_USR1(("updateDisconnectProfileMR: MS Handle: %d", poDisconnectBluetoothProfile->DBPFiDataObjectMethodStart.u8DeviceHandle));

      It = std::find_if(deviceConnectionStatusList._deviceConnectionInfoList.begin(),
            deviceConnectionStatusList._deviceConnectionInfoList.end(),
            MeetsDeviceHandle<DeviceConnectionInfo>(poDisconnectBluetoothProfile->DBPFiDataObjectMethodStart.u8DeviceHandle));

      if (It != deviceConnectionStatusList._deviceConnectionInfoList.end())
      {
         deviceconnectioninfo = *It;

         DBPFMethodResult.u8DeviceHandle = poDisconnectBluetoothProfile->DBPFiDataObjectMethodStart.u8DeviceHandle;
         DBPFMethodResult.oServiceType.bHFP = FALSE;
         DBPFMethodResult.oServiceType.bAVP = FALSE;
         DBPFMethodResult.oServiceType.bPAN = FALSE;
         DBPFMethodResult.oServiceType.bPBAP = FALSE;
         DBPFMethodResult.oServiceType.bMAP = FALSE;

         ETG_TRACE_USR1(("updateDisconnectProfileMR: MS HFP: %d, AVP:%d, PAN:%d PBAP - %d MAP - %d",\
               poDisconnectBluetoothProfile->DBPFiDataObjectMethodStart.oServiceType.bHFP,
               poDisconnectBluetoothProfile->DBPFiDataObjectMethodStart.oServiceType.bAVP,
               poDisconnectBluetoothProfile->DBPFiDataObjectMethodStart.oServiceType.bPAN,
               poDisconnectBluetoothProfile->DBPFiDataObjectMethodStart.oServiceType.bPBAP,
               poDisconnectBluetoothProfile->DBPFiDataObjectMethodStart.oServiceType.bMAP));

         for (ProtocolConnectionInfoMap::const_iterator ItProConInfoMap = deviceconnectioninfo._protocolConnectionInfo.begin();
               ItProConInfoMap != deviceconnectioninfo._protocolConnectionInfo.end();
               ItProConInfoMap++)
         {
            protocolId = ItProConInfoMap->first;
            protocolconnectioninfo = ItProConInfoMap->second;

            ETG_TRACE_USR1(("updateDisconnectProfileMR : protocolId:%d status:%d",\
                  protocolId, protocolconnectioninfo._connectionStatus));

            if ((protocolId == BM_PROTOCOL_ID_HFP) && (poDisconnectBluetoothProfile->DBPFiDataObjectMethodStart.oServiceType.bHFP == TRUE))
            {
               if (protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_DISCONNECTED)
               {
                  poDisconnectBluetoothProfile->BTServiceType.bHFP = TRUE;
                  DBPFMethodResult.oServiceType.bHFP = TRUE;
               }
               else if((protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_CONNECTED) && (bResponse == FALSE))
               {
                  // find related entry in old list
                  bRet = vCheckProfileStatus(poDisconnectBluetoothProfile->DBPFiDataObjectMethodStart.u8DeviceHandle, protocolId, prevConnectionStatus, blockState);

                  if(bRet == true)
                  {
                     if(prevConnectionStatus != protocolconnectioninfo._connectionStatus)
                     {
                        poDisconnectBluetoothProfile->BTServiceType.bHFP = TRUE;
                     }
                  }
               }
            }

            if ((protocolId == BM_PROTOCOL_ID_AVP) && (poDisconnectBluetoothProfile->DBPFiDataObjectMethodStart.oServiceType.bAVP == TRUE))
            {
               if (protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_DISCONNECTED)
               {
                  poDisconnectBluetoothProfile->BTServiceType.bAVP = TRUE;
                  DBPFMethodResult.oServiceType.bAVP = TRUE;
               }
               else if((protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_CONNECTED) && (bResponse == FALSE))
               {
                  // find related entry in old list
                  bRet = vCheckProfileStatus(poDisconnectBluetoothProfile->DBPFiDataObjectMethodStart.u8DeviceHandle, protocolId, prevConnectionStatus, blockState);

                  if(bRet == true)
                  {
                     if(prevConnectionStatus != protocolconnectioninfo._connectionStatus)
                     {
                        poDisconnectBluetoothProfile->BTServiceType.bAVP = TRUE;
                     }
                  }
               }
            }

            if ((protocolId == BM_PROTOCOL_ID_PAN) && (poDisconnectBluetoothProfile->DBPFiDataObjectMethodStart.oServiceType.bPAN == TRUE))
            {
               if (protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_DISCONNECTED)
               {
                  poDisconnectBluetoothProfile->BTServiceType.bPAN = TRUE;
                  DBPFMethodResult.oServiceType.bPAN = TRUE;
               }
               else if((protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_CONNECTED) && (bResponse == FALSE))
               {
                  // find related entry in old list
                  bRet = vCheckProfileStatus(poDisconnectBluetoothProfile->DBPFiDataObjectMethodStart.u8DeviceHandle, protocolId, prevConnectionStatus, blockState);

                  if(bRet == true)
                  {
                     if(prevConnectionStatus != protocolconnectioninfo._connectionStatus)
                     {
                        poDisconnectBluetoothProfile->BTServiceType.bPAN = TRUE;
                     }
                  }
               }
            }

            if ((protocolId == BM_PROTOCOL_ID_PBDL) && (poDisconnectBluetoothProfile->DBPFiDataObjectMethodStart.oServiceType.bPBAP == TRUE))
            {
               if (protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_DISCONNECTED)
               {
                  poDisconnectBluetoothProfile->BTServiceType.bPBAP = TRUE;
                  DBPFMethodResult.oServiceType.bPBAP = TRUE;
               }
               else if((protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_CONNECTED) && (bResponse == FALSE))
               {
                  // find related entry in old list
                  bRet = vCheckProfileStatus(poDisconnectBluetoothProfile->DBPFiDataObjectMethodStart.u8DeviceHandle, protocolId, prevConnectionStatus, blockState);

                  if(bRet == true)
                  {
                     if(prevConnectionStatus != protocolconnectioninfo._connectionStatus)
                     {
                        poDisconnectBluetoothProfile->BTServiceType.bPBAP = TRUE;
                     }
                  }
               }
            }

            if ((protocolId == BM_PROTOCOL_ID_MSG) && (poDisconnectBluetoothProfile->DBPFiDataObjectMethodStart.oServiceType.bMAP == TRUE))
            {
               if (protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_DISCONNECTED)
               {
                  poDisconnectBluetoothProfile->BTServiceType.bMAP = TRUE;
                  DBPFMethodResult.oServiceType.bMAP = TRUE;
               }
               else if((protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_CONNECTED) && (bResponse == FALSE))
               {
                  // find related entry in old list
                  bRet = vCheckProfileStatus(poDisconnectBluetoothProfile->DBPFiDataObjectMethodStart.u8DeviceHandle, protocolId, prevConnectionStatus, blockState);

                  if(bRet == true)
                  {
                     if(prevConnectionStatus != protocolconnectioninfo._connectionStatus)
                     {
                        poDisconnectBluetoothProfile->BTServiceType.bMAP = TRUE;
                     }
                  }
               }
            }
         }

         ETG_TRACE_USR1(("updateDisconnectProfileMR: Service HFP:%d, AVP:%d, PAN:%d bPBAP:%d bMAP:%d", poDisconnectBluetoothProfile->BTServiceType.bHFP,
               poDisconnectBluetoothProfile->BTServiceType.bAVP, poDisconnectBluetoothProfile->BTServiceType.bPAN, poDisconnectBluetoothProfile->BTServiceType.bPBAP,
               poDisconnectBluetoothProfile->BTServiceType.bMAP));

         if ((poDisconnectBluetoothProfile->BTServiceType.bHFP == poDisconnectBluetoothProfile->DBPFiDataObjectMethodStart.oServiceType.bHFP) &&
               (poDisconnectBluetoothProfile->BTServiceType.bAVP == poDisconnectBluetoothProfile->DBPFiDataObjectMethodStart.oServiceType.bAVP) &&
               (poDisconnectBluetoothProfile->BTServiceType.bPAN == poDisconnectBluetoothProfile->DBPFiDataObjectMethodStart.oServiceType.bPAN) &&
               (poDisconnectBluetoothProfile->BTServiceType.bPBAP == poDisconnectBluetoothProfile->DBPFiDataObjectMethodStart.oServiceType.bPBAP) &&
               (poDisconnectBluetoothProfile->BTServiceType.bMAP == poDisconnectBluetoothProfile->DBPFiDataObjectMethodStart.oServiceType.bMAP))
         {
            DisconnectBluetoothProfileMethodResult(methodcontext, DBPFMethodResult);

            poDisconnectBluetoothProfile->DBPFiDataObjectMethodStart.vDestroy();
            OSAL_DELETE poDisconnectBluetoothProfile;

            FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(DISCONNECTPROFILE_METHOD_FKTID, methodcontext, u16Count);
            bJobFind = TRUE;
         }
      }
      else
      {
         ETG_TRACE_USR1(("updateDisconnectProfileMR: devicehandle not in the list"));

         DisconnectBluetoothProfileMethodResult(methodcontext, poDisconnectBluetoothProfile->DBPFiDataObjectMethodStart);

         poDisconnectBluetoothProfile->DBPFiDataObjectMethodStart.vDestroy();
         OSAL_DELETE poDisconnectBluetoothProfile;

         FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(DISCONNECTPROFILE_METHOD_FKTID, methodcontext, u16Count);
         bJobFind = TRUE;
      }
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::SwitchLocalPairableModeResponse(BmResult result)
{
   JobList *joblist = OSAL_NULL;
   Job methodcontext;
   tU16 u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;

   ETG_TRACE_USR1(("SwitchLocalPairableModeResponse: result:%d", result));

   joblist = FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContext(ADDNEWDEVICE_METHOD_FKTID);

   if (joblist)
   {
      ETG_TRACE_USR1(("SwitchLocalPairableModeResponse: size: %d", joblist->size()));

      for (JobList::iterator it = joblist->begin(); it != joblist->end(); it++)
      {
         methodcontext = (Job) *it;
         u16Count++;

         ETG_TRACE_USR1(("SwitchLocalPairableModeResponse: methodcontext u16FunctionID: %d bResponse: %d u16Count - %d",
               methodcontext.u16FunctionID, methodcontext.bResponse, u16Count));

         if(methodcontext.bResponse == false)
         {
            if(methodcontext.u16FunctionID == ADDNEWDEVICE_METHOD_FKTID)
            {
               (*it).bResponse = true;

               if (BM_RESULT_OK != result)
               {
                  sendMethodError(ADDNEWDEVICE_METHOD_FKTID, methodcontext, most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
                  FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(ADDNEWDEVICE_METHOD_FKTID, methodcontext, u16Count);
               }
               else
               {
                  if(_bmCoreConfiguration._useFixedPinLegacyPairing == TRUE)
                  {
                     ETG_TRACE_USR1(("SwitchLocalPairableModeResponse: update PairingPin property to clients"));
                     updateClients(MOST_BTSETFI_C_U16_PAIRINGPIN);
                  }
               }
            }
            else if(methodcontext.u16FunctionID == SWITCHBTLOCALMODE_METHOD_FKTID)
            {
               most_btsetfi_tclMsgSwitchBTLocalModeMethodStart *poSLCFiDataObjectMethodStart = NULL;

               poSLCFiDataObjectMethodStart = (most_btsetfi_tclMsgSwitchBTLocalModeMethodStart *) methodcontext.poMethodArg;

               if(poSLCFiDataObjectMethodStart)
               {
                  if (BM_RESULT_OK == result)
                  {
                     (*it).bResponse = true;

                     if((poSLCFiDataObjectMethodStart->Pairable.enType == most_fi_tcl_BTLocalModeType::FI_EN_E8ON) && (_bmCoreConfiguration._useFixedPinLegacyPairing == TRUE))
                     {
                        ETG_TRACE_USR1(("SwitchLocalPairableModeResponse: update PairingPin property to clients"));
                        updateClients(MOST_BTSETFI_C_U16_PAIRINGPIN);
                     }
                  }
                  else
                  {
                     sendMethodError(SWITCHBTLOCALMODE_METHOD_FKTID, methodcontext, most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);

                     poSLCFiDataObjectMethodStart->vDestroy();
                     OSAL_DELETE poSLCFiDataObjectMethodStart;

                     FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(ADDNEWDEVICE_METHOD_FKTID, methodcontext, u16Count);
                  }
               }
            }

            break;
         }
         else
         {
            ETG_TRACE_USR1(("SwitchLocalPairableModeResponse: Response is already received"));
         }
      }
   }

   return;
}


tVoid FC_Bluetooth_tclCCAService::SwitchLocalConnectableModeResponse(BmResult result)
{
   JobList *joblist = OSAL_NULL;
   Job methodcontext;
   tU16 u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;

   ETG_TRACE_USR1(("SwitchLocalConnectableModeResponse: result:%d", result));

   joblist = FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContext(ADDNEWDEVICE_METHOD_FKTID);

   if (joblist)
   {
      ETG_TRACE_USR1(("SwitchLocalConnectableModeResponse: size: %d", joblist->size()));

      for (JobList::iterator it = joblist->begin(); it != joblist->end(); it++)
      {
         methodcontext = (Job) *it;
         u16Count++;

         ETG_TRACE_USR1(("SwitchLocalConnectableModeResponse: methodcontext u16FunctionID: %d bResponse: %d u16Count - %d",
               methodcontext.u16FunctionID, methodcontext.bResponse, u16Count));

         if((methodcontext.u16FunctionID == SWITCHBTLOCALMODE_METHOD_FKTID) && (methodcontext.bResponse == true))
         {
            if (BM_RESULT_OK != result)
            {
               SwitchBTLocalModeMethodResult(methodcontext, FALSE);
            }
            else
            {
               SwitchBTLocalModeMethodResult(methodcontext, TRUE);
            }

            most_btsetfi_tclMsgSwitchBTLocalModeMethodStart *poSLCFiDataObjectMethodStart = NULL;

            poSLCFiDataObjectMethodStart = (most_btsetfi_tclMsgSwitchBTLocalModeMethodStart *) methodcontext.poMethodArg;

            if(poSLCFiDataObjectMethodStart)
            {
               poSLCFiDataObjectMethodStart->vDestroy();
               OSAL_DELETE poSLCFiDataObjectMethodStart;
            }

            FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(ADDNEWDEVICE_METHOD_FKTID, methodcontext, u16Count);

            break;
         }
         else
         {
            ETG_TRACE_USR1(("SwitchLocalConnectableModeResponse: Response is not received"));
         }
      }
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::AddOobPairedDeviceResponse(BmResult result)
{
   JobList *joblist = OSAL_NULL;
   Job methodcontext;
   tBool bQuit = FALSE;
   tU16 u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;

   ETG_TRACE_USR1(("AddOobPairedDeviceResponse: result:%d", result));

   do
   {
      bQuit = FALSE;

      joblist = FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContext(ADDOOBPAIREDDEVICE_METHOD_FKTID);

      if (joblist)
      {
         ETG_TRACE_USR1(("AddOobPairedDeviceResponse: size: %d", joblist->size()));

         for (JobList::iterator it = joblist->begin(); it != joblist->end(); it++)
         {
            methodcontext = (Job) *it;
            u16Count++;

            ETG_TRACE_USR1(("AddOobPairedDeviceResponse: methodcontext bResponse: %d u16Count - %d",
                  methodcontext.bResponse, u16Count));

            if(methodcontext.bResponse == false)
            {
               if(BM_RESULT_OK != result)
               {
                  sendMethodError(ADDOOBPAIREDDEVICE_METHOD_FKTID, methodcontext, most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
               }
               else
               {
                  AddOobPairedDeviceMethodResult(methodcontext, TRUE);
               }

               FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(ADDOOBPAIREDDEVICE_METHOD_FKTID, methodcontext, u16Count);

               bQuit = TRUE;
            }
            else
            {
               ETG_TRACE_USR1(("AddOobPairedDeviceResponse: Response is already received"));
            }

            ETG_TRACE_USR1(("AddOobPairedDeviceResponse: bQuit:%d", bQuit));

            if(bQuit == TRUE)
            {
               u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;
               break;
            }
         }
      }
      else
      {
         bQuit = TRUE;
      }
   }while(bQuit == FALSE);

   return;
}

tVoid FC_Bluetooth_tclCCAService::SetFavoriteResponse(BmResult result)
{
   JobList *joblist = OSAL_NULL;
   Job methodcontext;
   tBool bQuit = FALSE;
   tU16 u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;

   ETG_TRACE_USR1(("SetFavoriteResponse: result:%d", result));

   do
   {
      bQuit = FALSE;

      joblist = FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContext(SETFAVORITE_METHOD_FKTID);

      if (joblist)
      {
         ETG_TRACE_USR1(("SetFavoriteResponse: size: %d", joblist->size()));

         for (JobList::iterator it = joblist->begin(); it != joblist->end(); it++)
         {
            methodcontext = (Job) *it;
            u16Count++;

            ETG_TRACE_USR1(("SetFavoriteResponse: methodcontext bResponse: %d u16Count - %d",
                  methodcontext.bResponse, u16Count));

            if(methodcontext.bResponse == false)
            {
               if(BM_RESULT_OK != result)
               {
                  sendMethodError(SETFAVORITE_METHOD_FKTID, methodcontext, most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
               }
               else
               {
                  SetFavoriteMethodResult(methodcontext, TRUE);
               }

               FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(SETFAVORITE_METHOD_FKTID, methodcontext, u16Count);

               bQuit = TRUE;
            }
            else
            {
               ETG_TRACE_USR1(("SetFavoriteResponse: Response is already received"));
            }

            ETG_TRACE_USR1(("SetFavoriteResponse: bQuit:%d", bQuit));

            if(bQuit == TRUE)
            {
               u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;
               break;
            }
         }
      }
      else
      {
         bQuit = TRUE;
      }
   }while(bQuit == FALSE);

   return;
}

tVoid FC_Bluetooth_tclCCAService::ClearFavoriteResponse(BmResult result)
{
   JobList *joblist = OSAL_NULL;
   Job methodcontext;
   tBool bQuit = FALSE;
   tU16 u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;

   ETG_TRACE_USR1(("ClearFavoriteResponse: result:%d", result));

   do
   {
      bQuit = FALSE;

      joblist = FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContext(CLEARFAVORITE_METHOD_FKTID);

      if (joblist)
      {
         ETG_TRACE_USR1(("ClearFavoriteResponse: size: %d", joblist->size()));

         for (JobList::iterator it = joblist->begin(); it != joblist->end(); it++)
         {
            methodcontext = (Job) *it;
            u16Count++;

            ETG_TRACE_USR1(("ClearFavoriteResponse: methodcontext bResponse: %d u16Count - %d",
                  methodcontext.bResponse, u16Count));

            if(methodcontext.bResponse == false)
            {
               if(BM_RESULT_OK != result)
               {
                  sendMethodError(CLEARFAVORITE_METHOD_FKTID, methodcontext, most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
               }
               else
               {
                  ClearFavoriteMethodResult(methodcontext, TRUE);
               }

               FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(CLEARFAVORITE_METHOD_FKTID, methodcontext, u16Count);

               bQuit = TRUE;
            }
            else
            {
               ETG_TRACE_USR1(("ClearFavoriteResponse: Response is already received"));
            }

            ETG_TRACE_USR1(("ClearFavoriteResponse: bQuit:%d", bQuit));

            if(bQuit == TRUE)
            {
               u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;
               break;
            }
         }
      }
      else
      {
         bQuit = TRUE;
      }
   }while(bQuit == FALSE);

   return;
}

tVoid FC_Bluetooth_tclCCAService::MultiHFPSupportResponse(BmResult result)
{
   JobList *joblist = OSAL_NULL;
   Job methodcontext;
   tBool bQuit = FALSE;
   tU16 u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;

   ETG_TRACE_USR1(("MultiHFPSupportResponse: result:%d", result));

   do
   {
      bQuit = FALSE;

      joblist = FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContext(SWITCHMULTIHFPSUPPORT_METHOD_FKTID);

      if (joblist)
      {
         ETG_TRACE_USR1(("MultiHFPSupportResponse: size: %d", joblist->size()));

         for (JobList::iterator it = joblist->begin(); it != joblist->end(); it++)
         {
            methodcontext = (Job) *it;
            u16Count++;

            ETG_TRACE_USR1(("MultiHFPSupportResponse: methodcontext bResponse: %d u16Count - %d",
                  methodcontext.bResponse, u16Count));

            if(methodcontext.bResponse == false)
            {
               if(BM_RESULT_OK != result)
               {
                  sendMethodError(SWITCHMULTIHFPSUPPORT_METHOD_FKTID, methodcontext, most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
               }
               else
               {
                  SwitchMultiHFPSupportMethodResult(methodcontext, TRUE);
               }

               FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(SWITCHMULTIHFPSUPPORT_METHOD_FKTID, methodcontext, u16Count);

               bQuit = TRUE;
            }
            else
            {
               ETG_TRACE_USR1(("MultiHFPSupportResponse: Response is already received"));
            }

            ETG_TRACE_USR1(("MultiHFPSupportResponse: bQuit:%d", bQuit));

            if(bQuit == TRUE)
            {
               u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;
               break;
            }
         }
      }
      else
      {
         bQuit = TRUE;
      }
   }while(bQuit == FALSE);

   return;
}

tVoid FC_Bluetooth_tclCCAService::SetDeviceUsagePreferenceResponse(BmResult result)
{
   JobList *joblist = OSAL_NULL;
   Job methodcontext;
   tBool bQuit = FALSE;
   tU16 u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;

   ETG_TRACE_USR1(("SetDeviceUsagePreferenceResponse: result:%d", result));

   do
   {
      bQuit = FALSE;

      joblist = FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContext(SETUSAGEPREFERENCE_METHOD_FKTID);

      if (joblist)
      {
         ETG_TRACE_USR1(("SetDeviceUsagePreferenceResponse: size: %d", joblist->size()));

         for (JobList::iterator it = joblist->begin(); it != joblist->end(); it++)
         {
            methodcontext = (Job) *it;
            u16Count++;

            ETG_TRACE_USR1(("SetDeviceUsagePreferenceResponse: methodcontext bResponse: %d u16Count - %d",
                  methodcontext.bResponse, u16Count));

            if(methodcontext.bResponse == false)
            {
               if(BM_RESULT_OK != result)
               {
                  sendMethodError(SETUSAGEPREFERENCE_METHOD_FKTID, methodcontext, most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
               }
               else
               {
                  SetDeviceUsagePreferenceMethodResult(methodcontext, TRUE);
               }

               FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(SETUSAGEPREFERENCE_METHOD_FKTID, methodcontext, u16Count);

               bQuit = TRUE;
            }
            else
            {
               ETG_TRACE_USR1(("SetDeviceUsagePreferenceResponse: Response is already received"));
            }

            ETG_TRACE_USR1(("SetDeviceUsagePreferenceResponse: bQuit:%d", bQuit));

            if(bQuit == TRUE)
            {
               u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;
               break;
            }
         }
      }
      else
      {
         bQuit = TRUE;
      }
   }while(bQuit == FALSE);

   return;
}

tVoid FC_Bluetooth_tclCCAService::SetPrimaryResponse(BmResult result)
{
   JobList *joblist = OSAL_NULL;
   Job methodcontext;
   tBool bQuit = FALSE;
   tU16 u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;

   ETG_TRACE_USR1(("SetPrimaryResponse: result:%d", result));

   do
   {
      bQuit = FALSE;

      joblist = FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContext(SETPRIMARY_METHOD_FKTID);

      if (joblist)
      {
         ETG_TRACE_USR1(("SetPrimaryResponse: size: %d", joblist->size()));

         for (JobList::iterator it = joblist->begin(); it != joblist->end(); it++)
         {
            methodcontext = (Job) *it;
            u16Count++;

            ETG_TRACE_USR1(("SetPrimaryResponse: methodcontext bResponse: %d u16Count - %d",
                  methodcontext.bResponse, u16Count));

            if(methodcontext.bResponse == false)
            {
               if(BM_RESULT_OK != result)
               {
                  sendMethodError(SETPRIMARY_METHOD_FKTID, methodcontext, most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
               }
               else
               {
                  SetPrimaryMethodResult(methodcontext, TRUE);
               }

               FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(SETPRIMARY_METHOD_FKTID, methodcontext, u16Count);

               bQuit = TRUE;
            }
            else
            {
               ETG_TRACE_USR1(("SetPrimaryResponse: Response is already received"));
            }

            ETG_TRACE_USR1(("SetPrimaryResponse: bQuit:%d", bQuit));

            if(bQuit == TRUE)
            {
               u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;
               break;
            }
         }
      }
      else
      {
         bQuit = TRUE;
      }
   }while(bQuit == FALSE);

   return;
}

tVoid FC_Bluetooth_tclCCAService::SetBtPrfoilesUsageInfoResponse(BmResult result)
{
   JobList *joblist = OSAL_NULL;
   Job methodcontext;
   tBool bQuit = FALSE;
   tU16 u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;

   ETG_TRACE_USR1(("SetBtPrfoilesUsageInfoResponse: result:%d", result));

   do
   {
      bQuit = FALSE;

      joblist = FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContext(SETBTPROFILESUSAGE_METHOD_FKTID);

      if (joblist)
      {
         ETG_TRACE_USR1(("SetBtPrfoilesUsageInfoResponse: size: %d", joblist->size()));

         for (JobList::iterator it = joblist->begin(); it != joblist->end(); it++)
         {
            methodcontext = (Job) *it;
            u16Count++;

            ETG_TRACE_USR1(("SetBtPrfoilesUsageInfoResponse: methodcontext bResponse: %d u16Count - %d",
                  methodcontext.bResponse, u16Count));

            if(methodcontext.bResponse == false)
            {
               if(BM_RESULT_OK != result)
               {
                  sendMethodError(SETBTPROFILESUSAGE_METHOD_FKTID, methodcontext, most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
               }
               else
               {
                  SetBtPrfoilesUsageMethodResult(methodcontext, TRUE);
               }

               FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(SETBTPROFILESUSAGE_METHOD_FKTID, methodcontext, u16Count);

               bQuit = TRUE;
            }
            else
            {
               ETG_TRACE_USR1(("SetBtPrfoilesUsageInfoResponse: Response is already received"));
            }

            ETG_TRACE_USR1(("SetBtPrfoilesUsageInfoResponse: bQuit:%d", bQuit));

            if(bQuit == TRUE)
            {
               u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;
               break;
            }
         }
      }
      else
      {
         bQuit = TRUE;
      }
   }while(bQuit == FALSE);

   return;
}

tVoid FC_Bluetooth_tclCCAService::ResolveConflictsResponse(BmResult result)
{
   JobList *joblist = OSAL_NULL;
   Job methodcontext;
   tBool bQuit = FALSE;
   tU16 u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;

   ETG_TRACE_USR1(("ResolveConflictsResponse: result:%d", result));

   do
   {
      bQuit = FALSE;

      joblist = FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContext(RESOLVE_CONFLICTS_METHOD_FKTID);

      if (joblist)
      {
         ETG_TRACE_USR1(("ResolveConflictsResponse: size: %d", joblist->size()));

         for (JobList::iterator it = joblist->begin(); it != joblist->end(); it++)
         {
            methodcontext = (Job) *it;
            u16Count++;

            ETG_TRACE_USR1(("ResolveConflictsResponse: methodcontext bResponse: %d u16Count - %d",
                  methodcontext.bResponse, u16Count));

            if(methodcontext.bResponse == false)
            {
               if(BM_RESULT_OK != result)
               {
                  sendMethodError(RESOLVE_CONFLICTS_METHOD_FKTID, methodcontext, most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
               }
               else
               {
                  ResolveConflictsMethodResult(methodcontext, TRUE);
               }

               FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(RESOLVE_CONFLICTS_METHOD_FKTID, methodcontext, u16Count);

               bQuit = TRUE;
            }
            else
            {
               ETG_TRACE_USR1(("ResolveConflictsResponse: Response is already received"));
            }

            ETG_TRACE_USR1(("ResolveConflictsResponse: bQuit:%d", bQuit));

            if(bQuit == TRUE)
            {
               u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;
               break;
            }
         }
      }
      else
      {
         bQuit = TRUE;
      }
   }while(bQuit == FALSE);

   return;
}

tVoid FC_Bluetooth_tclCCAService::ReplaceBluetoothLimitationModeResponse(BmResult result)
{
   JobList *joblist = OSAL_NULL;
   Job methodcontext;
   tU16 u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;

   ETG_TRACE_USR1(("ReplaceBluetoothLimitationModeResponse: result:%d", result));

   // Get the list of job available for ReplaceBluetoothMode Method in the map using the FKID
   joblist = FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContext(REPLACEBTLIMITATIONMODE_METHOD_FKTID);

   // Check the job list is not empty
   if (joblist)
   {
      ETG_TRACE_USR1(("ReplaceBluetoothLimitationModeResponse: size: %d", joblist->size()));

      // iterate the job list
      for (JobList::iterator it = joblist->begin(); it != joblist->end(); it++)
      {
         methodcontext = (Job) *it;
         u16Count++;

         ETG_TRACE_USR1(("ReplaceBluetoothLimitationModeResponse: methodcontext bResponse: %d u16Count - %d",
               methodcontext.bResponse, u16Count));

         // BMCore process the request in order of FIFO. So that only CCA layer get the response in the order of request send.
         // check the response for the job is false. If the response is false i.e (response is received for this request)
         // then based on the result either send MR or ME
         if(methodcontext.bResponse == false)
         {
            if(BM_RESULT_OK != result)
            {
               sendMethodError(REPLACEBTLIMITATIONMODE_METHOD_FKTID, methodcontext, most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
            }
            else
            {
               ReplaceBluetoothLimitationModeMethodResult(methodcontext, TRUE);
            }

            // pop the job from the list
            FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(REPLACEBTLIMITATIONMODE_METHOD_FKTID, methodcontext, u16Count);

            break;
         }
         else
         {
            ETG_TRACE_USR1(("ReplaceBluetoothLimitationModeResponse: Response is already received"));
         }
      }
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::SetProfileUserAvailabilityResponse(BmResult result)
{
   JobList *joblist = OSAL_NULL;
   Job methodcontext;
   tBool bQuit = FALSE;
   tU16 u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;

   ETG_TRACE_USR1(("SetProfileUserAvailabilityResponse: result:%d", result));

   do
   {
      bQuit = FALSE;

      joblist = FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContext(SETPROFILEUSERAVAILABILITY_METHOD_FKTID);

      if (joblist)
      {
         ETG_TRACE_USR1(("SetProfileUserAvailabilityResponse: size: %d", joblist->size()));

         for (JobList::iterator it = joblist->begin(); it != joblist->end(); it++)
         {
            methodcontext = (Job) *it;
            u16Count++;

            ETG_TRACE_USR1(("SetProfileUserAvailabilityResponse: methodcontext bResponse: %d u16Count - %d",
                  methodcontext.bResponse, u16Count));

            if(methodcontext.bResponse == false)
            {
               if(BM_RESULT_OK != result)
               {
                  sendMethodError(SETPROFILEUSERAVAILABILITY_METHOD_FKTID, methodcontext, most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
               }
               else
               {
                  SetProfileUserAvailabilityMethodResult(methodcontext, TRUE);
               }

               FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(SETPROFILEUSERAVAILABILITY_METHOD_FKTID, methodcontext, u16Count);

               bQuit = TRUE;
            }
            else
            {
               ETG_TRACE_USR1(("SetProfileUserAvailabilityResponse: Response is already received"));
            }

            ETG_TRACE_USR1(("SetProfileUserAvailabilityResponse: bQuit:%d", bQuit));

            if(bQuit == TRUE)
            {
               u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;
               break;
            }
         }
      }
      else
      {
         bQuit = TRUE;
      }
   }while(bQuit == FALSE);

   return;
}

tVoid FC_Bluetooth_tclCCAService::StartAutoconnectSeqResponse(BmResult result)
{
   JobList *joblist = OSAL_NULL;
   Job methodcontext;
   tBool bQuit = FALSE;
   tU16 u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;

   ETG_TRACE_USR1(("StartAutoconnectSeqResponse: result:%d", result));

   do
   {
      bQuit = FALSE;

      // Read the  method jobs(start auto connect) from queue
      joblist = FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContext(STARTAUTOCONNECTSEQ_METHOD_FKTID);

      if (joblist)
      {
         ETG_TRACE_USR1(("StartAutoconnectSeqResponse: size: %d", joblist->size()));

         for (JobList::iterator it = joblist->begin(); it != joblist->end();)
         {
            methodcontext = (Job) *it;
            u16Count++;

            ETG_TRACE_USR1(("StartAutoconnectSeqResponse: methodcontext u16FunctionID: %d bResponse: %d u16Count - %d",
                  methodcontext.u16FunctionID, methodcontext.bResponse, u16Count));

            // check whether the update is immediate response or Property changes. if the update is immediate response then update the corresponding method context
            // as response - RECEIVED and check the result. if the result is NOT_OK then send the ME to the corresponding method else send the MR
            // to the corresponding method
            if(methodcontext.bResponse == false)
            {
               if(methodcontext.u16FunctionID == STARTAUTOCONNECTSEQ_METHOD_FKTID)
               {
                  (*it).bResponse = true;

                  if(BM_RESULT_OK != result)
                  {
                     // send the ME
                     sendMethodError(STARTAUTOCONNECTSEQ_METHOD_FKTID, methodcontext, most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
                  }
                  else
                  {
                     //send the MR
                     StartAutoConnectSeqMethodResult(methodcontext, TRUE);
                  }

                  //remove the method from queue
                  FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(STARTAUTOCONNECTSEQ_METHOD_FKTID, methodcontext, u16Count);
               } //! End of if(methodcontext.u16FunctionID == STARTAUTOCONNECTSEQ_METHOD_FKTID)
               else
               {
                  //remove the method from queue once the response is received and function Id is DUMMY
                  FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(STARTAUTOCONNECTSEQ_METHOD_FKTID, methodcontext, u16Count);
               }

               bQuit = TRUE;
            }
            else
            {
               ETG_TRACE_USR1(("StartAutoconnectSeqResponse: Response is already received"));
            }

            ETG_TRACE_USR1(("StartAutoconnectSeqResponse: bQuit:%d", bQuit));

            if(bQuit == TRUE)
            {
               u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;
               break;
            }
         }
      }
      else
      {
         bQuit = TRUE;
      }
   }while(bQuit == FALSE);

   return;
}

tVoid FC_Bluetooth_tclCCAService::updatePairingResponse(const PairingStatus& btPairingStatus, tBool bResponse, BmResult result)
{
   JobList *joblist = OSAL_NULL;
   Job methodcontext;
   tBool bQuit = FALSE;
   tBool bJobFind = FALSE;
   tU16 u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;

   ETG_TRACE_USR1(("updatePairingResponse: bResponse: %d result:%d", bResponse, result));

   do
   {
      bJobFind = FALSE;
      bQuit = FALSE;

      // Read the  method jobs(pairing response) from queue
      joblist = FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContext(PAIRINGRESPONSE_METHOD_FKTID);

      if (joblist)
      {
         ETG_TRACE_USR1(("PairingResponse: size: %d", joblist->size()));

         for (JobList::iterator it = joblist->begin(); it != joblist->end(); it++)
         {
            methodcontext = (Job) *it;
            u16Count++;

            ETG_TRACE_USR1(("updatePairingResponse: methodcontext u16FunctionID: %d bResponse: %d u16Count - %d",
                  methodcontext.u16FunctionID, methodcontext.bResponse, u16Count));

            // check whether the update is immediate response or Property changes. if the update is immediate response then update the corresponding method context
            // as response - RECEIVED and check the result. if the result is NOT_OK then send the ME to the corresponding method.
            if(bResponse == TRUE)
            {
               if(methodcontext.bResponse == false)
               {
                  (*it).bResponse = true;

                  if(BM_RESULT_OK != result)
                  {
                     sendMethodError(PAIRINGRESPONSE_METHOD_FKTID, methodcontext, most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);

                     FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(PAIRINGRESPONSE_METHOD_FKTID, methodcontext, u16Count);
                  }

                  bQuit = TRUE;
               }
               else
               {
                  ETG_TRACE_USR1(("updatePairingResponse: Response is already received"));
               }
            }
            else
            {
               // check and send the MR only if the immediate response is received for the corresponding method
               if(methodcontext.bResponse == true)
               {
                  // check the MR is available for the corresponding method request. if available then send the MR to the request.
                  //MR for PairingResponse
                  PairingResponseMethodResult(((Job) *it), btPairingStatus._result);
                  FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(PAIRINGRESPONSE_METHOD_FKTID, methodcontext, u16Count);
                  bJobFind = TRUE;
               }
               else
               {
                  ETG_TRACE_USR1(("updatePairingResponse: Response is not yet received"));
                  bQuit = TRUE;
               }
            }

            ETG_TRACE_USR1(("PairingResponse: bJobFind: %d bQuit:%d", bJobFind, bQuit));

            if((bJobFind == TRUE) || (bQuit == TRUE))
            {
               u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;
               break;
            }
         }
      }
      else
      {
         bQuit = TRUE;
      }
   }while((bJobFind == TRUE) && (bQuit == FALSE));

   return;
}

tVoid FC_Bluetooth_tclCCAService::StartServiceSearchResponse(BmResult result)
{
   JobList *joblist = OSAL_NULL;
   Job methodcontext;
   tU16 u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;

   ETG_TRACE_USR1(("StartServiceSearchResponse: result:%d", result));

   joblist = FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContext(STARTSEARCHSPPSERVICES_METHOD_FKTID);

   if (joblist)
   {
      ETG_TRACE_USR1(("StartServiceSearchResponse: size: %d", joblist->size()));

      for (JobList::iterator it = joblist->begin(); it != joblist->end(); )
      {
         methodcontext = (Job) *it;
         u16Count++;

         ETG_TRACE_USR1(("SetDeviceUsagePreferenceResponse: methodcontext bResponse: %d u16Count - %d",
               methodcontext.bResponse, u16Count));

         if(methodcontext.bResponse == false)
         {
            if(BM_RESULT_OK != result)
            {
               sendMethodError(STARTSEARCHSPPSERVICES_METHOD_FKTID, methodcontext, most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
            }
            else
            {
               StartServiceSearchMethodResult(methodcontext, TRUE);
            }

            FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(STARTSEARCHSPPSERVICES_METHOD_FKTID, methodcontext, u16Count);
            break;
         }
         else
         {
            ETG_TRACE_USR1(("StartServiceSearchResponse: Response is already received"));
            it++;
         }
      }
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::StopServiceSearchResponse(BmResult result)
{
   JobList *joblist = OSAL_NULL;
   Job methodcontext;
   tU16 u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;

   ETG_TRACE_USR1(("StopServiceSearchResponse: result:%d", result));

   joblist = FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContext(STOPSEARCHSPPSERVICES_METHOD_FKTID);

   if (joblist)
   {
      ETG_TRACE_USR1(("StopServiceSearchResponse: size: %d", joblist->size()));

      for (JobList::iterator it = joblist->begin(); it != joblist->end();)
      {
         methodcontext = (Job) *it;
         u16Count++;

         ETG_TRACE_USR1(("StopServiceSearchResponse: methodcontext bResponse: %d u16Count - %d",
               methodcontext.bResponse, u16Count));

         if(methodcontext.bResponse == false)
         {
            if(BM_RESULT_OK != result)
            {
               sendMethodError(STOPSEARCHSPPSERVICES_METHOD_FKTID, methodcontext, most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
            }
            else
            {
               StopServiceSearchMethodResult(methodcontext, TRUE);
            }

            FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(STOPSEARCHSPPSERVICES_METHOD_FKTID, methodcontext, u16Count);
            break;
         }
         else
         {
            ETG_TRACE_USR1(("StopServiceSearchResponse: Response is already received"));
            it++;
         }
      }
   }

   return;
}

tBool FC_Bluetooth_tclCCAService::vCheckDeviceConnectionStatus(DeviceId deviceHandle, ConnectionStatus &connectionStatus)
{
   DeviceConnectionInfoList::iterator It;
   tBool bRet = false;

   It = std::find_if(_deviceConnectionStatusList._deviceConnectionInfoList.begin(),
         _deviceConnectionStatusList._deviceConnectionInfoList.end(),
         MeetsDeviceHandle<DeviceConnectionInfo>(deviceHandle));

   if (It != _deviceConnectionStatusList._deviceConnectionInfoList.end())
   {
      connectionStatus = It->_connectionStatus;
      bRet = true;
      ETG_TRACE_USR1(("vCheckDeviceConnectionStatus: deviceHandle:%d status:%d", deviceHandle, connectionStatus));
   }

   return bRet;
}

tBool FC_Bluetooth_tclCCAService::vCheckProfileStatus(DeviceId deviceHandle, ProtocolId protocolId, ConnectionStatus &connectionStatus, BlockState &blockState)
{
   DeviceConnectionInfo deviceconnectioninfo;
   ProtocolId oldprotocolId;
   ProtocolConnectionInfo protocolconnectioninfo;
   DeviceConnectionInfoList::iterator It;
   tBool bRet = false;

   connectionStatus = BM_CONNECTION_STATUS_UNKNOWN;

   It = std::find_if(_deviceConnectionStatusList._deviceConnectionInfoList.begin(),
         _deviceConnectionStatusList._deviceConnectionInfoList.end(),
         MeetsDeviceHandle<DeviceConnectionInfo>(deviceHandle));

   if (It != _deviceConnectionStatusList._deviceConnectionInfoList.end())
   {
      deviceconnectioninfo = *It;
      for (ProtocolConnectionInfoMap::const_iterator ItProConInfoMap = deviceconnectioninfo._protocolConnectionInfo.begin();
            ItProConInfoMap != deviceconnectioninfo._protocolConnectionInfo.end();
            ItProConInfoMap++)
      {
         oldprotocolId = ItProConInfoMap->first;
         protocolconnectioninfo = ItProConInfoMap->second;

         if(oldprotocolId == protocolId)
         {
            connectionStatus = protocolconnectioninfo._connectionStatus;
            ETG_TRACE_USR4(("vCheckProfileStatus: Protocol:%d status:%d", oldprotocolId, connectionStatus));
            bRet = true;
            break;
         }
      }
   }

   vGetProfileBlockStatus(deviceHandle, protocolId, blockState);

   return bRet;
}

tVoid FC_Bluetooth_tclCCAService::vGetProfileBlockStatus(DeviceId deviceHandle, ProtocolId protocolId, BlockState &blockState)
{
   ETG_TRACE_USR1(("vGetProfileBlockStatus: deviceHandle - %d protocolId - %d", deviceHandle, protocolId));

   blockState = BM_BLOCK_STATE_UNBLOCKED;

   if(BM_OVERALL_BLOCK_STATE_UNBLOCKED == _blockStatus._overallDeviceBlockStatus._blockState)
   {
      DeviceBlockStatus deviceBlockStatus;
      DeviceBlockStatusList::const_iterator ItDBSL;

      ItDBSL = std::find_if(_blockStatus._deviceBlockStatusList.begin(),
            _blockStatus._deviceBlockStatusList.end(),
            MeetsDeviceHandle<DeviceBlockStatus>(deviceHandle));

      if (ItDBSL != _blockStatus._deviceBlockStatusList.end())
      {
         deviceBlockStatus = *ItDBSL;

         if(BM_BLOCK_STATE_UNBLOCKED == deviceBlockStatus._blockState)
         {
            for (ProtocolBlockStatusMap::iterator itPIM = deviceBlockStatus._protocolBlockStatusMap.begin();
                  itPIM != deviceBlockStatus._protocolBlockStatusMap.end(); itPIM++)
            {
               if(itPIM->first._protocolId == protocolId)
               {
                  blockState = itPIM->second;
                  break;
               }
            }
         }
         else
         {
            blockState = BM_BLOCK_STATE_BLOCKED;
         }
      }
   }
   else if(BM_OVERALL_BLOCK_STATE_BLOCKED == _blockStatus._overallDeviceBlockStatus._blockState)
   {
      blockState = BM_BLOCK_STATE_BLOCKED;
   }

   ETG_TRACE_USR4(("vGetProfileBlockStatus: blockState : %d", blockState));
}

tVoid FC_Bluetooth_tclCCAService::vCheckCurProfileStatusWithList(DeviceId deviceHandle, ProtocolId protocolId,
      const DeviceConnectionStatusList& deviceConnectionStatusList, ConnectionStatus &connectionStatus)
{
   DeviceConnectionInfo deviceconnectioninfo;
   ProtocolId oldprotocolId;
   ProtocolConnectionInfo protocolconnectioninfo;
   DeviceConnectionInfoList::const_iterator It;
   tBool bRet = false;

   It = std::find_if(deviceConnectionStatusList._deviceConnectionInfoList.begin(),
         deviceConnectionStatusList._deviceConnectionInfoList.end(),
         MeetsDeviceHandle<DeviceConnectionInfo>(deviceHandle));

   if (It != deviceConnectionStatusList._deviceConnectionInfoList.end())
   {
      deviceconnectioninfo = *It;
      for (ProtocolConnectionInfoMap::const_iterator ItProConInfoMap = deviceconnectioninfo._protocolConnectionInfo.begin();
            ItProConInfoMap != deviceconnectioninfo._protocolConnectionInfo.end();
            ItProConInfoMap++)
      {
         oldprotocolId = ItProConInfoMap->first;
         protocolconnectioninfo = ItProConInfoMap->second;

         if(oldprotocolId == protocolId)
         {
            connectionStatus = protocolconnectioninfo._connectionStatus;
            ETG_TRACE_USR1(("vCheckCurProfileStatusWithList: Protocol:%d status:%d", oldprotocolId, connectionStatus));
            bRet = true;
            break;
         }
      }
   }

   if(bRet == false)
   {
      connectionStatus = BM_CONNECTION_STATUS_UNKNOWN;
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::vUpdateBlockInfo(const PairedDeviceList& pairedDeviceList)
{
   ENTRY_INTERNAL
   DeviceBaseInfoList::const_iterator connListIt;
   DeviceId deviceId;
   tBool bRet = false;
   enBlockInfo blockAVPStatus = AVP_UNBLOCKED;

   _avpBlockInfoLock.lock();

   if(pairedDeviceList._deviceBaseInfoList.size() > FC_BLUETOOTH_CCASERVICE_ZERO)
   {
      if (_pairedDeviceList._deviceBaseInfoList.size() < pairedDeviceList._deviceBaseInfoList.size())
      {
         for (std::list<DeviceBaseInfo>::const_iterator it = pairedDeviceList._deviceBaseInfoList.begin();
               it != pairedDeviceList._deviceBaseInfoList.end(); it++)
         {
            std::map<DeviceId, enBlockInfo>::iterator It = _blockAVPInfo.find(it->_deviceHandle);

            if(It == _blockAVPInfo.end())
            {
               _blockAVPInfo.insert(std::make_pair(it->_deviceHandle, blockAVPStatus));

               bRet = fc_bluetooth_tclClientHandler_MediaPlayer::poGetInstance()->bCheckDeviceIsIphone_ConnectedToMediaPlayer(
                                    it->_deviceHandle, it->_bdName);

               if(bRet == true)
               {
                  blockAVPStatus = AVP_DISCONNECT_BLOCKED;
                  _blockAVPInfo[it->_deviceHandle] = blockAVPStatus;
               }

               ETG_TRACE_USR4((" vUpdateBlockInfo :: block info -%u for deviceHandle - %d", ETG_CENUM(enBlockInfo, blockAVPStatus), it->_deviceHandle));
            }
         }
      }
      else if (_pairedDeviceList._deviceBaseInfoList.size() > pairedDeviceList._deviceBaseInfoList.size())
      {
         for (std::map<DeviceId, enBlockInfo>::iterator it = _blockAVPInfo.begin(); it != _blockAVPInfo.end(); it++)
         {
            deviceId = it->first;

            connListIt = std::find_if(pairedDeviceList._deviceBaseInfoList.begin(),
                  pairedDeviceList._deviceBaseInfoList.end(),
                  MeetsDeviceHandle<DeviceBaseInfo>(deviceId));

            if (connListIt == pairedDeviceList._deviceBaseInfoList.end())
            {
               _blockAVPInfo.erase(deviceId);

               ETG_TRACE_USR4((" vUpdateBlockInfo :: devicehandle - %d removed", deviceId));
            }
         }
      }
   }
   else
   {
      _blockAVPInfo.clear();
      ETG_TRACE_USR4((" vUpdateBlockInfo :: cleared"));
   }

   _avpBlockInfoLock.unlock();

   return;
}

tVoid FC_Bluetooth_tclCCAService::setBlockInfoStauts(DeviceId deviceHandle, enBlockInfo blockInfo)
{
   ETG_TRACE_USR1((" setBlockInfoStauts :: block info -%u for deviceHandle - %d", ETG_CENUM(enBlockInfo, blockInfo), deviceHandle));

   _avpBlockInfoLock.lock();

   std::map<DeviceId, enBlockInfo>::iterator It = _blockAVPInfo.find(deviceHandle);

   if(It != _blockAVPInfo.end())
   {
      _blockAVPInfo[deviceHandle] = blockInfo;
   }
   else
   {
      _blockAVPInfo.insert(std::make_pair(deviceHandle, blockInfo));
   }

   _avpBlockInfoLock.unlock();
}

tVoid FC_Bluetooth_tclCCAService::getBlockInfoStauts(DeviceId deviceHandle, enBlockInfo& blockInfo)
{
   _avpBlockInfoLock.lock();

   std::map<DeviceId, enBlockInfo>::iterator It = _blockAVPInfo.find(deviceHandle);

   if(It != _blockAVPInfo.end())
   {
      ETG_TRACE_USR4((" getBlockInfoStauts :: deviceHandle - %d is available", deviceHandle));
      blockInfo = _blockAVPInfo[deviceHandle];
   }
   else
   {
      blockInfo = AVP_UNBLOCKED;
   }

   ETG_TRACE_USR4((" getBlockInfoStauts :: block info -%u for deviceHandle - %d", ETG_CENUM(enBlockInfo, blockInfo), deviceHandle));

   _avpBlockInfoLock.unlock();
}

tVoid FC_Bluetooth_tclCCAService::vFillDeviceListChange(const PairedDeviceList& pairedDeviceList)
{
   ENTRY_INTERNAL

   DeviceBaseInfoList::const_iterator connListIt;

   if (_pairedDeviceList._deviceBaseInfoList.size() < pairedDeviceList._deviceBaseInfoList.size())
   {
      for (std::list<DeviceBaseInfo>::const_iterator it = pairedDeviceList._deviceBaseInfoList.begin();
            it != pairedDeviceList._deviceBaseInfoList.end(); it++)
      {
         ETG_TRACE_USR4(("vFillDeviceListChange:if deviceID : %d", _u8DeviceHandle));
         ETG_TRACE_USR4(("vFillDeviceListChange:if _connectionStatus : %d", _e8connectionStatus));

         if (_pairedDeviceList._deviceBaseInfoList.size() != FC_BLUETOOTH_CCASERVICE_ZERO)
         {
            ETG_TRACE_USR4(("vFillDeviceListChange:if  : %d", it->_deviceHandle));

            connListIt = std::find_if(_pairedDeviceList._deviceBaseInfoList.begin(),
                  _pairedDeviceList._deviceBaseInfoList.end(),
                  MeetsDeviceHandle<DeviceBaseInfo>(it->_deviceHandle));

            if (connListIt == _pairedDeviceList._deviceBaseInfoList.end())
            {
               _u8DeviceHandle = (tU8)it->_deviceHandle;
               _e8connectionStatus = it->_connectionStatus;
               _bDeviceListChangeUpdate = true;
               _bUpdateRingtoneStatus = true;
               _inbandRingtoneSupport = it->_inbandRingtoneSupport;
               break;
            }
         }
         else
         {
            if (it->_connectionStatus != BM_CONNECTION_STATUS_UNKNOWN)
            {
               _u8DeviceHandle = (tU8)it->_deviceHandle;
               _e8connectionStatus = it->_connectionStatus;
               _bDeviceListChangeUpdate = true;

               _bUpdateRingtoneStatus = true;
               _inbandRingtoneSupport = it->_inbandRingtoneSupport;
            }
            break;
         }
      }
   }
   else if (_pairedDeviceList._deviceBaseInfoList.size() > pairedDeviceList._deviceBaseInfoList.size())
   {
      for (std::list<DeviceBaseInfo>::iterator it = _pairedDeviceList._deviceBaseInfoList.begin();
            it != _pairedDeviceList._deviceBaseInfoList.end(); it++)
      {
         ETG_TRACE_USR4(("vFillDeviceListChange:else if deviceID : %d", _u8DeviceHandle));
         ETG_TRACE_USR4(("vFillDeviceListChange:else  if _connectionStatus : %d", _e8connectionStatus));

         connListIt = std::find_if(pairedDeviceList._deviceBaseInfoList.begin(),
               pairedDeviceList._deviceBaseInfoList.end(),
               MeetsDeviceHandle<DeviceBaseInfo>(it->_deviceHandle));

         if (connListIt == pairedDeviceList._deviceBaseInfoList.end())
         {
            _u8DeviceHandle = (tU8)it->_deviceHandle;
            _e8connectionStatus = BM_CONNECTION_STATUS_UNKNOWN;
            _bDeviceListChangeUpdate = true;
            break;
         }
      }
   }
   else
   {
      for (std::list<DeviceBaseInfo>::const_iterator it = pairedDeviceList._deviceBaseInfoList.begin();
            it != pairedDeviceList._deviceBaseInfoList.end(); it++)
      {
         ETG_TRACE_USR4(("vFillDeviceListChange:else deviceID : %d", it->_deviceHandle));
         ETG_TRACE_USR4(("vFillDeviceListChange:else _connectionStatus : %d", it->_connectionStatus));

         connListIt = std::find_if(_pairedDeviceList._deviceBaseInfoList.begin(),
               _pairedDeviceList._deviceBaseInfoList.end(),
               MeetsDeviceHandle<DeviceBaseInfo>(it->_deviceHandle));

         if (connListIt != _pairedDeviceList._deviceBaseInfoList.end())
         {
            ETG_TRACE_USR4(("vFillDeviceListChange:connListIt deviceID : %d", connListIt->_deviceHandle));
            ETG_TRACE_USR4(("vFillDeviceListChange:connListIt _connectionStatus : %d", connListIt->_connectionStatus));

            if (connListIt->_connectionStatus != it->_connectionStatus)
            {
               ETG_TRACE_USR4(("vFillDeviceListChange: _connectionStatus changed"));

               _u8DeviceHandle = (tU8)it->_deviceHandle;
               _e8connectionStatus = it->_connectionStatus;

               if((_e8connectionStatus == BM_CONNECTION_STATUS_CONNECTED) ||
                     (_e8connectionStatus == BM_CONNECTION_STATUS_DISCONNECTED))
               {
                  _bDeviceListChangeUpdate = true;
               }

               _bPairedDevicelistUpdate = true;
               break;
            }
            else if((connListIt->_deviceIdentification._specificationId != it->_deviceIdentification._specificationId) ||
                  (connListIt->_deviceIdentification._vendorId != it->_deviceIdentification._vendorId) ||
                  (connListIt->_deviceIdentification._vendorIdSource != it->_deviceIdentification._vendorIdSource) ||
                  (connListIt->_deviceIdentification._productId != it->_deviceIdentification._productId) ||
                  (connListIt->_deviceIdentification._version != it->_deviceIdentification._version))

            {
               ETG_TRACE_USR4(("vFillDeviceListChange: _deviceIdentification changed"));
               _bPairedDevicelistUpdate = true;
               break;
            }
            else if(connListIt->_favoriteIndex != it->_favoriteIndex)
            {
               ETG_TRACE_USR4(("vFillDeviceListChange: _favoriteIndex changed"));
               _bPairedDevicelistUpdate = true;
               break;
            }
            else if(connListIt->_iAPoverBTSupported != it->_iAPoverBTSupported)
            {
               ETG_TRACE_USR4(("vFillDeviceListChange: _iAPoverBTSupported changed"));
               _bPairedDevicelistUpdate = true;
               break;
            }
            else if(connListIt->_usagePreference != it->_usagePreference)
            {
               ETG_TRACE_USR4(("vFillDeviceListChange: _usagePreference changed"));
               _bPairedDevicelistUpdate = true;
               break;
            }
            else if(connListIt->_inbandRingtoneSupport != it->_inbandRingtoneSupport)
            {
               ETG_TRACE_USR4(("vFillDeviceListChange: _inbandRingtoneSupport changed"));

               vUpdateRingtoneSupport(it->_deviceHandle, it->_inbandRingtoneSupport);
            }
            else if(0 != connListIt->_bdName.compare(it->_bdName))
            {
               ETG_TRACE_USR4(("vFillDeviceListChange: _bdName changed"));
               _bPairedDevicelistUpdate = true;
               break;
            }
            else
            {
               vCheckProtocoInfoChanged(it->_protocolInfo, connListIt->_protocolInfo);

               if(_bPairedDevicelistUpdate == true)
               {
                  if (_u8BluetoothAudioDeviceHandle != INVALID_DEVICE_HANDLE)
                  {
                     connListIt = std::find_if(pairedDeviceList._deviceBaseInfoList.begin(),
                           pairedDeviceList._deviceBaseInfoList.end(),
                           MeetsDeviceHandle<DeviceBaseInfo>(_u8BluetoothAudioDeviceHandle));

                     if (connListIt != pairedDeviceList._deviceBaseInfoList.end())
                     {
                        for (ProtocolInfoMap::const_iterator it = connListIt->_protocolInfo.begin();
                              it != connListIt->_protocolInfo.end(); it++)
                        {
                           if (it->first == BM_PROTOCOL_ID_AVP)
                           {
                              ETG_TRACE_USR4(("vFillDeviceListChange: _bluetoothAudioVersion : %X %X", _bluetoothAudioVersion, it->second._version));
                              if (_bluetoothAudioVersion != it->second._version)
                              {
                                 _bVersionUpdate = true;
                              }
                              break;
                           }
                        }
                     }
                  }
                  break;
               }
            }
         }
      }
   }

   ETG_TRACE_USR4(("vFillDeviceListChange: deviceID : %d", _u8DeviceHandle));
   ETG_TRACE_USR4(("vFillDeviceListChange: _connectionStatus : %d, _bVersionUpdate : %d _bPairedDevicelistUpdate : %d", _e8connectionStatus, _bVersionUpdate, _bPairedDevicelistUpdate));

   return;
}

tVoid FC_Bluetooth_tclCCAService::vUpdateRingtoneSupport(DeviceId deviceHandle, InbandRingtoneSupport inbandRingtoneSupport)
{
   RingtoneId ringtoneId = DEFAULT_RINGTONE_ID;
   BmResult result = BM_RESULT_ERR_GENERAL;

   if(false == _bmCoreConfiguration._systemWideRingtoneEnabled)
   {
      ETG_TRACE_USR4(("vUpdateRingtoneSupport: deviceID - %d, inbandRingtoneSupport - %d", deviceHandle, inbandRingtoneSupport));

      if(_bluetoothApp)
      {
         result = _bluetoothApp->getBmCoreRequestIf().readDeviceRingtoneIdFromDb(ringtoneId, deviceHandle);
      }

      if(result == BM_RESULT_OK)
      {
         ETG_TRACE_USR4(("vUpdateRingtoneSupport: ringtoneId in the Database = %d", ringtoneId));

         if(ringtoneId == -1)
         {
            if (inbandRingtoneSupport == BM_INBAND_RINGTONE_SUPPORT_AVAILABLE)
            {
               ringtoneId = RINGTONE_INBAND_RINGTONEID;
            }
            else
            {
               ringtoneId = DEFAULT_RINGTONE_ID;
            }

            ETG_TRACE_USR4(("vUpdateRingtoneSupport: updated ringtoneId = %d", ringtoneId));

            std::string sRingtoneName = "";
            oAvailableRingtoneList.vGetRingtoneName((tU16)(ringtoneId - 1), sRingtoneName);

            updateChangeRingtoneStatus((tU8)deviceHandle, (tU16)ringtoneId, sRingtoneName, TRUE);
         }
      }
      else
      {
         ETG_TRACE_ERR(("OnRequestDeviceRingtonesListMethodStart: readDeviceRingtoneIdFromDb func return error:%d", result));
      }
   }
   else
   {
      ETG_TRACE_USR4(("vUpdateRingtoneSupport: _systemWideRingtoneEnabled is true so it not required to update ringtone status"));
   }
}

tVoid FC_Bluetooth_tclCCAService::vCheckProtocoInfoChanged(ProtocolInfoMap curprotocolInfo, ProtocolInfoMap oldprotocolInfo)
{
   ProtocolInfoMap::const_iterator curPIMit, oldPIMit;

   ETG_TRACE_USR4(("vCheckProtocoInfoChanged: entered"));

   for (curPIMit = curprotocolInfo.begin(); curPIMit != curprotocolInfo.end(); curPIMit++)
   {
      for (oldPIMit = oldprotocolInfo.begin(); oldPIMit != oldprotocolInfo.end(); oldPIMit++)
      {
         if(curPIMit->first == oldPIMit->first)
         {
            if (curPIMit->second._version != oldPIMit->second._version)
            {
               ETG_TRACE_USR4(("vCheckProtocoInfoChanged: version changed"));
               _bPairedDevicelistUpdate = true;
               break;
            }
            else if(curPIMit->second._isSupported != oldPIMit->second._isSupported)
            {
               ETG_TRACE_USR4(("vCheckProtocoInfoChanged: _isSupported changed"));
               _bPairedDevicelistUpdate = true;
               break;
            }
            else if(curPIMit->second._favoriteIndex != oldPIMit->second._favoriteIndex)
            {
               ETG_TRACE_USR4(("vCheckProtocoInfoChanged: _favoriteIndex changed"));
               _bPairedDevicelistUpdate = true;
               break;
            }
         }
      }
   }
}

tU16 FC_Bluetooth_tclCCAService::u16GetDeviceHandleForCurrentOutgoingSource(const DeviceConnectionStatusList& deviceConnectionStatusList)
{
   ENTRY_INTERNAL

   tU16 u16OutGoingDeviceHandle = INVALID_DEVICE_HANDLE;
   tBool bHFP = FALSE;

   for (tU16 iCount = FC_BLUETOOTH_CCASERVICE_ZERO; iCount < deviceConnectionStatusList._deviceConnectionInfoList.size(); iCount++)
   {
      if(deviceConnectionStatusList._deviceConnectionInfoList[iCount]._connectionStatus == BM_CONNECTION_STATUS_CONNECTED)
      {
         MapOutgoingSourceStatusToMOST(bHFP, deviceConnectionStatusList._deviceConnectionInfoList[iCount]._protocolConnectionInfo);

         if (bHFP == TRUE)
         {
            u16OutGoingDeviceHandle = (tU16)deviceConnectionStatusList._deviceConnectionInfoList[iCount]._deviceHandle;
            break;
         }
      }
   }

   return u16OutGoingDeviceHandle;
}

tU16 FC_Bluetooth_tclCCAService::u16GetDeviceHandleForNonOutgoingSource(const DeviceConnectionStatusList& deviceConnectionStatusList)
{
   ENTRY_INTERNAL

   tU16 u16OutGoingDeviceHandle = INVALID_DEVICE_HANDLE;
   tBool bHFP = FALSE;

   for (tU16 iCount = FC_BLUETOOTH_CCASERVICE_ZERO; iCount < deviceConnectionStatusList._deviceConnectionInfoList.size(); iCount++)
   {
      MapOutgoingSourceStatusToMOST(bHFP, deviceConnectionStatusList._deviceConnectionInfoList[iCount]._protocolConnectionInfo);
      if (bHFP == FALSE)
      {
         u16OutGoingDeviceHandle = (tU16)deviceConnectionStatusList._deviceConnectionInfoList[iCount]._deviceHandle;
         break;
      }
   }

   ETG_TRACE_USR2((" u16GetDeviceHandleForNonOutgoingSource : u16OutGoingDeviceHandle %d",u16OutGoingDeviceHandle));
   return u16OutGoingDeviceHandle;
}

tBool FC_Bluetooth_tclCCAService::handlePairingStatusGet(amt_tclServiceData& roOutMsg)
{
   ENTRY

   tBool bRet = false;

   ETG_TRACE_USR1((" handlePairingStatusGet ::e8PairingStatusType : %d", _oFIDataPairingStatus.e8PairingStatusType.enType));
   ETG_TRACE_USR1((" handlePairingStatusGet ::sDeviceName : %s", _oFIDataPairingStatus.sDeviceName.szValue));
   ETG_TRACE_USR1((" handlePairingStatusGet ::u8DeviceHandle : %d", _oFIDataPairingStatus.u8DeviceHandle));

   bRet = fi_tclVisitorMessage(_oFIDataPairingStatus, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);

   return bRet;
}

tVoid FC_Bluetooth_tclCCAService::vUpdatePairingStatus(PairingResult result, BdName remoteBdName, BdAddress remoteBdAddress)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1((" vUpdatePairingStatus :: entered"));

   most_fi_tcl_e8_BTSetPairingStatusType mostPairingStatusType;
   MapPairingStatusTypeToMOST(mostPairingStatusType, result);

   if(_oFIDataPairingStatus.e8PairingStatusType.enType != mostPairingStatusType.enType)
   {
      _oFIDataPairingStatus.e8PairingStatusType.enType = mostPairingStatusType.enType;

      if(s32StringCompare(_oFIDataPairingStatus.sDeviceName.szValue, remoteBdName.c_str()) != FC_BLUETOOTH_CCASERVICE_ZERO)
      {
         _oFIDataPairingStatus.sDeviceName.bSet(remoteBdName.c_str());
      }

      _oFIDataPairingStatus.u8DeviceHandle = INVALID_DEVICE_HANDLE;

      // Check the Pairing status is successful. If successful then get the device handle from PairedDeviceList
      if(BM_PAIRING_RESULT_OK == result)
      {
         PairedDeviceList pairedDeviceList;
         vGetPairedDeviceList(pairedDeviceList);

         if(FC_BLUETOOTH_CCASERVICE_ZERO != pairedDeviceList._deviceBaseInfoList.size())
         {
            for (std::list<DeviceBaseInfo>::const_iterator it = pairedDeviceList._deviceBaseInfoList.begin();
                  it != pairedDeviceList._deviceBaseInfoList.end(); it++)
            {
               if(it->_bdAddress == remoteBdAddress)
               {
                  _oFIDataPairingStatus.u8DeviceHandle = (tU8) it->_deviceHandle;
                  ETG_TRACE_USR1((" vUpdatePairingStatus ::u8DeviceHandle : %d", _oFIDataPairingStatus.u8DeviceHandle));
                  break;
               }
            }
         }
      }

      updateClients(MOST_BTSETFI_C_U16_PAIRINGSTATUS);
   }

   return;
}

tBool FC_Bluetooth_tclCCAService::handleVehicleFriendlyNameGet(amt_tclServiceData& roOutMsg)
{
   ENTRY

   tBool bRet = false;

   ETG_TRACE_USR1((" handleVehicleFriendlyNameGet ::FriendlyName - %s", _oFIDataVehicleBTFriendlyName.sVehicleBTFriendlyName.szValue));

   bRet = fi_tclVisitorMessage(_oFIDataVehicleBTFriendlyName, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);

   return bRet;
}

tVoid FC_Bluetooth_tclCCAService::vUpdateVehicleFriendlyName(LocalFriendlyNameType localFriendlyName)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1((" vUpdateVehicleFriendlyName :prev - %s", _oFIDataVehicleBTFriendlyName.sVehicleBTFriendlyName.szValue));
   ETG_TRACE_USR1((" vUpdateVehicleFriendlyName :curr - %s", localFriendlyName.c_str()));

   if(s32StringCompare(_oFIDataVehicleBTFriendlyName.sVehicleBTFriendlyName.szValue, localFriendlyName.c_str())
         != FC_BLUETOOTH_CCASERVICE_ZERO)
   {
      _oFIDataVehicleBTFriendlyName.sVehicleBTFriendlyName.bSet(localFriendlyName.c_str(),
                  most_fi_tcl_String::FI_EN_UTF8);

      updateClients(MOST_BTSETFI_C_U16_VEHICLEBTFRIENDLYNAME);
   }

   return;
}

tBool FC_Bluetooth_tclCCAService::handleVehicleFriendlyNameSetStatus(amt_tclServiceData& roOutMsg)
{
   ENTRY

   tBool bRet = false;

   ETG_TRACE_USR1((" handleVehicleFriendlyNameSetStatus ::FriendlyName - %s", _oFIDataVehicleBTFriendlyNameset.sVehicleBTFriendlyName.szValue));

   bRet = fi_tclVisitorMessage(_oFIDataVehicleBTFriendlyNameset, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);

   return bRet;
}

tVoid FC_Bluetooth_tclCCAService::vUpdateBtLocalFriendlyNameSet(LocalFriendlyNameType localFriendlyName)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1((" vUpdateBtLocalFriendlyNameSet :prev - %s", _oFIDataVehicleBTFriendlyNameset.sVehicleBTFriendlyName.szValue));
   ETG_TRACE_USR1((" vUpdateBtLocalFriendlyNameSet :curr - %s",  localFriendlyName.c_str()));

   if(s32StringCompare(_oFIDataVehicleBTFriendlyNameset.sVehicleBTFriendlyName.szValue, localFriendlyName.c_str())
         != FC_BLUETOOTH_CCASERVICE_ZERO)
   {
      _oFIDataVehicleBTFriendlyNameset.sVehicleBTFriendlyName.bSet(localFriendlyName.c_str(),
                  most_fi_tcl_String::FI_EN_UTF8);

      _btLocalFriendlyName = localFriendlyName;

      updateClients(MOST_BTSETFI_C_U16_VEHICLEBTFRIENDLYNAMESET);
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::vGetLocalFriendlyName(LocalFriendlyNameType& localFriendlyName)
{
   ENTRY_INTERNAL

   localFriendlyName = _btLocalFriendlyName;

   ETG_TRACE_USR1((" vGetLocalFriendlyName - %s", localFriendlyName.c_str()));

   return;
}

tBool FC_Bluetooth_tclCCAService::handlePairingPinGet(amt_tclServiceData& roOutMsg)
{
   ENTRY

   tBool bRet = false;

   ETG_TRACE_USR1((" handlePairingPinGet ::sPinNumber - %s", _oFIDataPairingPin.sPinNumber.szValue));

   bRet = fi_tclVisitorMessage(_oFIDataPairingPin, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);

   return bRet;
}

tVoid FC_Bluetooth_tclCCAService::vUpdatePairingPin(PairingPinType pin)
{
   ENTRY_INTERNAL

   if(s32StringCompare(_oFIDataPairingPin.sPinNumber.szValue, pin.c_str()) != FC_BLUETOOTH_CCASERVICE_ZERO)
   {
      updatePairingPinMR(pin);

      _oFIDataPairingPin.sPinNumber.bSet(pin.c_str(), most_fi_tcl_String::FI_EN_UTF8);

      _pairingPin = pin;

      updateClients(MOST_BTSETFI_C_U16_PAIRINGPIN);
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::vGetPairingPin(PairingPin& pairingPin)
{
   ENTRY_INTERNAL

   pairingPin._pin = _pairingPin;

   ETG_TRACE_USR1((" vGetPairingPin ::sPinNumber - %s", pairingPin._pin.c_str()));

   return;
}

tVoid FC_Bluetooth_tclCCAService::updatePairingPinMR(PairingPinType& pin)
{
   JobList *joblist = OSAL_NULL;

   joblist = FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopMethodContext(CHANGEPIN_METHOD_FKTID);

   if (joblist)
   {
      LocalFriendlyNameType localFriendlyName = "";

      vGetLocalFriendlyName(localFriendlyName);

      for (JobList::iterator it = joblist->begin(); it != joblist->end(); it++)
      {
         ChangePinMethodResult((Job) *it, localFriendlyName, pin);
      }
   }
}

tBool FC_Bluetooth_tclCCAService::handleMaxDevicesPairedGet(amt_tclServiceData& roOutMsg)
{
   ENTRY

   tBool bRet = false;

   ETG_TRACE_USR4(("handleMaxDevicesPairedGet: deviceHandle - %d", _oFIDataMaxDevicesPaired.u8DeviceHandle));
   ETG_TRACE_USR4(("handleMaxDevicesPairedGet: DeviceName - %s", _oFIDataMaxDevicesPaired.sDeviceName.szValue));

   bRet = fi_tclVisitorMessage(_oFIDataMaxDevicesPaired, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);

   return bRet;
}

tVoid FC_Bluetooth_tclCCAService::vUpdateBmConfigData(const BmConfigData& bmConfigData)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR4(("vUpdateBmConfigData: Max device supported : %d", bmConfigData._maxNumPairedDevices));

   _maxNumPairedDevices = (tU16)bmConfigData._maxNumPairedDevices;

   return;
}

tVoid FC_Bluetooth_tclCCAService::vGetmaxNumPairedDevices(tU16& maxNumPairedDevices)
{
   ENTRY_INTERNAL

   maxNumPairedDevices = _maxNumPairedDevices;

   ETG_TRACE_USR4(("vGetmaxNumPairedDevices: %d", maxNumPairedDevices));

   return;
}

tVoid FC_Bluetooth_tclCCAService::vMaxDevicesPairedReached(const PairedDeviceList& pairedDeviceList)
{
   ENTRY_INTERNAL

   tBool bRet = false;
   tU16 maxNumPairedDevices = FC_BLUETOOTH_CCASERVICE_ZERO;

   vGetmaxNumPairedDevices(maxNumPairedDevices);

   ETG_TRACE_USR4(("vMaxDevicesPairedReached: Max device supported : %d", maxNumPairedDevices));

   if ((pairedDeviceList._deviceBaseInfoList.size() == maxNumPairedDevices) &&
         (maxNumPairedDevices != FC_BLUETOOTH_CCASERVICE_ZERO))
   {
      ETG_TRACE_USR4(("vMaxDevicesPairedReached: Max device is reached"));

      tU8 u8Count = FC_BLUETOOTH_CCASERVICE_ZERO;

      for (std::list<DeviceBaseInfo>::const_iterator it = pairedDeviceList._deviceBaseInfoList.begin();
            it != pairedDeviceList._deviceBaseInfoList.end(); it++)
      {
         u8Count++;

         if (u8Count == maxNumPairedDevices)
         {
            std::string szDeviceNameToHMI = "";

            ETG_TRACE_USR4(("vMaxDevicesPairedReached: device state - %d", it->_connectionStatus));

            if (BM_CONNECTION_STATUS_CONNECTED != it->_connectionStatus)
            {
               _oFIDataMaxDevicesPaired.u8DeviceHandle = (tU8)it->_deviceHandle;
               _oFIDataMaxDevicesPaired.sDeviceName.bSet(it->_bdName.c_str());
            }
            else
            {
               _oFIDataMaxDevicesPaired.u8DeviceHandle = INVALID_DEVICE_HANDLE;
               _oFIDataMaxDevicesPaired.sDeviceName.bSet(szDeviceNameToHMI.c_str());
            }

            bRet = true;
         }
      }
   }
   else
   {
      ETG_TRACE_USR4(("vMaxDevicesPairedReached: Max device is not reached"));
   }

   if(bRet == true)
   {
      updateClients(MOST_BTSETFI_C_U16_MAXDEVICESPAIRED);
   }

   return;
}

tBool FC_Bluetooth_tclCCAService::handleBluetoothOnOffGet(amt_tclServiceData& roOutMsg)
{
   ENTRY

   tBool bRet = false;

   ETG_TRACE_USR4(("handleBluetoothOnOffGet:BluetoothOnOff %d", _oFIDataBluetoothOnOff.bBTOnOff));

   bRet = fi_tclVisitorMessage(_oFIDataBluetoothOnOff, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);

   return bRet;
}

tBool FC_Bluetooth_tclCCAService::bGetBTOnOffState()
{
   ENTRY_INTERNAL

   tBool bBTOnOff = _oFIDataBluetoothOnOff.bBTOnOff;

   ETG_TRACE_USR2(("bGetBTOnOffState - bBTOnOff is %d", bBTOnOff));

   return bBTOnOff;
}

tVoid FC_Bluetooth_tclCCAService::vUpdateBluetoothOnOff(SwitchState switchState)
{
   ENTRY_INTERNAL

   tBool bBTOnOff = _oFIDataBluetoothOnOff.bBTOnOff;

   MapBluetoothOnOffStatusToMOST(_oFIDataBluetoothOnOff, switchState);

   ETG_TRACE_USR4(("vUpdateBluetoothOnOff:BluetoothOnOff Prev-%d Cur-%d", bBTOnOff, _oFIDataBluetoothOnOff.bBTOnOff));

   if((switchState == SWITCH_STATE_SWITCHED_ON) || (switchState == SWITCH_STATE_SWITCHED_OFF))
   {
      updateBTOnOffExtenedMR(switchState, false);

      updateClients(MOST_BTSETFI_C_U16_BLUETOOTHONOFF);
   }

   _bluetoothswitchState = switchState;

   return;
}

tVoid FC_Bluetooth_tclCCAService::vGetBluetoothOnOff(SwitchState& switchState)
{
   ENTRY_INTERNAL

   switchState = _bluetoothswitchState;

   return;
}

tVoid FC_Bluetooth_tclCCAService::updateBTOnOffExtenedMR(SwitchState switchState, tBool bResponse)
{
   ENTRY_INTERNAL

   JobList *joblist = OSAL_NULL;
   tBool bJobFind = FALSE;
   Job methodcontext;
   most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodStart *poBTFiDataObjectMethodStart = NULL;
   tU16 u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;

   ETG_TRACE_USR4(("updateBTOnOffExtenedMR: switchState - %d Response - %d", switchState, bResponse));

   joblist = FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContext(SWITCHBTONOFFEXT_METHOD_FKTID);

   if (joblist)
   {
      for (JobList::iterator it = joblist->begin(); it != joblist->end(); it++)
      {
         methodcontext = (Job) *it;
         poBTFiDataObjectMethodStart = (most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodStart *) (methodcontext.poMethodArg);
         u16Count++;

         if (poBTFiDataObjectMethodStart)
         {
            ETG_TRACE_USR4(("updateBTOnOffExtenedMR: MS bBTOnOff - %d u16Count - %d", poBTFiDataObjectMethodStart->bBTOnOff, u16Count));

            if(poBTFiDataObjectMethodStart->bBTOnOff == TRUE)
            {
               if(switchState == SWITCH_STATE_SWITCHED_ON)
               {
                  bJobFind = TRUE;

                  // Check if the directory with the bt only reset file exist
                  // send the BT DTC update to Dialog if BtStateOff file is not exist
                  if (true == bCheckBtOnlyResetFileIsExist())
                  {
                     vUpdateBtDTCState(_vehicleBtAddress);

                     vUpdateWifiDTCState();
                  }
               }
               else if(switchState == SWITCH_STATE_SWITCHED_OFF)
               {
                  if(_bluetoothswitchState == SWITCH_STATE_SWITCHING_ON)
                  {
                     bJobFind = TRUE;

                     // Check if the directory with the bt only reset file exist
                     if ((true == bCheckBtOnlyResetFileIsExist()) && (false == bCheckStackIsRunning()))
                     {
                        vUpdateBtDTCState("");

                        vUpdateWifiDTCState();
                     }
                  }
                  else
                  {
                     ETG_TRACE_USR4(("updateBTOnOffExtenedMR: Prev state is not SWITCHING_ON"));
                  }
               }
            }
            else
            {
               if(switchState == SWITCH_STATE_SWITCHED_OFF)
               {
                  bJobFind = TRUE;
               }
               else if(switchState == SWITCH_STATE_SWITCHED_ON)
               {
                  if(_bluetoothswitchState == SWITCH_STATE_SWITCHING_OFF)
                  {
                     bJobFind = TRUE;
                  }
                  else
                  {
                     ETG_TRACE_USR4(("updateBTOnOffExtenedMR: Prev state is not SWITCHING_OFF"));
                  }
               }
            }
         }

         if(bJobFind == TRUE)
         {
            SwitchBluetoothOnOffExtendedMethodResult(methodcontext, switchState);

            if (poBTFiDataObjectMethodStart != NULL)
            {
               poBTFiDataObjectMethodStart->vDestroy();
               OSAL_DELETE poBTFiDataObjectMethodStart;
            }

            FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(SWITCHBTONOFFEXT_METHOD_FKTID, methodcontext, u16Count);

            break;
         }
         else
         {
            if(bResponse == true)
            {
               break;
            }
         }
      }
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::vUpdateDiscoveryStatus(SwitchStatus switchStatus)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR4(("vUpdateDiscoveryStatus:BluetoothOnOff Prev-%d Cur-%d",
         _discoveryStatus._switchState, switchStatus._switchState));

   if((switchStatus._switchState == SWITCH_STATE_SWITCHED_ON) || (switchStatus._switchState == SWITCH_STATE_SWITCHED_OFF))
   {
      updateDiscoveryStatusOnOffMR(switchStatus, FALSE);
   }

   _discoveryStatus = switchStatus;

   return;
}

tVoid FC_Bluetooth_tclCCAService::vGetDiscoveryStatus(SwitchStatus& switchStatus)
{
   ENTRY_INTERNAL

   switchStatus = _discoveryStatus;

   ETG_TRACE_USR4(("vGetDiscoveryStatus: switchStatus - %d", switchStatus._switchState));

   return;
}

tVoid FC_Bluetooth_tclCCAService::updateDiscoveryStatusOnOffMR(SwitchStatus switchStatus, tBool bResponse)
{
   ENTRY_INTERNAL

   JobList *joblist = OSAL_NULL;
   tBool bJobFind = FALSE;
   Job methodcontext;
   most_btsetfi_tclMsgScanBluetoothDevicesMethodStart *poSBFiDataObjectMethodStart = NULL;
   tU16 u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;

   joblist = FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContext(SCANBTDEVICES_METHOD_FKTID);

   if (joblist)
   {
      for (JobList::iterator it = joblist->begin(); it != joblist->end(); it++)
      {
         methodcontext = (Job) *it;
         poSBFiDataObjectMethodStart = (most_btsetfi_tclMsgScanBluetoothDevicesMethodStart *) (methodcontext.poMethodArg);
         u16Count++;

         if (poSBFiDataObjectMethodStart)
         {
            ETG_TRACE_USR4(("updateDiscoveryStatusOnOffMR: MS bScanOnOff - %d switchState - %d, u16Count - %d",
                  poSBFiDataObjectMethodStart->bScan, switchStatus._switchState, u16Count));

            if(poSBFiDataObjectMethodStart->bScan == TRUE)
            {
               if(switchStatus._switchState == SWITCH_STATE_SWITCHED_ON)
               {
                  bJobFind = TRUE;
               }
               else if(switchStatus._switchState == SWITCH_STATE_SWITCHED_OFF)
               {
                  if(_discoveryStatus._switchState == SWITCH_STATE_SWITCHING_ON)
                  {
                     bJobFind = TRUE;
                  }
               }
            }
            else
            {
               if(switchStatus._switchState == SWITCH_STATE_SWITCHED_OFF)
               {
                  bJobFind = TRUE;
               }
               else if(switchStatus._switchState == SWITCH_STATE_SWITCHED_ON)
               {
                  if(_discoveryStatus._switchState == SWITCH_STATE_SWITCHING_OFF)
                  {
                     bJobFind = TRUE;
                  }
               }
            }
         }

         if(bJobFind == TRUE)
         {
            ScanBluetoothDevicesMethodResult(methodcontext, switchStatus, bResponse);

            if (poSBFiDataObjectMethodStart != NULL)
            {
               poSBFiDataObjectMethodStart->vDestroy();
               OSAL_DELETE poSBFiDataObjectMethodStart;
            }

            FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(SCANBTDEVICES_METHOD_FKTID, methodcontext, u16Count);

            break;
         }
         else
         {
            if(bResponse == true)
            {
               break;
            }
         }
      }
   }

   return;
}

tBool FC_Bluetooth_tclCCAService::handleVehicleBtAddressGet(amt_tclServiceData& roOutMsg)
{
   ENTRY

   tBool bRet = false;

   ETG_TRACE_USR4(("handleVehicleBtAddressGet::VehicleBtAddress - %s", _oFIDataVehicleBTAddress.sVehicleBTAddress.szValue));

   bRet = fi_tclVisitorMessage(_oFIDataVehicleBTAddress, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);

   return bRet;
}

tVoid FC_Bluetooth_tclCCAService::vUpdateVehicleBtAddress(BdAddress bdAddress)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1((" vUpdateVehicleBtAddress :prev - %s", _oFIDataVehicleBTAddress.sVehicleBTAddress.szValue));
   ETG_TRACE_USR1((" vUpdateVehicleBtAddress :curr - %s",  bdAddress.c_str()));

   if(s32StringCompare(_oFIDataVehicleBTAddress.sVehicleBTAddress.szValue, bdAddress.c_str())
         != FC_BLUETOOTH_CCASERVICE_ZERO)
   {
      _oFIDataVehicleBTAddress.sVehicleBTAddress.bSet(bdAddress.c_str(),
                  most_fi_tcl_String::FI_EN_UTF8);

      _vehicleBtAddress = bdAddress;
      _bUpdateBtDTCState = true;

      if(true == _bmCoreConfiguration._btOnOffSupport)
      {
         vUpdateBtDTCState(_vehicleBtAddress);
      }
      else
      {
         ETG_TRACE_USR4((" vUpdateVehicleBtAddress : BT DTC is not updated because BT On/Off feature is OFF"));
      }

      vUpdateWifiDTCState();

      updateClients(MOST_BTSETFI_C_U16_VEHICLEBTADDRESS);
   }
   else
   {
      ETG_TRACE_USR1((" vUpdateVehicleBtAddress : bUpdateBtDTCState - %d", _bUpdateBtDTCState));

      if(false == _bUpdateBtDTCState)
      {
         _bUpdateBtDTCState = true;

         // If the BtStateOff file is exist, BMApp is not sending the BT DTC update to Dialog
         if (true == bCheckBtStateOffFileIsExist())
         {
            ETG_TRACE_USR4((" vUpdateVehicleBtAddress : BT DTC is not updated because BT stae off file is exist"));
         }
         else if(false == _bmCoreConfiguration._btOnOffSupport)
         {
            ETG_TRACE_USR4((" vUpdateVehicleBtAddress : BT DTC is not updated because BT On/Off feature is OFF"));
         }
         else
         {
            vUpdateBtDTCState("");
         }

         vUpdateWifiDTCState();
      }
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::vUpdateStackInitialized(bool stackInitialized)
{
   ETG_TRACE_USR1((" vUpdateStackInitialized : prevStackInitialized - %d, currStackInitialized - %d, _vehicleBtAddress - %50s",
         _bStackInitialized, stackInitialized,  _vehicleBtAddress.c_str()));

   // Update the DTC value based on the Stack Initialized value
   if(_bStackInitialized != stackInitialized)
   {
      _bStackInitialized = stackInitialized;

      // Send BT DTC as success if bStackInitialized is ture
      if(true == _bStackInitialized)
      {
         if(true == _bmCoreConfiguration._btOnOffSupport)
         {
            vUpdateBtDTCState(_vehicleBtAddress);
         }
         else
         {
            ETG_TRACE_USR4((" vUpdateStackInitialized : BT DTC is not updated because BT On/Off feature is OFF"));
         }
      }
      else
      {
         // If the BtStateOff file is exist, BMApp is not sending the BT DTC update to Dialog
         if (true == bCheckBtStateOffFileIsExist())
         {
            ETG_TRACE_USR4((" vUpdateStackInitialized : BT DTC is not updated because BT stae off file is exist"));
         }
         else if(false == _bmCoreConfiguration._btOnOffSupport)
         {
            ETG_TRACE_USR4((" vUpdateStackInitialized : BT DTC is not updated because BT On/Off feature is OFF"));
         }
         else
         {
            // Send BT DTC as failure if bStackInitialized is ture
            vUpdateBtDTCState("");
         }
      }

      // Update the WIFI DTC
      vUpdateWifiDTCState();
   }
}

tVoid FC_Bluetooth_tclCCAService::vUpdateBtDTCState(BdAddress bdAddress)
{
   ETG_TRACE_USR1((" vUpdateBtDTCState: _vehicleBtAddress - %50s", bdAddress.c_str()));

   if (_bluetoothApp)
   {
      if(false == bdAddress.empty())
      {
         _bluetoothApp->getClientHandlerDiaglog().vHandleNewBluetoothDTCState(BLUETOOTH_DTC_STATE_OK_STARTUP);
      }
      else
      {
         _bluetoothApp->getClientHandlerDiaglog().vHandleNewBluetoothDTCState(BLUETOOTH_DTC_STATE_ERROR_STARTUP);
      }
   }
}

tVoid  FC_Bluetooth_tclCCAService::vUpdateWifiDTCState()
{
   ETG_TRACE_USR1((" vUpdateWifiDTCState: entered"));

   fc_bluetooth_tclClientHandler_Diaglib* poDiaglib = fc_bluetooth_tclClientHandler_Diaglib::poGetInstance();

   if (poDiaglib)
   {
      tBool bUpdate = FALSE;
      tBool bMacAddressfound = FALSE;

      poDiaglib->vUpdateWifiDtc(bUpdate, bMacAddressfound);

      if((TRUE == bUpdate) && (_bluetoothApp))
      {
         if(TRUE == bMacAddressfound)
         {
            _bluetoothApp->getClientHandlerDiaglog().vHandleNewBluetoothDTCState(WIFI_DTC_STATE_OK_STARTUP);
         }
         else
         {
            _bluetoothApp->getClientHandlerDiaglog().vHandleNewBluetoothDTCState(WIFI_DTC_STATE_ERROR_STARTUP);
         }
      }
      else
      {
         ETG_TRACE_USR4((" vUpdateWifiDTCState:BuildID is BT only, WifiDTC is not set"));
      }
   }
}

bool FC_Bluetooth_tclCCAService::bCheckBtOnlyResetFileIsExist()
{
   bool bBtOnlyResetFilePathIsAvail = false;

   if(access(BT_ONLY_MODULE_RESET_FILEPATH, F_OK) != -1)
   {
      bBtOnlyResetFilePathIsAvail = true;
   }

   ETG_TRACE_USR4((" bCheckBtOnlyResetFileIsExist: FileExist - %10s", bBtOnlyResetFilePathIsAvail ? "true": "false"));

   return bBtOnlyResetFilePathIsAvail;
}

bool FC_Bluetooth_tclCCAService::bCheckBtStateOffFileIsExist()
{
   bool bBtStateOffFilePathIsAvail = false;

   if(access(BT_STATE_OFF_FILEPATH, F_OK) != -1)
   {
      bBtStateOffFilePathIsAvail = true;
   }

   ETG_TRACE_USR4((" bCheckBtStateOffFileIsExist: FileExist - %10s", bBtStateOffFilePathIsAvail ? "true": "false"));

   return bBtStateOffFilePathIsAvail;
}

bool FC_Bluetooth_tclCCAService::bCheckStackIsRunning()
{
   bool stackRunning(false);
   const ::std::string hliProcess("evo_hli_socket");
   const ::std::string genProcess("evo_genivi_bt");

   if((true == ::fw::isProcessRunning(hliProcess)) && (true == ::fw::isProcessRunning(genProcess))
         && (true == _bStackInitialized))
   {
      stackRunning = true;
   }

   ETG_TRACE_USR4((" bCheckStackIsRunning: _bStackInitialized - %d, stackRunning - %10s", _bStackInitialized, stackRunning ? "true": "false"));

   return stackRunning;
}

tVoid FC_Bluetooth_tclCCAService::vGetVehicleAddress(BdAddress& bdAddress)
{
   ENTRY_INTERNAL

   bdAddress = _vehicleBtAddress;

   ETG_TRACE_USR1((" vGetVehicleAddress - %s",  bdAddress.c_str()));

   return;
}

tBool FC_Bluetooth_tclCCAService::handleVehicleSupportedProfilesGet(amt_tclServiceData& roOutMsg)
{
   ENTRY

   tBool bRet = false;

   ETG_TRACE_USR1((" handleVehicleSupportedProfilesGet entered"));

   bRet = fi_tclVisitorMessage(_oFIDataVehicleSupportedBTProfiles, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);

   return bRet;
}

tVoid FC_Bluetooth_tclCCAService::vUpdateVehicleSupportedProfiles(ProtocolInfoMap protocolInfos)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1((" vUpdateVehicleSupportedProfiles entered"));

   most_fi_tcl_BTSetSupportedProfiles mostSupportedProfiles;

   memcpy(&mostSupportedProfiles, &_oFIDataVehicleSupportedBTProfiles.oSupportedProfiles, sizeof(mostSupportedProfiles));

   MapSupportedProfilesStatusToMOST(_oFIDataVehicleSupportedBTProfiles.oSupportedProfiles, protocolInfos);

   if((mostSupportedProfiles.bHFPSupport != _oFIDataVehicleSupportedBTProfiles.oSupportedProfiles.bHFPSupport) ||
      (mostSupportedProfiles.bA2DPSupport != _oFIDataVehicleSupportedBTProfiles.oSupportedProfiles.bA2DPSupport) ||
      (mostSupportedProfiles.bAVRCPSupport != _oFIDataVehicleSupportedBTProfiles.oSupportedProfiles.bAVRCPSupport) ||
      (mostSupportedProfiles.bPANSupport != _oFIDataVehicleSupportedBTProfiles.oSupportedProfiles.bPANSupport) ||
      (mostSupportedProfiles.bPBAPSuport != _oFIDataVehicleSupportedBTProfiles.oSupportedProfiles.bPBAPSuport) ||
      (mostSupportedProfiles.bMAPSupport != _oFIDataVehicleSupportedBTProfiles.oSupportedProfiles.bMAPSupport) ||
      (mostSupportedProfiles.bSPPSupport != _oFIDataVehicleSupportedBTProfiles.oSupportedProfiles.bSPPSupport))
   {
      updateClients(MOST_BTSETFI_C_U16_VEHICLESUPPORTEDBTPROFILES);
   }

   return;
}

tBool FC_Bluetooth_tclCCAService::handleAutoconnectOnOffGet(amt_tclServiceData& roOutMsg)
{
   ENTRY

   tBool bRet = false;

   ETG_TRACE_USR1((" handleAutoconnectOnOffGet ::Type : %d", _oFIDataAutoConnectOnOff.bAutoConnectOnOff));
   bRet = fi_tclVisitorMessage(_oFIDataAutoConnectOnOff, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);

   return bRet;
}

tVoid FC_Bluetooth_tclCCAService::vUpdateAutoConnectOnOff(StandardAutoConnectionType type)
{
   ENTRY_INTERNAL

   tBool bAutoConnectOnOff = _oFIDataAutoConnectOnOff.bAutoConnectOnOff;

   MapAutoConnectOnOffStatusToMOST(_oFIDataAutoConnectOnOff, type);

   ETG_TRACE_USR1((" vUpdateAutoConnectOnOff ::Type : prev:%d cur:%d", bAutoConnectOnOff, _oFIDataAutoConnectOnOff.bAutoConnectOnOff));

   if(bAutoConnectOnOff != _oFIDataAutoConnectOnOff.bAutoConnectOnOff)
   {
      updateClients(MOST_BTSETFI_C_U16_AUTOCONNECTONOFF);
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::vGetAutoConnectionType(tBool& bAutoconnectOnOff)
{
   ENTRY_INTERNAL

   bAutoconnectOnOff = _oFIDataAutoConnectOnOff.bAutoConnectOnOff;

   ETG_TRACE_USR1(("vGetAutoConnectionType ::Type : %d", _oFIDataAutoConnectOnOff.bAutoConnectOnOff));

   return;
}

tBool FC_Bluetooth_tclCCAService::handlePairingRequestGet(amt_tclServiceData& roOutMsg)
{
   ENTRY

   tBool bRet = false;

   ETG_TRACE_USR1((" handlePairingRequestGet ::sDeviceName : %s", _oFIDataPairingRequest.sDeviceName.szValue));
   ETG_TRACE_USR1((" handlePairingRequestGet ::sRemoteDeviceAddress : %s", _oFIDataPairingRequest.sRemoteDeviceAddress.szValue));
   ETG_TRACE_USR1((" handlePairingRequestGet ::sPinNumber : %s", _oFIDataPairingRequest.sPinNumber.szValue));
   ETG_TRACE_USR1((" handlePairingRequestGet ::PairingType : %d", _oFIDataPairingRequest.e8PairingType.enType));
   ETG_TRACE_USR1((" handlePairingRequestGet ::Origin : %d", _oFIDataPairingRequest.e8Origin.enType));

   bRet = fi_tclVisitorMessage(_oFIDataPairingRequest, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);

   return bRet;
}

tVoid FC_Bluetooth_tclCCAService::vUpdatePairingRequest(const PairingStatus& btPairingStatus)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1((" vUpdatePairingRequest ::entered"));

   if(s32StringCompare(_oFIDataPairingRequest.sPinNumber.szValue, btPairingStatus._pin.c_str()) != FC_BLUETOOTH_CCASERVICE_ZERO)
   {
      _oFIDataPairingRequest.sPinNumber.bSet(btPairingStatus._pin.c_str(), most_fi_tcl_String::FI_EN_UTF8);

      if(s32StringCompare(_oFIDataPairingRequest.sDeviceName.szValue, btPairingStatus._remoteBdName.c_str()) != FC_BLUETOOTH_CCASERVICE_ZERO)
      {
         _oFIDataPairingRequest.sDeviceName.bSet(btPairingStatus._remoteBdName.c_str(), most_fi_tcl_String::FI_EN_UTF8);
      }

      if(s32StringCompare(_oFIDataPairingRequest.sRemoteDeviceAddress.szValue, btPairingStatus._remoteBdAddress.c_str()) != FC_BLUETOOTH_CCASERVICE_ZERO)
      {
         _oFIDataPairingRequest.sRemoteDeviceAddress.bSet(btPairingStatus._remoteBdAddress.c_str());
      }

      most_fi_tcl_e8_BTSetPairingType mostPairingType;
      MapPairingTypeToMOST(mostPairingType, btPairingStatus._pairingType);

      if(_oFIDataPairingRequest.e8PairingType.enType != mostPairingType.enType)
      {
         _oFIDataPairingRequest.e8PairingType.enType = mostPairingType.enType;
      }

      most_fi_tcl_e8_BTSetOrigin mostOrigin;
      MapOriginTypeToMOST(mostOrigin, btPairingStatus._origin);

      if(_oFIDataPairingRequest.e8Origin.enType != mostOrigin.enType)
      {
         _oFIDataPairingRequest.e8Origin.enType = mostOrigin.enType;
      }

      updateClients(MOST_BTSETFI_C_U16_PAIRINGREQUEST);
   }

   return;
}

tBool FC_Bluetooth_tclCCAService::handleDeviceListExtendedGet(amt_tclServiceData& roOutMsg)
{
   ENTRY
   (tVoid) roOutMsg;

   tBool bRet = false;

   bRet = fi_tclVisitorMessage(_oFIDataObjectDeviceListExtended, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);

   return bRet;
}

tVoid FC_Bluetooth_tclCCAService::vUpdateDeviceListExtended(const PairedDeviceList& pairedDeviceList,
      const DeviceConnectionStatusList& deviceConnectionStatusList)
{
   ENTRY_INTERNAL

   DeviceConnectionInfoList::const_iterator connListIt;

   _oFIDataObjectDeviceListExtended.oDeviceListExtendedResult.oItems.clear();
   _oFIDataObjectDeviceListExtended.u8NumPairedDevices = FC_BLUETOOTH_CCASERVICE_ZERO;

   _oFIDataObjectDeviceListExtended.oDeviceListChange.u8DeviceHandle = _oDeviceListChange.u8DeviceHandle;
   _oFIDataObjectDeviceListExtended.oDeviceListChange.e8DeviceStatus.enType = _oDeviceListChange.e8DeviceStatus.enType;

   ETG_TRACE_USR1((" vUpdateDeviceListExtended :: _maxNumPairedDevices - %d", _maxNumPairedDevices));

   for (std::list<DeviceBaseInfo>::const_iterator it = pairedDeviceList._deviceBaseInfoList.begin();
         it != pairedDeviceList._deviceBaseInfoList.end(); it++)
   {
      if (_oFIDataObjectDeviceListExtended.u8NumPairedDevices < _maxNumPairedDevices)
      {
         _oFIDataObjectDeviceListExtended.u8NumPairedDevices++;

         most_fi_tcl_BTSetDeviceListExtendedResultItem oSetDeviceListExtResultItem;

         _oFIDataObjectDeviceListExtended.oDeviceListExtendedResult.oItems.push_back(oSetDeviceListExtResultItem);

         most_fi_tcl_BTSetDeviceListExtendedResultItem& oDeviceItem = _oFIDataObjectDeviceListExtended.oDeviceListExtendedResult.oItems.back();

         std::string str = it->_bdAddress;

         if(_bBluetoothServiceIsAvail == true)
         {
            std::transform(str.begin(), str.end(), str.begin(), ::tolower);
         }

         oDeviceItem.sDeviceAddress.bSet(str.c_str(), most_fi_tcl_String::FI_EN_UTF8);

         oDeviceItem.u8DeviceHandle = (tU8)it->_deviceHandle;

         oDeviceItem.sDeviceName.bSet(it->_bdName.c_str());

         MapDeviceListExtendedConnectionStatusToMOST(oDeviceItem.bDeviceConnectedStatus, it->_deviceHandle, it->_connectionStatus);

         MapConnectionStatusTypeToMOST(oDeviceItem.e8DeviceConnectionStatus, it->_connectionStatus);

         if (oDeviceItem.bDeviceConnectedStatus == TRUE)
         {
            oDeviceItem.e8DeviceDisconnectedReason.enType = most_fi_tcl_e8_BTSetDeviceDisconnectedReason::FI_EN_E8NOT_APPLICABLE;

            if(oDeviceItem.u8DeviceHandle == _oDeviceListChange.u8DeviceHandle)
            {
               _oFIDataObjectDeviceListExtended.oDeviceListChange.e8DeviceDisconnectedReason.enType = most_fi_tcl_e8_BTSetDeviceDisconnectedReason::FI_EN_E8NOT_APPLICABLE;
            }
         }
         else
         {
            if(oDeviceItem.u8DeviceHandle == _oDeviceListChange.u8DeviceHandle)
            {
               MapDeviceDisconnectedReasonToMOST(_oFIDataObjectDeviceListExtended.oDeviceListChange.e8DeviceDisconnectedReason, it->_disconnectedReason);
            }

            MapDeviceDisconnectedReasonToMOST(oDeviceItem.e8DeviceDisconnectedReason, it->_disconnectedReason);
         }

         connListIt = std::find_if(deviceConnectionStatusList._deviceConnectionInfoList.begin(),
               deviceConnectionStatusList._deviceConnectionInfoList.end(),
               MeetsDeviceHandle<DeviceConnectionInfo>(it->_deviceHandle));

         if (connListIt != deviceConnectionStatusList._deviceConnectionInfoList.end())
         {
            MapDeviceProfilesStatusToMOST(oDeviceItem.oDeviceProfileStatus, oDeviceItem.oDeviceProfileConnectionStatus,
                  oDeviceItem.oDeviceProfileDisconnectedReason, connListIt->_protocolConnectionInfo, connListIt->_deviceHandle);
         }
         else
         {
            bool devicefound = false;

            //check the device is already available in the list if it is not then set the device disconnected reason
            for(tU16 u16Index = 0; u16Index < _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems.size();u16Index++)
            {
               if(oDeviceItem.u8DeviceHandle == _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].u8DeviceHandle)
               {
                  devicefound = true;

                  oDeviceItem.oDeviceProfileDisconnectedReason.e8HFP = _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].oDeviceProfileDisconnectedReason.e8HFP;
                  oDeviceItem.oDeviceProfileDisconnectedReason.e8AVP = _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].oDeviceProfileDisconnectedReason.e8AVP;
                  oDeviceItem.oDeviceProfileDisconnectedReason.e8PAN = _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].oDeviceProfileDisconnectedReason.e8PAN;
                  oDeviceItem.oDeviceProfileDisconnectedReason.e8PBAP = _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].oDeviceProfileDisconnectedReason.e8PBAP;
                  oDeviceItem.oDeviceProfileDisconnectedReason.e8MAP = _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].oDeviceProfileDisconnectedReason.e8MAP;
                  break;
               }
            }

            if(false == devicefound)
            {
               oDeviceItem.oDeviceProfileDisconnectedReason.e8HFP = oDeviceItem.e8DeviceDisconnectedReason;
               oDeviceItem.oDeviceProfileDisconnectedReason.e8AVP = oDeviceItem.e8DeviceDisconnectedReason;
               oDeviceItem.oDeviceProfileDisconnectedReason.e8PAN = oDeviceItem.e8DeviceDisconnectedReason;
               oDeviceItem.oDeviceProfileDisconnectedReason.e8PBAP = oDeviceItem.e8DeviceDisconnectedReason;
               oDeviceItem.oDeviceProfileDisconnectedReason.e8MAP = oDeviceItem.e8DeviceDisconnectedReason;
            }
         }

         MapSupportedProfilesStatusToMOST(oDeviceItem.oDeviceSupportedProfiles, it->_protocolInfo);

         if (oDeviceItem.u8DeviceHandle == _outgoingSourceDeviceHandle)
         {
            oDeviceItem.bOutgoingSourceDeviceStatus = TRUE;
         }
         else
         {
            oDeviceItem.bOutgoingSourceDeviceStatus = FALSE;
         }

         oDeviceItem.u8DeviceFavoriteIndex = (tU8)it->_favoriteIndex;

         MapFavoriteProfilesIndexToMOST(oDeviceItem.oDeviceProfileFavoriteIndex, it->_protocolInfo);

         MapDeviceUsagePreferenceToMOST(oDeviceItem.e8DeviceUsagePreference, it->_usagePreference);

         oDeviceItem.biAPoverBTSupport = it->_iAPoverBTSupported;

         ETG_TRACE_USR1((" vUpdateDeviceListExtended ::u8NumPairedDevices : %d", _oFIDataObjectDeviceListExtended.u8NumPairedDevices));

         ETG_TRACE_USR1((" vUpdateDeviceListExtended ::oDeviceListChange.DeviceHandle : %d", _oFIDataObjectDeviceListExtended.oDeviceListChange.u8DeviceHandle));

         ETG_TRACE_USR1((" vUpdateDeviceListExtended ::oDeviceListChange.e8DeviceStatus : %d", _oFIDataObjectDeviceListExtended.oDeviceListChange.e8DeviceStatus.enType));

         ETG_TRACE_USR1((" vUpdateDeviceListExtended ::oDeviceListChange.e8DeviceDisconnectedReason : %d", _oFIDataObjectDeviceListExtended.oDeviceListChange.e8DeviceDisconnectedReason.enType));

         ETG_TRACE_USR1((" vUpdateDeviceListExtended ::oDeviceItem.u8DeviceHandle : %d", oDeviceItem.u8DeviceHandle));

         ETG_TRACE_USR1((" vUpdateDeviceListExtended ::oDeviceItem.sDeviceName : %s", it->_bdName.c_str()));

         ETG_TRACE_USR1((" vUpdateDeviceListExtended ::oDeviceItem.sDeviceAddress : %s", it->_bdAddress.c_str()));

         ETG_TRACE_USR1((" vUpdateDeviceListExtended ::oDeviceItem.bHFP - %d, bAVP - %d, bPAN -%d bMAP - %d bPBAP - %d",
               oDeviceItem.oDeviceProfileStatus.bHFP,\
               oDeviceItem.oDeviceProfileStatus.bAVP,\
               oDeviceItem.oDeviceProfileStatus.bPAN,\
               oDeviceItem.oDeviceProfileStatus.bMAP,\
               oDeviceItem.oDeviceProfileStatus.bPBAP));

         ETG_TRACE_USR1((" vUpdateDeviceListExtended ::oDeviceProfileConnectionStatus.e8HFP - %d, e8AVP - %d, e8PAN -%d e8MAP - %d e8PBAP - %d",
               oDeviceItem.oDeviceProfileConnectionStatus.e8HFP.enType,\
               oDeviceItem.oDeviceProfileConnectionStatus.e8AVP.enType,\
               oDeviceItem.oDeviceProfileConnectionStatus.e8PAN.enType,\
               oDeviceItem.oDeviceProfileConnectionStatus.e8MAP.enType,\
               oDeviceItem.oDeviceProfileConnectionStatus.e8PBAP.enType));

         ETG_TRACE_USR1((" vUpdateDeviceListExtended ::oDeviceProfileDisconnectedReason.e8HFP - %d, e8AVP - %d, e8PAN -%d e8MAP - %d e8PBAP - %d",
               oDeviceItem.oDeviceProfileDisconnectedReason.e8HFP.enType,\
               oDeviceItem.oDeviceProfileDisconnectedReason.e8AVP.enType,\
               oDeviceItem.oDeviceProfileDisconnectedReason.e8PAN.enType,\
               oDeviceItem.oDeviceProfileDisconnectedReason.e8MAP.enType,\
               oDeviceItem.oDeviceProfileDisconnectedReason.e8PBAP.enType));

         ETG_TRACE_USR1((" vUpdateDeviceListExtended ::oDeviceItem.bSSP - %d, bHFP - %d, bA2DP -%d bAVRCP - %d, bMAP -%d bDUN - %d  bPAN - %d bPBAP - %d bDIP - %d",
               oDeviceItem.oDeviceSupportedProfiles.bSPPSupport,
               oDeviceItem.oDeviceSupportedProfiles.bHFPSupport,
               oDeviceItem.oDeviceSupportedProfiles.bA2DPSupport,
               oDeviceItem.oDeviceSupportedProfiles.bAVRCPSupport,
               oDeviceItem.oDeviceSupportedProfiles.bMAPSupport,
               oDeviceItem.oDeviceSupportedProfiles.bDUNSupport,
               oDeviceItem.oDeviceSupportedProfiles.bPANSupport,
               oDeviceItem.oDeviceSupportedProfiles.bPBAPSuport,
               oDeviceItem.oDeviceSupportedProfiles.bDIPSupport));

         ETG_TRACE_USR1((" vUpdateDeviceListExtended ::oDeviceItem.bDeviceConnectedStatus : %d", oDeviceItem.bDeviceConnectedStatus));

         ETG_TRACE_USR1((" vUpdateDeviceListExtended ::oDeviceItem.e8DeviceConnectionStatus : %d", oDeviceItem.e8DeviceConnectionStatus.enType));

         ETG_TRACE_USR1((" vUpdateDeviceListExtended ::oDeviceItem.e8DeviceDisconnectedReason : %d", oDeviceItem.e8DeviceDisconnectedReason.enType));

         ETG_TRACE_USR1((" vUpdateDeviceListExtended ::bOutgoingSourceDeviceStatus : %d", oDeviceItem.bOutgoingSourceDeviceStatus));

         ETG_TRACE_USR1((" vUpdateDeviceListExtended ::u8DeviceFavoriteIndex : %d", oDeviceItem.u8DeviceFavoriteIndex));

         ETG_TRACE_USR1((" vUpdateDeviceListExtended ::HFP Favorite - %d AVP Favorite - %d",
               oDeviceItem.oDeviceProfileFavoriteIndex.u8HFP,
               oDeviceItem.oDeviceProfileFavoriteIndex.u8AVP));

         ETG_TRACE_USR1((" vUpdateDeviceListExtended ::e8DeviceUsagePreference : %d", oDeviceItem.e8DeviceUsagePreference.enType));

         ETG_TRACE_USR1((" vUpdateDeviceListExtended ::biAPoverBTSupport : %d", oDeviceItem.biAPoverBTSupport));

         // Convert seconds to YYYY:MM:DD HH:MM:SS(UTC time)
         MapsecondsToMOST(oDeviceItem.oDateTimeStamp, it->_connectionOrderInfo._seconds);

         MapDeviceIdentificationToMOST(oDeviceItem.oDeviceInfo, it->_deviceIdentification);

         // Convert seconds to YYYY:MM:DD HH:MM:SS(UTC time)
         MapsecondsToMOST(oDeviceItem.oDevicePairedDateTimeStamp, it->_pairingOrderInfo._seconds);
      }
      else
      {
         ETG_TRACE_USR1((" vUpdateDeviceListExtended :: _maxNumPairedDevices is reached"));
         break;
      }
   }

   vCopyFIDataObjectDeviceListExtended();

   updateClients(MOST_BTSETFI_C_U16_DEVICELISTEXTENDED);

   return;
}

tVoid FC_Bluetooth_tclCCAService::vCopyFIDataObjectDeviceListExtended()
{
   ENTRY_INTERNAL

   _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems.clear();
   _oFIDataObjectDeviceListExtendedPrev = _oFIDataObjectDeviceListExtended;

   ETG_TRACE_USR1((" vCopyFIDataObjectDeviceListExtended ::u8NumPairedDevices : %d", _oFIDataObjectDeviceListExtendedPrev.u8NumPairedDevices));

   ETG_TRACE_USR1((" vCopyFIDataObjectDeviceListExtended ::oDeviceListChange.DeviceHandle : %d", _oFIDataObjectDeviceListExtendedPrev.oDeviceListChange.u8DeviceHandle));

   ETG_TRACE_USR1((" vCopyFIDataObjectDeviceListExtended ::oDeviceListChange.e8DeviceStatus : %d", _oFIDataObjectDeviceListExtendedPrev.oDeviceListChange.e8DeviceStatus.enType));

   ETG_TRACE_USR1((" vCopyFIDataObjectDeviceListExtended ::oDeviceListChange.e8DeviceDisconnectedReason : %d", _oFIDataObjectDeviceListExtendedPrev.oDeviceListChange.e8DeviceDisconnectedReason.enType));

   ETG_TRACE_USR1((" vCopyFIDataObjectDeviceListExtended ::size : %d", _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems.size()));

   for(tU16 u16Index = 0; u16Index < _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems.size();u16Index++)
   {
      ETG_TRACE_USR1((" vCopyFIDataObjectDeviceListExtended ::oDeviceItem.u8DeviceHandle : %d", _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].u8DeviceHandle));

      ETG_TRACE_USR1((" vCopyFIDataObjectDeviceListExtended ::oDeviceItem.sDeviceName : %s", _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].sDeviceName.szValue));

      ETG_TRACE_USR1((" vCopyFIDataObjectDeviceListExtended ::oDeviceItem.sDeviceAddress : %s", _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].sDeviceAddress.szValue));

      ETG_TRACE_USR1((" vCopyFIDataObjectDeviceListExtended ::oDeviceItem.bHFP - %d, bAVP - %d, bPAN -%d bMAP - %d bPBAP - %d",
            _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].oDeviceProfileStatus.bHFP,\
            _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].oDeviceProfileStatus.bAVP,\
            _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].oDeviceProfileStatus.bPAN,\
            _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].oDeviceProfileStatus.bMAP,\
            _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].oDeviceProfileStatus.bPBAP));

      ETG_TRACE_USR1((" vCopyFIDataObjectDeviceListExtended ::oDeviceProfileConnectionStatus.e8HFP - %d, e8AVP - %d, e8PAN -%d e8MAP - %d e8PBAP - %d",
            _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].oDeviceProfileConnectionStatus.e8HFP.enType,\
            _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].oDeviceProfileConnectionStatus.e8AVP.enType,\
            _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].oDeviceProfileConnectionStatus.e8PAN.enType,\
            _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].oDeviceProfileConnectionStatus.e8MAP.enType,\
            _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].oDeviceProfileConnectionStatus.e8PBAP.enType));

      ETG_TRACE_USR1((" vCopyFIDataObjectDeviceListExtended ::oDeviceItem.bSSP - %d, bHFP - %d, bA2DP -%d bAVRCP - %d, bMAP -%d bDUN - %d  bPAN - %d bPBAP - %d bDIP - %d",
            _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].oDeviceSupportedProfiles.bSPPSupport,
            _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].oDeviceSupportedProfiles.bHFPSupport,
            _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].oDeviceSupportedProfiles.bA2DPSupport,
            _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].oDeviceSupportedProfiles.bAVRCPSupport,
            _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].oDeviceSupportedProfiles.bMAPSupport,
            _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].oDeviceSupportedProfiles.bDUNSupport,
            _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].oDeviceSupportedProfiles.bPANSupport,
            _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].oDeviceSupportedProfiles.bPBAPSuport,
            _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].oDeviceSupportedProfiles.bDIPSupport));

      ETG_TRACE_USR1((" vCopyFIDataObjectDeviceListExtended ::oDeviceItem.bDeviceConnectedStatus : %d", _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].bDeviceConnectedStatus));

      ETG_TRACE_USR1((" vCopyFIDataObjectDeviceListExtended ::oDeviceItem.e8DeviceConnectionStatus : %d", _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].e8DeviceConnectionStatus.enType));

      ETG_TRACE_USR1((" vCopyFIDataObjectDeviceListExtended ::oDeviceItem.e8DeviceDisconnectedReason : %d", _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].e8DeviceDisconnectedReason.enType));

      ETG_TRACE_USR1((" vCopyFIDataObjectDeviceListExtended ::bOutgoingSourceDeviceStatus : %d", _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].bOutgoingSourceDeviceStatus));

      ETG_TRACE_USR1((" vCopyFIDataObjectDeviceListExtended ::e8DeviceUsagePreference : %d", _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].e8DeviceUsagePreference.enType));

      ETG_TRACE_USR1((" vCopyFIDataObjectDeviceListExtended ::u8DeviceFavoriteIndex : %d", _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].u8DeviceFavoriteIndex));

      ETG_TRACE_USR1((" vCopyFIDataObjectDeviceListExtended ::oDeviceProfileFavoriteIndex.u8HFP - %d, u8AVP -%d",
                  _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].oDeviceProfileFavoriteIndex.u8HFP,
                  _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].oDeviceProfileFavoriteIndex.u8AVP));
   }
}

tVoid FC_Bluetooth_tclCCAService::MapDeviceListExtendedConnectionStatusToMOST(tBool &bDeviceConnectedStatus, DeviceId deviceHandle, ConnectionStatus connectionStatus)
{
   ENTRY_INTERNAL

   PairedDeviceList pairedDeviceList;
   DeviceBaseInfoList::iterator devInfoListIt;

   ETG_TRACE_USR1((" MapDeviceListExtendedConnectionStatusToMOST :: connectionStatus - %d", connectionStatus));

   if (connectionStatus == BM_CONNECTION_STATUS_CONNECTED)
   {
      bDeviceConnectedStatus = TRUE;
   }
   else if((connectionStatus == BM_CONNECTION_STATUS_DISCONNECTED) ||
         (connectionStatus == BM_CONNECTION_STATUS_CONNECTING))
   {
      bDeviceConnectedStatus = FALSE;
   }
   else
   {
      tBool bRes = false;

      for(tU16 u16Index = 0; u16Index < _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems.size();u16Index++)
      {
         if(deviceHandle == _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].u8DeviceHandle)
         {
            bDeviceConnectedStatus = _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].bDeviceConnectedStatus;
            bRes = true;
            break;
         }
      }

      if(bRes == false)
      {
         bDeviceConnectedStatus = FALSE;
      }

      ETG_TRACE_USR2((" MapDeviceListExtendedConnectionStatusToMOST:bRes : %d", bRes));
   }

   ETG_TRACE_USR2((" MapDeviceListExtendedConnectionStatusToMOST:bDeviceConnectedStatus : %d", bDeviceConnectedStatus));
}

tVoid FC_Bluetooth_tclCCAService::vSetPrevProfileStatus(DeviceId deviceHandle, ProtocolId protocolId, tBool& bProfileStatus)
{
   tBool bRes = false;

   for(tU16 u16Index = 0; u16Index < _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems.size();u16Index++)
   {
      if(deviceHandle == _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].u8DeviceHandle)
      {
         if(protocolId == BM_PROTOCOL_ID_HFP)
         {
            bProfileStatus = _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].oDeviceProfileStatus.bHFP;
         }
         else if (protocolId == BM_PROTOCOL_ID_AVP)
         {
            bProfileStatus = _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].oDeviceProfileStatus.bAVP;
         }
         else if (protocolId == BM_PROTOCOL_ID_PAN)
         {
            bProfileStatus = _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].oDeviceProfileStatus.bPAN;
         }
         else if (protocolId == BM_PROTOCOL_ID_PBDL)
         {
            bProfileStatus = _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].oDeviceProfileStatus.bPBAP;
         }

         else if (protocolId == BM_PROTOCOL_ID_MSG)
         {
            bProfileStatus = _oFIDataObjectDeviceListExtendedPrev.oDeviceListExtendedResult.oItems[u16Index].oDeviceProfileStatus.bMAP;
         }

         bRes = true;
         break;
      }
   }

   if(bRes == false)
   {
      bProfileStatus = FALSE;
   }

   ETG_TRACE_USR1((" vSetPrevProfileStatus ::bRes - %d bProfileStatus - %d", bRes, bProfileStatus));

   return;
}

tBool FC_Bluetooth_tclCCAService::handleVisibleDevicesGet(amt_tclServiceData& roOutMsg)
{
   ENTRY
   (tVoid) roOutMsg;

   tBool bRet = false;

   ETG_TRACE_USR1((" handleVisibleDevicesGet ::u8NumVisibleDevices : %d", _oFIDataVisibleDevicesStatus.u8NumVisibleDevices));

   bRet = fi_tclVisitorMessage(_oFIDataVisibleDevicesStatus, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);

   return bRet;
}

tVoid FC_Bluetooth_tclCCAService::vUpdateDiscoveredDeviceList(const DiscoveredDeviceList& discoveredDeviceList)
{
   ENTRY_INTERNAL

   _oFIDataVisibleDevicesStatus.oVisibleDevicesList.oVisibleDeviceItems.clear();
   _oFIDataVisibleDevicesStatus.u8NumVisibleDevices = FC_BLUETOOTH_CCASERVICE_ZERO;

   for (std::list<DiscoveredDeviceInfo>::const_iterator it = discoveredDeviceList._discoveredDeviceInfoList.begin();
         it != discoveredDeviceList._discoveredDeviceInfoList.end(); it++)
   {
      _oFIDataVisibleDevicesStatus.u8NumVisibleDevices++;

      most_fi_tcl_BTSetVisibleDeviceItem oSetVisibleDeviceItem;

      _oFIDataVisibleDevicesStatus.oVisibleDevicesList.oVisibleDeviceItems.push_back(oSetVisibleDeviceItem);

      most_fi_tcl_BTSetVisibleDeviceItem& oDeviceItem = _oFIDataVisibleDevicesStatus.oVisibleDevicesList.oVisibleDeviceItems.back();

      oDeviceItem.sBluetoothDeviceAddress.bSet(it->_bdAddress.c_str(), most_fi_tcl_String::FI_EN_UTF8);

      oDeviceItem.sDeviceName.bSet(it->_bdName.c_str(), most_fi_tcl_String::FI_EN_UTF8);

      MapSupportedProfilesStatusToMOST(oDeviceItem.oSupportedProfiles, it->_protocolInfo);

      MapVisibleDeviceConnectionStatusToMOST(oDeviceItem.e8VisibleDeviceConnectionStatus, it->_deviceHandle, it->_connectionStatus);

      ETG_TRACE_USR1((" vUpdateDiscoveredDeviceList ::u8NumVisibleDevices : %d", _oFIDataVisibleDevicesStatus.u8NumVisibleDevices));

      ETG_TRACE_USR1(("vUpdateDiscoveredDeviceList::sBluetoothDeviceAddress = %s ", it->_bdAddress.c_str()));

      ETG_TRACE_USR1(("vUpdateDiscoveredDeviceList::sDeviceName = %s ", it->_bdName.c_str()));

      ETG_TRACE_USR1(("vUpdateDiscoveredDeviceList::e8VisibleDeviceConnectionStatus = %d ",
            oDeviceItem.e8VisibleDeviceConnectionStatus.enType));
   }

   updateClients(MOST_BTSETFI_C_U16_VISIBLEDEVICES);

   return;
}

tBool FC_Bluetooth_tclCCAService::handleBluetoothAudioSourceGet(amt_tclServiceData& roOutMsg)
{
   ENTRY
   (tVoid) roOutMsg;

   tBool bRet = false;

   ETG_TRACE_USR1((" handleBluetoothAudioSourceGet ::DeviceHandle - %d", _oFIDataBluetoothAudioSource.u8DeviceHandle));
   ETG_TRACE_USR1((" handleBluetoothAudioSourceGet ::bPlaySupport - %d", _oFIDataBluetoothAudioSource.oDeviceControlSupport.bPlaySupport));
   ETG_TRACE_USR1((" handleBluetoothAudioSourceGet ::bPauseSupport - %d", _oFIDataBluetoothAudioSource.oDeviceControlSupport.bPauseSupport));
   ETG_TRACE_USR1((" handleBluetoothAudioSourceGet ::bNextTrackSupport - %d", _oFIDataBluetoothAudioSource.oDeviceControlSupport.bNextTrackSupport));
   ETG_TRACE_USR1((" handleBluetoothAudioSourceGet ::bPreviousTrackSupport - %d", _oFIDataBluetoothAudioSource.oDeviceControlSupport.bPreviousTrackSupport));
   ETG_TRACE_USR1((" handleBluetoothAudioSourceGet ::bShuffleSupport - %d", _oFIDataBluetoothAudioSource.oDeviceControlSupport.bShuffleSupport));
   ETG_TRACE_USR1((" handleBluetoothAudioSourceGet ::bRepeatSupport - %d", _oFIDataBluetoothAudioSource.oDeviceControlSupport.bRepeatSupport));
   ETG_TRACE_USR1((" handleBluetoothAudioSourceGet ::bFastForwardSupport - %d", _oFIDataBluetoothAudioSource.oDeviceControlSupport.bFastForwardSupport));
   ETG_TRACE_USR1((" handleBluetoothAudioSourceGet ::bRewindSupport - %d", _oFIDataBluetoothAudioSource.oDeviceControlSupport.bRewindSupport));
   ETG_TRACE_USR1((" handleBluetoothAudioSourceGet ::bPreviousTrackSupport - %d", _oFIDataBluetoothAudioSource.oDeviceControlSupport.bPreviousTrackSupport));
   ETG_TRACE_USR1((" handleBluetoothAudioSourceGet ::bMediaAggregrationSupport - %d", _oFIDataBluetoothAudioSource.oDeviceControlSupport.bMediaAggregrationSupport));
   ETG_TRACE_USR1((" handleBluetoothAudioSourceGet ::bPlaytimeSupport - %d", _oFIDataBluetoothAudioSource.oDeviceControlSupport.bPlaytimeSupport));
   ETG_TRACE_USR1((" handleBluetoothAudioSourceGet ::bMetadataSupport - %d", _oFIDataBluetoothAudioSource.oDeviceControlSupport.bMetadataSupport));
   ETG_TRACE_USR1((" handleBluetoothAudioSourceGet ::bFolderBrowseSupport - %d", _oFIDataBluetoothAudioSource.oDeviceControlSupport.bFolderBrowseSupport));

   bRet = fi_tclVisitorMessage(_oFIDataBluetoothAudioSource, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);

   return bRet;
}

tVoid FC_Bluetooth_tclCCAService::vUpdateBluetoothAudioSource(tU8 u8DeviceHandle, const PairedDeviceList& pairedDeviceList)
{
   ENTRY

   DeviceBaseInfoList::const_iterator devInfoListIt;

   ETG_TRACE_USR1((" vUpdateBluetoothAudioSource ::DeviceHandle - %d", u8DeviceHandle));

   if(u8DeviceHandle != INVALID_DEVICE_HANDLE)
   {
      devInfoListIt = std::find_if(pairedDeviceList._deviceBaseInfoList.begin(),
            pairedDeviceList._deviceBaseInfoList.end(),
            MeetsDeviceHandle<DeviceBaseInfo>(u8DeviceHandle));

      if(devInfoListIt != pairedDeviceList._deviceBaseInfoList.end())
      {
         for (ProtocolInfoMap::const_iterator it = devInfoListIt->_protocolInfo.begin(); it != devInfoListIt->_protocolInfo.end(); it++)
         {
            ETG_TRACE_USR1(("vUpdateBluetoothAudioSource: ProtocolID = %i; _version = %x",
                  it->first, it->second._version));

            if (it->first == BM_PROTOCOL_ID_AVP)
            {
               _bluetoothAudioVersion = it->second._version;

               // Set the play and pause support as true(version info is not available for A2DP device)
               _oFIDataBluetoothAudioSource.u8DeviceHandle = u8DeviceHandle;
               _oFIDataBluetoothAudioSource.oDeviceControlSupport.bPlaySupport = TRUE;
               _oFIDataBluetoothAudioSource.oDeviceControlSupport.bPauseSupport = TRUE;

               if(it->second._version != 0x0)
               {
                  _oFIDataBluetoothAudioSource.oDeviceControlSupport.bNextTrackSupport = TRUE;
                  _oFIDataBluetoothAudioSource.oDeviceControlSupport.bPreviousTrackSupport = TRUE;
                  _oFIDataBluetoothAudioSource.oDeviceControlSupport.bFastForwardSupport = TRUE;
                  _oFIDataBluetoothAudioSource.oDeviceControlSupport.bRewindSupport = TRUE;
                  _oFIDataBluetoothAudioSource.oDeviceControlSupport.bPlaytimeSupport = TRUE;

                  if(it->second._version == 0x0103)
                  {
                     _oFIDataBluetoothAudioSource.oDeviceControlSupport.bMetadataSupport = TRUE;
                     _oFIDataBluetoothAudioSource.oDeviceControlSupport.bShuffleSupport = TRUE;
                     _oFIDataBluetoothAudioSource.oDeviceControlSupport.bRepeatSupport = TRUE;
                     _oFIDataBluetoothAudioSource.oDeviceControlSupport.bFolderBrowseSupport = FALSE;
                     _oFIDataBluetoothAudioSource.oDeviceControlSupport.bMediaAggregrationSupport = FALSE;
                  }
                  else if(it->second._version > 0x0103)
                  {
                     _oFIDataBluetoothAudioSource.oDeviceControlSupport.bMetadataSupport = TRUE;
                     _oFIDataBluetoothAudioSource.oDeviceControlSupport.bShuffleSupport = TRUE;
                     _oFIDataBluetoothAudioSource.oDeviceControlSupport.bRepeatSupport = TRUE;
                     _oFIDataBluetoothAudioSource.oDeviceControlSupport.bFolderBrowseSupport = TRUE;
                     _oFIDataBluetoothAudioSource.oDeviceControlSupport.bMediaAggregrationSupport = TRUE;
                  }
                  else
                  {
                     _oFIDataBluetoothAudioSource.oDeviceControlSupport.bMetadataSupport = FALSE;
                     _oFIDataBluetoothAudioSource.oDeviceControlSupport.bFolderBrowseSupport = FALSE;
                     _oFIDataBluetoothAudioSource.oDeviceControlSupport.bMediaAggregrationSupport = FALSE;
                     _oFIDataBluetoothAudioSource.oDeviceControlSupport.bShuffleSupport = FALSE;
                     _oFIDataBluetoothAudioSource.oDeviceControlSupport.bRepeatSupport = FALSE;
                  }
               }
               else
               {
                  ETG_TRACE_ERR((" vUpdateBluetoothAudioSource ::DeviceHandle in the paired device list But version is zero"));
               }

               updateClients(MOST_BTSETFI_C_U16_BLUETOOTHAUDIOSOURCE);

               break;
            }
         }
      }
      else
      {
         ETG_TRACE_ERR((" vUpdateBluetoothAudioSource ::DeviceHandle not in the paired device list"));
      }
   }
   else
   {
      _bluetoothAudioVersion = FC_BLUETOOTH_CCASERVICE_ZERO;

      _oFIDataBluetoothAudioSource.u8DeviceHandle = u8DeviceHandle;
      _oFIDataBluetoothAudioSource.oDeviceControlSupport.bPlaySupport = FALSE;
      _oFIDataBluetoothAudioSource.oDeviceControlSupport.bPauseSupport = FALSE;
      _oFIDataBluetoothAudioSource.oDeviceControlSupport.bNextTrackSupport = FALSE;
      _oFIDataBluetoothAudioSource.oDeviceControlSupport.bPreviousTrackSupport = FALSE;
      _oFIDataBluetoothAudioSource.oDeviceControlSupport.bShuffleSupport = FALSE;
      _oFIDataBluetoothAudioSource.oDeviceControlSupport.bRepeatSupport = FALSE;
      _oFIDataBluetoothAudioSource.oDeviceControlSupport.bFastForwardSupport = FALSE;
      _oFIDataBluetoothAudioSource.oDeviceControlSupport.bRewindSupport = FALSE;
      _oFIDataBluetoothAudioSource.oDeviceControlSupport.bPlaytimeSupport = FALSE;
      _oFIDataBluetoothAudioSource.oDeviceControlSupport.bFolderBrowseSupport = FALSE;
      _oFIDataBluetoothAudioSource.oDeviceControlSupport.bMetadataSupport = FALSE;
      _oFIDataBluetoothAudioSource.oDeviceControlSupport.bMediaAggregrationSupport = FALSE;

      updateClients(MOST_BTSETFI_C_U16_BLUETOOTHAUDIOSOURCE);
   }

   return;
}

tBool FC_Bluetooth_tclCCAService::handleChangeRingtoneGet(amt_tclServiceData& roOutMsg)
{
   ENTRY

   tBool bRet = false;

   ETG_TRACE_USR4(("handleChangeRingtoneGet: devicehandle = %d RintoneId  %d", _oFIDataChangeRingtone.u8DeviceHandle, _oFIDataChangeRingtone.u16RingtoneID));

   bRet = fi_tclVisitorMessage(_oFIDataChangeRingtone, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);

   return bRet;
}

tBool FC_Bluetooth_tclCCAService::handleSignalStrengthGet(amt_tclServiceData& roOutMsg)
{
   ENTRY

   tBool bRet = false;

   ETG_TRACE_USR4(("handleSignalStrengthGet: entered"));

   bRet = fi_tclVisitorMessage(_oFIDataSignalStrength, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);

   return bRet;
}

tVoid FC_Bluetooth_tclCCAService::vGetLinkQuality(LinkQuality& linkQuality)
{
   ENTRY_INTERNAL

   linkQuality = _linkQuality;
}

tVoid FC_Bluetooth_tclCCAService::vUpdateRssiValue(const LinkQuality& linkQuality)
{
   ENTRY_INTERNAL

   tBool bRet = false;
   DeviceId deviceId;
   LinkQualityInfo linkQualityInfo, oldLinkQualityInfo;

   LinkQuality oldlinkQuality;
   vGetLinkQuality(oldlinkQuality);

   ETG_TRACE_USR1(("vUpdateRssiValue : LinkQuality size - %d, oldsize - %d", linkQuality._linkQualityInfoList.size(),
         oldlinkQuality._linkQualityInfoList.size()));

   if(linkQuality._linkQualityInfoList.size() != oldlinkQuality._linkQualityInfoList.size())
   {
      bRet = true;
   }
   else
   {
      for (LinkQualityInfoList::const_iterator it = linkQuality._linkQualityInfoList.begin();
               it != linkQuality._linkQualityInfoList.end(); it++)
      {
         deviceId = it->first;
         linkQualityInfo = it->second;

         for (LinkQualityInfoList::iterator itOld = oldlinkQuality._linkQualityInfoList.begin();
               itOld != oldlinkQuality._linkQualityInfoList.end(); itOld++)
         {
            oldLinkQualityInfo = itOld->second;

            if((deviceId == itOld->first) && (oldLinkQualityInfo._rssi != linkQualityInfo._rssi))
            {
               bRet = true;
               break;
            }
         }

         if(true == bRet)
            break;
      }
   }

   if(true == bRet)
   {
      _oFIDataSignalStrength.oSignalStrengthList.oSignalStrengthItems.clear();

      for (LinkQualityInfoList::const_iterator it = linkQuality._linkQualityInfoList.begin();
            it != linkQuality._linkQualityInfoList.end(); it++)
      {
         deviceId = it->first;
         linkQualityInfo = it->second;

         //SignalStrength
         most_fi_tcl_BTSetSignalStrengthItem oSignalItem;

         oSignalItem.u8DeviceHandle = (tU8)deviceId;
         oSignalItem.s8SignalStrength = linkQualityInfo._rssi;

         ETG_TRACE_USR4((" vUpdateRssiValue ::oSignalItem.u8DeviceHandle : %d", oSignalItem.u8DeviceHandle));
         ETG_TRACE_USR4((" vUpdateRssiValue ::oSignalItem.s8SignalStrength : %d", oSignalItem.s8SignalStrength));

         _oFIDataSignalStrength.oSignalStrengthList.oSignalStrengthItems.push_back(oSignalItem);
      }

      updateClients(MOST_BTSETFI_C_U16_SIGNALSTRENGTH);
   }

   vCopyLinkQuality(linkQuality);

   return;
}

tVoid FC_Bluetooth_tclCCAService::vCopyLinkQuality(const LinkQuality& linkQuality)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR4(("vCopyLinkQuality:entered"));

   _linkQuality._linkQualityInfoList.clear();

   for (LinkQualityInfoList::const_iterator itLQI = linkQuality._linkQualityInfoList.begin();
         itLQI != linkQuality._linkQualityInfoList.end(); itLQI++)
   {
      DeviceId deviceId = itLQI->first;

      LinkQualityInfo linkQualityInfo;
      linkQualityInfo._rssi = itLQI->second._rssi;
      linkQualityInfo._linkQuality = itLQI->second._linkQuality;

      _linkQuality._linkQualityInfoList[deviceId] = linkQualityInfo;

      ETG_TRACE_USR4(("vCopyLinkQuality:deviceId - %d _rssi - %d _linkQuality - %d",
            deviceId, linkQualityInfo._rssi, linkQualityInfo._linkQuality));
   }
}


tVoid FC_Bluetooth_tclCCAService::vUpdateLinkQualityTestMode(const LinkQualityInfo& linkQualityInfo)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1((" vUpdateLinkQualityTestMode ::_linkQuality : %d", linkQualityInfo._linkQuality));
   ETG_TRACE_USR1((" vUpdateLinkQualityTestMode ::_rssi : %d", linkQualityInfo._rssi));

   _linkQualityTestModeInfo._linkQuality = linkQualityInfo._linkQuality;
   _linkQualityTestModeInfo._rssi = linkQualityInfo._rssi;

   return;
}

tVoid FC_Bluetooth_tclCCAService::vGetLinkQualityTestMode(TestModeLinkQuality& linkQuality)
{
   ENTRY_INTERNAL

   linkQuality._linkQualityInfo._linkQuality = _linkQualityTestModeInfo._linkQuality;
   linkQuality._linkQualityInfo._rssi = _linkQualityTestModeInfo._rssi;

   ETG_TRACE_USR1((" vGetLinkQualityTestMode ::_linkQuality : %d", linkQuality._linkQualityInfo._linkQuality));
   ETG_TRACE_USR1((" vGetLinkQualityTestMode ::_rssi : %d", linkQuality._linkQualityInfo._rssi));

   return;
}

tBool FC_Bluetooth_tclCCAService::handlePairableModeGet(amt_tclServiceData& roOutMsg)
{
   ENTRY

   tBool bRet = false;

   ETG_TRACE_USR1((" handlePairableModeGet ::Pairable : %d", _oFIDataPairableMode.Pairable));
   ETG_TRACE_USR1((" handlePairableModeGet ::Connectable : %d", _oFIDataPairableMode.Connectable));
   ETG_TRACE_USR1((" handlePairableModeGet ::PairingInProgress : %d", _oFIDataPairableMode.PairingInProgress));
   ETG_TRACE_USR1((" handlePairableModeGet ::sBTAddress : %s", _oFIDataPairableMode.sBTAddress.szValue));

   bRet = fi_tclVisitorMessage(_oFIDataPairableMode, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);

   return bRet;
}

tVoid FC_Bluetooth_tclCCAService::vUpdatePairableMode(tU8 update, SwitchState switchState,
      PairingState state, BdAddress remoteBdAddress)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1((" vUpdatePairableMode : changed - %d", update));

   tBool bUpdateClients = false;

   if(update == LOCALPAIRABLEMODECHANGED)
   {
      tBool bPairable = _oFIDataPairableMode.Pairable;

      if ((switchState == SWITCH_STATE_SWITCHED_ON) || (switchState == SWITCH_STATE_SWITCHING_OFF))
      {
         _oFIDataPairableMode.Pairable = TRUE;
      }
      else
      {
         _oFIDataPairableMode.Pairable = FALSE;
      }

      ETG_TRACE_USR1((" vUpdatePairableMode: bPairable prev - %d cur - %d",
            bPairable, _oFIDataPairableMode.Pairable));

      if(bPairable != _oFIDataPairableMode.Pairable)
         bUpdateClients = true;
   }
   else if(update == LOCALCONNECTABLEMODECHANGED)
   {
      tBool bConnectable = _oFIDataPairableMode.Connectable;

      if ((switchState == SWITCH_STATE_SWITCHED_ON) || (switchState == SWITCH_STATE_SWITCHING_OFF))
      {
         _oFIDataPairableMode.Connectable = TRUE;
      }
      else
      {
         _oFIDataPairableMode.Connectable = FALSE;
      }

      ETG_TRACE_USR1((" vUpdatePairableMode: bConnectable prev - %d cur - %d",
            bConnectable, _oFIDataPairableMode.Connectable));

      if (bConnectable != _oFIDataPairableMode.Connectable)
         bUpdateClients = true;
   }
   else
   {
      tBool bPairingInProgress = _oFIDataPairableMode.PairingInProgress;

      _pairingState = state;

      if (state == BM_PAIRING_STATE_PAIRING_IN_PROGRESS)
      {
         _oFIDataPairableMode.PairingInProgress = TRUE;
      }
      else
      {
         _oFIDataPairableMode.PairingInProgress = FALSE;
      }

      ETG_TRACE_USR1((" vUpdatePairableMode: PairingInProgress prev - %d cur - %d",
            bPairingInProgress, _oFIDataPairableMode.PairingInProgress));

      if(bPairingInProgress != _oFIDataPairableMode.PairingInProgress)
      {
         if(_oFIDataPairableMode.PairingInProgress == TRUE)
         {
            _bdAAPAddress = remoteBdAddress;
         }
         else
         {
            _bdAAPAddress = "";
         }
         bUpdateClients = true;
      }
   }

   _oFIDataPairableMode.sBTAddress.bSet(_bdAAPAddress.c_str());

   if(bUpdateClients)
   {
      updateClients(MOST_BTSETFI_C_U16_PAIRABLEMODE);
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::vGetPairingState(PairingState &state)
{
   ENTRY_INTERNAL

   state = _pairingState;

   ETG_TRACE_USR1((" vGetPairingState ::state : %d", state));

   return;
}


tBool FC_Bluetooth_tclCCAService::handleSppServiceConnectionGet(amt_tclServiceData& roOutMsg)
{
   ENTRY

   tBool bRet = false;

   ETG_TRACE_USR1((" handleSppServiceConnectionGet : size - %d", _oFIDataSPPServiceConnection.oSPPServiceConnectionStatusList.oItems.size()));

   bRet = fi_tclVisitorMessage(_oFIDataSPPServiceConnection, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);

   return bRet;
}

tVoid FC_Bluetooth_tclCCAService::vUpdateSppServiceConnection(const DeviceConnectionStatusList& deviceConnectionStatusList)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1((" vUpdateSppServiceConnection : entered"));

   ProtocolConnectionInfo protocolconnectioninfo;
   Uuid uuid;

   if(bCheckSppServiceConnection(deviceConnectionStatusList) == true)
   {
      _oFIDataSPPServiceConnection.oSPPServiceConnectionStatusList.oItems.clear();

      for (std::vector<DeviceConnectionInfo>::const_iterator it = deviceConnectionStatusList._deviceConnectionInfoList.begin();
            it != deviceConnectionStatusList._deviceConnectionInfoList.end(); it++)
      {
         for (SppConnectionInfoMap::const_iterator ItSppConInfoMap = it->_sppConnectionInfo.begin();
               ItSppConInfoMap != it->_sppConnectionInfo.end(); ItSppConInfoMap++)
         {
            uuid = ItSppConInfoMap->first;
            protocolconnectioninfo = ItSppConInfoMap->second;

            most_fi_tcl_BTSPPServiceConnectionStatusListItem oBTSetConnectionStatusListItem;

            _oFIDataSPPServiceConnection.oSPPServiceConnectionStatusList.oItems.push_back(oBTSetConnectionStatusListItem);

            most_fi_tcl_BTSPPServiceConnectionStatusListItem& oSppConnectionStatusItem = _oFIDataSPPServiceConnection.oSPPServiceConnectionStatusList.oItems.back();

            oSppConnectionStatusItem.u8DeviceHandle = (tU8)it->_deviceHandle;

            oSppConnectionStatusItem.sUUID.bSet(uuid.c_str());

            MapConnectionStatusTypeToMOST(oSppConnectionStatusItem.e8SPPConnectionStatus, protocolconnectioninfo._connectionStatus);

            MapSppDisconnectionReasonToMOST(oSppConnectionStatusItem.e8SPPDisconnectionReason, protocolconnectioninfo._disconnectedReason);

            oSppConnectionStatusItem.sRFCommID.bSet(protocolconnectioninfo._rfcommDevicePath.c_str());

            ETG_TRACE_USR1((" vUpdateSppServiceConnection ::oSppConnectionStatusItem.DeviceHandle : %d", oSppConnectionStatusItem.u8DeviceHandle));

            ETG_TRACE_USR1((" vUpdateSppServiceConnection ::oSppConnectionStatusItem.e8DeviceStatus : %d", oSppConnectionStatusItem.e8SPPConnectionStatus.enType));

            ETG_TRACE_USR1((" vUpdateSppServiceConnection ::oSppConnectionStatusItem.e8DeviceDisconnectedReason : %d", oSppConnectionStatusItem.e8SPPDisconnectionReason.enType));

            ETG_TRACE_USR1((" vUpdateSppServiceConnection ::oSppConnectionStatusItem.suuid : %s", uuid.c_str()));

            ETG_TRACE_USR1((" vUpdateSppServiceConnection ::oSppConnectionStatusItem.sRFCommID : %s", protocolconnectioninfo._rfcommDevicePath.c_str()));
         }
      }

      updateClients(MOST_BTSETFI_C_U16_SPPSERVICECONNECTION);
   }
   else
   {
      ETG_TRACE_USR1((" vUpdateSppServiceConnection :: No Update to Client since same received from BMCore"));
   }

   return;
}

tBool FC_Bluetooth_tclCCAService::bCheckSppServiceConnection(const DeviceConnectionStatusList& deviceConnectionStatusList)
{
   ProtocolConnectionInfo oldProtocolconnectioninfo, curProtocolconnectioninfo;
   SppConnectionInfoMap::const_iterator ItOldSppConInfoMap, ItCurSppConInfoMap;
   Uuid oldUuid, curUuid;
   tBool bUpdate = false;
   DeviceConnectionInfoList::const_iterator connListIt;

   ETG_TRACE_USR4((" bCheckSppServiceConnection : entered"));

   if(_deviceConnectionStatusList._deviceConnectionInfoList.size() == deviceConnectionStatusList._deviceConnectionInfoList.size())
   {
      for (std::vector<DeviceConnectionInfo>::const_iterator it = deviceConnectionStatusList._deviceConnectionInfoList.begin();
            it != deviceConnectionStatusList._deviceConnectionInfoList.end(); it++)
      {
         connListIt = std::find_if(_deviceConnectionStatusList._deviceConnectionInfoList.begin(),
               _deviceConnectionStatusList._deviceConnectionInfoList.end(),
               MeetsDeviceHandle<DeviceConnectionInfo>(it->_deviceHandle));

         if (connListIt != _deviceConnectionStatusList._deviceConnectionInfoList.end())
         {
            if(connListIt->_sppConnectionInfo.size() == it->_sppConnectionInfo.size())
            {
               for (ItCurSppConInfoMap = it->_sppConnectionInfo.begin();
                     ItCurSppConInfoMap != it->_sppConnectionInfo.end(); ItCurSppConInfoMap++)
               {
                  curUuid = ItCurSppConInfoMap->first;
                  curProtocolconnectioninfo = ItCurSppConInfoMap->second;

                  for (ItOldSppConInfoMap = connListIt->_sppConnectionInfo.begin();
                        ItOldSppConInfoMap != connListIt->_sppConnectionInfo.end(); ItOldSppConInfoMap++)
                  {
                     oldUuid = ItOldSppConInfoMap->first;
                     oldProtocolconnectioninfo = ItOldSppConInfoMap->second;

                     if(s32StringCompare(curUuid.c_str(), oldUuid.c_str()) == FC_BLUETOOTH_CCASERVICE_ZERO)
                     {
                        if(oldProtocolconnectioninfo._connectionStatus != curProtocolconnectioninfo._connectionStatus)
                        {
                           ETG_TRACE_USR4((" bCheckSppServiceConnection : _connectionStatus changed - %d",
                                 curProtocolconnectioninfo._connectionStatus));

                           bUpdate = true;
                        }
                        else if(s32StringCompare(oldProtocolconnectioninfo._rfcommDevicePath.c_str(),
                              curProtocolconnectioninfo._rfcommDevicePath.c_str()) != FC_BLUETOOTH_CCASERVICE_ZERO)
                        {
                           ETG_TRACE_USR4((" bCheckSppServiceConnection : _rfcommDevicePath changed"));
                           bUpdate = true;
                        }
                        else if(oldProtocolconnectioninfo._disconnectedReason != curProtocolconnectioninfo._disconnectedReason)
                        {
                           ETG_TRACE_USR4((" bCheckSppServiceConnection : _disconnectedReason changed"));
                           bUpdate = true;
                        }
                        else
                        {
                           ETG_TRACE_USR4((" bCheckSppServiceConnection: same"));
                        }
                        break;
                     }
                  }

                  if(bUpdate == true)
                     break;
               }
            }
            else
            {
               bUpdate = true;
            }
         }

         if(bUpdate == true)
            break;
      }
   }
   else if(_deviceConnectionStatusList._deviceConnectionInfoList.size() < deviceConnectionStatusList._deviceConnectionInfoList.size())
   {
      for (std::vector<DeviceConnectionInfo>::const_iterator it = deviceConnectionStatusList._deviceConnectionInfoList.begin();
            it != deviceConnectionStatusList._deviceConnectionInfoList.end(); it++)
      {
         if (_deviceConnectionStatusList._deviceConnectionInfoList.size() != FC_BLUETOOTH_CCASERVICE_ZERO)
         {
            ETG_TRACE_USR4(("bCheckSppServiceConnection: else if - devicehandle: %d", it->_deviceHandle));

            connListIt = std::find_if(_deviceConnectionStatusList._deviceConnectionInfoList.begin(),
                  _deviceConnectionStatusList._deviceConnectionInfoList.end(),
                  MeetsDeviceHandle<DeviceConnectionInfo>(it->_deviceHandle));

            if (connListIt == _deviceConnectionStatusList._deviceConnectionInfoList.end())
            {
               if(it->_sppConnectionInfo.size() > FC_BLUETOOTH_CCASERVICE_ZERO)
               {
                  bUpdate = true;
               }
               break;
            }
         }
         else
         {
            ETG_TRACE_USR4((" bCheckSppServiceConnection - else if: size -%d ", it->_sppConnectionInfo.size()));
            if(it->_sppConnectionInfo.size() > FC_BLUETOOTH_CCASERVICE_ZERO)
            {
               bUpdate = true;
            }
            break;
         }
      }
   }
   else
   {
      for (std::vector<DeviceConnectionInfo>::const_iterator it = _deviceConnectionStatusList._deviceConnectionInfoList.begin();
            it != _deviceConnectionStatusList._deviceConnectionInfoList.end(); it++)
      {
         connListIt = std::find_if(deviceConnectionStatusList._deviceConnectionInfoList.begin(),
               deviceConnectionStatusList._deviceConnectionInfoList.end(),
               MeetsDeviceHandle<DeviceConnectionInfo>(it->_deviceHandle));

         if (connListIt == deviceConnectionStatusList._deviceConnectionInfoList.end())
         {
            ETG_TRACE_USR4(("bCheckSppServiceConnection:else - size : %d", it->_sppConnectionInfo.size()));

            if(it->_sppConnectionInfo.size() > FC_BLUETOOTH_CCASERVICE_ZERO)
            {
               bUpdate = true;
            }
            break;
         }
      }
   }

   return bUpdate;
}

tBool FC_Bluetooth_tclCCAService::handleBTLimitationModeGet(amt_tclServiceData& roOutMsg)
{
   ENTRY

   tBool bRet = false;

   bRet = fi_tclVisitorMessage(_oFIDataBTLimitationMode, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);

   return bRet;
}

tVoid FC_Bluetooth_tclCCAService::vUpdateBtLimitationMode(const BtLimitationMode& btLimitationMode)
{
   ENTRY_INTERNAL
   
   ETG_TRACE_USR1(("vUpdateBtLimitationMode :: entered"));

   tBool bUpdate = false;

   if(FC_BLUETOOTH_CCASERVICE_ZERO == btLimitationMode._btLimitationModeInfoList.size())
   {
      _oFIDataBTLimitationMode.oList.oItems.clear();
      bUpdate = true;
   }

   for (std::vector<BtLimitationModeInfo>::const_iterator it = btLimitationMode._btLimitationModeInfoList.begin();
         it != btLimitationMode._btLimitationModeInfoList.end(); it++)
   {
      if((it->_limitationMode._limitationFeature != BM_LIMITATION_FEATURE_LAST) && (it->_limitationMode._limitationCommunicationIf != BM_LIMITATION_COMMUNICATION_IF_LAST))
      {
         if(false == bUpdate)
         {
            _oFIDataBTLimitationMode.oList.oItems.clear();
            bUpdate = true;
         }

         most_fi_tcl_BTLimitationModeListItem oBTLimitationModeListItem;

         _oFIDataBTLimitationMode.oList.oItems.push_back(oBTLimitationModeListItem);

         most_fi_tcl_BTLimitationModeListItem& oBTLimitationModeStatusItem = _oFIDataBTLimitationMode.oList.oItems.back();

         oBTLimitationModeStatusItem.sBdAddress.bSet(it->_bdAddress.c_str());

         oBTLimitationModeStatusItem.sBdDeviceName.bSet(it->_bdName.c_str());

         MapLimitationFeatureToMost(oBTLimitationModeStatusItem.e8Technology, it->_limitationMode._limitationFeature);

         MapLimitationCommunicationIfToMost(oBTLimitationModeStatusItem.e8CommunicationChannel, it->_limitationMode._limitationCommunicationIf);

         MapLimitationActionStateToMost(oBTLimitationModeStatusItem.e8ActionState, it->_limitationState);

         ETG_TRACE_USR4((" vUpdateBtLimitationMode ::oBTLimitationModeStatusItem.sBdAdress : %s", it->_bdAddress.c_str()));

         ETG_TRACE_USR4((" vUpdateBtLimitationMode ::oBTLimitationModeStatusItem.sBdDeviceName : %s", it->_bdName.c_str()));

         ETG_TRACE_USR4((" vUpdateBtLimitationMode ::oBTLimitationModeStatusItem.e8Technology : %d", oBTLimitationModeStatusItem.e8Technology.enType));

         ETG_TRACE_USR4((" vUpdateBtLimitationMode ::oBTLimitationModeStatusItem.e8CommunicationChannel : %d", oBTLimitationModeStatusItem.e8CommunicationChannel.enType));

         ETG_TRACE_USR4((" vUpdateBtLimitationMode ::oBTLimitationModeStatusItem.e8ActionState : %d", oBTLimitationModeStatusItem.e8ActionState.enType));
      }
   }

   if(true == bUpdate)
      updateClients(MOST_BTSETFI_C_U16_BLUETOOTHLIMITATIONMODE);

   return;
}

tBool FC_Bluetooth_tclCCAService::handleMultiHFPSupportGet(amt_tclServiceData& roOutMsg)
{
   ENTRY

   tBool bRet = false;

   bRet = fi_tclVisitorMessage(_oFIDataMultiHFPSupport, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);

   return bRet;
}

tVoid FC_Bluetooth_tclCCAService::vUpdateMultiHFPSupportStatus(SwitchState switchState)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("vUpdateMultiHFPSupportStatus :: entered"));

   MapMultiHFPSupportStatusToMOST(_oFIDataMultiHFPSupport.e8MultiHFPSupport, switchState);

   updateClients(MOST_BTSETFI_C_U16_MULTIHFPSUPPORT);

   return;
}

tBool FC_Bluetooth_tclCCAService::handleBtProfilesUsageInfoGet(amt_tclServiceData& roOutMsg)
{
   ENTRY

   tBool bRet = false;

   bRet = fi_tclVisitorMessage(_oFIDataBTProfilesUsageInfo, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);

   return bRet;
}

tVoid FC_Bluetooth_tclCCAService::vUpdateProfileUsageList(const ProfileUsageList& profileUsageList)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("vUpdateProfileUsageList :: entered"));

   _oFIDataBTProfilesUsageInfo.oBTProfilesUsageInfoList.oItems.clear();

   for (std::list<ProfileUsageInfo>::const_iterator it = profileUsageList._btProfileUsageInfoList.begin();
         it != profileUsageList._btProfileUsageInfoList.end(); it++)
   {
      most_fi_tcl_BTProfilesUsageInfoList oBTProfilesUsageInfoListItem;

      _oFIDataBTProfilesUsageInfo.oBTProfilesUsageInfoList.oItems.push_back(oBTProfilesUsageInfoListItem);

      most_fi_tcl_BTProfilesUsageInfoList& oBTProfilesUsageInfoListStatusItem = _oFIDataBTProfilesUsageInfo.oBTProfilesUsageInfoList.oItems.back();

      oBTProfilesUsageInfoListStatusItem.u8DeviceHandle = (tU8)it->_deviceHandle;

      MapBtProfilesToMost(oBTProfilesUsageInfoListStatusItem.oBTProfilesUsageInfo.e8BTProfile, it->_protocol._protocolId);

      oBTProfilesUsageInfoListStatusItem.oBTProfilesUsageInfo.sUUID.bSet(it->_protocol._uuid.c_str());

      MapBTProfileUsageTypeToMost(oBTProfilesUsageInfoListStatusItem.oBTProfilesUsageInfo.e8BTProfileUsageType, it->_ProfileUsageType);

      oBTProfilesUsageInfoListStatusItem.oBTProfilesUsageInfo.bInUse = it->_InUse;

      ETG_TRACE_USR1((" vUpdateProfileUsageList :: u8DeviceHandle : %d", oBTProfilesUsageInfoListStatusItem.u8DeviceHandle));

      ETG_TRACE_USR1((" vUpdateProfileUsageList :: oBTProfilesUsageInfo.e8BTProfile : %d", oBTProfilesUsageInfoListStatusItem.oBTProfilesUsageInfo.e8BTProfile.enType));

      ETG_TRACE_USR1((" vUpdateProfileUsageList :: oBTProfilesUsageInfo.sUUID : %s", oBTProfilesUsageInfoListStatusItem.oBTProfilesUsageInfo.sUUID.szValue));

      ETG_TRACE_USR1((" vUpdateProfileUsageList :: oBTProfilesUsageInfo.e8BTProfileUsageType : %d",oBTProfilesUsageInfoListStatusItem.oBTProfilesUsageInfo.e8BTProfileUsageType.enType));

      ETG_TRACE_USR1((" vUpdateProfileUsageList :: oBTProfilesUsageInfo.bInUse : %d", oBTProfilesUsageInfoListStatusItem.oBTProfilesUsageInfo.bInUse));
   }

   updateClients(MOST_BTSETFI_C_U16_BTPROFILESUSAGEINFO);

   return;
}

tBool FC_Bluetooth_tclCCAService::handleConflictDetectedGet(amt_tclServiceData& roOutMsg)
{
   ENTRY

   tBool bRet = false;

   ETG_TRACE_USR1(("handleConflictDetectedGet :: entered"));

   bRet = fi_tclVisitorMessage(_oFIDataConflictsDetected, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);

   return bRet;
}

tVoid FC_Bluetooth_tclCCAService::vUpdateIssueInfoList(const IssueInfoList& issueInfoList)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("vUpdateProfileUsageList :: entered"));

   MapConflictTriggerToMost(_oFIDataConflictsDetected.e8ConflictTrigger, issueInfoList._conflictTrigger);

   _oFIDataConflictsDetected.oBTConflictInfoList.oItems.clear();

   for (std::vector<IssueInfo>::const_iterator it = issueInfoList._conflictInfoList.begin();
         it != issueInfoList._conflictInfoList.end(); it++)
   {
      most_fi_tcl_BTConflictInfo oBTConflictInfoListItem;

      _oFIDataConflictsDetected.oBTConflictInfoList.oItems.push_back(oBTConflictInfoListItem);

      most_fi_tcl_BTConflictInfo& oBTConflictInfoListStatusItem = _oFIDataConflictsDetected.oBTConflictInfoList.oItems.back();

      oBTConflictInfoListStatusItem.u8DeviceHandle = (tU8)it->_deviceID;

      MapBtProfilesToMost(oBTConflictInfoListStatusItem.e8BTProfile, it->_protocol._protocolId);

      oBTConflictInfoListStatusItem.sUUID.bSet(it->_protocol._uuid.c_str());

      MapConflictTypeToMost(oBTConflictInfoListStatusItem.e8ConflictType, it->_conflictType);

      MapBTProfileUsageTypeToMost(oBTConflictInfoListStatusItem.e8BTProfileUsageType, it->_profileUsageType);

      MapConflictStateToMost(oBTConflictInfoListStatusItem.e8ConflictState, it->_conflictState);

      ETG_TRACE_USR1((" vUpdateIssueInfoList :: u8DeviceHandle : %d", oBTConflictInfoListStatusItem.u8DeviceHandle));

      ETG_TRACE_USR1((" vUpdateIssueInfoList :: oBTConflictInfoListStatusItem.e8BTProfile : %d", oBTConflictInfoListStatusItem.e8BTProfile.enType));

      ETG_TRACE_USR1((" vUpdateIssueInfoList :: oBTConflictInfoListStatusItem.sUUID : %s", oBTConflictInfoListStatusItem.sUUID.szValue));

      ETG_TRACE_USR1((" vUpdateIssueInfoList :: oBTConflictInfoListStatusItem.e8BTProfileUsageType : %d", oBTConflictInfoListStatusItem.e8BTProfileUsageType.enType));

      ETG_TRACE_USR1((" vUpdateIssueInfoList :: oBTConflictInfoListStatusItem.e8ConflictType : %d", oBTConflictInfoListStatusItem.e8ConflictType.enType));

      ETG_TRACE_USR1((" vUpdateIssueInfoList :: oBTConflictInfoListStatusItem.e8ConflictState : %d", oBTConflictInfoListStatusItem.e8ConflictState.enType));
   }

   updateClients(MOST_BTSETFI_C_U16_CONFLICTSDETECTED);

   return;
}

tBool FC_Bluetooth_tclCCAService::handleAutoConnectionStatusGet(amt_tclServiceData& roOutMsg)
{
   ENTRY

   tBool bRet = false;

   ETG_TRACE_USR1(("handleAutoConnectionStatusGet :: entered"));

   bRet = fi_tclVisitorMessage(_oFIDataAutoConnectionStatus, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);

   return bRet;
}

tVoid FC_Bluetooth_tclCCAService::vUpdateAutoConnectionStatus(const AutoConnectionStatus& autoConnectionStatus)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("vUpdateAutoConnectionStatus :: entered"));

   MapAutoConnectionStatusToMOST(_oFIDataAutoConnectionStatus.e8AutoConnectionStatus, autoConnectionStatus._autoConnectionState);

   _oFIDataAutoConnectionStatus.u8DeviceHandle = (tU8)autoConnectionStatus._deviceIdInProgress;

   ETG_TRACE_USR1(("vUpdateAutoConnectionStatus :: e8AutoConnectionStatus - %d u8DeviceHandle - %d",
         _oFIDataAutoConnectionStatus.e8AutoConnectionStatus.enType, _oFIDataAutoConnectionStatus.u8DeviceHandle));

   updateClients(MOST_BTSETFI_C_U16_AUTOCONNECTIONSTATUS);

   return;
}

tVoid FC_Bluetooth_tclCCAService::vUpdateBmServiceAvailability(const BmServiceAvailability& bmServiceAvailability)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("vUpdateBmServiceAvailability :: entered"));

   MapServiceAvailabilityToMOST(_oFIDataServiceAvailableStatus.e8ServiceAvailable, bmServiceAvailability._serviceAvailability);

   ETG_TRACE_USR1(("vUpdateBmServiceAvailability :: ServiceAvailability - %d",
         _oFIDataServiceAvailableStatus.e8ServiceAvailable.enType));

   updateClients(MOST_BTSETFI_C_U16_SERVICEAVAILABLE);

   return;
}

tBool FC_Bluetooth_tclCCAService::handleServiceAvailableGet(amt_tclServiceData& roOutMsg)
{
   ENTRY

   tBool bRet = false;

   ETG_TRACE_USR1(("handleServiceAvailableGet :: entered"));

   bRet = fi_tclVisitorMessage(_oFIDataServiceAvailableStatus, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
   return bRet;
}
tVoid FC_Bluetooth_tclCCAService::vUpdateVehicleConfiguration(const LocalInfo& localInfo)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("vUpdateVehicleConfiguration :: entered"));

   ETG_TRACE_USR2((" vUpdateVehicleConfiguration : VehicleBTAddress - %s",  localInfo._bdAddress.c_str()));

   ETG_TRACE_USR2((" vUpdateVehicleConfiguration : VehicleBTName - %s",  localInfo._bdName.c_str()));

   _oFIDataVehicleConfiguration.sVehicleBTAddress.bSet(localInfo._bdAddress.c_str(),
         most_fi_tcl_String::FI_EN_UTF8);

   _oFIDataVehicleConfiguration.sVehicleBTFriendlyName.bSet(localInfo._bdName.c_str(),
         most_fi_tcl_String::FI_EN_UTF8);

   MapSupportedProfilesStatusToMOST(_oFIDataVehicleConfiguration.oVehicleSupportedProfiles, localInfo._protocolInfos);

   MapDeviceIdentificationToMOST(_oFIDataVehicleConfiguration.oVehicleIdentification, localInfo._vehicleIdentification);

   updateClients(MOST_BTSETFI_C_U16_VEHICLECONFIGURATION);

   return;
}

tBool FC_Bluetooth_tclCCAService::handleVehicleConfigurationGet(amt_tclServiceData& roOutMsg)
{
   ENTRY

   tBool bRet = false;

   ETG_TRACE_USR1(("handleVehicleConfigurationGet :: entered"));

   bRet = fi_tclVisitorMessage(_oFIDataVehicleConfiguration, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);

   return bRet;
}

/*******************************************************************************
 *
 * bProcessSet()
 *
 *******************************************************************************/
tBool FC_Bluetooth_tclCCAService::bProcessSet(amt_tclServiceData* poMessage, tBool& bPropertyChanged, tU16& u16ErrorCode)
{
   ENTRY

   tBool bSuccess = FALSE;

   BmResult result = BM_RESULT_ERR_GENERAL;

   tU16 u16FunctionId = poMessage->u16GetFunctionID();

   switch (u16FunctionId)
   {
      case MOST_BTSETFI_C_U16_BLUETOOTHONOFF:
      {
         fi_tclVisitorMessage oVisitorMsg(poMessage);

         most_btsetfi_tclMsgBluetoothOnOffSet bluetoothOnOffSet;

         if (oVisitorMsg.s32GetData(bluetoothOnOffSet, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION)
               != OSAL_ERROR)
         {
            ETG_TRACE_USR4(("SET: BLUETOOTH ON/OFF: %d",bluetoothOnOffSet.bBTOnOff));

            TargetSwitchState targetSwitchState;

            MapBluetoothOnOffToInternal(targetSwitchState, bluetoothOnOffSet.bBTOnOff);

            if(_bluetoothApp)
            {
               result = _bluetoothApp->getBmCoreRequestIf().switchBtStatus(targetSwitchState);

               if (BM_RESULT_OK != result)
               {
                  ETG_TRACE_ERR(("MOST_BTSETFI_C_U16_BLUETOOTHONOFF:: result - %d", result));
               }
            }
            else
            {
               ETG_TRACE_ERR(("MOST_BTSETFI_C_U16_BLUETOOTHONOFF: _bluetoothApp is NULL"));
            }
         }
         else
         {
            ETG_TRACE_ERR(("MOST_BTSETFI_C_U16_BLUETOOTHONOFF::OSAL Error encountered"));
            u16ErrorCode = CCA_C_U16_ERROR_VERSION_NOT_SUPPORTED;
         }

         bluetoothOnOffSet.vDestroy();
      }
      break;
      case MOST_BTSETFI_C_U16_BLUETOOTHAUDIOSOURCE:
      {
        fi_tclVisitorMessage oVisitorMsg(poMessage);

        most_btsetfi_tclMsgBluetoothAudioSourcePureSet bluetoothAudioSourcePureSet;

        if (oVisitorMsg.s32GetData(bluetoothAudioSourcePureSet, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION) != OSAL_ERROR)
        {
           ETG_TRACE_ERR(("MOST_BTSETFI_C_U16_BLUETOOTHAUDIOSOURCE:: Not used in IVI"));
        }
        else
        {
           ETG_TRACE_ERR(("MOST_BTSETFI_C_U16_BLUETOOTHAUDIOSOURCE::OSAL Error encountered"));
           u16ErrorCode = CCA_C_U16_ERROR_VERSION_NOT_SUPPORTED;
        }

        bluetoothAudioSourcePureSet.vDestroy();
      }
      break;

      case MOST_BTSETFI_C_U16_AUTOCONNECTONOFF:
      {
         fi_tclVisitorMessage oVisitorMsg(poMessage);

         most_btsetfi_tclMsgAutoConnectOnOffSet autoConnectOnOffSet;

         if (oVisitorMsg.s32GetData(autoConnectOnOffSet, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION)
               != OSAL_ERROR)
         {
            ETG_TRACE_USR4(("SET: AUTOCONNECT ON/OFF: %d",autoConnectOnOffSet.bAutoConnectOnOff));

            AutoConnectionType autoConnectionType;

            MapAutoConnectOnOffToInternal(autoConnectionType, autoConnectOnOffSet.bAutoConnectOnOff);

            if(_bluetoothApp)
            {
               result = _bluetoothApp->getBmCoreRequestIf().setAutoConnectionType(autoConnectionType);

               if (BM_RESULT_OK != result)
               {
                  ETG_TRACE_ERR(("MOST_BTSETFI_C_U16_AUTOCONNECTONOFF:: result - %d", result));
               }
            }
            else
            {
               ETG_TRACE_ERR(("MOST_BTSETFI_C_U16_AUTOCONNECTONOFF: _bluetoothApp is NULL"));
            }
         }
         else
         {
            ETG_TRACE_ERR(("MOST_BTSETFI_C_U16_AUTOCONNECTONOFF::OSAL Error encountered"));

            u16ErrorCode = CCA_C_U16_ERROR_VERSION_NOT_SUPPORTED;
         }
      }
      break;

      case MOST_BTSETFI_C_U16_VEHICLEBTFRIENDLYNAMESET:
      {
         fi_tclVisitorMessage oVisitorMsg(poMessage);

         most_btsetfi_tclMsgVehicleBTFriendlyNamesetSet oFIDataObject;

         if (oVisitorMsg.s32GetData(oFIDataObject, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION)
               != OSAL_ERROR)
         {
            ETG_TRACE_USR1(("SET: VEHICLE BT FRIENDLY NAME: %s",\
                  oFIDataObject.sVehicleBTFriendlyName.szValue));

            std::string localFriendlyName = oFIDataObject.sVehicleBTFriendlyName.szValue;

            LocalFriendlyName btLocalFriendlyName(localFriendlyName);

            if(_bluetoothApp)
            {
               result = _bluetoothApp->getBmCoreRequestIf().setBtLocalFriendlyName(btLocalFriendlyName);

               if (BM_RESULT_OK != result)
               {
                  ETG_TRACE_ERR(("MOST_BTSETFI_C_U16_VEHICLEBTFRIENDLYNAMESET::result - %d", result));
               }
            }
            else
            {
               ETG_TRACE_ERR(("MOST_BTSETFI_C_U16_VEHICLEBTFRIENDLYNAMESET: _bluetoothApp is NULL"));
            }
         }
         else
         {
            ETG_TRACE_ERR(("MOST_BTSETFI_C_U16_VEHICLEBTFRIENDLYNAMESET::OSAL Error encountered"));

            u16ErrorCode = CCA_C_U16_ERROR_VERSION_NOT_SUPPORTED;
         }
      }
      break;

      case MOST_BTSETFI_C_U16_CHANGERINGTONE:
      {
         fi_tclVisitorMessage oVisitorMsg(poMessage);
         most_btsetfi_tclMsgChangeRingtonePureSet oFIDataObject;

         if (oVisitorMsg.s32GetData(oFIDataObject, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION)
               != OSAL_ERROR)
         {
            tU8 u8DeviceHandle = oFIDataObject.u8DeviceHandle;
            tU16 u16RingToneID = oFIDataObject.u16RingtoneID;

            ETG_TRACE_USR2(("ChangeRingtone(Devicehandle %d, RingToneId %d)", u8DeviceHandle, u16RingToneID));

            if (u16RingToneID == FC_BLUETOOTH_CCASERVICE_ZERO) //invalid ringtone
            {
               u16RingToneID = DEFAULT_RINGTONE_ID;
               ETG_TRACE_USR2(("ChangeRingtone: invalid ringtone ID, set default ringtone ID %d", u16RingToneID));
            }

            _u8SystemWideDeviceHandle = u8DeviceHandle;

            RingtoneId ringtoneId = u16RingToneID;

            if(_bluetoothApp)
            {
               if(true == _bmCoreConfiguration._systemWideRingtoneEnabled)
               {
                  result = _bluetoothApp->getBmCoreRequestIf().storeSystemWideRingtoneIdInDb(ringtoneId);
               }
               else
               {
                  result = _bluetoothApp->getBmCoreRequestIf().storeDeviceRingtoneIdInDb(_u8SystemWideDeviceHandle, ringtoneId);
               }

               if (BM_RESULT_OK == result)
               {
                  _u16SystemWideRingtone = u16RingToneID;
                  ETG_TRACE_USR4(("ChangeRingtone: _u16SystemWideRingtone = %d",_u16SystemWideRingtone));

                  std::string sRingtoneName = "";
                  oAvailableRingtoneList.vGetRingtoneName((tU16)(_u16SystemWideRingtone - 1), sRingtoneName);
                  updateChangeRingtoneStatus(_u8SystemWideDeviceHandle, _u16SystemWideRingtone, sRingtoneName, false);
               }
               else
               {
                  ETG_TRACE_ERR(("ChangeRingtone::store RingtoneIdInDb is failed"));
               }
            }
            else
            {
               ETG_TRACE_ERR(("MOST_BTSETFI_C_U16_CHANGERINGTONE: _bluetoothApp is NULL"));
            }
         }
         else
         {
            u16ErrorCode = CCA_C_U16_ERROR_VERSION_NOT_SUPPORTED;
         }
         oFIDataObject.vDestroy();
      }
      break;
      default:
         ETG_TRACE_ERR(("bProcessSet(). Invalid 'FID = %u'.", u16FunctionId));
      break;
   }

   if (BM_RESULT_OK == result)
   {
      bPropertyChanged = true;
      bSuccess = TRUE;
   }
   else
   {
      ETG_TRACE_ERR(("bProcessSet(). Setting of property with 'FID = %u' failed.", u16FunctionId));
   }

   return bSuccess;
}

/*******************************************************************************
 *
 * MethodStart Functions
 *
 *******************************************************************************/
tVoid FC_Bluetooth_tclCCAService::onSwitchBluetoothOnOffExtendedMethodStart(amt_tclServiceData* poMessage)
{
   ENTRY

   Job switchBTOnOffExtended;
   most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodStart oFiDataObjectMethodStart;

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   if (oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
      switchBTOnOffExtended.u16CmdCounter = poMessage->u16GetCmdCounter();
      switchBTOnOffExtended.u16FunctionID = poMessage->u16GetFunctionID();
      switchBTOnOffExtended.u16RegisterID = poMessage->u16GetRegisterID();
      switchBTOnOffExtended.u16SourceAppID = poMessage->u16GetSourceAppID();
      switchBTOnOffExtended.poMethodArg = OSAL_NULL;
      switchBTOnOffExtended.bResponse = false;

      if ((FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContextListSize(switchBTOnOffExtended.u16FunctionID))
            < FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE)
      {
         ETG_TRACE_USR1(("onSwitchBluetoothOnOffExtendedMethodStart::bBTOnOff requested - %d bSuppressAutoConnection - %d",
               oFiDataObjectMethodStart.bBTOnOff, oFiDataObjectMethodStart.bSuppressAutoConnection));

         most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodStart *temp = OSAL_NEW most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodStart;

         if(temp)
         {
            temp->bBTOnOff = oFiDataObjectMethodStart.bBTOnOff;
            temp->bSuppressAutoConnection = oFiDataObjectMethodStart.bSuppressAutoConnection;

            switchBTOnOffExtended.poMethodArg =
                  (most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodStart *) temp;

            TargetSwitchState targetSwitchState;

            MapBluetoothOnOffToInternal(targetSwitchState, oFiDataObjectMethodStart.bBTOnOff);

            if(_bluetoothApp)
            {
               bool delayBtOnRequest = false;
               checkForCreateOrDeleteBtStateOffFile(temp->bBTOnOff, delayBtOnRequest);

               FC_Bluetooth_CCAMethodQueue::poGetInstance()->PushMethodContext(switchBTOnOffExtended.u16FunctionID, switchBTOnOffExtended);

               _bluetoothApp->getBmCoreRequestIf().switchBtStatus(targetSwitchState, oFiDataObjectMethodStart.bSuppressAutoConnection, delayBtOnRequest);
            }
         }
         else
         {
            ETG_TRACE_ERR(("onSwitchBluetoothOnOffExtendedMethodStart:  temp is Null"));
            sendMethodError(switchBTOnOffExtended.u16FunctionID, switchBTOnOffExtended,
                  most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
         }
      }
      else
      {
         ETG_TRACE_ERR(("onSwitchBluetoothOnOffExtendedMethodStart:  Queue size is more than %d",
               FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE));
         sendMethodError(switchBTOnOffExtended.u16FunctionID, switchBTOnOffExtended,
               most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
      }
   }
   else
   {
      ETG_TRACE_ERR(("onSwitchBluetoothOnOffExtendedMethodStart: OSAL GetData() failed"));
      vPostError(oVisitorMsg);
   }

   oFiDataObjectMethodStart.vDestroy();
   return;
}

tVoid FC_Bluetooth_tclCCAService::checkForCreateOrDeleteBtStateOffFile(bool bBTOnOff, bool& delayBtOnRequest)
{
   delayBtOnRequest = false;

   // check bt only reset file is exist
   if(true == bCheckBtOnlyResetFileIsExist())
   {
      ETG_TRACE_USR4(("checkForCreateOrDeleteBtStateOffFile:: BTOnOff = %d", bBTOnOff));

      if(true == bBTOnOff)
      {
         // deletes the bt_state_off file if exist.
         if(true == bCheckBtStateOffFileIsExist())
         {
            CmdData btstateOffResult = execRootCommand(FC_BT_ROOTDAEMON_CLIENT_NAME, BT_STATE_OFF, "delete");

            if (btstateOffResult.errorNo == ERR_NONE)
            {
               ETG_TRACE_USR4(("checkForCreateOrDeleteBtStateOffFile:: File is deleted successfully"));
            }
            else
            {
               ETG_TRACE_USR4(("checkForCreateOrDeleteBtStateOffFile:: File is not able to delete"));
            }
         }

         // restarts the evoultion stack if not running
         if(false == bCheckStackIsRunning())
         {
            CmdData btStartResult = execRootCommand(FC_BT_ROOTDAEMON_CLIENT_NAME, EVOLUTION_STACK, "start");

            if (btStartResult.errorNo == ERR_NONE)
            {
               ETG_TRACE_USR4(("checkForCreateOrDeleteBtStateOffFile:: Evolution stack is started successfully"));
               delayBtOnRequest = true;
            }
            else
            {
               ETG_TRACE_USR4(("checkForCreateOrDeleteBtStateOffFile:: Evolution stack is not able to start"));
            }
         }
      }
      else
      {
         // creates the bt_state_off file if not exist.
         if(false == bCheckBtStateOffFileIsExist())
         {
            CmdData btstateOffResult = execRootCommand(FC_BT_ROOTDAEMON_CLIENT_NAME, BT_STATE_OFF, "create");

            if (btstateOffResult.errorNo == ERR_NONE)
            {
               ETG_TRACE_USR4(("checkForCreateOrDeleteBtStateOffFile:: File is created successfully"));
            }
            else
            {
               ETG_TRACE_USR4(("checkForCreateOrDeleteBtStateOffFile:: File is not able to create"));
            }
         }
      }
   }
   else
   {
      ETG_TRACE_USR4(("checkForCreateOrDeleteBtStateOffFile:: Project is not supported"));
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::onScanBluetoothDevicesMethodStart(amt_tclServiceData* poMessage)
{
   ENTRY

   Job scanBluetoothDevices;
   most_btsetfi_tclMsgScanBluetoothDevicesMethodStart oFiDataObjectMethodStart;

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   if (oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION)
         != OSAL_ERROR)
   {
      scanBluetoothDevices.u16CmdCounter = poMessage->u16GetCmdCounter();
      scanBluetoothDevices.u16FunctionID = poMessage->u16GetFunctionID();
      scanBluetoothDevices.u16RegisterID = poMessage->u16GetRegisterID();
      scanBluetoothDevices.u16SourceAppID = poMessage->u16GetSourceAppID();
      scanBluetoothDevices.poMethodArg = OSAL_NULL;
      scanBluetoothDevices.bResponse = false;

      ETG_TRACE_USR1(("onScanBluetoothDevicesMethodStart::scan value = %d ", oFiDataObjectMethodStart.bScan));

      if((FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContextListSize(scanBluetoothDevices.u16FunctionID))
            < FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE)
      {
         most_btsetfi_tclMsgScanBluetoothDevicesMethodStart *temp = OSAL_NEW most_btsetfi_tclMsgScanBluetoothDevicesMethodStart;

         if(temp)
         {
            temp->bScan = oFiDataObjectMethodStart.bScan;

            scanBluetoothDevices.poMethodArg =
                              (most_btsetfi_tclMsgScanBluetoothDevicesMethodStart *) temp;

            TargetSwitchState targetSwitchState;

            MapSwitchDiscoveryStatusToInternal(targetSwitchState, oFiDataObjectMethodStart.bScan);

            if(_bluetoothApp)
            {
               FC_Bluetooth_CCAMethodQueue::poGetInstance()->PushMethodContext(scanBluetoothDevices.u16FunctionID,
                                    scanBluetoothDevices);
               _bluetoothApp->getBmCoreRequestIf().switchDiscoveryStatus(targetSwitchState);
            }
         }
         else
         {
            ETG_TRACE_ERR(("onScanBluetoothDevicesMethodStart:  temp is Null"));
                  sendMethodError(scanBluetoothDevices.u16FunctionID, scanBluetoothDevices,
                        most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
         }
      }
      else
      {
         ETG_TRACE_ERR(("onScanBluetoothDevicesMethodStart:  Queue size is more than %d",
               FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE));
         sendMethodError(scanBluetoothDevices.u16FunctionID, scanBluetoothDevices,
               most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
      }
   }
   else
   {
      ETG_TRACE_ERR(("onScanBluetoothDevicesMethodStart: OSAL GetData() failed"));
      vPostError(oVisitorMsg);
   }

   oFiDataObjectMethodStart.vDestroy();
   return;
}

tVoid FC_Bluetooth_tclCCAService::onGetDeviceInfoExtendedMethodStart(amt_tclServiceData* poMessage)
{
   ENTRY

   BmResult result = BM_RESULT_ERR_GENERAL;
   Job GetDeviceInfoExt;

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   most_btsetfi_tclMsgGetDeviceInfoExtendedMethodStart oFiDataObjectMethodStart;

   if (oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION)
         != OSAL_ERROR)
   {
      RemoteDeviceInfo remoteDeviceInfo;
      DeviceId deviceHandle = oFiDataObjectMethodStart.u8DeviceHandle;

      GetDeviceInfoExt.u16CmdCounter = poMessage->u16GetCmdCounter();
      GetDeviceInfoExt.u16FunctionID = poMessage->u16GetFunctionID();
      GetDeviceInfoExt.u16RegisterID = poMessage->u16GetRegisterID();
      GetDeviceInfoExt.u16SourceAppID = poMessage->u16GetSourceAppID();
      GetDeviceInfoExt.poMethodArg = OSAL_NULL;
      GetDeviceInfoExt.bResponse = false;

      ETG_TRACE_USR1(("onGetDeviceInfoExtendedMethodStart::deviceHandle value = %d ", oFiDataObjectMethodStart.u8DeviceHandle));

      if(_bluetoothApp)
      {
         result = _bluetoothApp->getBmCoreRequestIf().getRemoteDeviceInfo(remoteDeviceInfo, deviceHandle);
      }

      if (BM_RESULT_OK == result)
      {
         most_btsetfi_tclMsgGetDeviceInfoExtendedMethodResult oFiDataObjectMethodResult;

         oFiDataObjectMethodResult.u8DeviceHandle = (tU8)remoteDeviceInfo._deviceBaseInfo._deviceHandle;

         MapMajorDeviceClassTypeToMOST(oFiDataObjectMethodResult.e8MajorDeviceClass,
               remoteDeviceInfo._deviceBaseInfo._majorDeviceClass);

         if(_bBluetoothServiceIsAvail == true)
         {
            std::transform(remoteDeviceInfo._deviceBaseInfo._bdAddress.begin(), remoteDeviceInfo._deviceBaseInfo._bdAddress.end(),
                  remoteDeviceInfo._deviceBaseInfo._bdAddress.begin(), ::tolower);
         }

         oFiDataObjectMethodResult.sBluetoothDeviceAddress.bSet(remoteDeviceInfo._deviceBaseInfo._bdAddress.c_str(),
               most_fi_tcl_String::FI_EN_UTF8);

         ETG_TRACE_USR1(("onGetDeviceInfoExtendedMethodStart::_bdAddress = %s ", remoteDeviceInfo._deviceBaseInfo._bdAddress.c_str()));

         MapBluetoothFeatureSupportToMOST(oFiDataObjectMethodResult.oBluetoothFeatureSupport,
               remoteDeviceInfo._deviceBaseInfo._protocolInfo, oFiDataObjectMethodResult.u8DeviceHandle);

         oFiDataObjectMethodResult.sLinkKey.bSet(remoteDeviceInfo._linkKey.c_str(), most_fi_tcl_String::FI_EN_UTF8);

         MapSupportedProfilesStatusToMOST(oFiDataObjectMethodResult.oSupportedProfiles,
               remoteDeviceInfo._deviceBaseInfo._protocolInfo);

         MapDeviceIdentificationToMOST(oFiDataObjectMethodResult.oDeviceIdentification,
               remoteDeviceInfo._deviceBaseInfo._deviceIdentification);

         // Create FI VisitorMessage.
         fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodResult, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

         vInitServiceData(oVisitorMsgOutput, GetDeviceInfoExt.u16SourceAppID, GetDeviceInfoExt.u16RegisterID,
               GetDeviceInfoExt.u16CmdCounter, GetDeviceInfoExt.u16FunctionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

         // Post the message
         ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

         if (AIL_EN_N_NO_ERROR != ailResult)
         {
            ETG_TRACE_ERR(("onGetDeviceInfoExtendedMethodStart:enPostMessage failed for FunctionID: %d, with Result: %d",\
                  GetDeviceInfoExt.u16FunctionID, ailResult));
         }
         else
         {
            ETG_TRACE_USR1(("onGetDeviceInfoExtendedMethodStart::enPostMessage send successfully"));
         }

         oFiDataObjectMethodResult.vDestroy();
      }
      else
      {
         ETG_TRACE_ERR(("onGetDeviceInfoMethodStart: getRemoteDeviceInfo func return error:%d", result));
         sendMethodError(GetDeviceInfoExt.u16FunctionID, GetDeviceInfoExt,
               most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
      }
   }
   else
   {
      ETG_TRACE_ERR(("onGetDeviceInfoExtendedMethodStart: OSAL GetData() failed"));
      vPostError(oVisitorMsg);
   }

   oFiDataObjectMethodStart.vDestroy();
   return;
}

tVoid FC_Bluetooth_tclCCAService::onAddNewDeviceMethodStart(amt_tclServiceData* poMessage)
{
   ENTRY

   Job Addnewdevice;
   most_btsetfi_tclMsgAddNewDeviceMethodStart oFiDataObjectMethodStart;

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   ETG_TRACE_USR1(("onAddNewDeviceMethodStart:: entered"));

   if (oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
      Addnewdevice.u16CmdCounter = poMessage->u16GetCmdCounter();
      Addnewdevice.u16FunctionID = poMessage->u16GetFunctionID();
      Addnewdevice.u16RegisterID = poMessage->u16GetRegisterID();
      Addnewdevice.u16SourceAppID = poMessage->u16GetSourceAppID();
      Addnewdevice.poMethodArg = OSAL_NULL;
      Addnewdevice.bResponse = false;

      if (FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContextListSize(Addnewdevice.u16FunctionID)
            < FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE)
      {
         TargetSwitchState targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_ON;
         BdAddress bdAddress = "";

         if(_bluetoothApp)
         {
            FC_Bluetooth_CCAMethodQueue::poGetInstance()->PushMethodContext(Addnewdevice.u16FunctionID, Addnewdevice);
            _bluetoothApp->getBmCoreRequestIf().switchLocalPairableMode(targetSwitchState, bdAddress);
         }
      }
      else
      {
         ETG_TRACE_ERR(("onAddNewDeviceMethodStart:  Queue size is more than %d",
               FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE));
         sendMethodError(Addnewdevice.u16FunctionID, Addnewdevice, most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
      }
   }
   else
   {
      ETG_TRACE_ERR(("onAddNewDeviceMethodStart: OSAL GetData() failed"));
      vPostError(oVisitorMsg);
   }

   oFiDataObjectMethodStart.vDestroy();
   return;
}

tVoid FC_Bluetooth_tclCCAService::onChangePinMethodStart(amt_tclServiceData* poMessage)
{
   ENTRY

   Job changePin;
   most_btsetfi_tclMsgChangePinMethodStart oFiDataObjectMethodStart;
   std::string szPin;

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   if (oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
      changePin.u16CmdCounter = poMessage->u16GetCmdCounter();
      changePin.u16FunctionID = poMessage->u16GetFunctionID();
      changePin.u16RegisterID = poMessage->u16GetRegisterID();
      changePin.u16SourceAppID = poMessage->u16GetSourceAppID();
      changePin.poMethodArg = OSAL_NULL;
      changePin.bResponse = false;

      if((FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContextListSize(changePin.u16FunctionID))
               < FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE)
      {
         szPin = static_cast<char*> (oFiDataObjectMethodStart.sPinNumber.szValue);

         ETG_TRACE_USR1(("onChangePinMethodStart::CHANGED PIN value =%s ", oFiDataObjectMethodStart.sPinNumber.szValue));

         PairingPin pairingPin;

         vGetPairingPin(pairingPin);

         if(s32StringCompare(szPin.c_str(), pairingPin._pin.c_str()) != FC_BLUETOOTH_CCASERVICE_ZERO)
         {
            pairingPin._pin = szPin;

            if(_bluetoothApp)
            {
               FC_Bluetooth_CCAMethodQueue::poGetInstance()->PushMethodContext(changePin.u16FunctionID, changePin);
               _bluetoothApp->getBmCoreRequestIf().setPairingPin(pairingPin);
            }
         }
         else
         {
            ETG_TRACE_USR1(("onChangePinMethodStart:: Pin is already set"));

            LocalFriendlyNameType localFriendlyName = "";

            vGetLocalFriendlyName(localFriendlyName);

            ChangePinMethodResult(changePin, localFriendlyName, pairingPin._pin);
         }
      }
      else
      {
         ETG_TRACE_ERR(("onChangePinMethodStart:  Queue size is more than %d",
               FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE));
         sendMethodError(changePin.u16FunctionID, changePin, most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
      }
   }
   else
   {
      ETG_TRACE_ERR(("onChangePinMethodStart: OSAL GetData() failed"));
      vPostError(oVisitorMsg);
   }

   oFiDataObjectMethodStart.vDestroy();
   return;
}

tVoid FC_Bluetooth_tclCCAService::onPairingResponseMethodStart(amt_tclServiceData* poMessage)
{
   ENTRY

   Job pairingResponse;
   most_btsetfi_tclMsgPairingResponseMethodStart oFiDataObjectMethodStart;

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   if (oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
      pairingResponse.u16CmdCounter = poMessage->u16GetCmdCounter();
      pairingResponse.u16FunctionID = poMessage->u16GetFunctionID();
      pairingResponse.u16RegisterID = poMessage->u16GetRegisterID();
      pairingResponse.u16SourceAppID = poMessage->u16GetSourceAppID();
      pairingResponse.poMethodArg = OSAL_NULL;
      pairingResponse.bResponse = false;

      if((FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContextListSize(pairingResponse.u16FunctionID))
               < FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE)
      {
         ETG_TRACE_USR1(("onPairingResponseMethodStart:e8PairingResponseType.enType :: %d",
               oFiDataObjectMethodStart.e8PairingResponseType.enType));

         if(_bluetoothApp)
         {
            switch (oFiDataObjectMethodStart.e8PairingResponseType.enType)
            {
               case most_fi_tcl_e8_BTSetPairingResponseType::FI_EN_E8PAIRING_RESPONSE_YES:
               {
                  FC_Bluetooth_CCAMethodQueue::poGetInstance()->PushMethodContext(pairingResponse.u16FunctionID,
                        pairingResponse);
                  _bluetoothApp->getBmCoreRequestIf().acceptPairingRequest();
               }
               break;
               case most_fi_tcl_e8_BTSetPairingResponseType::FI_EN_E8PAIRING_RESPONSE_NO:
               {
                  FC_Bluetooth_CCAMethodQueue::poGetInstance()->PushMethodContext(pairingResponse.u16FunctionID,
                        pairingResponse);
                  _bluetoothApp->getBmCoreRequestIf().rejectPairingRequest();
               }
               break;
               case most_fi_tcl_e8_BTSetPairingResponseType::FI_EN_E8PAIRING_RESPONSE_CANCEL:
               {
                  PairingStatus btPairingStatus;
                  vGetPairingStatus(btPairingStatus);

                  // Send the cancel request only if the pairing is in progress
                  if((BM_PAIRING_STATE_IDLE == btPairingStatus._state) || (BM_PAIRING_STATE_UNKNOWN == btPairingStatus._state)
                        || ((BM_PAIRING_STATE_PAIRING_IN_PROGRESS == btPairingStatus._state) && (BM_PAIRING_RESULT_ERR_PAIRING_CANCELED == btPairingStatus._result)))
                  {
                     // Update the property if PairingState is Idle
                     vUpdatePairingStatus(BM_PAIRING_RESULT_ERR_PAIRING_CANCELED,"", "");
                     PairingResponseMethodResult(pairingResponse, BM_PAIRING_RESULT_ERR_PAIRING_CANCELED);
                  }
                  else
                  {
                     FC_Bluetooth_CCAMethodQueue::poGetInstance()->PushMethodContext(pairingResponse.u16FunctionID,
                           pairingResponse);
                     _bluetoothApp->getBmCoreRequestIf().rejectPairingRequest();
                  }
               }
               break;
               case most_fi_tcl_e8_BTSetPairingResponseType::FI_EN_E8PAIRING_RESPONSE_RETRY:
                  //TODO: to be discussed for Retry option.
               break;
               default:
                  ETG_TRACE_ERR(("onPairingResponseMethodStart: Invalid pairing response type"));
               break;
            }
         }
      }
      else
      {
         ETG_TRACE_ERR(("onPairingResponseMethodStart:  Queue size is more than %d",
               FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE));
         sendMethodError(pairingResponse.u16FunctionID, pairingResponse,
               most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
      }
   }
   else
   {
      ETG_TRACE_ERR(("onPairingResponseMethodStart: OSAL GetData() failed"));
      vPostError(oVisitorMsg);
   }

   oFiDataObjectMethodStart.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::onChangeDeviceStateMethodStart(amt_tclServiceData* poMessage)
{
   ENTRY

   DeviceHandleType deviceHandleSingleType(BM_DEVICE_HANDLE_TYPE_SINGLE);
   DeviceHandleType deviceHandleAllType(BM_DEVICE_HANDLE_TYPE_ALL);

   most_btsetfi_tclMsgChangeDeviceStateMethodStart oFiDataObjectMethodStart;
   Job changeDeviceState;

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   if (oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
      changeDeviceState.u16CmdCounter = poMessage->u16GetCmdCounter();
      changeDeviceState.u16FunctionID = poMessage->u16GetFunctionID();
      changeDeviceState.u16RegisterID = poMessage->u16GetRegisterID();
      changeDeviceState.u16SourceAppID = poMessage->u16GetSourceAppID();
      changeDeviceState.poMethodArg = OSAL_NULL;
      changeDeviceState.bResponse = false;

      tU16 u16ListSize = FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContextListSize(changeDeviceState.u16FunctionID);

      if (u16ListSize < FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE)
      {
         ETG_TRACE_USR1(("onChangeDeviceStateMethodStart:u8DeviceHandle - %d",
               oFiDataObjectMethodStart.u8DeviceHandle));
         ETG_TRACE_USR1(("onChangeDeviceStateMethodStart:e8ChangeDeviceStateAction.enType :: %d",
               oFiDataObjectMethodStart.e8ChangeDeviceStateAction.enType));

         most_btsetfi_tclMsgChangeDeviceStateMethodStart *temp = OSAL_NEW most_btsetfi_tclMsgChangeDeviceStateMethodStart;

         if(temp != NULL)
         {
            DeviceId deviceHandle = oFiDataObjectMethodStart.u8DeviceHandle;

            temp->u8DeviceHandle = oFiDataObjectMethodStart.u8DeviceHandle;
            temp->e8ChangeDeviceStateAction = oFiDataObjectMethodStart.e8ChangeDeviceStateAction;

            changeDeviceState.poMethodArg =
                  (most_btsetfi_tclMsgChangeDeviceStateMethodStart *) temp;

            FC_Bluetooth_CCAMethodQueue::poGetInstance()->PushMethodContext(changeDeviceState.u16FunctionID, changeDeviceState);

            switch (oFiDataObjectMethodStart.e8ChangeDeviceStateAction.enType)
            {
               case most_fi_tcl_e8_BTSetChangeDeviceStateAction::FI_EN_E8SELECT:
               {
                  if(_bluetoothApp)
                  {
                     _bluetoothApp->getBmCoreRequestIf().connectDevice(deviceHandle);
                  }
               }
               break;
               case most_fi_tcl_e8_BTSetChangeDeviceStateAction::FI_EN_E8DISCONNECT:
               {
                  if(_bluetoothApp)
                  {
                     if (deviceHandle == FC_BLUETOOTH_CCASERVICE_ZERO)
                     {
                        _bluetoothApp->getBmCoreRequestIf().disconnectDevice(deviceHandle, deviceHandleAllType);
                     }
                     else
                     {
                        _bluetoothApp->getBmCoreRequestIf().disconnectDevice(deviceHandle, deviceHandleSingleType);
                     }
                  }
               }
               break;
               case most_fi_tcl_e8_BTSetChangeDeviceStateAction::FI_EN_E8DELETE:
               {
                  if(_bluetoothApp)
                  {
                     if (deviceHandle == FC_BLUETOOTH_CCASERVICE_ZERO)
                     {
                        _bluetoothApp->getBmCoreRequestIf().deleteDevice(deviceHandle, deviceHandleAllType);
                     }
                     else
                     {
                        _bluetoothApp->getBmCoreRequestIf().deleteDevice(deviceHandle, deviceHandleSingleType);
                     }
                  }
               }
               break;
               case most_fi_tcl_e8_BTSetChangeDeviceStateAction::FI_EN_E8DELETE_ALL:
               {
                  if(_bluetoothApp)
                  {
                     _bluetoothApp->getBmCoreRequestIf().deleteDevice(deviceHandle, deviceHandleAllType);
                  }
               }
               break;
               case most_fi_tcl_e8_BTSetChangeDeviceStateAction::FI_EN_E8BLOCK:
               {
                  if(_bluetoothApp)
                  {
                     if (deviceHandle == FC_BLUETOOTH_CCASERVICE_ZERO)
                     {
                        _bluetoothApp->getBmCoreRequestIf().blockDevice(deviceHandle, deviceHandleAllType);
                     }
                     else
                     {
                        _bluetoothApp->getBmCoreRequestIf().blockDevice(deviceHandle, deviceHandleSingleType);
                     }
                  }
               }
               break;
               case most_fi_tcl_e8_BTSetChangeDeviceStateAction::FI_EN_E8UNBLOCK:
               {
                  if(_bluetoothApp)
                  {
                     if (deviceHandle == FC_BLUETOOTH_CCASERVICE_ZERO)
                     {
                        _bluetoothApp->getBmCoreRequestIf().unblockDevice(deviceHandle, deviceHandleAllType);
                     }
                     else
                     {
                        _bluetoothApp->getBmCoreRequestIf().unblockDevice(deviceHandle, deviceHandleSingleType);
                     }
                  }
               }
               break;
               case most_fi_tcl_e8_BTSetChangeDeviceStateAction::FI_EN_E8UNBLOCK_AUTO_CONNECT:
               {
                  if(_bluetoothApp)
                  {
                     if (deviceHandle == FC_BLUETOOTH_CCASERVICE_ZERO)
                     {
                        _bluetoothApp->getBmCoreRequestIf().unblockDevice(deviceHandle, deviceHandleAllType);
                     }
                     else
                     {
                        _bluetoothApp->getBmCoreRequestIf().unblockDevice(deviceHandle, deviceHandleSingleType);
                     }

                     // Add the dummy job to stat
                     Job startAutoConnect;
                     startAutoConnect.u16FunctionID = DUMMY_METHOD_FKID;
                     startAutoConnect.bResponse = false;
                     startAutoConnect.poMethodArg = OSAL_NULL;
                     FC_Bluetooth_CCAMethodQueue::poGetInstance()->PushMethodContext(STARTAUTOCONNECTSEQ_METHOD_FKTID, startAutoConnect);
                     _bluetoothApp->getBmCoreRequestIf().startAutoConnectSequence(BM_TEMPORARY_AUTO_CONNECTION_LAST_CONNECTED_DEVICES);
                  }
               }
               break;
               case most_fi_tcl_e8_BTSetChangeDeviceStateAction::FI_EN_E8BLOCK_ALL_EXCEPT:
               {
                  ETG_TRACE_ERR(("onChangeDeviceStateMethodStart: not used in IVI"));
                  u16ListSize = (tU16)(u16ListSize + FC_BLUETOOTH_CCASERVICE_ONE);
                  ChangeDeviceStateMethodError(changeDeviceState, u16ListSize);
               }
               break;
               default:
               {
                  ETG_TRACE_ERR(("onChangeDeviceStateMethodStart: Invalid change device state"));
                  u16ListSize = (tU16)(u16ListSize + FC_BLUETOOTH_CCASERVICE_ONE);
                  ChangeDeviceStateMethodError(changeDeviceState, u16ListSize);
               }
               break;
            }
         }
         else
         {
            ETG_TRACE_ERR(("onChangeDeviceStateMethodStart:  poFiDataObjectMethodStart is Null"));
            sendMethodError(changeDeviceState.u16FunctionID, changeDeviceState,
                  most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
         }
      }
      else
      {
         ETG_TRACE_ERR(("onChangeDeviceStateMethodStart:  Queue size is more than %d",
               FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE));
         sendMethodError(changeDeviceState.u16FunctionID, changeDeviceState,
               most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
      }
   }
   else
   {
      ETG_TRACE_ERR(("onChangeDeviceStateMethodStart: OSAL GetData() failed"));
      vPostError(oVisitorMsg);
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::vUpdateBlockStatus(const BlockStatus& blockStatus)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR4(("vUpdateBlockStatus:entered - %d", blockStatus._deviceBlockStatusList.size()));

   //MR for ChangeDeviceState(BLOCK/UNBLOCK/BLOCK_ALL_EXCEPT)
   vBlockAndUnblockProfileResponse(blockStatus);

   vCopyBlockStatus(blockStatus);

   return;
}

tVoid FC_Bluetooth_tclCCAService::vGetBlockStatus(BlockStatus& blockStatus)
{
   ENTRY_INTERNAL

   blockStatus = _blockStatus;

   return;
}

tVoid FC_Bluetooth_tclCCAService::vBlockAndUnblockProfileResponse(const BlockStatus& blockStatus,
      tBool bResponse, BmResult result)
{
   JobList *joblist = OSAL_NULL;
   Job methodcontext;
   tBool bQuit = FALSE;
   tBool bJobFind = FALSE;
   tU16 u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;

   ETG_TRACE_USR1(("vBlockAndUnblockProfileResponse: bResponse: %d result:%d", bResponse, result));

   do
   {
      bJobFind = FALSE;
      bQuit = FALSE;

      // Read the change device state method jobs from queue
      joblist = FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContext(CHANGEDEVICESTATE_METHOD_FKTID);

      // check the jobs is available
      if (joblist)
      {
         ETG_TRACE_USR1(("vBlockAndUnblockProfileResponse: size: %d", joblist->size()));

         for (JobList::iterator it = joblist->begin(); it != joblist->end(); it++)
         {
            methodcontext = (Job) *it;
            u16Count++;

            ETG_TRACE_USR1(("vBlockAndUnblockProfileResponse: methodcontext u16FunctionID: %d bResponse: %d u16Count - %d",
                  methodcontext.u16FunctionID, methodcontext.bResponse, u16Count));

            // check whether immediate response is received from BMCore. if the response is true then update the corresponding method context
            // as response - RECEIVED and check the result. if the result is NOT_OK then send the ME to the change device state request.
            if(bResponse == TRUE)
            {
               if(methodcontext.bResponse == false)
               {
                  (*it).bResponse = true;

                  if(BM_RESULT_OK != result)
                  {
                     // send the ME
                     ChangeDeviceStateMethodError(methodcontext, u16Count);
                  }
                  else
                  {
                     // check the MR is already available for the corresponding method request. if available then send the MR to the request.
                     updateChangeDeviceStateBlockMR(blockStatus, methodcontext, bJobFind, u16Count);
                  }

                  bQuit = TRUE;
               }
               else
               {
                  ETG_TRACE_USR1(("vBlockAndUnblockProfileResponse: Response is already received"));
               }
            }
            else
            {
               if(methodcontext.bResponse == true)
               {
                  // check the MR is available for the corresponding method request. if available then send the MR to the request.
                  updateChangeDeviceStateBlockMR(blockStatus, methodcontext, bJobFind, u16Count);
               }
               else
               {
                  ETG_TRACE_USR1(("vBlockAndUnblockProfileResponse: Response is not yet received"));
                  bQuit = TRUE;
               }
            }

            ETG_TRACE_USR1(("vBlockAndUnblockProfileResponse: bJobFind: %d bQuit:%d", bJobFind, bQuit));

            if((bJobFind == TRUE) || (bQuit == TRUE))
            {
               u16Count = FC_BLUETOOTH_CCASERVICE_ZERO;
               break;
            }
         }
      }
      else
      {
         bQuit = TRUE;
      }
   }while((bJobFind == TRUE) && (bQuit == FALSE));

   return;
}

void FC_Bluetooth_tclCCAService::updateChangeDeviceStateBlockMR(const BlockStatus& blockStatus,
      Job& methodcontext, tBool& bJobFind, tU16& u16Count)
{
   ENTRY_INTERNAL

   DeviceBlockStatus deviceBlockStatus;
   DeviceBlockStatusList::const_iterator It;
   most_fi_tcl_e8_BTSetConnectionResult e8_BTSetConnectionResult;
   most_btsetfi_tclMsgChangeDeviceStateMethodStart *poCDSFiDataObjectMethodStart = NULL;

   poCDSFiDataObjectMethodStart = (most_btsetfi_tclMsgChangeDeviceStateMethodStart *) (methodcontext.poMethodArg);

   if (poCDSFiDataObjectMethodStart)
   {
      if ((poCDSFiDataObjectMethodStart->e8ChangeDeviceStateAction.enType == most_fi_tcl_e8_BTSetChangeDeviceStateAction::FI_EN_E8BLOCK) ||
            (poCDSFiDataObjectMethodStart->e8ChangeDeviceStateAction.enType == most_fi_tcl_e8_BTSetChangeDeviceStateAction::FI_EN_E8UNBLOCK) ||
            (poCDSFiDataObjectMethodStart->e8ChangeDeviceStateAction.enType == most_fi_tcl_e8_BTSetChangeDeviceStateAction::FI_EN_E8BLOCK_ALL_EXCEPT) ||
            (poCDSFiDataObjectMethodStart->e8ChangeDeviceStateAction.enType == most_fi_tcl_e8_BTSetChangeDeviceStateAction::FI_EN_E8UNBLOCK_AUTO_CONNECT))
      {
         if(poCDSFiDataObjectMethodStart->u8DeviceHandle != FC_BLUETOOTH_CCASERVICE_ZERO)
         {
            It = std::find_if(blockStatus._deviceBlockStatusList.begin(),
                  blockStatus._deviceBlockStatusList.end(),
                  MeetsDeviceHandle<DeviceBlockStatus>(poCDSFiDataObjectMethodStart->u8DeviceHandle));

            if (It != blockStatus._deviceBlockStatusList.end())
            {
               deviceBlockStatus = *It;

               ETG_TRACE_USR1(("updateChangeDeviceStateBlockMR: MS Handle:%d Received Handle:%d Status:%d",\
                     poCDSFiDataObjectMethodStart->u8DeviceHandle, deviceBlockStatus._deviceHandle, deviceBlockStatus._blockState));

               if (_bluetoothApp)
               {
                  if(poCDSFiDataObjectMethodStart->e8ChangeDeviceStateAction.enType != most_fi_tcl_e8_BTSetChangeDeviceStateAction::FI_EN_E8BLOCK_ALL_EXCEPT)
                  {
                     if(deviceBlockStatus._blockState == BM_BLOCK_STATE_BLOCKED)
                     {
                        e8_BTSetConnectionResult.enType = most_fi_tcl_e8_BTSetConnectionResult::FI_EN_E8DEVICE_BLOCKED;
                     }
                     else
                     {
                        e8_BTSetConnectionResult.enType = most_fi_tcl_e8_BTSetConnectionResult::FI_EN_E8DEVICE_UNBLOCKED;
                     }

                     bJobFind = TRUE;
                  }
                  else
                  {
                     if(deviceBlockStatus._blockState == BM_BLOCK_STATE_UNBLOCKED)
                     {
                        if(blockStatus._deviceBlockStatusList.size() > FC_BLUETOOTH_CCASERVICE_ZERO)
                        {
                           for (tU16 iCount = FC_BLUETOOTH_CCASERVICE_ZERO; iCount < blockStatus._deviceBlockStatusList.size(); iCount++)
                           {
                              if(blockStatus._deviceBlockStatusList[iCount]._deviceHandle != deviceBlockStatus._deviceHandle)
                              {
                                 if (blockStatus._deviceBlockStatusList[iCount]._blockState == BM_BLOCK_STATE_BLOCKED)
                                 {
                                    e8_BTSetConnectionResult.enType = most_fi_tcl_e8_BTSetConnectionResult::FI_EN_E8BLOCK_ALL_EXCEPT;
                                    bJobFind = TRUE;
                                 }
                                 else
                                 {
                                    bJobFind = FALSE;
                                    break;
                                 }
                              }
                           }
                        }
                        else
                        {
                           bJobFind = TRUE;
                        }
                     }
                  }
               }
            }
         }
         else
         {
            ETG_TRACE_USR1(("updateChangeDeviceStateBlockMR: MS Handle:%d Action:%d State:%d",\
                  poCDSFiDataObjectMethodStart->u8DeviceHandle, poCDSFiDataObjectMethodStart->e8ChangeDeviceStateAction.enType, blockStatus._overallDeviceBlockStatus._blockState));

            if(poCDSFiDataObjectMethodStart->e8ChangeDeviceStateAction.enType == most_fi_tcl_e8_BTSetChangeDeviceStateAction::FI_EN_E8BLOCK)
            {
               if(blockStatus._overallDeviceBlockStatus._blockState == BM_OVERALL_BLOCK_STATE_BLOCKED)
               {
                  e8_BTSetConnectionResult.enType = most_fi_tcl_e8_BTSetConnectionResult::FI_EN_E8DEVICE_BLOCKED;
                  bJobFind = TRUE;
               }
            }
            else if((poCDSFiDataObjectMethodStart->e8ChangeDeviceStateAction.enType == most_fi_tcl_e8_BTSetChangeDeviceStateAction::FI_EN_E8UNBLOCK) ||
                  (poCDSFiDataObjectMethodStart->e8ChangeDeviceStateAction.enType == most_fi_tcl_e8_BTSetChangeDeviceStateAction::FI_EN_E8UNBLOCK_AUTO_CONNECT))
            {
               if(blockStatus._overallDeviceBlockStatus._blockState == BM_OVERALL_BLOCK_STATE_UNBLOCKED)
               {
                  e8_BTSetConnectionResult.enType = most_fi_tcl_e8_BTSetConnectionResult::FI_EN_E8DEVICE_UNBLOCKED;
                  bJobFind = TRUE;
               }
            }
         }
      }

      if (bJobFind == TRUE)
      {
         ChangeDeviceStateMethodResult(methodcontext, e8_BTSetConnectionResult);

         if(poCDSFiDataObjectMethodStart != NULL)
         {
            poCDSFiDataObjectMethodStart->vDestroy();
            OSAL_DELETE poCDSFiDataObjectMethodStart;
         }

         FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(CHANGEDEVICESTATE_METHOD_FKTID, methodcontext, u16Count);
      }
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::vCopyBlockStatus(const BlockStatus& blockStatus)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR4(("vCopyBlockStatus:entered"));

   _blockStatus._overallDeviceBlockStatus._blockState = blockStatus._overallDeviceBlockStatus._blockState;
   _blockStatus._overallDeviceBlockStatus._bdAddress = blockStatus._overallDeviceBlockStatus._bdAddress;

   ETG_TRACE_USR4(("vCopyBlockStatus:_overallDeviceBlockStatus - %d ", _blockStatus._overallDeviceBlockStatus._blockState));

   _blockStatus._deviceBlockStatusList.clear();

   if(blockStatus._deviceBlockStatusList.size() > FC_BLUETOOTH_CCASERVICE_ZERO)
   {
      for (std::vector<DeviceBlockStatus>::const_iterator it = blockStatus._deviceBlockStatusList.begin();
            it != blockStatus._deviceBlockStatusList.end(); it++)
      {
         DeviceBlockStatus temp;

         temp._deviceHandle = it->_deviceHandle;
         temp._blockState  = it->_blockState;

         for (ProtocolBlockStatusMap::const_iterator itPIM = it->_protocolBlockStatusMap.begin(); itPIM != it->_protocolBlockStatusMap.end(); itPIM++)
         {
            BlockState blockstate = itPIM->second;

            Protocol protocol;
            protocol._protocolId = itPIM->first._protocolId;
            protocol._uuid = itPIM->first._uuid;

            temp._protocolBlockStatusMap[protocol] = blockstate;

            ETG_TRACE_USR4(("vCopyBlockStatus:protocolid-%d uuid-%50s  blockstatus-%d",
                  protocol._protocolId, protocol._uuid.c_str(), blockstate));
         }

         _blockStatus._deviceBlockStatusList.push_back(temp);
      }
   }

   vPrintBlockStatus(_blockStatus);

   return;
}

tVoid FC_Bluetooth_tclCCAService::vPrintBlockStatus(const BlockStatus& blockStatus)
{
   ETG_TRACE_USR4(("vPrintBlockStatus:size - %d", blockStatus._deviceBlockStatusList.size()));

   for (std::vector<DeviceBlockStatus>::const_iterator it = blockStatus._deviceBlockStatusList.begin();
         it != blockStatus._deviceBlockStatusList.end(); it++)
   {
      ETG_TRACE_USR4(("vPrintBlockStatus:deviceHandle - %d ", it->_deviceHandle));
      ETG_TRACE_USR4(("vPrintBlockStatus:blockState - %d ", it->_blockState));

      for (ProtocolBlockStatusMap::const_iterator itPIM = it->_protocolBlockStatusMap.begin(); itPIM != it->_protocolBlockStatusMap.end(); itPIM++)
      {
         BlockState blockstate = itPIM->second;

         Protocol protocol;
         protocol._protocolId = itPIM->first._protocolId;
         protocol._uuid = itPIM->first._uuid;

         ETG_TRACE_USR4(("vPrintBlockStatus:protocolid-%d uuid-%50s  blockstatus-%d",
               protocol._protocolId, protocol._uuid.c_str(), blockstate));
      }
   }

   return;
}

tBool FC_Bluetooth_tclCCAService::bCheckBlockStatus(tU8 u8DeviceHandle, most_fi_tcl_e8_BTSetChangeDeviceStateAction e8ChangeDeviceStateAction,
      most_fi_tcl_e8_BTSetConnectionResult& e8_BTSetConnectionResult)
{
   DeviceBlockStatusList::iterator It;
   BlockStatus blockStatus;
   tBool bRet = false;
   tBool bAutoconnectOnOff = false;

   vGetBlockStatus(blockStatus);

   ETG_TRACE_USR1(("bCheckBlockStatus:u8DeviceHandle - %d", u8DeviceHandle));
   ETG_TRACE_USR1(("bCheckBlockStatus:e8ChangeDeviceStateAction.enType :: %d", e8ChangeDeviceStateAction.enType));

   if(u8DeviceHandle != FC_BLUETOOTH_CCASERVICE_ZERO)
   {
      It = std::find_if(blockStatus._deviceBlockStatusList.begin(),
            blockStatus._deviceBlockStatusList.end(),
            MeetsDeviceHandle<DeviceBlockStatus>(u8DeviceHandle));

      if(It != blockStatus._deviceBlockStatusList.end())
      {
         if(e8ChangeDeviceStateAction.enType == most_fi_tcl_e8_BTSetChangeDeviceStateAction::FI_EN_E8BLOCK)
         {
            ETG_TRACE_USR1(("bCheckBlockStatus:BLOCK state :: %d", It->_blockState));

            if(It->_blockState == BM_BLOCK_STATE_BLOCKED)
            {
               e8_BTSetConnectionResult.enType = most_fi_tcl_e8_BTSetConnectionResult::FI_EN_E8DEVICE_BLOCKED;
               bRet = true;
            }
         }
         else if(e8ChangeDeviceStateAction.enType == most_fi_tcl_e8_BTSetChangeDeviceStateAction::FI_EN_E8UNBLOCK)
         {
            ETG_TRACE_USR1(("bCheckBlockStatus:UNBLOCK state :: %d", It->_blockState));

            if(It->_blockState == BM_BLOCK_STATE_UNBLOCKED)
            {
               e8_BTSetConnectionResult.enType = most_fi_tcl_e8_BTSetConnectionResult::FI_EN_E8DEVICE_UNBLOCKED;
               bRet = true;
            }
         }
         else
         {
            ETG_TRACE_USR1(("bCheckBlockStatus:BLOCK_ALL_EXCEPT state :: %d", It->_blockState));

            if(It->_blockState == BM_BLOCK_STATE_UNBLOCKED)
            {
               if(blockStatus._deviceBlockStatusList.size() > 1)
               {
                  for (tU16 iCount = FC_BLUETOOTH_CCASERVICE_ZERO; iCount < blockStatus._deviceBlockStatusList.size(); iCount++)
                  {
                     if(blockStatus._deviceBlockStatusList[iCount]._deviceHandle != u8DeviceHandle)
                     {
                        ETG_TRACE_USR1(("bCheckDeviceState:BLOCK_ALL_EXCEPT other state :: %d", blockStatus._deviceBlockStatusList[iCount]._blockState));

                        if (blockStatus._deviceBlockStatusList[iCount]._blockState == BM_BLOCK_STATE_BLOCKED)
                        {
                           bRet = true;
                        }
                        else
                        {
                           bRet = false;
                           break;
                        }
                     }
                  }
               }
               else
               {
                  bRet = true;
               }

               ETG_TRACE_USR1(("bCheckDeviceState:BLOCK_ALL_EXCEPT ret val :: %d", bRet));

               if(bRet == true)
               {
                  e8_BTSetConnectionResult.enType = most_fi_tcl_e8_BTSetConnectionResult::FI_EN_E8BLOCK_ALL_EXCEPT;
               }
            }
         }
      }
   }
   else
   {
      if(e8ChangeDeviceStateAction.enType == most_fi_tcl_e8_BTSetChangeDeviceStateAction::FI_EN_E8BLOCK)
      {
         ETG_TRACE_USR1(("bCheckBlockStatus:BLOCKall_state :: %d", blockStatus._overallDeviceBlockStatus._blockState));

         if(blockStatus._overallDeviceBlockStatus._blockState == BM_OVERALL_BLOCK_STATE_BLOCKED)
         {
            e8_BTSetConnectionResult.enType = most_fi_tcl_e8_BTSetConnectionResult::FI_EN_E8DEVICE_BLOCKED;
            bRet = true;
         }
      }
      else if(e8ChangeDeviceStateAction.enType == most_fi_tcl_e8_BTSetChangeDeviceStateAction::FI_EN_E8UNBLOCK)
      {
         ETG_TRACE_USR1(("bCheckBlockStatus:UNBLOCKall state :: %d", blockStatus._overallDeviceBlockStatus._blockState));

         if(blockStatus._overallDeviceBlockStatus._blockState == BM_OVERALL_BLOCK_STATE_UNBLOCKED)
         {
            e8_BTSetConnectionResult.enType = most_fi_tcl_e8_BTSetConnectionResult::FI_EN_E8DEVICE_UNBLOCKED;
            bRet = true;
         }
      }
      else if(e8ChangeDeviceStateAction.enType == most_fi_tcl_e8_BTSetChangeDeviceStateAction::FI_EN_E8UNBLOCK_AUTO_CONNECT)
      {
         vGetAutoConnectionType(bAutoconnectOnOff);

         ETG_TRACE_USR1(("bCheckBlockStatus:UNBLOCK aUTO state :: %d %d", blockStatus._overallDeviceBlockStatus._blockState, bAutoconnectOnOff));

         if((blockStatus._overallDeviceBlockStatus._blockState == BM_OVERALL_BLOCK_STATE_UNBLOCKED) && (bAutoconnectOnOff == true))
         {
            e8_BTSetConnectionResult.enType = most_fi_tcl_e8_BTSetConnectionResult::FI_EN_E8DEVICE_UNBLOCKED;
            bRet = true;
         }
      }
   }

   return bRet;
}

tVoid FC_Bluetooth_tclCCAService::onReplaceDeviceMethodStart(amt_tclServiceData* poMessage)
{
   ENTRY

   BmResult result = BM_RESULT_ERR_GENERAL;

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   most_btsetfi_tclMsgReplaceDeviceMethodStart oFiDataObjectMethodStart;

   if (oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION)
         != OSAL_ERROR)
   {
      DeviceId deviceHandle = oFiDataObjectMethodStart.u8ConnectDeviceHandle;

      //TODO: discuss and update the below point!!!
      //When ReplaceDevice Method called, connected device should be disconnected first and then the requested device should be connected.
      //If BM_CORE handles the logic for disconnecting device internally, then calling disconnectDevice() is not required.

      if(_bluetoothApp)
      {
         result = _bluetoothApp->getBmCoreRequestIf().connectDevice(deviceHandle);

         if (BM_RESULT_OK != result)
         {
            vPostError(oVisitorMsg);
         }
      }
   }
   else
   {
      ETG_TRACE_ERR(("Error: OSAL GetData() failed for onReplaceDeviceMethodStart"));
   }

   oFiDataObjectMethodStart.vDestroy();
   return;
}

tVoid FC_Bluetooth_tclCCAService::onClearDeviceInfoMethodStart(amt_tclServiceData* poMessage)
{
   ENTRY

   Job clearDeviceInfo;

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   most_btsetfi_tclMsgClearDeviceInfoMethodStart oFiDataObjectMethodStart;

   ETG_TRACE_USR1(("onClearDeviceInfoMethodStart:entered"));

   if (oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
      clearDeviceInfo.u16CmdCounter = poMessage->u16GetCmdCounter();
      clearDeviceInfo.u16FunctionID = poMessage->u16GetFunctionID();
      clearDeviceInfo.u16RegisterID = poMessage->u16GetRegisterID();
      clearDeviceInfo.u16SourceAppID = poMessage->u16GetSourceAppID();

      if(_bluetoothApp)
      {
         FC_Bluetooth_CCAMethodQueue::poGetInstance()->PushMethodContext(clearDeviceInfo.u16FunctionID,
               clearDeviceInfo);

         // false - clear and set the default value (using same power cycle)
         _bluetoothApp->getBmCoreRequestIf().resetToDefault(false);
      }
   }
   else
   {
      ETG_TRACE_ERR(("Error: OSAL GetData() failed for onClearDeviceInfoMethodStart"));
      vPostError(oVisitorMsg);
   }

   oFiDataObjectMethodStart.vDestroy();
   return;
}

tVoid FC_Bluetooth_tclCCAService::onConnectBluetoothProfileMethodStart(amt_tclServiceData* poMessage)
{
   (tVoid) poMessage;
   ENTRY

   Job connectProfile;
   ProtocolList protocolList;
   most_btsetfi_tclMsgConnectBluetoothProfileMethodStart oFiDataObjectMethodStart;

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   if (oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
      connectProfile.u16CmdCounter = poMessage->u16GetCmdCounter();
      connectProfile.u16FunctionID = poMessage->u16GetFunctionID();
      connectProfile.u16RegisterID = poMessage->u16GetRegisterID();
      connectProfile.u16SourceAppID = poMessage->u16GetSourceAppID();
      connectProfile.bResponse = false;
      connectProfile.poMethodArg = OSAL_NULL;

      if ((FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContextListSize(connectProfile.u16FunctionID))
            < FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE)
      {
         DeviceId deviceHandle = oFiDataObjectMethodStart.u8DeviceHandle;

         protocolList.clear();

         ETG_TRACE_USR4(("onConnectBluetoothProfileMethodStart:u8DeviceHandle:%d"\
               ,oFiDataObjectMethodStart.u8DeviceHandle));
         ETG_TRACE_USR4(("onConnectBluetoothProfileMethodStart:oServiceType.bHFP"\
               ":%d",oFiDataObjectMethodStart.oServiceType.bHFP));
         ETG_TRACE_USR4(("onConnectBluetoothProfileMethodStart:oServiceType.bAVP"\
               ":%d",oFiDataObjectMethodStart.oServiceType.bAVP));
         ETG_TRACE_USR4(("onConnectBluetoothProfileMethodStart:oServiceType.bPAN"\
               ":%d",oFiDataObjectMethodStart.oServiceType.bPAN));
         ETG_TRACE_USR4(("onConnectBluetoothProfileMethodStart:oServiceType.bPBAP"\
               ":%d",oFiDataObjectMethodStart.oServiceType.bPBAP));
         ETG_TRACE_USR4(("onConnectBluetoothProfileMethodStart:oServiceType.bMAP"\
               ":%d",oFiDataObjectMethodStart.oServiceType.bMAP));

         connectBluetoothProfileStruct *poConnectBluetoothProfile = OSAL_NEW connectBluetoothProfileStruct;

         if (poConnectBluetoothProfile)
         {
            poConnectBluetoothProfile->CBPFiDataObjectMethodStart.u8DeviceHandle = oFiDataObjectMethodStart.u8DeviceHandle;
            poConnectBluetoothProfile->CBPFiDataObjectMethodStart.oServiceType.bHFP = oFiDataObjectMethodStart.oServiceType.bHFP;
            poConnectBluetoothProfile->CBPFiDataObjectMethodStart.oServiceType.bAVP = oFiDataObjectMethodStart.oServiceType.bAVP;
            poConnectBluetoothProfile->CBPFiDataObjectMethodStart.oServiceType.bPAN = oFiDataObjectMethodStart.oServiceType.bPAN;
            poConnectBluetoothProfile->CBPFiDataObjectMethodStart.oServiceType.bPBAP = oFiDataObjectMethodStart.oServiceType.bPBAP;
            poConnectBluetoothProfile->CBPFiDataObjectMethodStart.oServiceType.bMAP = oFiDataObjectMethodStart.oServiceType.bMAP;
            poConnectBluetoothProfile->BTServiceType.bHFP = FALSE;
            poConnectBluetoothProfile->BTServiceType.bAVP = FALSE;
            poConnectBluetoothProfile->BTServiceType.bPAN = FALSE;
            poConnectBluetoothProfile->BTServiceType.bPBAP = FALSE;
            poConnectBluetoothProfile->BTServiceType.bMAP = FALSE;

            connectProfile.poMethodArg =
                  (connectBluetoothProfileStruct *) poConnectBluetoothProfile;

            if (oFiDataObjectMethodStart.oServiceType.bHFP)
            {
               Protocol protocol;
               protocol._protocolId = BM_PROTOCOL_ID_HFP;
               protocol._uuid = "";
               protocolList.push_back(protocol);
            }

            if (oFiDataObjectMethodStart.oServiceType.bAVP)
            {
               Protocol protocol;
               protocol._protocolId = BM_PROTOCOL_ID_AVP;
               protocol._uuid = "";
               protocolList.push_back(protocol);
            }

            if (oFiDataObjectMethodStart.oServiceType.bPAN)
            {
               Protocol protocol;
               protocol._protocolId = BM_PROTOCOL_ID_PAN;
               protocol._uuid = "";
               protocolList.push_back(protocol);
            }

            if (oFiDataObjectMethodStart.oServiceType.bPBAP)
            {
               Protocol protocol;
               protocol._protocolId = BM_PROTOCOL_ID_PBDL;
               protocol._uuid = "";
               protocolList.push_back(protocol);
            }

            if (oFiDataObjectMethodStart.oServiceType.bMAP)
            {
               Protocol protocol;
               protocol._protocolId = BM_PROTOCOL_ID_MSG;
               protocol._uuid = "";
               protocolList.push_back(protocol);
            }

            if(_bluetoothApp)
            {
               FC_Bluetooth_CCAMethodQueue::poGetInstance()->PushMethodContext(connectProfile.u16FunctionID,
                     connectProfile);
               _bluetoothApp->getBmCoreRequestIf().connectProfiles(deviceHandle, protocolList);
            }
         }
         else
         {
            ETG_TRACE_ERR(("onConnectBluetoothProfileMethodStart: poConnectBluetoothProfile is Null"));
            sendMethodError(connectProfile.u16FunctionID, connectProfile, most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
         }
      }
      else
      {
         ETG_TRACE_ERR(("onConnectBluetoothProfileMethodStart:  Queue size is more than %d",
               FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE));
         sendMethodError(connectProfile.u16FunctionID, connectProfile,
               most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
      }
   }
   else
   {
      ETG_TRACE_ERR(("onConnectBluetoothProfileMethodStart: OSAL GetData() failed"));
      vPostError(oVisitorMsg);
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::onDisconnectBluetoothProfileMethodStart(amt_tclServiceData* poMessage)
{
   (tVoid) poMessage;
   ENTRY

   Job disconnectProfile;
   ProtocolList protocolList;
   most_btsetfi_tclMsgDisconnectBluetoothProfileMethodStart oFiDataObjectMethodStart;

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   if (oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
      disconnectProfile.u16CmdCounter = poMessage->u16GetCmdCounter();
      disconnectProfile.u16FunctionID = poMessage->u16GetFunctionID();
      disconnectProfile.u16RegisterID = poMessage->u16GetRegisterID();
      disconnectProfile.u16SourceAppID = poMessage->u16GetSourceAppID();
      disconnectProfile.bResponse = false;
      disconnectProfile.poMethodArg = OSAL_NULL;

      if ((FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContextListSize(disconnectProfile.u16FunctionID))
            < FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE)
      {
         DeviceId deviceHandle = oFiDataObjectMethodStart.u8DeviceHandle;

         protocolList.clear();

         ETG_TRACE_USR4(("onDisconnectBluetoothProfileMethodStart:u8DeviceHandle:%d"\
               ,oFiDataObjectMethodStart.u8DeviceHandle));
         ETG_TRACE_USR4(("onDisconnectBluetoothProfileMethodStart:oServiceType.bHFP"\
               ":%d",oFiDataObjectMethodStart.oServiceType.bHFP));
         ETG_TRACE_USR4(("onDisconnectBluetoothProfileMethodStart:oServiceType.bAVP"\
               ":%d",oFiDataObjectMethodStart.oServiceType.bAVP));
         ETG_TRACE_USR4(("onDisconnectBluetoothProfileMethodStart:oServiceType.bPAN"\
               ":%d",oFiDataObjectMethodStart.oServiceType.bPAN));
         ETG_TRACE_USR4(("onDisconnectBluetoothProfileMethodStart:oServiceType.bPBAP"\
               ":%d",oFiDataObjectMethodStart.oServiceType.bPBAP));
         ETG_TRACE_USR4(("onDisconnectBluetoothProfileMethodStart:oServiceType.bMAP"\
               ":%d",oFiDataObjectMethodStart.oServiceType.bMAP));

         disconnectBluetoothProfileStruct *poDisconnectBluetoothProfile =
               OSAL_NEW disconnectBluetoothProfileStruct;

         if (poDisconnectBluetoothProfile)
         {
            poDisconnectBluetoothProfile->DBPFiDataObjectMethodStart.u8DeviceHandle = oFiDataObjectMethodStart.u8DeviceHandle;
            poDisconnectBluetoothProfile->DBPFiDataObjectMethodStart.oServiceType.bHFP = oFiDataObjectMethodStart.oServiceType.bHFP;
            poDisconnectBluetoothProfile->DBPFiDataObjectMethodStart.oServiceType.bAVP = oFiDataObjectMethodStart.oServiceType.bAVP;
            poDisconnectBluetoothProfile->DBPFiDataObjectMethodStart.oServiceType.bPAN = oFiDataObjectMethodStart.oServiceType.bPAN;
            poDisconnectBluetoothProfile->DBPFiDataObjectMethodStart.oServiceType.bPBAP = oFiDataObjectMethodStart.oServiceType.bPBAP;
            poDisconnectBluetoothProfile->DBPFiDataObjectMethodStart.oServiceType.bMAP = oFiDataObjectMethodStart.oServiceType.bMAP;
            poDisconnectBluetoothProfile->BTServiceType.bHFP = FALSE;
            poDisconnectBluetoothProfile->BTServiceType.bAVP = FALSE;
            poDisconnectBluetoothProfile->BTServiceType.bPAN = FALSE;
            poDisconnectBluetoothProfile->BTServiceType.bPBAP = FALSE;
            poDisconnectBluetoothProfile->BTServiceType.bMAP = FALSE;

            disconnectProfile.poMethodArg =
                  (disconnectBluetoothProfileStruct *) poDisconnectBluetoothProfile;

            if (oFiDataObjectMethodStart.oServiceType.bHFP)
            {
               Protocol protocol;
               protocol._protocolId = BM_PROTOCOL_ID_HFP;
               protocol._uuid = "";
               protocolList.push_back(protocol);
            }

            if (oFiDataObjectMethodStart.oServiceType.bAVP)
            {
               Protocol protocol;
               protocol._protocolId = BM_PROTOCOL_ID_AVP;
               protocol._uuid = "";
               protocolList.push_back(protocol);
            }

            if (oFiDataObjectMethodStart.oServiceType.bPAN)
            {
               Protocol protocol;
               protocol._protocolId = BM_PROTOCOL_ID_PAN;
               protocol._uuid = "";
               protocolList.push_back(protocol);
            }

            if (oFiDataObjectMethodStart.oServiceType.bPBAP)
            {
               Protocol protocol;
               protocol._protocolId = BM_PROTOCOL_ID_PBDL;
               protocol._uuid = "";
               protocolList.push_back(protocol);
            }

            if (oFiDataObjectMethodStart.oServiceType.bMAP)
            {
               Protocol protocol;
               protocol._protocolId = BM_PROTOCOL_ID_MSG;
               protocol._uuid = "";
               protocolList.push_back(protocol);
            }

            if(_bluetoothApp)
            {
               FC_Bluetooth_CCAMethodQueue::poGetInstance()->PushMethodContext(disconnectProfile.u16FunctionID,
                     disconnectProfile);
               _bluetoothApp->getBmCoreRequestIf().disconnectProfiles(deviceHandle, protocolList);
            }
         }
         else
         {
            ETG_TRACE_ERR(("onDisconnectBluetoothProfileMethodStart: poFiDataObjectMethodStart is Null"));
            sendMethodError(disconnectProfile.u16FunctionID, disconnectProfile, most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
         }
      }
      else
      {
         ETG_TRACE_ERR(("onDisconnectBluetoothProfileMethodStart:  Queue size is more than %d",
               FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE));
         sendMethodError(disconnectProfile.u16FunctionID, disconnectProfile,
               most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
      }
   }
   else
   {
      ETG_TRACE_ERR(("onDisconnectBluetoothProfileMethodStart: OSAL GetData() failed"));
      vPostError(oVisitorMsg);
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::onSendPairingRequestMethodStart(amt_tclServiceData* poMessage)
{
   (tVoid) poMessage;
   ENTRY

   Job sendPairingRequest;
   most_btsetfi_tclMsgSendPairingRequestMethodStart oFiDataObjectMethodStart;

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   if (oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
      sendPairingRequest.u16CmdCounter = poMessage->u16GetCmdCounter();
      sendPairingRequest.u16FunctionID = poMessage->u16GetFunctionID();
      sendPairingRequest.u16RegisterID = poMessage->u16GetRegisterID();
      sendPairingRequest.u16SourceAppID = poMessage->u16GetSourceAppID();
      sendPairingRequest.poMethodArg = OSAL_NULL;
      sendPairingRequest.bResponse = false;

      if((FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContextListSize(sendPairingRequest.u16FunctionID))
            < FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE)
      {
         BdAddress bdAddress = static_cast<char*>(oFiDataObjectMethodStart.sRemoteDeviceAddress.szValue);

         ETG_TRACE_USR4(("onSendPairingRequestMethodStart: PairingRequest: %d",oFiDataObjectMethodStart.bPairingRequest));
         ETG_TRACE_USR4(("onSendPairingRequestMethodStart: device address: %s",bdAddress.c_str()));

         FC_Bluetooth_CCAMethodQueue::poGetInstance()->PushMethodContext(sendPairingRequest.u16FunctionID,
               sendPairingRequest);

         // Start Pairing to the remote device if bPairingRequest is true
         if (oFiDataObjectMethodStart.bPairingRequest)
         {
            if(_bluetoothApp)
            {
               _bluetoothApp->getBmCoreRequestIf().startPairing(bdAddress);
            }
         }
         // Cancel Pairing to the remote device if bPairingRequest is false
         else
         {
            if(_bluetoothApp)
            {
               _bluetoothApp->getBmCoreRequestIf().cancelPairing();
            }
         }
      }
      else
      {
         ETG_TRACE_ERR(("onSendPairingRequestMethodStart: Queue size is more than %d",
               FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE));
         sendMethodError(sendPairingRequest.u16FunctionID, sendPairingRequest,
               most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
      }
   }
   else
   {
      ETG_TRACE_ERR(("onSendPairingRequestMethodStart: OSAL GetData() failed"));
      vPostError(oVisitorMsg);
   }

   oFiDataObjectMethodStart.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::OnPlayRingtoneMethodStart(amt_tclServiceData* poMessage)
{
   ENTRY

   fi_tclVisitorMessage oVisitorMsg(poMessage);
   most_btsetfi_tclMsgPlayRingtoneMethodStart oFiDataObjectMethodStart;
   Job playRingtone;

   if (oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
      playRingtone.u16SourceAppID = poMessage->u16GetSourceAppID();
      playRingtone.u16RegisterID = poMessage->u16GetRegisterID();
      playRingtone.u16CmdCounter = poMessage->u16GetCmdCounter();
      playRingtone.u16FunctionID = poMessage->u16GetFunctionID();
      playRingtone.poMethodArg = OSAL_NULL;
      playRingtone.bResponse = false;

      ETG_TRACE_USR1((" OnPlayRingtoneMethodStart::u16RingtoneID :: %u",oFiDataObjectMethodStart.u16RingtoneID));
      ETG_TRACE_USR1((" OnPlayRingtoneMethodStart::u8LogicalAVChannel :: %u",oFiDataObjectMethodStart.u8LogicalAVChannel));

      if (oFiDataObjectMethodStart.u16RingtoneID >= 2 && oFiDataObjectMethodStart.u16RingtoneID <= 11)
      {
         _playRingtone.u16SourceAppID = playRingtone.u16SourceAppID;
         _playRingtone.u16RegisterID = playRingtone.u16RegisterID;
         _playRingtone.u16CmdCounter = playRingtone.u16CmdCounter;
         _playRingtone.u16FunctionID = playRingtone.u16FunctionID;
         _playRingtone.poMethodArg = OSAL_NULL;
         _playRingtone.bResponse = false;

         if (_bIsRingtonePlaying == true)
         {
            tU16 u16RingtoneID = oAvailableRingtoneList.vGetPlayRingtoneID();

            if(u16RingtoneID != oFiDataObjectMethodStart.u16RingtoneID)
            {
               oAvailableRingtoneList.vSetPlayRingtoneID(oFiDataObjectMethodStart.u16RingtoneID);

               ETG_TRACE_USR4(("OnPlayRingtoneMethodStart: Stop the previously playing ringtone"));
               stopRingTone();

               _bIsRingtonePlaying = false;

               ETG_TRACE_USR4(("OnPlayRingtoneMethodStart: Play the newly selected ringtone"));
               playRingTone();
            }
            else
            {
               ETG_TRACE_USR4(("OnPlayRingtoneMethodStart: ringtone is already playing"));
               PlayRingtoneMethodResult(_playRingtone);
            }
         }
         else
         {
            oAvailableRingtoneList.vSetPlayRingtoneID(oFiDataObjectMethodStart.u16RingtoneID);
            FC_Bluetooth_tclAudioRouting::poGetInstance()->vTriggerARLAudio(FC_BLUETOOTH_AUDIOCHANNEL_MONORINGTONE);
            ETG_TRACE_USR4(("OnPlayRingtoneMethodStart:Bt Audio is triggered"));
         }
      }
      else if ((oFiDataObjectMethodStart.u16RingtoneID == INCOMING_CALL_RINGTONE_ID) ||
            (oFiDataObjectMethodStart.u16RingtoneID == VOLUME_SLIDING_RINGTONE_ID))
      {
         //Set the ringtone id to invalid so that vehicle ringtone can be played
         oAvailableRingtoneList.vSetPlayRingtoneID(oFiDataObjectMethodStart.u16RingtoneID);

         _playRingtone.u16SourceAppID = playRingtone.u16SourceAppID;
         _playRingtone.u16RegisterID = playRingtone.u16RegisterID;
         _playRingtone.u16CmdCounter = playRingtone.u16CmdCounter;
         _playRingtone.u16FunctionID = playRingtone.u16FunctionID;
         _playRingtone.poMethodArg = OSAL_NULL;
         _playRingtone.bResponse = false;

         if (_bIsRingtonePlaying == true)
         {
            ETG_TRACE_USR4((" OnPlayRingtoneMethodStart: Stop the previously playing ringtone, when incoming call is received !"));
            stopRingTone();
            _bIsRingtonePlaying = false;
            playRingTone();
         }
         else
         {
            FC_Bluetooth_tclAudioRouting::poGetInstance()->vTriggerARLAudio(FC_BLUETOOTH_AUDIOCHANNEL_MONORINGTONE);
            ETG_TRACE_USR4(("OnPlayRingtoneMethodStart: Bt Audio is triggered"));
         }
      }
      else
      {
         ETG_TRACE_ERR(("  OnPlayRingtoneMethodStart - CCA_C_U16_ERROR_PARAMETER_OUT_OF_RANGE"));
         sendMethodError(playRingtone.u16FunctionID, playRingtone,
               most_fi_tcl_e8_ErrorCode::FI_EN_PARAMETERWRONG_OUTOFRANGE);
      }
   }
   else
   {
      ETG_TRACE_ERR(("OnPlayRingtoneMethodStart: OSAL GetData() failed"));
      vPostError(oVisitorMsg);
   }

   oFiDataObjectMethodStart.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::OnStopRingtoneMethodStart(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("OnStopRingtoneMethodStart: Entered"));

   fi_tclVisitorMessage oVisitorMsg(poMessage);
   most_btsetfi_tclMsgStopRingtoneMethodStart oFiDataObjectMethodStart;
   Job StopRingtone;

   if (oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION)
         != OSAL_ERROR)
   {
      StopRingtone.u16SourceAppID = poMessage->u16GetSourceAppID();
      StopRingtone.u16RegisterID = poMessage->u16GetRegisterID();
      StopRingtone.u16CmdCounter = poMessage->u16GetCmdCounter();
      StopRingtone.u16FunctionID = poMessage->u16GetFunctionID();
      StopRingtone.poMethodArg = OSAL_NULL;
      StopRingtone.bResponse = false;

      if (TRUE == _bIsStopRingtoneinProgress)
      {
         ETG_TRACE_USR4(("Stop ringtone is already in Progress."));
         sendMethodError(StopRingtone.u16FunctionID, StopRingtone, most_fi_tcl_e8_ErrorCode::FI_EN_BUSY);
      }
      else
      {
         if(_bIsRingtonePlaying  == true)
         {
            ETG_TRACE_USR4(("Ringtone is currently playing. Hence can be stopped."));
            _bIsStopRingtoneinProgress = TRUE;
            FC_Bluetooth_tclAudioRouting::poGetInstance()->
                  vTriggerARLAudioDeallocation(FC_BLUETOOTH_AUDIOCHANNEL_MONORINGTONE);

            _stopRingtone.u16SourceAppID = StopRingtone.u16SourceAppID;
            _stopRingtone.u16RegisterID = StopRingtone.u16RegisterID;
            _stopRingtone.u16CmdCounter = StopRingtone.u16CmdCounter;
            _stopRingtone.u16FunctionID = StopRingtone.u16FunctionID;
            _stopRingtone.poMethodArg = OSAL_NULL;
            _stopRingtone.bResponse = false;
         }
         else
         {
            ETG_TRACE_USR4(("Ringtone is not playing. Hence sending the method result immediately."));
            StopRingtoneMethodResult(StopRingtone, true);
         }
      }
   }
   else
   {
      ETG_TRACE_ERR(("OnStopRingtoneMethodStart: OSAL GetData() failed"));
      vPostError(oVisitorMsg);
   }

   oFiDataObjectMethodStart.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::OnRequestAvailableRingtonesListMethodStart(amt_tclServiceData* poMessage)
{
   ENTRY

   Job RequestAvailableRingtonesList;
   tBool bInbandSupported = FALSE;
   RingtoneId ringtoneId = DEFAULT_RINGTONE_ID;
   BmResult result = BM_RESULT_ERR_GENERAL;

   most_btsetfi_tclMsgRequestAvailableRingtonesListMethodStart oFiDataObjectMethodStart;

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   if (oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
      RequestAvailableRingtonesList.u16SourceAppID = poMessage->u16GetSourceAppID();
      RequestAvailableRingtonesList.u16RegisterID = poMessage->u16GetRegisterID();
      RequestAvailableRingtonesList.u16CmdCounter = poMessage->u16GetCmdCounter();
      RequestAvailableRingtonesList.u16FunctionID = poMessage->u16GetFunctionID();
      RequestAvailableRingtonesList.poMethodArg = OSAL_NULL;
      RequestAvailableRingtonesList.bResponse = false;

      ETG_TRACE_USR1((" OnRequestAvailableRingtonesListMethodStart::u8DeviceHandle :: %u",\
            oFiDataObjectMethodStart.u8DeviceHandle));

      if(true == _bmCoreConfiguration._systemWideRingtoneEnabled)
      {
         if(_bluetoothApp)
         {
            result = _bluetoothApp->getBmCoreRequestIf().readSystemWideRingtoneIdFromDb(ringtoneId);

            if (BM_RESULT_OK == result)
            {
               ETG_TRACE_USR4(("OnRequestAvailableRingtonesListMethodStart: ringtoneId in the database = %d", ringtoneId));

               if((ringtoneId == -1) || (ringtoneId == RINGTONE_INBAND_RINGTONEID))
               {
                  result = GetInbandRingtoneSupport(bInbandSupported, oFiDataObjectMethodStart.u8DeviceHandle);

                  if(result == BM_RESULT_OK)
                  {
                     if(_u16SystemWideRingtone == RINGTONE_INBAND_RINGTONEID)
                     {
                        if(bInbandSupported == true)
                        {
                           ringtoneId = RINGTONE_INBAND_RINGTONEID;
                        }
                        else
                        {
                           ringtoneId = DEFAULT_RINGTONE_ID;
                        }
                     }
                     else
                     {
                        ringtoneId = _u16SystemWideRingtone;
                     }
                  }
               }
            }
         }
      }
      else
      {
         if(_bluetoothApp)
         {
            result = _bluetoothApp->getBmCoreRequestIf().readDeviceRingtoneIdFromDb(ringtoneId, oFiDataObjectMethodStart.u8DeviceHandle);

            if (BM_RESULT_OK == result)
            {
               ETG_TRACE_USR4(("OnRequestAvailableRingtonesListMethodStart: ringtoneId in the database = %d", ringtoneId));

               if((ringtoneId == -1) || (ringtoneId == RINGTONE_INBAND_RINGTONEID))
               {
                  result = GetInbandRingtoneSupport(bInbandSupported, oFiDataObjectMethodStart.u8DeviceHandle);

                  if(result == BM_RESULT_OK)
                  {
                     if(bInbandSupported == true)
                     {
                        ringtoneId = RINGTONE_INBAND_RINGTONEID;
                     }
                     else
                     {
                        ringtoneId = DEFAULT_RINGTONE_ID;
                     }
                  }
               }
            }
         }
      }

      if (BM_RESULT_OK == result)
      {
         ETG_TRACE_USR4(("OnRequestAvailableRingtonesListMethodStart: ringtoneId = %d", ringtoneId));

         tU16 u16RingtoneID = (tU16)ringtoneId;

         most_btsetfi_tclMsgRequestAvailableRingtonesListMethodResult oFiDataObjectMethodResult;

         std::string szRingtoneName = "";

         oAvailableRingtoneList.vPrintStatus();

         //refresh the list from the directory
         oAvailableRingtoneList.vRequestRefreshRingToneList();

         for (tU16 i = FC_BLUETOOTH_CCASERVICE_ZERO; i < oAvailableRingtoneList.u16GetNumberOfRingTones(); i++)
         {
            //populate the ringtone list
            most_fi_tcl_BTSetRingtoneListItem oRingToneItem;

            oFiDataObjectMethodResult.oRingtoneList.oItems.push_back(oRingToneItem);

            most_fi_tcl_BTSetRingtoneListItem& roLastRingToneItem = oFiDataObjectMethodResult.oRingtoneList.oItems.back();

            roLastRingToneItem.u16RingtoneID = oAvailableRingtoneList.u16GetRingToneID(i);

            oAvailableRingtoneList.vGetRingtoneName(i, szRingtoneName);

            if (0 == strcasecmp(szRingtoneName.c_str(), "RingtoneA"))
            {
               szRingtoneName = "Ringtone A";
               ETG_TRACE_USR4(("szRingtoneName::%s",szRingtoneName.c_str()));
            }
            else if (0 == strcasecmp(szRingtoneName.c_str(), "RingtoneB"))
            {
               szRingtoneName = "Ringtone B";
               ETG_TRACE_USR4(("szRingtoneName::%s",szRingtoneName.c_str()));
            }
            else
            {
               ETG_TRACE_USR4(("szRingtoneName::%s",szRingtoneName.c_str()));
            }

            roLastRingToneItem.sRingtoneName.bSet(szRingtoneName.c_str());
            ETG_TRACE_USR1(("OnRequestAvailableRingtonesListMethodStart: Availb RingtoneName %s",\
                  roLastRingToneItem.sRingtoneName.szGet(most_fi_tcl_String::FI_EN_UTF8) ));

            roLastRingToneItem.bPlayRingtoneAvailable = oAvailableRingtoneList.bIsPlayRingtoneAvailable(i);
            roLastRingToneItem.bRingtoneAvailable = oAvailableRingtoneList.bIsRingtoneAvailable(bInbandSupported, i);
            roLastRingToneItem.bActiveRingtone = oAvailableRingtoneList.bIsActiveRingtone(u16RingtoneID, i);
         }

         // Create FI VisitorMessage.
         fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodResult, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

         vInitServiceData(oVisitorMsgOutput, RequestAvailableRingtonesList.u16SourceAppID, RequestAvailableRingtonesList.u16RegisterID,
               RequestAvailableRingtonesList.u16CmdCounter, RequestAvailableRingtonesList.u16FunctionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

         // Post the message
         ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

         if (AIL_EN_N_NO_ERROR != ailResult)
         {
            // fatal error, because a server can post in all use cases
            ETG_TRACE_ERR(("enPostMessage failed for FunctionID: %d, with Result: %d",\
                  RequestAvailableRingtonesList.u16FunctionID, ailResult));
         }
         else
         {
            ETG_TRACE_USR1((" OnRequestAvailableRingtonesListMethodStart::MR sent successfully"));
         }

         // Destroy the (Message related) FI data object (output)
         oFiDataObjectMethodResult.vDestroy();
      }
      else
      {
         ETG_TRACE_ERR(("OnRequestAvailableRingtonesListMethodStart: read RingtoneIdFromDb func return error:%d", result));
      }
   }
   else
   {
      ETG_TRACE_ERR(("OnRequestAvailableRingtonesListMethodStart: OSAL GetData() failed"));
      vPostError(oVisitorMsg);
   }

   oFiDataObjectMethodStart.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::OnRequestDeviceRingtonesListMethodStart(amt_tclServiceData* poMessage)
{
   ENTRY

   ETG_TRACE_USR1((" OnRequestDeviceRingtonesListMethodStart entered"));

   fi_tclVisitorMessage oVisitorMsg(poMessage);
   most_btsetfi_tclMsgRequestDeviceRingtoneListMethodStart oFiDataObjectMethodStart;
   Job RequestDeviceRingtonesList;
   RingtoneId ringtoneId = DEFAULT_RINGTONE_ID;
   BmResult result = BM_RESULT_ERR_GENERAL;
   std::string szRingtoneName = "";

   if (oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
      RequestDeviceRingtonesList.u16SourceAppID = poMessage->u16GetSourceAppID();
      RequestDeviceRingtonesList.u16RegisterID = poMessage->u16GetRegisterID();
      RequestDeviceRingtonesList.u16CmdCounter = poMessage->u16GetCmdCounter();
      RequestDeviceRingtonesList.u16FunctionID = poMessage->u16GetFunctionID();

      most_btsetfi_tclMsgRequestDeviceRingtoneListMethodResult oFiDataObjectMethodResult;

      if(true == _bmCoreConfiguration._systemWideRingtoneEnabled)
      {
         if(_bluetoothApp)
         {
            result = _bluetoothApp->getBmCoreRequestIf().readSystemWideRingtoneIdFromDb(ringtoneId);
         }

         if (BM_RESULT_OK == result)
         {
            ETG_TRACE_USR4(("OnRequestDeviceRingtonesListMethodStart: ringtoneId in the Database = %d", ringtoneId));

            if(ringtoneId == -1)
            {
               ringtoneId = _u16SystemWideRingtone;
            }

            ETG_TRACE_USR4(("OnRequestDeviceRingtonesListMethodStart: ringtoneId = %d", ringtoneId));

            most_fi_tcl_BTSetDeviceRingtoneListResultItem oDeviceRingtoneListResultItem;

            oFiDataObjectMethodResult.oDeviceRingtoneListResult.oItems.push_back(oDeviceRingtoneListResultItem);

            most_fi_tcl_BTSetDeviceRingtoneListResultItem& oLastRingtoneItem = oFiDataObjectMethodResult.oDeviceRingtoneListResult.oItems.back();

            oLastRingtoneItem.u8DeviceHandle = FC_BLUETOOTH_CCASERVICE_ZERO;
            oLastRingtoneItem.u16RingtoneID = (tU16)ringtoneId;

            oAvailableRingtoneList.vGetRingtoneName((tU16)(ringtoneId  - 1), szRingtoneName);

            if (0 == strcasecmp(szRingtoneName.c_str(), "RingtoneA"))
            {
               szRingtoneName = "Ringtone A";
               ETG_TRACE_USR4(("szRingtoneName::%s",szRingtoneName.c_str()));
            }
            else if (0 == strcasecmp(szRingtoneName.c_str(), "RingtoneB"))
            {
               szRingtoneName = "Ringtone B";
               ETG_TRACE_USR4(("szRingtoneName::%s",szRingtoneName.c_str()));
            }
            else
            {
               ETG_TRACE_USR4(("szRingtoneName::%s",szRingtoneName.c_str()));
            }

            oLastRingtoneItem.sRingtoneName.bSet(szRingtoneName.c_str());

            ETG_TRACE_USR1(("OnRequestDeviceRingtonesListMethodStart: Availb RingtoneName %s",\
                  oLastRingtoneItem.sRingtoneName.szGet(most_fi_tcl_String::FI_EN_UTF8) ));
         }
         else
         {
            ETG_TRACE_ERR(("OnRequestDeviceRingtonesListMethodStart: readSystemWideRingtoneIdFromDb func return error:%d", result));
         }
      }
      else
      {
         PairedDeviceList pairedDeviceList;
         vGetPairedDeviceList(pairedDeviceList);

         if(FC_BLUETOOTH_CCASERVICE_ZERO != pairedDeviceList._deviceBaseInfoList.size())
         {
            for (std::list<DeviceBaseInfo>::const_iterator it = pairedDeviceList._deviceBaseInfoList.begin();
                     it != pairedDeviceList._deviceBaseInfoList.end(); it++)
            {
               if(_bluetoothApp)
               {
                  result = _bluetoothApp->getBmCoreRequestIf().readDeviceRingtoneIdFromDb(ringtoneId, it->_deviceHandle);
               }

               if (BM_RESULT_OK == result)
               {
                  ETG_TRACE_USR4(("OnRequestDeviceRingtonesListMethodStart: ringtoneId in the Database = %d", ringtoneId));

                  if(ringtoneId == -1)
                  {
                     tBool bInbandSupported = FALSE;
                     result = GetInbandRingtoneSupport(bInbandSupported, (tU8)it->_deviceHandle);

                     if(result == BM_RESULT_OK)
                     {
                        if(bInbandSupported == true)
                        {
                           ringtoneId = RINGTONE_INBAND_RINGTONEID;
                        }
                        else
                        {
                           ringtoneId = DEFAULT_RINGTONE_ID;
                        }
                     }
                  }

                  if(result == BM_RESULT_OK)
                  {
                     ETG_TRACE_USR4(("OnRequestDeviceRingtonesListMethodStart: ringtoneId = %d", ringtoneId));

                     most_fi_tcl_BTSetDeviceRingtoneListResultItem oDeviceRingtoneListResultItem;

                     oFiDataObjectMethodResult.oDeviceRingtoneListResult.oItems.push_back(oDeviceRingtoneListResultItem);

                     most_fi_tcl_BTSetDeviceRingtoneListResultItem& oLastRingtoneItem = oFiDataObjectMethodResult.oDeviceRingtoneListResult.oItems.back();

                     oLastRingtoneItem.u8DeviceHandle = (tU8)it->_deviceHandle;
                     oLastRingtoneItem.u16RingtoneID = (tU16)ringtoneId;
                     oLastRingtoneItem.sDeviceName.bSet(it->_bdName.c_str());

                     oAvailableRingtoneList.vGetRingtoneName((tU16)(ringtoneId  - 1), szRingtoneName);

                     if (0 == strcasecmp(szRingtoneName.c_str(), "RingtoneA"))
                     {
                        szRingtoneName = "Ringtone A";
                        ETG_TRACE_USR4(("szRingtoneName::%s",szRingtoneName.c_str()));
                     }
                     else if (0 == strcasecmp(szRingtoneName.c_str(), "RingtoneB"))
                     {
                        szRingtoneName = "Ringtone B";
                        ETG_TRACE_USR4(("szRingtoneName::%s",szRingtoneName.c_str()));
                     }
                     else
                     {
                        ETG_TRACE_USR4(("szRingtoneName::%s",szRingtoneName.c_str()));
                     }

                     oLastRingtoneItem.sRingtoneName.bSet(szRingtoneName.c_str());

                     ETG_TRACE_USR1(("OnRequestDeviceRingtonesListMethodStart: Availb RingtoneName %s",\
                           oLastRingtoneItem.sRingtoneName.szGet(most_fi_tcl_String::FI_EN_UTF8) ));
                  }
               }
               else
               {
                  ETG_TRACE_ERR(("OnRequestDeviceRingtonesListMethodStart: readDeviceRingtoneIdFromDb func return error:%d", result));
               }
            }
         }
      }

      // Create FI VisitorMessage.
      fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodResult, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

      vInitServiceData(oVisitorMsgOutput, RequestDeviceRingtonesList.u16SourceAppID, RequestDeviceRingtonesList.u16RegisterID,
            RequestDeviceRingtonesList.u16CmdCounter, RequestDeviceRingtonesList.u16FunctionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post the message
      ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

      if (AIL_EN_N_NO_ERROR != ailResult)
      {
         // fatal error, because a server can post in all use cases
         ETG_TRACE_ERR(("enPostMessage failed for FunctionID: %d, with Result: %d",\
               RequestDeviceRingtonesList.u16FunctionID, ailResult));
      }

      // Destroy the (Message related) FI data object (output)
      oFiDataObjectMethodResult.vDestroy();
   }
   else
   {
      ETG_TRACE_ERR(("OnRequestDeviceRingtonesListMethodStart: OSAL GetData() failed"));
      vPostError(oVisitorMsg);
   }

   oFiDataObjectMethodStart.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::OnConnectSPPServiceMethodStart(amt_tclServiceData* poMessage)
{
   (tVoid) poMessage;
   ENTRY
   Job connectSPPService;
   ProtocolList protocolList;

   most_btsetfi_tclMsgConnectSPPServiceMethodStart oFiDataObjectMethodStart;

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   connectSPPService.u16CmdCounter = poMessage->u16GetCmdCounter();
   connectSPPService.u16FunctionID = poMessage->u16GetFunctionID();
   connectSPPService.u16RegisterID = poMessage->u16GetRegisterID();
   connectSPPService.u16SourceAppID = poMessage->u16GetSourceAppID();
   connectSPPService.bResponse = false;
   connectSPPService.poMethodArg = OSAL_NULL;

   if (oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
      if ((FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContextListSize(CONNECTPROFILE_METHOD_FKTID))
            < FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE)
      {
         DeviceId deviceHandle = oFiDataObjectMethodStart.u8DeviceHandle;

         protocolList.clear();

         ETG_TRACE_USR4(("OnConnectSPPServiceMethodStart:u8DeviceHandle:%d",oFiDataObjectMethodStart.u8DeviceHandle));

         ETG_TRACE_USR4(("OnConnectSPPServiceMethodStart:UUID:%s",oFiDataObjectMethodStart.szUUID.szValue));

         Uuid uuid(oFiDataObjectMethodStart.szUUID.szGet());

         Protocol protocol;
         protocol._protocolId = BM_PROTOCOL_ID_SPP;
         protocol._uuid = uuid;
         protocolList.push_back(protocol);

         if(_bluetoothApp)
         {
            FC_Bluetooth_CCAMethodQueue::poGetInstance()->PushMethodContext(CONNECTPROFILE_METHOD_FKTID, connectSPPService);
            _bluetoothApp->getBmCoreRequestIf().connectProfiles(deviceHandle, protocolList);
         }
      }
      else
      {
         ETG_TRACE_ERR(("OnConnectSPPServiceMethodStart:  Queue size is more than %d",
               FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE));
         sendMethodError(connectSPPService.u16FunctionID, connectSPPService,
               most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
      }
   }
   else
   {
      ETG_TRACE_ERR(("OnConnectSPPServiceMethodStart: OSAL GetData() failed"));
      vPostError(oVisitorMsg);
   }

   oFiDataObjectMethodStart.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::OnStartAutoConnectSequenceMethodStart(amt_tclServiceData* poMessage)
{
   ENTRY

   fi_tclVisitorMessage oVisitorMsg(poMessage);
   most_btsetfi_tclMsgStartAutoConnectSequenceMethodStart oFiDataObjectMethodStart;
   Job startAutoConnect;
   PairedDeviceList pairedDeviceList;

   if (oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
      startAutoConnect.u16SourceAppID = poMessage->u16GetSourceAppID();
      startAutoConnect.u16RegisterID = poMessage->u16GetRegisterID();
      startAutoConnect.u16CmdCounter = poMessage->u16GetCmdCounter();
      startAutoConnect.u16FunctionID = poMessage->u16GetFunctionID();
      startAutoConnect.poMethodArg = OSAL_NULL;
      startAutoConnect.bResponse = false;

      ETG_TRACE_USR2(("OnStartAutoConnectSequenceMethodStart:bStartAutoConnect - %d",  oFiDataObjectMethodStart.bStartAutoConnect));

      if(TRUE == oFiDataObjectMethodStart.bStartAutoConnect)
      {
         //TODO
         vGetPairedDeviceList(pairedDeviceList);

         if(pairedDeviceList._deviceBaseInfoList.size() == FC_BLUETOOTH_CCASERVICE_ZERO)
         {
            ETG_TRACE_ERR(("OnStartAutoConnectSequenceMethodStart: no Paired device is available"));
            sendMethodError(startAutoConnect.u16FunctionID, startAutoConnect, most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
         }
         else
         {
            if(_bluetoothApp)
            {
               FC_Bluetooth_CCAMethodQueue::poGetInstance()->PushMethodContext(startAutoConnect.u16FunctionID, startAutoConnect);
               _bluetoothApp->getBmCoreRequestIf().startAutoConnectSequence(BM_TEMPORARY_AUTO_CONNECTION_LAST_CONNECTED_DEVICES);
            }
         }
      }
      else
      {
         if(_bluetoothApp)
         {
            FC_Bluetooth_CCAMethodQueue::poGetInstance()->PushMethodContext(startAutoConnect.u16FunctionID, startAutoConnect);
            _bluetoothApp->getBmCoreRequestIf().stopAutoConnectSequence();
         }
      }
   }
   else
   {
      ETG_TRACE_ERR(("OnStartAutoConnectSequenceMethodStart: OSAL GetData() failed"));
      vPostError(oVisitorMsg);
   }

   oFiDataObjectMethodStart.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::OnSwitchBTLocalModeMethodStart(amt_tclServiceData* poMessage)
{
   ENTRY

   fi_tclVisitorMessage oVisitorMsg(poMessage);
   most_btsetfi_tclMsgSwitchBTLocalModeMethodStart oFiDataObjectMethodStart;
   Job switchBTLocalMode;
   TargetSwitchState targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_OFF;

   if (oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
      switchBTLocalMode.u16SourceAppID = poMessage->u16GetSourceAppID();
      switchBTLocalMode.u16RegisterID = poMessage->u16GetRegisterID();
      switchBTLocalMode.u16CmdCounter = poMessage->u16GetCmdCounter();
      switchBTLocalMode.u16FunctionID = poMessage->u16GetFunctionID();
      switchBTLocalMode.poMethodArg = OSAL_NULL;
      switchBTLocalMode.bResponse = false;

      if ((FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContextListSize(CONNECTPROFILE_METHOD_FKTID))
            < FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE)
      {
         ETG_TRACE_USR2(("OnSwitchBTLocalModeMethodStart:BT Address - %s" , oFiDataObjectMethodStart.sBTAddress.szValue));
         ETG_TRACE_USR2(("OnSwitchBTLocalModeMethodStart:Pairable mode - %d", oFiDataObjectMethodStart.Pairable.enType));
         ETG_TRACE_USR2(("OnSwitchBTLocalModeMethodStart:Connectable mode - %d", oFiDataObjectMethodStart.Connectable.enType));

         tU8 u8localPairable = m_u8Pairable;
         tU8 u8localConnectable = m_u8Connectable;
         BdAddress bdAddress = static_cast<char*>(oFiDataObjectMethodStart.sBTAddress.szValue);

         m_u8Pairable = oFiDataObjectMethodStart.Pairable.enType;
         m_u8Connectable = oFiDataObjectMethodStart.Connectable.enType;

         _bdAAPAddress = bdAddress;

         if(m_u8Pairable != BT_LOCALMODE_AUTO)
         {
            u8localPairable = m_u8Pairable;

            if(u8localPairable == BT_LOCALMODE_ON)
            {
               oFiDataObjectMethodStart.Pairable.enType = most_fi_tcl_BTLocalModeType::FI_EN_E8ON;
            }
            else
            {
               oFiDataObjectMethodStart.Pairable.enType = most_fi_tcl_BTLocalModeType::FI_EN_E8OFF;
            }
         }

         if(m_u8Connectable != BT_LOCALMODE_AUTO)
         {
            u8localConnectable = m_u8Connectable;

            if(u8localConnectable == BT_LOCALMODE_ON)
            {
               oFiDataObjectMethodStart.Connectable.enType = most_fi_tcl_BTLocalModeType::FI_EN_E8ON;
            }
            else
            {
               oFiDataObjectMethodStart.Connectable.enType = most_fi_tcl_BTLocalModeType::FI_EN_E8OFF;
            }
         }

         // Sends the Method Error if Pairable is ON and Connectable Mode is OFF
         if((most_fi_tcl_BTLocalModeType::FI_EN_E8ON == oFiDataObjectMethodStart.Pairable.enType) &&
               (most_fi_tcl_BTLocalModeType::FI_EN_E8OFF == oFiDataObjectMethodStart.Connectable.enType))
         {
            ETG_TRACE_ERR(("OnSwitchBTLocalModeMethodStart: invalid configuration"));
            sendMethodError(switchBTLocalMode.u16FunctionID, switchBTLocalMode, most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
         }
         else
         {
            most_btsetfi_tclMsgSwitchBTLocalModeMethodStart *poFiDataObjectMethodStart =
                  OSAL_NEW most_btsetfi_tclMsgSwitchBTLocalModeMethodStart;

            if (poFiDataObjectMethodStart)
            {
               poFiDataObjectMethodStart->sBTAddress.bSet(_bdAAPAddress.c_str());
               poFiDataObjectMethodStart->Pairable.enType = oFiDataObjectMethodStart.Pairable.enType;
               poFiDataObjectMethodStart->Connectable.enType = oFiDataObjectMethodStart.Connectable.enType;

               switchBTLocalMode.poMethodArg =
                     (most_btsetfi_tclMsgSwitchBTLocalModeMethodStart *) poFiDataObjectMethodStart;

               if(u8localPairable == BT_LOCALMODE_ON)
               {
                  targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_ON;
               }
               else
               {
                  targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_OFF;
               }

               if(_bluetoothApp)
               {
                  FC_Bluetooth_CCAMethodQueue::poGetInstance()->PushMethodContext(ADDNEWDEVICE_METHOD_FKTID, switchBTLocalMode);
                  _bluetoothApp->getBmCoreRequestIf().switchLocalPairableMode(targetSwitchState, bdAddress);
               }

               if(u8localConnectable == BT_LOCALMODE_ON)
               {
                  targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_ON;
               }
               else
               {
                  targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_OFF;
               }

               if(_bluetoothApp)
               {
                  _bluetoothApp->getBmCoreRequestIf().switchLocalConnectableMode(targetSwitchState, bdAddress);
               }

            }
            else
            {
               ETG_TRACE_ERR(("OnSwitchBTLocalModeMethodStart: poFiDataObjectMethodStart is Null"));
               sendMethodError(switchBTLocalMode.u16FunctionID, switchBTLocalMode, most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
            }
         }
      }
      else
      {
         ETG_TRACE_ERR(("OnSwitchBTLocalModeMethodStart:  Queue size is more than %d",
               FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE));
         sendMethodError(switchBTLocalMode.u16FunctionID, switchBTLocalMode,
               most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
      }
   }
   else
   {
      ETG_TRACE_ERR(("OnSwitchBTLocalModeMethodStart: OSAL GetData() failed"));
      vPostError(oVisitorMsg);
   }

   oFiDataObjectMethodStart.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::OnSetBTLimitationModeMethodStart(amt_tclServiceData* poMessage)
{
   ENTRY

   fi_tclVisitorMessage oVisitorMsg(poMessage);
   most_btsetfi_tclMsgSetBluetoothLimitationModeMethodStart oFiDataObjectMethodStart;
   Job setBTLimitationMode;

   if (oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
      ETG_TRACE_USR2(("OnSetBTLimitationModeMethodStart:BT Address - %s" , oFiDataObjectMethodStart.sBdAddress.szValue));
      ETG_TRACE_USR2(("OnSetBTLimitationModeMethodStart:BT Name - %s" , oFiDataObjectMethodStart.sBdDeviceName.szValue));
      ETG_TRACE_USR2(("OnSetBTLimitationModeMethodStart:e8Technology - %d", oFiDataObjectMethodStart.e8Technology.enType));
      ETG_TRACE_USR2(("OnSetBTLimitationModeMethodStart:e8CommunicationChannel - %d", oFiDataObjectMethodStart.e8CommunicationChannel.enType));
      ETG_TRACE_USR2(("OnSetBTLimitationModeMethodStart:e8Action - %d", oFiDataObjectMethodStart.e8Action.enType));

      setBTLimitationMode.u16SourceAppID = poMessage->u16GetSourceAppID();
      setBTLimitationMode.u16RegisterID = poMessage->u16GetRegisterID();
      setBTLimitationMode.u16CmdCounter = poMessage->u16GetCmdCounter();
      setBTLimitationMode.u16FunctionID = poMessage->u16GetFunctionID();
      setBTLimitationMode.poMethodArg = OSAL_NULL;
      setBTLimitationMode.bResponse = false;

      LimitationMode limitationMode;
      LimitationAction limitationAction;
      BdAddress bdAddress = static_cast<char*>(oFiDataObjectMethodStart.sBdAddress.szValue);
      BdName bdName = static_cast<char*>(oFiDataObjectMethodStart.sBdDeviceName.szValue);

      MapLimitationFeatureToInternal(limitationMode._limitationFeature, oFiDataObjectMethodStart.e8Technology);

      MapLimitationCommunicationIfToInternal(limitationMode._limitationCommunicationIf,
            oFiDataObjectMethodStart.e8CommunicationChannel);

      MapLimitationActionToInternal(limitationAction, oFiDataObjectMethodStart.e8Action);

      if(_bluetoothApp)
      {
         FC_Bluetooth_CCAMethodQueue::poGetInstance()->PushMethodContext(setBTLimitationMode.u16FunctionID, setBTLimitationMode);
         _bluetoothApp->getBmCoreRequestIf().setBtLimitationMode(bdAddress, bdName, limitationMode, limitationAction);
      }
   }
   else
   {
      ETG_TRACE_ERR(("OnSetBTLimitationModeMethodStart: OSAL GetData() failed"));
      vPostError(oVisitorMsg);
   }

   oFiDataObjectMethodStart.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::OnChangeWifiTransmitPowerMethodStart(amt_tclServiceData* poMessage)
{
   ENTRY

   fi_tclVisitorMessage oVisitorMsg(poMessage);
   most_btsetfi_tclMsgChangeWifiTransmitPowerMethodStart oFiDataObjectMethodStart;
   Job changeWifiTransmitPower;
   CmdData result;
   char cmdstr[BD_CMD_STRING_LEN];

   if (oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
      ETG_TRACE_USR2(("OnChangeWifiTransmitPowerMethodStart:attenuate value - %d" , oFiDataObjectMethodStart.u8WiFiPowerAttenuation));

      changeWifiTransmitPower.u16SourceAppID = poMessage->u16GetSourceAppID();
      changeWifiTransmitPower.u16RegisterID = poMessage->u16GetRegisterID();
      changeWifiTransmitPower.u16CmdCounter = poMessage->u16GetCmdCounter();
      changeWifiTransmitPower.u16FunctionID = poMessage->u16GetFunctionID();
      changeWifiTransmitPower.poMethodArg = OSAL_NULL;
      changeWifiTransmitPower.bResponse = false;

      memset(cmdstr, FC_BLUETOOTH_CCASERVICE_ZERO, BD_CMD_STRING_LEN);
      snprintf(cmdstr, BD_CMD_STRING_LEN, "%d", oFiDataObjectMethodStart.u8WiFiPowerAttenuation);

      result = execRootCommand(FC_BT_ROOTDAEMON_CLIENT_NAME, SET_WIFI_TX_PWR, cmdstr);

      if(result.errorNo == ERR_NONE)
      {
         ChangeWifiTransmitPowerMethodResult(changeWifiTransmitPower, true);
      }
      else
      {
         ETG_TRACE_USR2(("OnChangeWifiTransmitPowerMethodStart: errorNo - %d" , result.errorNo));
         sendMethodError(changeWifiTransmitPower.u16FunctionID, changeWifiTransmitPower, most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
      }
   }
   else
   {
      ETG_TRACE_ERR(("OnChangeWifiTransmitPowerMethodStart: OSAL GetData() failed"));
      vPostError(oVisitorMsg);
   }

   oFiDataObjectMethodStart.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::OnDisconnectSPPServiceMethodStart(amt_tclServiceData* poMessage)
{
   (tVoid) poMessage;
   ENTRY
   Job disconnectSPPService;
   ProtocolList protocolList;

   most_btsetfi_tclMsgDisconnectSPPServiceMethodStart oFiDataObjectMethodStart;

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   disconnectSPPService.u16CmdCounter = poMessage->u16GetCmdCounter();
   disconnectSPPService.u16FunctionID = poMessage->u16GetFunctionID();
   disconnectSPPService.u16RegisterID = poMessage->u16GetRegisterID();
   disconnectSPPService.u16SourceAppID = poMessage->u16GetSourceAppID();
   disconnectSPPService.bResponse = false;
   disconnectSPPService.poMethodArg = OSAL_NULL;

   if (oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
      if ((FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContextListSize(DISCONNECTPROFILE_METHOD_FKTID))
            < FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE)
      {
         DeviceId deviceHandle = oFiDataObjectMethodStart.u8DeviceHandle;

         protocolList.clear();

         ETG_TRACE_USR4(("OnDisconnectSPPServiceMethodStart:u8DeviceHandle:%d",oFiDataObjectMethodStart.u8DeviceHandle));

         ETG_TRACE_USR4(("OnDisconnectSPPServiceMethodStart:UUID:%s",oFiDataObjectMethodStart.szUUID.szValue));

         Uuid uuid(oFiDataObjectMethodStart.szUUID.szGet());

         Protocol protocol;
         protocol._protocolId = BM_PROTOCOL_ID_SPP;
         protocol._uuid = uuid;
         protocolList.push_back(protocol);

         if(_bluetoothApp)
         {
            FC_Bluetooth_CCAMethodQueue::poGetInstance()->PushMethodContext(DISCONNECTPROFILE_METHOD_FKTID, disconnectSPPService);
            _bluetoothApp->getBmCoreRequestIf().disconnectProfiles(deviceHandle, protocolList);
         }
      }
      else
      {
         ETG_TRACE_ERR(("OnDisconnectSPPServiceMethodStart:  Queue size is more than %d",
               FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE));
         sendMethodError(disconnectSPPService.u16FunctionID, disconnectSPPService,
               most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
      }
   }
   else
   {
      ETG_TRACE_ERR(("OnConnectSPPServiceMethodStart: OSAL GetData() failed"));
      vPostError(oVisitorMsg);
   }

   oFiDataObjectMethodStart.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::OnStartSearchSPPServicesMethodStart(amt_tclServiceData* poMessage)
{
   (tVoid) poMessage;
   ENTRY
   Job startSearchSPPService;
   ProtocolList protocolList;

   most_btsetfi_tclMsgStartSearchSPPServicesMethodStart oFiDataObjectMethodStart;

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   startSearchSPPService.u16CmdCounter = poMessage->u16GetCmdCounter();
   startSearchSPPService.u16FunctionID = poMessage->u16GetFunctionID();
   startSearchSPPService.u16RegisterID = poMessage->u16GetRegisterID();
   startSearchSPPService.u16SourceAppID = poMessage->u16GetSourceAppID();
   startSearchSPPService.bResponse = false;
   startSearchSPPService.poMethodArg = OSAL_NULL;

   if (oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
      if ((FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContextListSize(startSearchSPPService.u16FunctionID))
            < FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE)
      {
         DeviceId deviceHandle = oFiDataObjectMethodStart.u8DeviceHandle;

         ETG_TRACE_USR4(("OnStartSearchSPPServicesMethodStart:u8DeviceHandle - %d bPeriodicSearch - %d",
               oFiDataObjectMethodStart.u8DeviceHandle, oFiDataObjectMethodStart.bPeriodicSearch));

         if(_bluetoothApp)
         {
            FC_Bluetooth_CCAMethodQueue::poGetInstance()->PushMethodContext(startSearchSPPService.u16FunctionID, startSearchSPPService);
            _bluetoothApp->getBmCoreRequestIf().startServiceSearch(deviceHandle);
         }
      }
      else
      {
         ETG_TRACE_ERR(("OnStartSearchSPPServicesMethodStart:  Queue size is more than %d",
               FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE));
         sendMethodError(startSearchSPPService.u16FunctionID, startSearchSPPService,
               most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
      }
   }
   else
   {
      ETG_TRACE_ERR(("OnStartSearchSPPServicesMethodStart: OSAL GetData() failed"));
      vPostError(oVisitorMsg);
   }

   oFiDataObjectMethodStart.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::OnStopSearchSPPServicesMethodStart(amt_tclServiceData* poMessage)
{
   (tVoid) poMessage;
   ENTRY
   Job stopSearchSPPService;

   most_btsetfi_tclMsgStopSearchSPPServicesMethodStart oFiDataObjectMethodStart;

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   stopSearchSPPService.u16CmdCounter = poMessage->u16GetCmdCounter();
   stopSearchSPPService.u16FunctionID = poMessage->u16GetFunctionID();
   stopSearchSPPService.u16RegisterID = poMessage->u16GetRegisterID();
   stopSearchSPPService.u16SourceAppID = poMessage->u16GetSourceAppID();
   stopSearchSPPService.bResponse = false;
   stopSearchSPPService.poMethodArg = OSAL_NULL;

   if (oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
      if ((FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContextListSize(stopSearchSPPService.u16FunctionID))
            < FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE)
      {
         DeviceId deviceHandle = oFiDataObjectMethodStart.u8DeviceHandle;

         ETG_TRACE_USR4(("OnStopSearchSPPServicesMethodStart:u8DeviceHandle - %d, u8SearchHandle - %d",
               oFiDataObjectMethodStart.u8DeviceHandle, oFiDataObjectMethodStart.u8SearchHandle));

         if(_bluetoothApp)
         {
            FC_Bluetooth_CCAMethodQueue::poGetInstance()->PushMethodContext(stopSearchSPPService.u16FunctionID, stopSearchSPPService);
            _bluetoothApp->getBmCoreRequestIf().stopServiceSearch(deviceHandle);
         }
      }
      else
      {
         ETG_TRACE_ERR(("OnStopSearchSPPServicesMethodStart:  Queue size is more than %d",
               FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE));
         sendMethodError(stopSearchSPPService.u16FunctionID, stopSearchSPPService,
               most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
      }
   }
   else
   {
      ETG_TRACE_ERR(("OnStopSearchSPPServicesMethodStart: OSAL GetData() failed"));
      vPostError(oVisitorMsg);
   }

   oFiDataObjectMethodStart.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::OnAddOobPairedDeviceMethodStart(amt_tclServiceData* poMessage)
{
   (tVoid) poMessage;
   ENTRY
   Job addOobPairedDevice;

   most_btsetfi_tclMsgAddOobPairedDeviceMethodStart oFiDataObjectMethodStart;

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   addOobPairedDevice.u16CmdCounter = poMessage->u16GetCmdCounter();
   addOobPairedDevice.u16FunctionID = poMessage->u16GetFunctionID();
   addOobPairedDevice.u16RegisterID = poMessage->u16GetRegisterID();
   addOobPairedDevice.u16SourceAppID = poMessage->u16GetSourceAppID();
   addOobPairedDevice.bResponse = false;
   addOobPairedDevice.poMethodArg = OSAL_NULL;

   if (oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
      if ((FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContextListSize(addOobPairedDevice.u16FunctionID))
            < FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE)
      {
         ETG_TRACE_USR2(("OnAddOobPairedDeviceMethodStart:BT Address - %s" , oFiDataObjectMethodStart.sBdAddress.szValue));
         ETG_TRACE_USR2(("OnAddOobPairedDeviceMethodStart:sLinkKey - %s", oFiDataObjectMethodStart.sBdName.szValue));
         ETG_TRACE_USR2(("OnAddOobPairedDeviceMethodStart:sBdName - %s", oFiDataObjectMethodStart.sLinkKey.szValue));
         ETG_TRACE_USR2(("OnAddOobPairedDeviceMethodStart:e8OobType - %d", oFiDataObjectMethodStart.e8OobType.enType));

         BdAddress bdAddress(oFiDataObjectMethodStart.sBdAddress.szGet());
         BdName bdName(oFiDataObjectMethodStart.sBdName.szGet());
         LinkKey linkKey(oFiDataObjectMethodStart.sLinkKey.szGet());
         OobType oobType;

         MapOobTypeToInternal(oobType, oFiDataObjectMethodStart.e8OobType);

         if(_bluetoothApp)
         {
            FC_Bluetooth_CCAMethodQueue::poGetInstance()->PushMethodContext(addOobPairedDevice.u16FunctionID, addOobPairedDevice);
            _bluetoothApp->getBmCoreRequestIf().addOobPairedDevice(bdAddress, bdName, linkKey, oobType);
         }
      }
      else
      {
         ETG_TRACE_ERR(("OnAddOobPairedDeviceMethodStart:  Queue size is more than %d",
               FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE));
         sendMethodError(addOobPairedDevice.u16FunctionID, addOobPairedDevice,
               most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
      }
   }
   else
   {
      ETG_TRACE_ERR(("OnAddOobPairedDeviceMethodStart: OSAL GetData() failed"));
      vPostError(oVisitorMsg);
   }

   oFiDataObjectMethodStart.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::OnSetFavoriteMethodStart(amt_tclServiceData* poMessage)
{
   (tVoid) poMessage;
   ENTRY
   Job setFavorite;

   most_btsetfi_tclMsgSetFavoriteMethodStart oFiDataObjectMethodStart;

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   setFavorite.u16CmdCounter = poMessage->u16GetCmdCounter();
   setFavorite.u16FunctionID = poMessage->u16GetFunctionID();
   setFavorite.u16RegisterID = poMessage->u16GetRegisterID();
   setFavorite.u16SourceAppID = poMessage->u16GetSourceAppID();
   setFavorite.bResponse = false;
   setFavorite.poMethodArg = OSAL_NULL;

   if (oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
      if ((FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContextListSize(setFavorite.u16FunctionID))
            < FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE)
      {
         ETG_TRACE_USR2(("OnSetFavoriteMethodStart:u8DeviceHandle - %d" , oFiDataObjectMethodStart.u8DeviceHandle));
         ETG_TRACE_USR2(("OnSetFavoriteMethodStart:e8FavoriteType - %d", oFiDataObjectMethodStart.e8FavoriteType.enType));
         ETG_TRACE_USR2(("OnSetFavoriteMethodStart:u8FavoriteIndex - %d", oFiDataObjectMethodStart.u8FavoriteIndex));

         DeviceId deviceHandle = oFiDataObjectMethodStart.u8DeviceHandle;
         FavoriteType favoriteType;

         MapFavoriteTypeToInternal(favoriteType, oFiDataObjectMethodStart.e8FavoriteType);

         if(_bluetoothApp)
         {
            FC_Bluetooth_CCAMethodQueue::poGetInstance()->PushMethodContext(setFavorite.u16FunctionID, setFavorite);
            _bluetoothApp->getBmCoreRequestIf().setFavorite(deviceHandle, favoriteType, oFiDataObjectMethodStart.u8FavoriteIndex);
         }
      }
      else
      {
         ETG_TRACE_ERR(("OnSetFavoriteMethodStart:  Queue size is more than %d",
               FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE));
         sendMethodError(setFavorite.u16FunctionID, setFavorite,
               most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
      }
   }
   else
   {
      ETG_TRACE_ERR(("OnSetFavoriteMethodStart: OSAL GetData() failed"));
      vPostError(oVisitorMsg);
   }

   oFiDataObjectMethodStart.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::OnClearFavoriteMethodStart(amt_tclServiceData* poMessage)
{
   (tVoid) poMessage;
   ENTRY
   Job clearFavorite;

   most_btsetfi_tclMsgClearFavoriteMethodStart oFiDataObjectMethodStart;

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   clearFavorite.u16CmdCounter = poMessage->u16GetCmdCounter();
   clearFavorite.u16FunctionID = poMessage->u16GetFunctionID();
   clearFavorite.u16RegisterID = poMessage->u16GetRegisterID();
   clearFavorite.u16SourceAppID = poMessage->u16GetSourceAppID();
   clearFavorite.bResponse = false;
   clearFavorite.poMethodArg = OSAL_NULL;

   if (oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
      if ((FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContextListSize(clearFavorite.u16FunctionID))
            < FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE)
      {
         ETG_TRACE_USR2(("OnClearFavoriteMethodStart:u8DeviceHandle - %d" , oFiDataObjectMethodStart.u8DeviceHandle));
         ETG_TRACE_USR2(("OnClearFavoriteMethodStart:e8FavoriteType - %d", oFiDataObjectMethodStart.e8FavoriteType.enType));

         DeviceId deviceHandle = oFiDataObjectMethodStart.u8DeviceHandle;
         FavoriteType favoriteType;

         MapFavoriteTypeToInternal(favoriteType, oFiDataObjectMethodStart.e8FavoriteType);

         if(_bluetoothApp)
         {
            FC_Bluetooth_CCAMethodQueue::poGetInstance()->PushMethodContext(clearFavorite.u16FunctionID, clearFavorite);
            _bluetoothApp->getBmCoreRequestIf().clearFavorite(deviceHandle, favoriteType);
         }
      }
      else
      {
         ETG_TRACE_ERR(("OnClearFavoriteMethodStart:  Queue size is more than %d",
               FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE));
         sendMethodError(clearFavorite.u16FunctionID, clearFavorite,
               most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
      }
   }
   else
   {
      ETG_TRACE_ERR(("OnClearFavoriteMethodStart: OSAL GetData() failed"));
      vPostError(oVisitorMsg);
   }

   oFiDataObjectMethodStart.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::OnSwitchMultiHFPSupportMethodStart(amt_tclServiceData* poMessage)
{
   (tVoid) poMessage;
   ENTRY
   Job switchMultiHFPSupport;
   TargetSwitchState targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_OFF;

   most_btsetfi_tclMsgSwitchMultiHFPSupportMethodStart oFiDataObjectMethodStart;

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   switchMultiHFPSupport.u16CmdCounter = poMessage->u16GetCmdCounter();
   switchMultiHFPSupport.u16FunctionID = poMessage->u16GetFunctionID();
   switchMultiHFPSupport.u16RegisterID = poMessage->u16GetRegisterID();
   switchMultiHFPSupport.u16SourceAppID = poMessage->u16GetSourceAppID();
   switchMultiHFPSupport.bResponse = false;
   switchMultiHFPSupport.poMethodArg = OSAL_NULL;

   if (oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
      if ((FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContextListSize(switchMultiHFPSupport.u16FunctionID))
            < FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE)
      {
         ETG_TRACE_USR2(("OnSwitchMultiHFPSupportMethodStart:bMultiHFPSupport - %d", oFiDataObjectMethodStart.bMultiHFPSupport));

         if(oFiDataObjectMethodStart.bMultiHFPSupport == TRUE)
         {
            targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_ON;
         }
         else
         {
            targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_OFF;
         }

         if(_bluetoothApp)
         {
            FC_Bluetooth_CCAMethodQueue::poGetInstance()->PushMethodContext(switchMultiHFPSupport.u16FunctionID, switchMultiHFPSupport);
            _bluetoothApp->getBmCoreRequestIf().switchMultiHFPSupport(targetSwitchState);
         }
      }
      else
      {
         ETG_TRACE_ERR(("OnSwitchMultiHFPSupportMethodStart:  Queue size is more than %d",
               FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE));
         sendMethodError(switchMultiHFPSupport.u16FunctionID, switchMultiHFPSupport,
               most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
      }
   }
   else
   {
      ETG_TRACE_ERR(("OnSwitchMultiHFPSupportMethodStart: OSAL GetData() failed"));
      vPostError(oVisitorMsg);
   }

   oFiDataObjectMethodStart.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::OnSetPrimaryMethodStart(amt_tclServiceData* poMessage)
{
   (tVoid) poMessage;
   ENTRY
   Job setPrimary;

   most_btsetfi_tclMsgSetPrimaryMethodStart oFiDataObjectMethodStart;

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   setPrimary.u16CmdCounter = poMessage->u16GetCmdCounter();
   setPrimary.u16FunctionID = poMessage->u16GetFunctionID();
   setPrimary.u16RegisterID = poMessage->u16GetRegisterID();
   setPrimary.u16SourceAppID = poMessage->u16GetSourceAppID();
   setPrimary.bResponse = false;
   setPrimary.poMethodArg = OSAL_NULL;

   if (oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
      if ((FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContextListSize(setPrimary.u16FunctionID))
            < FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE)
      {
         ETG_TRACE_USR2(("OnSetPrimaryMethodStart:u8DeviceHandle - %d" , oFiDataObjectMethodStart.u8DeviceHandle));

         DeviceId deviceHandle = oFiDataObjectMethodStart.u8DeviceHandle;

         if(_bluetoothApp)
         {
            FC_Bluetooth_CCAMethodQueue::poGetInstance()->PushMethodContext(setPrimary.u16FunctionID, setPrimary);
            _bluetoothApp->getBmCoreRequestIf().setPrimaryHfpDevice(deviceHandle);
         }
      }
      else
      {
         ETG_TRACE_ERR(("OnSetPrimaryMethodStart:  Queue size is more than %d",
               FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE));
         sendMethodError(setPrimary.u16FunctionID, setPrimary,
               most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
      }
   }
   else
   {
      ETG_TRACE_ERR(("OnSetPrimaryMethodStart: OSAL GetData() failed"));
      vPostError(oVisitorMsg);
   }

   oFiDataObjectMethodStart.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::OnSetBtPrfoilesUsageMethodStart(amt_tclServiceData* poMessage)
{
   (tVoid) poMessage;
   ENTRY
   Job setBTProfilesUsage;

   most_btsetfi_tclMsgSetBTProfilesUsageMethodStart oFiDataObjectMethodStart;

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   setBTProfilesUsage.u16CmdCounter = poMessage->u16GetCmdCounter();
   setBTProfilesUsage.u16FunctionID = poMessage->u16GetFunctionID();
   setBTProfilesUsage.u16RegisterID = poMessage->u16GetRegisterID();
   setBTProfilesUsage.u16SourceAppID = poMessage->u16GetSourceAppID();
   setBTProfilesUsage.bResponse = false;
   setBTProfilesUsage.poMethodArg = OSAL_NULL;

   if (oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
      if ((FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContextListSize(setBTProfilesUsage.u16FunctionID))
            < FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE)
      {
         if(FC_BLUETOOTH_CCASERVICE_ZERO != oFiDataObjectMethodStart.oBTProfilesUsageInfoList.oItems.size())
         {
            ProfileUsageList profileUsageInfoList;

            for (size_t index = 0; index < oFiDataObjectMethodStart.oBTProfilesUsageInfoList.oItems.size(); index++)
            {
               ETG_TRACE_USR2(("OnSetBtPrfoilesUsageMethodStart:oItems[index].u8DeviceHandle - %d" ,
                     oFiDataObjectMethodStart.oBTProfilesUsageInfoList.oItems[index].u8DeviceHandle));
               ETG_TRACE_USR2(("OnSetBtPrfoilesUsageMethodStart:oItems[index].oBTProfilesUsageInfo.e8BTProfile - %d" ,
                     oFiDataObjectMethodStart.oBTProfilesUsageInfoList.oItems[index].oBTProfilesUsageInfo.e8BTProfile.enType));
               ETG_TRACE_USR2(("OnSetBtPrfoilesUsageMethodStart:oItems[index].oBTProfilesUsageInfo.sUUID - %s" ,
                     oFiDataObjectMethodStart.oBTProfilesUsageInfoList.oItems[index].oBTProfilesUsageInfo.sUUID.szValue));
               ETG_TRACE_USR2(("OnSetBtPrfoilesUsageMethodStart:oItems[index].oBTProfilesUsageInfo.e8BTProfileUsageType - %d" ,
                     oFiDataObjectMethodStart.oBTProfilesUsageInfoList.oItems[index].oBTProfilesUsageInfo.e8BTProfileUsageType.enType));
               ETG_TRACE_USR2(("OnSetBtPrfoilesUsageMethodStart:oItems[index].oBTProfilesUsageInfo.bInUse - %d" ,
                     oFiDataObjectMethodStart.oBTProfilesUsageInfoList.oItems[index].oBTProfilesUsageInfo.bInUse));

               ProfileUsageInfo profileUsageInfo;
               Uuid uuid(oFiDataObjectMethodStart.oBTProfilesUsageInfoList.oItems[index].oBTProfilesUsageInfo.sUUID.szGet());

               profileUsageInfo._deviceHandle = oFiDataObjectMethodStart.oBTProfilesUsageInfoList.oItems[index].u8DeviceHandle;
               profileUsageInfo._InUse = oFiDataObjectMethodStart.oBTProfilesUsageInfoList.oItems[index].oBTProfilesUsageInfo.bInUse;

               MapBTProfileToInternal(profileUsageInfo._protocol, oFiDataObjectMethodStart.oBTProfilesUsageInfoList.oItems[index].oBTProfilesUsageInfo.e8BTProfile, uuid);

               MapProfileUsageTypeToInternal(profileUsageInfo._ProfileUsageType, oFiDataObjectMethodStart.oBTProfilesUsageInfoList.oItems[index].oBTProfilesUsageInfo.e8BTProfileUsageType);

               profileUsageInfoList._btProfileUsageInfoList.push_back(profileUsageInfo);
            }

            if(_bluetoothApp)
            {
               FC_Bluetooth_CCAMethodQueue::poGetInstance()->PushMethodContext(setBTProfilesUsage.u16FunctionID, setBTProfilesUsage);
               _bluetoothApp->getBmCoreRequestIf().setBtProfileUsageInfo(profileUsageInfoList);
            }
         }
         else
         {
            ETG_TRACE_ERR(("OnSetBtPrfoilesUsageMethodStart:  Methodstart list is empty"));
            sendMethodError(setBTProfilesUsage.u16FunctionID, setBTProfilesUsage,
                  most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
         }
      }
      else
      {
         ETG_TRACE_ERR(("OnSetBtPrfoilesUsageMethodStart:  Queue size is more than %d",
               FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE));
         sendMethodError(setBTProfilesUsage.u16FunctionID, setBTProfilesUsage,
               most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
      }
   }
   else
   {
      ETG_TRACE_ERR(("OnSetBtPrfoilesUsageMethodStart: OSAL GetData() failed"));
      vPostError(oVisitorMsg);
   }

   oFiDataObjectMethodStart.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::OnResolveConflictsMethodStart(amt_tclServiceData* poMessage)
{
   (tVoid) poMessage;
   ENTRY
   Job resolveConflicts;

   most_btsetfi_tclMsgResolveConflictsMethodStart oFiDataObjectMethodStart;

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   resolveConflicts.u16CmdCounter = poMessage->u16GetCmdCounter();
   resolveConflicts.u16FunctionID = poMessage->u16GetFunctionID();
   resolveConflicts.u16RegisterID = poMessage->u16GetRegisterID();
   resolveConflicts.u16SourceAppID = poMessage->u16GetSourceAppID();
   resolveConflicts.bResponse = false;
   resolveConflicts.poMethodArg = OSAL_NULL;

   if (oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
      if ((FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContextListSize(resolveConflicts.u16FunctionID))
            < FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE)
      {
         ETG_TRACE_USR2(("OnResolveConflictsMethodStart:e8ConflictTrigger.enType - %d",
               oFiDataObjectMethodStart.e8ConflictTrigger.enType));
         ETG_TRACE_USR2(("OnResolveConflictsMethodStart:e8ResolutionType.enType - %d" ,
               oFiDataObjectMethodStart.e8ResolutionType.enType));

         UserDecisionInfo userDecisionInfo;

         MapConflictTriggerToInternal(userDecisionInfo._conflictTrigger, oFiDataObjectMethodStart.e8ConflictTrigger);
         MapResolutionTypeToInternal(userDecisionInfo._userDecision, oFiDataObjectMethodStart.e8ResolutionType);

         if(_bluetoothApp)
         {
            FC_Bluetooth_CCAMethodQueue::poGetInstance()->PushMethodContext(resolveConflicts.u16FunctionID, resolveConflicts);
            _bluetoothApp->getBmCoreRequestIf().notifyUserDecision(userDecisionInfo);
         }
      }
      else
      {
         ETG_TRACE_ERR(("OnResolveConflictsMethodStart:  Queue size is more than %d",
               FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE));
         sendMethodError(resolveConflicts.u16FunctionID, resolveConflicts,
               most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
      }
   }
   else
   {
      ETG_TRACE_ERR(("OnResolveConflictsMethodStart: OSAL GetData() failed"));
      vPostError(oVisitorMsg);
   }

   oFiDataObjectMethodStart.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::OnSetDeviceUsagePreferenceMethodStart(amt_tclServiceData* poMessage)
{
   (tVoid) poMessage;
   ENTRY
   Job setDeviceUsagePreference;

   most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodStart oFiDataObjectMethodStart;

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   setDeviceUsagePreference.u16CmdCounter = poMessage->u16GetCmdCounter();
   setDeviceUsagePreference.u16FunctionID = poMessage->u16GetFunctionID();
   setDeviceUsagePreference.u16RegisterID = poMessage->u16GetRegisterID();
   setDeviceUsagePreference.u16SourceAppID = poMessage->u16GetSourceAppID();
   setDeviceUsagePreference.bResponse = false;
   setDeviceUsagePreference.poMethodArg = OSAL_NULL;

   if (oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
      if ((FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContextListSize(setDeviceUsagePreference.u16FunctionID))
            < FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE)
      {
         ETG_TRACE_USR2(("OnSetDeviceUsagePreferenceMethodStart:u8DeviceHandle - %d",
               oFiDataObjectMethodStart.u8DeviceHandle));
         ETG_TRACE_USR2(("OnSetDeviceUsagePreferenceMethodStart:e8DeviceUsagePreference.enType - %d" ,
               oFiDataObjectMethodStart.e8DeviceUsagePreference.enType));

         DeviceId deviceHandle = oFiDataObjectMethodStart.u8DeviceHandle;
         UsagePreference usagePreference;

         MapDeviceUsagePreferenceToInternal(usagePreference, oFiDataObjectMethodStart.e8DeviceUsagePreference);

         if(_bluetoothApp)
         {
            FC_Bluetooth_CCAMethodQueue::poGetInstance()->PushMethodContext(setDeviceUsagePreference.u16FunctionID, setDeviceUsagePreference);
            _bluetoothApp->getBmCoreRequestIf().setDeviceUsagePreference(deviceHandle, usagePreference);
         }
      }
      else
      {
         ETG_TRACE_ERR(("OnSetDeviceUsagePreferenceMethodStart:  Queue size is more than %d",
               FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE));
         sendMethodError(setDeviceUsagePreference.u16FunctionID, setDeviceUsagePreference,
               most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
      }
   }
   else
   {
      ETG_TRACE_ERR(("OnSetDeviceUsagePreferenceMethodStart: OSAL GetData() failed"));
      vPostError(oVisitorMsg);
   }

   oFiDataObjectMethodStart.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::OnSetProfileUserAvailabilityMethodStart(amt_tclServiceData* poMessage)
{
   (tVoid) poMessage;
   ENTRY
   Job setProfileUserAvailability;

   most_btsetfi_tclMsgSetProfileUserAvailabilityMethodStart oFiDataObjectMethodStart;

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   setProfileUserAvailability.u16CmdCounter = poMessage->u16GetCmdCounter();
   setProfileUserAvailability.u16FunctionID = poMessage->u16GetFunctionID();
   setProfileUserAvailability.u16RegisterID = poMessage->u16GetRegisterID();
   setProfileUserAvailability.u16SourceAppID = poMessage->u16GetSourceAppID();
   setProfileUserAvailability.bResponse = false;
   setProfileUserAvailability.poMethodArg = OSAL_NULL;

   if (oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
      if ((FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContextListSize(setProfileUserAvailability.u16FunctionID))
            < FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE)
      {
         ETG_TRACE_USR2(("OnSetProfileUserAvailabilityMethodStart:e8Protocol.enType - %d",
               oFiDataObjectMethodStart.e8Profile.enType));
         ETG_TRACE_USR2(("OnSetProfileUserAvailabilityMethodStart:e8UserAvailable.enType - %d" ,
               oFiDataObjectMethodStart.e8UserAvailable.enType));

         Protocol protocol;
         Uuid uuid = "";
         bool available = false;

         MapBTProfileToInternal(protocol, oFiDataObjectMethodStart.e8Profile, uuid);
         MapBTUserAvailabilityToInternal(available, oFiDataObjectMethodStart.e8UserAvailable);

         if(_bluetoothApp)
         {
            FC_Bluetooth_CCAMethodQueue::poGetInstance()->PushMethodContext(setProfileUserAvailability.u16FunctionID, setProfileUserAvailability);
            _bluetoothApp->getBmCoreRequestIf().setProtocolUserAvailability(protocol, available);
         }
      }
      else
      {
         ETG_TRACE_ERR(("OnSetProfileUserAvailabilityMethodStart:  Queue size is more than %d",
               FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE));
         sendMethodError(setProfileUserAvailability.u16FunctionID, setProfileUserAvailability,
               most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
      }
   }
   else
   {
      ETG_TRACE_ERR(("OnSetProfileUserAvailabilityMethodStart: OSAL GetData() failed"));
      vPostError(oVisitorMsg);
   }

   oFiDataObjectMethodStart.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::OnReplaceBluetoothLimitationModeMethodStart(amt_tclServiceData* poMessage)
{
   (tVoid) poMessage;
   ENTRY
   Job replaceBluetoothLimitationMode;

   most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodStart oFiDataObjectMethodStart;

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   // update the fuction ID, command counter, etc., in the job
   // set the response default as false
   replaceBluetoothLimitationMode.u16CmdCounter = poMessage->u16GetCmdCounter();
   replaceBluetoothLimitationMode.u16FunctionID = poMessage->u16GetFunctionID();
   replaceBluetoothLimitationMode.u16RegisterID = poMessage->u16GetRegisterID();
   replaceBluetoothLimitationMode.u16SourceAppID = poMessage->u16GetSourceAppID();
   replaceBluetoothLimitationMode.bResponse = false;
   replaceBluetoothLimitationMode.poMethodArg = OSAL_NULL;

   // Read the message
   if (oVisitorMsg.s32GetData(oFiDataObjectMethodStart, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
      // check the queue size. if the queue size is more than 32 then send error directly.
      if ((FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContextListSize(replaceBluetoothLimitationMode.u16FunctionID))
            < FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE)
      {
         ETG_TRACE_USR2(("OnReplaceBluetoothLimitationModeMethodStart:oLimitationModeToBeReplaced.BT Address - %s" ,
               oFiDataObjectMethodStart.oLimitationModeToBeReplaced.sBdAddress.szValue));
         ETG_TRACE_USR2(("OnReplaceBluetoothLimitationModeMethodStart:oLimitationModeToBeReplaced.BT Name - %s" ,
               oFiDataObjectMethodStart.oLimitationModeToBeReplaced.sBdDeviceName.szValue));
         ETG_TRACE_USR2(("OnReplaceBluetoothLimitationModeMethodStart:oLimitationModeToBeReplaced.e8Technology - %d",
               oFiDataObjectMethodStart.oLimitationModeToBeReplaced.e8Technology.enType));
         ETG_TRACE_USR2(("OnReplaceBluetoothLimitationModeMethodStart:oLimitationModeToBeReplaced.e8CommunicationChannel - %d",
               oFiDataObjectMethodStart.oLimitationModeToBeReplaced.e8CommunicationChannel.enType));
         ETG_TRACE_USR2(("OnReplaceBluetoothLimitationModeMethodStart:oLimitationModeToBeReplaced.e8ActionState - %d",
               oFiDataObjectMethodStart.oLimitationModeToBeReplaced.e8ActionState.enType));

         ETG_TRACE_USR2(("OnReplaceBluetoothLimitationModeMethodStart:oNewLimitationMode.BT Address - %s" ,
               oFiDataObjectMethodStart.oNewLimitationMode.sBdAddress.szValue));
         ETG_TRACE_USR2(("OnReplaceBluetoothLimitationModeMethodStart:oNewLimitationMode.BT Name - %s" ,
               oFiDataObjectMethodStart.oNewLimitationMode.sBdDeviceName.szValue));
         ETG_TRACE_USR2(("OnReplaceBluetoothLimitationModeMethodStart:oNewLimitationMode.e8Technology - %d",
               oFiDataObjectMethodStart.oNewLimitationMode.e8Technology.enType));
         ETG_TRACE_USR2(("OnReplaceBluetoothLimitationModeMethodStart:oNewLimitationMode.e8CommunicationChannel - %d",
               oFiDataObjectMethodStart.oNewLimitationMode.e8CommunicationChannel.enType));
         ETG_TRACE_USR2(("OnReplaceBluetoothLimitationModeMethodStart:oNewLimitationMode.e8Action - %d",
               oFiDataObjectMethodStart.oNewLimitationMode.e8Action.enType));

         // convert the most_fi data internally for bmcore request arguments
         // Limitation Mode to be replaced
         BtLimitationModeInfo limitationModeToBeReplaced;

         limitationModeToBeReplaced._bdAddress = static_cast<char*>(oFiDataObjectMethodStart.oLimitationModeToBeReplaced.sBdAddress.szValue);
         limitationModeToBeReplaced._bdName = static_cast<char*>(oFiDataObjectMethodStart.oLimitationModeToBeReplaced.sBdDeviceName.szValue);

         MapLimitationFeatureToInternal(limitationModeToBeReplaced._limitationMode._limitationFeature,
               oFiDataObjectMethodStart.oLimitationModeToBeReplaced.e8Technology);

         MapLimitationCommunicationIfToInternal(limitationModeToBeReplaced._limitationMode._limitationCommunicationIf,
               oFiDataObjectMethodStart.oLimitationModeToBeReplaced.e8CommunicationChannel);

         MapLimitationActionStateToInternal(limitationModeToBeReplaced._limitationState,
               oFiDataObjectMethodStart.oLimitationModeToBeReplaced.e8ActionState);

         LimitationMode limitationMode;
         LimitationAction limitationAction;
         BdAddress bdAddress = static_cast<char*>(oFiDataObjectMethodStart.oNewLimitationMode.sBdAddress.szValue);
         BdName bdName = static_cast<char*>(oFiDataObjectMethodStart.oNewLimitationMode.sBdDeviceName.szValue);

         MapLimitationFeatureToInternal(limitationMode._limitationFeature, oFiDataObjectMethodStart.oNewLimitationMode.e8Technology);

         MapLimitationCommunicationIfToInternal(limitationMode._limitationCommunicationIf,
               oFiDataObjectMethodStart.oNewLimitationMode.e8CommunicationChannel);

         MapLimitationActionToInternal(limitationAction, oFiDataObjectMethodStart.oNewLimitationMode.e8Action);

         if(_bluetoothApp)
         {
            // Push the job in the map
            FC_Bluetooth_CCAMethodQueue::poGetInstance()->PushMethodContext(replaceBluetoothLimitationMode.u16FunctionID, replaceBluetoothLimitationMode);
            _bluetoothApp->getBmCoreRequestIf().replaceBtLimitationMode(limitationModeToBeReplaced, bdAddress, bdName, limitationMode, limitationAction);
         }
      }
      else
      {
         ETG_TRACE_ERR(("OnReplaceBluetoothLimitationModeMethodStart:  Queue size is more than %d",
               FC_BLUETOOTH_SERVICE_METHOD_QUEUE_SIZE));
         sendMethodError(replaceBluetoothLimitationMode.u16FunctionID, replaceBluetoothLimitationMode,
               most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
      }
   }
   else
   {
      ETG_TRACE_ERR(("OnReplaceBluetoothLimitationModeMethodStart: OSAL GetData() failed"));
      vPostError(oVisitorMsg);
   }

   oFiDataObjectMethodStart.vDestroy();

   return;
}

/**
 * Method Result
 */
tVoid FC_Bluetooth_tclCCAService::AddNewDeviceMethodResult(Job methodcontext, const PairingStatus& btPairingStatus)
{
   ENTRY
   most_btsetfi_tclMsgAddNewDeviceMethodResult oFiDataObjectMethodResult;

   //Create the method result
   MapPairingTypeToMOST(oFiDataObjectMethodResult.e8PairingType, btPairingStatus._pairingType);

   oFiDataObjectMethodResult.sDeviceName.bSet(btPairingStatus._remoteBdName.c_str());

   oFiDataObjectMethodResult.sPinNumber.bSet(btPairingStatus._pin.c_str(), most_fi_tcl_String::FI_EN_UTF8);

   ETG_TRACE_USR1(("AddNewDeviceMethodResult: e8PairingType - %d", oFiDataObjectMethodResult.e8PairingType.enType));
   ETG_TRACE_USR1(("AddNewDeviceMethodResult: sDeviceName - %s", oFiDataObjectMethodResult.sDeviceName.szValue));
   ETG_TRACE_USR1(("AddNewDeviceMethodResult: sPinNumber - %s", oFiDataObjectMethodResult.sPinNumber.szValue));

   // Create FI VisitorMessage.
   fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodResult, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

   vInitServiceData(oVisitorMsgOutput, methodcontext.u16SourceAppID, methodcontext.u16RegisterID,
         methodcontext.u16CmdCounter, methodcontext.u16FunctionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

   // Post the message
   ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

   if (AIL_EN_N_NO_ERROR != ailResult)
   {
      // fatal error, because a server can post in all use cases
      ETG_TRACE_ERR(("AddNewDeviceMethodResult:enPostMessage failed for FunctionID: %d, with Result: %d",\
            methodcontext.u16FunctionID, ailResult));
   }

   // Destroy the (Message related) FI data object (output)
   oFiDataObjectMethodResult.vDestroy();
   return;
}

tVoid FC_Bluetooth_tclCCAService::ConnectBluetoothProfileMethodResult(Job methodcontext,
      most_btsetfi_tclMsgConnectBluetoothProfileMethodStart connectBluetoothProfileMethodStart)
{
   ENTRY
   most_btsetfi_tclMsgConnectBluetoothProfileMethodResult oFiDataObjectMethodResult;

   oFiDataObjectMethodResult.u8DeviceHandle = connectBluetoothProfileMethodStart.u8DeviceHandle;

   oFiDataObjectMethodResult.oProfileConnectionStatus.bHFP = connectBluetoothProfileMethodStart.oServiceType.bHFP;
   oFiDataObjectMethodResult.oProfileConnectionStatus.bAVP = connectBluetoothProfileMethodStart.oServiceType.bAVP;
   oFiDataObjectMethodResult.oProfileConnectionStatus.bPAN = connectBluetoothProfileMethodStart.oServiceType.bPAN;
   oFiDataObjectMethodResult.oProfileConnectionStatus.bPBAP = connectBluetoothProfileMethodStart.oServiceType.bPBAP;
   oFiDataObjectMethodResult.oProfileConnectionStatus.bMAP = connectBluetoothProfileMethodStart.oServiceType.bMAP;

   ETG_TRACE_USR1(("ConnectBluetoothProfileMethodResult: u8DeviceHandle - %d", oFiDataObjectMethodResult.u8DeviceHandle));
   ETG_TRACE_USR1(("ConnectBluetoothProfileMethodResult: bHFP - %d", oFiDataObjectMethodResult.oProfileConnectionStatus.bHFP));
   ETG_TRACE_USR1(("ConnectBluetoothProfileMethodResult: bAVP - %d", oFiDataObjectMethodResult.oProfileConnectionStatus.bAVP));
   ETG_TRACE_USR1(("ConnectBluetoothProfileMethodResult: bPAN - %d", oFiDataObjectMethodResult.oProfileConnectionStatus.bPAN));
   ETG_TRACE_USR1(("ConnectBluetoothProfileMethodResult: bPBAP - %d", oFiDataObjectMethodResult.oProfileConnectionStatus.bPBAP));
   ETG_TRACE_USR1(("ConnectBluetoothProfileMethodResult: bMAP - %d", oFiDataObjectMethodResult.oProfileConnectionStatus.bMAP));

   // Create FI VisitorMessage.
   fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodResult, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

   vInitServiceData(oVisitorMsgOutput, methodcontext.u16SourceAppID, methodcontext.u16RegisterID,
         methodcontext.u16CmdCounter, methodcontext.u16FunctionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

   // Post the message
   ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

   if (AIL_EN_N_NO_ERROR != ailResult)
   {
      // fatal error, because a server can post in all use cases
      ETG_TRACE_ERR(("enPostMessage failed for FunctionID: %d, with Result: %d",\
            methodcontext.u16FunctionID, ailResult));
   }

   // Destroy the (Message related) FI data object (output)
   oFiDataObjectMethodResult.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::DisconnectBluetoothProfileMethodResult(Job methodcontext,
      most_btsetfi_tclMsgDisconnectBluetoothProfileMethodStart disconnectBluetoothProfileMethodStart)
{
   ENTRY
   most_btsetfi_tclMsgDisconnectBluetoothProfileMethodResult oFiDataObjectMethodResult;

   oFiDataObjectMethodResult.u8DeviceHandle = disconnectBluetoothProfileMethodStart.u8DeviceHandle;

   oFiDataObjectMethodResult.oProfileDisconnectionStatus.bHFP = disconnectBluetoothProfileMethodStart.oServiceType.bHFP;
   oFiDataObjectMethodResult.oProfileDisconnectionStatus.bAVP = disconnectBluetoothProfileMethodStart.oServiceType.bAVP;
   oFiDataObjectMethodResult.oProfileDisconnectionStatus.bPAN = disconnectBluetoothProfileMethodStart.oServiceType.bPAN;
   oFiDataObjectMethodResult.oProfileDisconnectionStatus.bPBAP = disconnectBluetoothProfileMethodStart.oServiceType.bPBAP;
   oFiDataObjectMethodResult.oProfileDisconnectionStatus.bMAP = disconnectBluetoothProfileMethodStart.oServiceType.bMAP;

   ETG_TRACE_USR1(("DisconnectBluetoothProfileMethodResult: u8DeviceHandle - %d", oFiDataObjectMethodResult.u8DeviceHandle));
   ETG_TRACE_USR1(("DisconnectBluetoothProfileMethodResult: bHFP - %d", oFiDataObjectMethodResult.oProfileDisconnectionStatus.bHFP));
   ETG_TRACE_USR1(("DisconnectBluetoothProfileMethodResult: bAVP - %d", oFiDataObjectMethodResult.oProfileDisconnectionStatus.bAVP));
   ETG_TRACE_USR1(("DisconnectBluetoothProfileMethodResult: bPAN - %d", oFiDataObjectMethodResult.oProfileDisconnectionStatus.bPAN));
   ETG_TRACE_USR1(("DisconnectBluetoothProfileMethodResult: bPBAP - %d", oFiDataObjectMethodResult.oProfileDisconnectionStatus.bPBAP));
   ETG_TRACE_USR1(("DisconnectBluetoothProfileMethodResult: bMAP - %d", oFiDataObjectMethodResult.oProfileDisconnectionStatus.bMAP));

   // Create FI VisitorMessage.
   fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodResult, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

   vInitServiceData(oVisitorMsgOutput, methodcontext.u16SourceAppID, methodcontext.u16RegisterID,
         methodcontext.u16CmdCounter, methodcontext.u16FunctionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

   // Post the message
   ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

   if (AIL_EN_N_NO_ERROR != ailResult)
   {
      // fatal error, because a server can post in all use cases
      ETG_TRACE_ERR(("enPostMessage failed for FunctionID: %d, with Result: %d",\
            methodcontext.u16FunctionID, ailResult));
   }

   // Destroy the (Message related) FI data object (output)
   oFiDataObjectMethodResult.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::ChangeDeviceStateMethodResult(Job methodcontext, most_fi_tcl_e8_BTSetConnectionResult e8_BTSetConnectionResult, tBool bReplaceDeviceRequired)
{
   ENTRY

   most_btsetfi_tclMsgChangeDeviceStateMethodResult oFiDataObjectMethodResult;

   //Create the method result
   //TODO
   if(bReplaceDeviceRequired == TRUE)
   {
      oFiDataObjectMethodResult.bReplaceDeviceRequired = TRUE;
   }
   else
   {
      oFiDataObjectMethodResult.bReplaceDeviceRequired = FALSE;
   }

   oFiDataObjectMethodResult.e8ConnectionResult = e8_BTSetConnectionResult;

   ETG_TRACE_USR1(("ChangeDeviceStateMethodResult: e8ConnectionResult - %d",\
         oFiDataObjectMethodResult.e8ConnectionResult.enType));

   // Create FI VisitorMessage.
   fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodResult, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

   vInitServiceData(oVisitorMsgOutput, methodcontext.u16SourceAppID, methodcontext.u16RegisterID,
         methodcontext.u16CmdCounter, methodcontext.u16FunctionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

   // Post the message
   ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

   if (AIL_EN_N_NO_ERROR != ailResult)
   {
      // fatal error, because a server can post in all use cases
      ETG_TRACE_ERR(("enPostMessage failed for FunctionID: %d, with Result: %d",\
            methodcontext.u16FunctionID, ailResult));
   }

   // Destroy the (Message related) FI data object (output)
   oFiDataObjectMethodResult.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::PairingResponseMethodResult(Job methodcontext, PairingResult result)
{
   ENTRY
   most_btsetfi_tclMsgPairingResponseMethodResult oFiDataObjectMethodResult;

   //Create the method result
   MapPairingStatusTypeToMOST(oFiDataObjectMethodResult.e8PairingStatusType, result);

   ETG_TRACE_USR1(("PairingResponseMethodResult: e8PairingStatusType - %d",\
            oFiDataObjectMethodResult.e8PairingStatusType.enType));

   // Create FI VisitorMessage.
   fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodResult, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

   vInitServiceData(oVisitorMsgOutput, methodcontext.u16SourceAppID, methodcontext.u16RegisterID,
         methodcontext.u16CmdCounter, methodcontext.u16FunctionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

   // Post the message
   ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

   if (AIL_EN_N_NO_ERROR != ailResult)
   {
      // fatal error, because a server can post in all use cases
      ETG_TRACE_ERR(("enPostMessage failed for FunctionID: %d, with Result: %d",\
            methodcontext.u16FunctionID, ailResult));
   }

   // Destroy the (Message related) FI data object (output)
   oFiDataObjectMethodResult.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::SwitchBluetoothOnOffExtendedMethodResult(Job methodcontext, SwitchState switchState)
{
   ENTRY

   most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodResult oFiDataObjectMethodResult;

   ETG_TRACE_USR1(("SwitchBluetoothOnOffExtendedMethodResult: _switchState - %d",switchState));

   //Create the method result
   if(switchState)
   {
      oFiDataObjectMethodResult.bBTOnOffResult = TRUE;
   }
   else
   {
      oFiDataObjectMethodResult.bBTOnOffResult = FALSE;
   }

   ETG_TRACE_USR1(("SwitchBluetoothOnOffExtendedMethodResult: bBTOnOffResult - %d",\
         oFiDataObjectMethodResult.bBTOnOffResult));

   // Create FI VisitorMessage.
   fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodResult, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

   vInitServiceData(oVisitorMsgOutput, methodcontext.u16SourceAppID, methodcontext.u16RegisterID,
         methodcontext.u16CmdCounter, methodcontext.u16FunctionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

   // Post the message
   ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

   if (AIL_EN_N_NO_ERROR != ailResult)
   {
      // fatal error, because a server can post in all use cases
      ETG_TRACE_ERR(("enPostMessage failed for FunctionID: %d, with Result: %d",methodcontext.u16FunctionID, ailResult));
   }

   // Destroy the (Message related) FI data object (output)
   oFiDataObjectMethodResult.vDestroy();
   return;
}

tVoid FC_Bluetooth_tclCCAService::SendPairingRequestMethodResult(Job methodcontext, const PairingStatus& btPairingStatus, BmResult result)
{
   ENTRY

   most_btsetfi_tclMsgSendPairingRequestMethodResult oFiDataObjectMethodResult;

   //Create the method result
   if(result == BM_RESULT_OK)
   {
      MapSetPairingResultToMOST(oFiDataObjectMethodResult.e8PairingResult, btPairingStatus._state);
   }
   else if(result == BM_RESULT_ERR_PAIRING_IN_PROGRESS)
   {
      oFiDataObjectMethodResult.e8PairingResult.enType =
            most_fi_tcl_e8_BTSetPairingResult::FI_EN_E8PAIRING_ALREADY_STARTED;
   }
   else if(result == BM_RESULT_ERR_NO_PAIRING_IN_PROGRESS)
   {
      oFiDataObjectMethodResult.e8PairingResult.enType =
            most_fi_tcl_e8_BTSetPairingResult::FI_EN_E8PAIRING_ALREADY_STOPPED;
   }

   ETG_TRACE_USR1(("SendPairingRequestMethodResult: e8PairingResult - %d",\
         oFiDataObjectMethodResult.e8PairingResult.enType));

   // Create FI VisitorMessage.
   fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodResult, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

   vInitServiceData(oVisitorMsgOutput, methodcontext.u16SourceAppID, methodcontext.u16RegisterID,
         methodcontext.u16CmdCounter, methodcontext.u16FunctionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

   // Post the message
   ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

   if (AIL_EN_N_NO_ERROR != ailResult)
   {
      // fatal error, because a server can post in all use cases
      ETG_TRACE_ERR(("enPostMessage failed for FunctionID: %d, with Result: %d", methodcontext.u16FunctionID, ailResult));
   }


   // Destroy the (Message related) FI data object (output)
   oFiDataObjectMethodResult.vDestroy();
   return;
}

tVoid FC_Bluetooth_tclCCAService::ScanBluetoothDevicesMethodResult(Job methodcontext, const SwitchStatus& btSwitchStatus,
      tBool bResponse)
{
   ENTRY
   most_btsetfi_tclMsgScanBluetoothDevicesMethodResult oFiDataObjectMethodResult;

   ETG_TRACE_USR1(("ScanBluetoothDevicesMethodResult: _switchState - %d", btSwitchStatus._switchState));

   //Create the method result
   MapSwitchStatusToMOST(oFiDataObjectMethodResult.e8ScanningState,btSwitchStatus, bResponse);

   // Create FI VisitorMessage.
   fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodResult, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

   vInitServiceData(oVisitorMsgOutput, methodcontext.u16SourceAppID, methodcontext.u16RegisterID,
         methodcontext.u16CmdCounter, methodcontext.u16FunctionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

   // Post the message
   ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

   if (AIL_EN_N_NO_ERROR != ailResult)
   {
      // fatal error, because a server can post in all use cases
      ETG_TRACE_ERR(("enPostMessage failed for FunctionID: %d, with Result: %d", methodcontext.u16FunctionID, ailResult));
   }


   // Destroy the (Message related) FI data object (output)
   oFiDataObjectMethodResult.vDestroy();
   return;
}

tVoid FC_Bluetooth_tclCCAService::ChangePinMethodResult(Job methodcontext, LocalFriendlyNameType localFriendlyName, PairingPinType pin)
{
   ENTRY
   most_btsetfi_tclMsgChangePinMethodResult oFiDataObjectMethodResult;

   //Create the method result
   oFiDataObjectMethodResult.e8PairingType.enType = most_fi_tcl_e8_BTSetPairingType::FI_EN_E8PAIRING_TYPE_CHANGE_PIN;

   oFiDataObjectMethodResult.sDeviceName.bSet(localFriendlyName.c_str());

   oFiDataObjectMethodResult.sPinNumber.bSet(pin.c_str(), most_fi_tcl_String::FI_EN_UTF8);

   ETG_TRACE_USR1(("ChangePinMethodResult: e8PairingType - %d", oFiDataObjectMethodResult.e8PairingType.enType));
   ETG_TRACE_USR1(("ChangePinMethodResult: sDeviceName - %s", oFiDataObjectMethodResult.sDeviceName.szValue));
   ETG_TRACE_USR1(("ChangePinMethodResult: sPinNumber - %s", oFiDataObjectMethodResult.sPinNumber.szValue));

   // Create FI VisitorMessage.
   fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodResult, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

   vInitServiceData(oVisitorMsgOutput, methodcontext.u16SourceAppID, methodcontext.u16RegisterID,
         methodcontext.u16CmdCounter, methodcontext.u16FunctionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

   // Post the message
   ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

   if (AIL_EN_N_NO_ERROR != ailResult)
   {
      // fatal error, because a server can post in all use cases
      ETG_TRACE_ERR(("enPostMessage failed for FunctionID: %d, with Result: %d",\
            methodcontext.u16FunctionID, ailResult));
   }

   // Destroy the (Message related) FI data object (output)
   oFiDataObjectMethodResult.vDestroy();
   return;
}

tVoid FC_Bluetooth_tclCCAService::PlayRingtoneMethodResult(Job methodcontext)
{
   ENTRY

   most_btsetfi_tclMsgPlayRingtoneMethodResult oFiDataObjectMethodResult;

   ETG_TRACE_USR1(("PlayRingtoneMethodResult: entered"));

   // Create FI VisitorMessage.
   fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodResult, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

   vInitServiceData(oVisitorMsgOutput, methodcontext.u16SourceAppID, methodcontext.u16RegisterID,
         methodcontext.u16CmdCounter, methodcontext.u16FunctionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

   // Post the message
   ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

   if (AIL_EN_N_NO_ERROR != ailResult)
   {
      // fatal error, because a server can post in all use cases
      ETG_TRACE_ERR(("enPostMessage failed for FunctionID: %d, with Result: %d",\
            methodcontext.u16FunctionID, ailResult));
   }

   // Destroy the (Message related) FI data object (output)
   oFiDataObjectMethodResult.vDestroy();
   return;
}

tVoid FC_Bluetooth_tclCCAService::PlayRingtoneMethodError()
{
   ETG_TRACE_USR1(("PlayRingtoneMethodError: entered"));

   sendMethodError(_playRingtone.u16FunctionID, _playRingtone,
         most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
}

tVoid FC_Bluetooth_tclCCAService::StopRingtoneMethodResult(Job methodcontext, tBool bStatus)
{
   ENTRY
   most_btsetfi_tclMsgStopRingtoneMethodResult oFiDataObjectMethodResult;

   ETG_TRACE_USR1(("StopRingtoneMethodResult: bStatus - %d", bStatus));

   oFiDataObjectMethodResult.bStopPlayRingtoneResult = bStatus;

   // Create FI VisitorMessage.
   fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodResult, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

   vInitServiceData(oVisitorMsgOutput, methodcontext.u16SourceAppID, methodcontext.u16RegisterID,
         methodcontext.u16CmdCounter, methodcontext.u16FunctionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

   // Post the message
   ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

   if (AIL_EN_N_NO_ERROR != ailResult)
   {
      // fatal error, because a server can post in all use cases
      ETG_TRACE_ERR(("enPostMessage failed for FunctionID: %d, with Result: %d",\
            methodcontext.u16FunctionID, ailResult));
   }

   // Destroy the (Message related) FI data object (output)
   oFiDataObjectMethodResult.vDestroy();
   return;
}

tVoid FC_Bluetooth_tclCCAService::ConnectSPPServiceMethodResult(Job methodcontext, tBool bStatus)
{
   ENTRY
   (tVoid) methodcontext;

   most_btsetfi_tclMsgConnectSPPServiceMethodResult oFiDataObjectMethodResult;

   oFiDataObjectMethodResult.bConnectSPPService = bStatus;

   ETG_TRACE_USR1(("ConnectSPPServiceMethodResult: bConnectSPPService - %d", oFiDataObjectMethodResult.bConnectSPPService));

   // Create FI VisitorMessage.
   fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodResult, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

   vInitServiceData(oVisitorMsgOutput, methodcontext.u16SourceAppID, methodcontext.u16RegisterID, methodcontext.u16CmdCounter, methodcontext.u16FunctionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

   // Post the message
   ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

   if (AIL_EN_N_NO_ERROR != ailResult)
   {
      // fatal error, because a server can post in all use cases
      ETG_TRACE_ERR(("enPostMessage failed for FunctionID: %d, with Result: %d", methodcontext.u16FunctionID, ailResult));
   }

   // Destroy the (Message related) FI data object (output)
   oFiDataObjectMethodResult.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::StartAutoConnectSeqMethodResult(Job methodcontext, tBool bStatus)
{
   ENTRY
   most_btsetfi_tclMsgStartAutoConnectSequenceMethodResult oFiDataObjectMethodResult;

   ETG_TRACE_USR1(("StartAutoConnectSeqMethodResult: bStatus - %d", bStatus));

   oFiDataObjectMethodResult.bResult = bStatus;

   // Create FI VisitorMessage.
   fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodResult, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

   vInitServiceData(oVisitorMsgOutput, methodcontext.u16SourceAppID, methodcontext.u16RegisterID,
         methodcontext.u16CmdCounter, methodcontext.u16FunctionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

   // Post the message
   ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

   if (AIL_EN_N_NO_ERROR != ailResult)
   {
      // fatal error, because a server can post in all use cases
      ETG_TRACE_ERR(("enPostMessage failed for FunctionID: %d, with Result: %d",\
            methodcontext.u16FunctionID, ailResult));
   }

   // Destroy the (Message related) FI data object (output)
   oFiDataObjectMethodResult.vDestroy();
   return;
}

tVoid FC_Bluetooth_tclCCAService::SwitchBTLocalModeMethodResult(Job methodcontext, tBool bStatus)
{
   ENTRY
   most_btsetfi_tclMsgSwitchBTLocalModeMethodResult oFiDataObjectMethodResult;

   ETG_TRACE_USR1(("SwitchBTLocalModeMethodResult: bStatus - %d", bStatus));

   oFiDataObjectMethodResult.bResult = bStatus;

   // Create FI VisitorMessage.
   fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodResult, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

   vInitServiceData(oVisitorMsgOutput, methodcontext.u16SourceAppID, methodcontext.u16RegisterID,
         methodcontext.u16CmdCounter, methodcontext.u16FunctionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

   // Post the message
   ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

   if (AIL_EN_N_NO_ERROR != ailResult)
   {
      // fatal error, because a server can post in all use cases
      ETG_TRACE_ERR(("enPostMessage failed for FunctionID: %d, with Result: %d",\
            methodcontext.u16FunctionID, ailResult));
   }

   // Destroy the (Message related) FI data object (output)
   oFiDataObjectMethodResult.vDestroy();
   return;
}

tVoid FC_Bluetooth_tclCCAService::SetBTLimitationModeMethodResult(Job methodcontext, tBool bStatus)
{
   ENTRY
   most_btsetfi_tclMsgSetBluetoothLimitationModeMethodResult oFiDataObjectMethodResult;

   oFiDataObjectMethodResult.bResult = bStatus;

   ETG_TRACE_USR1(("SetBTLimitationModeMethodResult: bResult - %d", oFiDataObjectMethodResult.bResult));

   // Create FI VisitorMessage.
   fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodResult, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

   vInitServiceData(oVisitorMsgOutput, methodcontext.u16SourceAppID, methodcontext.u16RegisterID,
         methodcontext.u16CmdCounter, methodcontext.u16FunctionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

   // Post the message
   ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

   if (AIL_EN_N_NO_ERROR != ailResult)
   {
      // fatal error, because a server can post in all use cases
      ETG_TRACE_ERR(("enPostMessage failed for FunctionID: %d, with Result: %d",\
            methodcontext.u16FunctionID, ailResult));
   }

   // Destroy the (Message related) FI data object (output)
   oFiDataObjectMethodResult.vDestroy();
   return;
}

tVoid FC_Bluetooth_tclCCAService::ClearDeviceInfoMethodResult(Job methodcontext, tBool bStatus)
{
   ENTRY
   most_btsetfi_tclMsgClearDeviceInfoMethodResult oFiDataObjectMethodResult;

   oFiDataObjectMethodResult.bResult = bStatus;

   ETG_TRACE_USR1(("ClearDeviceInfoMethodResult: bResult - %d", oFiDataObjectMethodResult.bResult));

   // Create FI VisitorMessage.
   fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodResult, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

   vInitServiceData(oVisitorMsgOutput, methodcontext.u16SourceAppID, methodcontext.u16RegisterID,
         methodcontext.u16CmdCounter, methodcontext.u16FunctionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

   // Post the message
   ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

   if (AIL_EN_N_NO_ERROR != ailResult)
   {
      // fatal error, because a server can post in all use cases
      ETG_TRACE_ERR(("enPostMessage failed for FunctionID: %d, with Result: %d",\
            methodcontext.u16FunctionID, ailResult));
   }

   // Destroy the (Message related) FI data object (output)
   oFiDataObjectMethodResult.vDestroy();
   return;
}

tVoid FC_Bluetooth_tclCCAService::ChangeWifiTransmitPowerMethodResult(Job methodcontext, tBool bStatus)
{
   ENTRY
   most_btsetfi_tclMsgChangeWifiTransmitPowerMethodResult oFiDataObjectMethodResult;

   oFiDataObjectMethodResult.bResult = bStatus;

   ETG_TRACE_USR1(("ChangeWifiTransmitPowerMethodResult: bResult - %d", oFiDataObjectMethodResult.bResult));

   // Create FI VisitorMessage.
   fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodResult, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

   vInitServiceData(oVisitorMsgOutput, methodcontext.u16SourceAppID, methodcontext.u16RegisterID,
         methodcontext.u16CmdCounter, methodcontext.u16FunctionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

   // Post the message
   ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

   if (AIL_EN_N_NO_ERROR != ailResult)
   {
      // fatal error, because a server can post in all use cases
      ETG_TRACE_ERR(("enPostMessage failed for FunctionID: %d, with Result: %d",\
            methodcontext.u16FunctionID, ailResult));
   }

   // Destroy the (Message related) FI data object (output)
   oFiDataObjectMethodResult.vDestroy();
   return;
}

tVoid FC_Bluetooth_tclCCAService::DisconnectSPPServiceMethodResult(Job methodcontext, tBool bStatus)
{
   ENTRY
   (tVoid) methodcontext;

   most_btsetfi_tclMsgDisconnectSPPServiceMethodResult oFiDataObjectMethodResult;

   oFiDataObjectMethodResult.bDisconnectSPPService = bStatus;

   ETG_TRACE_USR1(("DisconnectSPPServiceMethodResult: bDisconnectSPPService - %d", oFiDataObjectMethodResult.bDisconnectSPPService));

   // Create FI VisitorMessage.
   fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodResult, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

   vInitServiceData(oVisitorMsgOutput, methodcontext.u16SourceAppID, methodcontext.u16RegisterID, methodcontext.u16CmdCounter, methodcontext.u16FunctionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

   // Post the message
   ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

   if (AIL_EN_N_NO_ERROR != ailResult)
   {
      // fatal error, because a server can post in all use cases
      ETG_TRACE_ERR(("enPostMessage failed for FunctionID: %d, with Result: %d", methodcontext.u16FunctionID, ailResult));
   }

   // Destroy the (Message related) FI data object (output)
   oFiDataObjectMethodResult.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::StartSearchSPPServicesMethodResult(Job methodcontext, tBool bStatus, tU8 u8SearchHandle)
{
   ENTRY
   (tVoid) methodcontext;

   most_btsetfi_tclMsgStartSearchSPPServicesMethodResult oFiDataObjectMethodResult;

   oFiDataObjectMethodResult.bResult = bStatus;

   oFiDataObjectMethodResult.u8SearchHandle = u8SearchHandle;

   ETG_TRACE_USR1(("StartSearchSPPServicesMethodResult: bResult - %d u8SearchHandle - %d",
         oFiDataObjectMethodResult.bResult, oFiDataObjectMethodResult.u8SearchHandle));

   // Create FI VisitorMessage.
   fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodResult, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

   vInitServiceData(oVisitorMsgOutput, methodcontext.u16SourceAppID, methodcontext.u16RegisterID, methodcontext.u16CmdCounter, methodcontext.u16FunctionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

   // Post the message
   ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

   if (AIL_EN_N_NO_ERROR != ailResult)
   {
      // fatal error, because a server can post in all use cases
      ETG_TRACE_ERR(("enPostMessage failed for FunctionID: %d, with Result: %d", methodcontext.u16FunctionID, ailResult));
   }

   // Destroy the (Message related) FI data object (output)
   oFiDataObjectMethodResult.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::StopSearchSPPServicesMethodResult(Job methodcontext, tBool bStatus)
{
   ENTRY
   (tVoid) methodcontext;

   most_btsetfi_tclMsgStopSearchSPPServicesMethodResult oFiDataObjectMethodResult;

   oFiDataObjectMethodResult.bResult = bStatus;

   ETG_TRACE_USR1(("StopSearchSPPServicesMethodResult: bResult - %d", oFiDataObjectMethodResult.bResult));

   // Create FI VisitorMessage.
   fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodResult, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

   vInitServiceData(oVisitorMsgOutput, methodcontext.u16SourceAppID, methodcontext.u16RegisterID, methodcontext.u16CmdCounter, methodcontext.u16FunctionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

   // Post the message
   ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

   if (AIL_EN_N_NO_ERROR != ailResult)
   {
      // fatal error, because a server can post in all use cases
      ETG_TRACE_ERR(("enPostMessage failed for FunctionID: %d, with Result: %d", methodcontext.u16FunctionID, ailResult));
   }

   // Destroy the (Message related) FI data object (output)
   oFiDataObjectMethodResult.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::AddOobPairedDeviceMethodResult(Job methodcontext, tBool bStatus)
{
   ENTRY
   (tVoid) methodcontext;

   most_btsetfi_tclMsgAddOobPairedDeviceMethodResult oFiDataObjectMethodResult;

   oFiDataObjectMethodResult.bResult = bStatus;

   ETG_TRACE_USR1(("AddOobPairedDeviceMethodResult: bResult - %d", oFiDataObjectMethodResult.bResult));

   // Create FI VisitorMessage.
   fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodResult, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

   vInitServiceData(oVisitorMsgOutput, methodcontext.u16SourceAppID, methodcontext.u16RegisterID, methodcontext.u16CmdCounter, methodcontext.u16FunctionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

   // Post the message
   ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

   if (AIL_EN_N_NO_ERROR != ailResult)
   {
      // fatal error, because a server can post in all use cases
      ETG_TRACE_ERR(("enPostMessage failed for FunctionID: %d, with Result: %d", methodcontext.u16FunctionID, ailResult));
   }

   // Destroy the (Message related) FI data object (output)
   oFiDataObjectMethodResult.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::SetFavoriteMethodResult(Job methodcontext, tBool bStatus)
{
   ENTRY
   (tVoid) methodcontext;

   most_btsetfi_tclMsgSetFavoriteMethodResult oFiDataObjectMethodResult;

   oFiDataObjectMethodResult.bResult = bStatus;

   ETG_TRACE_USR1(("SetFavoriteMethodResult: bResult - %d", oFiDataObjectMethodResult.bResult));

   // Create FI VisitorMessage.
   fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodResult, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

   vInitServiceData(oVisitorMsgOutput, methodcontext.u16SourceAppID, methodcontext.u16RegisterID, methodcontext.u16CmdCounter, methodcontext.u16FunctionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

   // Post the message
   ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

   if (AIL_EN_N_NO_ERROR != ailResult)
   {
      // fatal error, because a server can post in all use cases
      ETG_TRACE_ERR(("enPostMessage failed for FunctionID: %d, with Result: %d", methodcontext.u16FunctionID, ailResult));
   }

   // Destroy the (Message related) FI data object (output)
   oFiDataObjectMethodResult.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::ClearFavoriteMethodResult(Job methodcontext, tBool bStatus)
{
   ENTRY
   (tVoid) methodcontext;

   most_btsetfi_tclMsgClearFavoriteMethodResult oFiDataObjectMethodResult;

   oFiDataObjectMethodResult.bResult = bStatus;

   ETG_TRACE_USR1(("ClearFavoriteMethodResult: bResult - %d", oFiDataObjectMethodResult.bResult));

   // Create FI VisitorMessage.
   fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodResult, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

   vInitServiceData(oVisitorMsgOutput, methodcontext.u16SourceAppID, methodcontext.u16RegisterID, methodcontext.u16CmdCounter, methodcontext.u16FunctionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

   // Post the message
   ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

   if (AIL_EN_N_NO_ERROR != ailResult)
   {
      // fatal error, because a server can post in all use cases
      ETG_TRACE_ERR(("enPostMessage failed for FunctionID: %d, with Result: %d", methodcontext.u16FunctionID, ailResult));
   }

   // Destroy the (Message related) FI data object (output)
   oFiDataObjectMethodResult.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::SwitchMultiHFPSupportMethodResult(Job methodcontext, tBool bStatus)
{
   ENTRY
   (tVoid) methodcontext;

   most_btsetfi_tclMsgSwitchMultiHFPSupportMethodResult oFiDataObjectMethodResult;

   oFiDataObjectMethodResult.bResult = bStatus;

   ETG_TRACE_USR1(("SwitchMultiHFPSupportMethodResult: bResult - %d", oFiDataObjectMethodResult.bResult));

   // Create FI VisitorMessage.
   fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodResult, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

   vInitServiceData(oVisitorMsgOutput, methodcontext.u16SourceAppID, methodcontext.u16RegisterID, methodcontext.u16CmdCounter, methodcontext.u16FunctionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

   // Post the message
   ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

   if (AIL_EN_N_NO_ERROR != ailResult)
   {
      // fatal error, because a server can post in all use cases
      ETG_TRACE_ERR(("SwitchMultiHFPSupportMethodResult: enPostMessage failed for FunctionID: %d, with Result: %d", methodcontext.u16FunctionID, ailResult));
   }

   // Destroy the (Message related) FI data object (output)
   oFiDataObjectMethodResult.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::SetPrimaryMethodResult(Job methodcontext, tBool bStatus)
{
   ENTRY
   (tVoid) methodcontext;

   most_btsetfi_tclMsgSetPrimaryMethodResult oFiDataObjectMethodResult;

   oFiDataObjectMethodResult.bResult = bStatus;

   ETG_TRACE_USR1(("SetPrimaryMethodResult: bResult - %d", oFiDataObjectMethodResult.bResult));

   // Create FI VisitorMessage.
   fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodResult, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

   vInitServiceData(oVisitorMsgOutput, methodcontext.u16SourceAppID, methodcontext.u16RegisterID, methodcontext.u16CmdCounter, methodcontext.u16FunctionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

   // Post the message
   ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

   if (AIL_EN_N_NO_ERROR != ailResult)
   {
      // fatal error, because a server can post in all use cases
      ETG_TRACE_ERR(("SetPrimaryMethodResult: enPostMessage failed for FunctionID: %d, with Result: %d", methodcontext.u16FunctionID, ailResult));
   }

   // Destroy the (Message related) FI data object (output)
   oFiDataObjectMethodResult.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::SetBtPrfoilesUsageMethodResult(Job methodcontext, tBool bStatus)
{
   ENTRY
   (tVoid) methodcontext;

   most_btsetfi_tclMsgSetBTProfilesUsageMethodResult oFiDataObjectMethodResult;

   oFiDataObjectMethodResult.bResult = bStatus;

   ETG_TRACE_USR1(("SetBtPrfoilesUsageMethodResult: bResult - %d", oFiDataObjectMethodResult.bResult));

   // Create FI VisitorMessage.
   fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodResult, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

   vInitServiceData(oVisitorMsgOutput, methodcontext.u16SourceAppID, methodcontext.u16RegisterID, methodcontext.u16CmdCounter, methodcontext.u16FunctionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

   // Post the message
   ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

   if (AIL_EN_N_NO_ERROR != ailResult)
   {
      // fatal error, because a server can post in all use cases
      ETG_TRACE_ERR(("SetBtPrfoilesUsageMethodResult: enPostMessage failed for FunctionID: %d, with Result: %d", methodcontext.u16FunctionID, ailResult));
   }

   // Destroy the (Message related) FI data object (output)
   oFiDataObjectMethodResult.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::ResolveConflictsMethodResult(Job methodcontext, tBool bStatus)
{
   ENTRY
   (tVoid) methodcontext;

   most_btsetfi_tclMsgResolveConflictsMethodResult oFiDataObjectMethodResult;

   oFiDataObjectMethodResult.bResult = bStatus;

   ETG_TRACE_USR1(("ResolveConflictsMethodResult: bResult - %d", oFiDataObjectMethodResult.bResult));

   // Create FI VisitorMessage.
   fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodResult, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

   vInitServiceData(oVisitorMsgOutput, methodcontext.u16SourceAppID, methodcontext.u16RegisterID, methodcontext.u16CmdCounter, methodcontext.u16FunctionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

   // Post the message
   ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

   if (AIL_EN_N_NO_ERROR != ailResult)
   {
      // fatal error, because a server can post in all use cases
      ETG_TRACE_ERR(("ResolveConflictsMethodResult: enPostMessage failed for FunctionID: %d, with Result: %d", methodcontext.u16FunctionID, ailResult));
   }

   // Destroy the (Message related) FI data object (output)
   oFiDataObjectMethodResult.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::SetDeviceUsagePreferenceMethodResult(Job methodcontext, tBool bStatus)
{
   ENTRY
   (tVoid) methodcontext;

   most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodResult oFiDataObjectMethodResult;

   oFiDataObjectMethodResult.bResult = bStatus;

   ETG_TRACE_USR1(("SetDeviceUsagePreferenceMethodResult: bResult - %d", oFiDataObjectMethodResult.bResult));

   // Create FI VisitorMessage.
   fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodResult, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

   vInitServiceData(oVisitorMsgOutput, methodcontext.u16SourceAppID, methodcontext.u16RegisterID, methodcontext.u16CmdCounter, methodcontext.u16FunctionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

   // Post the message
   ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

   if (AIL_EN_N_NO_ERROR != ailResult)
   {
      // fatal error, because a server can post in all use cases
      ETG_TRACE_ERR(("SetDeviceUsagePreferenceMethodResult: enPostMessage failed for FunctionID: %d, with Result: %d", methodcontext.u16FunctionID, ailResult));
   }

   // Destroy the (Message related) FI data object (output)
   oFiDataObjectMethodResult.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::SetProfileUserAvailabilityMethodResult(Job methodcontext, tBool bStatus)
{
   ENTRY
   (tVoid) methodcontext;

   most_btsetfi_tclMsgSetProfileUserAvailabilityMethodResult oFiDataObjectMethodResult;

   oFiDataObjectMethodResult.bResult = bStatus;

   ETG_TRACE_USR1(("SetProfileUserAvailabilityMethodResult: bResult - %d", oFiDataObjectMethodResult.bResult));

   // Create FI VisitorMessage.
   fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodResult, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

   vInitServiceData(oVisitorMsgOutput, methodcontext.u16SourceAppID, methodcontext.u16RegisterID, methodcontext.u16CmdCounter, methodcontext.u16FunctionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

   // Post the message
   ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

   if (AIL_EN_N_NO_ERROR != ailResult)
   {
      // fatal error, because a server can post in all use cases
      ETG_TRACE_ERR(("SetProfileUserAvailabilityMethodResult: enPostMessage failed for FunctionID: %d, with Result: %d", methodcontext.u16FunctionID, ailResult));
   }

   // Destroy the (Message related) FI data object (output)
   oFiDataObjectMethodResult.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::ReplaceBluetoothLimitationModeMethodResult(Job methodcontext, tBool bStatus)
{
   ENTRY
   (tVoid) methodcontext;

   most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodResult oFiDataObjectMethodResult;

   oFiDataObjectMethodResult.bResult = bStatus;

   ETG_TRACE_USR1(("ReplaceBluetoothLimitationModeMethodResult: bResult - %d", oFiDataObjectMethodResult.bResult));

   // Create FI VisitorMessage.
   fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodResult, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

   vInitServiceData(oVisitorMsgOutput, methodcontext.u16SourceAppID, methodcontext.u16RegisterID, methodcontext.u16CmdCounter, methodcontext.u16FunctionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

   // Post the message
   ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

   if (AIL_EN_N_NO_ERROR != ailResult)
   {
      // fatal error, because a server can post in all use cases
      ETG_TRACE_ERR(("ReplaceBluetoothLimitationModeMethodResult: enPostMessage failed for FunctionID: %d, with Result: %d", methodcontext.u16FunctionID, ailResult));
   }

   // Destroy the (Message related) FI data object (output)
   oFiDataObjectMethodResult.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::StartServiceSearchMethodResult(Job methodcontext, tBool bStatus)
{
   ENTRY
   (tVoid) methodcontext;

   most_btsetfi_tclMsgStartSearchSPPServicesMethodResult oFiDataObjectMethodResult;

   oFiDataObjectMethodResult.bResult = bStatus;

   ETG_TRACE_USR1(("StartServiceSearchMethodResult: bResult - %d", oFiDataObjectMethodResult.bResult));

   // Create FI VisitorMessage.
   fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodResult, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

   vInitServiceData(oVisitorMsgOutput, methodcontext.u16SourceAppID, methodcontext.u16RegisterID, methodcontext.u16CmdCounter, methodcontext.u16FunctionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

   // Post the message
   ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

   if (AIL_EN_N_NO_ERROR != ailResult)
   {
      // fatal error, because a server can post in all use cases
      ETG_TRACE_ERR(("StartServiceSearchMethodResult: enPostMessage failed for FunctionID: %d, with Result: %d", methodcontext.u16FunctionID, ailResult));
   }

   // Destroy the (Message related) FI data object (output)
   oFiDataObjectMethodResult.vDestroy();

   return;
}

tVoid FC_Bluetooth_tclCCAService::StopServiceSearchMethodResult(Job methodcontext, tBool bStatus)
{
   ENTRY
   (tVoid) methodcontext;

   most_btsetfi_tclMsgStopSearchSPPServicesMethodResult oFiDataObjectMethodResult;

   oFiDataObjectMethodResult.bResult = bStatus;

   ETG_TRACE_USR1(("StopServiceSearchMethodResult: bResult - %d", oFiDataObjectMethodResult.bResult));

   // Create FI VisitorMessage.
   fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodResult, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

   vInitServiceData(oVisitorMsgOutput, methodcontext.u16SourceAppID, methodcontext.u16RegisterID, methodcontext.u16CmdCounter, methodcontext.u16FunctionID, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

   // Post the message
   ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

   if (AIL_EN_N_NO_ERROR != ailResult)
   {
      // fatal error, because a server can post in all use cases
      ETG_TRACE_ERR(("StopServiceSearchMethodResult: enPostMessage failed for FunctionID: %d, with Result: %d", methodcontext.u16FunctionID, ailResult));
   }

   // Destroy the (Message related) FI data object (output)
   oFiDataObjectMethodResult.vDestroy();

   return;
}

/**
 * Method Error
 */

tVoid FC_Bluetooth_tclCCAService::ConnectBluetoothProfileMethodError(Job& methodcontext, tU16& u16Count)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("ConnectBluetoothProfileMethodError entered"));

   connectBluetoothProfileStruct *poConnectBluetoothProfile = NULL;

   sendMethodError(CONNECTPROFILE_METHOD_FKTID, methodcontext, most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);

   poConnectBluetoothProfile = (connectBluetoothProfileStruct *) methodcontext.poMethodArg;

   if(poConnectBluetoothProfile != NULL)
   {
      poConnectBluetoothProfile->CBPFiDataObjectMethodStart.vDestroy();
      OSAL_DELETE poConnectBluetoothProfile;
   }

   FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(CONNECTPROFILE_METHOD_FKTID, methodcontext, u16Count);

   return;
}

tVoid FC_Bluetooth_tclCCAService::DisconnectBluetoothProfileMethodError(Job& methodcontext, tU16& u16Count)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("DisconnectBluetoothProfileMethodError entered"));

   disconnectBluetoothProfileStruct *poDisconnectBluetoothProfile = NULL;

   sendMethodError(DISCONNECTPROFILE_METHOD_FKTID, methodcontext, most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);

   poDisconnectBluetoothProfile = (disconnectBluetoothProfileStruct *) methodcontext.poMethodArg;

   if(poDisconnectBluetoothProfile != NULL)
   {
      poDisconnectBluetoothProfile->DBPFiDataObjectMethodStart.vDestroy();
      OSAL_DELETE poDisconnectBluetoothProfile;
   }

   FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(DISCONNECTPROFILE_METHOD_FKTID, methodcontext, u16Count);

   return;
}

tVoid FC_Bluetooth_tclCCAService::ChangeDeviceStateMethodError(Job& methodcontext, tU16& u16Count)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("ChangeDeviceStateMethodError entered"));

   most_btsetfi_tclMsgChangeDeviceStateMethodStart *poCDSFiDataObjectMethodStart = NULL;

   sendMethodError(CHANGEDEVICESTATE_METHOD_FKTID, methodcontext, most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);

   poCDSFiDataObjectMethodStart = (most_btsetfi_tclMsgChangeDeviceStateMethodStart *) methodcontext.poMethodArg;

   if(poCDSFiDataObjectMethodStart != NULL)
   {
      poCDSFiDataObjectMethodStart->vDestroy();
      OSAL_DELETE poCDSFiDataObjectMethodStart;
   }

   FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(CHANGEDEVICESTATE_METHOD_FKTID, methodcontext, u16Count);

   return;
}

template<typename T> tVoid FC_Bluetooth_tclCCAService::MethodError(T oFiDataObjectMethodError,
      Job methodcontext, tU16 u16ErrorCode)
{
   ENTRY

   //Create the method result
   oFiDataObjectMethodError.e8ErrorCode.enType = static_cast <most_fi_tcl_e8_ErrorCode::tenType>( u16ErrorCode);

   // Create FI VisitorMessage.
   fi_tclVisitorMessage oVisitorMsgOutput(oFiDataObjectMethodError, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

   vInitServiceData(oVisitorMsgOutput, methodcontext.u16SourceAppID, methodcontext.u16RegisterID,
         methodcontext.u16CmdCounter, methodcontext.u16FunctionID, AMT_C_U8_CCAMSG_OPCODE_ERROR);

   // Post the message
   if (oVisitorMsgOutput.bIsValid())
   {
      ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

      if (AIL_EN_N_NO_ERROR != ailResult)
      {
         // fatal error, because a server can post in all use cases
         ETG_TRACE_ERR(("enPostMessage failed for FunctionID: %d, with Result: %d",\
               methodcontext.u16FunctionID, ailResult));
      }
      else
      {
         ETG_TRACE_USR4(("MethodError send successful for FunctionID: %d", methodcontext.u16FunctionID));
      }
   }
}

tVoid FC_Bluetooth_tclCCAService::sendMethodError(tU16 u16FunctionId, Job methodcontext, tU16 u16ErrorCode)
{
   ENTRY

   _sendMethodErrorLock.lock();

   ETG_TRACE_USR4(("sendMethodError: FunctionID: %d", u16FunctionId));

   switch(u16FunctionId)
   {
      case ADDNEWDEVICE_METHOD_FKTID:
      {
         most_btsetfi_tclMsgAddNewDeviceError AddNewDeviceError;
         MethodError(AddNewDeviceError, methodcontext, u16ErrorCode);
         AddNewDeviceError.vDestroy();
         break;
      }
      case PAIRINGRESPONSE_METHOD_FKTID:
      {
         most_btsetfi_tclMsgPairingResponseError PairingResponseError;
         MethodError(PairingResponseError, methodcontext, u16ErrorCode);
         PairingResponseError.vDestroy();
         break;
      }
      case CHANGEPIN_METHOD_FKTID:
      {
         most_btsetfi_tclMsgChangePinError ChangePinError;
         MethodError(ChangePinError, methodcontext, u16ErrorCode);
         ChangePinError.vDestroy();
         break;
      }
      case CHANGEDEVICESTATE_METHOD_FKTID:
      {
         most_btsetfi_tclMsgChangeDeviceStateError ChangeDeviceStateError;
         MethodError(ChangeDeviceStateError, methodcontext, u16ErrorCode);
         ChangeDeviceStateError.vDestroy();
         break;
      }
      case GETDEVICEINFOEXT_METHOD_FKTID:
      {
         most_btsetfi_tclMsgGetDeviceInfoExtendedError GetDeviceInfoExtError;
         MethodError(GetDeviceInfoExtError, methodcontext, u16ErrorCode);
         GetDeviceInfoExtError.vDestroy();
         break;
      }

      case SWITCHBTONOFFEXT_METHOD_FKTID:
      {
         most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedError SwitchBTOnOffExtError;
         MethodError(SwitchBTOnOffExtError, methodcontext, u16ErrorCode);
         SwitchBTOnOffExtError.vDestroy();
         break;
      }
      case SCANBTDEVICES_METHOD_FKTID:
      {
         most_btsetfi_tclMsgScanBluetoothDevicesError ScanBluetoothDevicesError;
         MethodError(ScanBluetoothDevicesError, methodcontext, u16ErrorCode);
         ScanBluetoothDevicesError.vDestroy();
         break;
      }
      case CONNECTPROFILE_METHOD_FKTID:
      {
         most_btsetfi_tclMsgConnectBluetoothProfileError ConnectBluetoothProfileError;
         MethodError(ConnectBluetoothProfileError, methodcontext, u16ErrorCode);
         ConnectBluetoothProfileError.vDestroy();
         break;
      }
      case DISCONNECTPROFILE_METHOD_FKTID:
      {
         most_btsetfi_tclMsgDisconnectBluetoothProfileError DisconnectBluetoothProfileError;
         MethodError(DisconnectBluetoothProfileError, methodcontext, u16ErrorCode);
         DisconnectBluetoothProfileError.vDestroy();
         break;
      }
      case SENDPAIRINGREQUEST_METHOD_FKTID:
      {
         most_btsetfi_tclMsgSendPairingRequestError SendPairingRequestError;
         MethodError(SendPairingRequestError, methodcontext, u16ErrorCode);
         SendPairingRequestError.vDestroy();
         break;
      }
      case CLEARDEVICEINFO_METHOD_FKTID:
      {
         most_btsetfi_tclMsgClearDeviceInfoError ClearDeviceInfoError;
         MethodError(ClearDeviceInfoError, methodcontext, u16ErrorCode);
         ClearDeviceInfoError.vDestroy();
         break;
      }
      case PLAYRINGTONE_METHOD_FKTID:
      {
         most_btsetfi_tclMsgPlayRingtoneError PlayRingtoneError;
         MethodError(PlayRingtoneError, methodcontext, u16ErrorCode);
         PlayRingtoneError.vDestroy();
         break;
      }
      case STOPRINGTONE_METHOD_FKTID:
      {
         most_btsetfi_tclMsgStopRingtoneError StopRingtoneError;
         MethodError(StopRingtoneError, methodcontext, u16ErrorCode);
         StopRingtoneError.vDestroy();
         break;
      }
      case REQDEVRINGTONELIST_METHOD_FKTID:
      {
         most_btsetfi_tclMsgRequestDeviceRingtoneListError ReqDevRingtoneListError;
         MethodError(ReqDevRingtoneListError, methodcontext, u16ErrorCode);
         ReqDevRingtoneListError.vDestroy();
         break;
      }
      case REQAVAILRINGTONELIST_METHOD_FKTID:
      {
         most_btsetfi_tclMsgRequestAvailableRingtonesListError ReqAvailRingtoneListError;
         MethodError(ReqAvailRingtoneListError, methodcontext, u16ErrorCode);
         ReqAvailRingtoneListError.vDestroy();
         break;
      }
      case STARTAUTOCONNECTSEQ_METHOD_FKTID:
      {
         most_btsetfi_tclMsgStartAutoConnectSequenceError StartAutoConnectSequenceError;
         MethodError(StartAutoConnectSequenceError, methodcontext, u16ErrorCode);
         StartAutoConnectSequenceError.vDestroy();
         break;
      }
      case SWITCHBTLOCALMODE_METHOD_FKTID:
      {
         most_btsetfi_tclMsgSwitchBTLocalModeError SwitchBTLocalModeError;
         MethodError(SwitchBTLocalModeError, methodcontext, u16ErrorCode);
         SwitchBTLocalModeError.vDestroy();
         break;
      }
      case CONNECTSPPSERVICE_METHOD_FKTID:
      {
         most_btsetfi_tclMsgConnectSPPServiceError ConnectSPPServiceError;
         MethodError(ConnectSPPServiceError, methodcontext, u16ErrorCode);
         ConnectSPPServiceError.vDestroy();
         break;
      }
      case SETBTLIMITATIONMODE_METHOD_FKTID:
      {
         most_btsetfi_tclMsgSetBluetoothLimitationModeError setBluetoothLimitationError;
         MethodError(setBluetoothLimitationError, methodcontext, u16ErrorCode);
         setBluetoothLimitationError.vDestroy();
         break;
      }
      case CHANGEWIFITXPOWER_METHOD_FKTID:
      {
         most_btsetfi_tclMsgChangeWifiTransmitPowerError changeWifiTxPowerError;
         MethodError(changeWifiTxPowerError, methodcontext, u16ErrorCode);
         changeWifiTxPowerError.vDestroy();
         break;
      }
      case DISCONNECTSPPSERVICE_METHOD_FKTID:
      {
         most_btsetfi_tclMsgDisconnectSPPServiceError disconnectSPPServiceError;
         MethodError(disconnectSPPServiceError, methodcontext, u16ErrorCode);
         disconnectSPPServiceError.vDestroy();
         break;
      }
      case STARTSEARCHSPPSERVICES_METHOD_FKTID:
      {
         most_btsetfi_tclMsgStartSearchSPPServicesError startSearchSPPServicesError;
         MethodError(startSearchSPPServicesError, methodcontext, u16ErrorCode);
         startSearchSPPServicesError.vDestroy();
         break;
      }
      case STOPSEARCHSPPSERVICES_METHOD_FKTID:
      {
         most_btsetfi_tclMsgStopSearchSPPServicesError stopSearchSPPServicesError;
         MethodError(stopSearchSPPServicesError, methodcontext, u16ErrorCode);
         stopSearchSPPServicesError.vDestroy();
         break;
      }
      case ADDOOBPAIREDDEVICE_METHOD_FKTID:
      {
         most_btsetfi_tclMsgAddOobPairedDeviceError addOobPairedDeviceError;
         MethodError(addOobPairedDeviceError, methodcontext, u16ErrorCode);
         addOobPairedDeviceError.vDestroy();
         break;
      }
      case SETFAVORITE_METHOD_FKTID:
      {
         most_btsetfi_tclMsgSetFavoriteError setFavoriteError;
         MethodError(setFavoriteError, methodcontext, u16ErrorCode);
         setFavoriteError.vDestroy();
         break;
      }
      case CLEARFAVORITE_METHOD_FKTID:
      {
         most_btsetfi_tclMsgClearFavoriteError clearFavoriteError;
         MethodError(clearFavoriteError, methodcontext, u16ErrorCode);
         clearFavoriteError.vDestroy();
         break;
      }
      case SWITCHMULTIHFPSUPPORT_METHOD_FKTID:
      {
         most_btsetfi_tclMsgSwitchMultiHFPSupportError switchMultiHFPSupportError;
         MethodError(switchMultiHFPSupportError, methodcontext, u16ErrorCode);
         switchMultiHFPSupportError.vDestroy();
         break;
      }
      case SETPRIMARY_METHOD_FKTID:
      {
         most_btsetfi_tclMsgSetPrimaryError setPrimaryError;
         MethodError(setPrimaryError, methodcontext, u16ErrorCode);
         setPrimaryError.vDestroy();
         break;
      }
      case SETBTPROFILESUSAGE_METHOD_FKTID:
      {
         most_btsetfi_tclMsgSetBTProfilesUsageError setBTProfilesUsageError;
         MethodError(setBTProfilesUsageError, methodcontext, u16ErrorCode);
         setBTProfilesUsageError.vDestroy();
         break;
      }
      case RESOLVE_CONFLICTS_METHOD_FKTID:
      {
         most_btsetfi_tclMsgResolveConflictsError resolveConflictsError;
         MethodError(resolveConflictsError, methodcontext, u16ErrorCode);
         resolveConflictsError.vDestroy();
         break;
      }
      case SETUSAGEPREFERENCE_METHOD_FKTID:
      {
         most_btsetfi_tclMsgSetDeviceUsagePreferenceError setDeviceUsagePreferenceError;
         MethodError(setDeviceUsagePreferenceError, methodcontext, u16ErrorCode);
         setDeviceUsagePreferenceError.vDestroy();
         break;
      }
      case SETPROFILEUSERAVAILABILITY_METHOD_FKTID:
      {
         most_btsetfi_tclMsgSetProfileUserAvailabilityError setProfileUserAvailabilityError;
         MethodError(setProfileUserAvailabilityError, methodcontext, u16ErrorCode);
         setProfileUserAvailabilityError.vDestroy();
         break;
      }
      case REPLACEBTLIMITATIONMODE_METHOD_FKTID:
      {
         most_btsetfi_tclMsgReplaceBluetoothLimitationModeError replaceBluetoothLimitationModeError;
         MethodError(replaceBluetoothLimitationModeError, methodcontext, u16ErrorCode);
         replaceBluetoothLimitationModeError.vDestroy();
         break;
      }
      default:
         ETG_TRACE_USR4(("sendMethodError: Invalid FunctionID"));
         break;
   }

   _sendMethodErrorLock.unlock();

   return;
}

tVoid FC_Bluetooth_tclCCAService::funcResponseError(tU16 u16FunctionId, tU16 u16ErrorCode, tBool bRemove)
{
   ENTRY_INTERNAL

   JobList *joblist = OSAL_NULL;
   tBool bRet = false;

   ETG_TRACE_USR1(("funcResponseError:FunctionID: %d bRemove: %d",\
            u16FunctionId, bRemove));

   if(bRemove == REMOVE_ALL_METHOD)
   {
      joblist = FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopMethodContext(u16FunctionId);

      if (joblist)
      {
         for (JobList::iterator it = joblist->begin(); it != joblist->end(); it++)
         {
            sendMethodError(u16FunctionId, (Job) *it, u16ErrorCode);
         }
      }
   }
   else
   {
      Job f_rJob;

      bRet = FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContext(u16FunctionId, f_rJob);

      if (bRet)
      {
         sendMethodError(u16FunctionId, f_rJob, u16ErrorCode);

         FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(u16FunctionId, f_rJob, FC_BLUETOOTH_CCASERVICE_ONE);
      }
   }
}

tVoid FC_Bluetooth_tclCCAService::sendMethodResult(tU16 u16FunctionId)
{
   Job f_rJob;
   tBool bRet = false;

   ETG_TRACE_USR1(("sendMethodResult:FunctionID: %d", u16FunctionId));

   bRet = FC_Bluetooth_CCAMethodQueue::poGetInstance()->GetMethodContext(u16FunctionId, f_rJob);

   if (bRet)
   {
      switch(u16FunctionId)
      {
         case SETBTLIMITATIONMODE_METHOD_FKTID:
         {
            SetBTLimitationModeMethodResult(f_rJob, TRUE);
            FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(u16FunctionId, f_rJob, FC_BLUETOOTH_CCASERVICE_ONE);
            break;
         }
         case CLEARDEVICEINFO_METHOD_FKTID:
         {
            ClearDeviceInfoMethodResult(f_rJob, TRUE);
            FC_Bluetooth_CCAMethodQueue::poGetInstance()->PopParticularMethodContext(u16FunctionId, f_rJob, FC_BLUETOOTH_CCASERVICE_ONE);
            break;
         }
         default:
            ETG_TRACE_USR4(("sendMethodResult: Invalid FunctionID"));
            break;
      }
   }
}

/**
 * Type conversions (MOST to Internal)
 */
void FC_Bluetooth_tclCCAService::MapBluetoothOnOffToInternal(TargetSwitchState &targetSwitchState,
      const tBool bluetoothOnOff)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("MapBluetoothOnOffToInternal::bluetoothOnOff = %d ", bluetoothOnOff));

   if (bluetoothOnOff == TRUE)
   {
      targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_ON;
   }
   else
   {
      targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_OFF;
   }

   return;
}

void FC_Bluetooth_tclCCAService::MapAutoConnectOnOffToInternal(AutoConnectionType &autoConnectionType,
      const tBool autoConnectOnOff)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("MapAutoConnectOnOffToInternal::autoConnectOnOff = %d ", autoConnectOnOff));

   if (autoConnectOnOff == FALSE)
   {
      autoConnectionType._type = BM_STANDARD_AUTO_CONNECTION_OFF;
   }
   else
   {
      autoConnectionType._type = BM_STANDARD_AUTO_CONNECTION_LAST_CONNECTED_DEVICES; // TODO
   }

   return;
}

BmResult FC_Bluetooth_tclCCAService::GetInbandRingtoneSupport(tBool &inbandSupport, tU8 u8DeviceHandle)
{
   ENTRY_INTERNAL
   PairedDeviceList pairedDeviceList;
   DeviceBaseInfoList::iterator devInfoListIt;
   BmResult result = BM_RESULT_ERR_GENERAL;

   inbandSupport = FALSE;

   vGetPairedDeviceList(pairedDeviceList);

   devInfoListIt = std::find_if(pairedDeviceList._deviceBaseInfoList.begin(),
         pairedDeviceList._deviceBaseInfoList.end(),
         MeetsDeviceHandle<DeviceBaseInfo>(u8DeviceHandle));

   if (devInfoListIt != pairedDeviceList._deviceBaseInfoList.end())
   {
      if (devInfoListIt->_inbandRingtoneSupport == BM_INBAND_RINGTONE_SUPPORT_AVAILABLE)
      {
         inbandSupport = TRUE;
      }

      result = BM_RESULT_OK;
   }
   else
   {

   }

   ETG_TRACE_USR1(("GetInbandRingtoneSupport::inbandSupport = %d ", inbandSupport));

   return result;
}

void FC_Bluetooth_tclCCAService::MapSwitchDiscoveryStatusToInternal(TargetSwitchState &switchState, const tBool scan)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("MapSwitchDiscoveryStatusToInternal::scan = %d ", scan));

   if (scan == TRUE)
   {
      switchState = TARGET_SWITCH_STATE_SWITCHED_ON;
   }
   else
   {
      switchState = TARGET_SWITCH_STATE_SWITCHED_OFF;
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::MapLimitationFeatureToInternal(LimitationFeature &limitationFeature, most_fi_tcl_e8_BTTechnology e8Technology)
{
   ENTRY_INTERNAL

   switch(e8Technology.enType)
   {
      case most_fi_tcl_e8_BTTechnology::FI_EN_IAP:
         limitationFeature = ::bmcore::BM_LIMITATION_FEATURE_IAP;
      break;
      case most_fi_tcl_e8_BTTechnology::FI_EN_CAR_PLAY:
         limitationFeature = ::bmcore::BM_LIMITATION_FEATURE_CAR_PLAY;
      break;
      case most_fi_tcl_e8_BTTechnology::FI_EN_ANDROID_AUTO:
         limitationFeature = ::bmcore::BM_LIMITATION_FEATURE_ANDROID_AUTO;
      break;
      case most_fi_tcl_e8_BTTechnology::FI_EN_MY_SPIN:
         limitationFeature = ::bmcore::BM_LIMITATION_FEATURE_MY_SPIN;
      break;
      case most_fi_tcl_e8_BTTechnology::FI_EN_MY_SPIN_IOS:
         limitationFeature = ::bmcore::BM_LIMITATION_FEATURE_MY_SPIN_IOS;
      break;
      case most_fi_tcl_e8_BTTechnology::FI_EN_MIRROR_LINK:
         limitationFeature = ::bmcore::BM_LIMITATION_FEATURE_MIRROR_LINK;
      break;
      case most_fi_tcl_e8_BTTechnology::FI_EN_MIRROR_LINK_IOS:
         limitationFeature = ::bmcore::BM_LIMITATION_FEATURE_MIRROR_LINK_IOS;
      break;
      case most_fi_tcl_e8_BTTechnology::FI_EN_CAR_LIFE:
         limitationFeature = ::bmcore::BM_LIMITATION_FEATURE_CAR_LIFE;
      break;
      case most_fi_tcl_e8_BTTechnology::FI_EN_CAR_LIFE_IOS:
         limitationFeature = ::bmcore::BM_LIMITATION_FEATURE_CAR_LIFE_IOS;
      break;
      case most_fi_tcl_e8_BTTechnology::FI_EN_ON_CAR:
         limitationFeature = ::bmcore::BM_LIMITATION_FEATURE_ON_CAR;
      break;
      case most_fi_tcl_e8_BTTechnology::FI_EN_ON_CAR_IOS:
         limitationFeature = ::bmcore::BM_LIMITATION_FEATURE_ON_CAR_IOS;
      break;
      default:
         limitationFeature = ::bmcore::BM_LIMITATION_FEATURE_LAST;
         ETG_TRACE_ERR(("Invalid limitationFeature"));
      break;
   }

   ETG_TRACE_USR1(("MapLimitationFeatureToInternal::limitationFeature = %d ", limitationFeature));

   return;
}

tVoid FC_Bluetooth_tclCCAService::MapLimitationCommunicationIfToInternal(LimitationCommunicationIf& limitationCommunicationIf,
      most_fi_tcl_e8_BTCommunicationChannel e8CommunicationChannel)
{
   ENTRY_INTERNAL

   switch(e8CommunicationChannel.enType)
   {
      case most_fi_tcl_e8_BTCommunicationChannel::FI_EN_USB:
         limitationCommunicationIf = ::bmcore::BM_LIMITATION_COMMUNICATION_IF_USB;
      break;
      case most_fi_tcl_e8_BTCommunicationChannel::FI_EN_WIFI_2_4GHZ:
         limitationCommunicationIf = ::bmcore::BM_LIMITATION_COMMUNICATION_IF_WIFI_2_4;
      break;
      case most_fi_tcl_e8_BTCommunicationChannel::FI_EN_WIFI_5GHZ:
         limitationCommunicationIf = ::bmcore::BM_LIMITATION_COMMUNICATION_IF_WIFI_5;
      break;
      case most_fi_tcl_e8_BTCommunicationChannel::FI_EN_BLUETOOTH:
         limitationCommunicationIf = ::bmcore::BM_LIMITATION_COMMUNICATION_IF_BT;
      break;
      case most_fi_tcl_e8_BTCommunicationChannel::FI_EN_WIFI:
         //Todo: This need to be changed once Wifi band information is available
         limitationCommunicationIf = ::bmcore::BM_LIMITATION_COMMUNICATION_IF_WIFI;
      break;
      default:
         limitationCommunicationIf = ::bmcore::BM_LIMITATION_COMMUNICATION_IF_LAST;
         ETG_TRACE_ERR(("Invalid limitationCommunicationIf"));
      break;
   }

   ETG_TRACE_USR1(("MapLimitationCommunicationIfToInternal::limitationCommunicationIf = %d ", limitationCommunicationIf));

   return;
}

tVoid FC_Bluetooth_tclCCAService::MapLimitationActionToInternal(LimitationAction &limitationAction, most_fi_tcl_e8_BTLimitationAction e8Action)
{
   ENTRY_INTERNAL

   switch (e8Action.enType)
   {
      case most_fi_tcl_e8_BTLimitationAction::FI_EN_PREPARE:
         limitationAction = ::bmcore::BM_LIMITATION_ACTION_PREPARE;
      break;
      case most_fi_tcl_e8_BTLimitationAction::FI_EN_PREACTIVATE:
         limitationAction = ::bmcore::BM_LIMITATION_ACTION_PREACTIVATE;
      break;
      case most_fi_tcl_e8_BTLimitationAction::FI_EN_ACTIVATE:
         limitationAction = ::bmcore::BM_LIMITATION_ACTION_ACTIVATE;
      break;
      case most_fi_tcl_e8_BTLimitationAction::FI_EN_DEACTIVATE:
         limitationAction = ::bmcore::BM_LIMITATION_ACTION_DEACTIVATE;
      break;
      case most_fi_tcl_e8_BTLimitationAction::FI_EN_DEACTIVATE_WAIT:
         limitationAction = ::bmcore::BM_LIMITATION_ACTION_DEACTIVATE_WAIT;
      break;
      case most_fi_tcl_e8_BTLimitationAction::FI_EN_DEACTIVATE_INTERNAL:
         limitationAction = ::bmcore::BM_LIMITATION_ACTION_DEACTIVATE_INTERNAL;
      break;
      case most_fi_tcl_e8_BTLimitationAction::FI_EN_DEACTIVATE_SPMSTATE_OFF:
         limitationAction = ::bmcore::BM_LIMITATION_ACTION_DEACTIVATE_SPM_STATE_OFF;
      break;
      default:
         limitationAction = ::bmcore::BM_LIMITATION_ACTION_LAST;
         ETG_TRACE_ERR(("Invalid limitationAction"));
      break;
   }

   ETG_TRACE_USR1(("MapLimitationActionToInternal::limitationAction = %d ", limitationAction));

   return;
}

tVoid FC_Bluetooth_tclCCAService::MapLimitationActionStateToInternal(LimitationState &limitationActionState,
      most_fi_tcl_e8_BTLimitationActionState e8ActionState)
{
   ENTRY_INTERNAL

   switch (e8ActionState.enType)
   {
      case most_fi_tcl_e8_BTLimitationActionState::FI_EN_IDLE:
         limitationActionState = ::bmcore::BM_LIMITATION_STATE_IDLE;
         break;
      case most_fi_tcl_e8_BTLimitationActionState::FI_EN_PREPARING:
         limitationActionState = ::bmcore::BM_LIMITATION_STATE_PREPARING;
         break;
      case most_fi_tcl_e8_BTLimitationActionState::FI_EN_PREPARED:
         limitationActionState = ::bmcore::BM_LIMITATION_STATE_PREPARED;
         break;
      case most_fi_tcl_e8_BTLimitationActionState::FI_EN_PREACTIVATING:
         limitationActionState = ::bmcore::BM_LIMITATION_STATE_PREACTIVATING;
         break;
      case most_fi_tcl_e8_BTLimitationActionState::FI_EN_PREACTIVATED:
         limitationActionState = ::bmcore::BM_LIMITATION_STATE_PREACTIVATED;
         break;
      case most_fi_tcl_e8_BTLimitationActionState::FI_EN_ACTIVATING:
         limitationActionState = ::bmcore::BM_LIMITATION_STATE_ACTIVATING;
         break;
      case most_fi_tcl_e8_BTLimitationActionState::FI_EN_ACTIVE:
         limitationActionState = ::bmcore::BM_LIMITATION_STATE_ACTIVE;
         break;
      case most_fi_tcl_e8_BTLimitationActionState::FI_EN_DEACTIVATING:
         limitationActionState = ::bmcore::BM_LIMITATION_STATE_DEACTIVATING;
         break;
      case most_fi_tcl_e8_BTLimitationActionState::FI_EN_WAITING:
         limitationActionState = ::bmcore::BM_LIMITATION_STATE_WAITING;
         break;
      case most_fi_tcl_e8_BTLimitationActionState::FI_EN_ERROR:
         limitationActionState = ::bmcore::BM_LIMITATION_STATE_ERROR;
         break;
      case most_fi_tcl_e8_BTLimitationActionState::FI_EN_ERROR_USER_DENIED:
         limitationActionState = ::bmcore::BM_LIMITATION_STATE_ERROR_USER_DENIED;
         break;
      default:
         limitationActionState = ::bmcore::BM_LIMITATION_STATE_LAST;
         ETG_TRACE_ERR(("Invalid limitationAction"));
         break;
   }

   ETG_TRACE_USR1(("MapLimitationActionStateToInternal::limitationActionState = %d ", limitationActionState));

   return;
}

tVoid FC_Bluetooth_tclCCAService::MapOobTypeToInternal(OobType& oobType, most_fi_tcl_e8_BTOobType e8OobType)
{
   ENTRY_INTERNAL

   switch (e8OobType.enType)
   {
      case most_fi_tcl_e8_BTOobType::FI_EN_GENERIC:
         oobType = ::bmcore::BM_OOB_TYPE_GENERIC;
      break;
      case most_fi_tcl_e8_BTOobType::FI_EN_APPLE:
         oobType = ::bmcore::BM_OOB_TYPE_APPLE;
      break;
      default:
         ETG_TRACE_ERR(("MapOobTypeToInternal: Invalid oobType"));
      break;
   }

   ETG_TRACE_USR1(("MapOobTypeToInternal::oobType = %d ", oobType));

   return;
}

tVoid FC_Bluetooth_tclCCAService::MapFavoriteTypeToInternal(FavoriteType& favoriteType, most_fi_tcl_e8_BTFavoriteType e8FavoriteType)
{
   ENTRY_INTERNAL

   switch (e8FavoriteType.enType)
   {
      case most_fi_tcl_e8_BTFavoriteType::FI_EN_DEVICE:
         favoriteType = ::bmcore::BM_FAVORITE_TYPE_DEVICE;
      break;
      case most_fi_tcl_e8_BTFavoriteType::FI_EN_PROTOCOL_HFP:
         favoriteType = ::bmcore::BM_FAVORITE_TYPE_PROTOCOL_HFP;
      break;
      case most_fi_tcl_e8_BTFavoriteType::FI_EN_PROTOCOL_AVP:
         favoriteType = ::bmcore::BM_FAVORITE_TYPE_PROTOCOL_AVP;
      break;
      default:
         ETG_TRACE_ERR(("MapFavoriteTypeToInternal: Invalid favoriteType"));
      break;
   }

   ETG_TRACE_USR1(("MapFavoriteTypeToInternal::favoriteType = %d ", favoriteType));

   return;
}

tVoid FC_Bluetooth_tclCCAService::MapDeviceUsagePreferenceToInternal(UsagePreference& usagePreference, most_fi_tcl_e8_BTSetUsagePreference e8DeviceUsagePreference)
{
   ENTRY_INTERNAL

   switch (e8DeviceUsagePreference.enType)
   {
      case most_fi_tcl_e8_BTSetUsagePreference::FI_EN_E8CLASSIC_BT:
         usagePreference = BM_UP_CLASSIC_BT;
      break;
      case most_fi_tcl_e8_BTSetUsagePreference::FI_EN_E8CPW:
         usagePreference = BM_UP_CPW;
      break;
      case most_fi_tcl_e8_BTSetUsagePreference::FI_EN_E8TEMP_CLASSIC_BT:
         usagePreference = BM_UP_TEMP_CLASSIC_BT;
      break;
      default:
         ETG_TRACE_ERR(("MapDeviceUsagePreferenceToInternal: Invalid UsagePreference"));
      break;
   }

   ETG_TRACE_USR1(("MapDeviceUsagePreferenceToInternal::UsagePreference = %d ", usagePreference));

   return;
}

tVoid FC_Bluetooth_tclCCAService::MapBTProfileToInternal(Protocol& protocol, most_fi_tcl_e8_BTProfile e8BTProfile, Uuid uuid)
{
   ENTRY_INTERNAL

   protocol._protocolId = BM_PROTOCOL_ID_UNKNOWN;
   protocol._uuid = "";

   switch (e8BTProfile.enType)
   {
      case most_fi_tcl_e8_BTProfile::FI_EN_E8BT_PROFILE_HFP:
         protocol._protocolId = BM_PROTOCOL_ID_HFP;
      break;
      case most_fi_tcl_e8_BTProfile::FI_EN_E8BT_PROFILE_AVP:
         protocol._protocolId = BM_PROTOCOL_ID_AVP;
      break;
      case most_fi_tcl_e8_BTProfile::FI_EN_E8BT_PROFILE_PAN:
         protocol._protocolId = BM_PROTOCOL_ID_PAN;
      break;
      case most_fi_tcl_e8_BTProfile::FI_EN_E8BT_PROFILE_PBAP:
         protocol._protocolId = BM_PROTOCOL_ID_PBDL;
      break;
      case most_fi_tcl_e8_BTProfile::FI_EN_E8BT_PROFILE_MAP:
         protocol._protocolId = BM_PROTOCOL_ID_MSG;
      break;
      case most_fi_tcl_e8_BTProfile::FI_EN_E8BT_PROFILE_SPP:
         protocol._protocolId = BM_PROTOCOL_ID_SPP;
         protocol._uuid = uuid;
      break;
      default:
         ETG_TRACE_ERR(("MapBTProfileToInternal: Invalid Profile"));
      break;
   }

   ETG_TRACE_USR1(("MapBTProfileToInternal::protocolId - %d uuid - %50s", protocol._protocolId, protocol._uuid.c_str()));

   return;
}

tVoid FC_Bluetooth_tclCCAService::MapProfileUsageTypeToInternal(BTProfileUsageType& profileUsageType, most_fi_tcl_e8_BTProfileUsageType e8BTProfileUsageType)
{
   ENTRY_INTERNAL

   switch (e8BTProfileUsageType.enType)
   {
      case most_fi_tcl_e8_BTProfileUsageType::FI_EN_E8PROFILE_USAGE_NONE:
         profileUsageType = BT_PROFILE_USAGE_NONE;
      break;
      case most_fi_tcl_e8_BTProfileUsageType::FI_EN_E8PROFILE_USAGE_GENERIC:
         profileUsageType = BT_PROFILE_USAGE_GENERIC;
      break;
      case most_fi_tcl_e8_BTProfileUsageType::FI_EN_E8PROFILE_USAGE_ACTIVE_CALL:
         profileUsageType= BT_PROFILE_USAGE_ACTIVE_CALL;
      break;
      case most_fi_tcl_e8_BTProfileUsageType::FI_EN_E8PROFILE_USAGE_AUDIO_STREAMING:
         profileUsageType = BT_PROFILE_USAGE_AUDIO_STREAMING;
      break;
      default:
         ETG_TRACE_ERR(("MapProfileUsageTypeToInternal: Invalid Profile"));
      break;
   }

   ETG_TRACE_USR1(("MapProfileUsageTypeToInternal::profileUsageType - %d", profileUsageType));

   return;
}

tVoid FC_Bluetooth_tclCCAService::MapResolutionTypeToInternal(UserDecision& userDecision, most_fi_tcl_e8_BTResolutionType e8BTResolutionType)
{
   ENTRY_INTERNAL

   switch (e8BTResolutionType.enType)
   {
      case most_fi_tcl_e8_BTResolutionType::FI_EN_E8RESOLUTION_TYPE_PROCEED:
         userDecision = BM_USER_DECISION_PROCEED;
      break;
      case most_fi_tcl_e8_BTResolutionType::FI_EN_E8RESOLUTION_TYPE_CANCEL:
         userDecision = BM_USER_DECISION_CANCEL;
      break;
      default:
         ETG_TRACE_ERR(("MapResolutionTypeToInternal: Invalid Resolution Type"));
      break;
   }

   ETG_TRACE_USR1(("MapResolutionTypeToInternal::userDecision = %d ", userDecision));

   return;
}

tVoid FC_Bluetooth_tclCCAService::MapConflictTriggerToInternal(ConflictTrigger& conflictTrigger, most_fi_tcl_e8_BTConflictTrigger e8BTConflictTrigger)
{
   ENTRY_INTERNAL

   switch (e8BTConflictTrigger.enType)
   {
      case most_fi_tcl_e8_BTConflictTrigger::FI_EN_E8NONE:
         conflictTrigger = BM_CONFLICT_TRIGGER_NONE;
      break;
      case most_fi_tcl_e8_BTConflictTrigger::FI_EN_E8BT_PAIRING:
         conflictTrigger = BM_CONFLICT_TRIGGER_BT_PAIRING;
      break;
      case most_fi_tcl_e8_BTConflictTrigger::FI_EN_E8OOB_BT_PAIRING:
         conflictTrigger = BM_CONFLICT_TRIGGER_OOB_BT_PAIRING;
      break;
      case most_fi_tcl_e8_BTConflictTrigger::FI_EN_E8AAP_USB:
         conflictTrigger = BM_CONFLICT_TRIGGER_AAP_USB;
      break;
      case most_fi_tcl_e8_BTConflictTrigger::FI_EN_E8AAP_WIRELESS:
         conflictTrigger = BM_CONFLICT_TRIGGER_AAP_WIRELESS;
      break;
      case most_fi_tcl_e8_BTConflictTrigger::FI_EN_E8CP_USB:
         conflictTrigger = BM_CONFLICT_TRIGGER_CP_USB;
      break;
      case most_fi_tcl_e8_BTConflictTrigger::FI_EN_E8CP_WIRELESS:
         conflictTrigger = BM_CONFLICT_TRIGGER_CP_WIRELESS;
      break;
      case most_fi_tcl_e8_BTConflictTrigger::FI_EN_E8CARLIFE_USB:
         conflictTrigger = BM_CONFLICT_TRIGGER_CARLIFE_USB;
      break;
      case most_fi_tcl_e8_BTConflictTrigger::FI_EN_E8CARLIFE_IOS_USB:
         conflictTrigger = BM_CONFLICT_TRIGGER_CARLIFE_IOS_USB;
      break;
      case most_fi_tcl_e8_BTConflictTrigger::FI_EN_E8ONCAR_USB:
         conflictTrigger = BM_CONFLICT_TRIGGER_ONCAR_USB;
      break;
      case most_fi_tcl_e8_BTConflictTrigger::FI_EN_E8ONCAR_IOS_USB:
         conflictTrigger = BM_CONFLICT_TRIGGER_ONCAR_IOS_USB;
      break;
      case most_fi_tcl_e8_BTConflictTrigger::FI_EN_E8MIRRORLINK_USB:
         conflictTrigger = BM_CONFLICT_TRIGGER_MIRRORLINK_USB;
      break;
      case most_fi_tcl_e8_BTConflictTrigger::FI_EN_E8MIRRORLINK_IOS_USB:
         conflictTrigger = BM_CONFLICT_TRIGGER_MIRRORLINK_IOS_USB;
      break;
      case most_fi_tcl_e8_BTConflictTrigger::FI_EN_E8MYSPIN_USB:
         conflictTrigger = BM_CONFLICT_TRIGGER_MYSPIN_USB;
      break;
      case most_fi_tcl_e8_BTConflictTrigger::FI_EN_E8MYSPIN_IOS_USB:
         conflictTrigger = BM_CONFLICT_TRIGGER_MYSPIN_IOS_USB;
      break;
      default:
         ETG_TRACE_ERR(("MapConflictTriggerToInternal: Invalid conflictTrigger"));
      break;
   }

   ETG_TRACE_USR1(("MapConflictTriggerToInternal::conflictTrigger = %d ", conflictTrigger));

   return;
}

tVoid FC_Bluetooth_tclCCAService::MapBTUserAvailabilityToInternal(bool& available, most_fi_tcl_e8_BTUserAvailable e8UserAvailable)
{
   ENTRY_INTERNAL

   switch (e8UserAvailable.enType)
   {
      case most_fi_tcl_e8_BTUserAvailable::FI_EN_E8USER_NOT_AVAILABLE:
         available  = false;
      break;
      case most_fi_tcl_e8_BTUserAvailable::FI_EN_E8USER_AVAILABLE:
         available  = true;
      break;
      default:
         ETG_TRACE_ERR(("MapBTUserAvailabilityToInternal: Invalid User available"));
         available  = false;
      break;
   }

   ETG_TRACE_USR1(("MapBTUserAvailabilityToInternal::available - %d", available));

   return;
}

/**
 *Type conversions (Internal to MOST)
 */
//TODO: to be completed
void FC_Bluetooth_tclCCAService::MapDeviceStatusTypeToMOST(most_fi_tcl_e8_BTSetDeviceStatus &mostDeviceStatus,
      const ConnectionStatus connectionStatus, tBool bHFP)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("MapDeviceStatusTypeToMOST::connectionStatus = %d ", connectionStatus));

   // TODO
   switch (connectionStatus)
   {
      case BM_CONNECTION_STATUS_CONNECTED:
      case BM_CONNECTION_STATUS_DISCONNECTING:
         if (bHFP == TRUE)
         {
            mostDeviceStatus.enType = most_fi_tcl_e8_BTSetDeviceStatus::FI_EN_E8DEVICE_CONNECTED_OSD;
         }
         else
         {
            mostDeviceStatus.enType = most_fi_tcl_e8_BTSetDeviceStatus::FI_EN_E8DEVICE_CONNECTED;
         }
      break;
      case BM_CONNECTION_STATUS_CONNECTING:
      case BM_CONNECTION_STATUS_DISCONNECTED:
         mostDeviceStatus.enType = most_fi_tcl_e8_BTSetDeviceStatus::FI_EN_E8DEVICE_DISCONNECTED;
      break;
      case BM_CONNECTION_STATUS_UNKNOWN:
         mostDeviceStatus.enType = most_fi_tcl_e8_BTSetDeviceStatus::FI_EN_E8DEVICE_DELETED;
      break;
         //todo (added by Stefan): BM_CONNECTION_STATUS_BLOCKED has been removed from ConnectionStatus,
         // so I commented the following two lines
         /*
          case BM_CONNECTION_STATUS_BLOCKED:
          break;
          */
         //case BM_CONNECTION_STATUS_DISCONNECTED: // TODO
         //mostConnectionResult.enType = most_fi_tcl_e8_BTSetConnectionResult::FI_EN_E8DEVICE_NOT_CONNECTED; // TODO
         //break;
      default:
         ETG_TRACE_ERR(("Invalid connection status"));
      break;
   }
}

void FC_Bluetooth_tclCCAService::MapConnectionStatusTypeToMOST(most_fi_tcl_e8_BTConnectionStatus &mostConnectionStatus,
      ConnectionStatus connectionStatus)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("MapConnectionStatusTypeToMOST::connectionStatus = %d ", connectionStatus));

   switch (connectionStatus)
   {
      case BM_CONNECTION_STATUS_CONNECTED:
         mostConnectionStatus.enType = most_fi_tcl_e8_BTConnectionStatus::FI_EN_E8STATUS_CONNECTED;
      break;
      case BM_CONNECTION_STATUS_DISCONNECTED:
         mostConnectionStatus.enType = most_fi_tcl_e8_BTConnectionStatus::FI_EN_E8STATUS_DISCONNECTED;
      break;
      case BM_CONNECTION_STATUS_CONNECTING:
         mostConnectionStatus.enType = most_fi_tcl_e8_BTConnectionStatus::FI_EN_E8STATUS_CONNECTING;
      break;
      case BM_CONNECTION_STATUS_DISCONNECTING:
         mostConnectionStatus.enType = most_fi_tcl_e8_BTConnectionStatus::FI_EN_E8STATUS_DISCONNECTING;
      break;
      default:
         ETG_TRACE_ERR(("Invalid connection status"));
      break;
   }
}

void FC_Bluetooth_tclCCAService::MapDeviceDisconnectedReasonToMOST(most_fi_tcl_e8_BTSetDeviceDisconnectedReason &mostDeviceDisconnectedReason,
      const DisconnectedReason disconnectedReason)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("MapDeviceDisconnectedReasonToMOST::disconnectedReason = %d ", disconnectedReason));

   switch (disconnectedReason)
   {
      case BM_DISCONNECTED_REASON_NORMAL_LOSS_LOCAL:
         mostDeviceDisconnectedReason.enType = most_fi_tcl_e8_BTSetDeviceDisconnectedReason::FI_EN_E8MODULE_REQUEST;
      break;
      case BM_DISCONNECTED_REASON_NORMAL_LOSS_REMOTE:
         mostDeviceDisconnectedReason.enType = most_fi_tcl_e8_BTSetDeviceDisconnectedReason::FI_EN_E8DEVICE_REQUEST;
      break;
      case BM_DISCONNECTED_REASON_ABNORMAL_LOSS:
         mostDeviceDisconnectedReason.enType = most_fi_tcl_e8_BTSetDeviceDisconnectedReason::FI_EN_E8OUT_OF_RANGE;
      break;
      case BM_DISCONNECTED_REASON_AUTOMATIC:
         mostDeviceDisconnectedReason.enType = most_fi_tcl_e8_BTSetDeviceDisconnectedReason::FI_EN_E8AUTOMATIC;
      break;
      case BM_DISCONNECTED_REASON_TEMPORARILY:
         mostDeviceDisconnectedReason.enType = most_fi_tcl_e8_BTSetDeviceDisconnectedReason::FI_EN_E8INTERMEDIATE;
      break;
      case BM_DISCONNECTED_REASON_UNKNOWN:
      case BM_DISCONNECTED_REASON_NOT_APPLICABLE:
         mostDeviceDisconnectedReason.enType = most_fi_tcl_e8_BTSetDeviceDisconnectedReason::FI_EN_E8NOT_APPLICABLE;
      break;
      case BM_DISCONNECTED_REASON_CONNECTION_FAILED_TIMEOUT:
         mostDeviceDisconnectedReason.enType = most_fi_tcl_e8_BTSetDeviceDisconnectedReason::FI_EN_E8CONNECT_TIMEOUT;
      break;
      case BM_DISCONNECTED_REASON_CONNECTION_FAILED:
      case BM_DISCONNECTED_REASON_CONNECTION_FAILED_LIMIT_REACHED:
      case BM_DISCONNECTED_REASON_OUT_OF_RANGE:
         mostDeviceDisconnectedReason.enType = most_fi_tcl_e8_BTSetDeviceDisconnectedReason::FI_EN_E8CONNECT_FAILED;
      break;
      case BM_DISCONNECTED_REASON_CONNECTION_FAILED_REJECTED:
         mostDeviceDisconnectedReason.enType = most_fi_tcl_e8_BTSetDeviceDisconnectedReason::FI_EN_E8CONNECT_REJECTED;
      break;
      case BM_DISCONNECTED_REASON_CONNECTION_FAILED_NOT_SUPPORTED:
         mostDeviceDisconnectedReason.enType = most_fi_tcl_e8_BTSetDeviceDisconnectedReason::FI_EN_E8PROTOCOL_NOT_SUPPORTED;
      break;
      case BM_DISCONNECTED_REASON_MISSING_LINK_KEY:
         mostDeviceDisconnectedReason.enType = most_fi_tcl_e8_BTSetDeviceDisconnectedReason::FI_EN_E8LINKKEY_MISSING;
      break;
      default:
         ETG_TRACE_ERR(("Invalid disconnected reason"));
      break;
   }
}

void FC_Bluetooth_tclCCAService::MapSppDisconnectionReasonToMOST(most_fi_tcl_e8_BTDisconnectionReason &mostSppDisconnectedReason,
      DisconnectedReason disconnectedReason)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("MapSppDisconnectionReasonToMOST::disconnectedReason = %d ", disconnectedReason));

   switch (disconnectedReason)
   {
      case BM_DISCONNECTED_REASON_NORMAL_LOSS_LOCAL:
         mostSppDisconnectedReason.enType = most_fi_tcl_e8_BTDisconnectionReason::FI_EN_E8HMI_DISCONNECT;
      break;
      case BM_DISCONNECTED_REASON_NORMAL_LOSS_REMOTE:
         mostSppDisconnectedReason.enType = most_fi_tcl_e8_BTDisconnectionReason::FI_EN_E8REMOTE_DISCONNECT;
         break;
      case BM_DISCONNECTED_REASON_CONNECTION_FAILED_UUID_NOT_SUPPORTED:
         mostSppDisconnectedReason.enType = most_fi_tcl_e8_BTDisconnectionReason::FI_EN_E8UUID_NOT_SUPPORTED;
      break;
      case BM_DISCONNECTED_REASON_ABNORMAL_LOSS:
         mostSppDisconnectedReason.enType = most_fi_tcl_e8_BTDisconnectionReason::FI_EN_E8LOST;
      break;
      case BM_DISCONNECTED_REASON_AUTOMATIC:
         mostSppDisconnectedReason.enType = most_fi_tcl_e8_BTDisconnectionReason::FI_EN_E8AUTOMATIC;
         break;
      case BM_DISCONNECTED_REASON_TEMPORARILY:
         mostSppDisconnectedReason.enType = most_fi_tcl_e8_BTDisconnectionReason::FI_EN_E8INTERMEDIATE;
         break;
      case BM_DISCONNECTED_REASON_UNKNOWN:
      case BM_DISCONNECTED_REASON_NOT_APPLICABLE:
         mostSppDisconnectedReason.enType = most_fi_tcl_e8_BTDisconnectionReason::FI_EN_E8NOT_APPLICABLE;
         break;
      case BM_DISCONNECTED_REASON_CONNECTION_FAILED_TIMEOUT:
         mostSppDisconnectedReason.enType = most_fi_tcl_e8_BTDisconnectionReason::FI_EN_E8CONNECT_TIMEOUT;
         break;
      case BM_DISCONNECTED_REASON_CONNECTION_FAILED:
      case BM_DISCONNECTED_REASON_CONNECTION_FAILED_LIMIT_REACHED:
      case BM_DISCONNECTED_REASON_MISSING_LINK_KEY:
      case BM_DISCONNECTED_REASON_OUT_OF_RANGE:
         mostSppDisconnectedReason.enType = most_fi_tcl_e8_BTDisconnectionReason::FI_EN_E8CONNECTION_FAILED;
         break;
      case BM_DISCONNECTED_REASON_CONNECTION_FAILED_REJECTED:
         mostSppDisconnectedReason.enType = most_fi_tcl_e8_BTDisconnectionReason::FI_EN_E8CONNECT_REJECTED;
         break;
      case BM_DISCONNECTED_REASON_NONE:
         mostSppDisconnectedReason.enType = most_fi_tcl_e8_BTDisconnectionReason::FI_EN_E8NONE;
         break;
      default:
         ETG_TRACE_ERR(("Invalid disconnected status"));
      break;
   }
}

void FC_Bluetooth_tclCCAService::MapPairingStatusTypeToMOST(most_fi_tcl_e8_BTSetPairingStatusType &mostPairingStatusType,
      const PairingResult pairingResult)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("MapPairingStatusTypeToMOST::pairingResult = %d ", pairingResult));

   //TODO: check this mapping again!!!
   switch (pairingResult)
   {
      case BM_PAIRING_RESULT_OK:
         mostPairingStatusType.enType = most_fi_tcl_e8_BTSetPairingStatusType::FI_EN_E8PAIRING_STATUS_SUCCESSFUL;
      break;
      case BM_PAIRING_RESULT_ERR_START_PAIRING_FAILED:
      case BM_PAIRING_RESULT_ERR_NOT_PAIRABLE:
      case BM_PAIRING_RESULT_ERR_GENERAL:
      case BM_PAIRING_RESULT_ERR_NO_RESSOURCE_AVAILABLE:
         mostPairingStatusType.enType = most_fi_tcl_e8_BTSetPairingStatusType::FI_EN_E8PAIRING_STATUS_UNSUCCESSFUL;
      break;
      case BM_PAIRING_RESULT_ERR_NOT_PAIRABLE_AFTER_TIMEOUT:
         mostPairingStatusType.enType = most_fi_tcl_e8_BTSetPairingStatusType::FI_EN_E8PAIRING_STATUS_TIMEOUT;
      break;
      case BM_PAIRING_RESULT_ERR_PAIRING_REJECTED:
      case BM_PAIRING_RESULT_ERR_PAIRING_CANCELED:
         mostPairingStatusType.enType = most_fi_tcl_e8_BTSetPairingStatusType::FI_EN_E8PAIRING_STATUS_CANCELLED;
      break;
      case BM_PAIRING_RESULT_ERR_CONNECTION_LOST:
         mostPairingStatusType.enType = most_fi_tcl_e8_BTSetPairingStatusType::FI_EN_E8PAIRING_STATUS_CONNECTIONLOST;
      break;
      case BM_PAIRING_RESULT_ERR_PAIRING_AUTHENTICATION_FAILED:
      case BM_PAIRING_RESULT_ERR_MISSING_PIN:
         mostPairingStatusType.enType = most_fi_tcl_e8_BTSetPairingStatusType::FI_EN_E8PAIRING_STATUS_AUTHENTICATIONFAILURE;
      break;
      case BM_PAIRING_RESULT_ERR_PAIRING_FAILED_RETRY_KEEP_SESSION:
         mostPairingStatusType.enType = most_fi_tcl_e8_BTSetPairingStatusType::FI_EN_E8PAIRING_STATUS_RETRY_KEEP_SESSION;
      break;
      case BM_PAIRING_RESULT_ERR_PAIRING_FAILED_RETRY_NEW_SESSION:
         mostPairingStatusType.enType = most_fi_tcl_e8_BTSetPairingStatusType::FI_EN_E8PAIRING_STATUS_RETRY_NEW_SESSION;
      break;
      case BM_PAIRING_RESULT_UNKNOWN:
         mostPairingStatusType.enType = most_fi_tcl_e8_BTSetPairingStatusType::FI_EN_E8PAIRING_STATUS_IDLE;
      break;
      default:
      {
         mostPairingStatusType.enType = most_fi_tcl_e8_BTSetPairingStatusType::FI_EN_E8PAIRING_STATUS_IDLE;
         ETG_TRACE_ERR(("Invalid pairingResult type"));
      }
      break;
   }
   return;
}

void FC_Bluetooth_tclCCAService::MapSetPairingResultToMOST(most_fi_tcl_e8_BTSetPairingResult &mostPairingResult,
      const PairingState pairingState)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("MapSetPairingResultToMOST::pairingState = %d ", pairingState));

   switch (pairingState)
   {
      case BM_PAIRING_STATE_IDLE:
         mostPairingResult.enType = most_fi_tcl_e8_BTSetPairingResult::FI_EN_E8PAIRING_STOPPED;
      break;
      case BM_PAIRING_STATE_PAIRING_IN_PROGRESS:
         mostPairingResult.enType = most_fi_tcl_e8_BTSetPairingResult::FI_EN_E8PAIRING_STARTED;
      break;
      default:
         ETG_TRACE_ERR(("Invalid pairing state"));
      break;
   }
}

void FC_Bluetooth_tclCCAService::MapPairingTypeToMOST(most_fi_tcl_e8_BTSetPairingType &mostPairingType,
      const PairingType pairingType)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("MapPairingTypeToMOST::pairingType = %d ", pairingType));

   switch (pairingType)
   {
      case BM_PAIRING_TYPE_LEGACY:
         mostPairingType.enType = most_fi_tcl_e8_BTSetPairingType::FI_EN_E8PAIRING_TYPE_LEGACY;
      break;
      case BM_PAIRING_TYPE_SSP_NUMERIC_COMPARISON:
      case BM_PAIRING_TYPE_SSP_PASSKEY_ENTRY_MODE_INPUT_BY_REMOTE_DEVICE:
      case BM_PAIRING_TYPE_SSP_PASSKEY_ENTRY_MODE_INPUT_BY_LOCAL_DEVICE:
         mostPairingType.enType = most_fi_tcl_e8_BTSetPairingType::FI_EN_E8PAIRING_TYPE_SSP_NUMERIC_COMPARISON;
      break;
      case BM_PAIRING_TYPE_SSP_JUST_WORK:
         mostPairingType.enType = most_fi_tcl_e8_BTSetPairingType::FI_EN_E8PAIRING_TYPE_SSP_JUST_WORKS;
      break;
      default:
      {
         mostPairingType.enType = most_fi_tcl_e8_BTSetPairingType::FI_EN_E8PAIRING_TYPE_LEGACY;
         ETG_TRACE_ERR(("Invalid pairing type"));
      }
      break;
   }
   return;
}

void FC_Bluetooth_tclCCAService::MapOriginTypeToMOST(most_fi_tcl_e8_BTSetOrigin &mostOrigin,
      const PairingRequestOrigin pairingRequestOrigin)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("MapOriginTypeToMOST::pairingRequestOrigin = %d ", pairingRequestOrigin));

   switch (pairingRequestOrigin)
   {
      case BM_PAIRING_REQUEST_ORIGIN_LOCAL:
      {
         mostOrigin.enType = most_fi_tcl_e8_BTSetOrigin::FI_EN_E8SYSTEM;
      }
      break;
      case BM_PAIRING_REQUEST_ORIGIN_REMOTE:
      {
         mostOrigin.enType = most_fi_tcl_e8_BTSetOrigin::FI_EN_E8DEVICE;
      }
      break;
      default:
      {
         mostOrigin.enType = most_fi_tcl_e8_BTSetOrigin::FI_EN_E8DEVICE;
         ETG_TRACE_ERR(("Invalid pairing request origin type"));
      }
      break;
   }
   return;
}

void FC_Bluetooth_tclCCAService::MapBluetoothOnOffStatusToMOST(most_btsetfi_tclMsgBluetoothOnOffStatus &mostBTOnOff,
      const SwitchState switchState)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("MapBluetoothOnOffStatusToMOST::switchState = %d ", switchState));

   //TODO: check this mapping again!!!
   switch (switchState)
   {
      case SWITCH_STATE_SWITCHED_OFF:
      case SWITCH_STATE_SWITCHING_ON:
         mostBTOnOff.bBTOnOff = FALSE;
      break;
      case SWITCH_STATE_SWITCHED_ON:
      case SWITCH_STATE_SWITCHING_OFF:
         mostBTOnOff.bBTOnOff = TRUE;
      break;

      default:
         ETG_TRACE_ERR(("Invalid switch state"));
      break;
   }
   return;
}

void FC_Bluetooth_tclCCAService::MapSupportedProfilesStatusToMOST(
      most_fi_tcl_BTSetSupportedProfiles &mostSupportedProfiles, const ProtocolInfoMap protocolInfoMap)
{
   ENTRY_INTERNAL

   ProtocolInfoMap::const_iterator it;

   for (it = protocolInfoMap.begin(); it != protocolInfoMap.end(); it++)
   {
      ETG_TRACE_USR1(("MapSupportedProfilesStatusToMOST: ProtocolID = %i; isSupported = %d",\
            it->first, it->second._isSupported));

      switch (it->first)
      {
         case BM_PROTOCOL_ID_HFP:
            mostSupportedProfiles.bHFPSupport = it->second._isSupported;
         break;
         case BM_PROTOCOL_ID_AVP:
            mostSupportedProfiles.bA2DPSupport = it->second._isSupported;
            mostSupportedProfiles.bAVRCPSupport = it->second._isSupported;
         break;
         case BM_PROTOCOL_ID_PAN:
            mostSupportedProfiles.bPANSupport = it->second._isSupported;
         break;
         case BM_PROTOCOL_ID_PBDL:
            mostSupportedProfiles.bPBAPSuport = it->second._isSupported;
         break;
         case BM_PROTOCOL_ID_MSG:
            mostSupportedProfiles.bMAPSupport = it->second._isSupported;
         break;
         case BM_PROTOCOL_ID_SPP:
            mostSupportedProfiles.bSPPSupport = it->second._isSupported;
         break;

         default:
            ETG_TRACE_ERR(("Invalid supported profile"));
         break;
      }
   }

   //TODO: DUN, OPP & DIP Protocol support needs to be verified!!!
   mostSupportedProfiles.bDUNSupport = false;
   mostSupportedProfiles.bOPPSupport = false;
   mostSupportedProfiles.bDIPSupport = false;
   return;
}

void FC_Bluetooth_tclCCAService::MapFavoriteProfilesIndexToMOST(
      most_fi_tcl_BTProfileFavoriteIndex &mostBTProfileFavoriteIndex, const ProtocolInfoMap protocolInfoMap)
{
   ENTRY_INTERNAL

   ProtocolInfoMap::const_iterator it;

   for (it = protocolInfoMap.begin(); it != protocolInfoMap.end(); it++)
   {
      ETG_TRACE_USR1(("MapFavoriteProfilesIndexToMOST: ProtocolID = %i; _favoriteIndex = %d",\
            it->first, it->second._favoriteIndex));

      switch (it->first)
      {
         case BM_PROTOCOL_ID_HFP:
            mostBTProfileFavoriteIndex.u8HFP = (tU8)it->second._favoriteIndex;
         break;
         case BM_PROTOCOL_ID_AVP:
            mostBTProfileFavoriteIndex.u8AVP = (tU8)it->second._favoriteIndex;
         break;
         default:
         break;
      }
   }

   return;
}

void FC_Bluetooth_tclCCAService::MapDeviceUsagePreferenceToMOST(
      most_fi_tcl_e8_BTUsagePreference &mostDeviceUsagePreference, const UsagePreference usagePreference)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("MapDeviceUsagePreferenceToMOST: usagePreference = %d", usagePreference));

   switch (usagePreference)
   {
      case BM_UP_UNDECIDED:
         mostDeviceUsagePreference.enType = most_fi_tcl_e8_BTUsagePreference::FI_EN_E8UNDECIDED;
         break;
      case BM_UP_TEMP_CLASSIC_BT:
         mostDeviceUsagePreference.enType = most_fi_tcl_e8_BTUsagePreference::FI_EN_E8TEMP_CLASSIC_BT;
         break;
      case BM_UP_CLASSIC_BT:
         mostDeviceUsagePreference.enType = most_fi_tcl_e8_BTUsagePreference::FI_EN_E8CLASSIC_BT;
         break;
      case BM_UP_CPW:
         mostDeviceUsagePreference.enType = most_fi_tcl_e8_BTUsagePreference::FI_EN_E8CPW;
         break;
      default:
         ETG_TRACE_ERR(("Invalid usage preference"));
         break;
   }

   return;
}

void FC_Bluetooth_tclCCAService::MapDeviceProfilesStatusToMOST(most_fi_tcl_BTServiceType &mostBTServiceType,
      most_fi_tcl_BTProfileConnectionStatus &mostBTProfileConnectionStatus,
      most_fi_tcl_BTProfileDisconnectedReason &mostBTDeviceProfileDisconnectedReason,
      const ProtocolConnectionInfoMap protocolConnectionInfoMap, DeviceId deviceHandle)
{
   ENTRY_INTERNAL
   ProtocolConnectionInfo protocolconnectioninfo;
   ProtocolId protocolId;

   mostBTProfileConnectionStatus.e8HFP.enType = most_fi_tcl_e8_BTConnectionStatus::FI_EN_E8STATUS_DISCONNECTED;
   mostBTProfileConnectionStatus.e8AVP.enType = most_fi_tcl_e8_BTConnectionStatus::FI_EN_E8STATUS_DISCONNECTED;
   mostBTProfileConnectionStatus.e8PAN.enType = most_fi_tcl_e8_BTConnectionStatus::FI_EN_E8STATUS_DISCONNECTED;
   mostBTProfileConnectionStatus.e8PBAP.enType = most_fi_tcl_e8_BTConnectionStatus::FI_EN_E8STATUS_DISCONNECTED;
   mostBTProfileConnectionStatus.e8MAP.enType = most_fi_tcl_e8_BTConnectionStatus::FI_EN_E8STATUS_DISCONNECTED;

   for (ProtocolConnectionInfoMap::const_iterator ItProConInfoMap = protocolConnectionInfoMap.begin();
         ItProConInfoMap != protocolConnectionInfoMap.end();
         ItProConInfoMap++)
   {
      protocolId = ItProConInfoMap->first;
      protocolconnectioninfo = ItProConInfoMap->second;

      ETG_TRACE_USR1(("MapDeviceProfilesStatusToMOST::protocolId = %d _connectionStatus - %d",
            protocolId, protocolconnectioninfo._connectionStatus));

      if (protocolId == BM_PROTOCOL_ID_HFP)
      {
         if(protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_CONNECTED)
         {
            mostBTServiceType.bHFP = TRUE;
         }
         else if((protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_DISCONNECTED) ||
               (protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_CONNECTING))
         {
            mostBTServiceType.bHFP = FALSE;
         }
         else
         {
            vSetPrevProfileStatus(deviceHandle, protocolId, mostBTServiceType.bHFP);
         }

         MapDeviceDisconnectedReasonToMOST(mostBTDeviceProfileDisconnectedReason.e8HFP, protocolconnectioninfo._disconnectedReason);
         MapConnectionStatusTypeToMOST(mostBTProfileConnectionStatus.e8HFP, protocolconnectioninfo._connectionStatus);
      }

      if (protocolId == BM_PROTOCOL_ID_AVP)
      {
         if(protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_CONNECTED)
         {
            mostBTServiceType.bAVP = TRUE;
         }
         else if((protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_DISCONNECTED) ||
               (protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_CONNECTING))
         {
            mostBTServiceType.bAVP = FALSE;
         }
         else
         {
            vSetPrevProfileStatus(deviceHandle, protocolId, mostBTServiceType.bAVP);
         }

         MapDeviceDisconnectedReasonToMOST(mostBTDeviceProfileDisconnectedReason.e8AVP, protocolconnectioninfo._disconnectedReason);
         MapConnectionStatusTypeToMOST(mostBTProfileConnectionStatus.e8AVP, protocolconnectioninfo._connectionStatus);
      }

      if (protocolId == BM_PROTOCOL_ID_PAN)
      {
         if(protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_CONNECTED)
         {
            mostBTServiceType.bPAN = TRUE;
         }
         else if((protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_DISCONNECTED) ||
               (protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_CONNECTING))
         {
            mostBTServiceType.bPAN = FALSE;
         }
         else
         {
            vSetPrevProfileStatus(deviceHandle, protocolId, mostBTServiceType.bPAN);
         }

         MapDeviceDisconnectedReasonToMOST(mostBTDeviceProfileDisconnectedReason.e8PAN, protocolconnectioninfo._disconnectedReason);
         MapConnectionStatusTypeToMOST(mostBTProfileConnectionStatus.e8PAN, protocolconnectioninfo._connectionStatus);
      }

      if (protocolId == BM_PROTOCOL_ID_PBDL)
      {
         if(protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_CONNECTED)
         {
            mostBTServiceType.bPBAP = TRUE;
         }
         else if((protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_DISCONNECTED) ||
               (protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_CONNECTING))
         {
            mostBTServiceType.bPBAP = FALSE;
         }
         else
         {
            vSetPrevProfileStatus(deviceHandle, protocolId, mostBTServiceType.bPBAP);
         }

         MapDeviceDisconnectedReasonToMOST(mostBTDeviceProfileDisconnectedReason.e8PBAP, protocolconnectioninfo._disconnectedReason);
         MapConnectionStatusTypeToMOST(mostBTProfileConnectionStatus.e8PBAP, protocolconnectioninfo._connectionStatus);
      }

      if (protocolId == BM_PROTOCOL_ID_MSG)
      {
         if(protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_CONNECTED)
         {
            mostBTServiceType.bMAP = TRUE;
         }
         else if((protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_DISCONNECTED) ||
               (protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_CONNECTING))
         {
            mostBTServiceType.bMAP = FALSE;
         }
         else
         {
            vSetPrevProfileStatus(deviceHandle, protocolId, mostBTServiceType.bMAP);
         }

         MapDeviceDisconnectedReasonToMOST(mostBTDeviceProfileDisconnectedReason.e8MAP, protocolconnectioninfo._disconnectedReason);
         MapConnectionStatusTypeToMOST(mostBTProfileConnectionStatus.e8MAP, protocolconnectioninfo._connectionStatus);
      }
   }

   return;
}

void FC_Bluetooth_tclCCAService::MapOutgoingSourceStatusToMOST(tBool &bOutgoingSourceStatus,
      const ProtocolConnectionInfoMap protocolConnectionInfoMap)
{
   ENTRY_INTERNAL
   ProtocolConnectionInfo protocolconnectioninfo;
   ProtocolId protocolId;

   for (ProtocolConnectionInfoMap::const_iterator ItProConInfoMap = protocolConnectionInfoMap.begin();
         ItProConInfoMap != protocolConnectionInfoMap.end();
         ItProConInfoMap++)
   {
      protocolId = ItProConInfoMap->first;
      protocolconnectioninfo = ItProConInfoMap->second;

      ETG_TRACE_USR1(("MapOutgoingSourceStatusToMOST::protocolId = %d _connectionStatus - %d",
            protocolId, protocolconnectioninfo._connectionStatus));

      // TODO: Not Connected status to be confirmed from BMCore
      if (protocolId == BM_PROTOCOL_ID_HFP)
      {
         if(protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_CONNECTED)
         {
            bOutgoingSourceStatus = TRUE;
         }
         else
         {
            bOutgoingSourceStatus = FALSE;
         }
         break;
      }
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::vCheckAVPConnectionStatus(tBool &bAVPStatus, ProtocolConnectionInfoMap protocolConnectionInfoMap)
{
   ENTRY_INTERNAL
   ProtocolConnectionInfo protocolconnectioninfo;
   ProtocolId protocolId;

   for (ProtocolConnectionInfoMap::const_iterator ItProConInfoMap = protocolConnectionInfoMap.begin();
         ItProConInfoMap != protocolConnectionInfoMap.end();
         ItProConInfoMap++)
   {
      protocolId = ItProConInfoMap->first;
      protocolconnectioninfo = ItProConInfoMap->second;

      ETG_TRACE_USR1(("vCheckAVPConnectionStatus::protocolId = %d _connectionStatus - %d",
            protocolId, protocolconnectioninfo._connectionStatus));

      // TODO: Not Connected status to be confirmed from BMCore
      if (protocolId == BM_PROTOCOL_ID_AVP)
      {
         if ((protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_CONNECTED) ||
             (protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_DISCONNECTING))
         {
            bAVPStatus = TRUE;
         }
         else
         {
            bAVPStatus = FALSE;
         }
         break;
      }
   }

   return;
}

void FC_Bluetooth_tclCCAService::MapMajorDeviceClassTypeToMOST(most_fi_tcl_e8_BTSetMajorDeviceClass &mostMajorClass,
      const BTSMajorDeviceClass majorDeviceClass)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("MapMajorDeviceClassTypeToMOST::majorDeviceClass = %d ", majorDeviceClass));

   switch (majorDeviceClass)
   {
      case BTS_COD_MAJORDC_PHONE:
         mostMajorClass.enType = most_fi_tcl_e8_BTSetMajorDeviceClass::FI_EN_E8MAJOR_DEVICE_CLASS_PHONE;
      break;
      case BTS_COD_MAJORDC_AUDIO:
         mostMajorClass.enType = most_fi_tcl_e8_BTSetMajorDeviceClass::FI_EN_E8MAJOR_DEVICE_CLASS_AUDIOVIDEO;
      break;
      case BTS_COD_MAJORDC_COMPUTER:
         mostMajorClass.enType = most_fi_tcl_e8_BTSetMajorDeviceClass::FI_EN_E8MAJOR_DEVICE_CLASS_COMPUTER;
      break;
      case BTS_COD_MAJORDC_LAN:
         mostMajorClass.enType = most_fi_tcl_e8_BTSetMajorDeviceClass::FI_EN_E8MAJOR_DEVICE_CLASS_LANORNAP;
      break;

      default:
         ETG_TRACE_ERR(("Invalid major device class type"));
      break;
   }
   return;
}

void FC_Bluetooth_tclCCAService::MapDeviceIdentificationToMOST(
      most_fi_tcl_BTSetDeviceIdentification &mostDeviceIdentification, const DeviceIdentification deviceIdentification)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("MapDeviceIdentificationToMOST::_vendorIdSource = %d _vendorId = %d _productId = %d version = %d",
         deviceIdentification._vendorIdSource, deviceIdentification._vendorId,deviceIdentification._productId,
         deviceIdentification._version));

   mostDeviceIdentification.u16VendorIDSource = deviceIdentification._vendorIdSource;
   mostDeviceIdentification.u16VendorID = deviceIdentification._vendorId;
   mostDeviceIdentification.u16ProductID = deviceIdentification._productId;
   mostDeviceIdentification.u16ProductVersion = deviceIdentification._version;
   return;
}

void FC_Bluetooth_tclCCAService::MapsecondsToMOST(most_fi_tcl_BTSetDateTimeStamp &mostDateTimeStamp,
      const unsigned long long int seconds)
{
   ENTRY_INTERNAL
   struct tm *gmtm;
   char buffer [10] ={" "};
   const char* strstream = OSAL_NULL;

   time_t seconds_t = (time_t)seconds;
   gmtm = gmtime(&seconds_t); //TODO

   //Set Connected Date Time Stamp
   sprintf(buffer, "%d", (gmtm->tm_year +  1900));
   strstream = (const char *)buffer;
   mostDateTimeStamp.oDateStamp.sCldrYear.bSet(strstream, most_fi_tcl_String::FI_EN_UTF8);
   ETG_TRACE_USR1(("MapsecondsToMOST:: sCldrYear %s",mostDateTimeStamp.oDateStamp.sCldrYear.szValue));

   sprintf(buffer, "%d", (gmtm->tm_mon + 1));
   strstream = (const char *)buffer;
   mostDateTimeStamp.oDateStamp.sCldrMonth.bSet(strstream, most_fi_tcl_String::FI_EN_UTF8);
   ETG_TRACE_USR1(("MapsecondsToMOST:: sCldrMonth %s", mostDateTimeStamp.oDateStamp.sCldrMonth.szValue));

   sprintf(buffer, "%d", gmtm->tm_mday);
   strstream = (const char *)buffer;
   mostDateTimeStamp.oDateStamp.sCldrDay.bSet(strstream, most_fi_tcl_String::FI_EN_UTF8);
   ETG_TRACE_USR1(("MapsecondsToMOST:: sCldrDay %s", mostDateTimeStamp.oDateStamp.sCldrDay.szValue));

   sprintf(buffer, "%d", gmtm->tm_hour);
   strstream = (const char *)buffer;
   mostDateTimeStamp.oTimeStamp.sHours.bSet(strstream, most_fi_tcl_String::FI_EN_UTF8);
   ETG_TRACE_USR1(("MapsecondsToMOST:: sHours %s", mostDateTimeStamp.oTimeStamp.sHours.szValue));

   sprintf(buffer, "%d", gmtm->tm_min);
   strstream = (const char *)buffer;
   mostDateTimeStamp.oTimeStamp.sMinutes.bSet(strstream, most_fi_tcl_String::FI_EN_UTF8);
   ETG_TRACE_USR1(("MapsecondsToMOST:: sMinute %s", mostDateTimeStamp.oTimeStamp.sMinutes.szValue));

   sprintf(buffer, "%d", gmtm->tm_sec);
   strstream = (const char *)buffer;
   mostDateTimeStamp.oTimeStamp.sSeconds.bSet(strstream, most_fi_tcl_String::FI_EN_UTF8);

   ETG_TRACE_USR1(("MapsecondsToMOST:: Seconds %s", mostDateTimeStamp.oTimeStamp.sSeconds.szValue));

   return;
}

void FC_Bluetooth_tclCCAService::MapSwitchStatusToMOST(most_fi_tcl_e8_BTSetScanningState &mostScanningState,
      const SwitchStatus& btSwitchStatus, tBool bResponse)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("MapSwitchStatusToMOST::_switchState = %d ", btSwitchStatus._switchState));

   switch (btSwitchStatus._switchState)
   {
      case SWITCH_STATE_SWITCHED_OFF:
      case SWITCH_STATE_SWITCHING_ON:
         if(bResponse == TRUE)
         {
            mostScanningState.enType = most_fi_tcl_e8_BTSetScanningState::FI_EN_E8SCANNING_ALREADY_STOPPED;
         }
         else
         {
            mostScanningState.enType = most_fi_tcl_e8_BTSetScanningState::FI_EN_E8SCANNING_STOPPED;
         }
      break;
      case SWITCH_STATE_SWITCHED_ON:
      case SWITCH_STATE_SWITCHING_OFF:
         if(bResponse == TRUE)
         {
            mostScanningState.enType = most_fi_tcl_e8_BTSetScanningState::FI_EN_E8SCANNING_ALREADY_STARTED;
         }
         else
         {
            mostScanningState.enType = most_fi_tcl_e8_BTSetScanningState::FI_EN_E8SCANNING_STARTED;
         }
      break;

      default:
         ETG_TRACE_ERR(("MapSwitchStatusToMOST: Invalid state"));
      break;
   }
   return;
}

void FC_Bluetooth_tclCCAService::MapBluetoothFeatureSupportToMOST(most_fi_tcl_BTSetBluetoothFeatureSupport &mostBluetoothFeatureSupport,
      const ProtocolInfoMap protocolInfoMap, tU8 u8DeviceHandle)
{
   ENTRY_INTERNAL

   ProtocolInfoMap::const_iterator it;
   tBool bPANSupport = false;
   //tBool bDUNSupport = false;

   DeviceConnectionStatusList deviceConnectionStatusList;
   tBool bAVPStatus = FALSE;
   DeviceConnectionInfoList::iterator  connListIt;

   ETG_TRACE_USR1((" MapBluetoothFeatureSupportToMOST ::DeviceHandle - %d", u8DeviceHandle));

   for (it = protocolInfoMap.begin(); it != protocolInfoMap.end(); it++)
   {
      ETG_TRACE_USR1(("MapBluetoothFeatureSupportToMOST: ProtocolID = %i; isSupported = %d",
            it->first, it->second._isSupported));

      switch (it->first)
      {
         case BM_PROTOCOL_ID_HFP:
            mostBluetoothFeatureSupport.bHandsFreeSupport = it->second._isSupported;
         break;
         case BM_PROTOCOL_ID_AVP:

            vGetDeviceConnectionStatusList(deviceConnectionStatusList);

            connListIt = std::find_if(deviceConnectionStatusList._deviceConnectionInfoList.begin(),
                  deviceConnectionStatusList._deviceConnectionInfoList.end(),
                  MeetsDeviceHandle<DeviceConnectionInfo>(u8DeviceHandle));

            if (connListIt != deviceConnectionStatusList._deviceConnectionInfoList.end())
            {
               if((connListIt->_connectionStatus == BM_CONNECTION_STATUS_CONNECTED) ||
                  (connListIt->_connectionStatus == BM_CONNECTION_STATUS_DISCONNECTING))
               {
                  vCheckAVPConnectionStatus(bAVPStatus, connListIt->_protocolConnectionInfo);
               }
            }

            if(bAVPStatus == TRUE)
            {
               MapAudioStreamingSupportTypeToMOST(mostBluetoothFeatureSupport.e8AudioStreamingSupportType, it->second._version);
            }
            else
            {
               mostBluetoothFeatureSupport.e8AudioStreamingSupportType.enType = most_fi_tcl_e8_BTSetAudioStreamingSupportType::FI_EN_E8DEFAULT;
            }

            //It always false because BT settings not support audiostreaming
            mostBluetoothFeatureSupport.bAudioStreamingSupport = FALSE;

            ETG_TRACE_USR1((" MapBluetoothFeatureSupportToMOST ::bAudioStreamingSupport - %d", mostBluetoothFeatureSupport.bAudioStreamingSupport));
            ETG_TRACE_USR1((" MapBluetoothFeatureSupportToMOST ::e8AudioStreamingSupportType - %d", mostBluetoothFeatureSupport.e8AudioStreamingSupportType.enType));

         break;
         case BM_PROTOCOL_ID_PAN:
            mostBluetoothFeatureSupport.bInternetAccessSupport = it->second._isSupported;
            bPANSupport = it->second._isSupported;
            //bDUNSupport = false;
         break;
         case BM_PROTOCOL_ID_PBDL:
            mostBluetoothFeatureSupport.bPhoneBookSupport = it->second._isSupported;
         break;
         case BM_PROTOCOL_ID_MSG:
            mostBluetoothFeatureSupport.bMessagingSupport = it->second._isSupported;
         break;
         case BM_PROTOCOL_ID_SPP:
            mostBluetoothFeatureSupport.bSerialPortSupport = it->second._isSupported;
         break;
         default:
            ETG_TRACE_ERR(("Invalid supported profile"));
         break;
      }
   }

   mostBluetoothFeatureSupport.bPortableNavigationSupport = false;

   //!Fix for CID 20283: Logically dead code (DEADCODE)
   if(bPANSupport  == true)
   {
      mostBluetoothFeatureSupport.e8InternetAccessSupportType.enType = most_fi_tcl_e8_BTSetInternetAccessSupportType::FI_EN_E8PAN_SUPPORTED;
   }
   /*if((bDUNSupport  == true) && (bPANSupport == true))
   {
      mostBluetoothFeatureSupport.e8InternetAccessSupportType.enType = most_fi_tcl_e8_BTSetInternetAccessSupportType::FI_EN_E8DUN_PAN_SUPPORTED;
   }
   else if(bPANSupport  == true)
   {
      mostBluetoothFeatureSupport.e8InternetAccessSupportType.enType = most_fi_tcl_e8_BTSetInternetAccessSupportType::FI_EN_E8PAN_SUPPORTED;
   }
   else if(bDUNSupport  == true)
   {
      mostBluetoothFeatureSupport.e8InternetAccessSupportType.enType = most_fi_tcl_e8_BTSetInternetAccessSupportType::FI_EN_E8DUN_SUPPORTED;
   }*/
}

void FC_Bluetooth_tclCCAService::MapAudioStreamingSupportTypeToMOST(most_fi_tcl_e8_BTSetAudioStreamingSupportType
      &mostAudioStreamingSupport, const ProtocolVersion version)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("MapAudioStreamingSupportTypeToMOST: version = %X", version));

   if(version == 0x0100)
   {
      mostAudioStreamingSupport.enType = most_fi_tcl_e8_BTSetAudioStreamingSupportType::FI_EN_E8AVRCP_NO_METADATA;
   }
   else if(version == 0x0103)
   {
      mostAudioStreamingSupport.enType = most_fi_tcl_e8_BTSetAudioStreamingSupportType::FI_EN_E8AVRCP_METADATA;
   }
   else if(version >= 0x0104)
   {
      mostAudioStreamingSupport.enType = most_fi_tcl_e8_BTSetAudioStreamingSupportType::FI_EN_E8AVRCP_BROWSING;
   }
   else
   {
      // Set the default value as NO_METADATA(version info is not available for A2DP device)
      mostAudioStreamingSupport.enType = most_fi_tcl_e8_BTSetAudioStreamingSupportType::FI_EN_E8AVRCP_NO_METADATA;
   }

   return;
}

void FC_Bluetooth_tclCCAService::MapAutoConnectOnOffStatusToMOST(most_btsetfi_tclMsgAutoConnectOnOffStatus
      &mostAutoConnectOnOffStatus, const AutoConnectionType autoConnectionType)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("MapAutoConnectOnOffStatusToMOST: autoConnectionType = %d", autoConnectionType._type));

   //TODO : type should be verified
   if(autoConnectionType._type == BM_STANDARD_AUTO_CONNECTION_OFF)
   {
      mostAutoConnectOnOffStatus.bAutoConnectOnOff = FALSE;
   }
   else
   {
      mostAutoConnectOnOffStatus.bAutoConnectOnOff = TRUE;
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::MapLimitationFeatureToMost(most_fi_tcl_e8_BTTechnology& e8Technology, const LimitationFeature limitationFeature)
{
   ENTRY_INTERNAL

   switch(limitationFeature)
   {
      case ::bmcore::BM_LIMITATION_FEATURE_IAP:
         e8Technology.enType = most_fi_tcl_e8_BTTechnology::FI_EN_IAP;
      break;
      case ::bmcore::BM_LIMITATION_FEATURE_CAR_PLAY:
         e8Technology.enType = most_fi_tcl_e8_BTTechnology::FI_EN_CAR_PLAY;
      break;
      case ::bmcore::BM_LIMITATION_FEATURE_ANDROID_AUTO:
         e8Technology.enType = most_fi_tcl_e8_BTTechnology::FI_EN_ANDROID_AUTO;
      break;
      case ::bmcore::BM_LIMITATION_FEATURE_MY_SPIN:
         e8Technology.enType = most_fi_tcl_e8_BTTechnology::FI_EN_MY_SPIN;
      break;
      case ::bmcore::BM_LIMITATION_FEATURE_MY_SPIN_IOS:
         e8Technology.enType = most_fi_tcl_e8_BTTechnology::FI_EN_MY_SPIN_IOS;
      break;
      case ::bmcore::BM_LIMITATION_FEATURE_MIRROR_LINK:
         e8Technology.enType = most_fi_tcl_e8_BTTechnology::FI_EN_MIRROR_LINK;
      break;
      case ::bmcore::BM_LIMITATION_FEATURE_MIRROR_LINK_IOS:
         e8Technology.enType = most_fi_tcl_e8_BTTechnology::FI_EN_MIRROR_LINK_IOS;
      break;
      case ::bmcore::BM_LIMITATION_FEATURE_CAR_LIFE:
         e8Technology.enType = most_fi_tcl_e8_BTTechnology::FI_EN_CAR_LIFE;
      break;
      case ::bmcore::BM_LIMITATION_FEATURE_CAR_LIFE_IOS:
         e8Technology.enType = most_fi_tcl_e8_BTTechnology::FI_EN_CAR_LIFE_IOS;
      break;
      case ::bmcore::BM_LIMITATION_FEATURE_ON_CAR:
         e8Technology.enType = most_fi_tcl_e8_BTTechnology::FI_EN_ON_CAR;
      break;
      case ::bmcore::BM_LIMITATION_FEATURE_ON_CAR_IOS:
         e8Technology.enType = most_fi_tcl_e8_BTTechnology::FI_EN_ON_CAR_IOS;
      break;
      default:
         ETG_TRACE_ERR(("Invalid limitationFeature"));
      break;
   }

   ETG_TRACE_USR1(("MapLimitationFeatureToMost::limitationFeature = %d e8Technology = %d ",
         limitationFeature, e8Technology.enType));

   return;
}

tVoid FC_Bluetooth_tclCCAService::MapLimitationCommunicationIfToMost(most_fi_tcl_e8_BTCommunicationChannel& e8CommunicationChannel,
      const LimitationCommunicationIf limitationCommunicationIf)
{
   ENTRY_INTERNAL

   switch(limitationCommunicationIf)
   {
      case ::bmcore::BM_LIMITATION_COMMUNICATION_IF_USB:
         e8CommunicationChannel.enType = most_fi_tcl_e8_BTCommunicationChannel::FI_EN_USB;
      break;
      case ::bmcore::BM_LIMITATION_COMMUNICATION_IF_WIFI_2_4:
         e8CommunicationChannel.enType = most_fi_tcl_e8_BTCommunicationChannel::FI_EN_WIFI_2_4GHZ;
      break;
      case ::bmcore::BM_LIMITATION_COMMUNICATION_IF_WIFI_5:
         e8CommunicationChannel.enType = most_fi_tcl_e8_BTCommunicationChannel::FI_EN_WIFI_5GHZ;
      break;
      case ::bmcore::BM_LIMITATION_COMMUNICATION_IF_BT:
         e8CommunicationChannel.enType = most_fi_tcl_e8_BTCommunicationChannel::FI_EN_BLUETOOTH;
      break;
      case ::bmcore::BM_LIMITATION_COMMUNICATION_IF_WIFI:
         e8CommunicationChannel.enType = most_fi_tcl_e8_BTCommunicationChannel::FI_EN_WIFI;
      break;
      default:
         ETG_TRACE_ERR(("Invalid limitationCommunicationIf"));
      break;
   }

   ETG_TRACE_USR1(("MapLimitationCommunicationIfToMost::limitationCommunicationIf = %d e8CommunicationChannel = %d ",
         limitationCommunicationIf, e8CommunicationChannel.enType));

   return;
}

tVoid FC_Bluetooth_tclCCAService::MapLimitationActionStateToMost(most_fi_tcl_e8_BTLimitationActionState& e8ActionState, const LimitationState limitationState)
{
   ENTRY_INTERNAL

   switch (limitationState)
   {
      case ::bmcore::BM_LIMITATION_STATE_IDLE:
         e8ActionState.enType =  most_fi_tcl_e8_BTLimitationActionState::FI_EN_IDLE;
      break;
      case ::bmcore::BM_LIMITATION_STATE_PREPARING:
         e8ActionState.enType = most_fi_tcl_e8_BTLimitationActionState::FI_EN_PREPARING;
      break;
      case ::bmcore::BM_LIMITATION_STATE_PREPARED:
         e8ActionState.enType = most_fi_tcl_e8_BTLimitationActionState::FI_EN_PREPARED;
      break;
      case ::bmcore::BM_LIMITATION_STATE_PREACTIVATING:
         e8ActionState.enType = most_fi_tcl_e8_BTLimitationActionState::FI_EN_PREACTIVATING;
      break;
      case ::bmcore::BM_LIMITATION_STATE_PREACTIVATED:
         e8ActionState.enType =  most_fi_tcl_e8_BTLimitationActionState::FI_EN_PREACTIVATED;
      break;
      case ::bmcore::BM_LIMITATION_STATE_ACTIVATING:
         e8ActionState.enType = most_fi_tcl_e8_BTLimitationActionState::FI_EN_ACTIVATING;
      break;
      case ::bmcore::BM_LIMITATION_STATE_ACTIVE:
         e8ActionState.enType =  most_fi_tcl_e8_BTLimitationActionState::FI_EN_ACTIVE;
      break;
      case ::bmcore::BM_LIMITATION_STATE_DEACTIVATING:
         e8ActionState.enType = most_fi_tcl_e8_BTLimitationActionState::FI_EN_DEACTIVATING;
      break;
      case ::bmcore::BM_LIMITATION_STATE_WAITING:
         e8ActionState.enType = most_fi_tcl_e8_BTLimitationActionState::FI_EN_WAITING;
      break;
      case ::bmcore::BM_LIMITATION_STATE_ERROR:
         e8ActionState.enType = most_fi_tcl_e8_BTLimitationActionState::FI_EN_ERROR;
      break;
      case ::bmcore::BM_LIMITATION_STATE_ERROR_USER_DENIED:
         e8ActionState.enType = most_fi_tcl_e8_BTLimitationActionState::FI_EN_ERROR_USER_DENIED;
      break;
      default:
         ETG_TRACE_ERR(("Invalid limitationState"));
      break;
   }

   ETG_TRACE_USR1(("MapLimitationActionStateToMost::limitationState  = %d e8ActionState = %d",
         limitationState, e8ActionState.enType));

   return;
}

void FC_Bluetooth_tclCCAService::MapVisibleDeviceConnectionStatusToMOST(
      most_fi_tcl_e8_BTSetVisibleDeviceConnectionStatus &moste8VisibleDeviceConnectionStatus, DeviceId deviceHandle, ConnectionStatus connectionStatus)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("MapVisibleDeviceConnectionStatusToMOST: deviceHandle = %d connectionStatus - %d", deviceHandle, connectionStatus));

   if(deviceHandle != FC_BLUETOOTH_CCASERVICE_ZERO)
   {
      if((connectionStatus == BM_CONNECTION_STATUS_CONNECTED) || (connectionStatus == BM_CONNECTION_STATUS_DISCONNECTING))
      {
         moste8VisibleDeviceConnectionStatus.enType = most_fi_tcl_e8_BTSetVisibleDeviceConnectionStatus::FI_EN_E8CONNECTED;
      }
      else
      {
         moste8VisibleDeviceConnectionStatus.enType = most_fi_tcl_e8_BTSetVisibleDeviceConnectionStatus::FI_EN_E8PAIRED;
      }
   }
   else
   {
      moste8VisibleDeviceConnectionStatus.enType = most_fi_tcl_e8_BTSetVisibleDeviceConnectionStatus::FI_EN_E8NEW;
   }

   return;
}

void FC_Bluetooth_tclCCAService::MapMultiHFPSupportStatusToMOST(most_fi_tcl_e8_BTSwitchStatus &mostBTSwitchStatus,
      const SwitchState switchState)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("MapMultiHFPSupportStatusToMOST::switchState = %d ", switchState));

   switch (switchState)
   {
      case SWITCH_STATE_SWITCHED_OFF:
         mostBTSwitchStatus.enType = most_fi_tcl_e8_BTSwitchStatus::FI_EN_E8SWITCHED_OFF;
      break;
      case SWITCH_STATE_SWITCHING_ON:
         mostBTSwitchStatus.enType = most_fi_tcl_e8_BTSwitchStatus::FI_EN_E8SWITCHING_ON;
         break;
      case SWITCH_STATE_SWITCHED_ON:
         mostBTSwitchStatus.enType = most_fi_tcl_e8_BTSwitchStatus::FI_EN_E8SWITCHED_ON;
      break;
      case SWITCH_STATE_SWITCHING_OFF:
         mostBTSwitchStatus.enType = most_fi_tcl_e8_BTSwitchStatus::FI_EN_E8SWITCHING_OFF;
      break;
      default:
         ETG_TRACE_ERR(("Invalid switch state"));
      break;
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::MapBtProfilesToMost(most_fi_tcl_e8_BTProfile& e8BTProfile, ProtocolId protocolId)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("MapBtProfilesToMost::protocolId - %d", protocolId));

   switch (protocolId)
   {
      case BM_PROTOCOL_ID_HFP:
         e8BTProfile.enType = most_fi_tcl_e8_BTProfile::FI_EN_E8BT_PROFILE_HFP;
      break;
      case BM_PROTOCOL_ID_AVP:
         e8BTProfile.enType = most_fi_tcl_e8_BTProfile::FI_EN_E8BT_PROFILE_AVP;
      break;
      case BM_PROTOCOL_ID_PAN:
         e8BTProfile.enType = most_fi_tcl_e8_BTProfile::FI_EN_E8BT_PROFILE_PAN;
      break;
      case BM_PROTOCOL_ID_PBDL:
         e8BTProfile.enType = most_fi_tcl_e8_BTProfile::FI_EN_E8BT_PROFILE_PBAP;
      break;
      case BM_PROTOCOL_ID_MSG:
         e8BTProfile.enType = most_fi_tcl_e8_BTProfile::FI_EN_E8BT_PROFILE_MAP;
      break;
      case BM_PROTOCOL_ID_SPP:
         e8BTProfile.enType = most_fi_tcl_e8_BTProfile::FI_EN_E8BT_PROFILE_SPP;
      break;
      default:
         ETG_TRACE_ERR(("MapBtProfilesToMost: Invalid Profile"));
      break;
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::MapBTProfileUsageTypeToMost(most_fi_tcl_e8_BTProfileUsageType& e8BTProfileUsageType, BTProfileUsageType profileUsageType)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("MapBTProfileUsageTypeToMost::profileUsageType - %d", profileUsageType));

   switch (profileUsageType)
   {
      case BT_PROFILE_USAGE_NONE:
         e8BTProfileUsageType.enType = most_fi_tcl_e8_BTProfileUsageType::FI_EN_E8PROFILE_USAGE_NONE;
      break;
      case BT_PROFILE_USAGE_GENERIC:
         e8BTProfileUsageType.enType = most_fi_tcl_e8_BTProfileUsageType::FI_EN_E8PROFILE_USAGE_GENERIC;
      break;
      case BT_PROFILE_USAGE_ACTIVE_CALL:
         e8BTProfileUsageType.enType= most_fi_tcl_e8_BTProfileUsageType::FI_EN_E8PROFILE_USAGE_ACTIVE_CALL;
      break;
      case BT_PROFILE_USAGE_AUDIO_STREAMING:
         e8BTProfileUsageType.enType = most_fi_tcl_e8_BTProfileUsageType::FI_EN_E8PROFILE_USAGE_AUDIO_STREAMING;
      break;
      default:
         ETG_TRACE_ERR(("MapBTProfileUsageTypeToMost: Invalid Profile usage"));
      break;
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::MapConflictTypeToMost(most_fi_tcl_e8_BTConflictType& e8BTConflictType, ConflictType conflictType)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("MapConflictTypeToMost::conflictType - %d", conflictType));

   switch (conflictType)
   {
      case BM_CONFLICT_TYPE_GENERIC:
         e8BTConflictType.enType = most_fi_tcl_e8_BTConflictType::FI_EN_E8GENERIC;
      break;
      case BM_CONFLICT_TYPE_MAX_NUMBER_PAIRED_DEVICES_REACHED:
         e8BTConflictType.enType = most_fi_tcl_e8_BTConflictType::FI_EN_E8MAX_NUM_OF_PAIRED_DEVICES;
      break;
      case BM_CONFLICT_TYPE_PROFILE_IN_USE:
         e8BTConflictType.enType= most_fi_tcl_e8_BTConflictType::FI_EN_E8PROFILE_IN_USE;
      break;
      case BM_CONFLICT_TYPE_INCORRECT_WIFI_MODE:
         e8BTConflictType.enType = most_fi_tcl_e8_BTConflictType::FI_EN_E8INCORRECT_WIFI_MODE;
      break;
      case BM_CONFLICT_TYPE_CHECK_MAX_NUMBER_PAIRED_DEVICES_REACHED:
         e8BTConflictType.enType = most_fi_tcl_e8_BTConflictType::FI_EN_E8CHECK_MAX_NUM_OF_PAIRED_DEVICES;
      break;
      default:
         ETG_TRACE_ERR(("MapConflictTypeToMost: Invalid conflictType"));
      break;
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::MapConflictStateToMost(most_fi_tcl_e8_BTConflictState& e8ConflictState, ConflictState conflictState)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("MapConflictStateToMost::conflictState - %d", conflictState));

   switch (conflictState)
   {
      case BM_CONFLICT_STATE_NEW:
         e8ConflictState.enType = most_fi_tcl_e8_BTConflictState::FI_EN_E8CONFLICT_STATE_NEW;
      break;
      case BM_CONFLICT_STATE_UNCHANGED:
         e8ConflictState.enType = most_fi_tcl_e8_BTConflictState::FI_EN_E8CONFLICT_STATE_UNCHANGED;
      break;
      case BM_CONFLICT_STATE_SOLVED:
         e8ConflictState.enType= most_fi_tcl_e8_BTConflictState::FI_EN_E8CONFLICT_STATE_SOLVED;
      break;
      default:
         ETG_TRACE_ERR(("MapConflictStateToMost: Invalid conflictState"));
      break;
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::MapConflictTriggerToMost(most_fi_tcl_e8_BTConflictTrigger& e8BTConflictTrigger, ConflictTrigger conflictTrigger)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("MapConflictTriggerToMost::conflictTrigger - %d", conflictTrigger));

   switch (conflictTrigger)
   {
      case BM_CONFLICT_TRIGGER_NONE:
         e8BTConflictTrigger.enType = most_fi_tcl_e8_BTConflictTrigger::FI_EN_E8NONE;
      break;
      case BM_CONFLICT_TRIGGER_BT_PAIRING:
         e8BTConflictTrigger.enType = most_fi_tcl_e8_BTConflictTrigger::FI_EN_E8BT_PAIRING;
      break;
      case BM_CONFLICT_TRIGGER_OOB_BT_PAIRING:
         e8BTConflictTrigger.enType = most_fi_tcl_e8_BTConflictTrigger::FI_EN_E8OOB_BT_PAIRING;
      break;
      case BM_CONFLICT_TRIGGER_AAP_USB:
         e8BTConflictTrigger.enType = most_fi_tcl_e8_BTConflictTrigger::FI_EN_E8AAP_USB;
      break;
      case BM_CONFLICT_TRIGGER_AAP_WIRELESS:
         e8BTConflictTrigger.enType = most_fi_tcl_e8_BTConflictTrigger::FI_EN_E8AAP_WIRELESS;
      break;
      case BM_CONFLICT_TRIGGER_CP_USB:
         e8BTConflictTrigger.enType = most_fi_tcl_e8_BTConflictTrigger::FI_EN_E8CP_USB;
      break;
      case BM_CONFLICT_TRIGGER_CP_WIRELESS:
         e8BTConflictTrigger.enType = most_fi_tcl_e8_BTConflictTrigger::FI_EN_E8CP_WIRELESS;
      break;
      case BM_CONFLICT_TRIGGER_CARLIFE_USB:
         e8BTConflictTrigger.enType = most_fi_tcl_e8_BTConflictTrigger::FI_EN_E8CARLIFE_USB;
      break;
      case BM_CONFLICT_TRIGGER_CARLIFE_IOS_USB:
         e8BTConflictTrigger.enType = most_fi_tcl_e8_BTConflictTrigger::FI_EN_E8CARLIFE_IOS_USB;
      break;
      case BM_CONFLICT_TRIGGER_ONCAR_USB:
         e8BTConflictTrigger.enType = most_fi_tcl_e8_BTConflictTrigger::FI_EN_E8ONCAR_USB;
      break;
      case BM_CONFLICT_TRIGGER_ONCAR_IOS_USB:
         e8BTConflictTrigger.enType = most_fi_tcl_e8_BTConflictTrigger::FI_EN_E8ONCAR_IOS_USB;
      break;
      case BM_CONFLICT_TRIGGER_MIRRORLINK_USB:
         e8BTConflictTrigger.enType = most_fi_tcl_e8_BTConflictTrigger::FI_EN_E8MIRRORLINK_USB;
      break;
      case BM_CONFLICT_TRIGGER_MIRRORLINK_IOS_USB:
         e8BTConflictTrigger.enType = most_fi_tcl_e8_BTConflictTrigger::FI_EN_E8MIRRORLINK_IOS_USB;
      break;
      case BM_CONFLICT_TRIGGER_MYSPIN_USB:
         e8BTConflictTrigger.enType = most_fi_tcl_e8_BTConflictTrigger::FI_EN_E8MYSPIN_USB;
      break;
      case BM_CONFLICT_TRIGGER_MYSPIN_IOS_USB:
         e8BTConflictTrigger.enType = most_fi_tcl_e8_BTConflictTrigger::FI_EN_E8MYSPIN_IOS_USB;
      break;
      default:
         ETG_TRACE_ERR(("MapConflictTriggerToMost: Invalid conflictTrigger"));
      break;
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::MapAutoConnectionStatusToMOST(most_fi_tcl_e8_BTAutoconnectionStatus& e8AutoConnectionStatus, AutoConnectionState autoConnectionState)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("MapAutoConnectionStatusToMOST::autoConnectionState - %d", autoConnectionState));

   switch (autoConnectionState)
   {
      case BM_AUTO_CONNECTION_STATE_IDLE:
         e8AutoConnectionStatus.enType = most_fi_tcl_e8_BTAutoconnectionStatus::FI_EN_E8IDLE;
         break;
      case BM_AUTO_CONNECTION_STATE_PREPARING:
         e8AutoConnectionStatus.enType = most_fi_tcl_e8_BTAutoconnectionStatus::FI_EN_E8PREPARING;
         break;
      case BM_AUTO_CONNECTION_STATE_IN_PROGRESS:
         e8AutoConnectionStatus.enType = most_fi_tcl_e8_BTAutoconnectionStatus::FI_EN_E8IN_PROGRESS;
         break;
      default:
         ETG_TRACE_ERR(("MapAutoConnectionStatusToMOST: Invalid autoConnectionState"));
      break;
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::MapServiceAvailabilityToMOST(most_fi_tcl_e8_BTServiceAvailable& e8ServiceAvailable, ServiceAvailability serviceAvailability)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("MapServiceAvailabilityToMOST::serviceAvailability - %d", serviceAvailability));

   switch (serviceAvailability)
   {
      case BM_SERVICE_UNAVAILABLE:
         e8ServiceAvailable.enType = most_fi_tcl_e8_BTServiceAvailable::FI_EN_E8SERVICE_UNAVAILABLE;
         break;
      case BM_SERVICE_AVAILABLE_RESTRICTED:
         e8ServiceAvailable.enType = most_fi_tcl_e8_BTServiceAvailable::FI_EN_E8SERVICE_AVAILABLE_RESTRICTED;
         break;
      case BM_SERVICE_AVAILABLE:
         e8ServiceAvailable.enType = most_fi_tcl_e8_BTServiceAvailable::FI_EN_E8SERVICE_AVAILABLE;
         break;
      default:
         ETG_TRACE_ERR(("MapServiceAvailabilityToMOST: Invalid serivceAvailablity"));
      break;
   }

   return;
}

/**
 * Internal post functions
 */
void FC_Bluetooth_tclCCAService::vPostResult(most_btsetfi_tclMsgBaseMessage& rBaseMessage,
      amt_tclServiceData& rServiceMethodStart)
{
   ENTRY_INTERNAL

   // Create FI VisitorMessage.
   fi_tclVisitorMessage oVisitorMsgOutput(rBaseMessage, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

   // Init Method result message
   vInitServiceData(oVisitorMsgOutput, rServiceMethodStart.u16GetSourceAppID(), rServiceMethodStart.u16GetRegisterID(),
         rServiceMethodStart.u16GetCmdCounter(), rServiceMethodStart.u16GetFunctionID(),
         AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

   // Post the message
   ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

   if (AIL_EN_N_NO_ERROR != ailResult)
   {
      // fatal error, because a server can post in all use cases
      ETG_TRACE_ERR(("vPostResult:enPostMessage failed for FunctionID: %d, with Result: %d",\
            rServiceMethodStart.u16GetFunctionID(), ailResult));
   }
   else
   {
      ETG_TRACE_USR1(("vPostResult:enPostMessage successfully post for FunctionID: %d",\
            rServiceMethodStart.u16GetFunctionID()));
   }

   // Destroy the (Message related) FI data object (output)
   rBaseMessage.vDestroy();
   return;
}

tVoid FC_Bluetooth_tclCCAService::vPostError(amt_tclServiceData &rServiceMethodStart,
      most_fi_tcl_e8_ErrorCode::tenType errorCode, tU8 errorParam)
{
   ENTRY_INTERNAL

   most_btsetfi_tclMsgDefaultError oError;

   // set error code
   oError.e8ErrorCode.enType = errorCode;

   //set error info
   oError.oErrorInfo.vSetData(&errorParam, sizeof(errorParam));

   // Create FI VisitorMessage.
   fi_tclVisitorMessage oErrorMsg(oError, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION);

   // Init error message
   vInitServiceData(oErrorMsg, rServiceMethodStart.u16GetSourceAppID(), rServiceMethodStart.u16GetRegisterID(),
         rServiceMethodStart.u16GetCmdCounter(), rServiceMethodStart.u16GetFunctionID(), AMT_C_U8_CCAMSG_OPCODE_ERROR);

   ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oErrorMsg, TRUE);

   if (AIL_EN_N_NO_ERROR != ailResult)
   {
      // fatal error, because a server can post in all use cases
      ETG_TRACE_ERR(("vPostError:enPostMessage failed for FunctionID: %d, with Result: %d",\
            rServiceMethodStart.u16GetFunctionID(), ailResult));
   }
   else
   {
      ETG_TRACE_USR1(("vPostError:enPostMessage successfully post for FunctionID: %d",\
            rServiceMethodStart.u16GetFunctionID()));
   }

   oError.vDestroy();
   return;
}

/*******************************************************************************
 ** FUNCTION:   clearAllPrivateData
 *******************************************************************************/
/* DESCRIPTION    :  This is a handler function for clear Private data from DefSet
 *  PARAMETERS    :  IN:  None
 *  RETURNVALUE   :  None
 *******************************************************************************/

tS32 FC_Bluetooth_tclCCAService::clearAllPrivateData()
{
   ENTRY_INTERNAL

   tS32 s32RetVal = FC_BLUETOOTH_CLEAR_PRIVATEDATA_FAILURE;

   BmResult result = BM_RESULT_ERR_GENERAL;

   if(_bluetoothApp)
   {
      // false - clear and set the default value (using same power cycle)
      result =  _bluetoothApp->getBmCoreRequestIf().resetToDefault(false);

      if(result == BM_RESULT_OK)
      {
         s32RetVal = FC_BLUETOOTH_CLEAR_PRIVATEDATA_SUCCESS;

         updateRingtoneValues(TRUE);
      }
   }

   ETG_TRACE_USR4(("clearAllPrivateData: return  - %d", s32RetVal));

   return s32RetVal;
}

/*******************************************************************************
 ** FUNCTION:   vRestoreRadioSettings
 *******************************************************************************/
/* DESCRIPTION:
 *   This is a handler function for Restore Radio Settings from DefSet
 *  PARAMETERS:
 *     IN:  None
 *  RETURNVALUE: None
 *******************************************************************************/
tVoid FC_Bluetooth_tclCCAService::restoreRadioSettings()
{
   ENTRY_INTERNAL
   BmResult result = BM_RESULT_ERR_GENERAL;

   if(false == _bmCoreConfiguration._systemWideRingtoneEnabled)
   {
      PairedDeviceList pairedDeviceList;
      vGetPairedDeviceList(pairedDeviceList);

      if(FC_BLUETOOTH_CCASERVICE_ZERO != pairedDeviceList._deviceBaseInfoList.size())
      {
         for (std::list<DeviceBaseInfo>::const_iterator it = pairedDeviceList._deviceBaseInfoList.begin();
               it != pairedDeviceList._deviceBaseInfoList.end(); it++)
         {
            if(_bluetoothApp)
            {
               result = _bluetoothApp->getBmCoreRequestIf().storeDeviceRingtoneIdInDb(it->_deviceHandle, DEFAULT_RINGTONE_ID);

               if (BM_RESULT_OK == result)
               {
                  //update status
                  std::string sRingtoneName = "";
                  oAvailableRingtoneList.vGetRingtoneName((tU16)(DEFAULT_RINGTONE_ID - 1), sRingtoneName);
                  updateChangeRingtoneStatus((tU8)it->_deviceHandle, (tU16)DEFAULT_RINGTONE_ID, sRingtoneName);
               }
               else
               {
                  ETG_TRACE_ERR(("updateRingtoneValues: storeDeviceRingtoneIdInDb is failed - %d ", result));
               }
            }
         }
      }
   }
   else
   {
      updateRingtoneValues(TRUE);
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::vCheckAndUpdateRingtoneSupport()
{
   ENTRY_INTERNAL
   BmResult result = BM_RESULT_ERR_GENERAL;
   RingtoneId ringtoneId = FC_BLUETOOTH_CCASERVICE_ZERO;

   ETG_TRACE_USR4(("vCheckAndUpdateRingtoneSupport: entered"));

   if(false == _bmCoreConfiguration._systemWideRingtoneEnabled)
   {
      PairedDeviceList pairedDeviceList;
      vGetPairedDeviceList(pairedDeviceList);

      if(FC_BLUETOOTH_CCASERVICE_ZERO != pairedDeviceList._deviceBaseInfoList.size())
      {
         for (std::list<DeviceBaseInfo>::const_iterator it = pairedDeviceList._deviceBaseInfoList.begin();
               it != pairedDeviceList._deviceBaseInfoList.end(); it++)
         {
            if(_bluetoothApp)
            {
               result = _bluetoothApp->getBmCoreRequestIf().readDeviceRingtoneIdFromDb(ringtoneId, it->_deviceHandle);
            }

            if (BM_RESULT_OK == result)
            {
               ETG_TRACE_USR4(("vCheckAndUpdateRingtoneSupport: ringtoneId in the database = %d", ringtoneId));

               if(ringtoneId == -1)
               {
                  tBool bInbandSupported = FALSE;
                  result = GetInbandRingtoneSupport(bInbandSupported, (tU8)it->_deviceHandle);

                  if(result == BM_RESULT_OK)
                  {
                     if(bInbandSupported == true)
                     {
                        ringtoneId = RINGTONE_INBAND_RINGTONEID;
                     }
                     else
                     {
                        ringtoneId = DEFAULT_RINGTONE_ID;
                     }
                  }
               }

               if(result == BM_RESULT_OK)
               {
                  //update status
                  std::string sRingtoneName = "";
                  oAvailableRingtoneList.vGetRingtoneName((tU16)(ringtoneId - 1), sRingtoneName);
                  updateChangeRingtoneStatus((tU8)it->_deviceHandle, (tU16)ringtoneId, sRingtoneName);
               }
            }
            else
            {
               ETG_TRACE_ERR(("vCheckAndUpdateRingtoneSupport: readDeviceRingtoneIdFromDb func return error:%d", result));
            }
         }
      }
   }
   else
   {
      ETG_TRACE_USR4(("vCheckAndUpdateRingtoneSupport: _systemWideRingtoneEnabled is enabled"));
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::playRingTone()
{
   tU16 u16RingtoneID = INCOMING_CALL_RINGTONE_ID;
   std::string szRingtoneName = "";
   tU16 u16RequestedRingtoneID = DEFAULT_RINGTONE_ID;

   //Get the ringtone id set in PlayRingTone method start
   u16RingtoneID = oAvailableRingtoneList.vGetPlayRingtoneID();

   ETG_TRACE_USR2(("playRingTone: ringtone id - %d ",u16RingtoneID));

   u16RequestedRingtoneID = u16RingtoneID;

   if (u16RingtoneID >= 2 && u16RingtoneID <= 11)
   {
      oAvailableRingtoneList.vGetRingToneNameWithFilePath(u16RingtoneID, szRingtoneName);

      FC_Bluetooth_AudioPlayer* poRingTonePlayer = FC_Bluetooth_AudioPlayer::getInstance(); //gstreamer

      if (poRingTonePlayer)
      {
         ETG_TRACE_USR4((" FC_Bluetooth_AudioPlayer::playRingTone "));

         tBool bRet = poRingTonePlayer->playFile(szRingtoneName.c_str(), u16RequestedRingtoneID, false);

         if(bRet == true)
         {
            _bIsRingtonePlaying = TRUE;
            PlayRingtoneMethodResult(_playRingtone);
         }
         else
         {
            sendMethodError(_playRingtone.u16FunctionID, _playRingtone,
                  most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
         }
      }
   }
   else
   {
      if(u16RingtoneID == VOLUME_SLIDING_RINGTONE_ID)
      {
         u16RingtoneID = DEFAULT_RINGTONE_ID;

         if(true == _bmCoreConfiguration._systemWideRingtoneEnabled)
         {
            ETG_TRACE_USR4(("playRingTone: _u16SystemWideRingtone = %d",_u16SystemWideRingtone));

            if((NO_RINGTONE != _u16SystemWideRingtone) && (RINGTONE_INBAND_RINGTONEID != _u16SystemWideRingtone))
            {
               u16RingtoneID = _u16SystemWideRingtone;
            }
         }
      }
      else
      {
         u16RingtoneID = DEFAULT_RINGTONE_ID;
      }

      oAvailableRingtoneList.vGetRingToneNameWithFilePath(u16RingtoneID, szRingtoneName);

      FC_Bluetooth_AudioPlayer* poRingTonePlayer = FC_Bluetooth_AudioPlayer::getInstance(); //gstreamer

      if (poRingTonePlayer)
      {
         ETG_TRACE_USR4((" FC_Bluetooth_AudioPlayer::playRingTone "));

         tBool bRet = poRingTonePlayer->playFile(szRingtoneName.c_str(), u16RequestedRingtoneID, true);

         if(bRet == true)
         {
            _bIsRingtonePlaying = TRUE;
            PlayRingtoneMethodResult(_playRingtone);
         }
         else
         {
            sendMethodError(_playRingtone.u16FunctionID, _playRingtone,
                  most_fi_tcl_e8_ErrorCode::FI_EN_FUNCTIONSPECIFIC);
         }
      }
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::stopRingTone()
{
   ENTRY_INTERNAL

   if(_bIsRingtonePlaying  == true)
   {
      _bIsRingtonePlaying = false;

      FC_Bluetooth_AudioPlayer::stopPlayback();

      if (_bIsStopRingtoneinProgress)
      {
         _bIsStopRingtoneinProgress = false;
         StopRingtoneMethodResult(_stopRingtone, true);
      }
   }

   return;
}

tVoid FC_Bluetooth_tclCCAService::updateRingtoneValues(tBool bClearRingtoneValue)
{
   ENTRY_INTERNAL

   if(true == _bmCoreConfiguration._systemWideRingtoneEnabled)
   {
      RingtoneId ringtoneId = FC_BLUETOOTH_CCASERVICE_ZERO;
      BmResult result = BM_RESULT_ERR_GENERAL;

      ETG_TRACE_USR4(("updateRingtoneValues: _u16SystemWideRingtone = %d",_u16SystemWideRingtone));

      if(TRUE == bClearRingtoneValue) // Setting to default ringtone value on resetting factory settings
      {
         ETG_TRACE_USR4((" Set to default value value on clearing private data !!"));

         ringtoneId = RINGTONE_INBAND_RINGTONEID;

         if(_bluetoothApp)
         {
            result = _bluetoothApp->getBmCoreRequestIf().storeSystemWideRingtoneIdInDb((RingtoneId)(-1));

            if (BM_RESULT_OK != result)
            {
               ETG_TRACE_ERR(("updateRingtoneValues: storeSystemWideRingtoneIdInDb is failed - %d ", result));
            }
         }
      }
      else
      {
         ETG_TRACE_USR4((" SYSTEM_WIDE_RINGTONE LoadSettings !!"));

         if(_bluetoothApp)
         {
            result = _bluetoothApp->getBmCoreRequestIf().readSystemWideRingtoneIdFromDb(ringtoneId);

            if (BM_RESULT_OK != result)
            {
               ETG_TRACE_ERR(("updateRingtoneValues: readSystemWideRingtoneIdFromDb is failed - %d ", result));
            }
            else
            {
               ETG_TRACE_USR4((" SYSTEM_WIDE_RINGTONE Value loaded is %d", ringtoneId));

               if ((ringtoneId == -1) || ((ringtoneId > BT_MAX_RINGTONE_SUPPORTED) && (ringtoneId != NO_RINGTONE)))
               {
                  ETG_TRACE_USR4(("Error ! Value from db not read successfully. So changing RingtoneID to RINGTONE_INBAND_RINGTONEID"));

                  ringtoneId = RINGTONE_INBAND_RINGTONEID;
               }
            }
         }
      }

      if (BM_RESULT_OK == result)
      {
         _u8SystemWideDeviceHandle = SYSTEM_WIDE_DEVICEHANDLE;
         _u16SystemWideRingtone = (tU16)ringtoneId;
         ETG_TRACE_USR4((" Value of _u16SystemWideRingtone = %d",_u16SystemWideRingtone));

         /* Updating changeringtone status upon ignition ON for paired and when no device connected */
         std::string sRingtoneName = "";
         oAvailableRingtoneList.vGetRingtoneName((tU16)(_u16SystemWideRingtone - 1),sRingtoneName);
         updateChangeRingtoneStatus(_u8SystemWideDeviceHandle, _u16SystemWideRingtone, sRingtoneName, TRUE);
      }
   }
   else
   {
      ETG_TRACE_USR4(("updateRingtoneValues: _systemWideRingtoneEnabled is false"));
   }
}

tVoid FC_Bluetooth_tclCCAService::updateChangeRingtoneStatus(tU8 u8DeviceHandle, tU16 u16RingtoneID, std::string sRingtoneName, tBool bUpdateClients)
{
   ENTRY_INTERNAL

   _oFIDataChangeRingtone.u8DeviceHandle = u8DeviceHandle;
   _oFIDataChangeRingtone.u16RingtoneID = u16RingtoneID;
   _oFIDataChangeRingtone.sRingtoneName.bSet(sRingtoneName.c_str());
   if (bUpdateClients)
   {
      ETG_TRACE_USR4(("updateChangeRingtoneStatus: devicehandle = %d RintoneId = %d", _oFIDataChangeRingtone.u8DeviceHandle, _oFIDataChangeRingtone.u16RingtoneID));
      updateClients(MOST_BTSETFI_C_U16_CHANGERINGTONE);
   }

   return;
}

tBool FC_Bluetooth_tclCCAService::bCheckLinkQualityStatus(const char* bdAddress, LinkQualityInfo& temp)
{
   ENTRY_INTERNAL

   tBool bRet = false;
   PairedDeviceList pairedDeviceList;
   LinkQualityInfo linkQualityInfo;
   DeviceId deviceId;

   ETG_TRACE_USR1(("bCheckLinkQualityStatus: bdAddress = %s", bdAddress));

   vGetPairedDeviceList(pairedDeviceList);

   for (std::list<DeviceBaseInfo>::const_iterator it = pairedDeviceList._deviceBaseInfoList.begin();
         it != pairedDeviceList._deviceBaseInfoList.end(); it++)
   {
      std::string str = it->_bdAddress;

      std::transform(str.begin(), str.end(), str.begin(), ::tolower);

      if (s32StringCompare(str.c_str(), bdAddress) == FC_BLUETOOTH_CCASERVICE_ZERO)
      {
         if (it->_connectionStatus == BM_CONNECTION_STATUS_CONNECTED)
         {
            LinkQuality linkQuality;
            vGetLinkQuality(linkQuality);

            if (linkQuality._linkQualityInfoList.size() > FC_BLUETOOTH_CCASERVICE_ZERO)
            {
               for (LinkQualityInfoList::const_iterator ItLQInfoMap = linkQuality._linkQualityInfoList.begin();
                     ItLQInfoMap != linkQuality._linkQualityInfoList.end(); ItLQInfoMap++)
               {
                  deviceId = ItLQInfoMap->first;
                  linkQualityInfo = ItLQInfoMap->second;

                  if (deviceId == it->_deviceHandle)
                  {
                     temp._linkQuality = linkQualityInfo._linkQuality;
                     temp._rssi = linkQualityInfo._rssi;

                     ETG_TRACE_USR1(("bCheckLinkQualityStatus: _linkQuality - %d _rssi - %d", temp._linkQuality, temp._rssi));

                     bRet = true;
                  }
               }
            }
            else
            {
               ETG_TRACE_USR1((" bCheckLinkQualityStatus: _linkQualityInfoList.size() is return zero "));
            }
         }
         else
         {
            ETG_TRACE_ERR((" bCheckLinkQualityStatus: device is not connected"));
         }

         break;
      }
   }

   ETG_TRACE_USR1((" bCheckLinkQualityStatus: return value:%d ", bRet));

   return bRet;
}

/*******************************************************************************
*
* FUNCTION:    bIsDeviceAddressValid
*
* DESCRIPTION: Validates the input Bluetooth Device Address
*
* PARAMETER:   sDeviceAddress: Bluetooth Device Address should be validated.
*
* RETURNVALUE: FALSE: when the address length is not 12 (i.e. 6 bytes) or
*                    when the characters in the device address are not valid
*                    hex characters
*              TRUE: otherwise
********************************************************************************/
tBool FC_Bluetooth_tclCCAService::bIsDeviceAddressValid( const std::string& sDeviceAddress) const
{
   ENTRY_INTERNAL

   if (sDeviceAddress.size() != FC_BLUETOOTH_VALID_BD_ADDRESS_LENGTH)
   {
      ETG_TRACE_USR4(("bIsDeviceAddressValid: Device Address size is %u", sDeviceAddress.size()));
      return FALSE;
   }

   for(tU16 i=0; i < sDeviceAddress.size(); i++)
   {
      if (('0' <= sDeviceAddress[i]) && (sDeviceAddress[i] <= '9'))
      {
         // numeric character
      }
      else if (('a' <= sDeviceAddress[i]) && (sDeviceAddress[i] <= 'f'))
      {
         // alphabetic character
      }
      else if (('A' <= sDeviceAddress[i]) && (sDeviceAddress[i] <= 'F'))
      {
         // alphabetic character
      }
      else
      {
         // invalid character
         ETG_TRACE_USR2(("bIsDeviceAddressValid: Invalid Hex char found. Hence invalid Hex String"));
         return FALSE;
      }
   }

   return TRUE;
}


/*******************************************************************************
* FUNCTION     :  s32StringCompare
*
* DESCRIPTION  :  Does null check before comparing strings
*
* PARAMETER    :  ps8Str1 - first string to compare
*                 ps8Str2 - second string to compare
*
* RETURNVALUE  :  0  - if string are equal
*                 -1 - if string don't match or is NULL.
********************************************************************************/
tS32 s32StringCompare(const char* ps8Str1, const char* ps8Str2)
{

    tS32 s32Ret = FC_BLUETOOTH_CCASERVICE_ZERO;
    if ((NULL == ps8Str1) || (NULL == ps8Str2))
    {
      ETG_TRACE_ERR(("s32StringCompare : ps8Str1/ps8Str2 is NULL"));
      return -1;
    }
    size_t u32Size1 = strlen(ps8Str1);
    size_t u32Size2 = strlen(ps8Str2);

    if( u32Size1 != u32Size2)
    {
        ETG_TRACE_ERR(("s32StringCompare : Size Mismatch, not same"));
        return -1;
    }

    s32Ret = strncmp(ps8Str1, ps8Str2, u32Size1);

    ETG_TRACE_USR2(("s32StringCompare :: s32Ret : %d",s32Ret));
    return s32Ret;
}
