/**
 * @file FC_Bluetooth_clienthandler_SpmCore.h
 * @author
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 *
 * @addtogroup FC_Bluetooth
 *
 * @brief Public interface for Bluetooth CCAMethodMap
 * @{
 */
#ifndef _FC_BLUETOOTH_CLIENTHANDLER_SPMCORE_H_
#define _FC_BLUETOOTH_CLIENTHANDLER_SPMCORE_H_

#include "FC_Bluetooth_main.h"

/******************************************************************************/
/* CLASS DEFINITION                                                           */
/******************************************************************************/
class ahl_tclBaseOneThreadClientHandler;

class fc_bluetooth_tclClientHandler_SpmCore : public ahl_tclBaseOneThreadClientHandler
{
public:
   fc_bluetooth_tclClientHandler_SpmCore(tVoid);
   fc_bluetooth_tclClientHandler_SpmCore(fc_bluetooth_tclApp* poMainAppl);
   virtual ~fc_bluetooth_tclClientHandler_SpmCore();

   /***************************************************************************
    * Overriding ahl_tclBaseOneThreadClientHandler methods.
    ***************************************************************************/
   virtual tVoid vOnServiceAvailable();
   virtual tVoid vOnServiceUnavailable();

   /***************************************************************************
    * Handler function declarations used by message map.
    ***************************************************************************/
   // Add your CCA message handler function prototypes here.

   tU32 u32GetCurrentBluetoothState();
   tVoid vGetBluetoothState();

   /***************************************************************************
    * Message map definition macro
    ***************************************************************************/
    DECLARE_MSG_MAP(fc_bluetooth_tclClientHandler_SpmCore)

private:

   /****************************************************************************
    Member variables for clienthandler_SpmCore
    ****************************************************************************/
   tVoid OnBluetoothStateStatus(amt_tclServiceData* poMessage);

   fc_bluetooth_tclApp* _bluetoothApp; /** Pointer to Main Application */
   tU32 m_u32BTState;
};

#endif //_FC_BLUETOOTH_CLIENTHANDLER_SPMCORE_H_
