/**
 * @file FC_Bluetooth_clienthandler_Diaglog.h
 * @author
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 *
 * @addtogroup FC_Bluetooth
 *
 * @brief ClientHandler for the service of the Diaglog
 * @{
 */

#ifndef _FC_BLUETOOTH_CLIENTHANDLER_DIAGLOG_H_
#define _FC_BLUETOOTH_CLIENTHANDLER_DIAGLOG_H_

/* Include Diagnostics FI interface */
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_SERVICEINFO
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h"

#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#include "vd_diaglog_if.h"

#define BLUETOOTH_DTC_STATE_UNDEFINED                          -1
#define BLUETOOTH_DTC_STATE_ERROR_STARTUP                      -2
#define BLUETOOTH_DTC_STATE_ERROR_NORMAL_OPERATION             -3 /*might be obsolete and mapped to _startup */
#define BLUETOOTH_DTC_STATE_OK_STARTUP                         0
#define BLUETOOTH_DTC_STATE_OK_NORMAL_OPERATION                1 /*might be obsolete and mapped to _startup */
#define WIFI_DTC_STATE_OK_STARTUP                              2
#define WIFI_DTC_STATE_ERROR_STARTUP                           3

class fc_bluetooth_tclClientHandler_Diaglog : public ahl_tclBaseOneThreadClientHandler
{
   
public:
   /****************************************************************************
   ** FUNCTION:   fc_bluetooth_tclClientHandler_Diaglog(tVoid);      
   ****************************************************************************/
   /* DESCRIPTION:   Default Constructor
   * 
   *   NOTE: Default Constructor will not be implemented.
   *   Avoids Lint Prio 3 warning: Info 1712: default constructor not defined 
   *   for class 'fc_bluetooth_tclClientHandler_Diaglog'
   ****************************************************************************/
   fc_bluetooth_tclClientHandler_Diaglog(tVoid); 


   /****************************************************************************
   ** FUNCTION:     
   *   fc_bluetooth_tclClientHandler_Diaglog(fc_stremrouter_tclApp* poMainAppl);     
   ****************************************************************************/
   /* DESCRIPTION:   Constructor
   * 
   ****************************************************************************/
   fc_bluetooth_tclClientHandler_Diaglog(fc_bluetooth_tclApp* poMainAppl);

   /****************************************************************************
   ** FUNCTION:   virtual ~fc_bluetooth_tclClientHandler_Diaglog();     
   ****************************************************************************/
   /* DESCRIPTION:   Destructor
   * 
   ****************************************************************************/
   virtual ~fc_bluetooth_tclClientHandler_Diaglog();

   /****************************************************************************
   ** FUNCTION:        
   *   fc_bluetooth_tclClientHandler_Diaglog& operator=
   *      (const fc_bluetooth_tclClientHandler_Diaglog &oClientHandler);      
   ****************************************************************************/
   /* DESCRIPTION:   Assignment Operator
   *
   *   NOTE: Assingment operater, will not be implemented.
   *   - Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   *     'fc_bluetooth_tclClientHandler_Diaglog' which has no assignment operator.
   *   - Disables the assignment operator for this class. So if an attempt for 
   *     the assignment is made the compiler complains.
   ****************************************************************************/
   fc_bluetooth_tclClientHandler_Diaglog& operator=
      (const fc_bluetooth_tclClientHandler_Diaglog &oClientHandler);

   /****************************************************************************
                  Overriding of general CCA methods
   ****************************************************************************/

   virtual tVoid vOnServiceAvailable();

   virtual tVoid vOnServiceUnavailable();

   tVoid vHandleNewBluetoothDTCState(tS8 state);

   /****************************************************************************
                  Overridng of CCA Extension methods
   ****************************************************************************/

   /****************************************************************************
   **              Declare Message Map  
   ****************************************************************************/
   /* DESCRIPTION:
   *   The message map is used to "redirect" incoming FI messages to
   *   dedicated handler functions
   ****************************************************************************/
   DECLARE_MSG_MAP(fc_bluetooth_tclClientHandler_Diaglog) 

private:
   /****************************************************************************
                  Handler Functions for incoming FI messages
   ****************************************************************************/
	tVoid OnSavetestresultMethodresult(amt_tclServiceData* poMessage);
	tVoid OnSendnexttestresultStatus(amt_tclServiceData* poMessage);

   /****************************************************************************
                  Specific Functions of this class
   ****************************************************************************/
	tS8   vCalculateTestResult(tU16 u16Dtc);

	tVoid vCheckAndSaveTestResult(tU16 u16Dtc, tS8 s8State);

	tVoid vSendTestResultToDiaglog(tVoid);

   /****************************************************************************
                  Member variables of this class
   ****************************************************************************/
	// Create the (message related) FI data object for the Method SAVETESTRESULT
	midw_diaglogfi_tclMsgSaveTestResultMethodStart m_oFiTestResultObject;

	//This variable show if exist TestResult to send to the diagnosis 
	tBool m_bExistTestDataToSend;

	//only at the beginning if the service is available send the TestResult to the diagnosis
    tBool m_bStart;

    tS8 m_s8BluetoothDTCState;

    tS8 m_s8WiFiDTCState;
};

#endif // _FC_BLUETOOTH_CLIENTHANDLER_DIAGLOG_H_
