/**
 * @file       :  fc_bluetooth_tclClientHandler_DefSetHandler.h
 * @author     :
 * @copyright  :  (c) 2015 Robert Bosch Car Multimedia GmbH
 * @addtogroup :  FC_Bluetooth
 *
 * @brief      :  Example implementation of a system set listener.
 * This handler sets the demodata value used for IncreaseDecrease demo
 * back to default on a DefSet request.
 */

#ifndef _FC_BLUETOOTH_CLIENTHANDLER_DEFSET_H_
#define _FC_BLUETOOTH_CLIENTHANDLER_DEFSET_H_

/**
 * Message are received by implementing ListenerInterfaces and registering 
 * them with diagnosis library. This demo shows two ways to achieve this.
 * SystemSets are handled in this class. For RoutineControl we create an
 * extra classes that handles requests for two different routines.
 */
class fc_bluetooth_tclClientHandler_DefSetHandler: public diaglib::tclSystemSetListenerIF
{
public:
   // +++ Depending on the type of listener you need the associated interface to send responses +++
   fc_bluetooth_tclClientHandler_DefSetHandler(diaglib::tclServiceDiaglib* pDiaglibService);
   virtual ~fc_bluetooth_tclClientHandler_DefSetHandler();

   // +++ Place the virtual listener functions here. These depend on the listener you implement +++
   /***************************************************************************
    * SystemSetListener methods
    ***************************************************************************/
   virtual tU32 vOnSystemSet ( 
                               tU32 u32SystemSetID, 
                               diaglib::tenSystemSetType u32SystemSetType,
                               diaglib::tContext MsgContext
                             );

	virtual tU32 vOnSystemSetFinished ( 
                                       tU32 u32SystemSetID, 
                                       diaglib::tenSystemSetType u32SystemSetType,
                                       diaglib::tContext MsgContext
                                     );

	virtual tU32 vOnSystemSetPrepare ( 
                                       tU32 u32SystemSetID, 
                                       diaglib::tenSystemSetType u32SystemSetType,
                                       diaglib::tContext MsgContext
                                    );

	virtual tU32 vOnSystemSetCheck ( 
                                    tU32 u32SystemSetID, 
                                    diaglib::tenSystemSetType u32SystemSetType,
                                    diaglib::tContext MsgContext
                                   );
private:
   diaglib::tclServiceDiaglib* _diaglibservice;

   fc_bluetooth_tclClientHandler_DefSetHandler();//lint !e1704 Info 1704 , eliminating lint warnings
};

#endif // _FC_BLUETOOTH_CLIENTHANDLER_DEFSET_H_
