/**
 * @file FC_Bluetooth_TestCommand.h
 *
 * @par SW-Component
 * Communication service layer
 *
 * @brief Communication service layer: test command handling.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Communication service layer: test command handling.
 */

#ifndef _FC_BLUETOOTH_TESTCOMMAND_H_
#define _FC_BLUETOOTH_TESTCOMMAND_H_

#include "FwITestCommandClient.h"

// Include BM Core interface
#include "BmCoreIfTypes.h"
class fc_bluetooth_tclApp;

namespace bmcore
{
   class IBmCoreRequestIf;
}
/**
 *
 */
class FC_Bluetooth_TestCommand : public ::fw::ITestCommandClient
{
public:
   /**
    * Default constructor.
    */
   FC_Bluetooth_TestCommand();

   /**
    * Constructor of the service class
    * @param[in] poMainAppl: Pointer to the CCA application
    * @return
    */
   FC_Bluetooth_TestCommand(fc_bluetooth_tclApp *poMainAppl);

   /**
    * Destructor.
    */
   virtual ~FC_Bluetooth_TestCommand();

   /**
    * Handle received test command.
    *
    * @param[in] data: test command
    */
   virtual void handleTestCommand(const unsigned char* data);

   /**
    * Initialize test command handling.
    *
    * @param[in] channel: trace channel id
    */
   void create(const unsigned int channel);

   /**
    * Deinitialize test command handling.
    */
   void destroy(void);

private:
   fc_bluetooth_tclApp* _bluetoothApp; /** Pointer to Main Application */
   unsigned int _channel; /**< trace channel id */
   bmcore::ProfileUsageList _profileUsageList;

   /**
    * Handle received test command.
    *
    * @param[in] testData: test command
    */
   void handleCommand(const unsigned char* testData);

   unsigned int getbdAddress2DeviceHandle(::std::string addr);
};

#endif //_FC_BLUETOOTH_TESTCOMMAND_H_
