/**
 * @file FC_Bluetooth_RingtoneList.h
 * @author 
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 *
 * @addtogroup FC_Bluetooth
 *
 * @brief Declaration of the interface class \c FC_Bluetooth_RingtoneList
 * @{
 */

#ifndef _FC_BLUETOOTH_RINGTONELIST_H_
#define _FC_BLUETOOTH_RINGTONELIST_H_

class FC_Bluetooth_tclRingToneListItem
{

public:

   FC_Bluetooth_tclRingToneListItem() :
         u16RingtoneID(0), bPlayRingtoneAvailable(FALSE), bRingtoneAvailable(FALSE), szRingtoneName("")
   {
   }

   FC_Bluetooth_tclRingToneListItem(const FC_Bluetooth_tclRingToneListItem& oRingToneItem)
   {
      *this = oRingToneItem;
   }

   virtual ~ FC_Bluetooth_tclRingToneListItem()
   {
      u16RingtoneID = 0;
      bPlayRingtoneAvailable = FALSE;
      bRingtoneAvailable = FALSE;
      szRingtoneName = "";
   }

   FC_Bluetooth_tclRingToneListItem& operator=(const FC_Bluetooth_tclRingToneListItem& oRingToneItem)
   {
      if (this == &oRingToneItem)
      {
         return *this;
      }

      u16RingtoneID = oRingToneItem.u16RingtoneID;
      bPlayRingtoneAvailable = oRingToneItem.bPlayRingtoneAvailable;
      bRingtoneAvailable = oRingToneItem.bRingtoneAvailable;
      szRingtoneName = oRingToneItem.szRingtoneName;
      return *this;
   }

   tU16 u16RingtoneID;
   tBool bPlayRingtoneAvailable;
   tBool bRingtoneAvailable;
   std::string szRingtoneName;

};

//
//  Ring tone data type
//
class FC_Bluetooth_RingtoneList
{

public:

   FC_Bluetooth_RingtoneList();
   virtual ~FC_Bluetooth_RingtoneList();

   const std::string& szGetRingToneFilePath();

   //Request for Ring tone list refresh
   void vRequestRefreshRingToneList();

   tU16 u16GetNumberOfRingTones()
   {
      return static_cast<tU16>(m_oAvailableRingToneList.size());
   }

   tU16 u16GetRingToneID(tU16 index);
   void szGetRingtoneNameWithRingtoneID(tU16 u16RingToneID, std::string& szRingtoneName);
   void vGetRingToneNameWithFilePath(tU16 u16RingToneID, std::string& szFile);

   tBool bIsPlayRingtoneAvailable(tU16 index);

   tBool bIsRingtoneAvailable(tBool inbandPhoneSupported, tU16 index);

   tBool bIsActiveRingtone(tU16 u16ActiveRingtoneID, tU16 index);

   void vGetRingtoneName(tU16 index, std::string& szRingtoneName);

   tVoid vSetPlayRingtoneID(tU16 playRingtoneID);
   tU16 vGetPlayRingtoneID();
   static void setLanguageSetting(tU8);
   static tU8 getLanguageSetting();

   //Debugging
   void vPrintStatus();
   virtual const tChar* pszGetClassName() const
   {
      return "FC_Bluetooth_RingtoneList";
   }

private:

   void vInitializeVehicleRingToneList();

   const std::string m_szFilePath;
   static tU8 m_u8CurrentLanguageSetting;
   //Currently selected ringtone played
   tU16 m_u16PlayRingtoneID;
   tU16 m_u16InBandRingToneIndex;

   std::vector<FC_Bluetooth_tclRingToneListItem> m_oAvailableRingToneList;
};

#endif // _FC_BLUETOOTH_RINGTONELIST_H_

