/**
 * @file FC_Bluetooth_Loopback_Controller.cpp
 * @author
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 *
 * @addtogroup FC_Bluetooth
 *
 * @brief Public interface for FC_Bluetooth_Loopback_Controller
 * @{
 */

#ifndef _FC_BLUETOOTH_LOOPBACK_CONTROLLER_H_
#define _FC_BLUETOOTH_LOOPBACK_CONTROLLER_H_

#include "Lock.h"

class FC_Bluetooth_Loopback_Controller
{
public:

   //singleton class
   FC_Bluetooth_Loopback_Controller();
   virtual ~FC_Bluetooth_Loopback_Controller();

   static FC_Bluetooth_Loopback_Controller* poGetInstance();

   void vPostLoopBackMessageToCCA(LoopBackMessageData oData);

   LoopBackMessageData poGetData(tU32 u32CallbackFuncID, tU32 u32CmdCntr);

   void vDeleteData(tU32 u32CallbackFuncID, tU32 u32CmdCntr);

   void vClearQueue();

private:

   void vAddToQueue(LoopBackMessageData oData);

   tU32 u32GetNumberOfMessagesInQueue();
   LoopBackMessageData poGetQueueElementAt(size_t index);

   std::vector<LoopBackMessageData, std::allocator<LoopBackMessageData> > _oDataQueue;

   static FC_Bluetooth_Loopback_Controller* _poInstance;

   Lock _lock;
   tU32 _u32CommandCounter;
};

#endif // FC_Bluetooth_Loopback_Controller_H_INCLUDED
