/**
 * @file FC_Bluetooth_AudioRouting.h
 * @author
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 *
 * @addtogroup FC_Bluetooth
 *
 * @brief Implementation of the interface to ARL.
 * @{
 */

#ifndef _FC_BLUETOOTH_AUDIOROUTING_H_
#define _FC_BLUETOOTH_AUDIOROUTING_H_

// include for audio routing lib
#ifndef ARL_S_IMPORT_INTERFACE_GENERIC
#define ARL_S_IMPORT_INTERFACE_GENERIC
#include "audio_routing_lib.h"
#endif

#include<unistd.h>
#include <sstream>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef enum
{
   SRC_NOT_AVAILABLE = 0,
   SRC_PLAYABLE_UNKNOWN,
   SRC_PLAYABLE,
   SRC_NOT_PLAYABLE
} tenSrcAvailability;

class fc_bluetooth_tclApp;

/**
 * @class FC_Bluetooth_tclAudioRouting
 * @ingroup CCAInterfaceModule
 *
 * @brief This class is used as an interface to ARL.
 *
 */

class FC_Bluetooth_tclAudioRouting : public arl_tclISource
{

private:
   //main application pointer
   fc_bluetooth_tclApp* _poMainAppl;
   int m_u8SrcAvailabilty;

   static FC_Bluetooth_tclAudioRouting *_audiorouting;

protected:

   /**
    * @brief Constructor of class FC_Bluetooth_tclAudioRouting
    *
    * use only inside poInstance()
    *
    * @return void
    */
   FC_Bluetooth_tclAudioRouting();

public:

   std::string m_szAlsaDeviceName;

   static FC_Bluetooth_tclAudioRouting* poGetInstance();

   /**
    * @brief Constructor of class FC_Bluetooth_tclAudioRouting
    *
    * This class is used for intialising the member variables
    *
    *
    * @return void
    */
   FC_Bluetooth_tclAudioRouting(fc_bluetooth_tclApp* poMainAppl);

   /**
    * @brief Returns the instance of the class FC_Bluetooth_tclAudioRouting
    *
    * This function returns the singleton of the class.
    *
    *
    * @return Static Instance of FC_Bluetooth_tclAudioRouting
    */
   static FC_Bluetooth_tclAudioRouting * poInstance();

   /**
    * @brief Destructor of class FC_Bluetooth_tclAudioRouting
    *
    * @return void
    */
   virtual ~FC_Bluetooth_tclAudioRouting();

   /**
    * @brief Once audio request is posted to ARL for channel acquisition and
    * the channel is granted, this method will be invoked from ARL.
    *
    * @return bool
    */
   virtual tBool bOnAllocate(arl_tenSource enSrcNum, const arl_tAllocRouteResult& rfcoAllocRoute);

   /**
    * @brief Once audio request is posted to ARL to relinquish the audio
    * channel, this method will be invoked from ARL.
    *
    * @return tBool
    */
   virtual tBool bOnDeAllocate(arl_tenSource enSrcNum);

   /**
    * @brief This method will be invoked from ARL when the streaming of audio
    * has to be started / stopped / paused.
    *
    * @param[in] rfcoSrcActivity: SA_ON, SA_OFF, SA_PAUSE.
    * SA_ON    - Request GStreamer to start playing the audio
    * SA_OFF   - Request GStreamer to stop playing the audio
    * SA_PAUSE - Request GStreamer to stop playing the audio
    *
    * @return tBool
    */
   virtual tBool bOnSrcActivity(arl_tenSource enSrcNum, const arl_tSrcActivity& rfcoSrcActivity);

   /**
    * @brief This interface makes the CCA service available.
    * Ideally it should not be invoked at all, but maintaining as part of
    * legacy code. Should be removed.
    *
    * @return void
    */
   void SetSourceAvailable(tBool bSourceAvailable);

   /**
    * @brief This method will inform ARL about the source availability
    *
    * @return void
    */
   void vSetSourceAvailability(arl_tenSrcAvailability srcAvailability, arl_tenAvailabilityReason availabilityReason, arl_tenSource enSource, tU16 u16SubSource = 0);

   /**
    * @brief This method posts the audio channel requests to ARL for the
    * sourceID.
    *
    * @return bool
    */
   tBool vTriggerARLAudio(tU16 audioChannelId);

   /**
    * @brief This method posts requests to ARL to de-allocate channel for the
    * sourceID.
    *
    * @return void
    */
   void vTriggerARLAudioDeallocation(tU16 audioChannelId);

   /**
    * @brief this method informs the source availability to ARL
    *
    * @return void
    */
   void vHandle_SourceAvailibility(arl_tenSrcAvailability srcAvailability, arl_tenAvailabilityReason availabilityReason, arl_tenSource enSource, tU16 subSource);

   void vARLResponseTimerCb();
};

#endif //_FC_BLUETOOTH_AUDIOROUTING_H_
