/**
 * @file CCAOutputWrapper.h
 * @author 
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 *
 * @addtogroup FC_Bluetooth
 *
 * @brief Public interface for CCABluetoothOutputWrapper
 * @{
 */

#ifndef _CCA_OUTPUT_WRAPPER_H_
#define _CCA_OUTPUT_WRAPPER_H_

#include "IBmCoreCallbackIf.h"

using namespace bmcore;

class fc_bluetooth_tclApp;

/** 
 * This class is used to get the response from BM Core and sends the status to HMI via Bluetooth Service. 
 */                            
class CCAOutputWrapper: public ::bmcore::IBmCoreCallbackIf
{
public:	

   /** 
   * The constructor sets all local member variables to default values
   * 
   */
   CCAOutputWrapper(fc_bluetooth_tclApp* poMainAppl);

   /**
    * Property Status
    */

   virtual void onBtSystemStateChanged(IN const BtSystemState& btSystemState);

   virtual void onLocalPairableModeChanged(const SwitchStatus& localPairableMode);

   virtual void onLocalConnectableModeChanged(const SwitchStatus& localConnectableMode);

   virtual void onBtStatusChanged(const SwitchStatus& bluetoothStatus);

   virtual void onBtLocalFriendlyNameChanged(const LocalFriendlyName& btLocalFriendlyName);

   virtual void onBtLocalInfoChanged(const LocalInfo& btLocalInfo);

   virtual void onPairingStatusChanged(const PairingStatus& btPairingStatus);

   virtual void onPairingPinChanged(const PairingPin& pairingPin);

   virtual void onPairedDeviceListChanged(const PairedDeviceList& pairedDeviceList);

   virtual void onDeviceConnectionStatusListChanged(const DeviceConnectionStatusList& deviceConnectionStatusList);
   
   virtual void onDiscoveryStatusChanged(IN const SwitchStatus& discoveryStatus);
   
   virtual void onDiscoveredDeviceChanged(IN const BdAddress& bdAddress, IN const BdName& btDeviceName);

   virtual void onDiscoveredDeviceListChanged(IN const DiscoveredDeviceList& discoveredDeviceList);

   virtual void onBlockStatusChanged(IN const BlockStatus& blockStatus);

   virtual void onAutoConnectionTypeChanged(IN const AutoConnectionType& autoConnectionType);

   virtual void onBmConfigDataChanged(IN const BmConfigData& bmConfigData);

   virtual void onBmServiceAvailabilityChanged(IN const BmServiceAvailability& bmServiceAvailability);

   virtual void onTestModeChanged(const SwitchStatus& testMode);

   virtual void onLinkQualityChanged(const LinkQuality& linkQuality);

   virtual void onLinkQualityTestModeChanged(const TestModeLinkQuality& linkQuality);

   virtual void onResetToDefaultStatusChanged(const ResetToDefaultStatus& status);

   virtual void onBtLimitationModeChanged(IN const BtLimitationMode& btLimitationMode);

   virtual void onUserDecisionRequiredSignal(IN const IssueInfoList& issueInfoList);

   virtual void onBtProfileUsageInfoChanged(IN const ProfileUsageList& btProfileUsageList);
   
   virtual void onMultiHFPSupportStatusChanged(IN const SwitchStatus& multiHFPSupportStatus);

   virtual void onAutoConnectionStatusChanged(IN const AutoConnectionStatus& autoConnectionStatus);

   /*
    * Method Response
    */

   virtual void updateConfiguration(INOUT BmCoreConfiguration& bmCoreConfiguration);

   virtual void stateChangeNormalResponse(IN const BmResult bmResult, IN const ActType act = 0u);

   virtual void stateChangeOffResponse(IN const BmResult bmResult, IN const ActType act = 0u);

   virtual void setProtocolUserAvailabilityResponse(IN const BmResult bmResult, IN const ActType act = 0u);

   virtual void switchLocalPairableModeResponse(const BmResult result, IN const ActType act = 0u);

   virtual void switchLocalConnectableModeResponse(const BmResult result, IN const ActType act = 0u);

   virtual void switchBtStatusResponse(const BmResult result, IN const ActType act = 0u);

   virtual void rejectPairingRequestResponse(const BmResult bmResult, IN const ActType act = 0u);

   virtual void acceptPairingRequestResponse(const BmResult bmResult, IN const ActType act = 0u);

   virtual void cancelPairingResponse(const BmResult bmResult, IN const ActType act = 0u);

   virtual void setAutoConnectionTypeResponse(IN const BmResult bmResult, IN const ActType act = 0u);

   virtual void setPairingPinResponse(IN const BmResult bmResult, IN const ActType act = 0u);

   virtual void addOobPairedDeviceResponse(const BmResult bmResult, IN const ActType act = 0u);

   virtual void startPairingResponse(const BmResult bmResult, IN const ActType act = 0u);

   virtual void switchDiscoveryStatusResponse(const BmResult result, IN const ActType act = 0u);

   virtual void connectDeviceResponse(const DeviceId deviceHandle, const BmResult result, IN const ActType act = 0u);

   virtual void disconnectDeviceResponse(const DeviceId deviceHandle, const BmResult result, IN const ActType act = 0u);

   virtual void deleteDeviceResponse(const DeviceId deviceHandle, const BmResult result, IN const ActType act = 0u);

   virtual void blockDeviceResponse(const DeviceId deviceHandle, const BmResult result, IN const ActType act = 0u);

   virtual void unblockDeviceResponse(const DeviceId deviceHandle, const BmResult result, IN const ActType act = 0u);

   virtual void connectProfilesResponse(const DeviceId deviceHandle, const BmResult result, IN const ActType act = 0u);

   virtual void disconnectProfilesResponse(const DeviceId deviceHandle, const BmResult result, IN const ActType act = 0u);

   virtual void blockProfilesResponse(const DeviceId deviceHandle, const BmResult bmResult, IN const ActType act = 0);

   virtual void unblockProfilesResponse(const DeviceId deviceHandle, const BmResult bmResult, IN const ActType act = 0u);

   virtual void setFavoriteResponse(IN const BmResult bmResult, IN const ActType act = 0u);

   virtual void clearFavoriteResponse(IN const BmResult bmResult, IN const ActType act = 0u);

   virtual void startServiceSearchResponse (IN const BmResult bmResult, IN const ActType act = 0u);

   virtual void stopServiceSearchResponse (IN const BmResult bmResult, IN const ActType act = 0u);

   virtual void switchMultiHFPSupportResponse (IN const BmResult bmResult, IN const ActType act = 0u);

   virtual void startAutoConnectSequenceResponse(const BmResult bmResult, IN const ActType act = 0u);

   virtual void stopAutoConnectSequenceResponse(const BmResult bmResult, IN const ActType act = 0u);

   virtual void setBtLimitationModeResponse(IN const BmResult bmResult, IN const ActType act = 0);

   virtual void replaceBtLimitationModeResponse(IN const BmResult bmResult, IN const ActType act = 0);

   virtual void notifyUserDecisionResponse(IN const BmResult bmResult, IN const ActType act = 0);

   virtual void resetToDefaultResponse(const BmResult bmResult, IN const ActType act = 0u);

   virtual void switchTestModeResponse(const BmResult result, IN const ActType act = 0u);

   virtual void storeDeviceRingtoneIdInDbResponse(IN const DeviceId deviceHandle, IN const BmResult bmResult, IN const ActType act = 0u);

   virtual void readDeviceRingtoneIdFromDbResponse(IN const DeviceId deviceHandle, IN const BmResult bmResult, IN const ActType act = 0u);

   virtual void storeSystemWideRingtoneIdInDbResponse(IN const BmResult bmResult, IN const ActType act = 0u);

   virtual void readSystemWideRingtoneIdFromDbResponse(IN const BmResult bmResult, IN const ActType act = 0u);

   virtual void updateLinkQualityResponse(IN const BmResult bmResult, IN const ActType act = 0u);

   virtual void requestTestModeLinkQualityResponse(IN const BmResult bmResult, IN const LinkQualityInfo& linkQualityInfo,
         IN const ActType act = 0u);

   virtual void setPrimaryHfpDeviceResponse(IN const BmResult bmResult);

   virtual void setBtProfileUsageInfoResponse(IN const BmResult bmResult, IN const ActType act = 0u);
   
   virtual void setDeviceUsagePreferenceResponse (IN const BmResult bmResult, IN const ActType act = 0u);

private:

   /**
    * For service class access
    */
   fc_bluetooth_tclApp *_bluetoothApp;

   tBool bReadData(tU16 u16KdsKey, tU16 u16DataLen, tU8* pu8DataBuffer);
   tVoid vReadBTVehicleFriendlyName(KdsInfo& kdsInfo, std::string& btFriendlyName);
   tVoid vReadCarPlayWirelessSupported(KdsInfo& kdsInfo, bool& bCarPlayWirelessSupported);
   tVoid vReadAndroidAutoWirelessSupported(KdsInfo& kdsInfo, bool& bAndroidAutoWirelessSupported);
   tVoid vReadPanProfileSupported(KdsInfo& kdsInfo, uint8_t& u8MaxNumInstances);
   tVoid vReadHFPProfileSupported(KdsInfo& kdsInfo, uint8_t& u8MaxNumInstances);
   tVoid vCheckAndRemoveTrailingSpace(std::string& btFriendlyName);
   tVoid vUpdateDidVersion(uint16_t& version);
   void vReadVehicleBtOnOff(KdsInfo& kdsInfo, bool& btOnOffSupport);
};

#endif //_CCA_OUTPUT_WRAPPER_H_

/** @} */
