/****************************************************************************
*FILE:         ResetToDefaultStatusPropHdl.cpp
*SW-COMPONENT: bmcore
*DESCRIPTION:  ResetToDefaultStatus Property Handler
*COPYRIGHT:    (c) 2015 Robert Bosch Car Multimedia GmbH
****************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/ResetToDefaultStatusPropHdl.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#endif
#endif

#include "ResetToDefaultStatusPropHdl.h"
#include "LocalSpm.h"
#include "FunctionTracer.h"

namespace bmcore
{
   ResetToDefaultStatusPropHdl::ResetToDefaultStatusPropHdl(IN BmCoreMainController& bmCoreMainController) :
         _bmCoreMainController(bmCoreMainController), _lock(), _firstUpdate(true), _resetToDefaultStatus()
   {
      ENTRY_INTERNAL
   }

   ResetToDefaultStatusPropHdl::~ResetToDefaultStatusPropHdl()
   {
      ENTRY_INTERNAL
   }

   void ResetToDefaultStatusPropHdl::get(OUT ResetToDefaultStatus& resetToDefaultStatus)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      resetToDefaultStatus = _resetToDefaultStatus;
   }

   void ResetToDefaultStatusPropHdl::set(IN const ResetToDefaultStatus& resetToDefaultStatus, IN const bool forcedUpdate)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      if ((resetToDefaultStatus != _resetToDefaultStatus) || (true == _firstUpdate) || (true == forcedUpdate))
      {
         _firstUpdate = false;

         _resetToDefaultStatus = resetToDefaultStatus;

         this->onResetToDefaultStatusChanged();
      }
   }

   void ResetToDefaultStatusPropHdl::onResetToDefaultStatusChanged()
   {
      ENTRY

      ResetToDefaultStatus resetToDefaultStatus;
      this->get(resetToDefaultStatus);

      ETG_TRACE_USR1(("onResetToDefaultStatusChanged: reporting changed ResetToDefaultStatus"));

      LocalSpm::getBmCoreCallbackIfWrapper().doOnResetToDefaultStatusChanged(resetToDefaultStatus);

      _bmCoreMainController.handlePropertyChange_ResetToDefaultStatus(resetToDefaultStatus);
   }
}
