
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/ProfileUsageInfoPropHdl.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#endif
#endif

#include "ProfileUsageInfoPropHdl.h"
#include "LocalSpm.h"
#include "FunctionTracer.h"
#include "BmVarTrace.h"

namespace bmcore
{
   ProfileUsageInfoPropHdl::ProfileUsageInfoPropHdl(BmCoreMainController& bmCoreMainController) :
		_bmCoreMainController(bmCoreMainController), _lock(), _firstUpdate(true), _btProfileUsageInfoList()
   {
      ENTRY_INTERNAL
   }//End of ProfileUsageInfoPropHdl::ProfileUsageInfoPropHdl(BmCoreMainController& bmCoreMainController)..

   ProfileUsageInfoPropHdl::~ProfileUsageInfoPropHdl()
   {
      ENTRY_INTERNAL
   }//End of ProfileUsageInfoPropHdl::~ProfileUsageInfoPropHdl()

   void ProfileUsageInfoPropHdl::get(ProfileUsageList& btProfileUsageInfoList)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);
      btProfileUsageInfoList = _btProfileUsageInfoList;
   }//End of  void ProfileUsageInfoPropHdl::get(ProfileUsageList& btProfileUsageInfoList)

   void ProfileUsageInfoPropHdl::set(const ProfileUsageList& btProfileUsageInfoList, IN const bool forcedUpdate)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      if ((btProfileUsageInfoList != _btProfileUsageInfoList) || (true == _firstUpdate) || (true == forcedUpdate))
      {
         _firstUpdate = false;

         _btProfileUsageInfoList = btProfileUsageInfoList;
         this->onBtProfileUsageInfoChanged();
      }//End of if ((btProfileUsageInfoList != _btProfileUsageInfoList) || (true == _firstUpdate) || (true == forcedUpdate))
   }//End of void ProfileUsageInfoPropHdl::set(const ProfileUsageList& btProfileUsageInfoList,...)

   void ProfileUsageInfoPropHdl::onBtProfileUsageInfoChanged()
   {
      ENTRY

      /*ProfileUsageList btProfileUsageInfo;
      this->get(btProfileUsageInfo);*/

      ETG_TRACE_USR1(("onBtProfileUsageInfoChanged: reporting changed btProfileUsageInfo"));

      //!Update the updated conflicts list to the registered clients
      LocalSpm::getBmCoreCallbackIfWrapper().doOnBtProfileUsageInfoChanged(_btProfileUsageInfoList);

      //_bmCoreMainController.handlePropertyChange_BtProfileUsageInfo(_btProfileUsageInfoList);
   }//End of void ProfileUsageInfoPropHdl::onBtProfileUsageInfoChanged()
}//End of namespace bmcore
