#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/PairingPinPropHdl.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#endif
#endif

#include "PairingPinPropHdl.h"
#include "LocalSpm.h"
#include "FunctionTracer.h"

namespace bmcore
{
   PairingPinPropHdl::PairingPinPropHdl(BmCoreMainController& bmCoreMainController) :
      _bmCoreMainController(bmCoreMainController), _lock(), _firstUpdate(true), _pairingPin()
   {
      ENTRY_INTERNAL
   }

   PairingPinPropHdl::~PairingPinPropHdl()
   {
      ENTRY_INTERNAL
   }

   void PairingPinPropHdl::get(PairingPin& pairingPin)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      pairingPin = _pairingPin;
   }

   void PairingPinPropHdl::set(IN const PairingPin& pairingPin, IN const bool forcedUpdate)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      if ((pairingPin != _pairingPin) || (true == _firstUpdate) || (true == forcedUpdate))
      {
         _firstUpdate = false;

         _pairingPin = pairingPin;

         this->onPairingPinChanged();
      }
   }

   void PairingPinPropHdl::onPairingPinChanged()
   {
      ENTRY_INTERNAL

      PairingPin pairingPin;
      this->get(pairingPin);

      ETG_TRACE_USR1(("onPairingPinChanged: reporting changed PairingPin"));

      LocalSpm::getBmCoreCallbackIfWrapper().doOnPairingPinChanged(pairingPin);
   }
}
