#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/LocalInfoPropHdl.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#endif
#endif

#include "LocalInfoPropHdl.h"
#include "LocalSpm.h"
#include "BmVarTrace.h"
#include "FunctionTracer.h"

namespace bmcore
{
   LocalInfoPropHdl::LocalInfoPropHdl(BmCoreMainController& bmCoreMainController) : _bmCoreMainController(bmCoreMainController),
         _lock(), _firstUpdate(true), _localInfo()
   {
      ENTRY_INTERNAL
   }

   LocalInfoPropHdl::~LocalInfoPropHdl()
   {
      ENTRY_INTERNAL
   }

   void LocalInfoPropHdl::get(LocalInfo& localInfo)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      localInfo = _localInfo;
   }

   void LocalInfoPropHdl::set(const LocalInfo& localInfo, const bool forcedUpdate)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      if ((localInfo != _localInfo) || (true == _firstUpdate) || (true == forcedUpdate))
      {
         _firstUpdate = false;

         _localInfo = localInfo;

         this->onLocalInfoChanged(localInfo);
      }
   }

   void LocalInfoPropHdl::onLocalInfoChanged(IN const LocalInfo& localInfo)
   {
      ETG_TRACE_USR1(("onLocalInfoChanged: LocalInfo changed"));

      LocalSpm::getBmCoreCallbackIfWrapper().doOnBtLocalInfoChanged(localInfo);

      //_bmCoreMainController.handlePropertyChange_LocalInfo(localInfo);
   }
}
