#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/LocalConnectableModeSwitchPropHdl.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#endif
#endif

#include "LocalConnectableModeSwitchPropHdl.h"
#include "LocalSpm.h"
#include "BmVarTrace.h"
#include "FunctionTracer.h"

namespace bmcore
{
   LocalConnectableModeSwitchPropHdl::LocalConnectableModeSwitchPropHdl(BmCoreMainController& bmCoreMainController) :
         _bmCoreMainController(bmCoreMainController), _lock(), _firstUpdate(true),
         _targetSwitchState(TARGET_SWITCH_STATE_SWITCHED_OFF), _switchStatus(),
         _externalSwitchState(SWITCH_STATE_SWITCHED_OFF), _switchedOffReason(SWITCHED_OFF_REASON_CLIENT), _numPendingBtsConnectableRequests(0)
   {
      ENTRY_INTERNAL
   }

   LocalConnectableModeSwitchPropHdl::~LocalConnectableModeSwitchPropHdl()
   {
      ENTRY_INTERNAL
   }

   TargetSwitchState LocalConnectableModeSwitchPropHdl::getTargetSwitchState(void) const
   {
      ENTRY_INTERNAL

      return _targetSwitchState;
   }

   void LocalConnectableModeSwitchPropHdl::get(INOUT SwitchStatus& switchStatus)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      switchStatus = _switchStatus;
   }

   void LocalConnectableModeSwitchPropHdl::setTargetSwitchState(IN const TargetSwitchState targetSwitchState,
         IN const BmCoreIfMsgOrigin origin, IN const ActType act)
   {
      ENTRY

      ETG_TRACE_USR1(("setTargetSwitchState: Current targetSwitchState = %d, Requested targetSwitchState = %d",
               ETG_CENUM(TargetSwitchState, _targetSwitchState), ETG_CENUM(TargetSwitchState, targetSwitchState)));

      SwitchStatus switchStatus(_switchStatus);

      ETG_TRACE_USR4(("setTargetSwitchState: Current Switch State = %d", ETG_CENUM(SwitchState, switchStatus._switchState)));

      if (targetSwitchState != _targetSwitchState)
      {
         if (targetSwitchState == TARGET_SWITCH_STATE_SWITCHED_OFF)
         {
            switch (switchStatus._switchState)
            {
               case SWITCH_STATE_SWITCHING_ON:
                  this->doRespondSwitching(0, origin, act);

                  _targetSwitchState = targetSwitchState;
                  break;
               case SWITCH_STATE_SWITCHED_ON:
                  this->doRespondSwitching(0, origin, act);

                  _targetSwitchState = targetSwitchState;

                  switchStatus._switchState = SWITCH_STATE_SWITCHING_OFF;

                  this->set(switchStatus, origin);

                  if (0 != this->doRequestExternalSwitching(targetSwitchState))
                  {
                     _targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_ON;

                     switchStatus._switchState = SWITCH_STATE_SWITCHED_ON;
                     this->set(switchStatus, origin);
                  }
                  break;
               case SWITCH_STATE_SWITCHING_OFF:
                  this->doRespondSwitching(0, origin, act);

                  _targetSwitchState = targetSwitchState;
                  break;
               default:
                  break;
            }
         }
         else // i.e. targetSwitchState == TARGET_SWITCH_STATE_SWITCHED_ON
         {
            switch (switchStatus._switchState)
            {
               case SWITCH_STATE_SWITCHING_ON:
                  this->doRespondSwitching(0, origin, act);

                  _targetSwitchState = targetSwitchState;
                  break;
               case SWITCH_STATE_SWITCHING_OFF:
                  this->doRespondSwitching(0, origin, act);

                  _targetSwitchState = targetSwitchState;
                  break;
               case SWITCH_STATE_SWITCHED_OFF:
               {
                  if ((SWITCHED_OFF_REASON_CLIENT == switchStatus._switchedOffReason)
                        || (SWITCHED_OFF_REASON_TIMEOUT == switchStatus._switchedOffReason)
                        || (SWITCHED_OFF_REASON_INTERNAL == switchStatus._switchedOffReason)
                        || (SWITCHED_OFF_REASON_ERROR == switchStatus._switchedOffReason))
                  {
                     this->doRespondSwitching(0, origin, act);

                     _targetSwitchState = targetSwitchState;

                     switchStatus._switchState = SWITCH_STATE_SWITCHING_ON;
                     switchStatus._switchedOffReason = SWITCHED_OFF_REASON_NOT_VALID;
                     this->set(switchStatus, origin);

                     if (0 != this->doRequestExternalSwitching(targetSwitchState))
                     {
                        _targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_OFF;

                        switchStatus._switchState = SWITCH_STATE_SWITCHED_OFF;
                        switchStatus._switchedOffReason = SWITCHED_OFF_REASON_ERROR;
                        this->set(switchStatus, origin);
                     }
                  }
                  else
                  {
                     this->doRespondSwitching(1, origin, act);
                  }
                  break;
               }
               default:
                  break;
            }
         }
      }
      else // i.e. targetSwitchState == _targetSwitchState
      {
         this->doRespondSwitching(0, origin, act);

         this->set(switchStatus, origin); // call needed for doing an initial reporting of
                                             // property to client
      }
   }

   void LocalConnectableModeSwitchPropHdl::onExternalSwitchingResponse(IN const CcErrorInternal result)
   {
      ENTRY

      ETG_TRACE_USR1(("onExternalSwitchingResponse: result = %d",
            ETG_CENUM(CcErrorInternal, result)));

      this->updateNumPendingBtsConnectableRequests(false);
   }

   void LocalConnectableModeSwitchPropHdl::onExternalSwitchStateUpdate(IN const SwitchState externalSwitchState,
         IN const SwitchedOffReason switchedOffReason)
   {
      ENTRY

      ETG_TRACE_USR1(("onExternalSwitchStateUpdate: externalSwitchState = %d",
            ETG_CENUM(SwitchState, externalSwitchState)));

      _externalSwitchState = externalSwitchState;
      _switchedOffReason = switchedOffReason;

      this->checkNumPendingBtsConnectableRequests();
   }

   void LocalConnectableModeSwitchPropHdl::doRespondSwitching(IN const Result result, IN const BmCoreIfMsgOrigin origin,
         IN const ActType act) const
   {
      if (BM_CORE_IF_MSG_ORIGIN_CLIENT == origin)
      {
         BmResult bmResult(BM_RESULT_OK);

         if (0 != result)
         {
            bmResult = BM_RESULT_ERR_GENERAL;
         }

         // respond to client's request synchronously
         LocalSpm::getBmCoreCallbackIfWrapper().doSwitchLocalConnectableModeResponse(bmResult, act);
      }
   }

   void LocalConnectableModeSwitchPropHdl::set(IN const SwitchStatus& switchStatus, IN const BmCoreIfMsgOrigin origin,
         IN const bool forcedUpdate)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      if ((switchStatus != _switchStatus) || (true == _firstUpdate) || (true == forcedUpdate))
      {
         _firstUpdate = false;

         _switchStatus = switchStatus;
         this->onSwitchStatusChanged(origin);
      }
   }

   void LocalConnectableModeSwitchPropHdl::onSwitchStatusChanged(IN const BmCoreIfMsgOrigin origin)
   {
      (void) origin;

      SwitchStatus localConnectableMode;
      this->get(localConnectableMode);

      ETG_TRACE_USR1(("onSwitchStatusChanged: LocalConnectableMode changed"));

      LocalSpm::getBmCoreCallbackIfWrapper().doOnLocalConnectableModeChanged(localConnectableMode);

      _bmCoreMainController.handlePropertyChange_LocalConnectableMode(localConnectableMode);
   }

   Result LocalConnectableModeSwitchPropHdl::doRequestExternalSwitching(IN const TargetSwitchState targetSwitchState)
   {
      ETG_TRACE_USR1(("doRequestExternalSwitching: switching %10s local connectable mode at BtStackIf",
            (targetSwitchState == TARGET_SWITCH_STATE_SWITCHED_ON) ? "ON" : "OFF"));

      Result result(0);

      if (TARGET_SWITCH_STATE_SWITCHED_ON == targetSwitchState)
      {
         _bmCoreMainController.getBtStackIfConnectionRequestIfWrapper().setLocalAdapterModes(BTS_MODE_UNCHANGED, 0,
               BTS_MODE_ENABLED, (TARGET_SWITCH_STATE_SWITCHED_OFF == LocalSpm::getDataProvider().getBmCoreConfiguration()._defaultLocalConnectableMode) ?
                     LocalSpm::getDataProvider().getBmCoreConfiguration()._localConnectableTimeoutSeconds : 0u, BM_REQUEST_TYPE_CONNECTABLE_MODE);
      }
      else
      {
         _bmCoreMainController.getBtStackIfConnectionRequestIfWrapper().setLocalAdapterModes(BTS_MODE_UNCHANGED, 0, BTS_MODE_DISABLED, 0, BM_REQUEST_TYPE_CONNECTABLE_MODE);
      }

      this->updateNumPendingBtsConnectableRequests(true);

      return result;
   }

   void LocalConnectableModeSwitchPropHdl::updateNumPendingBtsConnectableRequests(const bool increment)
   {
      ETG_TRACE_USR1(("updateNumPendingBtsConnectableRequests: %s number", increment ? "increment" : "decrement"));

      if (true == increment)
      {
         _numPendingBtsConnectableRequests++;
      }
      else
      {
         if (0u < _numPendingBtsConnectableRequests)
         {
            _numPendingBtsConnectableRequests--;
         }
         else
         {
            ETG_TRACE_ERR(("updateNumPendingBtsConnectableRequests: number of pending BTS connectable mode requests is already 0"));
         }
      }

      this->checkNumPendingBtsConnectableRequests();
   }

   void LocalConnectableModeSwitchPropHdl::checkNumPendingBtsConnectableRequests()
   {
      ETG_TRACE_USR1(("checkNumPendingBtsConnectableRequests: number of pending requests = %d", _numPendingBtsConnectableRequests));

      if (0u == _numPendingBtsConnectableRequests)
      {
         SwitchStatus switchStatus(_switchStatus);

         if (SWITCH_STATE_SWITCHED_OFF == _externalSwitchState)
         {
            if ((TARGET_SWITCH_STATE_SWITCHED_OFF == _targetSwitchState)
                  && (SWITCH_STATE_SWITCHED_OFF != switchStatus._switchState))
            {
               switchStatus._switchState = SWITCH_STATE_SWITCHED_OFF;
               switchStatus._switchedOffReason = SWITCHED_OFF_REASON_CLIENT;
               this->set(switchStatus, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);
            }

            if (TARGET_SWITCH_STATE_SWITCHED_ON == _targetSwitchState)
            {
               if (SWITCH_STATE_SWITCHING_OFF == switchStatus._switchState)
               {
                  switchStatus._switchState = SWITCH_STATE_SWITCHING_ON;
                  this->set(switchStatus, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);

                  if (0 != this->doRequestExternalSwitching(TARGET_SWITCH_STATE_SWITCHED_ON))
                  {
                     _targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_OFF;

                     switchStatus._switchState = SWITCH_STATE_SWITCHED_OFF;
                     switchStatus._switchedOffReason = SWITCHED_OFF_REASON_ERROR;
                     this->set(switchStatus, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);
                  }
               }
               else
               {
                  _targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_OFF;

                  switchStatus._switchState = SWITCH_STATE_SWITCHED_OFF;

                  if (SWITCHED_OFF_REASON_TIMEOUT == _switchedOffReason)
                  {
                     switchStatus._switchedOffReason = SWITCHED_OFF_REASON_TIMEOUT;
                  }
                  else
                  {
                     switchStatus._switchedOffReason = SWITCHED_OFF_REASON_INTERNAL;
                  }

                  this->set(switchStatus, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);
               }
            }
         }
         else // i.e. switchState == SWITCH_STATE_SWITCHED_ON
         {
            if (TARGET_SWITCH_STATE_SWITCHED_OFF == _targetSwitchState)
            {
               if (SWITCH_STATE_SWITCHING_ON == switchStatus._switchState)
               {
                  switchStatus._switchState = SWITCH_STATE_SWITCHING_OFF;
                  this->set(switchStatus, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);

                  if (0 != this->doRequestExternalSwitching(TARGET_SWITCH_STATE_SWITCHED_OFF))
                  {
                     _targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_ON;

                     switchStatus._switchState = SWITCH_STATE_SWITCHED_ON;
                     this->set(switchStatus, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);
                  }
               }
               else
               {
                  _targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_ON;

                  switchStatus._switchState = SWITCH_STATE_SWITCHED_ON;
                  switchStatus._switchedOffReason = SWITCHED_OFF_REASON_NOT_VALID;
                  this->set(switchStatus, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);
               }
            }
            else
            {
               if (SWITCH_STATE_SWITCHED_ON != switchStatus._switchState)
               {
                  switchStatus._switchState = SWITCH_STATE_SWITCHED_ON;
                  this->set(switchStatus, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);
               }
            }
         }
      }
   }
}
