#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/DiscoveryStatusPropHdl.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#endif
#endif

#include "DiscoveryStatusPropHdl.h"
#include "LocalSpm.h"
#include "BmVarTrace.h"
#include "FunctionTracer.h"

namespace bmcore
{
   DiscoveryStatusPropHdl::DiscoveryStatusPropHdl(BmCoreMainController& bmCoreMainController) :
         _bmCoreMainController(bmCoreMainController), _lock(), _firstUpdate(true),
         _targetSwitchState(TARGET_SWITCH_STATE_SWITCHED_OFF), _switchStatus()
   {
      ENTRY_INTERNAL
   }

   DiscoveryStatusPropHdl::~DiscoveryStatusPropHdl()
   {
      ENTRY_INTERNAL
   }

   TargetSwitchState DiscoveryStatusPropHdl::getTargetSwitchState(void) const
   {
      ENTRY_INTERNAL

      return _targetSwitchState;
   }

   void DiscoveryStatusPropHdl::get(OUT SwitchStatus& switchStatus)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      switchStatus = _switchStatus;
   }

   void DiscoveryStatusPropHdl::setTargetSwitchState(IN const TargetSwitchState targetSwitchState,
         IN const BmCoreIfMsgOrigin origin, IN const ActType act)
   {
      ENTRY

      SwitchStatus switchStatus(_switchStatus);

      if (targetSwitchState != _targetSwitchState)
      {
         if (targetSwitchState == TARGET_SWITCH_STATE_SWITCHED_OFF)
         {
            switch (switchStatus._switchState)
            {
               case SWITCH_STATE_SWITCHING_ON:
                  this->doRespondSwitching(0, origin, act);

                  _targetSwitchState = targetSwitchState;
                  break;
               case SWITCH_STATE_SWITCHED_ON:
                  this->doRespondSwitching(0, origin, act);

                  _targetSwitchState = targetSwitchState;

                  switchStatus._switchState = SWITCH_STATE_SWITCHING_OFF;

                  this->set(switchStatus, origin);

                  if (0 != this->doRequestExternalSwitching(targetSwitchState))
                  {
                     _targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_ON;

                     switchStatus._switchState = SWITCH_STATE_SWITCHED_ON;
                     this->set(switchStatus, origin);
                  }
                  break;
               case SWITCH_STATE_SWITCHING_OFF:
                  this->doRespondSwitching(0, origin, act);

                  _targetSwitchState = targetSwitchState;
                  break;
               default:
                  break;
            }
         }
         else // i.e. targetSwitchState == TARGET_SWITCH_STATE_SWITCHED_ON
         {
            switch (switchStatus._switchState)
            {
               case SWITCH_STATE_SWITCHING_ON:
                  this->doRespondSwitching(0, origin, act);

                  _targetSwitchState = targetSwitchState;
                  break;
               case SWITCH_STATE_SWITCHING_OFF:
                  this->doRespondSwitching(0, origin, act);

                  _targetSwitchState = targetSwitchState;
                  break;
               case SWITCH_STATE_SWITCHED_OFF:
               {
                  if ((SWITCHED_OFF_REASON_CLIENT == switchStatus._switchedOffReason)
                        || (SWITCHED_OFF_REASON_INTERNAL == switchStatus._switchedOffReason)
                        || (SWITCHED_OFF_REASON_ERROR == switchStatus._switchedOffReason))
                  {
                     this->doRespondSwitching(0, origin, act);

                     _targetSwitchState = targetSwitchState;

                     switchStatus._switchState = SWITCH_STATE_SWITCHING_ON;
                     switchStatus._switchedOffReason = SWITCHED_OFF_REASON_NOT_VALID;
                     this->set(switchStatus, origin);

                     if (0 != this->doRequestExternalSwitching(targetSwitchState))
                     {
                        _targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_OFF;

                        switchStatus._switchState = SWITCH_STATE_SWITCHED_OFF;
                        switchStatus._switchedOffReason = SWITCHED_OFF_REASON_ERROR;
                        this->set(switchStatus, origin);
                     }
                  }
                  else
                  {
                     this->doRespondSwitching(1, origin, act);
                  }
                  break;
               }
               default:
                  break;
            }
         }
      }
      else // i.e. targetSwitchState == _targetSwitchState
      {
         this->doRespondSwitching(0, origin, act);

         this->set(switchStatus, origin); // call needed for doing an initial reporting of
                                             // property to client
      }
   }

   void DiscoveryStatusPropHdl::onExternalSwitchingResponse(IN const CcErrorInternal result)
   {
      ENTRY

      ETG_TRACE_USR1(("onExternalSwitchingResponse: result = %d",
            ETG_CENUM(CcErrorInternal, result)));

      if (CC_ERR_INT_NO_ERROR != result)
      {
         SwitchStatus switchStatus(_switchStatus);

         switch (switchStatus._switchState)
         {
            case SWITCH_STATE_SWITCHING_ON:
               switchStatus._switchState = SWITCH_STATE_SWITCHED_OFF;

               if (_targetSwitchState == TARGET_SWITCH_STATE_SWITCHED_ON)
               {
                  // target: on
                  // present: switching on

                  _targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_OFF;

                  switchStatus._switchedOffReason = SWITCHED_OFF_REASON_ERROR;
               }
               else // i.e. _targetSwitchState == TARGET_SWITCH_STATE_SWITCHED_OFF
               {
                  // target: off
                  // present: switching on

                  switchStatus._switchedOffReason = SWITCHED_OFF_REASON_CLIENT;
               }
               break;
            case SWITCH_STATE_SWITCHING_OFF:
               switchStatus._switchState = SWITCH_STATE_SWITCHED_ON;

               if (_targetSwitchState == TARGET_SWITCH_STATE_SWITCHED_OFF)
               {
                  // target: off
                  // present: switching off

                  _targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_ON;
               }
               break;
            default:
               break;
         }

         this->set(switchStatus, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);
      }
   }

   void DiscoveryStatusPropHdl::onExternalSwitchStateUpdate(IN const SwitchState externalSwitchState)
   {
      ENTRY

      ETG_TRACE_USR1(("onExternalSwitchStateUpdate: externalSwitchState = %d",
            ETG_CENUM(cc::SwitchState, externalSwitchState)));

      SwitchStatus switchStatus(_switchStatus);

      if (SWITCH_STATE_SWITCHED_OFF == externalSwitchState)
      {
         if ((TARGET_SWITCH_STATE_SWITCHED_OFF == _targetSwitchState)
               && (SWITCH_STATE_SWITCHED_OFF != switchStatus._switchState))
         {
            // target: off
            // present: not switched off
            // reported: off

            switchStatus._switchState = SWITCH_STATE_SWITCHED_OFF;
            switchStatus._switchedOffReason = SWITCHED_OFF_REASON_CLIENT;
            this->set(switchStatus, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);
         }

         if (TARGET_SWITCH_STATE_SWITCHED_ON == _targetSwitchState)
         {
            if (SWITCH_STATE_SWITCHING_OFF == switchStatus._switchState)
            {
               // target: on
               // present: switching off
               // reported: off

               switchStatus._switchState = SWITCH_STATE_SWITCHING_ON;
               this->set(switchStatus, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);

               if (0 != this->doRequestExternalSwitching(TARGET_SWITCH_STATE_SWITCHED_ON))
               {
                  _targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_OFF;

                  switchStatus._switchState = SWITCH_STATE_SWITCHED_OFF;
                  switchStatus._switchedOffReason = SWITCHED_OFF_REASON_ERROR;
                  this->set(switchStatus, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);
               }
            }
            else
            {
               // target: on
               // present: not switching off
               // reported: off

               _targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_OFF;

               switchStatus._switchState = SWITCH_STATE_SWITCHED_OFF;
               switchStatus._switchedOffReason = SWITCHED_OFF_REASON_INTERNAL;
               this->set(switchStatus, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);
            }
         }
      }
      else // i.e. externalSwitchState == SWITCH_STATE_SWITCHED_ON
      {
         if (TARGET_SWITCH_STATE_SWITCHED_OFF == _targetSwitchState)
         {
            if (SWITCH_STATE_SWITCHING_ON == switchStatus._switchState)
            {
               switchStatus._switchState = SWITCH_STATE_SWITCHING_OFF;
               this->set(switchStatus, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);

               if (0 != this->doRequestExternalSwitching(TARGET_SWITCH_STATE_SWITCHED_OFF))
               {
                  _targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_ON;

                  switchStatus._switchState = SWITCH_STATE_SWITCHED_ON;
                  this->set(switchStatus, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);
               }
            }
            else
            {
               _targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_ON;

               switchStatus._switchState = SWITCH_STATE_SWITCHED_ON;
               switchStatus._switchedOffReason = SWITCHED_OFF_REASON_NOT_VALID;
               this->set(switchStatus, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);
            }
         }
         else
         {
            if (SWITCH_STATE_SWITCHED_ON != switchStatus._switchState)
            {
               switchStatus._switchState = SWITCH_STATE_SWITCHED_ON;
               this->set(switchStatus, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);
            }
         }
      }
   }

   void DiscoveryStatusPropHdl::doRespondSwitching(IN const Result result, IN const BmCoreIfMsgOrigin origin,
         IN const ActType act) const
   {
      if (BM_CORE_IF_MSG_ORIGIN_CLIENT == origin)
      {
         BmResult bmResult(BM_RESULT_OK);

         if (0 != result)
         {
            bmResult = BM_RESULT_ERR_GENERAL;
         }

         // respond to client's request synchronously
         LocalSpm::getBmCoreCallbackIfWrapper().doSwitchDiscoveryStatusResponse(bmResult, act);
      }
   }

   void DiscoveryStatusPropHdl::set(IN const SwitchStatus& switchStatus, IN const BmCoreIfMsgOrigin origin,
         IN const bool forcedUpdate)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      if ((switchStatus != _switchStatus) || (true == _firstUpdate) || (true == forcedUpdate))
      {
         _firstUpdate = false;

         _switchStatus = switchStatus;
         this->onSwitchStatusChanged(origin);
      }
   }

   void DiscoveryStatusPropHdl::onSwitchStatusChanged(IN const BmCoreIfMsgOrigin origin)
   {
      (void) origin;

      SwitchStatus discoveryStatus;
      this->get(discoveryStatus);

      ETG_TRACE_USR1(("onSwitchStatusChanged: DiscoveryStatus changed"));

      LocalSpm::getBmCoreCallbackIfWrapper().doOnDiscoveryStatusChanged(discoveryStatus);

      _bmCoreMainController.handlePropertyChange_DiscoveryStatus(discoveryStatus);
   }

   Result DiscoveryStatusPropHdl::doRequestExternalSwitching(IN const TargetSwitchState targetSwitchState) const
   {
      ETG_TRACE_USR1(("doRequestExternalSwitching: %20s device discovery at BtStackIf",
            (targetSwitchState == TARGET_SWITCH_STATE_SWITCHED_ON) ? "starting" : "stopping"));

      Result result(CC_ERR_INT_NO_ERROR);

      if (TARGET_SWITCH_STATE_SWITCHED_ON == targetSwitchState)
      {
         _bmCoreMainController.getBtStackIfConnectionRequestIfWrapper().startDiscovery();
      }
      else
      {
         _bmCoreMainController.getBtStackIfConnectionRequestIfWrapper().stopDiscovery();
      }

      return result;
   }
}
