/****************************************************************************
*FILE:         BmServiceAvailabilityPropHdl.cpp
*SW-COMPONENT: bmcore
*DESCRIPTION:  BmServiceAvailability Property Handler
*COPYRIGHT:    (c) 2015 Robert Bosch Car Multimedia GmbH
****************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/BmServiceAvailabilityPropHdl.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#endif
#endif

#include "BmServiceAvailabilityPropHdl.h"
#include "LocalSpm.h"
#include "FunctionTracer.h"

namespace bmcore
{
   BmServiceAvailabilityPropHdl::BmServiceAvailabilityPropHdl(IN BmCoreMainController& bmCoreMainController) :
            _bmCoreMainController(bmCoreMainController), _lock(), _firstUpdate(true), _bmServiceAvailability()
   {
      ENTRY_INTERNAL
   }

   BmServiceAvailabilityPropHdl::~BmServiceAvailabilityPropHdl()
   {
      ENTRY_INTERNAL
   }

   void BmServiceAvailabilityPropHdl::get(OUT BmServiceAvailability& bmServiceAvailability)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      bmServiceAvailability = _bmServiceAvailability;
   }

   void BmServiceAvailabilityPropHdl::set(IN const BmServiceAvailability& bmServiceAvailability, IN const bool forcedUpdate)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      if ((bmServiceAvailability != _bmServiceAvailability) || (true == _firstUpdate) || (true == forcedUpdate))
      {
         _firstUpdate = false;

         _bmServiceAvailability = bmServiceAvailability;

         this->onBmServiceAvailabilityChanged();
      }
   }

   void BmServiceAvailabilityPropHdl::onBmServiceAvailabilityChanged()
   {
      ENTRY

      BmServiceAvailability bmServiceAvailability;
      this->get(bmServiceAvailability);

      ETG_TRACE_USR1(("onBmServiceAvailabilityChanged: reporting changed BmServiceAvailability"));

      LocalSpm::getBmCoreCallbackIfWrapper().doOnBmServiceAvailabilityChanged(bmServiceAvailability);
   }
}
