/****************************************************************************
*FILE:         BmConfigDataPropHdl.cpp
*SW-COMPONENT: bmcore
*DESCRIPTION:  BmConfigData Property Handler
*COPYRIGHT:    (c) 2015 Robert Bosch Car Multimedia GmbH
****************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/BmConfigDataPropHdl.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#endif
#endif

#include "BmConfigDataPropHdl.h"
#include "LocalSpm.h"
#include "FunctionTracer.h"

namespace bmcore
{
   BmConfigDataPropHdl::BmConfigDataPropHdl(IN BmCoreMainController& bmCoreMainController) :
            _bmCoreMainController(bmCoreMainController), _lock(), _firstUpdate(true), _bmConfigData()
   {
      ENTRY_INTERNAL
   }

   BmConfigDataPropHdl::~BmConfigDataPropHdl()
   {
      ENTRY_INTERNAL
   }

   void BmConfigDataPropHdl::get(OUT BmConfigData& bmConfigData)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      bmConfigData = _bmConfigData;
   }

   void BmConfigDataPropHdl::set(IN const BmConfigData& bmConfigData, IN const bool forcedUpdate)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      if ((bmConfigData != _bmConfigData) || (true == _firstUpdate) || (true == forcedUpdate))
      {
         _firstUpdate = false;

         _bmConfigData = bmConfigData;

         this->onBmConfigDataChanged();
      }
   }

   void BmConfigDataPropHdl::onBmConfigDataChanged()
   {
      ENTRY

      BmConfigData bmConfigData;
      this->get(bmConfigData);

      ETG_TRACE_USR1(("onBmConfigDataChanged: reporting changed BmConfigData"));

      LocalSpm::getBmCoreCallbackIfWrapper().doOnBmConfigDataChanged(bmConfigData);
   }
}
