
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/BlockStatusPropHdl.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#endif
#endif

#include "BlockStatusPropHdl.h"
#include "LocalSpm.h"
#include "FunctionTracer.h"
#include "BmVarTrace.h"

namespace bmcore
{
   BlockStatusPropHdl::BlockStatusPropHdl(BmCoreMainController& bmCoreMainController) :
         _bmCoreMainController(bmCoreMainController), _lock(), _firstUpdate(true), _blockStatus(),
         _previousBlockStatus()
   {
      ENTRY_INTERNAL
   }

   BlockStatusPropHdl::~BlockStatusPropHdl()
   {
      ENTRY_INTERNAL
   }

   void BlockStatusPropHdl::get(OUT BlockStatus& blockStatus)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      blockStatus = _blockStatus;
   }

   void BlockStatusPropHdl::set(IN const BlockStatus& blockStatus, IN const bool forcedUpdate)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      _previousBlockStatus = _blockStatus;

      if ((blockStatus != _blockStatus) || (true == _firstUpdate) || (true == forcedUpdate))
      {
         _firstUpdate = false;

         _blockStatus = blockStatus;

         this->onBlockStatusChanged(blockStatus);
      }
   }

   void BlockStatusPropHdl::getPrevious(OUT BlockStatus& previousBlockStatus)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      previousBlockStatus = _previousBlockStatus;
   }

   void BlockStatusPropHdl::onBlockStatusChanged(IN const BlockStatus& blockStatus)
   {
      ETG_TRACE_USR1(("onBlockStatusChanged: BlockStatus changed"));

      LocalSpm::getBmCoreCallbackIfWrapper().doOnBlockStatusChanged(blockStatus);

      _bmCoreMainController.handlePropertyChange_BlockStatus(blockStatus);
   }
}
