/****************************************************************************
*FILE:         AutoConnectionTypePropHdl.cpp
*SW-COMPONENT: bmcore
*DESCRIPTION:  AutoConnectionType Property Handler
*COPYRIGHT:    (c) 2015 Robert Bosch Car Multimedia GmbH
****************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/AutoConnectionTypePropHdl.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#endif
#endif

#include "AutoConnectionTypePropHdl.h"
#include "LocalSpm.h"
#include "FunctionTracer.h"

namespace bmcore
{
   AutoConnectionTypePropHdl::AutoConnectionTypePropHdl(IN BmCoreMainController& bmCoreMainController) :
      _bmCoreMainController(bmCoreMainController), _lock(), _firstUpdate(true), _autoConnectionType()
   {
      ENTRY_INTERNAL
   }

   AutoConnectionTypePropHdl::~AutoConnectionTypePropHdl()
   {
      ENTRY_INTERNAL
   }

   void AutoConnectionTypePropHdl::get(OUT AutoConnectionType& autoConnectionType)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      autoConnectionType = _autoConnectionType;
   }

   void AutoConnectionTypePropHdl::set(IN const AutoConnectionType& autoConnectionType, IN const bool forcedUpdate)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      if ((autoConnectionType != _autoConnectionType) || (true == _firstUpdate) || (true == forcedUpdate))
      {
         _firstUpdate = false;

         _autoConnectionType = autoConnectionType;

         this->onAutoConnectionTypeChanged();
      }
   }

   void AutoConnectionTypePropHdl::onAutoConnectionTypeChanged()
   {
      ENTRY

      AutoConnectionType autoConnectionType;
      this->get(autoConnectionType);

      ETG_TRACE_USR1(("onAutoConnectionTypeChanged: reporting changed AutoConnectionType"));

      LocalSpm::getBmCoreCallbackIfWrapper().doOnAutoConnectionTypeChanged(autoConnectionType);
   }
}
