
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/AutoConnectionStatusPropHdl.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#endif
#endif

#include "AutoConnectionStatusPropHdl.h"
#include "FunctionTracer.h"
#include "LocalSpm.h"

namespace bmcore
{
   AutoConnectionStatusPropHdl::AutoConnectionStatusPropHdl(BmCoreMainController& bmCoreMainController) :
         _bmCoreMainController(bmCoreMainController), _lock(), _firstUpdate(true),
         _autoConnectionStatus(BM_AUTO_CONNECTION_STATE_IDLE, 0u)
   {
      ENTRY_INTERNAL
   }

   AutoConnectionStatusPropHdl::~AutoConnectionStatusPropHdl()
   {
      ENTRY_INTERNAL
   }

   void AutoConnectionStatusPropHdl::get(AutoConnectionStatus& autoConnectionStatus)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      autoConnectionStatus = _autoConnectionStatus;
   }

   void AutoConnectionStatusPropHdl::set(IN const AutoConnectionStatus& autoConnectionStatus, IN const bool forcedUpdate)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      if ((autoConnectionStatus != _autoConnectionStatus) || (true == _firstUpdate) || (true == forcedUpdate))
      {
         _firstUpdate = false;

         _autoConnectionStatus = autoConnectionStatus;
         this->onAutoConnectionStatusChanged();
      }
   }

   void AutoConnectionStatusPropHdl::onAutoConnectionStatusChanged()
   {
      ENTRY

      AutoConnectionStatus autoConnectionStatus;
      this->get(autoConnectionStatus);

      ETG_TRACE_USR1(("onAutoConnectionStatusChanged: AutoConnectionStatus changed"));

      LocalSpm::getBmCoreCallbackIfWrapper().doOnAutoConnectionStatusChanged(autoConnectionStatus);

      _bmCoreMainController.handlePropertyChange_AutoConnectionStatus(autoConnectionStatus);
   }
}
