/****************************************************************************
*FILE:         ResetToDefaultStatusPropHdl.h 
*SW-COMPONENT: bmcore
*DESCRIPTION:  ResetToDefaultStatus Property Handler
*COPYRIGHT:    (c) 2015 Robert Bosch Car Multimedia GmbH
****************************************************************************/

#ifndef _RESET_TO_DEFAULT_STATUS_PROP_HDL_H_
#define _RESET_TO_DEFAULT_STATUS_PROP_HDL_H_

#include "ResetToDefaultStatus.h"
#include "Lock.h"

namespace bmcore
{
   class BmCoreMainController;

   class ResetToDefaultStatusPropHdl
   {
   public:
      explicit ResetToDefaultStatusPropHdl(IN BmCoreMainController& bmCoreMainController);

      ~ResetToDefaultStatusPropHdl();

      void get(OUT ResetToDefaultStatus& resetToDefaultStatus);

      void set(IN const ResetToDefaultStatus& resetToDefaultStatus, IN const bool forcedUpdate = false);

   private:

      ResetToDefaultStatusPropHdl(const ResetToDefaultStatusPropHdl& other);

      ResetToDefaultStatusPropHdl& operator=(const ResetToDefaultStatusPropHdl& rhs);

      void onResetToDefaultStatusChanged();

      BmCoreMainController& _bmCoreMainController;

      LockForever _lock;
      bool _firstUpdate;

      ResetToDefaultStatus _resetToDefaultStatus;
   };
}

#endif // _RESET_TO_DEFAULT_STATUS_PROP_HDL_H_
