#ifndef _MULTI_HFP_SUPPORT_SWITCH_PROP_HDL_H_
#define _MULTI_HFP_SUPPORT_SWITCH_PROP_HDL_H_

#include "SwitchStatus.h"
#include "BmAllTypesInternal.h"
#include "Lock.h"

namespace bmcore
{
   class BmCoreMainController;

   class MultiHFPSupportSwitchPropHdl
   {
   public:

      explicit MultiHFPSupportSwitchPropHdl(BmCoreMainController& bmCoreMainController);

      ~MultiHFPSupportSwitchPropHdl();

      TargetSwitchState getTargetSwitchState(void) const;

      DeviceId getDeviceId(void) const;

      void get(OUT SwitchStatus& switchStatus);

      void setTargetSwitchState(IN const TargetSwitchState targetSwitchState,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT, IN const ActType act = 0u);

      void onInternalSwitchStateUpdate(IN const SwitchState switchState, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

   private:

      MultiHFPSupportSwitchPropHdl(const MultiHFPSupportSwitchPropHdl& other);

      MultiHFPSupportSwitchPropHdl& operator=(const MultiHFPSupportSwitchPropHdl& rhs);

      void doRespondSwitching(IN const Result result, IN const BmCoreIfMsgOrigin origin, IN const ActType act) const;

      void set(IN const SwitchStatus& switchStatus, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT,
            IN const bool forcedUpdate = false);

      void onSwitchStatusChanged(IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      Result doRequestInternalSwitching(IN const TargetSwitchState targetSwitchState, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      BmCoreMainController& _bmCoreMainController;

      LockForever _lock;
      bool _firstUpdate;
      DeviceId _deviceId;

      TargetSwitchState _targetSwitchState;
      SwitchStatus _switchStatus;
   };
}

#endif /* _MULTI_HFP_SUPPORT_SWITCH_PROP_HDL_H_ */
