#ifndef _LOCAL_INFO_PROP_HDL_H_
#define _LOCAL_INFO_PROP_HDL_H_

#include "LocalInfo.h"
#include "Lock.h"

namespace bmcore
{
   class BmCoreMainController;

   class LocalInfoPropHdl
   {
   public:
      explicit LocalInfoPropHdl(BmCoreMainController& bmCoreMainController);

      ~LocalInfoPropHdl();

      void get(OUT LocalInfo& localInfo);

      void set(IN const LocalInfo& localInfo, IN const bool forcedUpdate = false);

   private:

      LocalInfoPropHdl(const LocalInfoPropHdl& other);

      LocalInfoPropHdl& operator=(const LocalInfoPropHdl& rhs);

      void onLocalInfoChanged(IN const LocalInfo& localInfo);

      BmCoreMainController& _bmCoreMainController;

      LockForever _lock;
      bool _firstUpdate;

      LocalInfo _localInfo;
   };
}

#endif // _LOCAL_INFO_PROP_HDL_H_
