
#ifndef _BT_SYSTEM_STATE_PROPHDL_H_
#define _BT_SYSTEM_STATE_PROPHDL_H_

#include "BtSystemState.h"
#include "Lock.h"

namespace bmcore
{
   class BmCoreMainController;

   class BtSystemStatePropHdl
   {
   public:
      explicit BtSystemStatePropHdl(BmCoreMainController& bmCoreMainController);

      ~BtSystemStatePropHdl();

      void get(BtSystemState& btSystemState);

      void set(const BtSystemState& btSystemState, const bool forcedUpdate = false);

   private:

      BtSystemStatePropHdl(const BtSystemStatePropHdl& other);

      BtSystemStatePropHdl& operator=(const BtSystemStatePropHdl& rhs);

      void onBtSystemStateChanged();

      BmCoreMainController& _bmCoreMainController;

      LockForever _lock;
      bool _firstUpdate;

      BtSystemState _btSystemState;
   };
}

#endif // _BT_SYSTEM_STATE_PROPHDL_H_
