/****************************************************************************
*FILE:         BmConfigDataPropHdl.h 
*SW-COMPONENT: bmcore
*DESCRIPTION:  BmConfigData Property Handler
*COPYRIGHT:    (c) 2015 Robert Bosch Car Multimedia GmbH
****************************************************************************/

#ifndef _BM_CONFIG_DATA_PROP_HDL_H_
#define _BM_CONFIG_DATA_PROP_HDL_H_

#include "BmConfigData.h"
#include "Lock.h"

namespace bmcore
{
   class BmCoreMainController;

   class BmConfigDataPropHdl
   {
   public:
      explicit BmConfigDataPropHdl(IN BmCoreMainController& bmCoreMainController);

      ~BmConfigDataPropHdl();

      void get(OUT BmConfigData& bmConfigData);

      void set(IN const BmConfigData& bmConfigData, IN const bool forcedUpdate = false);

   private:
      BmConfigDataPropHdl(const BmConfigDataPropHdl& other);

      BmConfigDataPropHdl& operator=(const BmConfigDataPropHdl& rhs);

      void onBmConfigDataChanged();

      BmCoreMainController& _bmCoreMainController;

      LockForever _lock;
      bool _firstUpdate;

      BmConfigData _bmConfigData;
   };
}

#endif // _BM_CONFIG_DATA_PROP_HDL_H_
