/****************************************************************************
*FILE:         AutoConnectionTypePropHdl.h 
*SW-COMPONENT: bmcore
*DESCRIPTION:  AutoConnectionType Property Handler
*COPYRIGHT:    (c) 2015 Robert Bosch Car Multimedia GmbH
****************************************************************************/

#ifndef _AUTO_CONNECTION_TYPE_PROPHDL_H_
#define _AUTO_CONNECTION_TYPE_PROPHDL_H_

#include "AutoConnectionType.h"
#include "Lock.h"


namespace bmcore
{
   class BmCoreMainController;

   class AutoConnectionTypePropHdl
   {
   public:
      explicit AutoConnectionTypePropHdl(IN BmCoreMainController& bmCoreMainController);

      ~AutoConnectionTypePropHdl();

      void get(OUT AutoConnectionType& autoConnectionType);

      void set(IN const AutoConnectionType& autoConnectionType, IN const bool forcedUpdate = false);

   private:
      AutoConnectionTypePropHdl(const AutoConnectionTypePropHdl& other);

      AutoConnectionTypePropHdl& operator=(const AutoConnectionTypePropHdl& rhs);

      void onAutoConnectionTypeChanged();

      BmCoreMainController& _bmCoreMainController;

      LockForever _lock;
      bool _firstUpdate;

      AutoConnectionType _autoConnectionType;
   };
}

#endif // _AUTO_CONNECTION_TYPE_PROPHDL_H_
