#ifndef _BM_CORE_MAIN_CONTROLLER_H_
#define _BM_CORE_MAIN_CONTROLLER_H_

#include "ILocalSpm.h"
#include "ThreadFactory.h"
#include "BmAllTypesInternal.h"
#include "MessageQueue.h"
#include "BtStackIfConnectionRequestIfWrapper.h"
#include "BtStackIfConnectionCallbackIf.h"
#include "BtStackIfWblRequestIfWrapper.h"
#include "BtStackIfWblCallbackIf.h"

#include "BmConfigDataPropHdl.h"
#include "BtSystemStatePropHdl.h"
#include "BtStatusSwitchPropHdl.h"
#include "MultiHFPSupportSwitchPropHdl.h"
#include "LocalFriendlyNamePropHdl.h"
#include "LocalInfoPropHdl.h"
#include "LocalPairableModeSwitchPropHdl.h"
#include "LocalConnectableModeSwitchPropHdl.h"
#include "AutoConnectionTypePropHdl.h"
#include "AutoConnectionStatusPropHdl.h"
#include "DiscoveryStatusPropHdl.h"
#include "DiscoveredDeviceListPropHdl.h"
#include "PairingPinPropHdl.h"
#include "PairingStatusPropHdl.h"
#include "PairedDeviceListPropHdl.h"
#include "DeviceConnectionStatusListPropHdl.h"
#include "LinkQualityPropHdl.h"
#include "BlockStatusPropHdl.h"
#include "BtLimitationModePropHdl.h"
#include "TestModePropHdl.h"
#include "UserDecisionRequiredPropHdl.h"
#include "ProfileUsageInfoPropHdl.h"
#include "ResetToDefaultStatusPropHdl.h"
#include "TestModeLinkQualityPropHdl.h"
#include "BmServiceAvailabilityPropHdl.h"
#include "BlockRemoteConnectionsController.h"
#include "ServiceSearchController.h"
#include "Timer.h"

namespace bmcore
{
   // class forward declarations
   class BmCoreIfMessage;
   class BmCoreIfMessage_SetProtocolUserAvailabilityRequest;
   class BmCoreIfMessage_SetAutoConnectionTypeRequest;
   class BmCoreIfMessage_SwitchBtStatusRequest;
   class BmCoreIfMessage_SetBtLocalFriendlyNameRequest;
   class BmCoreIfMessage_SwitchLocalPairableModeRequest;
   class BmCoreIfMessage_SwitchLocalConnectableModeRequest;
   class BmCoreIfMessage_SwitchDiscoveryStatusRequest;
   class BmCoreIfMessage_PairingStatusUpdate;
   class BmCoreIfMessage_StartPairingRequest;
   class BmCoreIfMessage_CancelPairingRequest;
   class BmCoreIfMessage_AcceptPairingRequestRequest;
   class BmCoreIfMessage_RejectPairingRequestRequest;
   class BmCoreIfMessage_SetPairingPinRequest;
   class BmCoreIfMessage_AddOobPairedDeviceRequest;
   class BmCoreIfMessage_DeleteDeviceRequest;
   class BmCoreIfMessage_StartAutoConnectionSequenceRequest;
   class BmCoreIfMessage_StopAutoConnectionSequenceRequest;
   class BmCoreIfMessage_ConnectDeviceRequest;
   class BmCoreIfMessage_DisconnectDeviceRequest;
   class BmCoreIfMessage_ConnectProfilesRequest;
   class BmCoreIfMessage_DisconnectProfilesRequest;
   class BmCoreIfMessage_BlockDeviceRequest;
   class BmCoreIfMessage_UnblockDeviceRequest;
   class BmCoreIfMessage_BlockProfilesRequest;
   class BmCoreIfMessage_UnblockProfilesRequest;
   class BmCoreIfMessage_PairedDeviceListUpdate;
   class BmCoreIfMessage_DeviceConnectionStatusListUpdate;
   class BmCoreIfMessage_SetFavoriteRequest;
   class BmCoreIfMessage_ClearFavoriteRequest;
   class BmCoreIfMessage_SetPrimaryHfpDeviceRequest;
   class BmCoreIfMessage_StopServiceSearchRequest;
   class BmCoreIfMessage_StartServiceSearchRequest;
   class BmCoreIfMessage_UpdateLinkQualityRequest;
   class BmCoreIfMessage_BlockStatusUpdate;
   class BmCoreIfMessage_SetBtLimitationModeRequest;
   class BmCoreIfMessage_ReplaceBtLimitationModeRequest;
   class BmCoreIfMessage_BtLimitationModeUpdate;
   class BmCoreIfMessage_NotifyUserDecisionRequest;
   class BmCoreIfMessage_SwitchTestModeRequest;
   class BmCoreIfMessage_ResetToDefaultRequest;
   class BmCoreIfMessage_BtsFbConnectionInitialized;
   class BmCoreIfMessage_BtsLocalVersionInfo;
   class BmCoreIfMessage_BtsSwitchBluetoothOnOffResult;
   class BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus;
   class BmCoreIfMessage_BtsBluetoothHardwareOnOffResult;
   class BmCoreIfMessage_BtsSetLocalBtNameResult;
   class BmCoreIfMessage_BtsCurrentLocalBtName;
   class BmCoreIfMessage_BtsSetLocalAdapterModesResult;
   class BmCoreIfMessage_BtsCurrentDiscoverableMode;
   class BmCoreIfMessage_BtsCurrentConnectableMode;
   class BmCoreIfMessage_BtsStartDiscoveryResult;
   class BmCoreIfMessage_BtsStopDiscoveryResult;
   class BmCoreIfMessage_BtsDiscoveringStatus;
   class BmCoreIfMessage_BtsDiscoveredDeviceFound;
   class BmCoreIfMessage_BtsStartPairingResult;
   class BmCoreIfMessage_BtsPinCodeRequested;
   class BmCoreIfMessage_BtsSecureSimplePairingRequested;
   class BmCoreIfMessage_BtsPairingFinished;
   class BmCoreIfMessage_BtsSupportedServices;
   class BmCoreIfMessage_BtsSppCapabilities;
   class BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords;
   class BmCoreIfMessage_BtsDeviceCapabilities;
   class BmCoreIfMessage_BtsRemoteServiceSearchResult;
   class BmCoreIfMessage_BtsRemoteNameResult;
   class BmCoreIfMessage_BtsRemoteNameStatusUpdate;
   class BmCoreIfMessage_BtsLinkKeyRequested;
   class BmCoreIfMessage_BtsConnectProtocolResult;
   class BmCoreIfMessage_BtsRemoteProtocolConnectRequest;
   class BmCoreIfMessage_BtsDisconnectProtocolResult;
   class BmCoreIfMessage_BtsDisconnectDeviceResult;
   class BmCoreIfMessage_BtsProtocolConnectionStatus;
   class BmCoreIfMessage_BtsDeviceConnectionStatus;
   class BmCoreIfMessage_BtsLinkQualityResult;
   class BmCoreIfMessage_BtsStartTestModeResult;
   class BmCoreIfMessage_BtsStopTestModeResult;
   class BmCoreIfMessage_BtsTestModeStatus;
   class BmCoreIfMessage_BtsFbWblInitialized;
   class BmCoreIfMessage_BtsWblServiceAvailability;
   class BmCoreIfMessage_BtsWblLastIntendedMode;
   class BmCoreIfMessage_BtsWblSupportedFrequencies;
   class BmCoreIfMessage_BtsWblHealthinessIndicator;
   class BmCoreIfMessage_TerminateMessageHandlerThread;
   class BmCoreIfMessage_SetDeviceRemoteConnectable;
   class BmCoreIfMessage_SmTimeout;
   class BmCoreIfMessage_SwitchMultiHFPSupportRequest;
   class BmCoreIfMessage_SetBtProfilesUsageRequest;
   class BmCoreIfMessage_SetDeviceUsagePreferenceRequest;
   class BmCoreIfMessage_BtSystemState;

   class BmCoreMainController : public ILocalSpm, public TFThread
   {
   public:
      explicit BmCoreMainController(IN const ComponentId componentId);

      virtual ~BmCoreMainController();

      void notifyComponentState(IN const ComponentId componentId, IN const ComponentState componentState);

      Result initBtStackIfConnection(IN const BTSLocalStackConfiguration& configuration, IN const BTSBDAddressList& pairedDevices);

      Result initBtStackIfWbl(IN const BTSLocalWblConfiguration& configuration);

      Result initBmConfigData(void);

      BmResult getBmConfigData(OUT BmConfigData& bmConfigData,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_INTERNAL);

      BmResult getBmServiceAvailablity(OUT BmServiceAvailability& bmServiceAvailability,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_INTERNAL);

      Result initBtSystemState(void);

      BmResult setBtSystemState(IN const BtSystemState& btSystemState);

      BmResult getBtSystemState(OUT BtSystemState& btSystemState,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_INTERNAL);

      Result initLocalFriendlyName(void);

      Result initLocalInfo(void);

      Result initBlockStatus(void);

      Result initMultiHFPSupport(void);

      BmResult switchBtStatusInt(IN const TargetSwitchState& targetSwitchState,
            IN const bool suppressAutoConnectionAfterSwitchedOn, IN const bool updateLastMode);

      BmResult setBtLocalFriendlyNameInt(IN const LocalFriendlyNameType& bdName);

      BmResult setBtLocalFriendlyNameIntForced(IN const LocalFriendlyNameType& bdName);

      BmResult switchLocalPairableModeInt(IN const TargetSwitchState& targetSwitchState,
            IN const BdAddress& bdAddress);

      Result initLocalPairableMode(void);

      BmResult switchLocalConnectableModeInt(IN const TargetSwitchState& targetSwitchState,
            IN const BdAddress& bdAddress);

      Result initLocalConnectableMode(void);

      BmResult deleteDeviceInt(IN const DeviceId deviceId, IN const DeviceHandleType deviceHandleType);

      BmResult connectDeviceInt(IN const DeviceId deviceId, IN const bool delayRequestProcessing = false, IN const PageTimeout pageTimeout = 10240u);

      BmResult disconnectDeviceInt(IN const DeviceId deviceId, IN const DeviceHandleType deviceHandleType,
            IN const DisconnectedReason disconnectedReason, IN const bool deleteDevice = false);

      BmResult connectProfilesInt(IN const DeviceId deviceId, IN const ProtocolList& protocolList, IN const PageTimeout pageTimeout);

      BmResult disconnectProfilesInt(IN const DeviceId deviceId, IN const ProtocolList& protocolList);

      BmResult blockProfilesInt(IN const DeviceId deviceId, IN const ProtocolList& protocolList, IN const bool ignoreStopAutoconnection = false);

      BmResult unblockProfilesInt(IN const DeviceId deviceId, IN const ProtocolList& protocolList);

      BmResult switchMultiHFPSupportStatusInt(IN const TargetSwitchState& targetSwitchState);

      void addOobPairedDeviceInt(IN const BdAddress& bdAddress, IN const BdName& bdName,
            IN const LinkKey& linkKey, IN const OobType oobType, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_INTERNAL);

      BmResult getDiscoveryStatus(OUT SwitchStatus& discoveryStatus,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_INTERNAL);

      Result initDiscoveryStatus(void);

      BmResult switchDiscoveryStatusInt(IN const TargetSwitchState& targetSwitchState);

      BmResult getDiscoveredDeviceList(OUT DiscoveredDeviceList& discoveredDeviceList,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_INTERNAL);

      void initDiscoveredDeviceList(void);

      Result initAutoConnectionType(void);

      BmResult setAutoConnectionTypeInt(IN const AutoConnectionType& autoConnectionType);

      BmResult setAutoConnectionType(IN const AutoConnectionType& autoConnectionType, IN const ActType act);

      BmResult getAutoConnectionType(OUT AutoConnectionType& autoConnectionType,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_INTERNAL);

      void setAutoConnectionStatusInt(IN const AutoConnectionState autoConnectionState, IN const DeviceId deviceIdInProgress);

      BmResult setBtLimitationModeInt(IN const BdAddress& bdAddress, IN const BdName& bdName, IN const LimitationMode& limitationMode,
            IN const LimitationAction limitationAction);

      void pushBmCoreIfMessage(IN BmCoreIfMessage* bmCoreIfMessage);

      BmResult getBtStatus(OUT SwitchStatus& btStatus,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_INTERNAL);

      BmResult getBtLocalFriendlyName(OUT LocalFriendlyName& localFriendlyName,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_INTERNAL);

      BmResult getLocalInfo(OUT LocalInfo& localInfo, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_INTERNAL);

      BmResult getLocalPairableMode(OUT SwitchStatus& localPairableMode,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_INTERNAL);

      BmResult getLocalConnectableMode(OUT SwitchStatus& localConnectableMode,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_INTERNAL);

      BmResult getPairingPin(OUT PairingPin& pairingPin,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_INTERNAL);

      const PairingPinType getPairingPinCode();

      Result initPairingPin(void);

      Result updateLegacyPairingPin(void);

      BmResult setPairingPinInt(IN const PairingPin& pairingPin);

      BmResult getPairingStatus(OUT PairingStatus& pairingStatus,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_INTERNAL);

      void setPairingStatusInt(IN const PairingStatus& pairingStatus);

      BmResult getPairedDeviceList(OUT PairedDeviceList& pairedDeviceList,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_INTERNAL);

      Result initPairedDeviceList(void);

      Result resetRemoteConnections(void);

      void onDeviceBaseInfoChanged(void);

      void onDeviceConnectionStatusChanged(IN const DeviceConnectionInfo& deviceConnectionInfo);

      void onProtocolConnectionStatusChanged(IN const DeviceId deviceId, IN const Protocol& protocol,
            IN const ConnectionStatus connectionStatus, IN const DisconnectedReason disconnectedReason,
            IN const RfcommDevicePath& rfcommDevicePath);

      BmResult setDeviceRemoteConnectableInt(IN const DeviceId deviceId, IN const RemoteConnectable remoteConnectable);

      Result getDeviceRemoteConnectable(OUT RemoteConnectable& remoteConnectable, IN const DeviceId deviceId);

      Result getDeviceRemoteConnectable(OUT RemoteConnectable& remoteConnectable, IN const BdAddress& bdAddress);

      Result setDeviceiAPoverBTSupported(IN const DeviceId deviceId, IN const bool iAPoverBTSupported);

      Result getDeviceiAPoverBTSupported(OUT bool& iAPoverBTSupported, IN const DeviceId deviceId);

      BmResult getRemoteDeviceInfo(OUT RemoteDeviceInfo& remoteDeviceInfo, IN const DeviceId deviceHandle,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_INTERNAL);

      void onDeviceDeleted(IN const DeviceId deviceHandle);

      BmResult getDeviceConnectionStatusList(OUT DeviceConnectionStatusList& deviceConnectionStatusList,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_INTERNAL);

      BmResult getLinkQuality(OUT LinkQuality& linkQuality,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_INTERNAL);

      void onLinkQuality(IN const LinkQuality& linkQuality);

      BmResult getBlockStatus(OUT BlockStatus& blockStatus,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_INTERNAL);

      void setBlockStatusInt(IN const BlockStatus& blockStatus);

      void updateBlockStatus(IN const DeviceId devHandle, IN const BlockStatus& blockStatus,
            IN const BlockStatusUpdateType updateType);

      BmResult getAutoConnectionStatus(OUT AutoConnectionStatus& autoConnectionStatus,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_INTERNAL);

      Result getDeviceIdForBdName(OUT DeviceId& deviceId, IN const BdName& bdName);

      Result getDeviceHandleForBdName(OUT DeviceId& deviceHandle, IN const BdName& bdName);

      BmResult getBtLimitationMode(OUT BtLimitationMode& btLimitationMode,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_INTERNAL);

      Result getBtLimitationModeInfo(OUT BtLimitationModeInfo& btLimitationModeInfo,
            IN const BdAddress& bdAddress, IN BdName bdName = "");

      Result getBtLimitationModeInfo(OUT BtLimitationModeInfo& btLimitationModeInfo,
                  IN const DeviceId deviceId);

      Result updateBtLimitationMode(IN const BdAddress& bdAddress, IN const BdName& bdName, IN const LimitationMode& limitationMode,
            IN const LimitationState limitationState);

      Result deleteBtLimitationModeItem(IN const BdAddress& bdAddress, IN const BdName& bdName, IN const LimitationMode& limitationMode);

      BmResult getTestMode(OUT SwitchStatus& testMode,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_INTERNAL);

      BmResult getMultiHFPSupportStatus(OUT SwitchStatus& multiHFPSupportStatus,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_INTERNAL);

      BmResult getDeviceUsagePreference(OUT UsagePreference& usagePreference,
            IN const DeviceId deviceHandle, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_INTERNAL);

      Result getBtProfileUsageInfoList(OUT ProfileUsageList& btProfileUsageInfoList);

      Result updateBtProfileUsageInfoList(IN ProfileUsageList& btProfileUsageListUpdate);

      Result getBtConflictsDetectedList(OUT IssueInfoList& btConflictsDetectedList);

      Result updateBtConflictsDetectedList(IN const IssueInfoList& btConflictsDetectedList);

      Result clearBtConflictsList(IN const ConflictTrigger conflictTrigger);

      Result updateBtConflictsListItem(IN const IssueInfo& btConflictsListItem);

      Result initResetToDefaultStatus(void);

      BmResult getResetToDefaultStatus(OUT ResetToDefaultStatus& resetToDefaultStatus,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_INTERNAL);

      void updateResetToDefaultStatus(IN const ResetToDefaultState resetToDefaultState,
            IN const ResetToDefaultResult resetToDefaultResult);

      void onLocalSpmStateChanged(IN const SpmState spmState);

      Result checkAndDeactivateCPW(BtLimitationModeInfo& btLimitationModeInfo);

      Result blockRemoteConnections(IN const DeviceId deviceId);

      Result blockRemoteConnectionsTimeLimited(IN const DeviceId deviceId);

      Result unblockRemoteConnections(IN const DeviceId deviceId);

      Result stopDeviceServiceSearch(IN const DeviceId deviceId);

      BmResult startDeviceServiceSearch(IN const DeviceId deviceId);

      void handlePropertyChange_BtStatus(IN const SwitchStatus btStatus);

      void handlePropertyChange_LocalPairableMode(IN const SwitchStatus localPairableMode);

      void handlePropertyChange_LocalConnectableMode(IN const SwitchStatus localConnectableMode);

      void handlePropertyChange_DiscoveryStatus(IN const SwitchStatus& discoveryStatus);

      void handlePropertyChange_AutoConnectionStatus(IN const AutoConnectionStatus& autoConnectionStatus);

      void handlePropertyChange_PairedDeviceList(IN const PairedDeviceList& pairedDeviceList);

      void handlePropertyChange_DeviceConnectionStatusList(IN const DeviceConnectionStatusList& deviceConnectionStatusList,
            IN const DeviceConnectionStatusList& previousDeviceConnectionStatusList);

      void handlePropertyChange_BlockStatus(IN const BlockStatus& blockStatus);

      void handlePropertyChange_BtLimitationMode(IN const BtLimitationMode& btLimitationMode);

      void handlePropertyChange_MultiHFPSupportStatus(IN const SwitchStatus multiHFPSupportStatus);

      void handlePropertyChange_UserDecisionReqdInfo(IN const IssueInfoList& issueInfoList);

      void handlePropertyChange_ResetToDefaultStatus(IN const ResetToDefaultStatus& resetToDefaultStatus);

      void setDeviceBdAddrForRestrictedPairingConnecting(IN BdAddress bdAddress);

      void deactivateBtLimitationModeCPW(DeviceId deviceId);

      void deactivateBtLimitationModeCPW(BdAddress bdAddress);

      void checkAndUpdateBmServiceAvailability();

      void updateSupportedSppUuid(IN const BdAddress& bdAddress, IN const UuidList& supportedSppUuids);

      void sendDisconnectDeviceRequest(DeviceId& deviceId);

      void sendDisconnectDeviceRequest(const BdAddress bdAddress);

      inline BtStackIfConnectionRequestIfWrapper& getBtStackIfConnectionRequestIfWrapper(void)
      {
         return _btStackIfConnectionRequestIfWrapper;
      }

      inline const BtStackIfConnectionCallbackIf& getBtStackIfConnectionCallbackIf(void) const
      {
         return _btStackIfConnectionCallbackIf;
      }

      inline BtStackIfConnectionCallbackIf& getBtStackIfConnectionCallbackIf(void)
      {
         return _btStackIfConnectionCallbackIf;
      }

      inline BtStackIfWblRequestIfWrapper& getBtStackIfWblRequestIfWrapper(void)
      {
         return _btStackIfWblRequestIfWrapper;
      }

      inline const BtStackIfWblCallbackIf& getBtStackIfWblCallbackIf(void) const
      {
         return _btStackIfWblCallbackIf;
      }

      Result stopThread();

      inline const DeviceIdList& getConnectedDevicesWaitingForLinkQuality(void) const
      {
         return _connectedDevicesWaitingForLinkQuality;
      }

      inline const LinkQuality& getIntermediateLinkQuality(void) const
      {
         return _intermediateLinkQuality;
      }

      void addConnectedDeviceToWaitingForLinkQuality(IN const DeviceId deviceHandle);

      void removeConnectedDeviceFromWaitingForLinkQuality(IN const DeviceId deviceHandle);

      void addLinkQualityToIntermediateLinkQuality(IN const DeviceId deviceHandle, IN const LinkQualityType linkQuality,
            IN const Rssi rssi);

      Result updateFunctionalityRestrictionInfo(IN const RestrictionBit restrictionBit, IN const bool toBeSet);

      Result getProfileConnectionPageTimeout ( OUT PageTimeout& pausePagingTimeoutMilliSeconds, OUT PageTimeout& pageTimeout);

      bool isFunctionalityPermitted(IN const FunctionalityRestrictionInfo restrictionInfo);

      std::string getFunctionalityRestrictionInfoString(IN const FunctionalityRestrictionInfo restrictionInfo);

      BmResult doGetLinkQualityTestMode(OUT TestModeLinkQuality& linkQuality);

      bool startBtOnDelayTimer();
      void stopBtOnDelayTimerAndSendReq();
	  
      void create();

      int init(InitReason reason);

      int run();

      int stop();

      int done();

      void Do(int param, void* userPtr);

   private:
      void handleBmCoreIfMessage(BmCoreIfMessage* bmCoreIfMessage);

      BmResult handleBmCoreIfMessage_SetProtocolUserAvailabilityRequest(BmCoreIfMessage_SetProtocolUserAvailabilityRequest* bmCoreIfMessage);
      BmResult handleBmCoreIfMessage_SetAutoConnectionTypeRequest(BmCoreIfMessage_SetAutoConnectionTypeRequest* bmCoreIfMessage);
      BmResult handleBmCoreIfMessage_SwitchBtStatusRequest(BmCoreIfMessage_SwitchBtStatusRequest* bmCoreIfMessage);
      BmResult handleBmCoreIfMessage_SetBtLocalFriendlyNameRequest(BmCoreIfMessage_SetBtLocalFriendlyNameRequest* bmCoreIfMessage);
      BmResult handleBmCoreIfMessage_SwitchLocalPairableRequest(BmCoreIfMessage_SwitchLocalPairableModeRequest* bmCoreIfMessage);
      BmResult handleBmCoreIfMessage_SwitchLocalConnectableModeRequest(BmCoreIfMessage_SwitchLocalConnectableModeRequest* bmCoreIfMessage);
      BmResult handleBmCoreIfMessage_SwitchDiscoveryStatusRequest(BmCoreIfMessage_SwitchDiscoveryStatusRequest* bmCoreIfMessage);
      void handleBmCoreIfMessage_PairingStatusUpdate(BmCoreIfMessage_PairingStatusUpdate* bmCoreIfMessage);
      void handleBmCoreIfMessage_StartPairingRequest(BmCoreIfMessage_StartPairingRequest* bmCoreIfMessage);
      void handleBmCoreIfMessage_CancelPairingRequest(BmCoreIfMessage_CancelPairingRequest* bmCoreIfMessage);
      void handleBmCoreIfMessage_AcceptPairingRequestRequest(BmCoreIfMessage_AcceptPairingRequestRequest* bmCoreIfMessage);
      void handleBmCoreIfMessage_RejectPairingRequestRequest(BmCoreIfMessage_RejectPairingRequestRequest* bmCoreIfMessage);
      BmResult handleBmCoreIfMessage_SetPairingPinRequest(BmCoreIfMessage_SetPairingPinRequest* bmCoreIfMessage);
      void handleBmCoreIfMessage_AddOobPairedDeviceRequest(BmCoreIfMessage_AddOobPairedDeviceRequest* bmCoreIfMessage);
      BmResult handleBmCoreIfMessage_DeleteDeviceRequest(BmCoreIfMessage_DeleteDeviceRequest* bmCoreIfMessage);
      BmResult handleBmCoreIfMessage_StartAutoConnectionSequenceRequest(BmCoreIfMessage_StartAutoConnectionSequenceRequest* bmCoreIfMessage);
      BmResult handleBmCoreIfMessage_StopAutoConnectionSequenceRequest(BmCoreIfMessage_StopAutoConnectionSequenceRequest* bmCoreIfMessage);
      BmResult handleBmCoreIfMessage_ConnectDeviceRequest(BmCoreIfMessage_ConnectDeviceRequest* bmCoreIfMessage);
      BmResult handleBmCoreIfMessage_DisconnectDeviceRequest(BmCoreIfMessage_DisconnectDeviceRequest* bmCoreIfMessage);
      BmResult handleBmCoreIfMessage_ConnectProfilesRequest(BmCoreIfMessage_ConnectProfilesRequest* bmCoreIfMessage);
      BmResult handleBmCoreIfMessage_DisconnectProfilesRequest(BmCoreIfMessage_DisconnectProfilesRequest* bmCoreIfMessage);
      BmResult handleBmCoreIfMessage_BlockDeviceRequest(BmCoreIfMessage_BlockDeviceRequest* bmCoreIfMessage);
      BmResult handleBmCoreIfMessage_UnblockDeviceRequest(BmCoreIfMessage_UnblockDeviceRequest* bmCoreIfMessage);
      BmResult handleBmCoreIfMessage_BlockProfilesRequest(BmCoreIfMessage_BlockProfilesRequest* bmCoreIfMessage);
      BmResult handleBmCoreIfMessage_UnblockProfilesRequest(BmCoreIfMessage_UnblockProfilesRequest* bmCoreIfMessage);
      void handleBmCoreIfMessage_PairedDeviceListUpdate(BmCoreIfMessage_PairedDeviceListUpdate* bmCoreIfMessage);
      void handleBmCoreIfMessage_DeviceConnectionStatusListUpdate(BmCoreIfMessage_DeviceConnectionStatusListUpdate* bmCoreIfMessage);
      void handleBmCoreIfMessage_SetFavoriteRequest(BmCoreIfMessage_SetFavoriteRequest* bmCoreIfMessage);
      void handleBmCoreIfMessage_ClearFavoriteRequest(BmCoreIfMessage_ClearFavoriteRequest* bmCoreIfMessage);
      void handleBmCoreIfMessage_SetPrimaryHfpDeviceRequest(BmCoreIfMessage_SetPrimaryHfpDeviceRequest* bmCoreIfMessage);
      void handleBmCoreIfMessage_StopServiceSearchRequest(BmCoreIfMessage_StopServiceSearchRequest* bmCoreIfMessage );
      void handleBmCoreIfMessage_StartServiceSearchRequest(BmCoreIfMessage_StartServiceSearchRequest* bmCoreIfMessage );
      void handleBmCoreIfMessage_UpdateLinkQualityRequest(BmCoreIfMessage_UpdateLinkQualityRequest* bmCoreIfMessage);

      void handleBmCoreIfMessage_BlockStatusUpdate(BmCoreIfMessage_BlockStatusUpdate* bmCoreIfMessage);
      BmResult handleBmCoreIfMessage_SetBtLimitationModeRequest(BmCoreIfMessage_SetBtLimitationModeRequest* bmCoreIfMessage);
      BmResult handleBmCoreIfMessage_ReplaceBtLimitationModeRequest(BmCoreIfMessage_ReplaceBtLimitationModeRequest* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtLimitationModeUpdate(BmCoreIfMessage_BtLimitationModeUpdate* bmCoreIfMessage);
      void handleBmCoreIfMessage_NotifyUserDecisionRequest(BmCoreIfMessage_NotifyUserDecisionRequest* bmCoreIfMessage);
      BmResult handleBmCoreIfMessage_SwitchTestModeRequest(BmCoreIfMessage_SwitchTestModeRequest* bmCoreIfMessage);
      BmResult handleBmCoreIfMessage_ResetToDefaultRequest(BmCoreIfMessage_ResetToDefaultRequest* bmCoreIfMessage);

      void handleBmCoreIfMessage_BtsFbConnectionInitialized(BmCoreIfMessage_BtsFbConnectionInitialized* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsLocalVersionInfo(BmCoreIfMessage_BtsLocalVersionInfo* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsSwitchBluetoothOnOffResult(BmCoreIfMessage_BtsSwitchBluetoothOnOffResult* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsCurrentBluetoothOnOffStatus(BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsBluetoothHardwareOnOffResult(BmCoreIfMessage_BtsBluetoothHardwareOnOffResult* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsSetLocalBtNameResult(BmCoreIfMessage_BtsSetLocalBtNameResult* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsCurrentLocalBtName(BmCoreIfMessage_BtsCurrentLocalBtName* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsSetLocalAdapterModesResult(BmCoreIfMessage_BtsSetLocalAdapterModesResult* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsCurrentConnectableMode(BmCoreIfMessage_BtsCurrentConnectableMode* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsCurrentDiscoverableMode(BmCoreIfMessage_BtsCurrentDiscoverableMode* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsStartDiscoveryResult(BmCoreIfMessage_BtsStartDiscoveryResult* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsStopDiscoveryResult(BmCoreIfMessage_BtsStopDiscoveryResult* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsDiscoveringStatus(BmCoreIfMessage_BtsDiscoveringStatus* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsDiscoveredDeviceFound(BmCoreIfMessage_BtsDiscoveredDeviceFound* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsStartPairingResult(BmCoreIfMessage_BtsStartPairingResult* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsPinCodeRequested(BmCoreIfMessage_BtsPinCodeRequested* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsSecureSimplePairingRequested(BmCoreIfMessage_BtsSecureSimplePairingRequested* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsPairingFinished(BmCoreIfMessage_BtsPairingFinished* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsSupportedServices(BmCoreIfMessage_BtsSupportedServices* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsSppCapabilities(BmCoreIfMessage_BtsSppCapabilities* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsRemoteDeviceIdServiceRecords(BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsDeviceCapabilities(BmCoreIfMessage_BtsDeviceCapabilities* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsRemoteServiceSearchResult(BmCoreIfMessage_BtsRemoteServiceSearchResult* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsRemoteNameResult(BmCoreIfMessage_BtsRemoteNameResult* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsRemoteNameStatusUpdate(BmCoreIfMessage_BtsRemoteNameStatusUpdate* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsLinkKeyRequested(BmCoreIfMessage_BtsLinkKeyRequested* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsConnectProtocolResult(BmCoreIfMessage_BtsConnectProtocolResult* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsRemoteProtocolConnectRequest(BmCoreIfMessage_BtsRemoteProtocolConnectRequest* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsDisconnectProtocolResult(BmCoreIfMessage_BtsDisconnectProtocolResult* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsDisconnectDeviceResult(BmCoreIfMessage_BtsDisconnectDeviceResult* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsProtocolConnectionStatus(BmCoreIfMessage_BtsProtocolConnectionStatus* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsDeviceConnectionStatus(BmCoreIfMessage_BtsDeviceConnectionStatus* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsLinkQualityResult(BmCoreIfMessage_BtsLinkQualityResult* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsStartTestModeResult(BmCoreIfMessage_BtsStartTestModeResult* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsStopTestModeResult(BmCoreIfMessage_BtsStopTestModeResult* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsTestModeStatus(BmCoreIfMessage_BtsTestModeStatus* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsFbWblInitialized(BmCoreIfMessage_BtsFbWblInitialized* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsWblServiceAvailability(BmCoreIfMessage_BtsWblServiceAvailability* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsWblLastIntendedMode(BmCoreIfMessage_BtsWblLastIntendedMode* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsWblSupportedFrequencies(BmCoreIfMessage_BtsWblSupportedFrequencies* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtsWblHealthinessIndicator(BmCoreIfMessage_BtsWblHealthinessIndicator* bmCoreIfMessage);
      void handleBmCoreIfMessage_BtSystemStateChange(BmCoreIfMessage_BtSystemState* bmCoreIfMessage);

      void handleBmCoreIfMessage_TerminateThreadRequest(BmCoreIfMessage_TerminateMessageHandlerThread* bmCoreIfMessage);
      BmResult handleBmCoreIfMessage_SetDeviceRemoteConnectable(BmCoreIfMessage_SetDeviceRemoteConnectable* bmCoreIfMessage);

      void handleBmCoreIfMessage_SmTimeout(BmCoreIfMessage_SmTimeout* bmCoreIfMessage);
      BmResult handleBmCoreIfMessage_SwitchMultiHFPSupportRequest(BmCoreIfMessage_SwitchMultiHFPSupportRequest* bmCoreIfMessage);
      void handleBmCoreIfMessage_SetProfileUsageInfoRequest(BmCoreIfMessage_SetBtProfilesUsageRequest* bmCoreIfMessage);
      BmResult handleBmCoreIfMessage_SetDeviceUsagePreferenceRequest(BmCoreIfMessage_SetDeviceUsagePreferenceRequest* bmCoreIfMessage);

      BmResult checkBmCoreIfRequest(BmCoreIfMessage* bmCoreIfMessage);

      void processBtSystemStateOffOrBlock(IN const BtSystemState btSystemState);

      void addRemoteSupportedProtocol(IN const ProtocolId protocolId, IN const ProtocolVersion protocolVersion);
      const ProtocolIdVersionList getRemoteSupportedProtocols(void) const;
      void resetRemoteSupportedProtocols(void);
      void addRemoteSupportedSppUuid(IN const Uuid& uuid);
      const UuidList getRemoteSupportedSppUuids(void) const;
      void resetRemoteSupportedSppUuids(void);
      void setRemoteDeviceIdentification(IN const DeviceIdentification& deviceIdentification);
      const DeviceIdentification getRemoteDeviceIdentification(void) const;
      void resetRemoteDeviceIdentification(void);
      void addRemoteDevicesSppVersion(IN const BTSBDAddress& btsBdAddress, IN const ProtocolVersion sppVersion);
      void getRemoteDevicesSppVersion(IN const BdAddress& bdAddress, OUT ProtocolVersion& sppVersion);
      void onDeviceAdded(IN const DeviceBaseInfo& deviceBaseInfo);
      LegacyPinCode generateLegacyPairingPin(IN const uint32_t numDigits);
      void onSupportedProtocolsChanged(IN const DeviceId deviceHandle, IN const ProtocolInfoMap& protocolInfomap);
      void onSupportedSppUuidsChanged(IN const DeviceId deviceHandle);
      void getConnectedDevices(OUT DeviceIdList& connectedDeviceHandles);
      Result updateOverallDeviceBlockStatus(IN const OverallDeviceBlockStatus& overallDeviceBlockStatus);
      void getPrimaryStatus(INOUT DeviceConnectionStatusList& deviceConnectionStatusList);
      void checkForPendingIssuesToBeResolved();
      Result checkAutoConnectionInProgress(ProtocolId protocolId, BdAddress bdAddress, bool& ignoreStopAutoconnection);
      Result checkRemoteConnectionrequestTobeAllowed(ProtocolId protocolId, BdAddress bdAddress, Uuid uuid);
      void defaultActionforPairableAndDiscoverable();
      Result checkAndUpdateSupportedUuid(Uuid uuid, BdAddress bdAddress);
      void updateWblHealthinessIndicator(const BTSWblHealthinessIndicator wblHealthinessIndicator);

      static bool delayBtOnTimerCb(timer_t rTimerID, void *pvObject, const void *pvUserData);

      MessageQueue           _bmCoreIfMessageQueue;
      int                    _threadId;
      bool                   _terminateThread;

      ComponentState _expectedComponentState;

      BtStackIfConnectionRequestIfWrapper _btStackIfConnectionRequestIfWrapper;
      BtStackIfConnectionCallbackIf _btStackIfConnectionCallbackIf;

      BtStackIfWblRequestIfWrapper _btStackIfWblRequestIfWrapper;
      BtStackIfWblCallbackIf _btStackIfWblCallbackIf;

      BmConfigDataPropHdl                 _bmConfigDataPropHdl;
      BtSystemStatePropHdl                _btSystemStatePropHdl;
      BtStatusSwitchPropHdl               _btStatusSwitchPropHdl;
      MultiHFPSupportSwitchPropHdl        _multiHFPSupportSwitchPropHdl;
      LocalFriendlyNamePropHdl            _localFriendlyNamePropHdl;
      LocalInfoPropHdl                    _localInfoPropHdl;
      LocalPairableModeSwitchPropHdl      _localPairableModeSwitchPropHdl;
      LocalConnectableModeSwitchPropHdl   _localConnectableModeSwitchPropHdl;
      AutoConnectionTypePropHdl           _autoConnectionTypePropHdl;
      AutoConnectionStatusPropHdl         _autoConnectionStatusPropHdl;
      DiscoveryStatusPropHdl              _discoveryStatusPropHdl;
      DiscoveredDeviceListPropHdl         _discoveredDeviceListPropHdl;
      PairingPinPropHdl                   _pairingPinPropHdl;
      PairingStatusPropHdl                _pairingStatusPropHdl;
      PairedDeviceListPropHdl             _pairedDeviceListPropHdl;
      DeviceConnectionStatusListPropHdl   _deviceConnectionStatusListPropHdl;
      LinkQualityPropHdl                  _linkQualityPropHdl;
      BlockStatusPropHdl                  _blockStatusPropHdl;
      BtLimitationModePropHdl             _btLimitationModePropHdl;
      TestModePropHdl                     _testModePropHdl;
      UserDecisionRequiredPropHdl         _userDecisionRequiredPropHdl;
      ProfileUsageInfoPropHdl             _btProfileUsageInfoPropHdl;
      ResetToDefaultStatusPropHdl         _resetToDefaultStatusPropHdl;
      TestModeLinkQualityPropHdl          _testModeLinkQualityPropHdl;
      BmServiceAvailabilityPropHdl        _bmServiceAvailabilityPropHdl;

      BlockRemoteConnectionsController _remoteConnectableController;
      ServiceSearchController _serviceSearchController;

      ProtocolIdVersionList                   _remoteSupportedProtocols;
      UuidList                                _remoteSupportedSppUuids;
      DeviceIdentification                    _remoteDeviceIdentification;
      std::map<BTSBDAddress, ProtocolVersion> _remoteDevicesSPPVersion;

      DeviceIdList _connectedDevicesWaitingForLinkQuality;
      LinkQuality _intermediateLinkQuality;
      BTSWblHealthinessIndicator _wblHealthinessIndicator;

      // todo: following members are only temporarily declared in this class
      // and should be moved to separate classes
      unsigned int _numberPendingUpdateLinkQualityRequests;
      FunctionalityRestrictionInfo _currentFunctionalityRestrictionInfo;
      LockForeverAndNonReentrant   _currentFunctionalityRestrictionInfoLock;
      std::map<RestrictionBit, std::string> _restrictionBitStringMap;
      bool _resetToFactorySettingsRequested;

      timer_t _delayBtOnRequestTimerId;
      Timer   _delayBtOnRequestTimer;
      Lock _lockDelayBtOnRequestTimer;
      bool _waitingForEvoStackRestart;

      std::vector<IssueInfoList> _pendingIssuesToBeResolvedList;
   };
}

#endif // _BM_CORE_MAIN_CONTROLLER_H_
