/*
 * ILocalSpm.cpp
 *
 *  - Implementation
 *
 */

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_LOCALSPM
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/ILocalSpm.cpp.trc.h"
#endif
#endif

#include "LocalSpmStartSm.h"
#include "LocalSpmStopSm.h"
#include "ILocalSpm.h"
#include "LocalSpm.h"
#include "Dispatcher.h"

#include <sstream>

namespace bmcore
{
   int ILocalSpm::createDone(int error)
   {
      (void) error;
      _componentState = COMPONENT_STATE_CREATE;
      return 0;
   }

   int ILocalSpm::initDone(int error)
   {
      (void) error;

      char parameter[32];
      LocalSpm::getInstance().ParameterINIT_READY(parameter, sizeof(parameter) - 1, _componentID);
      Dispatcher::GetInstance().SendMessage("LocalSpmStartSm::INIT_READY", parameter);

      return 0;
   }

   int ILocalSpm::runDone(int error)
   {
      (void) error;

      char parameter[32];
      LocalSpm::getInstance().ParameterRUN_READY(parameter, sizeof(parameter) - 1, _componentID);
      Dispatcher::GetInstance().SendMessage("LocalSpmStartSm::RUN_READY", parameter);

      return 0;
   }


   int ILocalSpm::stopDone(int error)
   {
      (void) error;

      char parameter[32];
      LocalSpm::getInstance().ParameterSTOP_READY(parameter, sizeof(parameter) - 1, _componentID);
      Dispatcher::GetInstance().SendMessage("LocalSpmStopSm::STOP_READY", parameter);

      return 0;
   }

   int ILocalSpm::doneDone(int error)
   {
      (void) error;

      char parameter[32];
      LocalSpm::getInstance().ParameterDONE_READY(parameter, sizeof(parameter) - 1, _componentID);
      Dispatcher::GetInstance().SendMessage("LocalSpmStopSm::DONE_READY", parameter);

      return 0;
   }

   void ILocalSpm::setState(ComponentState componentState)
   {
      _componentState = componentState;
   }

   const char* ILocalSpm::getStateName(void) const
   {
      switch (_componentState)
      {
         case COMPONENT_STATE_CREATE:
            return "COMPONENT_STATE_CREATE";
         case COMPONENT_STATE_INIT:
            return "COMPONENT_STATE_INIT";
         case COMPONENT_STATE_RUNNING:
            return "COMPONENT_STATE_RUNNING";
         case COMPONENT_STATE_STOP:
            return "COMPONENT_STATE_STOP";
         case COMPONENT_STATE_DONE:
            return "COMPONENT_STATE_DONE";
         case COMPONENT_STATE_UNKNOWN:
         default:
            return "COMPONENT_STATE_UNKNOWN";
      }
   }

   const char* ILocalSpm::getComponentName(void) const
   {
      switch (_componentID)
      {
         case COMPONENT_ID_THREAD_FACTORY:
            return "THREAD_FACTORY";
         case COMPONENT_ID_DISPATCHER:
            return "DISPATCHER";
         case COMPONENT_ID_DB_MANAGER:
            return "DB_MANAGER";
         case COMPONENT_ID_DATA_PROVIDER:
            return "DATA_PROVIDER";
         case COMPONENT_ID_AUTOCONNECTION_CONTROLLER:
            return "AUTOCONNECTION_CONTROLLER";
         case COMPONENT_ID_RESET_TO_DEFAULT_CONTROLLER:
            return "RESET_TO_DEFAULT_CONTROLLER";
         case COMPONENT_ID_PAIRING_CONTROLLER:
            return "PAIRING_CONTROLLER";
         case COMPONENT_ID_BT_LIMITATION_CONTROLLER:
            return "BT_LIMITATION_CONTROLLER";
         case COMPONENT_ID_BM_CORE_MAIN_CONTROLLER:
            return "BMC_MAIN_CONTROLLER";
         case COMPONENT_ID_BM_CONTROLLER:
            return "BM_CONTROLLER";
         case COMPONENT_ID_OUTPUTWRAPPER:
            return "CALLBACK_IF_COMPONENT";
         case COMPONENT_ID_BM_CORE_CALLBACK_IF_WRAPPER:
            return "BM_CORE_CALLBACK_IF_WRAPPER";
//         case COMPONENT_ID_ALL_DEVICES_DISCONNECTION:
//            return "ALL_DEVICES_DISCONNECTION";
         case COMPONENT_ID_CONFIGURATION:
            return "CONFIGURATION";
         case COMPONENT_ID_CUSTOM_CONTROL:
            return "CUSTOM_CONTROL";
         case COMPONENT_ID_CONFLICTMANAGER:
        	 return "CONFLICT_MANAGER";
         case COMPONENT_ID_UNKNOWN:
         default:
            return "UNKNOWN";
      }
   }

   char *ILocalSpm::getSmStateName(OUT tGeneralString stateName, size_t size)
   {
      strncpy(stateName, "n/a", size);
      return stateName;
   }


   bool ILocalSpm::isComponentSm()
   {
      return false; //component is no state machine
   }
}
