/**
 * @file BtStackIfWblCallbackIf.cpp
 *
 * @swcomponent BluetoothConnectionManagerCore
 *
 * @brief This file contains the definition of the class BtStackIfWblCallbackIf
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details A detailed description is not yet available
 *
 * @ingroup BmControllerModule
 */

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_BMCONTROLLER
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/BtStackIfWblCallbackIf.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_BMCONTROLLER
#endif
#endif


#include "BtStackIfWblCallbackIf.h"
#include "BmCoreIfMessagesCreator.h"
#include "BmCoreMainController.h"
#include "LocalSpm.h"
#include "BmUtils.h"
#include "FunctionTracer.h"
#include "BmGlobalLock.h"

namespace bmcore
{
   BtStackIfWblCallbackIf::BtStackIfWblCallbackIf(BmCoreMainController& bmCoreMainController) :
         _bmCoreMainController(bmCoreMainController),
         _blockCallback(false)
   {
      ENTRY_INTERNAL

      ETG_TRACE_USR1(("BtStackIfWblCallbackIf: is being created"));
   }

   BtStackIfWblCallbackIf::~BtStackIfWblCallbackIf()
   {
      ENTRY_INTERNAL

      ETG_TRACE_USR1(("~BtStackIfWblCallbackIf"));
   }

   void BtStackIfWblCallbackIf::fbWblInitializedCB(IN const BTSRequestResult btsResult)
   {
      ETG_TRACE_USR1(("fbWblInitializedCB: btsResult = %d", ETG_CENUM(BTSRequestResult, btsResult)));

      if(_blockCallback)
      {
         ETG_TRACE_USR1(("fbWblInitializedCB: blocked"));
         return;
      }

      // no global lock because internal message is created

      BmCoreIfMessage_BtsFbWblInitialized* bmCoreIfMessage = getNewBmCoreIfMessage_BtsFbWblInitialized(btsResult,
            0u);

      if (0 == bmCoreIfMessage)
      {
         ETG_TRACE_FATAL(("fbWblInitializedCB: bmCoreIfMessage is 0"));
         return;
      }

      _bmCoreMainController.pushBmCoreIfMessage(bmCoreIfMessage);
   }

   void BtStackIfWblCallbackIf::setWblDummyResultCB(IN const BTSRequestResult btsResult)
   {
      ETG_TRACE_USR1(("setWblDummyResultCB: btsResult = %d", ETG_CENUM(BTSRequestResult, btsResult)));

      if(_blockCallback)
      {
         ETG_TRACE_USR1(("setWblDummyResultCB: blocked"));
         return;
      }
   }

   void BtStackIfWblCallbackIf::allowWblCommunicationResultCB(void)
   {
      ETG_TRACE_USR1(("allowWblCommunicationResultCB"));

      if(_blockCallback)
      {
         ETG_TRACE_USR1(("allowWblCommunicationResultCB: blocked"));
         return;
      }
   }

   void BtStackIfWblCallbackIf::blockWblCommunicationResultCB(void)
   {
      ETG_TRACE_USR1(("blockWblCommunicationResultCB"));

      if(_blockCallback)
      {
         ETG_TRACE_USR1(("blockWblCommunicationResultCB: blocked"));
         return;
      }
   }

   void BtStackIfWblCallbackIf::wblCommunicationStatusCB(IN const bool btsEnabled)
   {
      ETG_TRACE_USR1(("wblCommunicationStatusCB: btsEnabled = %10s", btsEnabled ? "true" : "false"));

      if(_blockCallback)
      {
         ETG_TRACE_USR1(("wblCommunicationStatusCB: blocked"));
         return;
      }
   }

   void BtStackIfWblCallbackIf::wblServiceAvailabilityCB(IN const bool btsServiceAvailable)
   {
      ETG_TRACE_USR1(("wblServiceAvailabilityCB: btsServiceAvailable = %10s", btsServiceAvailable ? "true" : "false"));

      if(_blockCallback)
      {
         ETG_TRACE_USR1(("wblServiceAvailabilityCB: blocked"));
         return;
      }

      BmCoreIfMessage_BtsWblServiceAvailability* bmCoreIfMessage = getNewBmCoreIfMessage_BtsWblServiceAvailability(btsServiceAvailable,
            0u);

      if (0 == bmCoreIfMessage)
      {
         ETG_TRACE_FATAL(("wblServiceAvailabilityCB: bmCoreIfMessage is 0"));
         return;
      }

      _bmCoreMainController.pushBmCoreIfMessage(bmCoreIfMessage);
   }

   void BtStackIfWblCallbackIf::wblLastIntendedModeCB(IN const BTSWblLastIntendedModeList& btsLastIntendedModeList)
   {
      ETG_TRACE_USR1(("wblLastIntendedModeCB"));

      if(_blockCallback)
      {
         ETG_TRACE_USR1(("wblLastIntendedModeCB: blocked"));
         return;
      }

      // no global lock because internal message is created

      BmCoreIfMessage_BtsWblLastIntendedMode* bmCoreIfMessage = getNewBmCoreIfMessage_BtsWblLastIntendedMode(btsLastIntendedModeList,
            0u);

      if (0 == bmCoreIfMessage)
      {
         ETG_TRACE_FATAL(("wblLastIntendedModeCB: bmCoreIfMessage is 0"));
         return;
      }

      _bmCoreMainController.pushBmCoreIfMessage(bmCoreIfMessage);
   }

   void BtStackIfWblCallbackIf::wblSupportedRestrictionsCB(IN const BTSWblSupportedRestrictionEntryList& btsSupportedRestrictionList)
   {
      ETG_TRACE_USR1(("wblSupportedRestrictionsCB"));

      // no global lock because internal message is created

      if(false == _blockCallback)
      {
		  BmCoreIfMessage_BtsWblSupportedFrequencies* bmCoreIfMessage = getNewBmCoreIfMessage_BtsWblSupportedFrequencies
				  (btsSupportedRestrictionList, 0u);

		  if (0 != bmCoreIfMessage)
		  {
			 _bmCoreMainController.pushBmCoreIfMessage(bmCoreIfMessage);
		  }//End of if (0 != bmCoreIfMessage)
		  else
		  {
			  ETG_TRACE_FATAL(("wblSupportedRestrictionsCB: bmCoreIfMessage is 0"));
		  }//End of else
      }//End of if(false == _blockCallback)
      else
      {
    	  ETG_TRACE_USR4(("wblSupportedRestrictionsCB: blocked"));
      }//End of else
   }

   void BtStackIfWblCallbackIf::wblWiFiSetupStatusCB(IN const BTSWblWiFiSetupStatusEntryList& btsWifiSetupStatusList)
   {
      ETG_TRACE_USR1(("wblWiFiSetupStatusCB"));

      (void) btsWifiSetupStatusList;

      if(_blockCallback)
      {
         ETG_TRACE_USR1(("wblWiFiSetupStatusCB: blocked"));
         return;
      }

      // no global lock because internal message is created

      // TODO
   }

   void BtStackIfWblCallbackIf::wblHealthinessIndicatorCB(IN const BTSWblHealthinessIndicator btsValue)
   {
      ETG_TRACE_USR1(("wblHealthinessIndicatorCB"));

      // no global lock because internal message is created
      if(false == _blockCallback)
      {
         BmCoreIfMessage_BtsWblHealthinessIndicator* bmCoreIfMessage = getNewBmCoreIfMessage_BtsWblHealthinessIndicator
               (btsValue, 0u);

         if (0 != bmCoreIfMessage)
         {
            _bmCoreMainController.pushBmCoreIfMessage(bmCoreIfMessage);
         }//End of if (0 != bmCoreIfMessage)
         else
         {
            ETG_TRACE_FATAL(("wblHealthinessIndicatorCB: bmCoreIfMessage is 0"));
         }//End of else
      }//End of if(false == _blockCallback)
      else
      {
         ETG_TRACE_USR4(("wblHealthinessIndicatorCB: blocked"));
      }//End of else
   }

}
