#ifndef _WIFI_HEALTHINESS_INDICATOR_H_
#define _WIFI_HEALTHINESS_INDICATOR_H_

#include "BmInterfaceTypesInternal.h"
#include "BaseTypes.h"
#include <list>

namespace bmcore
{
   class WifiHealthinessIndicatorInfo
   {
   public:
      WifiHealthinessIndicatorInfo();

      WifiHealthinessIndicatorInfo(const uint8_t& wifiHealthinessIndicatorThresholdValue, const PageTimeout connectionPageTimeoutMilliSeconds);

      WifiHealthinessIndicatorInfo(const WifiHealthinessIndicatorInfo& other);

      virtual ~WifiHealthinessIndicatorInfo();

      friend void swap(WifiHealthinessIndicatorInfo& first, WifiHealthinessIndicatorInfo& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      WifiHealthinessIndicatorInfo& operator=(WifiHealthinessIndicatorInfo other);

      bool operator==(const WifiHealthinessIndicatorInfo& rhs) const;

      uint8_t _wifiHealthinessIndicatorThresholdValue;
      PageTimeout _connectionPageTimeoutMilliSeconds;
   };

   typedef std::list<WifiHealthinessIndicatorInfo> WifiHealthinessIndicatorInformation;
}

#endif // _WIFI_HEALTHINESS_INDICATOR_H_
