
#ifndef _USER_DECISION_INFO_H_
#define _USER_DECISION_INFO_H_

#include "BmInterfaceTypesInternal.h"

namespace bmcore
{
   class UserDecisionInfo 
   {
   public:

      UserDecisionInfo();

      UserDecisionInfo(IN const ConflictTrigger conflictTrigger, IN const UserDecision userDecision);

      UserDecisionInfo(const UserDecisionInfo& other);

      ~UserDecisionInfo();

      friend void swap(UserDecisionInfo& first, UserDecisionInfo& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      UserDecisionInfo& operator=(UserDecisionInfo other);

      bool operator==(const UserDecisionInfo& rhs) const;

      bool operator!=(const UserDecisionInfo& rhs) const;

      ConflictTrigger _conflictTrigger;
      UserDecision _userDecision;

   private:

   };

} // namespace bmcore

#endif // _USER_DECISION_INFO_H_
