/****************************************************************************
*FILE:         TestModeLinkQuality.h 
*SW-COMPONENT: bmcore
*DESCRIPTION:  TestModeLinkQuality Property
*COPYRIGHT:    (c) 2015 Robert Bosch Car Multimedia GmbH
****************************************************************************/

#ifndef _TEST_MODE_LINK_QUALITY_H_
#define _TEST_MODE_LINK_QUALITY_H_

#include "LinkQualityInfo.h"

namespace bmcore
{
   class TestModeLinkQuality
   {
   public:

      TestModeLinkQuality();

      TestModeLinkQuality(IN const LinkQualityInfo linkQualityInfo);

      TestModeLinkQuality(const TestModeLinkQuality& testModelinkQuality);

      ~TestModeLinkQuality();

      friend void swap(TestModeLinkQuality& first, TestModeLinkQuality& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      TestModeLinkQuality& operator=(TestModeLinkQuality other);

      bool operator==(const TestModeLinkQuality& rhs) const;

      bool operator!=(const TestModeLinkQuality& rhs) const;

      LinkQualityInfo _linkQualityInfo;

   private:
   
   };

} // namespace bmcore

#endif // _TEST_MODE_LINK_QUALITY_H_
