/****************************************************************************
*FILE:         TestModeLinkQuality.cpp
*SW-COMPONENT: bmcore
*DESCRIPTION:  TestModeLinkQuality Property
*COPYRIGHT:    (c) 2015 Robert Bosch Car Multimedia GmbH
****************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/TestModeLinkQuality.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "FunctionTracer.h"
#include "TestModeLinkQuality.h"

namespace bmcore
{
   TestModeLinkQuality::TestModeLinkQuality() : _linkQualityInfo()
   {
      ENTRY_INTERNAL
   }

   TestModeLinkQuality::TestModeLinkQuality(IN const LinkQualityInfo linkQualityInfo) : _linkQualityInfo(linkQualityInfo)
   {
      ENTRY_INTERNAL
   }

   TestModeLinkQuality::TestModeLinkQuality(const TestModeLinkQuality& other): _linkQualityInfo(other._linkQualityInfo)
   {
      ENTRY_INTERNAL
   }

   TestModeLinkQuality::~TestModeLinkQuality()
   {
      ENTRY_INTERNAL
   }

   void swap(TestModeLinkQuality& first, TestModeLinkQuality& second)
   {
      using std::swap;

      swap(first._linkQualityInfo, second._linkQualityInfo);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   TestModeLinkQuality& TestModeLinkQuality::operator=(TestModeLinkQuality other)
   {
      swap(*this, other);

      return *this;
   }

   bool TestModeLinkQuality::operator==(const TestModeLinkQuality& rhs) const
   {
      return ((this->_linkQualityInfo == rhs._linkQualityInfo));
   }

   bool TestModeLinkQuality::operator!=(const TestModeLinkQuality& rhs) const
   {
      return (!(this->_linkQualityInfo == rhs._linkQualityInfo));
   }
}
