#ifndef _SWITCH_STATUS_H_
#define _SWITCH_STATUS_H_

#include "BmInterfaceTypesInternal.h"

namespace bmcore
{
   class SwitchStatus 
   {
   public:

      SwitchStatus();

      SwitchStatus(const SwitchState& switchState, const SwitchedOffReason& switchedOffReason);

      SwitchStatus(const SwitchStatus& other);

      virtual ~SwitchStatus();

      friend void swap(SwitchStatus& first, SwitchStatus& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      SwitchStatus& operator=(SwitchStatus other);

      bool operator==(const SwitchStatus& rhs) const;

      bool operator!=(const SwitchStatus& rhs) const;

      SwitchState       _switchState;
      SwitchedOffReason _switchedOffReason;

   private:

   };
} // namespace bmcore

#endif /* _SWITCH_STATUS_H_ */
