/****************************************************************************
*FILE:         ResetToDefaultStatus.cpp
*SW-COMPONENT: bmcore
*DESCRIPTION:  ResetToDefaultStatus Property
*COPYRIGHT:    (c) 2015 Robert Bosch Car Multimedia GmbH
****************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/ResetToDefaultStatus.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "FunctionTracer.h"
#include "ResetToDefaultStatus.h"

namespace bmcore
{
   ResetToDefaultStatus::ResetToDefaultStatus() :
         _resetState(BM_RESET_STATE_IDLE),
         _resetResult(BM_RESET_RESULT_OK)
   {
      ENTRY_INTERNAL
   }

   ResetToDefaultStatus::ResetToDefaultStatus(IN const ResetToDefaultState resetState,
                        IN const ResetToDefaultResult resetResult) :
                        _resetState(resetState),
                        _resetResult(resetResult)
   {
      ENTRY_INTERNAL
   }

   ResetToDefaultStatus::ResetToDefaultStatus(const ResetToDefaultStatus& other):
                        _resetState(other._resetState),
                        _resetResult(other._resetResult)
   {
      ENTRY_INTERNAL
   }

   ResetToDefaultStatus::~ResetToDefaultStatus()
   {
      ENTRY_INTERNAL
   }

   void swap(ResetToDefaultStatus& first, ResetToDefaultStatus& second)
   {
      using std::swap;

      swap(first._resetState, second._resetState);
      swap(first._resetResult, second._resetResult);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   ResetToDefaultStatus& ResetToDefaultStatus::operator=(ResetToDefaultStatus other)
   {
      swap(*this, other);

      return *this;
   }

   bool ResetToDefaultStatus::operator==(const ResetToDefaultStatus& rhs) const
   {
	   return ((this->_resetState == rhs._resetState)
			   && (this->_resetResult == rhs._resetResult));
   }

   bool ResetToDefaultStatus::operator!=(const ResetToDefaultStatus& rhs) const
   {
	   return ((this->_resetState == rhs._resetState)
			   && (this->_resetResult == rhs._resetResult));
   }
}
