
/**
 * @headerfile RemoteDeviceInfo.h
 * @brief This class implements Remote device Info
 * @date  Jul 20, 2015
 * @author tnh5cob -Tharani
 */

#ifndef _REMOTE_DEVICE_INFO_H_
#define _REMOTE_DEVICE_INFO_H_

#include "BmInterfaceTypesInternal.h"
#include "DeviceBaseInfo.h"
#include "ProtocolConnectionInfo.h"

namespace bmcore
{
   class RemoteDeviceInfo 
   {
   public:

      RemoteDeviceInfo();

      RemoteDeviceInfo(const DeviceBaseInfo& deviceBaseInfo, const LinkKey& linkKey, const ProtocolConnectionInfoMap& protocolConnectionInfo,
                       const SppConnectionInfoMap& sppConnectionInfo);

      RemoteDeviceInfo(const RemoteDeviceInfo& other);

      ~RemoteDeviceInfo();

      friend void swap(RemoteDeviceInfo& first, RemoteDeviceInfo& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      RemoteDeviceInfo& operator=(RemoteDeviceInfo other);

      bool operator==(const RemoteDeviceInfo& rhs) const;

      bool operator!=(const RemoteDeviceInfo& rhs) const;

      DeviceBaseInfo            _deviceBaseInfo;
      LinkKey                   _linkKey;
      ProtocolConnectionInfoMap _protocolConnectionInfo;
      SppConnectionInfoMap      _sppConnectionInfo;

   private:

   };

} // namespace bmcore

#endif /* _REMOTE_DEVICE_INFO_H_ */
