#ifndef _PROTOCOL_INFO_H_
#define _PROTOCOL_INFO_H_

#include "BmInterfaceTypesInternal.h"
#include <map>

namespace bmcore
{
   class ProtocolInfo
   {
   public:
      ProtocolInfo();

      ProtocolInfo(IN const ProtocolName& name, IN const ProtocolVersion version, IN const bool isSupported,
            IN const FavoriteIndex favoriteIndex);

      ProtocolInfo(const ProtocolInfo& other);

      virtual ~ProtocolInfo();

      friend void swap(ProtocolInfo& first, ProtocolInfo& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      ProtocolInfo& operator=(ProtocolInfo other);

      bool operator==(const ProtocolInfo& rhs) const;

      ProtocolName _name;
      ProtocolVersion _version;
      bool _isSupported;
      FavoriteIndex _favoriteIndex;
   };

   typedef std::map<ProtocolId, ProtocolInfo> ProtocolInfoMap;
}

#endif // _PROTOCOL_INFO_H_
